+/**
 *
 * CanvasXpress 40.0 - JavaScript Canvas Library
 *
 * Copyright (c) 2009-2022 - license@canvasxpress.org
 *
 * Redistributions of the source code must retain this copyright
 * notice and the following disclaimer.
 *
 * CanvasXpress is released as open source for personal and
 * educational use with dual licensing for commercial purposes.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please see a copy of the CanvasXpress License at
 * https://www.canvasxpress.org/docs/license.html.
 *
 * Dual licensing:
 * Commercial use may be granted to the extent that this source
 * code does NOT become part of any other Open Source or
 * Commercially licensed development library or toolkit without
 * explicit permission from CanvasXpress.
 *
 */
/**
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
+(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{if(typeof define==="function"&&define.amd){define(["exports"],a)}else{(a((b.CanvasXpress=b.CanvasXpress||{})))}}}(this,(function(b){var c,a;if(this){c=this.window;a=this.document}CanvasXpress=function(j,f,e,o,d,k,g,n,m,i){var h=this;var l=function(){h.init(j,f,e,o,d,k,g,n,m,i)};if((e&&e.fonts)||(j&&j.config&&j.config.fonts)){if(e&&e.fonts){CanvasXpress.loadFonts(e.fonts,l)}else{CanvasXpress.loadFonts(j.config.fonts,l)}}else{if((e&&e.fontsExternal)||(j&&j.config&&j.config.fontsExternal)){if(e&&e.fontsExternal){CanvasXpress.loadFontsExternal(e.fontsExternal,l)}else{CanvasXpress.loadFontsExternal(j.config.fontsExternal,l)}}else{this.init(j,f,e,o,d,k,g,n,m,i)}}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{if(typeof define==="function"&&define.amd){define(["exports"],a)}else{(a((b.cxplot=b.cxplot||{})))}}}(this,(function(){cxplot=function(h,b,j,m){if(typeof(h)=="object"&&h.isGGPlot){var n=function(f){if(Array.isArray(f)&&!f.length){return{}}else{return f}};delete (h.isGGPlot);var k=Array.isArray(h.geoms)?h.geoms:[h.geoms];var l=new cxplot(h.renderTo,h.data,aes(h.aes));for(var c=0;c<k.length;c++){var d=k[c];var e=d.toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l");if(l[e]){l[e](n(h.layers[d]))}}l.gg_labels(n(h.labels));l.gg_scales(n(h.scales));l.gg_theme(n(h.theme));l.gg_facet(n(h.facet));return l}else{var a={aes:(j||{}),remoteTransitionEffect:"none",theme:"GGPlot",widthFactor:2,isCxplot:true};return new CanvasXpress(h,b,a,m)}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{if(typeof define==="function"&&define.amd){define(["exports"],a)}else{(a((b.aes=b.aes||{})))}}}(this,(function(){aes=function(){var a=arguments;var e={};var d=["x","y","z","fill","color","shape","size"];for(var b=0;b<a.length;b++){if(Array.isArray(a[b])&&Array.isArray(a[b][0])){e.data=a[b]}else{if(a[b] instanceof Object){for(var c in a[b]){e[c]=a[b][c];if(c=="factor"){if(!e.stringSampleFactors){e.stringSampleFactors=[]}if(!e.stringVariableFactors){e.stringVariableFactors=[]}if(!e.asSampleFactors){e.asSampleFactors=[]}if(!e.asVariableFactors){e.asVariableFactors=[]}e.stringSampleFactors.push(a[b][c]);e.stringVariableFactors.push(a[b][c]);e.asSampleFactors.push(a[b][c]);e.asVariableFactors.push(a[b][c]);if(a.length>1){if(b==0){e.x=a[b][c]}else{if(b==1){e.y=a[b][c]}else{if(b==2){e.z=a[b][c]}}}}}else{if(d.includes(c)){if(a[b][c] instanceof Object&&a[b][c].factor){if(!e.stringSampleFactors){e.stringSampleFactors=[]}if(!e.stringVariableFactors){e.stringVariableFactors=[]}if(!e.asSampleFactors){e.asSampleFactors=[]}if(!e.asVariableFactors){e.asVariableFactors=[]}e.stringSampleFactors.push(a[b][c].factor);e.stringVariableFactors.push(a[b][c].factor);e.asSampleFactors.push(a[b][c].factor);e.asVariableFactors.push(a[b][c].factor);e[c]=a[b][c].factor}}else{if(c=="sample"){e.x=a[b][c]}}}}}else{if(b==0){e.x=a[b]}else{if(b==1){e.y=a[b]}else{if(b==2){e.z=a[b]}}}e[a[b]]=a[b]}}}return e}})));CanvasXpress.instances=[];CanvasXpress.config=[];CanvasXpress.transitions={};CanvasXpress.cacheImages={};CanvasXpress.cacheImagesReady=false;CanvasXpress.cachePatterns={};CanvasXpress.cacheText={};CanvasXpress.tabPanels={};CanvasXpress.fonts={Arial:true,Courier:true,Verdana:true};CanvasXpress.loadFonts=function(d,c){if(d&&d.length){var b=false;for(var a=0;a<d.length;a++){if(!CanvasXpress.fonts.hasOwnProperty(d[a])){b=true;break}}WebFontConfig={google:{families:d},timeout:2000};if(c){WebFontConfig.active=c}(function(h){if(window.navigator.onLine&&b){var e=h.createElement("script");var g=h.scripts[0];e.src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js";e.async=true;g.parentNode.insertBefore(e,g);for(var f=0;f<d.length;f++){CanvasXpress.fonts[d[f]]=true}}else{c()}})(document)}};CanvasXpress.loadFontsExternal=function(c,b){if(c&&c.length){var a=false;if(!CanvasXpress.fonts.hasOwnProperty(c[0].name)){a=true}(function(f){if(window.navigator.onLine&&a){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){var d=new FontFace(c[0].name,e.response);document.fonts.add(d);CanvasXpress.fonts[c[0].name]=true;b()}}}});e.responseType="arraybuffer";e.open("get",c[0].url);e.send()}else{b()}})(document)}};CanvasXpress.selector={vars:{},smps:{},meta:{},comp:{},nodes:{},edges:{},mixed:{},selections:0,groups:{},graphType:false};CanvasXpress.hidden={hiddenVars:{},hiddenSmps:{},hiddenGrps:{},hiddenMapFeatures:{}};CanvasXpress.stack={};CanvasXpress.current=false;CanvasXpress.chain={};CanvasXpress.resizing=false;CanvasXpress.registered="D27201A3F281661AA3F679F03C4912241D723E68F";CanvasXpress.system={};CanvasXpress.ready=false;CanvasXpress.factory={version:40,buildDate:"08-30-2022",client:"",siteSrc:false,valid:typeof window.cX=="string"?window.cX:undefined,href:window.location.href};CanvasXpress.factory.services="https://www.canvasxpress.org/cgi-bin/services.pl";CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){console.log("canvasXpress JS ready");a=true;for(var g=0;g<f.length;g++){f[g].fn.call(window,f[g].ctx)}f=[]}};var b=function(){if(window.document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(window.document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(window.document.addEventListener){window.document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{window.document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}};return true}();CanvasXpress.loadScripts=function(){var i=0;return function(files,callback,scope){var head=window.document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;loadScript(files[i-1],count)}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var e=window.document.getElementsByTagName("canvas");for(var d=0;d<e.length;d++){var g=e[d];if(g.className=="CanvasXpress"&&g.id){var f=false;var a={};var b=CanvasXpress.getObject(g.id);if(g.hasAttribute("data-src")&&!b){f=g.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(g,a,true);if(Object.keys(a).length){new CanvasXpress(g.id,f,a)}else{new CanvasXpress(g.id,f)}}}}};CanvasXpress.initImage=function(){var a=window.document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.className=="CanvasXpress"&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=window.document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=window.document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.className=="CanvasXpress"&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=window.document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress({data:f,renderTo:f})}}}};CanvasXpress.getObject=function(f,b){if(f){while(CanvasXpress.chain.hasOwnProperty(f)){f=CanvasXpress.chain[f]}for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==f){return CanvasXpress.instances[a]}}}else{if(b){var d=window.document.getElementById(f);if(!d){var e=window.document.createElement("canvas");e.id=f;e.width=100;e.height=100;window.document.body.appendChild(e);d=new CanvasXpress({renderTo:f,hidden:true})}return d}else{if(CanvasXpress.instances.length){return CanvasXpress.instances[0]}}}};CanvasXpress.json=function(b,c){var a=new FileReader();a.onload=function(){try{c(JSON.parse(a.result))}catch(d){alert("Oooops! Not a valid callback")}};a.readAsText(b)};CanvasXpress.csv=function(b,c){var a=new FileReader();a.onload=function(){try{var o=JSON.parse(a.result);var d=/\r\n|\r|\n/g;var h=o.split(d);var j=0;var n=0;if(o.match(/,/g)){j=o.match(/,/g).length}if(o.match(/\t/g)){n=o.match(/\t/g).length}var g=j>n?",":"\t";for(var k=0;k<h.length;k++){if(h[k].match(/^#/)){h.splice(k,1);k--;continue}var l=h[k].split(g);for(var p=l.length-1;p>=0;p--){if(l[p].replace(/"\s+$/,'"').charAt(l[p].length-1)=='"'){var q=l[p].replace(/^\s+"/,'"');if(q.length>1&&q.charAt(0)=='"'){l[p]=l[p].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(p){l.splice(p-1,2,[l[p-1],l[p]].join(g))}else{l=l.shift().split(g).concat(l)}}}else{l[p].replace(/""/g,'"')}}if(l.length==1&&l[0]==""){h.splice(k,1);k--;continue}h[k]=l}c(h)}catch(m){alert("Oooops! Not a valid callback")}};a.readAsText(b)};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(b,a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(b,a)}};CanvasXpress.prototype.init=function(g,d,b,k,a,h,e,j,i,f){this.setInit=function(){this.target=g;this.events=k;this.info=a;this.userId=1;this.url={};this.meta={ids:{},time:{start:new Date().getTime(),elapsed:null,end:null,draw:[],render:[]},data:false,canvas:{},config:{user:b,orig:{},vals:{},remote:false},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},events:{},state:{save:0,clip:false,translate:[0,0],rotate:[0],scale:[1,1],last:{translate:[0,0],rotate:[0],scale:[1,1]}},stack:[],def:{},dom:{}};this.config={};this.legend={color:{},shape:{},size:{},sample:{},variable:{},line:{},pattern:{},outline:{},connect:{},contour:{},bin2d:{},decoration:{},oncoprint:{},overlays:{},colorNode:{},shapeNode:{},sizeNode:{},patternNode:{},colorEdge:{},sizeEdge:{}};this.scales={};this.panel={};this.plot={}};this.validateParameters=function(l){this.validateData(l);this.validateConfig(l);this.validateEvents(l);this.validateInfo(l);this.validateAfterRender(l)};this.validateData=function(p){this.dataURL=false;this.dataString=false;if(typeof(p.data)=="string"){var n=window.document.getElementById(p.data);if(n&&n.tagName.toLowerCase()=="table"&&n.className=="CanvasXpress"&&n.id){var q=p.data;p.data=this.parseHTMLTable(n,true);p.config=p.data.config;p.data=p.data.data;n.parentNode.removeChild(n);var l=window.document.getElementById("temp-table-id-"+q);if(l){l.id=q}else{alert("Dude! What did you do?")}}else{var n=this.isValidString(p.data);switch(n.type){case"URL":this.dataURL=p.data;p.data=false;break;case"XML":this.dataString=n.data;p.data=false;break;case"JSON":p.data=n.data;break;case"DELIM":p.data=n.data.data;if(!p.config){p.config=n.data.config}break;default:alert("Not a valid data string\n");break}}}else{if(typeof(p.data)=="function"){try{p.data=d.call(this)}catch(m){alert("Not a valid Data object:\n"+m)}}else{if(!f){try{this.stringifyJSON(p.data)}catch(m){alert("Data object malformed:\n"+m)}}}}};this.validateConfig=function(n){if(n.config){if(typeof(n.config)=="function"){try{n.config=n.config.call(this)}catch(m){alert("Not a valid Data object:\n"+m)}}else{if(!n.noValidate){try{this.stringifyJSON(n.config)}catch(m){alert("Config object malformed:\n"+m)}}}this.topoJSONURL=false;if(n.config.topoJSON&&typeof(n.config.topoJSON)=="string"){var l=this.isValidString(n.config.topoJSON);switch(l.type){case"URL":this.topoJSONURL=n.config.topoJSON;break}}}};this.validateEvents=function(l){};this.validateInfo=function(l){if(!l.info){l.info=""}};this.validateAfterRender=function(m){if(m.afterRender){try{this.stringifyJSON(m.afterRender)}catch(l){alert("AfterRender object malformed:\n"+l)}}};this.isOneTimeFunctionInConfig=function(l){if(!l){l=this}if(l.transposeData){return true}if(l.transformData){return true}if(l.asSampleFactors&&l.asSampleFactors.length){return true}if(l.asVariableFactors&&l.asVariableFactors.length){return true}if(l.stringSampleFactors&&l.stringSampleFactors.length){return true}if(l.stringVariableFactors&&l.stringVariableFactors.length){return true}if(l.histogramData){return true}if(l.ridgeBy){return true}if(l.sortData&&l.sortData.length){return true}if(l.asDOE){}return false};this.getAfterRender=function(l){var n=[];if(l.histogramData||l.ridgeBy){if(l.histogramData===true&&l.colorBy){n.unshift(["createHistogram",[],{}])}else{n.unshift(["createHistogram",[l.ridgeBy||l.histogramData||l.colorBy],{}])}}if(l.stringVariableFactors&&l.stringVariableFactors.length){for(var m=0;m<l.stringVariableFactors.length;m++){n.unshift(["switchNumericToString",[l.stringVariableFactors[m]],{}])}}if(l.stringSampleFactors&&l.stringSampleFactors.length){for(var m=0;m<l.stringSampleFactors.length;m++){n.unshift(["switchNumericToString",[l.stringSampleFactors[m],true],{}])}}if(l.asVariableFactors&&l.asVariableFactors.length){for(var m=0;m<l.asVariableFactors.length;m++){n.unshift(["switchVarToAnnotation",[l.asVariableFactors[m]],{}])}}if(l.asSampleFactors&&l.asSampleFactors.length){for(var m=0;m<l.asSampleFactors.length;m++){n.unshift(["switchSmpToAnnotation",[l.asSampleFactors[m]],{}])}}if(l.transposeData){n.unshift(["transpose",[false,true],{}])}if(l.transformData){n.unshift(["transform",[l.transformData,l.transformAxis,false,true],{}])}if(l.sortData&&l.sortData.length){for(var m=0;m<l.sortData.length;m++){n.push(["modifySort",[l.sortData[m][0],l.sortData[m][1],l.sortData[m][2],false,m==this.sortData.length-1?true:false],{}])}}if(l.asDOE){n.push(["createDOE",[],{}])}return n};this.applyAfterRender=function(){if(this.isCxplot&&this.meta.config.user.aes){var l=this.meta.config.user.aes;if(l.stringVariableFactors){this.stringVariableFactors=this.cloneObject(l.stringVariableFactors)}if(l.stringSampleFactors){this.stringSampleFactors=this.cloneObject(l.stringSampleFactors)}if(l.asVariableFactors){this.asVariableFactors=this.cloneObject(this.asVariableFactors)}if(l.asSampleFactors){this.asSampleFactors=this.cloneObject(l.asSampleFactors)}}};this.afterRender=function(z){this.afterRendering=true;if(!z){z=[]}var D=this.meta.time.start;var A=this.graphType=="Scatter2D"&&this.scatterType=="visium";this.applyAfterRender();if(this.histogramData||this.ridgeBy){if(this.histogramData===true){z.push(["createHistogram",[],{},D,true])}else{z.push(["createHistogram",[this.ridgeBy||this.histogramData],{},D,true])}this.histogramData=false;delete (CanvasXpress.stack[this.target].config.histogramData)}if(this.stringVariableFactors.length){for(var q=0;q<this.stringVariableFactors.length;q++){z.unshift(["switchNumericToString",[this.stringVariableFactors[q],false],{},D,true])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var q=0;q<this.stringSampleFactors.length;q++){z.unshift(["switchNumericToString",[this.stringSampleFactors[q],true],{},D,true])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var q=0;q<this.asVariableFactors.length;q++){z.unshift(["switchVarToAnnotation",[this.asVariableFactors[q],false],{},D,true])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var q=0;q<this.asSampleFactors.length;q++){z.unshift(["switchSmpToAnnotation",[this.asSampleFactors[q],false],{},D,true])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){z.unshift(["transpose",[false,this.sortData.length||this.selectedDataPoints.length],{},D,true]);this.transposeData=false;delete (CanvasXpress.stack[this.target].config.transposeData)}if(this.sortData){for(var q=0;q<this.sortData.length;q++){z.push(["modifySort",[this.sortData[q][0],this.sortData[q][1],this.sortData[q][2],false,q==this.sortData.length-1?true:false],{},D,true])}this.sortData=[];delete (CanvasXpress.stack[this.target].config.sortData)}if(this.selectedDataPoints.length&&this.xAxisIndices&&this.xAxisIndices.length&&this.yAxisIndices&&this.yAxisIndices.length){var y=false;for(var q=0;q<this.selectedDataPoints.length;q++){var p=this.getVariableIndices(this.selectedDataPoints[q]);if(p>=0){this.addRemoveToSelected([p,this.xAxisIndices[0],this.yAxisIndices[0]]);y=true}}if(y){z.unshift(["broadcastDraw",[{func:"afterRender"}],{},D,true])}}var s=z.length-1;var m=false;for(var q=0;q<z.length;q++){var o=z[q];var w=o.shift();if(w){var l=o.length>0?o.shift():[];var x=o.length>0?o.shift():{};var C=o.length>0?o.shift():D;var r=o.length>0?o.shift():false;if(this.showFunctionNamesAfterRender){this.flashInfoSpan(20,20,w)}var n=z[q+1]&&z[q+1][0]&&z[q+1][0].match(/drag/i)?true:false;this.skipRender=w=="createDOE"||w=="createHistogram"||w=="modifyColorScheme"||w.match(/segregate/)||n?false:!this.showTransition&&q<s?true:this.view=="table"?false:false;this.skipRender=w.match(/switch/)&&q<s?true:false;for(var u in x){this[u]=x[u]}if(w.match(/switch/)&&A&&q==s){m=true}this[w].apply(this,l);if(w.match(/switch/)&&q==s&&!m){this.draw()}if(w=="moveCanvas"){CanvasXpress.stack[this.target].afterRender.push([w,l])}if(r){var B=CanvasXpress.stack[this.target].afterRender.length-1;CanvasXpress.stack[this.target].afterRender[B][4]=true}if(m){this.masterReset()}}}if(this.asDOE&&this.isDOEable()){this.createDOE(this.asDOE)}if(this.view=="table"){this.view="canvas";this.clickView()}else{if(this.view=="layout"){this.view="canvas";this.clickLayout(false,false,"none")}}this.triggerDataLoaded("afterRender");this.afterRendering=false};this.setURL=function(){if(window.location.search!=""){var n=location.search.substring(1).split("&");for(var m=0;m<n.length;m++){var l=n[m].split("=");if(!l[0]){continue}if(l[0].match(/^cX/)){this.url[l[0]]=l[1]||true}else{this.url[l[0]]=l[1]=="false"?false:l[1]=="true"?true:l[1]}}}};this.createThumbnailBase64=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var m=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var l=this;var n=function(o,p){l.saveAs(o,p);setTimeout(function(){window.close()},4000)};l.print(false,m,n)}else{if(this.url.hasOwnProperty("cXprintBase64")||this.cacheBase64){this.cacheBase64=false;var n=function(){return};if(CanvasXpress.$(this.target)){this.print(false,false,n)}}}};this.logConsole=function(l){if(this.verbose){console.log(this.target,this.prettyJSON(l))}};this.triggerDataLoaded=function(o,m){var n=this;var l=function(){var p=m||n;p.logConsole("canvasXpress data ready - "+o);p.createThumbnailBase64();CanvasXpress.ready=true};if(CanvasXpress.cacheImagesReady){if(o=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.dataURL&&!this.dataString&&!i&&!this.isUpdateRemoteData&&!e){l()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){l()}}else{if(!this.isTransitionOn){l()}}}}};this.saveFirstState=function(){CanvasXpress.stack[this.target].state.push(this.getConfigState())};this.continueInitialization=function(){var l=CanvasXpress.stack[this.target];var m=this.isOneTimeFunctionInConfig();this.initializeGraph(false,false,false,false,false,false,m);if(!this.dataURL){this.afterRender(l.afterRenderInit)}this.getDataFromURLOrString(this.target,l.config,l.events,l.info,j);this.saveFirstState();CanvasXpress.current=this.target;this.meta.time.end=new Date().getTime();this.meta.time.elapsed=this.meta.time.end-this.meta.time.start;this.hideMask()};this.pauseInitialization=function(){if(!this.lazyLoad||(!this.loaded&&this.isInViewport(this.meta.canvas.ctx.canvas))){this.continueInitialization()}};this.initializeProcessing=function(m){var l=this;l.initializeBrowser();l.initializeConfig(m.config);l.initializeViewport(m.hidden);l.validateUserColors();l.initializeApi();l.initializeDimensions();l.initializeData(m.data);l.initializeLayout();l.initializeDataFilters();l.initializeEvents();l.initializeRemote();l.initStack(m.data,m.config,m.events,m.info,m.afterRender);l.initTransitions();l.pauseInitialization()};this.initialize=function(l){CanvasXpress.instances.push(this);this.setInit();this.setURL();this.initDOM();this.initSVG();this.initInterface();this.initSave();this.validateParameters(l);this.initConfig();this.initDate();this.initViewport();this.initPrimitives();this.initUtils();this.initNumeric();this.initjLouvain();this.initMathUtils();this.initLegendUtils();this.initMarkerUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initExample();this.initDataUtils();this.initRandom();this.initData();this.initValidity();this.initLayout();this.initEvents();this.initTooltip();this.initTooltipMouse();this.initTooltipDiv();this.initToolbar();this.initTabpanel();this.initMenus();this.initLinks();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initCustomizer();this.initAnimation();this.initRemote();this.initAxes();this.initGraph();this.initCxplot();this.initializeProcessing(l)};if(!g){return}else{if(typeof(g)=="object"&&g.renderTo){if(g.isGGPlot){return new cxplot(g)}d=g.tracks?{tracks:g.tracks}:g.nodes?{nodes:g.nodes}:g.venn?{venn:g.venn}:g.data?g.data:false;b=g.config||false;if(g.version){b.createVersion=g.version}if(g.factory){b.createFactory=g.factory}k=g.events||false;a=g.info?g.info.replace(/'/g,"'").replace(/"/g,"'"):false;h=g.afterRender||false;e=g.hidden||false;j=g.callback||false;i=g.uploadFile||false;f=g.noValidate?g.noValidate:b&&b.noValidate?b.noValidate:false;g=g.renderTo}}var c={target:g,data:d,config:b,events:k,info:a,afterRender:h,hidden:e,callback:j,uploadFile:i,noValidate:f};this.initialize(c)};CanvasXpress.png="data:image/png;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.dates={Sun:1,Mon:2,Tue:3,Wed:4,Thu:5,Fri:6,Sat:7,Sunday:1,Monday:2,Tuesday:3,Wednesday:4,Thursday:5,Friday:6,Saturday:7,Jan:"01",Feb:"02",Mar:"03",Apr:"04",May:"05",Jun:"06",Jul:"07",Aug:"08",Sep:"09",Oct:"10",Nov:"11",Dec:"12",January:"01",February:"02",March:"03",April:"04",May:"05",June:"06",July:"07",August:"08",September:"09",October:"10",November:"11",December:"12"};CanvasXpress.constants={DBL_EPSILON:2.220446049250313e-16};CanvasXpress.countries={AFG:["Afghanistan","Asia","South Asia","AF",33.939,67.709],ALA:["Aland Islands","Europe","North Europe","AX",48.464,-122.706],ALB:["Albania","Europe","South Europe","AL",41.153,20.168],DZA:["Algeria","Africa","North Africa","DZ",28.033,1.659],ASM:["American Samoa","Oceania","Polynesia","AS",-14.271,-170.133],AND:["Andorra","Europe","South Europe","AD",42.546,1.601],AGO:["Angola","Africa","Middle Africa","AO",-11.203,17.873],AIA:["Anguilla","America","Caribbean","AI",18.22,-63.069],ATA:["Antarctica","","","AQ",-75.251,-0.072],ATG:["Antigua and Barbuda","America","Caribbean","AG",17.06,-61.797],ARG:["Argentina","America","South America","AR",-38.417,-63.617],ARM:["Armenia","Asia","West Asia","AM",40.069,45.038],ABW:["Aruba","America","Caribbean","AW",12.521,-69.969],AUS:["Australia","Oceania","Australia and New Zealand","AU",-25.275,133.775],AUT:["Austria","Europe","West Europe","AT",47.516,14.55],AZE:["Azerbaijan","Asia","West Asia","AZ",40.143,47.576],BHS:["Bahamas","America","Caribbean","BS",25.034,-77.397],BHR:["Bahrain","Asia","West Asia","BH",25.93,50.637],BGD:["Bangladesh","Asia","South Asia","BD",23.684,90.356],BRB:["Barbados","America","Caribbean","BB",13.193,-59.544],BLR:["Belarus","Europe","East Europe","BY",53.709,27.953],BEL:["Belgium","Europe","West Europe","BE",50.503,4.469],BLZ:["Belize","America","Central America","BZ",17.189,-88.498],BEN:["Benin","Africa","West Africa","BJ",9.307,2.315],BMU:["Bermuda","America","North America","BM",32.321,-64.758],BTN:["Bhutan","Asia","South Asia","BT",27.514,90.433],BOL:["Bolivia","America","South America","BO",-16.291,-63.589],BES:["Bonaire","America","Caribbean","BQ",12.201,-68.262],BIH:["Bosnia and Herzegovina","Europe","South Europe","BA",43.915,17.679],BWA:["Botswana","Africa","South Africa","BW",-22.329,24.684],BVT:["Bouvet Island","","","BV",-54.424,3.413],BRA:["Brazil","America","South America","BR",-14.236,-51.926],IOT:["British Indian Ocean Territory","","","IO",-6.344,71.876],BRN:["Brunei Darussalam","Asia","South-East Asia","BN",4.535,114.727],BGR:["Bulgaria","Europe","East Europe","BG",42.733,25.485],BFA:["Burkina Faso","Africa","West Africa","BF",12.238,-1.562],BDI:["Burundi","Africa","East Africa","BI",-3.374,29.918],KHM:["Cambodia","Asia","South-East Asia","KH",12.565,104.99],CMR:["Cameroon","Africa","Middle Africa","CM",7.369,12.354],CAN:["Canada","America","North America","CA",56.13,-106.347],CPV:["Cabo Verde","Africa","West Africa","CV",16.002,-24.014],CYM:["Cayman Islands","America","Caribbean","KY",19.513,-80.567],CAF:["Central African Republic","Africa","Middle Africa","CF",6.611,20.939],TCD:["Chad","Africa","Middle Africa","TD",15.454,18.732],CHL:["Chile","America","South America","CL",-35.676,-71.543],CHN:["China","Asia","East Asia","CN",35.861,104.195],CXR:["Christmas Island","","","CX",-10.448,105.69],CCK:["Cocos (Keeling) Islands","","","CC",-12.165,96.87],COL:["Colombia","America","South America","CO",4.57,-74.298],COM:["Comoros","Africa","East Africa","KM",-11.876,43.872],COG:["Congo","Africa","Middle Africa","CG",-0.229,15.827],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa","CD",-4.039,21.758],COK:["Cook Islands","Oceania","Polynesia","CK",-21.237,-159.778],CRI:["Costa Rica","America","Central America","CR",9.748,-83.754],CIV:["Cote d'Ivoire","Africa","West Africa","CI",7.539,-5.548],HRV:["Croatia","Europe","South Europe","HR",45.1,15.2],CUB:["Cuba","America","Caribbean","CU",21.521,-77.782],CUW:["Cura�ao","America","Caribbean","CW",12.169,-68.99],CYP:["Cyprus","Asia","West Asia","CY",35.126,33.429],CZE:["Czech Republic","Europe","East Europe","CZ",49.817,15.472],DNK:["Denmark","Europe","North Europe","DK",56.263,9.501],DJI:["Djibouti","Africa","East Africa","DJ",11.825,42.59],DMA:["Dominica","America","Caribbean","DM",15.414,-61.371],DOM:["Dominican Republic","America","Caribbean","DO",18.735,-70.163],ECU:["Ecuador","America","South America","EC",-1.832,-78.184],EGY:["Egypt","Africa","North Africa","EG",26.82,30.802],SLV:["El Salvador","America","Central America","SV",13.794,-88.897],GNQ:["Equatorial Guinea","Africa","Middle Africa","GQ",1.65,10.267],ERI:["Eritrea","Africa","East Africa","ER",15.179,39.782],EST:["Estonia","Europe","North Europe","EE",58.595,25.013],ETH:["Ethiopia","Africa","East Africa","ET",9.145,40.489],FLK:["Falkland Islands","America","South America","FK",-51.797,-59.524],FRO:["Faroe Islands","Europe","North Europe","FO",61.892,-6.912],FJI:["Fiji","Oceania","Melanesia","FJ",-16.579,179.414],FIN:["Finland","Europe","North Europe","FI",61.924,25.748],FRA:["France","Europe","West Europe","FR",46.227,2.213],GUF:["French Guiana","America","South America","GF",3.933,-53.126],PYF:["French Polynesia","Oceania","Polynesia","PF",-17.68,-149.407],ATF:["French Southern Territories","","","TF",-49.281,69.348],GAB:["Gabon","Africa","Middle Africa","GA",-0.804,11.609],GMB:["Gambia","Africa","West Africa","GM",13.443,-15.311],GEO:["Georgia","Asia","West Asia","GE",42.315,43.356],DEU:["Germany","Europe","West Europe","DE",51.165,10.451],GHA:["Ghana","Africa","West Africa","GH",7.946,-1.024],GIB:["Gibraltar","Europe","South Europe","GI",36.137,-5.346],GRC:["Greece","Europe","South Europe","GR",39.074,21.824],GRE:["Greece","Europe","South Europe","EL",39.074,21.824],GRL:["Greenland","America","North America","GL",71.706,-42.605],GRD:["Grenada","America","Caribbean","GD",12.262,-61.605],GLP:["Guadeloupe","America","Caribbean","GP",16.995,-62.068],GUM:["Guam","Oceania","Micronesia","GU",13.444,144.793],GTM:["Guatemala","America","Central America","GT",15.783,-90.231],GGY:["Guernsey","Europe","North Europe","GG",49.465,-2.586],GIN:["Guinea","Africa","West Africa","GN",9.945,-9.697],GNB:["Guinea-Bissau","Africa","West Africa","GW",11.803,-15.181],GUY:["Guyana","America","South America","GY",4.86,-58.931],HTI:["Haiti","America","Caribbean","HT",18.971,-72.286],HMD:["Heard Island and McDonald Islands","","","HM",-53.082,73.504],VAT:["Holy See","Europe","South Europe","VA",41.902,12.453],HND:["Honduras","America","Central America","HN",15.199,-86.242],HKG:["Hong Kong","Asia","East Asia","HK",22.396,114.109],HUN:["Hungary","Europe","East Europe","HU",47.162,19.503],ISL:["Iceland","Europe","North Europe","IS",64.963,-19.021],IND:["India","Asia","South Asia","IN",20.593,78.962],IDN:["Indonesia","Asia","South-East Asia","ID",-0.79,113.921],IRN:["Iran","Asia","South Asia","IR",32.427,53.688],IRQ:["Iraq","Asia","West Asia","IQ",33.223,43.679],IRL:["Ireland","Europe","North Europe","IE",53.412,-8.244],IMN:["Isle of Man","Europe","North Europe","IM",54.236,-4.549],ISR:["Israel","Asia","West Asia","IL",31.046,34.851],ITA:["Italy","Europe","South Europe","IT",41.871,12.567],JAM:["Jamaica","America","Caribbean","JM",18.109,-77.298],JPN:["Japan","Asia","East Asia","JP",36.204,138.252],JEY:["Jersey","Europe","North Europe","JE",49.214,-2.132],JOR:["Jordan","Asia","West Asia","JO",30.585,36.238],KAZ:["Kazakhstan","Asia","Central Asia","KZ",48.019,66.923],KEN:["Kenya","Africa","East Africa","KE",-0.024,37.906],KIR:["Kiribati","Oceania","Micronesia","KI",-3.371,-168.735],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia","KP",40.339,127.51],KOR:["Korea (Republic of)","Asia","East Asia","KR",35.907,127.766],XKX:["Kosovo","Europe","South Europe","XK",42.602,20.902],KWT:["Kuwait","Asia","West Asia","KW",29.311,47.481],KGZ:["Kyrgyzstan","Asia","Central Asia","KG",41.204,74.766],LAO:["Lao People's Democratic Republic","Asia","South-East Asia","LA",19.856,102.495],LVA:["Latvia","Europe","North Europe","LV",56.879,24.603],LBN:["Lebanon","Asia","West Asia","LB",33.854,35.862],LSO:["Lesotho","Africa","South Africa","LS",-29.61,28.233],LBR:["Liberia","Africa","West Africa","LR",6.428,-9.43],LBY:["Libya","Africa","North Africa","LY",26.335,17.228],LIE:["Liechtenstein","Europe","West Europe","LI",47.166,9.555],LTU:["Lithuania","Europe","North Europe","LT",55.169,23.881],LUX:["Luxembourg","Europe","West Europe","LU",49.815,6.129],MAC:["Macao","Asia","East Asia","MO",22.198,113.543],MKD:["Macedonia","Europe","South Europe","MK",41.608,21.745],MDG:["Madagascar","Africa","East Africa","MG",-18.767,46.869],MWI:["Malawi","Africa","East Africa","MW",-13.255,34.301],MYS:["Malaysia","Asia","South-East Asia","MY",4.21,101.975],MDV:["Maldives","Asia","South Asia","MV",3.202,73.22],MLI:["Mali","Africa","West Africa","ML",17.57,-3.997],MLT:["Malta","Europe","South Europe","MT",35.937,14.375],MHL:["Marshall Islands","Oceania","Micronesia","MH",7.131,171.184],MTQ:["Martinique","America","Caribbean","MQ",14.641,-61.025],MRT:["Mauritania","Africa","West Africa","MR",21.007,-10.941],MUS:["Mauritius","Africa","East Africa","MU",-20.349,57.552],MYT:["Mayotte","Africa","East Africa","YT",-12.828,45.166],MEX:["Mexico","America","Central America","MX",23.634,-102.553],FSM:["Micronesia","Oceania","Micronesia","FM",7.425,150.55],MDA:["Moldova","Europe","East Europe","MD",47.411,28.369],MCO:["Monaco","Europe","West Europe","MC",43.75,7.412],MNG:["Mongolia","Asia","East Asia","MN",46.862,103.846],MNE:["Montenegro","Europe","South Europe","ME",42.708,19.374],MSR:["Montserrat","America","Caribbean","MS",16.742,-62.188],MAR:["Morocco","Africa","North Africa","MA",31.791,-7.093],MOZ:["Mozambique","Africa","East Africa","MZ",-18.666,35.529],MMR:["Myanmar","Asia","South-East Asia","MM",21.913,95.956],NAM:["Namibia","Africa","South Africa","NA",-22.958,18.49],NRU:["Nauru","Oceania","Micronesia","NR",-0.523,166.931],NPL:["Nepal","Asia","South Asia","NP",28.394,84.124],NLD:["Netherlands","Europe","West Europe","NL",52.132,5.291],ANT:["Netherlands Antilles","","","AN",12.226,-69.061],NCL:["New Caledonia","Oceania","Melanesia","NC",-20.905,165.618],NZL:["New Zealand","Oceania","Australia and New Zealand","NZ",-40.901,174.885],NIC:["Nicaragua","America","Central America","NI",12.865,-85.208],NER:["Niger","Africa","West Africa","NE",17.607,8.081],NGA:["Nigeria","Africa","West Africa","NG",9.081,8.675],NIU:["Niue","Oceania","Polynesia","NU",-19.055,-169.868],NFK:["Norfolk Island","Oceania","Australia and New Zealand","NF",-29.041,167.954],MNP:["West Mariana Islands","Oceania","Micronesia","MP",17.33,145.384],NOR:["Norway","Europe","North Europe","NO",60.472,8.468],OMN:["Oman","Asia","West Asia","OM",21.512,55.923],PAK:["Pakistan","Asia","South Asia","PK",30.375,69.345],PLW:["Palau","Oceania","Micronesia","PW",7.514,134.582],PSE:["Palestine","Asia","West Asia","PS",31.952,35.233],PAN:["Panama","America","Central America","PA",8.537,-80.783],PNG:["Papua New Guinea","Oceania","Melanesia","PG",-6.315,143.955],PRY:["Paraguay","America","South America","PY",-23.443,-58.444],PER:["Peru","America","South America","PE",-9.19,-75.016],PHL:["Philippines","Asia","South-East Asia","PH",12.879,121.774],PCN:["Pitcairn","Oceania","Polynesia","PN",-24.704,-127.44],POL:["Poland","Europe","East Europe","PL",51.919,19.145],PRT:["Portugal","Europe","South Europe","PT",39.399,-8.225],PRI:["Puerto Rico","America","Caribbean","PR",18.22,-66.591],QAT:["Qatar","Asia","West Asia","QA",25.354,51.183],REU:["R�union","Africa","East Africa","RE",-21.116,55.536],ROU:["Romania","Europe","East Europe","RO",45.943,24.966],RUS:["Russian Federation","Europe","East Europe","RU",61.524,105.318],RWA:["Rwanda","Africa","East Africa","RW",-1.941,29.873],BLM:["Saint Barthelemy","America","Caribbean","BL",17.899,-62.833],SHN:["Saint Helena","Africa","West Africa","SH",-24.144,-10.031],KNA:["Saint Kitts and Nevis","America","Caribbean","KN",17.357,-62.783],LCA:["Saint Lucia","America","Caribbean","LC",13.909,-60.979],MAF:["Saint Martin","America","Caribbean","MF",18.075,-63.06],SPM:["Saint Pierre and Miquelon","America","North America","PM",46.941,-56.272],VCT:["Saint Vincent and the Grenadines","America","Caribbean","VC",12.984,-61.288],WSM:["Samoa","Oceania","Polynesia","WS",-13.76,-172.105],SMR:["San Marino","Europe","South Europe","SM",43.942,12.457],STP:["Sao Tome and Principe","Africa","Middle Africa","ST",0.186,6.613],SAU:["Saudi Arabia","Asia","West Asia","SA",23.885,45.079],SEN:["Senegal","Africa","West Africa","SN",14.497,-14.453],SRB:["Serbia","Europe","South Europe","RS",44.016,21.005],SYC:["Seychelles","Africa","East Africa","SC",-4.68,55.491],SLE:["Sierra Leone","Africa","West Africa","SL",8.46,-11.78],SGP:["Singapore","Asia","South-East Asia","SG",1.352,103.819],SXM:["Sint Maarten","America","Caribbean","SX",18.042,-63.054],SVK:["Slovakia","Europe","East Europe","SK",48.669,19.699],SVN:["Slovenia","Europe","South Europe","SI",46.151,14.995],SLB:["Solomon Islands","Oceania","Melanesia","SB",-9.646,160.156],SOM:["Somalia","Africa","East Africa","SO",5.152,46.199],ZAF:["South Africa","Africa","South Africa","ZA",-30.56,22.937],SGS:["South Georgia and the South Sandwich Islands","","","GS",-54.43,-36.588],SSD:["South Sudan","Africa","East Africa","SS",4.859,31.571],ESP:["Spain","Europe","South Europe","ES",40.463,-3.75],LKA:["Sri Lanka","Asia","South Asia","LK",7.873,80.771],SDN:["Sudan","Africa","North Africa","SD",12.862,30.217],SUR:["Suriname","America","South America","SR",3.919,-56.028],SJM:["Svalbard and Jan Mayen","Europe","North Europe","SJ",77.553,23.67],SWZ:["Swaziland","Africa","South Africa","SZ",-26.523,31.465],SWE:["Sweden","Europe","North Europe","SE",60.128,18.643],CHE:["Switzerland","Europe","West Europe","CH",46.818,8.227],SYR:["Syrian Arab Republic","Asia","West Asia","SY",34.802,38.996],TWN:["Taiwan","Asia","East Asia","TW",23.697,120.96],TJK:["Tajikistan","Asia","Central Asia","TJ",38.861,71.276],TZA:["Tanzania","Africa","East Africa","TZ",-6.37,34.888],THA:["Thailand","Asia","South-East Asia","TH",15.87,100.992],TLS:["Timor-Leste","Asia","South-East Asia","TL",-8.875,125.727],TGO:["Togo","Africa","West Africa","TG",8.619,0.824],TKL:["Tokelau","Oceania","Polynesia","TK",-8.968,-171.856],TON:["Tonga","Oceania","Polynesia","TO",-21.179,-175.199],TTO:["Trinidad and Tobago","America","Caribbean","TT",10.691,-61.223],TUN:["Tunisia","Africa","North Africa","TN",33.886,9.537],TUR:["Turkey","Asia","West Asia","TR",38.963,35.243],TKM:["Turkmenistan","Asia","Central Asia","TM",38.969,59.556],TCA:["Turks and Caicos Islands","America","Caribbean","TC",21.694,-71.798],TUV:["Tuvalu","Oceania","Polynesia","TV",-7.11,177.649],UGA:["Uganda","Africa","East Africa","UG",1.373,32.29],UKR:["Ukraine","Europe","East Europe","UA",48.379,31.165],ARE:["United Arab Emirates","Asia","West Asia","AE",23.424,53.847],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","GB",55.378,-3.436],UKM:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","UK",55.378,-3.436],USA:["United States of America","America","North America","US",37.09,-95.713],UMI:["United States Minor Outlying Islands","","","UM",-0.374,-159.996],URY:["Uruguay","America","South America","UY",-32.523,-55.766],UZB:["Uzbekistan","Asia","Central Asia","UZ",41.377,64.585],VUT:["Vanuatu","Oceania","Melanesia","VU",-15.377,166.959],VEN:["Venezuela","America","South America","VE",6.423,-66.59],VNM:["Vietnam","Asia","South-East Asia","VN",14.058,108.277],VGB:["Virgin Islands (British)","America","Caribbean","VG",18.42,-64.64],VIR:["Virgin Islands (U.S.)","America","Caribbean","VI",18.335,-64.897],WLF:["Wallis and Futuna","Oceania","Polynesia","WF",-13.769,-177.157],ESH:["Western Sahara","Africa","North Africa","EH",24.215,-12.886],XXX:["Unespecified Nationality","","","XX",],YEM:["Yemen","Asia","West Asia","YE",15.552,48.516],ZMB:["Zambia","Africa","East Africa","ZM",-13.134,27.849],ZWE:["Zimbabwe","Africa","East Africa","ZW",-19.016,29.154]};CanvasXpress.usa={AK:["Alaska",63.588753,-154.493062],AL:["Alabama",32.318231,-86.902298],AR:["Arkansas",35.20105,-91.831833],AZ:["Arizona",34.048928,-111.093731],CA:["California",36.778261,-119.417932],CO:["Colorado",39.550051,-105.782067],CT:["Connecticut",41.603221,-73.087749],DC:["District of Columbia",38.905985,-77.033418],DE:["Delaware",38.910832,-75.52767],FL:["Florida",27.664827,-81.515754],GA:["Georgia",32.157435,-82.907123],HI:["Hawaii",19.898682,-155.665857],IA:["Iowa",41.878003,-93.097702],ID:["Idaho",44.068202,-114.742041],IL:["Illinois",40.633125,-89.398528],IN:["Indiana",40.551217,-85.602364],KS:["Kansas",39.011902,-98.484246],KY:["Kentucky",37.839333,-84.270018],LA:["Louisiana",31.244823,-92.145024],MA:["Massachusetts",42.407211,-71.382437],MD:["Maryland",39.045755,-76.641271],ME:["Maine",45.253783,-69.445469],MI:["Michigan",44.314844,-85.602364],MN:["Minnesota",46.729553,-94.6859],MO:["Missouri",37.964253,-91.831833],MS:["Mississippi",32.354668,-89.398528],MT:["Montana",46.879682,-110.362566],NC:["North Carolina",35.759573,-79.0193],ND:["NorthDakota",47.551493,-101.002012],NE:["Nebraska",41.492537,-99.901813],NH:["New Hampshire",43.193852,-71.572395],NJ:["New Jersey",40.058324,-74.405661],NM:["New Mexico",34.97273,-105.032363],NV:["Nevada",38.80261,-116.419389],NY:["New York",43.299428,-74.217933],OH:["Ohio",40.417287,-82.907123],OK:["Oklahoma",35.007752,-97.092877],OR:["Oregon",43.804133,-120.554201],PA:["Pennsylvania",41.203322,-77.194525],PR:["Puerto Rico",18.220833,-66.590149],RI:["Rhode Island",41.580095,-71.477429],SC:["South Carolina",33.836081,-81.163725],SD:["South Dakota",43.969515,-99.901813],TN:["Tennessee",35.517491,-86.580447],TX:["Texas",31.968599,-99.901813],UT:["Utah",39.32098,-111.093731],VA:["Virginia",37.431573,-78.656894],VT:["Vermont",44.558803,-72.577841],WA:["Washington",47.751074,-120.740139],WI:["Wisconsin",43.78444,-88.787868],WV:["West Virginia",38.597626,-80.454903],WY:["Wyoming",43.075968,-107.290284]};CanvasXpress.maps={Africa:"/data/africa.geo.json",Argentina:"/data/argentina.geo.json",Asia:"/data/asia.geo.json",Belgium:"/data/belgium.geo.json",China:"/data/china.geo.json",Colombia:"/data/colombia.geo.json",Countries:"/data/countries.geo.json",Europe:"/data/europe.geo.json",France:"/data/france.geo.json",India:"/data/india.geo.json",Italy:"/data/italy.geo.json",NorthAmerica:"/data/north-america.geo.json",Oceania:"/data/oceania.geo.json",SouthAmerica:"/data/south-america.geo.json",Spain:"/data/spain.geo.json",UnitedKingdom:"/data/united-kindom.geo.json",USA:"/data/USA.geo.json",USACounties:"/data/usa-counties.json",USADistricts:"/data/usa-districts.json",USAStates:"/data/usa-states.json",WorldContinents:"/data/world-continents-geo.json",World:"/data/world.geo.json"};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5400000,"p36.32","gpos25"],[5400000,7200000,"p36.31","gneg"],[7200000,9200000,"p36.23","gpos25"],[9200000,12700000,"p36.22","gneg"],[12700000,16200000,"p36.21","gpos50"],[16200000,20400000,"p36.13","gneg"],[20400000,23900000,"p36.12","gpos25"],[23900000,28000000,"p36.11","gneg"],[28000000,30200000,"p35.3","gpos25"],[30200000,32400000,"p35.2","gneg"],[32400000,34600000,"p35.1","gpos25"],[34600000,40100000,"p34.3","gneg"],[40100000,44100000,"p34.2","gpos25"],[44100000,46800000,"p34.1","gneg"],[46800000,50700000,"p33","gpos75"],[50700000,56100000,"p32.3","gneg"],[56100000,59000000,"p32.2","gpos50"],[59000000,61300000,"p32.1","gneg"],[61300000,68900000,"p31.3","gpos50"],[68900000,69700000,"p31.2","gneg"],[69700000,84900000,"p31.1","gpos100"],[84900000,88400000,"p22.3","gneg"],[88400000,92000000,"p22.2","gpos75"],[92000000,94700000,"p22.1","gneg"],[94700000,99700000,"p21.3","gpos75"],[99700000,102200000,"p21.2","gneg"],[102200000,107200000,"p21.1","gpos100"],[107200000,111800000,"p13.3","gneg"],[111800000,116100000,"p13.2","gpos50"],[116100000,117800000,"p13.1","gneg"],[117800000,120600000,"p12","gpos50"],[120600000,121500000,"p11.2","gneg"],[121500000,125000000,"p11.1","acen"],[125000000,128900000,"q11","acen"],[128900000,142600000,"q12","gvar"],[142600000,147000000,"q21.1","gneg"],[147000000,150300000,"q21.2","gpos50"],[150300000,155000000,"q21.3","gneg"],[155000000,156500000,"q22","gpos50"],[156500000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,172900000,"q24.3","gpos75"],[172900000,176000000,"q25.1","gneg"],[176000000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207200000,"q32.1","gneg"],[207200000,211500000,"q32.2","gpos25"],[211500000,214500000,"q32.3","gneg"],[214500000,224100000,"q41","gpos100"],[224100000,224600000,"q42.11","gneg"],[224600000,227000000,"q42.12","gpos25"],[227000000,230700000,"q42.13","gneg"],[230700000,234700000,"q42.2","gpos50"],[234700000,236600000,"q42.3","gneg"],[236600000,243700000,"q43","gpos75"],[243700000,249250621,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,7100000,"p25.2","gpos50"],[7100000,12200000,"p25.1","gneg"],[12200000,16700000,"p24.3","gpos75"],[16700000,19200000,"p24.2","gneg"],[19200000,24000000,"p24.1","gpos75"],[24000000,27900000,"p23.3","gneg"],[27900000,30000000,"p23.2","gpos25"],[30000000,32100000,"p23.1","gneg"],[32100000,36600000,"p22.3","gpos75"],[36600000,38600000,"p22.2","gneg"],[38600000,41800000,"p22.1","gpos50"],[41800000,47800000,"p21","gneg"],[47800000,52900000,"p16.3","gpos100"],[52900000,55000000,"p16.2","gneg"],[55000000,61300000,"p16.1","gpos100"],[61300000,64100000,"p15","gneg"],[64100000,68600000,"p14","gpos50"],[68600000,71500000,"p13.3","gneg"],[71500000,73500000,"p13.2","gpos50"],[73500000,75000000,"p13.1","gneg"],[75000000,83300000,"p12","gpos100"],[83300000,90500000,"p11.2","gneg"],[90500000,93300000,"p11.1","acen"],[93300000,96800000,"q11.1","acen"],[96800000,102700000,"q11.2","gneg"],[102700000,106000000,"q12.1","gpos50"],[106000000,107500000,"q12.2","gneg"],[107500000,110200000,"q12.3","gpos25"],[110200000,114400000,"q13","gneg"],[114400000,118800000,"q14.1","gpos50"],[118800000,122400000,"q14.2","gneg"],[122400000,129900000,"q14.3","gpos50"],[129900000,132500000,"q21.1","gneg"],[132500000,135100000,"q21.2","gpos25"],[135100000,136800000,"q21.3","gneg"],[136800000,142200000,"q22.1","gpos100"],[142200000,144100000,"q22.2","gneg"],[144100000,148700000,"q22.3","gpos100"],[148700000,149900000,"q23.1","gneg"],[149900000,150500000,"q23.2","gpos25"],[150500000,154900000,"q23.3","gneg"],[154900000,159800000,"q24.1","gpos75"],[159800000,163700000,"q24.2","gneg"],[163700000,169700000,"q24.3","gpos75"],[169700000,178000000,"q31.1","gneg"],[178000000,180600000,"q31.2","gpos50"],[180600000,183000000,"q31.3","gneg"],[183000000,189400000,"q32.1","gpos75"],[189400000,191900000,"q32.2","gneg"],[191900000,197400000,"q32.3","gpos75"],[197400000,203300000,"q33.1","gneg"],[203300000,204900000,"q33.2","gpos50"],[204900000,209000000,"q33.3","gneg"],[209000000,215300000,"q34","gpos100"],[215300000,221500000,"q35","gneg"],[221500000,225200000,"q36.1","gpos75"],[225200000,226100000,"q36.2","gneg"],[226100000,231000000,"q36.3","gpos100"],[231000000,235600000,"q37.1","gneg"],[235600000,237300000,"q37.2","gpos50"],[237300000,243199373,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8700000,"p26.1","gpos50"],[8700000,11800000,"p25.3","gneg"],[11800000,13300000,"p25.2","gpos25"],[13300000,16400000,"p25.1","gneg"],[16400000,23900000,"p24.3","gpos100"],[23900000,26400000,"p24.2","gneg"],[26400000,30900000,"p24.1","gpos75"],[30900000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39400000,"p22.2","gneg"],[39400000,43700000,"p22.1","gpos75"],[43700000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63700000,"p14.2","gneg"],[63700000,69800000,"p14.1","gpos50"],[69800000,74200000,"p13","gneg"],[74200000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87200000,"p12.1","gpos75"],[87200000,87900000,"p11.2","gneg"],[87900000,91000000,"p11.1","acen"],[91000000,93900000,"q11.1","acen"],[93900000,98300000,"q11.2","gvar"],[98300000,100000000,"q12.1","gneg"],[100000000,100900000,"q12.2","gpos25"],[100900000,102800000,"q12.3","gneg"],[102800000,106200000,"q13.11","gpos75"],[106200000,107900000,"q13.12","gneg"],[107900000,111300000,"q13.13","gpos50"],[111300000,113500000,"q13.2","gneg"],[113500000,117300000,"q13.31","gpos75"],[117300000,119000000,"q13.32","gneg"],[119000000,121900000,"q13.33","gpos75"],[121900000,123800000,"q21.1","gneg"],[123800000,125800000,"q21.2","gpos25"],[125800000,129200000,"q21.3","gneg"],[129200000,133700000,"q22.1","gpos25"],[133700000,135700000,"q22.2","gneg"],[135700000,138700000,"q22.3","gpos25"],[138700000,142800000,"q23","gneg"],[142800000,148900000,"q24","gpos100"],[148900000,152100000,"q25.1","gneg"],[152100000,155000000,"q25.2","gpos50"],[155000000,157000000,"q25.31","gneg"],[157000000,159000000,"q25.32","gpos50"],[159000000,160700000,"q25.33","gneg"],[160700000,167600000,"q26.1","gpos100"],[167600000,170900000,"q26.2","gneg"],[170900000,175700000,"q26.31","gpos75"],[175700000,179000000,"q26.32","gneg"],[179000000,182700000,"q26.33","gpos75"],[182700000,184500000,"q27.1","gneg"],[184500000,186000000,"q27.2","gpos25"],[186000000,187900000,"q27.3","gneg"],[187900000,192300000,"q28","gpos75"],[192300000,198022430,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15200000,"p15.33","gpos50"],[15200000,17800000,"p15.32","gneg"],[17800000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50400000,"p11","acen"],[50400000,52700000,"q11","acen"],[52700000,59500000,"q12","gneg"],[59500000,66600000,"q13.1","gpos100"],[66600000,70500000,"q13.2","gneg"],[70500000,76300000,"q13.3","gpos75"],[76300000,78900000,"q21.1","gneg"],[78900000,82400000,"q21.21","gpos50"],[82400000,84100000,"q21.22","gneg"],[84100000,86900000,"q21.23","gpos25"],[86900000,88000000,"q21.3","gneg"],[88000000,93700000,"q22.1","gpos75"],[93700000,95100000,"q22.2","gneg"],[95100000,98800000,"q22.3","gpos75"],[98800000,101100000,"q23","gneg"],[101100000,107700000,"q24","gpos50"],[107700000,114100000,"q25","gneg"],[114100000,120800000,"q26","gpos75"],[120800000,123800000,"q27","gneg"],[123800000,128800000,"q28.1","gpos50"],[128800000,131100000,"q28.2","gneg"],[131100000,139500000,"q28.3","gpos100"],[139500000,141500000,"q31.1","gneg"],[141500000,146800000,"q31.21","gpos25"],[146800000,148500000,"q31.22","gneg"],[148500000,151100000,"q31.23","gpos25"],[151100000,155600000,"q31.3","gneg"],[155600000,161800000,"q32.1","gpos100"],[161800000,164500000,"q32.2","gneg"],[164500000,170100000,"q32.3","gpos100"],[170100000,171900000,"q33","gneg"],[171900000,176300000,"q34.1","gpos75"],[176300000,177500000,"q34.2","gneg"],[177500000,183200000,"q34.3","gpos100"],[183200000,187100000,"q35.1","gneg"],[187100000,191154276,"q35.2","gpos25"]],5:[[0,4500000,"p15.33","gneg"],[4500000,6300000,"p15.32","gpos25"],[6300000,9800000,"p15.31","gneg"],[9800000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48400000,"p11","acen"],[48400000,50700000,"q11.1","acen"],[50700000,58900000,"q11.2","gneg"],[58900000,62900000,"q12.1","gpos75"],[62900000,63200000,"q12.2","gneg"],[63200000,66700000,"q12.3","gpos75"],[66700000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76900000,"q13.3","gneg"],[76900000,81400000,"q14.1","gpos50"],[81400000,82800000,"q14.2","gneg"],[82800000,92300000,"q14.3","gpos100"],[92300000,98200000,"q15","gneg"],[98200000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121400000,"q23.1","gpos100"],[121400000,127300000,"q23.2","gneg"],[127300000,130600000,"q23.3","gpos100"],[130600000,136200000,"q31.1","gneg"],[136200000,139500000,"q31.2","gpos25"],[139500000,144500000,"q31.3","gneg"],[144500000,149800000,"q32","gpos75"],[149800000,152700000,"q33.1","gneg"],[152700000,155700000,"q33.2","gpos50"],[155700000,159900000,"q33.3","gneg"],[159900000,168500000,"q34","gpos100"],[168500000,172800000,"q35.1","gneg"],[172800000,176600000,"q35.2","gpos25"],[176600000,180915260,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27000000,"p22.2","gneg"],[27000000,30400000,"p22.1","gpos50"],[30400000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,52900000,"p12.2","gneg"],[52900000,57000000,"p12.1","gpos100"],[57000000,58700000,"p11.2","gneg"],[58700000,61000000,"p11.1","acen"],[61000000,63300000,"q11.1","acen"],[63300000,63400000,"q11.2","gneg"],[63400000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84900000,"q14.2","gneg"],[84900000,88000000,"q14.3","gpos50"],[88000000,93100000,"q15","gneg"],[93100000,99500000,"q16.1","gpos100"],[99500000,100600000,"q16.2","gneg"],[100600000,105500000,"q16.3","gpos100"],[105500000,114600000,"q21","gneg"],[114600000,118300000,"q22.1","gpos75"],[118300000,118500000,"q22.2","gneg"],[118500000,126100000,"q22.31","gpos100"],[126100000,127100000,"q22.32","gneg"],[127100000,130300000,"q22.33","gpos75"],[130300000,131200000,"q23.1","gneg"],[131200000,135200000,"q23.2","gpos50"],[135200000,139000000,"q23.3","gneg"],[139000000,142800000,"q24.1","gpos75"],[142800000,145600000,"q24.2","gneg"],[145600000,149000000,"q24.3","gpos75"],[149000000,152500000,"q25.1","gneg"],[152500000,155500000,"q25.2","gpos50"],[155500000,161000000,"q25.3","gneg"],[161000000,164500000,"q26","gpos50"],[164500000,171115067,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7300000,"p22.1","gneg"],[7300000,13800000,"p21.3","gpos100"],[13800000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,28000000,"p15.2","gpos50"],[28000000,28800000,"p15.1","gneg"],[28800000,35000000,"p14.3","gpos75"],[35000000,37200000,"p14.2","gneg"],[37200000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,54000000,"p12.1","gpos75"],[54000000,58000000,"p11.2","gneg"],[58000000,59900000,"p11.1","acen"],[59900000,61700000,"q11.1","acen"],[61700000,67000000,"q11.21","gneg"],[67000000,72200000,"q11.22","gpos50"],[72200000,77500000,"q11.23","gneg"],[77500000,86400000,"q21.11","gpos100"],[86400000,88200000,"q21.12","gneg"],[88200000,91100000,"q21.13","gpos75"],[91100000,92800000,"q21.2","gneg"],[92800000,98000000,"q21.3","gpos75"],[98000000,103800000,"q22.1","gneg"],[103800000,104500000,"q22.2","gpos50"],[104500000,107400000,"q22.3","gneg"],[107400000,114600000,"q31.1","gpos75"],[114600000,117400000,"q31.2","gneg"],[117400000,121100000,"q31.31","gpos75"],[121100000,123800000,"q31.32","gneg"],[123800000,127100000,"q31.33","gpos75"],[127100000,129200000,"q32.1","gneg"],[129200000,130400000,"q32.2","gpos25"],[130400000,132600000,"q32.3","gneg"],[132600000,138200000,"q33","gpos50"],[138200000,143100000,"q34","gneg"],[143100000,147900000,"q35","gpos75"],[147900000,152600000,"q36.1","gneg"],[152600000,155100000,"q36.2","gpos25"],[155100000,159138663,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19000000,"p22","gpos100"],[19000000,23300000,"p21.3","gneg"],[23300000,27400000,"p21.2","gpos50"],[27400000,28800000,"p21.1","gneg"],[28800000,36500000,"p12","gpos75"],[36500000,38300000,"p11.23","gneg"],[38300000,39700000,"p11.22","gpos25"],[39700000,43100000,"p11.21","gneg"],[43100000,45600000,"p11.1","acen"],[45600000,48100000,"q11.1","acen"],[48100000,52200000,"q11.21","gneg"],[52200000,52600000,"q11.22","gpos75"],[52600000,55500000,"q11.23","gneg"],[55500000,61600000,"q12.1","gpos50"],[61600000,62200000,"q12.2","gneg"],[62200000,66000000,"q12.3","gpos50"],[66000000,68000000,"q13.1","gneg"],[68000000,70500000,"q13.2","gpos50"],[70500000,73900000,"q13.3","gneg"],[73900000,78300000,"q21.11","gpos100"],[78300000,80100000,"q21.12","gneg"],[80100000,84600000,"q21.13","gpos75"],[84600000,86900000,"q21.2","gneg"],[86900000,93300000,"q21.3","gpos100"],[93300000,99000000,"q22.1","gneg"],[99000000,101600000,"q22.2","gpos25"],[101600000,106200000,"q22.3","gneg"],[106200000,110500000,"q23.1","gpos75"],[110500000,112100000,"q23.2","gneg"],[112100000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136400000,"q24.22","gneg"],[136400000,139900000,"q24.23","gpos75"],[139900000,146364022,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,38400000,"p13.2","gpos25"],[38400000,41000000,"p13.1","gneg"],[41000000,43600000,"p12","gpos50"],[43600000,47300000,"p11.2","gneg"],[47300000,49000000,"p11.1","acen"],[49000000,50700000,"q11","acen"],[50700000,65900000,"q12","gvar"],[65900000,68700000,"q13","gneg"],[68700000,72200000,"q21.11","gpos25"],[72200000,74000000,"q21.12","gneg"],[74000000,79200000,"q21.13","gpos50"],[79200000,81100000,"q21.2","gneg"],[81100000,84100000,"q21.31","gpos50"],[84100000,86900000,"q21.32","gneg"],[86900000,90400000,"q21.33","gpos50"],[90400000,91800000,"q22.1","gneg"],[91800000,93900000,"q22.2","gpos25"],[93900000,96600000,"q22.31","gneg"],[96600000,99300000,"q22.32","gpos25"],[99300000,102600000,"q22.33","gneg"],[102600000,108200000,"q31.1","gpos100"],[108200000,111300000,"q31.2","gneg"],[111300000,114900000,"q31.3","gpos25"],[114900000,117700000,"q32","gneg"],[117700000,122500000,"q33.1","gpos75"],[122500000,125800000,"q33.2","gneg"],[125800000,130300000,"q33.3","gpos25"],[130300000,133500000,"q34.11","gneg"],[133500000,134000000,"q34.12","gpos25"],[134000000,135900000,"q34.13","gneg"],[135900000,137400000,"q34.2","gpos25"],[137400000,141213431,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18600000,"p12.33","gpos75"],[18600000,18700000,"p12.32","gneg"],[18700000,22600000,"p12.31","gpos75"],[22600000,24600000,"p12.2","gneg"],[24600000,29600000,"p12.1","gpos50"],[29600000,31300000,"p11.23","gneg"],[31300000,34400000,"p11.22","gpos25"],[34400000,38000000,"p11.21","gneg"],[38000000,40200000,"p11.1","acen"],[40200000,42300000,"q11.1","acen"],[42300000,46100000,"q11.21","gneg"],[46100000,49900000,"q11.22","gpos25"],[49900000,52900000,"q11.23","gneg"],[52900000,61200000,"q21.1","gpos100"],[61200000,64500000,"q21.2","gneg"],[64500000,70600000,"q21.3","gpos100"],[70600000,74900000,"q22.1","gneg"],[74900000,77700000,"q22.2","gpos50"],[77700000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89500000,"q23.2","gneg"],[89500000,92900000,"q23.31","gpos75"],[92900000,94100000,"q23.32","gneg"],[94100000,97000000,"q23.33","gpos50"],[97000000,99300000,"q24.1","gneg"],[99300000,101900000,"q24.2","gpos50"],[101900000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105800000,"q24.33","gneg"],[105800000,111900000,"q25.1","gpos100"],[111900000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127500000,"q26.13","gneg"],[127500000,130600000,"q26.2","gpos50"],[130600000,135534747,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12700000,"p15.3","gneg"],[12700000,16200000,"p15.2","gpos50"],[16200000,21700000,"p15.1","gneg"],[21700000,26100000,"p14.3","gpos100"],[26100000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43500000,"p12","gpos100"],[43500000,48800000,"p11.2","gneg"],[48800000,51600000,"p11.12","gpos75"],[51600000,53700000,"p11.11","acen"],[53700000,55700000,"q11","acen"],[55700000,59900000,"q12.1","gpos75"],[59900000,61700000,"q12.2","gneg"],[61700000,63400000,"q12.3","gpos25"],[63400000,65900000,"q13.1","gneg"],[65900000,68400000,"q13.2","gpos25"],[68400000,70400000,"q13.3","gneg"],[70400000,75200000,"q13.4","gpos50"],[75200000,77100000,"q13.5","gneg"],[77100000,85600000,"q14.1","gpos100"],[85600000,88300000,"q14.2","gneg"],[88300000,92800000,"q14.3","gpos100"],[92800000,97200000,"q21","gneg"],[97200000,102100000,"q22.1","gpos100"],[102100000,102900000,"q22.2","gneg"],[102900000,110400000,"q22.3","gpos100"],[110400000,112500000,"q23.1","gneg"],[112500000,114500000,"q23.2","gpos50"],[114500000,121200000,"q23.3","gneg"],[121200000,123900000,"q24.1","gpos50"],[123900000,127800000,"q24.2","gneg"],[127800000,130800000,"q24.3","gpos50"],[130800000,135006516,"q25","gneg"]],12:[[0,3300000,"p13.33","gneg"],[3300000,5400000,"p13.32","gpos25"],[5400000,10100000,"p13.31","gneg"],[10100000,12800000,"p13.2","gpos75"],[12800000,14800000,"p13.1","gneg"],[14800000,20000000,"p12.3","gpos100"],[20000000,21300000,"p12.2","gneg"],[21300000,26500000,"p12.1","gpos100"],[26500000,27800000,"p11.23","gneg"],[27800000,30700000,"p11.22","gpos50"],[30700000,33300000,"p11.21","gneg"],[33300000,35800000,"p11.1","acen"],[35800000,38200000,"q11","acen"],[38200000,46400000,"q12","gpos100"],[46400000,49100000,"q13.11","gneg"],[49100000,51500000,"q13.12","gpos25"],[51500000,54900000,"q13.13","gneg"],[54900000,56600000,"q13.2","gpos25"],[56600000,58100000,"q13.3","gneg"],[58100000,63100000,"q14.1","gpos75"],[63100000,65100000,"q14.2","gneg"],[65100000,67700000,"q14.3","gpos50"],[67700000,71500000,"q15","gneg"],[71500000,75700000,"q21.1","gpos75"],[75700000,80300000,"q21.2","gneg"],[80300000,86700000,"q21.31","gpos100"],[86700000,89000000,"q21.32","gneg"],[89000000,92600000,"q21.33","gpos100"],[92600000,96200000,"q22","gneg"],[96200000,101600000,"q23.1","gpos75"],[101600000,103800000,"q23.2","gneg"],[103800000,109000000,"q23.3","gpos50"],[109000000,111700000,"q24.11","gneg"],[111700000,112300000,"q24.12","gpos25"],[112300000,114300000,"q24.13","gneg"],[114300000,116800000,"q24.21","gpos50"],[116800000,118100000,"q24.22","gneg"],[118100000,120700000,"q24.23","gpos50"],[120700000,125900000,"q24.31","gneg"],[125900000,129300000,"q24.32","gpos50"],[129300000,133851895,"q24.33","gneg"]],13:[[0,4500000,"p13","gvar"],[4500000,10000000,"p12","stalk"],[10000000,16300000,"p11.2","gvar"],[16300000,17900000,"p11.1","acen"],[17900000,19500000,"q11","acen"],[19500000,23300000,"q12.11","gneg"],[23300000,25500000,"q12.12","gpos25"],[25500000,27800000,"q12.13","gneg"],[27800000,28900000,"q12.2","gpos25"],[28900000,32200000,"q12.3","gneg"],[32200000,34000000,"q13.1","gpos50"],[34000000,35500000,"q13.2","gneg"],[35500000,40100000,"q13.3","gpos75"],[40100000,45200000,"q14.11","gneg"],[45200000,45800000,"q14.12","gpos25"],[45800000,47300000,"q14.13","gneg"],[47300000,50900000,"q14.2","gpos50"],[50900000,55300000,"q14.3","gneg"],[55300000,59600000,"q21.1","gpos100"],[59600000,62300000,"q21.2","gneg"],[62300000,65700000,"q21.31","gpos75"],[65700000,68600000,"q21.32","gneg"],[68600000,73300000,"q21.33","gpos100"],[73300000,75400000,"q22.1","gneg"],[75400000,77200000,"q22.2","gpos50"],[77200000,79000000,"q22.3","gneg"],[79000000,87700000,"q31.1","gpos100"],[87700000,90000000,"q31.2","gneg"],[90000000,95000000,"q31.3","gpos100"],[95000000,98200000,"q32.1","gneg"],[98200000,99300000,"q32.2","gpos25"],[99300000,101700000,"q32.3","gneg"],[101700000,104800000,"q33.1","gpos100"],[104800000,107000000,"q33.2","gneg"],[107000000,110300000,"q33.3","gpos100"],[110300000,115169878,"q34","gneg"]],14:[[0,3700000,"p13","gvar"],[3700000,8100000,"p12","stalk"],[8100000,16100000,"p11.2","gvar"],[16100000,17600000,"p11.1","acen"],[17600000,19100000,"q11.1","acen"],[19100000,24600000,"q11.2","gneg"],[24600000,33300000,"q12","gpos100"],[33300000,35300000,"q13.1","gneg"],[35300000,36600000,"q13.2","gpos50"],[36600000,37800000,"q13.3","gneg"],[37800000,43500000,"q21.1","gpos100"],[43500000,47200000,"q21.2","gneg"],[47200000,50900000,"q21.3","gpos100"],[50900000,54100000,"q22.1","gneg"],[54100000,55500000,"q22.2","gpos25"],[55500000,58100000,"q22.3","gneg"],[58100000,62100000,"q23.1","gpos75"],[62100000,64800000,"q23.2","gneg"],[64800000,67900000,"q23.3","gpos50"],[67900000,70200000,"q24.1","gneg"],[70200000,73800000,"q24.2","gpos50"],[73800000,79300000,"q24.3","gneg"],[79300000,83600000,"q31.1","gpos100"],[83600000,84900000,"q31.2","gneg"],[84900000,89800000,"q31.3","gpos100"],[89800000,91900000,"q32.11","gneg"],[91900000,94700000,"q32.12","gpos25"],[94700000,96300000,"q32.13","gneg"],[96300000,101400000,"q32.2","gpos50"],[101400000,103200000,"q32.31","gneg"],[103200000,104000000,"q32.32","gpos50"],[104000000,107349540,"q32.33","gneg"]],15:[[0,3900000,"p13","gvar"],[3900000,8700000,"p12","stalk"],[8700000,15800000,"p11.2","gvar"],[15800000,19000000,"p11.1","acen"],[19000000,20700000,"q11.1","acen"],[20700000,25700000,"q11.2","gneg"],[25700000,28100000,"q12","gpos50"],[28100000,30300000,"q13.1","gneg"],[30300000,31200000,"q13.2","gpos50"],[31200000,33600000,"q13.3","gneg"],[33600000,40100000,"q14","gpos75"],[40100000,42800000,"q15.1","gneg"],[42800000,43600000,"q15.2","gpos25"],[43600000,44800000,"q15.3","gneg"],[44800000,49500000,"q21.1","gpos75"],[49500000,52900000,"q21.2","gneg"],[52900000,59100000,"q21.3","gpos75"],[59100000,59300000,"q22.1","gneg"],[59300000,63700000,"q22.2","gpos25"],[63700000,67200000,"q22.31","gneg"],[67200000,67300000,"q22.32","gpos25"],[67300000,67500000,"q22.33","gneg"],[67500000,72700000,"q23","gpos25"],[72700000,75200000,"q24.1","gneg"],[75200000,76600000,"q24.2","gpos25"],[76600000,78300000,"q24.3","gneg"],[78300000,81700000,"q25.1","gpos50"],[81700000,85200000,"q25.2","gneg"],[85200000,89100000,"q25.3","gpos50"],[89100000,94300000,"q26.1","gneg"],[94300000,98500000,"q26.2","gpos50"],[98500000,102531392,"q26.3","gneg"]],16:[[0,7900000,"p13.3","gneg"],[7900000,10500000,"p13.2","gpos50"],[10500000,12600000,"p13.13","gneg"],[12600000,14800000,"p13.12","gpos50"],[14800000,16800000,"p13.11","gneg"],[16800000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28100000,"p12.1","gpos50"],[28100000,34600000,"p11.2","gneg"],[34600000,36600000,"p11.1","acen"],[36600000,38600000,"q11.1","acen"],[38600000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56700000,"q12.2","gpos50"],[56700000,57400000,"q13","gneg"],[57400000,66700000,"q21","gpos100"],[66700000,70800000,"q22.1","gneg"],[70800000,72900000,"q22.2","gpos50"],[72900000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81700000,"q23.2","gneg"],[81700000,84200000,"q23.3","gpos50"],[84200000,87100000,"q24.1","gneg"],[87100000,88700000,"q24.2","gpos25"],[88700000,90354753,"q24.3","gneg"]],17:[[0,3300000,"p13.3","gneg"],[3300000,6500000,"p13.2","gpos50"],[6500000,10700000,"p13.1","gneg"],[10700000,16000000,"p12","gpos75"],[16000000,22200000,"p11.2","gneg"],[22200000,24000000,"p11.1","acen"],[24000000,25800000,"q11.1","acen"],[25800000,31800000,"q11.2","gneg"],[31800000,38100000,"q12","gpos50"],[38100000,38400000,"q21.1","gneg"],[38400000,40900000,"q21.2","gpos25"],[40900000,44900000,"q21.31","gneg"],[44900000,47400000,"q21.32","gpos25"],[47400000,50200000,"q21.33","gneg"],[50200000,57600000,"q22","gpos75"],[57600000,58300000,"q23.1","gneg"],[58300000,61100000,"q23.2","gpos75"],[61100000,62600000,"q23.3","gneg"],[62600000,64200000,"q24.1","gpos50"],[64200000,67100000,"q24.2","gneg"],[67100000,70900000,"q24.3","gpos75"],[70900000,74800000,"q25.1","gneg"],[74800000,75300000,"q25.2","gpos25"],[75300000,81195210,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7100000,"p11.31","gpos50"],[7100000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,17200000,"p11.1","acen"],[17200000,19000000,"q11.1","acen"],[19000000,25000000,"q11.2","gneg"],[25000000,32700000,"q12.1","gpos100"],[32700000,37200000,"q12.2","gneg"],[37200000,43500000,"q12.3","gpos75"],[43500000,48200000,"q21.1","gneg"],[48200000,53800000,"q21.2","gpos75"],[53800000,56200000,"q21.31","gneg"],[56200000,59000000,"q21.32","gpos50"],[59000000,61600000,"q21.33","gneg"],[61600000,66800000,"q22.1","gpos100"],[66800000,68700000,"q22.2","gneg"],[68700000,73100000,"q22.3","gpos25"],[73100000,78077248,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,13900000,"p13.2","gpos25"],[13900000,14000000,"p13.13","gneg"],[14000000,16300000,"p13.12","gpos25"],[16300000,20000000,"p13.11","gneg"],[20000000,24400000,"p12","gvar"],[24400000,26500000,"p11","acen"],[26500000,28600000,"q11","acen"],[28600000,32400000,"q12","gvar"],[32400000,35500000,"q13.11","gneg"],[35500000,38300000,"q13.12","gpos25"],[38300000,38700000,"q13.13","gneg"],[38700000,43400000,"q13.2","gpos25"],[43400000,45200000,"q13.31","gneg"],[45200000,48000000,"q13.32","gpos25"],[48000000,51400000,"q13.33","gneg"],[51400000,53600000,"q13.41","gpos25"],[53600000,56300000,"q13.42","gneg"],[56300000,59128983,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12100000,"p12.2","gneg"],[12100000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25600000,"p11.21","gneg"],[25600000,27500000,"p11.1","acen"],[27500000,29400000,"q11.1","acen"],[29400000,32100000,"q11.21","gneg"],[32100000,34400000,"q11.22","gpos25"],[34400000,37600000,"q11.23","gneg"],[37600000,41700000,"q12","gpos75"],[41700000,42100000,"q13.11","gneg"],[42100000,46400000,"q13.12","gpos25"],[46400000,49800000,"q13.13","gneg"],[49800000,55000000,"q13.2","gpos75"],[55000000,56500000,"q13.31","gneg"],[56500000,58400000,"q13.32","gpos50"],[58400000,63025520,"q13.33","gneg"]],21:[[0,2800000,"p13","gvar"],[2800000,6800000,"p12","stalk"],[6800000,10900000,"p11.2","gvar"],[10900000,13200000,"p11.1","acen"],[13200000,14300000,"q11.1","acen"],[14300000,16400000,"q11.2","gneg"],[16400000,24000000,"q21.1","gpos100"],[24000000,26800000,"q21.2","gneg"],[26800000,31500000,"q21.3","gpos75"],[31500000,35800000,"q22.11","gneg"],[35800000,37800000,"q22.12","gpos50"],[37800000,39700000,"q22.13","gneg"],[39700000,42600000,"q22.2","gpos50"],[42600000,48129895,"q22.3","gneg"]],22:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,12200000,"p11.2","gvar"],[12200000,14700000,"p11.1","acen"],[14700000,17900000,"q11.1","acen"],[17900000,22200000,"q11.21","gneg"],[22200000,23500000,"q11.22","gpos25"],[23500000,25900000,"q11.23","gneg"],[25900000,29600000,"q12.1","gpos50"],[29600000,32200000,"q12.2","gneg"],[32200000,37600000,"q12.3","gpos50"],[37600000,41000000,"q13.1","gneg"],[41000000,44200000,"q13.2","gpos50"],[44200000,48400000,"q13.31","gneg"],[48400000,49400000,"q13.32","gpos50"],[49400000,51304566,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19300000,"p22.13","gneg"],[19300000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37600000,"p21.1","gpos100"],[37600000,42400000,"p11.4","gneg"],[42400000,46400000,"p11.3","gpos75"],[46400000,49800000,"p11.23","gneg"],[49800000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,60600000,"p11.1","acen"],[60600000,63000000,"q11.1","acen"],[63000000,64600000,"q11.2","gneg"],[64600000,67800000,"q12","gpos50"],[67800000,71800000,"q13.1","gneg"],[71800000,73900000,"q13.2","gpos50"],[73900000,76000000,"q13.3","gneg"],[76000000,84600000,"q21.1","gpos100"],[84600000,86200000,"q21.2","gneg"],[86200000,91800000,"q21.31","gpos100"],[91800000,93500000,"q21.32","gneg"],[93500000,98300000,"q21.33","gpos75"],[98300000,102600000,"q22.1","gneg"],[102600000,103700000,"q22.2","gpos50"],[103700000,108700000,"q22.3","gneg"],[108700000,116500000,"q23","gpos75"],[116500000,120900000,"q24","gneg"],[120900000,128700000,"q25","gpos100"],[128700000,130400000,"q26.1","gneg"],[130400000,133600000,"q26.2","gpos25"],[133600000,138000000,"q26.3","gneg"],[138000000,140300000,"q27.1","gpos75"],[140300000,142100000,"q27.2","gneg"],[142100000,147100000,"q27.3","gpos100"],[147100000,155270560,"q28","gneg"]],Y:[[0,2500000,"p11.32","gneg"],[2500000,3000000,"p11.31","gpos50"],[3000000,11600000,"p11.2","gneg"],[11600000,12500000,"p11.1","acen"],[12500000,13400000,"q11.1","acen"],[13400000,15100000,"q11.21","gneg"],[15100000,19800000,"q11.221","gpos50"],[19800000,22100000,"q11.222","gneg"],[22100000,26200000,"q11.223","gpos50"],[26200000,28800000,"q11.23","gneg"],[28800000,59373566,"q12","gvar"]]}},hg38:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9100000,"p36.23","gpos25"],[9100000,12500000,"p36.22","gneg"],[12500000,15900000,"p36.21","gpos50"],[15900000,20100000,"p36.13","gneg"],[20100000,23600000,"p36.12","gpos25"],[23600000,27600000,"p36.11","gneg"],[27600000,29900000,"p35.3","gpos25"],[29900000,32300000,"p35.2","gneg"],[32300000,34300000,"p35.1","gpos25"],[34300000,39600000,"p34.3","gneg"],[39600000,43700000,"p34.2","gpos25"],[43700000,46300000,"p34.1","gneg"],[46300000,50200000,"p33","gpos75"],[50200000,55600000,"p32.3","gneg"],[55600000,58500000,"p32.2","gpos50"],[58500000,60800000,"p32.1","gneg"],[60800000,68500000,"p31.3","gpos50"],[68500000,69300000,"p31.2","gneg"],[69300000,84400000,"p31.1","gpos100"],[84400000,87900000,"p22.3","gneg"],[87900000,91500000,"p22.2","gpos75"],[91500000,94300000,"p22.1","gneg"],[94300000,99300000,"p21.3","gpos75"],[99300000,101800000,"p21.2","gneg"],[101800000,106700000,"p21.1","gpos100"],[106700000,111200000,"p13.3","gneg"],[111200000,115500000,"p13.2","gpos50"],[115500000,117200000,"p13.1","gneg"],[117200000,120400000,"p12","gpos50"],[120400000,121700000,"p11.2","gneg"],[121700000,123400000,"p11.1","acen"],[123400000,125100000,"q11","acen"],[125100000,143200000,"q12","gvar"],[143200000,147500000,"q21.1","gneg"],[147500000,150600000,"q21.2","gpos50"],[150600000,155100000,"q21.3","gneg"],[155100000,156600000,"q22","gpos50"],[156600000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,173000000,"q24.3","gpos75"],[173000000,176100000,"q25.1","gneg"],[176100000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207100000,"q32.1","gneg"],[207100000,211300000,"q32.2","gpos25"],[211300000,214400000,"q32.3","gneg"],[214400000,223900000,"q41","gpos100"],[223900000,224400000,"q42.11","gneg"],[224400000,226800000,"q42.12","gpos25"],[226800000,230500000,"q42.13","gneg"],[230500000,234600000,"q42.2","gpos50"],[234600000,236400000,"q42.3","gneg"],[236400000,243500000,"q43","gpos75"],[243500000,248956422,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,6900000,"p25.2","gpos50"],[6900000,12000000,"p25.1","gneg"],[12000000,16500000,"p24.3","gpos75"],[16500000,19000000,"p24.2","gneg"],[19000000,23800000,"p24.1","gpos75"],[23800000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31800000,"p23.1","gneg"],[31800000,36300000,"p22.3","gpos75"],[36300000,38300000,"p22.2","gneg"],[38300000,41500000,"p22.1","gpos50"],[41500000,47500000,"p21","gneg"],[47500000,52600000,"p16.3","gpos100"],[52600000,54700000,"p16.2","gneg"],[54700000,61000000,"p16.1","gpos100"],[61000000,63900000,"p15","gneg"],[63900000,68400000,"p14","gpos50"],[68400000,71300000,"p13.3","gneg"],[71300000,73300000,"p13.2","gpos50"],[73300000,74800000,"p13.1","gneg"],[74800000,83100000,"p12","gpos100"],[83100000,91800000,"p11.2","gneg"],[91800000,93900000,"p11.1","acen"],[93900000,96000000,"q11.1","acen"],[96000000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108700000,"q12.3","gpos25"],[108700000,112200000,"q13","gneg"],[112200000,118100000,"q14.1","gpos50"],[118100000,121600000,"q14.2","gneg"],[121600000,129100000,"q14.3","gpos50"],[129100000,131700000,"q21.1","gneg"],[131700000,134300000,"q21.2","gpos25"],[134300000,136100000,"q21.3","gneg"],[136100000,141500000,"q22.1","gpos100"],[141500000,143400000,"q22.2","gneg"],[143400000,147900000,"q22.3","gpos100"],[147900000,149000000,"q23.1","gneg"],[149000000,149600000,"q23.2","gpos25"],[149600000,154000000,"q23.3","gneg"],[154000000,158900000,"q24.1","gpos75"],[158900000,162900000,"q24.2","gneg"],[162900000,168900000,"q24.3","gpos75"],[168900000,177100000,"q31.1","gneg"],[177100000,179700000,"q31.2","gpos50"],[179700000,182100000,"q31.3","gneg"],[182100000,188500000,"q32.1","gpos75"],[188500000,191100000,"q32.2","gneg"],[191100000,196600000,"q32.3","gpos75"],[196600000,202500000,"q33.1","gneg"],[202500000,204100000,"q33.2","gpos50"],[204100000,208200000,"q33.3","gneg"],[208200000,214500000,"q34","gpos100"],[214500000,220700000,"q35","gneg"],[220700000,224300000,"q36.1","gpos75"],[224300000,225200000,"q36.2","gneg"],[225200000,230100000,"q36.3","gpos100"],[230100000,234700000,"q37.1","gneg"],[234700000,236400000,"q37.2","gpos50"],[236400000,242193529,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8100000,"p26.1","gpos50"],[8100000,11600000,"p25.3","gneg"],[11600000,13200000,"p25.2","gpos25"],[13200000,16300000,"p25.1","gneg"],[16300000,23800000,"p24.3","gpos100"],[23800000,26300000,"p24.2","gneg"],[26300000,30800000,"p24.1","gpos75"],[30800000,32000000,"p23","gneg"],[32000000,36400000,"p22.3","gpos50"],[36400000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63800000,"p14.2","gneg"],[63800000,69700000,"p14.1","gpos50"],[69700000,74100000,"p13","gneg"],[74100000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87100000,"p12.1","gpos75"],[87100000,87800000,"p11.2","gneg"],[87800000,90900000,"p11.1","acen"],[90900000,94000000,"q11.1","acen"],[94000000,98600000,"q11.2","gvar"],[98600000,100300000,"q12.1","gneg"],[100300000,101200000,"q12.2","gpos25"],[101200000,103100000,"q12.3","gneg"],[103100000,106500000,"q13.11","gpos75"],[106500000,108200000,"q13.12","gneg"],[108200000,111600000,"q13.13","gpos50"],[111600000,113700000,"q13.2","gneg"],[113700000,117600000,"q13.31","gpos75"],[117600000,119300000,"q13.32","gneg"],[119300000,122200000,"q13.33","gpos75"],[122200000,124100000,"q21.1","gneg"],[124100000,126100000,"q21.2","gpos25"],[126100000,129500000,"q21.3","gneg"],[129500000,134000000,"q22.1","gpos25"],[134000000,136000000,"q22.2","gneg"],[136000000,139000000,"q22.3","gpos25"],[139000000,143100000,"q23","gneg"],[143100000,149200000,"q24","gpos100"],[149200000,152300000,"q25.1","gneg"],[152300000,155300000,"q25.2","gpos50"],[155300000,157300000,"q25.31","gneg"],[157300000,159300000,"q25.32","gpos50"],[159300000,161000000,"q25.33","gneg"],[161000000,167900000,"q26.1","gpos100"],[167900000,171200000,"q26.2","gneg"],[171200000,176000000,"q26.31","gpos75"],[176000000,179300000,"q26.32","gneg"],[179300000,183000000,"q26.33","gpos75"],[183000000,184800000,"q27.1","gneg"],[184800000,186300000,"q27.2","gpos25"],[186300000,188200000,"q27.3","gneg"],[188200000,192600000,"q28","gpos75"],[192600000,198295559,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15000000,"p15.33","gpos50"],[15000000,17700000,"p15.32","gneg"],[17700000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50000000,"p11","acen"],[50000000,51800000,"q11","acen"],[51800000,58500000,"q12","gneg"],[58500000,65500000,"q13.1","gpos100"],[65500000,69400000,"q13.2","gneg"],[69400000,75300000,"q13.3","gpos75"],[75300000,78000000,"q21.1","gneg"],[78000000,81500000,"q21.21","gpos50"],[81500000,83200000,"q21.22","gneg"],[83200000,86000000,"q21.23","gpos25"],[86000000,87100000,"q21.3","gneg"],[87100000,92800000,"q22.1","gpos75"],[92800000,94200000,"q22.2","gneg"],[94200000,97900000,"q22.3","gpos75"],[97900000,100100000,"q23","gneg"],[100100000,106700000,"q24","gpos50"],[106700000,113200000,"q25","gneg"],[113200000,119900000,"q26","gpos75"],[119900000,122800000,"q27","gneg"],[122800000,127900000,"q28.1","gpos50"],[127900000,130100000,"q28.2","gneg"],[130100000,138500000,"q28.3","gpos100"],[138500000,140600000,"q31.1","gneg"],[140600000,145900000,"q31.21","gpos25"],[145900000,147500000,"q31.22","gneg"],[147500000,150200000,"q31.23","gpos25"],[150200000,154600000,"q31.3","gneg"],[154600000,160800000,"q32.1","gpos100"],[160800000,163600000,"q32.2","gneg"],[163600000,169200000,"q32.3","gpos100"],[169200000,171000000,"q33","gneg"],[171000000,175400000,"q34.1","gpos75"],[175400000,176600000,"q34.2","gneg"],[176600000,182300000,"q34.3","gpos100"],[182300000,186200000,"q35.1","gneg"],[186200000,190214555,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6300000,"p15.32","gpos25"],[6300000,9900000,"p15.31","gneg"],[9900000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48800000,"p11","acen"],[48800000,51400000,"q11.1","acen"],[51400000,59600000,"q11.2","gneg"],[59600000,63600000,"q12.1","gpos75"],[63600000,63900000,"q12.2","gneg"],[63900000,67400000,"q12.3","gpos75"],[67400000,69100000,"q13.1","gneg"],[69100000,74000000,"q13.2","gpos50"],[74000000,77600000,"q13.3","gneg"],[77600000,82100000,"q14.1","gpos50"],[82100000,83500000,"q14.2","gneg"],[83500000,93000000,"q14.3","gpos100"],[93000000,98900000,"q15","gneg"],[98900000,103400000,"q21.1","gpos100"],[103400000,105100000,"q21.2","gneg"],[105100000,110200000,"q21.3","gpos100"],[110200000,112200000,"q22.1","gneg"],[112200000,113800000,"q22.2","gpos50"],[113800000,115900000,"q22.3","gneg"],[115900000,122100000,"q23.1","gpos100"],[122100000,127900000,"q23.2","gneg"],[127900000,131200000,"q23.3","gpos100"],[131200000,136900000,"q31.1","gneg"],[136900000,140100000,"q31.2","gpos25"],[140100000,145100000,"q31.3","gneg"],[145100000,150400000,"q32","gpos75"],[150400000,153300000,"q33.1","gneg"],[153300000,156300000,"q33.2","gpos50"],[156300000,160500000,"q33.3","gneg"],[160500000,169000000,"q34","gpos100"],[169000000,173300000,"q35.1","gneg"],[173300000,177100000,"q35.2","gpos25"],[177100000,181538259,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27100000,"p22.2","gneg"],[27100000,30500000,"p22.1","gpos50"],[30500000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,53000000,"p12.2","gneg"],[53000000,57200000,"p12.1","gpos100"],[57200000,58500000,"p11.2","gneg"],[58500000,59800000,"p11.1","acen"],[59800000,62600000,"q11.1","acen"],[62600000,62700000,"q11.2","gneg"],[62700000,69200000,"q12","gpos100"],[69200000,75200000,"q13","gneg"],[75200000,83200000,"q14.1","gpos50"],[83200000,84200000,"q14.2","gneg"],[84200000,87300000,"q14.3","gpos50"],[87300000,92500000,"q15","gneg"],[92500000,98900000,"q16.1","gpos100"],[98900000,100000000,"q16.2","gneg"],[100000000,105000000,"q16.3","gpos100"],[105000000,114200000,"q21","gneg"],[114200000,117900000,"q22.1","gpos75"],[117900000,118100000,"q22.2","gneg"],[118100000,125800000,"q22.31","gpos100"],[125800000,126800000,"q22.32","gneg"],[126800000,130000000,"q22.33","gpos75"],[130000000,130900000,"q23.1","gneg"],[130900000,134700000,"q23.2","gpos50"],[134700000,138300000,"q23.3","gneg"],[138300000,142200000,"q24.1","gpos75"],[142200000,145100000,"q24.2","gneg"],[145100000,148500000,"q24.3","gpos75"],[148500000,152100000,"q25.1","gneg"],[152100000,155200000,"q25.2","gpos50"],[155200000,160600000,"q25.3","gneg"],[160600000,164100000,"q26","gpos50"],[164100000,170805979,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13700000,"p21.3","gpos100"],[13700000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,27900000,"p15.2","gpos50"],[27900000,28800000,"p15.1","gneg"],[28800000,34900000,"p14.3","gpos75"],[34900000,37100000,"p14.2","gneg"],[37100000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,53900000,"p12.1","gpos75"],[53900000,58100000,"p11.2","gneg"],[58100000,60100000,"p11.1","acen"],[60100000,62100000,"q11.1","acen"],[62100000,67500000,"q11.21","gneg"],[67500000,72700000,"q11.22","gpos50"],[72700000,77900000,"q11.23","gneg"],[77900000,86700000,"q21.11","gpos100"],[86700000,88500000,"q21.12","gneg"],[88500000,91500000,"q21.13","gpos75"],[91500000,93300000,"q21.2","gneg"],[93300000,98400000,"q21.3","gpos75"],[98400000,104200000,"q22.1","gneg"],[104200000,104900000,"q22.2","gpos50"],[104900000,107800000,"q22.3","gneg"],[107800000,115000000,"q31.1","gpos75"],[115000000,117700000,"q31.2","gneg"],[117700000,121400000,"q31.31","gpos75"],[121400000,124100000,"q31.32","gneg"],[124100000,127500000,"q31.33","gpos75"],[127500000,129600000,"q32.1","gneg"],[129600000,130800000,"q32.2","gpos25"],[130800000,132900000,"q32.3","gneg"],[132900000,138500000,"q33","gpos50"],[138500000,143400000,"q34","gneg"],[143400000,148200000,"q35","gpos75"],[148200000,152800000,"q36.1","gneg"],[152800000,155200000,"q36.2","gpos25"],[155200000,159345973,"q36.3","gneg"]],8:[[0,2300000,"p23.3","gneg"],[2300000,6300000,"p23.2","gpos75"],[6300000,12800000,"p23.1","gneg"],[12800000,19200000,"p22","gpos100"],[19200000,23500000,"p21.3","gneg"],[23500000,27500000,"p21.2","gpos50"],[27500000,29000000,"p21.1","gneg"],[29000000,36700000,"p12","gpos75"],[36700000,38500000,"p11.23","gneg"],[38500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,47200000,"q11.1","acen"],[47200000,51300000,"q11.21","gneg"],[51300000,51700000,"q11.22","gpos75"],[51700000,54600000,"q11.23","gneg"],[54600000,60600000,"q12.1","gpos50"],[60600000,61300000,"q12.2","gneg"],[61300000,65100000,"q12.3","gpos50"],[65100000,67100000,"q13.1","gneg"],[67100000,69600000,"q13.2","gpos50"],[69600000,72000000,"q13.3","gneg"],[72000000,74600000,"q21.11","gpos100"],[74600000,74700000,"q21.12","gneg"],[74700000,83500000,"q21.13","gpos75"],[83500000,85900000,"q21.2","gneg"],[85900000,92300000,"q21.3","gpos100"],[92300000,97900000,"q22.1","gneg"],[97900000,100500000,"q22.2","gpos25"],[100500000,105100000,"q22.3","gneg"],[105100000,109500000,"q23.1","gpos75"],[109500000,111100000,"q23.2","gneg"],[111100000,116700000,"q23.3","gpos100"],[116700000,118300000,"q24.11","gneg"],[118300000,121500000,"q24.12","gpos50"],[121500000,126300000,"q24.13","gneg"],[126300000,130400000,"q24.21","gpos50"],[130400000,135400000,"q24.22","gneg"],[135400000,138900000,"q24.23","gpos75"],[138900000,145138636,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,37900000,"p13.2","gpos25"],[37900000,39000000,"p13.1","gneg"],[39000000,40000000,"p12","gpos50"],[40000000,42200000,"p11.2","gneg"],[42200000,43000000,"p11.1","acen"],[43000000,45500000,"q11","acen"],[45500000,61500000,"q12","gvar"],[61500000,65000000,"q13","gneg"],[65000000,69300000,"q21.11","gpos25"],[69300000,71300000,"q21.12","gneg"],[71300000,76600000,"q21.13","gpos50"],[76600000,78500000,"q21.2","gneg"],[78500000,81500000,"q21.31","gpos50"],[81500000,84300000,"q21.32","gneg"],[84300000,87800000,"q21.33","gpos50"],[87800000,89200000,"q22.1","gneg"],[89200000,91200000,"q22.2","gpos25"],[91200000,93900000,"q22.31","gneg"],[93900000,96500000,"q22.32","gpos25"],[96500000,99800000,"q22.33","gneg"],[99800000,105400000,"q31.1","gpos100"],[105400000,108500000,"q31.2","gneg"],[108500000,112100000,"q31.3","gpos25"],[112100000,114900000,"q32","gneg"],[114900000,119800000,"q33.1","gpos75"],[119800000,123100000,"q33.2","gneg"],[123100000,127500000,"q33.3","gpos25"],[127500000,130600000,"q34.11","gneg"],[130600000,131100000,"q34.12","gpos25"],[131100000,133100000,"q34.13","gneg"],[133100000,134500000,"q34.2","gpos25"],[134500000,138394717,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18300000,"p12.33","gpos75"],[18300000,18400000,"p12.32","gneg"],[18400000,22300000,"p12.31","gpos75"],[22300000,24300000,"p12.2","gneg"],[24300000,29300000,"p12.1","gpos50"],[29300000,31100000,"p11.23","gneg"],[31100000,34200000,"p11.22","gpos25"],[34200000,38000000,"p11.21","gneg"],[38000000,39800000,"p11.1","acen"],[39800000,41600000,"q11.1","acen"],[41600000,45500000,"q11.21","gneg"],[45500000,48600000,"q11.22","gpos25"],[48600000,51100000,"q11.23","gneg"],[51100000,59400000,"q21.1","gpos100"],[59400000,62800000,"q21.2","gneg"],[62800000,68800000,"q21.3","gpos100"],[68800000,73100000,"q22.1","gneg"],[73100000,75900000,"q22.2","gpos50"],[75900000,80300000,"q22.3","gneg"],[80300000,86100000,"q23.1","gpos100"],[86100000,87700000,"q23.2","gneg"],[87700000,91100000,"q23.31","gpos75"],[91100000,92300000,"q23.32","gneg"],[92300000,95300000,"q23.33","gpos50"],[95300000,97500000,"q24.1","gneg"],[97500000,100100000,"q24.2","gpos50"],[100100000,101200000,"q24.31","gneg"],[101200000,103100000,"q24.32","gpos25"],[103100000,104000000,"q24.33","gneg"],[104000000,110100000,"q25.1","gpos100"],[110100000,113100000,"q25.2","gneg"],[113100000,117300000,"q25.3","gpos75"],[117300000,119900000,"q26.11","gneg"],[119900000,121400000,"q26.12","gpos50"],[121400000,125700000,"q26.13","gneg"],[125700000,128800000,"q26.2","gpos50"],[128800000,133797422,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,11700000,"p15.4","gpos50"],[11700000,13800000,"p15.3","gneg"],[13800000,16900000,"p15.2","gpos50"],[16900000,22000000,"p15.1","gneg"],[22000000,26200000,"p14.3","gpos100"],[26200000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51000000,"p11.12","gpos75"],[51000000,53400000,"p11.11","acen"],[53400000,55800000,"q11","acen"],[55800000,60100000,"q12.1","gpos75"],[60100000,61900000,"q12.2","gneg"],[61900000,63600000,"q12.3","gpos25"],[63600000,66100000,"q13.1","gneg"],[66100000,68700000,"q13.2","gpos25"],[68700000,70500000,"q13.3","gneg"],[70500000,75500000,"q13.4","gpos50"],[75500000,77400000,"q13.5","gneg"],[77400000,85900000,"q14.1","gpos100"],[85900000,88600000,"q14.2","gneg"],[88600000,93000000,"q14.3","gpos100"],[93000000,97400000,"q21","gneg"],[97400000,102300000,"q22.1","gpos100"],[102300000,103000000,"q22.2","gneg"],[103000000,110600000,"q22.3","gpos100"],[110600000,112700000,"q23.1","gneg"],[112700000,114600000,"q23.2","gpos50"],[114600000,121300000,"q23.3","gneg"],[121300000,124000000,"q24.1","gpos50"],[124000000,127900000,"q24.2","gneg"],[127900000,130900000,"q24.3","gpos50"],[130900000,135086622,"q25","gneg"]],12:[[0,3200000,"p13.33","gneg"],[3200000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14600000,"p13.1","gneg"],[14600000,19800000,"p12.3","gpos100"],[19800000,21100000,"p12.2","gneg"],[21100000,26300000,"p12.1","gpos100"],[26300000,27600000,"p11.23","gneg"],[27600000,30500000,"p11.22","gpos50"],[30500000,33200000,"p11.21","gneg"],[33200000,35500000,"p11.1","acen"],[35500000,37800000,"q11","acen"],[37800000,46000000,"q12","gpos100"],[46000000,48700000,"q13.11","gneg"],[48700000,51100000,"q13.12","gpos25"],[51100000,54500000,"q13.13","gneg"],[54500000,56200000,"q13.2","gpos25"],[56200000,57700000,"q13.3","gneg"],[57700000,62700000,"q14.1","gpos75"],[62700000,64700000,"q14.2","gneg"],[64700000,67300000,"q14.3","gpos50"],[67300000,71100000,"q15","gneg"],[71100000,75300000,"q21.1","gpos75"],[75300000,79900000,"q21.2","gneg"],[79900000,86300000,"q21.31","gpos100"],[86300000,88600000,"q21.32","gneg"],[88600000,92200000,"q21.33","gpos100"],[92200000,95800000,"q22","gneg"],[95800000,101200000,"q23.1","gpos75"],[101200000,103500000,"q23.2","gneg"],[103500000,108600000,"q23.3","gpos50"],[108600000,111300000,"q24.11","gneg"],[111300000,111900000,"q24.12","gpos25"],[111900000,113900000,"q24.13","gneg"],[113900000,116400000,"q24.21","gpos50"],[116400000,117700000,"q24.22","gneg"],[117700000,120300000,"q24.23","gpos50"],[120300000,125400000,"q24.31","gneg"],[125400000,128700000,"q24.32","gpos50"],[128700000,133275309,"q24.33","gneg"]],13:[[0,4600000,"p13","gvar"],[4600000,10100000,"p12","stalk"],[10100000,16500000,"p11.2","gvar"],[16500000,17700000,"p11.1","acen"],[17700000,18900000,"q11","acen"],[18900000,22600000,"q12.11","gneg"],[22600000,24900000,"q12.12","gpos25"],[24900000,27200000,"q12.13","gneg"],[27200000,28300000,"q12.2","gpos25"],[28300000,31600000,"q12.3","gneg"],[31600000,33400000,"q13.1","gpos50"],[33400000,34900000,"q13.2","gneg"],[34900000,39500000,"q13.3","gpos75"],[39500000,44600000,"q14.11","gneg"],[44600000,45200000,"q14.12","gpos25"],[45200000,46700000,"q14.13","gneg"],[46700000,50300000,"q14.2","gpos50"],[50300000,54700000,"q14.3","gneg"],[54700000,59000000,"q21.1","gpos100"],[59000000,61800000,"q21.2","gneg"],[61800000,65200000,"q21.31","gpos75"],[65200000,68100000,"q21.32","gneg"],[68100000,72800000,"q21.33","gpos100"],[72800000,74900000,"q22.1","gneg"],[74900000,76700000,"q22.2","gpos50"],[76700000,78500000,"q22.3","gneg"],[78500000,87100000,"q31.1","gpos100"],[87100000,89400000,"q31.2","gneg"],[89400000,94400000,"q31.3","gpos100"],[94400000,97500000,"q32.1","gneg"],[97500000,98700000,"q32.2","gpos25"],[98700000,101100000,"q32.3","gneg"],[101100000,104200000,"q33.1","gpos100"],[104200000,106400000,"q33.2","gneg"],[106400000,109600000,"q33.3","gpos100"],[109600000,114364328,"q34","gneg"]],14:[[0,3600000,"p13","gvar"],[3600000,8000000,"p12","stalk"],[8000000,16100000,"p11.2","gvar"],[16100000,17200000,"p11.1","acen"],[17200000,18200000,"q11.1","acen"],[18200000,24100000,"q11.2","gneg"],[24100000,32900000,"q12","gpos100"],[32900000,34800000,"q13.1","gneg"],[34800000,36100000,"q13.2","gpos50"],[36100000,37400000,"q13.3","gneg"],[37400000,43000000,"q21.1","gpos100"],[43000000,46700000,"q21.2","gneg"],[46700000,50400000,"q21.3","gpos100"],[50400000,53600000,"q22.1","gneg"],[53600000,55000000,"q22.2","gpos25"],[55000000,57600000,"q22.3","gneg"],[57600000,61600000,"q23.1","gpos75"],[61600000,64300000,"q23.2","gneg"],[64300000,67400000,"q23.3","gpos50"],[67400000,69800000,"q24.1","gneg"],[69800000,73300000,"q24.2","gpos50"],[73300000,78800000,"q24.3","gneg"],[78800000,83100000,"q31.1","gpos100"],[83100000,84400000,"q31.2","gneg"],[84400000,89300000,"q31.3","gpos100"],[89300000,91400000,"q32.11","gneg"],[91400000,94200000,"q32.12","gpos25"],[94200000,95800000,"q32.13","gneg"],[95800000,100900000,"q32.2","gpos50"],[100900000,102700000,"q32.31","gneg"],[102700000,103500000,"q32.32","gpos50"],[103500000,107043718,"q32.33","gneg"]],15:[[0,4200000,"p13","gvar"],[4200000,9700000,"p12","stalk"],[9700000,17500000,"p11.2","gvar"],[17500000,19000000,"p11.1","acen"],[19000000,20500000,"q11.1","acen"],[20500000,25500000,"q11.2","gneg"],[25500000,27800000,"q12","gpos50"],[27800000,30000000,"q13.1","gneg"],[30000000,30900000,"q13.2","gpos50"],[30900000,33400000,"q13.3","gneg"],[33400000,39800000,"q14","gpos75"],[39800000,42500000,"q15.1","gneg"],[42500000,43300000,"q15.2","gpos25"],[43300000,44500000,"q15.3","gneg"],[44500000,49200000,"q21.1","gpos75"],[49200000,52600000,"q21.2","gneg"],[52600000,58800000,"q21.3","gpos75"],[58800000,59000000,"q22.1","gneg"],[59000000,63400000,"q22.2","gpos25"],[63400000,66900000,"q22.31","gneg"],[66900000,67000000,"q22.32","gpos25"],[67000000,67200000,"q22.33","gneg"],[67200000,72400000,"q23","gpos25"],[72400000,74900000,"q24.1","gneg"],[74900000,76300000,"q24.2","gpos25"],[76300000,78000000,"q24.3","gneg"],[78000000,81400000,"q25.1","gpos50"],[81400000,84700000,"q25.2","gneg"],[84700000,88500000,"q25.3","gpos50"],[88500000,93800000,"q26.1","gneg"],[93800000,98000000,"q26.2","gpos50"],[98000000,101991189,"q26.3","gneg"]],16:[[0,7800000,"p13.3","gneg"],[7800000,10400000,"p13.2","gpos50"],[10400000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28500000,"p12.1","gpos50"],[28500000,35300000,"p11.2","gneg"],[35300000,36800000,"p11.1","acen"],[36800000,38400000,"q11.1","acen"],[38400000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56000000,"q12.2","gpos50"],[56000000,57300000,"q13","gneg"],[57300000,66600000,"q21","gpos100"],[66600000,70800000,"q22.1","gneg"],[70800000,72800000,"q22.2","gpos50"],[72800000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81600000,"q23.2","gneg"],[81600000,84100000,"q23.3","gpos50"],[84100000,87000000,"q24.1","gneg"],[87000000,88700000,"q24.2","gpos25"],[88700000,90338345,"q24.3","gneg"]],17:[[0,3400000,"p13.3","gneg"],[3400000,6500000,"p13.2","gpos50"],[6500000,10800000,"p13.1","gneg"],[10800000,16100000,"p12","gpos75"],[16100000,22700000,"p11.2","gneg"],[22700000,25100000,"p11.1","acen"],[25100000,27400000,"q11.1","acen"],[27400000,33500000,"q11.2","gneg"],[33500000,39800000,"q12","gpos50"],[39800000,40200000,"q21.1","gneg"],[40200000,42800000,"q21.2","gpos25"],[42800000,46800000,"q21.31","gneg"],[46800000,49300000,"q21.32","gpos25"],[49300000,52100000,"q21.33","gneg"],[52100000,59500000,"q22","gpos75"],[59500000,60200000,"q23.1","gneg"],[60200000,63100000,"q23.2","gpos75"],[63100000,64600000,"q23.3","gneg"],[64600000,66200000,"q24.1","gpos50"],[66200000,69100000,"q24.2","gneg"],[69100000,72900000,"q24.3","gpos75"],[72900000,76800000,"q25.1","gneg"],[76800000,77200000,"q25.2","gpos25"],[77200000,83257441,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,18500000,"p11.1","acen"],[18500000,21500000,"q11.1","acen"],[21500000,27500000,"q11.2","gneg"],[27500000,35100000,"q12.1","gpos100"],[35100000,39500000,"q12.2","gneg"],[39500000,45900000,"q12.3","gpos75"],[45900000,50700000,"q21.1","gneg"],[50700000,56200000,"q21.2","gpos75"],[56200000,58600000,"q21.31","gneg"],[58600000,61300000,"q21.32","gpos50"],[61300000,63900000,"q21.33","gneg"],[63900000,69100000,"q22.1","gpos100"],[69100000,71000000,"q22.2","gneg"],[71000000,75400000,"q22.3","gpos25"],[75400000,80373285,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19900000,"p13.11","gneg"],[19900000,24200000,"p12","gvar"],[24200000,26200000,"p11","acen"],[26200000,28100000,"q11","acen"],[28100000,31900000,"q12","gvar"],[31900000,35100000,"q13.11","gneg"],[35100000,37800000,"q13.12","gpos25"],[37800000,38200000,"q13.13","gneg"],[38200000,42900000,"q13.2","gpos25"],[42900000,44700000,"q13.31","gneg"],[44700000,47500000,"q13.32","gpos25"],[47500000,50900000,"q13.33","gneg"],[50900000,53100000,"q13.41","gpos25"],[53100000,55800000,"q13.42","gneg"],[55800000,58617616,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12000000,"p12.2","gneg"],[12000000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,28100000,"p11.1","acen"],[28100000,30400000,"q11.1","acen"],[30400000,33500000,"q11.21","gneg"],[33500000,35800000,"q11.22","gpos25"],[35800000,39000000,"q11.23","gneg"],[39000000,43100000,"q12","gpos75"],[43100000,43500000,"q13.11","gneg"],[43500000,47800000,"q13.12","gpos25"],[47800000,51200000,"q13.13","gneg"],[51200000,56400000,"q13.2","gpos75"],[56400000,57800000,"q13.31","gneg"],[57800000,59700000,"q13.32","gpos50"],[59700000,64444167,"q13.33","gneg"]],21:[[0,3100000,"p13","gvar"],[3100000,7000000,"p12","stalk"],[7000000,10900000,"p11.2","gvar"],[10900000,12000000,"p11.1","acen"],[12000000,13000000,"q11.1","acen"],[13000000,15000000,"q11.2","gneg"],[15000000,22600000,"q21.1","gpos100"],[22600000,25500000,"q21.2","gneg"],[25500000,30200000,"q21.3","gpos75"],[30200000,34400000,"q22.11","gneg"],[34400000,36400000,"q22.12","gpos50"],[36400000,38300000,"q22.13","gneg"],[38300000,41200000,"q22.2","gpos50"],[41200000,46709983,"q22.3","gneg"]],22:[[0,4300000,"p13","gvar"],[4300000,9400000,"p12","stalk"],[9400000,13700000,"p11.2","gvar"],[13700000,15000000,"p11.1","acen"],[15000000,17400000,"q11.1","acen"],[17400000,21700000,"q11.21","gneg"],[21700000,23100000,"q11.22","gpos25"],[23100000,25500000,"q11.23","gneg"],[25500000,29200000,"q12.1","gpos50"],[29200000,31800000,"q12.2","gneg"],[31800000,37200000,"q12.3","gpos50"],[37200000,40600000,"q13.1","gneg"],[40600000,43800000,"q13.2","gpos50"],[43800000,48100000,"q13.31","gneg"],[48100000,49100000,"q13.32","gpos50"],[49100000,50818468,"q13.33","gneg"]],X:[[0,4400000,"p22.33","gneg"],[4400000,6100000,"p22.32","gpos50"],[6100000,9600000,"p22.31","gneg"],[9600000,17400000,"p22.2","gpos50"],[17400000,19200000,"p22.13","gneg"],[19200000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37800000,"p21.1","gpos100"],[37800000,42500000,"p11.4","gneg"],[42500000,47600000,"p11.3","gpos75"],[47600000,50100000,"p11.23","gneg"],[50100000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,61000000,"p11.1","acen"],[61000000,63800000,"q11.1","acen"],[63800000,65400000,"q11.2","gneg"],[65400000,68500000,"q12","gpos50"],[68500000,73000000,"q13.1","gneg"],[73000000,74700000,"q13.2","gpos50"],[74700000,76800000,"q13.3","gneg"],[76800000,85400000,"q21.1","gpos100"],[85400000,87000000,"q21.2","gneg"],[87000000,92700000,"q21.31","gpos100"],[92700000,94300000,"q21.32","gneg"],[94300000,99100000,"q21.33","gpos75"],[99100000,103300000,"q22.1","gneg"],[103300000,104500000,"q22.2","gpos50"],[104500000,109400000,"q22.3","gneg"],[109400000,117400000,"q23","gpos75"],[117400000,121800000,"q24","gneg"],[121800000,129500000,"q25","gpos100"],[129500000,131300000,"q26.1","gneg"],[131300000,134500000,"q26.2","gpos25"],[134500000,138900000,"q26.3","gneg"],[138900000,141200000,"q27.1","gpos75"],[141200000,143000000,"q27.2","gneg"],[143000000,148000000,"q27.3","gpos100"],[148000000,156040895,"q28","gneg"]],Y:[[0,300000,"p11.32","gneg"],[300000,600000,"p11.31","gpos50"],[600000,10300000,"p11.2","gneg"],[10300000,10400000,"p11.1","acen"],[10400000,10600000,"q11.1","acen"],[10600000,12400000,"q11.21","gneg"],[12400000,17100000,"q11.221","gpos50"],[17100000,19600000,"q11.222","gneg"],[19600000,23800000,"q11.223","gpos50"],[23800000,26600000,"q11.23","gneg"],[26600000,57227415,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Fish:["Fish"],Gantt:["Gantt"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Meter:["Meter"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],CombinationLineGraphs:["AreaLine","BarLine","DotLine","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Fish","Gantt","Meter","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],AttGraphs:["Bar","BarLine","Boxplot","Dotplot","Treemap","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","ParallelCoordinates","Line","Sankey","Tree","TagCloud","Gantt"],NoneDGraphs:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn"],NonSegregatable:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Circular","Gantt"]};CanvasXpress.colorNames={aliceblue:"f0f8ff",antiquewhite1:"ffefdb",antiquewhite2:"eedfcc",antiquewhite3:"cdc0b0",antiquewhite4:"8b8378",antiquewhite:"faebd7",aqua:"00ffff",aquamarine1:"7fffd4",aquamarine2:"76eec6",aquamarine4:"458b74",aquamarine:"7fffd4",azure1:"f0ffff",azure2:"e0eeee",azure3:"c1cdcd",azure4:"838b8b",azure:"f0ffff",beige:"f5f5dc",bisque1:"ffe4c4",bisque2:"eed5b7",bisque3:"cdb79e",bisque4:"8b7d6b",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blue1:"0000ff",blue2:"0000ee",blue3:"1874cd",blue4:"00008b",blueviolet:"8a2be2",brown1:"ff4040",brown2:"ee3b3b",brown3:"cd3333",brown4:"8b2323",brown:"a52a2a",burlywood1:"ffd39b",burlywood2:"eec591",burlywood3:"cdaa7d",burlywood4:"8b7355",burlywood:"deb887",cadetblue1:"98f5ff",cadetblue2:"8ee5ee",cadetblue3:"7ac5cd",cadetblue4:"53868b",cadetblue:"5f9ea0",chartreuse1:"7fff00",chartreuse2:"76ee00",chartreuse3:"66cd00",chartreuse4:"458b00",chartreuse:"7fff00",chocolate1:"ff7f24",chocolate2:"ee7621",chocolate3:"cd661d",chocolate:"d2691e",coral1:"ff7256",coral2:"ee6a50",coral3:"cd5b45",coral4:"8b3e2f",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk1:"fff8dc",cornsilk2:"eee8cd",cornsilk3:"cdc8b1",cornsilk4:"8b8878",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",cyan1:"00ffff",cyan2:"00eeee",cyan3:"00cdcd",cyan4:"008b8b",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod1:"ffb90f",darkgoldenrod2:"eead0e",darkgoldenrod3:"cd950c",darkgoldenrod4:"8b6508",darkgoldenrod4:"8b6508",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen1:"caff70",darkolivegreen2:"bcee68",darkolivegreen3:"a2cd5a",darkolivegreen4:"6e8b3d",darkolivegreen:"556b2f",darkorange1:"ff7f00",darkorange2:"ee7600",darkorange3:"cd6600",darkorange4:"8b4500",darkorange:"ff8c00",darkorchid1:"bf3eff",darkorchid2:"b23aee",darkorchid3:"9a32cd",darkorchid4:"68228b",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen1:"c1ffc1",darkseagreen2:"b4eeb4",darkseagreen3:"9bcd9b",darkseagreen4:"698b69",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray1:"97ffff",darkslategray2:"8deeee",darkslategray:"2f4f4f",darkslategray3:"79cdcd",darkslategray4:"528b8b",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink1:"ff1493",deeppink2:"ee1289",deeppink3:"cd1076",deeppink4:"8b0a50",deeppink:"ff1493",deepskyblue:"00bfff",deepskyblue1:"00bfff",deepskyblue2:"00b2ee",deepskyblue3:"009acd",deepskyblue4:"00688b",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1e90ff",dodgerblue:"1e90ff",dodgerblue2:"1c86ee",dodgerblue3:"1874cd",dodgerblue4:"104e8b",firebrick1:"ff3030",firebrick2:"ee2c2c",firebrick3:"cd2626",firebrick4:"8b1a1a",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold1:"ffd700",gold2:"eec900",gold3:"cdad00",gold4:"8b7500",goldenrod1:"ffc125",goldenrod2:"eeb422",goldenrod3:"cd9b1d",goldenrod4:"8b6914",goldenrod:"daa520",goldenrod:"daa520",gold:"ffd700",gray10:"1a1a1a",gray1:"030303",gray11:"1c1c1c",gray12:"1f1f1f",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2b2b2b",gray18:"2e2e2e",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3b3b3b",gray24:"3d3d3d",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4a4a4a",gray30:"4d4d4d",gray3:"080808",gray31:"4f4f4f",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5c5c5c",gray37:"5e5e5e",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0a0a0a",gray41:"696969",gray42:"6b6b6b",gray43:"6e6e6e",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7a7a7a",gray49:"7d7d7d",gray50:"7f7f7f",gray5:"0d0d0d",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8a8a8a",gray55:"8c8c8c",gray56:"8f8f8f",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0f0f0f",gray61:"9c9c9c",gray62:"9e9e9e",gray63:"a1a1a1",gray64:"a3a3a3",gray65:"a6a6a6",gray66:"a8a8a8",gray67:"ababab",gray68:"adadad",gray69:"b0b0b0",gray70:"b3b3b3",gray7:"121212",gray71:"b5b5b5",gray72:"b8b8b8",gray73:"bababa",gray74:"bdbdbd",gray75:"bfbfbf",gray76:"c2c2c2",gray77:"c4c4c4",gray78:"c7c7c7",gray79:"c9c9c9",gray:"808080",gray80:"cccccc",gray8:"141414",gray81:"cfcfcf",gray82:"d1d1d1",gray83:"d4d4d4",gray84:"d6d6d6",gray85:"d9d9d9",gray86:"dbdbdb",gray87:"dedede",gray88:"e0e0e0",gray89:"e3e3e3",gray90:"e5e5e5",gray9:"171717",gray91:"e8e8e8",gray92:"ebebeb",gray93:"ededed",gray94:"f0f0f0",gray95:"f2f2f2",gray97:"f7f7f7",gray98:"fafafa",gray99:"fcfcfc",gray:"bebebe",green:"008000",green1:"00ff00",green2:"00ee00",green3:"00cd00",green4:"008b00",greenyellow:"adff2f",grey:"808080",honeydew1:"f0fff0",honeydew2:"e0eee0",honeydew3:"c1cdc1",honeydew4:"838b83",honeydew:"f0fff0",hotpink1:"ff6eb4",hotpink2:"ee6aa7",hotpink3:"cd6090",hotpink4:"8b3a62",hotpink:"ff69b4",indianred1:"ff6a6a",indianred2:"ee6363",indianred3:"cd5555",indianred4:"8b3a3a",indianred:"cd5c5c",indigo:"4b0082",ivory1:"fffff0",ivory2:"eeeee0",ivory3:"cdcdc1",ivory4:"8b8b83",ivory:"fffff0",khaki1:"fff68f",khaki2:"eee685",khaki3:"cdc673",khaki4:"8b864e",khaki:"f0e68c",lavenderblush1:"fff0f5",lavenderblush2:"eee0e5",lavenderblush3:"cdc1c5",lavenderblush4:"8b8386",lavenderblush:"fff0f5",lavender:"e6e6fa",lawngreen:"7cfc00",lemonchiffon1:"fffacd",lemonchiffon2:"eee9bf",lemonchiffon3:"cdc9a5",lemonchiffon4:"8b8970",lemonchiffon:"fffacd",lightblue1:"bfefff",lightblue2:"b2dfee",lightblue3:"9ac0cd",lightblue4:"68838b",lightblue:"add8e6",lightcoral:"f08080",lightcyan1:"e0ffff",lightcyan2:"d1eeee",lightcyan3:"b4cdcd",lightcyan4:"7a8b8b",lightcyan:"e0ffff",light:"eedd82",lightgoldenrod1:"ffec8b",lightgoldenrod2:"eedc82",lightgoldenrod3:"cdbe70",lightgoldenrod4:"8b814c",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink1:"ffaeb9",lightpink2:"eea2ad",lightpink3:"cd8c95",lightpink4:"8b5f65",lightpink:"ffb6c1",lightsalmon1:"ffa07a",lightsalmon2:"ee9572",lightsalmon3:"cd8162",lightsalmon4:"8b5742",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue1:"b0e2ff",lightskyblue2:"a4d3ee",lightskyblue3:"8db6cd",lightskyblue4:"607b8b",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"cae1ff",lightsteelblue2:"bcd2ee",lightsteelblue3:"a2b5cd",lightsteelblue4:"6e7b8b",lightsteelblue:"b0c4de",lightyellow1:"ffffe0",lightyellow2:"eeeed1",lightyellow3:"cdcdb4",lightyellow4:"8b8b7a",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta2:"ee00ee",magenta3:"cd00cd",magenta4:"8b008b",magenta:"ff00ff",maroon1:"ff34b3",maroon2:"ee30a7",maroon3:"cd2990",maroon4:"8b1c62",maroon:"800000",maroon:"b03060",medium:"66cdaa",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid1:"e066ff",mediumorchid2:"d15fee",mediumorchid3:"b452cd",mediumorchid4:"7a378b",mediumorchid:"ba55d3",mediumpurple1:"ab82ff",mediumpurple2:"9f79ee",mediumpurple3:"8968cd",mediumpurple4:"5d478b",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose1:"ffe4e1",mistyrose2:"eed5d2",mistyrose3:"cdb7b5",mistyrose4:"8b7d7b",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite1:"ffdead",navajowhite2:"eecfa1",navajowhite3:"cdb38b",navajowhite4:"8b795e",navajowhite:"ffdead",navy:"000080",navyblue:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab1:"c0ff3e",olivedrab2:"b3ee3a",olivedrab4:"698b22",olivedrab:"6b8e23",orange1:"ffa500",orange2:"ee9a00",orange3:"cd8500",orange4:"8b5a00",orange:"ffa500",orangered1:"ff4500",orangered2:"ee4000",orangered3:"cd3700",orangered4:"8b2500",orangered:"ff4500",orchid1:"ff83fa",orchid2:"ee7ae9",orchid3:"cd69c9",orchid4:"8b4789",orchid:"da70d6",pale:"db7093",palegoldenrod:"eee8aa",palegreen1:"9aff9a",palegreen2:"90ee90",palegreen3:"7ccd7c",palegreen4:"548b54",palegreen:"98fb98",paleturquoise1:"bbffff",paleturquoise2:"aeeeee",paleturquoise3:"96cdcd",paleturquoise4:"668b8b",paleturquoise:"afeeee",palevioletred1:"ff82ab",palevioletred2:"ee799f",palevioletred3:"cd6889",palevioletred4:"8b475d",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff1:"ffdab9",peachpuff2:"eecbad",peachpuff3:"cdaf95",peachpuff4:"8b7765",peachpuff:"ffdab9",peru:"cd853f",pink1:"ffb5c5",pink2:"eea9b8",pink3:"cd919e",pink4:"8b636c",pink:"ffc0cb",plum1:"ffbbff",plum2:"eeaeee",plum3:"cd96cd",plum4:"8b668b",plum:"dda0dd",powderblue:"b0e0e6",purple1:"9b30ff",purple2:"912cee",purple3:"7d26cd",purple4:"551a8b",purple:"800080",purple:"a020f0",rebeccapurple:"663399",red1:"ff0000",red2:"ee0000",red3:"cd0000",red4:"8b0000",red:"ff0000",rosybrown1:"ffc1c1",rosybrown2:"eeb4b4",rosybrown3:"cd9b9b",rosybrown4:"8b6969",rosybrown:"bc8f8f",royalblue1:"4876ff",royalblue2:"436eee",royalblue3:"3a5fcd",royalblue:"4169e1",royalblue4:"27408b",saddlebrown:"8b4513",salmon1:"ff8c69",salmon2:"ee8262",salmon3:"cd7054",salmon4:"8b4c39",salmon:"fa8072",sandybrown:"f4a460",seagreen1:"54ff9f",seagreen2:"4eee94",seagreen:"2e8b57",seagreen3:"43cd80",seagreen4:"2e8b57",seashell1:"fff5ee",seashell2:"eee5de",seashell3:"cdc5bf",seashell4:"8b8682",seashell:"fff5ee",sienna1:"ff8247",sienna2:"ee7942",sienna3:"cd6839",sienna4:"8b4726",sienna:"a0522d",silver:"c0c0c0",skyblue1:"87ceff",skyblue2:"7ec0ee",skyblue3:"6ca6cd",skyblue4:"4a708b",skyblue:"87ceeb",slateblue1:"836fff",slateblue2:"7a67ee",slateblue3:"6959cd",slateblue4:"473c8b",slateblue:"6a5acd",slategray1:"c6e2ff",slategray2:"b9d3ee",slategray3:"9fb6cd",slategray4:"6c7b8b",slategray:"708090",slategrey:"708090",snow1:"fffafa",snow2:"eee9e9",snow3:"cdc9c9",snow4:"8b8989",snow:"fffafa",springgreen:"00ff7f",springgreen1:"00ff7f",springgreen2:"00ee76",springgreen3:"00cd66",springgreen4:"008b45",steelblue1:"63b8ff",steelblue2:"5cacee",steelblue3:"4f94cd",steelblue4:"36648b",steelblue:"4682b4",tan1:"ffa54f",tan2:"ee9a49",tan3:"cd853f",tan4:"8b5a2b",tan:"d2b48c",teal:"008080",thistle1:"ffe1ff",thistle2:"eed2ee",thistle3:"cdb5cd",thistle4:"8b7b8b",thistle:"d8bfd8",tomato1:"ff6347",tomato2:"ee5c42",tomato3:"cd4f39",tomato4:"8b3626",tomato:"ff6347",turquoise1:"00f5ff",turquoise2:"00e5ee",turquoise3:"00c5cd",turquoise4:"00868b",turquoise:"40e0d0",violet:"ee82ee",violetred1:"ff3e96",violetred2:"ee3a8c",violetred3:"cd3278",violetred4:"8b2252",violetred:"d02090",wheat1:"ffe7ba",wheat2:"eed8ae",wheat3:"cdba96",wheat4:"8b7e66",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow1:"ffff00",yellow2:"eeee00",yellow3:"cdcd00",yellow4:"8b8b00",yellow:"ffff00",yellowgreen:"9acd32"};CanvasXpress.setColorSchemes=function(){CanvasXpress.colorSchemes={YlGn:{3:"f7fcb9addd8e31a354",4:"ffffccc2e69978c679238443",5:"ffffccc2e69978c67931a354006837",6:"ffffccd9f0a3addd8e78c67931a354006837",7:"ffffccd9f0a3addd8e78c67941ab5d238443005a32",8:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32",9:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529"},YlGnBu:{3:"edf8b17fcdbb2c7fb8",4:"ffffcca1dab441b6c4225ea8",5:"ffffcca1dab441b6c42c7fb8253494",6:"ffffccc7e9b47fcdbb41b6c42c7fb8253494",7:"ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84",8:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84",9:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58"},GnBu:{3:"e0f3dba8ddb543a2ca",4:"f0f9e8bae4bc7bccc42b8cbe",5:"f0f9e8bae4bc7bccc443a2ca0868ac",6:"f0f9e8ccebc5a8ddb57bccc443a2ca0868ac",7:"f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e",8:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e",9:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081"},BuGn:{3:"e5f5f999d8c92ca25f",4:"edf8fbb2e2e266c2a4238b45",5:"edf8fbb2e2e266c2a42ca25f006d2c",6:"edf8fbccece699d8c966c2a42ca25f006d2c",7:"edf8fbccece699d8c966c2a441ae76238b45005824",8:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824",9:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b"},PuBuGn:{3:"ece2f0a6bddb1c9099",4:"f6eff7bdc9e167a9cf02818a",5:"f6eff7bdc9e167a9cf1c9099016c59",6:"f6eff7d0d1e6a6bddb67a9cf1c9099016c59",7:"f6eff7d0d1e6a6bddb67a9cf3690c002818a016450",8:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450",9:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636"},PuBu:{3:"ece7f2a6bddb2b8cbe",4:"f1eef6bdc9e174a9cf0570b0",5:"f1eef6bdc9e174a9cf2b8cbe045a8d",6:"f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d",7:"f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b",8:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b",9:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858"},BuPu:{3:"e0ecf49ebcda8856a7",4:"edf8fbb3cde38c96c688419d",5:"edf8fbb3cde38c96c68856a7810f7c",6:"edf8fbbfd3e69ebcda8c96c68856a7810f7c",7:"edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",8:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",9:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"},RdPu:{3:"fde0ddfa9fb5c51b8a",4:"feebe2fbb4b9f768a1ae017e",5:"feebe2fbb4b9f768a1c51b8a7a0177",6:"feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",7:"feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",8:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",9:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"},PuRd:{3:"e7e1efc994c7dd1c77",4:"f1eef6d7b5d8df65b0ce1256",5:"f1eef6d7b5d8df65b0dd1c77980043",6:"f1eef6d4b9dac994c7df65b0dd1c77980043",7:"f1eef6d4b9dac994c7df65b0e7298ace125691003f",8:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f",9:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f"},OrRd:{3:"fee8c8fdbb84e34a33",4:"fef0d9fdcc8afc8d59d7301f",5:"fef0d9fdcc8afc8d59e34a33b30000",6:"fef0d9fdd49efdbb84fc8d59e34a33b30000",7:"fef0d9fdd49efdbb84fc8d59ef6548d7301f990000",8:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000",9:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000"},YlOrRd:{3:"ffeda0feb24cf03b20",4:"ffffb2fecc5cfd8d3ce31a1c",5:"ffffb2fecc5cfd8d3cf03b20bd0026",6:"ffffb2fed976feb24cfd8d3cf03b20bd0026",7:"ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026",8:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026",9:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026"},YlOrBr:{3:"fff7bcfec44fd95f0e",4:"ffffd4fed98efe9929cc4c02",5:"ffffd4fed98efe9929d95f0e993404",6:"ffffd4fee391fec44ffe9929d95f0e993404",7:"ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",8:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",9:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"},Purples:{3:"efedf5bcbddc756bb1",4:"f2f0f7cbc9e29e9ac86a51a3",5:"f2f0f7cbc9e29e9ac8756bb154278f",6:"f2f0f7dadaebbcbddc9e9ac8756bb154278f",7:"f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486",8:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486",9:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d"},Blues:{3:"deebf79ecae13182bd",4:"eff3ffbdd7e76baed62171b5",5:"eff3ffbdd7e76baed63182bd08519c",6:"eff3ffc6dbef9ecae16baed63182bd08519c",7:"eff3ffc6dbef9ecae16baed64292c62171b5084594",8:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594",9:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b"},Greens:{3:"e5f5e0a1d99b31a354",4:"edf8e9bae4b374c476238b45",5:"edf8e9bae4b374c47631a354006d2c",6:"edf8e9c7e9c0a1d99b74c47631a354006d2c",7:"edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32",8:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32",9:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b"},Oranges:{3:"fee6cefdae6be6550d",4:"feeddefdbe85fd8d3cd94701",5:"feeddefdbe85fd8d3ce6550da63603",6:"feeddefdd0a2fdae6bfd8d3ce6550da63603",7:"feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04",8:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04",9:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704"},Reds:{3:"fee0d2fc9272de2d26",4:"fee5d9fcae91fb6a4acb181d",5:"fee5d9fcae91fb6a4ade2d26a50f15",6:"fee5d9fcbba1fc9272fb6a4ade2d26a50f15",7:"fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d",8:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d",9:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d"},Greys:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000",256:"fffffffffffffefefefefefefdfdfdfdfdfdfcfcfcfcfcfcfbfbfbfbfbfbfafafafafafaf9f9f9f9f9f9f9f9f9f8f8f8f8f8f8f7f7f7f7f7f7f6f6f6f6f6f6f5f5f5f5f5f5f4f4f4f4f4f4f3f3f3f3f3f3f2f2f2f2f2f2f1f1f1f1f1f1f0f0f0f0f0f0efefefefefefeeeeeeeeeeeeededededededececececececebebebebebebeaeaeaeaeaeae9e9e9e9e9e9e8e8e8e8e8e8e7e7e7e7e7e7e6e6e6e6e6e6e5e5e5e5e5e5e4e4e4e4e4e4e3e3e3e3e3e3e2e2e2e2e2e2e1e1e1e1e1e1e0e0e0e0e0e0dfdfdfdfdfdfdedededddddddddddddcdcdcdcdcdcdbdbdbdbdbdbdadadadadadad9d9d9d9d9d9d8d8d8d7d7d7d7d7d7d6d6d6d6d6d6d5d5d5d5d5d5d4d4d4d4d4d4d3d3d3d2d2d2d2d2d2d1d1d1d1d1d1d0d0d0cfcfcfcfcfcfcececececececdcdcdcdcdcdcccccccbcbcbcbcbcbcacacacacacac9c9c9c8c8c8c8c8c8c7c7c7c7c7c7c6c6c6c5c5c5c5c5c5c4c4c4c3c3c3c3c3c3c2c2c2c2c2c2c1c1c1c0c0c0c0c0c0bfbfbfbebebebebebebdbdbdbcbcbcbcbcbcbbbbbbbabababababab9b9b9b8b8b8b8b8b8b7b7b7b6b6b6b6b6b6b5b5b5b4b4b4b4b4b4b3b3b3b2b2b2b2b2b2b1b1b1b0b0b0afafafafafafaeaeaeadadadadadadacacacabababaaaaaaaaaaaaa9a9a9a8a8a8a7a7a7a7a7a7a6a6a6a5a5a5a4a4a4a4a4a4a3a3a3a2a2a2a1a1a1a0a0a0a0a0a09f9f9f9e9e9e9d9d9d9c9c9c9c9c9c9b9b9b9a9a9a9999999898989797979797979696969595959494949393939292929191919090909090908f8f8f8e8e8e8d8d8d8c8c8c8b8b8b8a8a8a8989898888888787878686868585858484848383838282828181818080807f7f7f7e7e7e7d7d7d7c7c7c7b7b7b7a7a7a7878787777777676767575757474747373737272727070706f6f6f6e6e6e6d6d6d6b6b6b6a6a6a6969696767676666666565656363636262626060605f5f5f5d5d5d5c5c5c5a5a5a5959595757575555555454545252525050504e4e4e4c4c4c4a4a4a4848484646464444444242424040403d3d3d3b3b3b3838383535353232322e2e2e2b2b2b2727272222221c1c1c15151500000"},PuOr:{3:"f1a340f7f7f7998ec3",4:"e66101fdb863b2abd25e3c99",5:"e66101fdb863f7f7f7b2abd25e3c99",6:"b35806f1a340fee0b6d8daeb998ec3542788",7:"b35806f1a340fee0b6f7f7f7d8daeb998ec3542788",8:"b35806e08214fdb863fee0b6d8daebb2abd28073ac542788",9:"b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac542788",10:"7f3b08b35806e08214fdb863fee0b6d8daebb2abd28073ac5427882d004b",11:"7f3b08b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac5427882d004b"},BrBG:{3:"d8b365f5f5f55ab4ac",4:"a6611adfc27d80cdc1018571",5:"a6611adfc27df5f5f580cdc1018571",6:"8c510ad8b365f6e8c3c7eae55ab4ac01665e",7:"8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e",8:"8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e",9:"8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e",10:"5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30",11:"5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30"},PRGn:{3:"af8dc3f7f7f77fbf7b",4:"7b3294c2a5cfa6dba0008837",5:"7b3294c2a5cff7f7f7a6dba0008837",6:"762a83af8dc3e7d4e8d9f0d37fbf7b1b7837",7:"762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837",8:"762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837",9:"762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837",10:"40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b",11:"40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b"},PiYG:{3:"e9a3c9f7f7f7a1d76a",4:"d01c8bf1b6dab8e1864dac26",5:"d01c8bf1b6daf7f7f7b8e1864dac26",6:"c51b7de9a3c9fde0efe6f5d0a1d76a4d9221",7:"c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221",8:"c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221",9:"c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221",10:"8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419",11:"8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419"},RdBu:{3:"ef8a62f7f7f767a9cf",4:"ca0020f4a58292c5de0571b0",5:"ca0020f4a582f7f7f792c5de0571b0",6:"b2182bef8a62fddbc7d1e5f067a9cf2166ac",7:"b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",8:"b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",9:"b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",10:"67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",11:"67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"},RdGy:{3:"ef8a62ffffff999999",4:"ca0020f4a582bababa404040",5:"ca0020f4a582ffffffbababa404040",6:"b2182bef8a62fddbc7e0e0e09999994d4d4d",7:"b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d",8:"b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d",9:"b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d",10:"67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a",11:"67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a"},RdYlBu:{3:"fc8d59ffffbf91bfdb",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},Spectral:{3:"fc8d59ffffbf99d594",4:"d7191cfdae61abdda42b83ba",5:"d7191cfdae61ffffbfabdda42b83ba",6:"d53e4ffc8d59fee08be6f59899d5943288bd",7:"d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",8:"d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",9:"d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",10:"9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",11:"9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"},RdYlGn:{3:"fc8d59ffffbf91cf60",4:"d7191cfdae61a6d96a1a9641",5:"d7191cfdae61ffffbfa6d96a1a9641",6:"d73027fc8d59fee08bd9ef8b91cf601a9850",7:"d73027fc8d59fee08bffffbfd9ef8b91cf601a9850",8:"d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850",9:"d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850",10:"a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837",11:"a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837"},Accent:{3:"7fc97fbeaed4fdc086",4:"7fc97fbeaed4fdc086ffff99",5:"7fc97fbeaed4fdc086ffff99386cb0",6:"7fc97fbeaed4fdc086ffff99386cb0f0027f",7:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17",8:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},Dark2:{3:"1b9e77d95f027570b3",4:"1b9e77d95f027570b3e7298a",5:"1b9e77d95f027570b3e7298a66a61e",6:"1b9e77d95f027570b3e7298a66a61ee6ab02",7:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d",8:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},Paired:{3:"a6cee31f78b4b2df8a",4:"a6cee31f78b4b2df8a33a02c",5:"a6cee31f78b4b2df8a33a02cfb9a99",6:"a6cee31f78b4b2df8a33a02cfb9a99e31a1c",7:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6f",8:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00",9:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d6",10:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9a",11:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99",12:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},Pastel1:{3:"fbb4aeb3cde3ccebc5",4:"fbb4aeb3cde3ccebc5decbe4",5:"fbb4aeb3cde3ccebc5decbe4fed9a6",6:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcc",7:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bd",8:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaec",9:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"},Pastel2:{3:"b3e2cdfdcdaccbd5e8",4:"b3e2cdfdcdaccbd5e8f4cae4",5:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9",6:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2ae",7:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cc",8:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"},Set1:{3:"e41a1c377eb84daf4a",4:"e41a1c377eb84daf4a984ea3",5:"e41a1c377eb84daf4a984ea3ff7f00",6:"e41a1c377eb84daf4a984ea3ff7f00ffff33",7:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628",8:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf",9:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"},Set2:{3:"66c2a5fc8d628da0cb",4:"66c2a5fc8d628da0cbe78ac3",5:"66c2a5fc8d628da0cbe78ac3a6d854",6:"66c2a5fc8d628da0cbe78ac3a6d854ffd92f",7:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494",8:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"},Set3:{3:"8dd3c7ffffb3bebada",4:"8dd3c7ffffb3bebadafb8072",5:"8dd3c7ffffb3bebadafb807280b1d3",6:"8dd3c7ffffb3bebadafb807280b1d3fdb462",7:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69",8:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5",9:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9",10:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bd",11:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5",12:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"},Default:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676",36:"ff00000000ff00ff00ffff0000ffffff00ff993300000080808000ff6600008080660066ff99cc666699333300ffcc99ccffff9999ffff80803366ff339966ffcc0000ccffd020909933660066cc99cc00ff990033cccccc99ff800000333399008000ffffcc99ccff800080"},Basic:{24:"0000ffff004dffbf0074ff00a400ffff7400ffff0000ffffff0000ffd3003d00ff00ff00ff00ffff9200d3ff000090ff6d00ffff4900ffe80000ff92ff0090ffaa00aaff00004dff"},Light:{24:"6565ffff6593ffd865abff65c865ffffab65ffff6565ffffff6565ffe5658965ff65ff65ff65ffffbd65e5ff6565bcffa765ffff9165fff16565ffbdff65bcffcc65ccff656593ff"},Favorite:{1:"ff0000",2:"ff000000ffff",3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000bfff0000ff800040ffff00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",10:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ff",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080",24:"ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff4000ff8000ffbf00ffff00ffff00bfff0080ff0040"},Pastel:{24:"b5b5ffffb5cbffedb5d7ffb5e5b5ffffd7b5ffffb5b5ffffffb5b5fff2b5c7b5ffb5ffb5ffb5ffffdfb5f2ffb5b5dfffd5b5ffffcab5fff8b5b5ffdfffb5dfffe6b5e6ffb5b5cbff"},Balanced:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676"},Rpalette:{8:"000000ff000000cd000000ff00ffffff00ffffff00bebebe"},RlatticeBackground:{7:"ffe5ccccffccccffffcce6ffffccffffccccffffcc"},RlatticeShingle:{7:"ff7f0000ff0000ffff0080ffff00ffff0000ffff00"},RlatticeLine:{7:"0080ffff00ff006400ff0000ffa50000ff00a52a2a"},RlatticePolygon:{7:"ccffffffccffccffccffe5cccce6ffffffccffcccc"},Bootstrap:{1:"337ab7",2:"337ab7d9534f",3:"337ab75cb85cd9534f",4:"337ab75cb85cf0ad4ed9534f",5:"337ab75cb85c5bc0def0ad4ed9534f",6:"337ab75cb85c9370db5bc0def0ad4ed9534f",7:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976",8:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976c86727"},ColorSpectrum:{1:""},White:{1:"ffffff"},Black:{1:"000000"},NPG:{10:"e64b354dbbd500a0873c5488f39b7f8491b491d1c2dc00007e6148b09c85"},AAAS:{10:"3b4992ee0000008b45631879008280bb00215f559ba200568081801b1919"},NEJM:{8:"bc3c290072b5e1872720854e7876b16f99adffdc91ee4c97"},Lancet:{9:"00468bed000042b5400099b4925e9ffdaf91ad002aadb6b61b1919"},Jama:{7:"374e55df8f4400a1d5b2474579af976a659980796b"},JCO:{10:"0073c2efc000868686cd534c7aa6dc003c678f77003b3b3ba730304a6990"},Economist:{12:"6794a7014d6476c0c101a2d97ad2f600887dadadad7bd3f67c260bee8f7176c0c1a18376"},EconomistBG:{5:"d5e4ebc3d6dfed111aebebebc9c9c9"},Excel:{7:"ff00ffffff0000ffff8000808000000080800000ff"},Excel2:{7:"993366ffffccccffff660066ff80800066ccccccff"},Excel3:{10:"365e9698333477973d5d437c36869fd1702f8197c5c47f80acc4849887b0"},GGPlot:{1:"595959",2:"f8766d00bfc4",3:"f8766d00ba38619cff",4:"f8766d7cae0000bfc4c77cff",5:"f8766da3a50000bf7d00b0f6e76bf3",6:"f8766db79f0000ba3800bfc4619cfff564e3",7:"f8766dc49a0053b40000c09400b6eba58afffb61d7",8:"f8766dcd96007cae0000be6700bfc400a9ffc77cffff61cc",9:"f8766dd3920093aa0000ba3800c19f00b9e3619cffdb72fbff61c3",10:"f8766dd89000a3a50039b60000bf7d00bfc400b0f69590ffe76bf3ff62bc",11:"f8766ddb8e00aea20064b20000bd5c00c1a700bade00a6ffb385ffef67ebff63b6",12:"f8766dde8c00b79f007cae0000ba3800c08b00bfc400b4f0619cffc77cfff564e3ff64b0",13:"f8766de18a00be9c008cab0024b70000be7000c1ab00bbda00acfc8b93ffd575fef962ddff65ac",14:"f8766de38900c49a0099a80053b40000bc5600c09400bfc400b6eb06a4ffa58affdf70f8fb61d7ff66a8",15:"f8766de58700c99800a3a5006bb10000ba3800bf7d00c0af00bcd800b0f6619cffb983ffe76bf3fd61d1ff67a4",16:"f8766de68613cd9600aba3007cae000cb70200be6700c19a00bfc400b8e700a9ff8494ffc77cffed68edff61ccff68a1",17:"f8766de7851ed09400b2a10089ac0045b50000bc5100c08700c0b200bcd600b3f229a3ff9c8dffd277fff166e8ff61c7ff689e",18:"f8766de88526d39200b79f0093aa005eb30000ba3800bf7400c19f00bfc400b9e300adfa619cffae87ffdb72fbf564e3ff61c3ff699c"},Solarized:{1:"b58900",2:"b58900859900",3:"b58900c671c4859900",4:"b58900dc322f268bd2859900",5:"b58900dc322f6c71c4268bd2859900",6:"b58900cb4b16d336826c71c42aa198859900",7:"b58900cb4b16dc322f6c71c4268bd22aa198859900",8:"b58900cb4b16dc322fd336826c71c4268bd22aa198859900"},SolarizedBase:{7:"002b36073642586e7583949693a1a1eee8d5fdf6e3",8:"002b36073642586e75657b8383949693a1a1eee8d5fdf6e3"},PaulTol:{1:"4477aa",2:"4477aacc6677",3:"4477aaddcc77cc6677",4:"4477aa117733ddcc77cc6677",5:"4477aa88ccee117733ddcc77cc6677",6:"4477aa88ccee117733ddcc77cc6677aa4499",7:"33228888ccee44aa99117733ddcc77cc6677aa4499",8:"33228888ccee44aa99117733999933ddcc77cc6677aa4499",9:"33228888ccee44aa99117733999933ddcc77cc6677882255aa4499",10:"33228888ccee44aa99117733999933ddcc77661100cc6677882255aa4499",11:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677882255aa4499",12:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677aa4466882255aa4499"},ColorBlind:{8:"000000e69f0056b4e9009e73f0e4420072b2d55e00cc79a7"},Tableau:{20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},TableauMedium:{10:"729eceff9e4a67bf5ced665dad8bc9a8786eed97caa2a2a2cdcc5d6dccda"},TableauLight:{10:"aec7e8ffbb7898df8aff9896c5b0d5c49c94f7b6d2c7c7c7dbdb8d9edae5"},TableauGrey:{5:"60636aa5acaf4144518f8782cfcfcf"},TableauColorBlind:{10:"006ba4ff800eababab5959595f9ed1c85200898989a2c8ecffbc79cfcfcf"},TableauTrafficLight:{9:"b10318dba13a309343d82526ffc15669b764f26c64ffdd719fcd99"},TableauPurpleGrey:{12:"7b66d2a699e8dc5fbdffc0da5f5a41b4b19b995688d898baab6ad5d098ee8b7c6edbd4c5"},TableauBlueRed:{12:"2c69b0b5c8e2f02720ffb6b0ac613ce9c39b6ba3d6b5dffdac8763ddc9b4bd0a36f4737a"},TableauGreenOrange:{12:"32a251acd98dff7f0fffb9773cb7cc98d9e4b85a0dffd94a39737c86b4a982853bccc94d"},TableauCyclic:{20:"1f83b41696ac18a18829a03c54a33882a93fadb828d8bd35ffbd4cffb022ff9c0eff810ee75727d23e4ec94d8cc04aa7b446b39658b18061b46f63bb"},TableauPairSequential:{32:"bccfb49c0824bccfb409622ab4d4da26456ef0c2947b3014c3c3c31e1e1ee5e5e5ffb2b6e5e5e5b7e6a7e5e5e5c4d8f3e5e5e5ffcc9ef5cac7bd1100dbe8b43c8200f3e0c2bb5137feffd941b7c4f7e4c6bb5137efedf5807dbaf0f0f0737373"},TableauTripleDiverging:{48:"9c0824cacaca26456e9c0824cacaca09622a9c0824ffffff09622a9c0824cacaca1e1e1e9c0824ffffff1e1e1e09622acacaca26456e7b3014cacaca26456e7b3014ffffff26456effb2b6e5e5e5b7e6a7ffb2b6ffffffb7e6a7ffb2b6ffffffc6c6c6ffcc9ee5e5e5c4d8f3ffcc9effffffc4d8f3e0ad30e4e4e27492aaeda389cde1d35c8b70529985dbcf47c26b51"},WallStreetJournal:{4:"efefefe9f3ead4dee7f8f2e4"},WallStreetJournal2:{4:"d3ba68d5695d5d8ca865a479"},WallStreetJournalRedGreen:{2:"088158ba2f2a"},WallStreetJournalBlackGreen:{4:"00000059595959a77f008856"},WallStreetJournalDemRep:{3:"006a8eb1283aa8a6a7"},WallStreetJournal3:{6:"c72e29016392be9c2e098154fb832d000000"},Stata:{15:"1a476f90353b55752fe37e006e8e84c10534938dd2cac27ea0522d7b92a82d6d669c8847bfa19cffd200d9e6eb"},Stata2:{15:"ffff0000ff000080ffff00ffff7f00ff0000add8e6ffe47400ff80c0dcc0ff45000000ffff00806e8e84a0522d"},Stata3:{15:"006000ff45001a476f90353b6e8e84a0522dff7f00ff00ff00ffffff000000ff009c8847800080c0dcc0add8e6"},StataMono:{15:"606060a0a0a0808080404040000000e0e0e0202020707070909090b0b0b0d0d0d0f0f0f0303030c0c0c0505050"},BlackAndWhite:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},BehancePair:{2:"6b5dd3cec8ff",4:"6b5dd3cec8ffffa2c0ffc6db",6:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7",8:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f",10:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f1b1d218d8e90"},BehanceTrio:{3:"6b5dd3cec8ff9d93e9",6:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a4",9:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5",12:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab",15:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab1b1d218d8e90494a4d"},BehanceQuartet:{4:"6b5dd3cec8ff9d93e98072dc",8:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed3",12:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4ff",16:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d",20:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d1b1d218d8e90494a4dfafafa"},Behance:{1:"6b5dd3",2:"6b5dd3ffa2c0",3:"6b5dd3ffa2c03f8cff",4:"6b5dd3ffa2c03f8cfffece73",5:"6b5dd33f8cffffa2c0fece731b1d21",6:"6b5dd3ffa2c03f8cff9d93e9ffc6dba0d7e7",7:"6b5dd33f8cffffa2c0fece731b1d21ffa25fcdf4ff",8:"6b5dd3ffa2c03f8cfffece739d93e9a0d7e7ffc6dbfee2ab",9:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab",10:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90",15:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d",20:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d8072dccdf4ffffbed3fedd9dfafafa"},Prism:{1:"1f7ff1",2:"1f7ff1814cff",3:"1f7ff1814cffff7d00",4:"1f7ff1814cffff7d0012c5ff",5:"1f7ff1814cffff7d0012c5fff4d4fe",6:"1f7ff1814cffff7d0012c5fff4d4fee9c505",7:"1f7ff1814cffff7d0012c5fff4d4fee9c505898790"},PrismPair:{2:"1f7ff112c5ff",4:"1f7ff112c5ff814cfff4d4fe",6:"1f7ff112c5ff814cfff4d4feff7d00e9c505",8:"1f7ff112c5ff814cfff4d4feff7d00e9c505042d710ccffe"},PrismTrio:{3:"61459939d4fbfe7d29"},CanvasXpress:{1:"4575b4",2:"d730274575b4",3:"d7191cfdae612c7bb6",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},CanvasXpressTraditional:{1:"f2000d",2:"f2000d000df2",3:"f2000d000df20df200",4:"f2000d000df20df200f2f20d",5:"f2000d000df20df200f2f20df20df2",6:"f2000d000df20df200f2f20df20df20df2f2",7:"f2000d000df20df200f2f20df20df20df2f2f2f2f2",8:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd3",9:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fe",10:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b",11:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d0016",12:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d",13:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00",14:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808",15:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38b",16:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe",17:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3",18:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3404040"},Matlab:{7:"0072bdd95319edb1207e2f8e77ac304dbeeea2142f"},Parula:{10:"352a870f5cdd127dd8079ccf15b1b459bd8ca5be6be1b952fcce2ef9fb0e"},Viridis:{3:"44015421908cfde725",4:"44015431688e35b779fde725",5:"4401543b528b21908c5dc863fde725",6:"4401544144872a788e22a8847ad151fde725",7:"440154443a8331688e21908c35b7798fd744fde725",8:"44015446337e365c8d277f8e1fa1874ac16d9fda3afde725",9:"440154472d7b3b528b2c728e21908c27ad815dc863aadc32fde725",10:"4401544828783e4a8931688e26828e1f9e8935b7796dcd59b4de2cfde725",11:"44015448257641448735608d2a788e21908c22a88443bf717ad151bbdf27fde725",12:"440154482173433e8538598c2d708e25858e1e9b8a2bb07f51c56a85d54ac2df23fde725",256:"44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"},Magma:{3:"000004b63679fcfdbf",4:"000004721f81f1605dfcfdbf",5:"00000451127cb63679fb8861fcfdbf",6:"0000043b0f708c2981de4968fe9f6dfcfdbf",7:"0000042d1160721f81b63679f1605dfeaf77fcfdbf",8:"0000042311515f187f982d80d3436ef8765cfeba80fcfdbf",9:"0000041d114751127c822681b63679e65164fb8861fec287fcfdbf",10:"000004180f3e451077721f819f2f7fcd4071f1605dfd9567fec98dfcfdbf",11:"000004150e373b0f70641a808c2981b63679de4968f76f5cfe9f6dfece91fcfdbf",12:"000004120d323310685a167e7d2482a3307ec83e73e95562f97c5dfea873fed395fcfdbf",256:"00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"},Plasma:{3:"0d0887cc4678f0f921",4:"0d08879c179eed7953f0f921",5:"0d08877e03a8cc4678f89441f0f921",6:"0d08876a00a8b12a90e16462fca636f0f921",7:"0d08875d01a69c179ecc4678ed7953fdb32ff0f921",8:"0d08875402a38b0aa5b93289db5c68f48849febc2af0f921",9:"0d08874c02a17e03a8a92395cc4678e56b5df89441fdc328f0f921",10:"0d088747039f7301a89c179ebd3786d8576bed7953fa9e3bfdc926f0f921",11:"0d088742049e6a00a8900da4b12a90cc4678e16462f1844bfca636fcce25f0f921",12:"0d08873e049c6300a78707a6a62098c03a83d5546ee76f5af58c46fdad32fcd225f0f921",256:"0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"},Inferno:{3:"000004bb3754fcffa4",4:"000004781c6ded6925fcffa4",5:"00000456106ebb3754f98c0afcffa4",6:"000004420a68932667dd513afca50afcffa4",7:"000004330a5f781c6dbb3754ed6925fcb519fcffa4",8:"000004280b5465156e9f2a63d44842f57d15fac127fcffa4",9:"000004210c4a56106e89226abb3754e35932f98c0af9c932fcffa4",10:"0000041b0c424b0c6b781c6da52c60cf4446ed6925fb9a06f7d03cfcffa4",11:"000004170c3a420a686b186e932667bb3754dd513af3771afca50af6d645fcffa4",12:"000004140b353a096360136e85216ba92e5ecb4149e65d2ff78311fcad12f5db4bfcffa4",256:"00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"},Cividis:{3:"00204d7c7b78ffea46",4:"00204d575c6da69d75ffea46",5:"00204d414d6b7c7b78bcaf6fffea46",6:"00204d31446b666970958f78cbba69ffea46",7:"00204d233e6c575c6d7c7b78a69d75d3c164ffea46",8:"00204d16396d4b546c6c6e728e8a79b3a772dbc761ffea46",9:"00204d05366e414d6b61646f7c7b789b9477bcaf6fe0cb5effea46",10:"00204d00336f39486b575c6d7071738a8779a69d75c4b56ce4cf5bffea46",11:"00204d00326f31446b4e576c6669707c7b78958f78b0a473cbba69e7d159ffea46",12:"00204d00306f2a406c48526b5e626e7273748784799e9677b6a971d0be67ead357ffea46",256:"00204c00204e00215000225100235300235500245600255800265a00265b00275d00285f002861002963002a64002a66002b68002c6a002d6c002d6d002e6e002e6f002f6f002f6f00306f00316f00316f00326e00336e00346e00346e01356e06366e0a376d0e376d12386d15396d17396d1a3a6c1c3b6c1e3c6c203c6c223d6c243e6c263e6c273f6c29406b2b416b2c416b2e426b2f436b31446b32446b33456b35466b36466b37476b38486b3a496b3b496b3c4a6b3d4b6b3e4b6b404c6b414d6b424e6b434e6b444f6b45506b46506b47516b48526b49536b4a536b4b546b4c556b4d556b4e566b4f576c50586c51586c52596c535a6c545a6c555b6c565c6c575d6d585d6d595e6d5a5f6d5b5f6d5c606d5d616e5e626e5f626e5f636e60646e61656f62656f63666f64676f65676f666870676970686a70686a70696b716a6c716b6d716c6d726d6e726e6f726f6f726f70737071737172737272747373747474757575757575757676767777767878767978777a79777b7a777b7b787c7b787d7c787e7d787f7e78807e78817f788280788381788481788582788683788784788885788985788a86788b87788c88788d88788e89788f8a78908b78918c78928c78938d78948e78958f78968f779790779891779992779a93779b93779c94779d95779e96769f9776a09876a19876a29976a39a75a49b75a59c75a69c75a79d75a89e74a99f74aaa074aba174aca173ada273aea373afa473b0a572b1a672b2a672b4a771b5a871b6a971b7aa70b8ab70b9ab70baac6fbbad6fbcae6ebdaf6ebeb06ebfb16dc0b16dc1b26cc2b36cc3b46cc5b56bc6b66bc7b76ac8b86ac9b869cab969cbba68ccbb68cdbc67cebd67d0be66d1bf66d2c065d3c065d4c164d5c263d6c363d7c462d8c561d9c661dbc760dcc860ddc95fdeca5edfcb5de0cb5de1cc5ce3cd5be4ce5be5cf5ae6d059e7d158e8d257e9d356ebd456ecd555edd654eed753efd852f0d951f1da50f3db4ff4dc4ef5dd4df6de4cf7df4bf9e049fae048fbe147fce246fde345ffe443ffe542ffe642ffe743ffe844ffe945"},Rainbow:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},Heat:{3:"ff0000ff8000ffff00",4:"ff0000ff8000ffff00ffff80",5:"ff0000ff5500ffaa00ffff00ffff80",6:"ff0000ff4000ff8000ffbf00ffff00ffff80",7:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff80",8:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff40ffffbf",9:"ff0000ff2a00ff5500ff8000ffaa00ffd500ffff00ffff40ffffbf",10:"ff0000ff2400ff4900ff6d00ff9200ffb600ffdb00ffff00ffff40ffffbf",11:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff40ffffbf",12:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff2affff80ffffd5"},LastAirBenderFire:{8:"ecb100a100007E605EFF45009948234B4C4E572530000000"},LastAirBenderAir:{7:"ff9933C24841FFFF338B5B4587AFD1EEB05ADBC5A0"},LastAirBenderEarth:{9:"015E05B1A8667A5C1264674225351C4C7022C7C45ED2CFABFEFED8"},LastAirBenderWater:{8:"0047ab1DB4D3A2CAEDAFB5B8120976fffafa174D79949BBC"},SpongeBob:{11:"C86925FDF56CC4433F989B46FC95765D57AFB2CE31FF2027000000B1D6C5AB8323"},Simpsons:{10:"fed90f424f46d1b271FB4122ABC67D0363C37A491E000000FC020946732E"},RickyAndMorty:{9:"01B4C697ce4cFFF874BEE5FDF675DA44281d3a4767F8D3ACE64358"},ParksAndRecreation:{10:"bdbdbda51209ffdb58ec70147A491EC24841005502f7fcb969983ab5651d"},KimPossible:{12:"FF8C0002466370D42389160402001F9CF6F7FFCE455D734DFEC3BB662C9Cfff9f5000000"},GravityFalls:{14:"417BA1ff1493ffff2e3456348b0000ff670093C0D58b45139248A71c88594747478fbc8fd2b48c000000"},GameOfThronesStark:{9:"cadde17B906F174D79fffafa898989D4CDB1708090120976000000"},GameOfThronesStannis:{7:"FF0000ff8d1aFFD700b20000cc6600FFFF66000000"},GameOfThronesLannister:{6:"89080AC5AA73FEDF25C248418B5B45000000"},GameOfThronesTyrell:{9:"068105F7DC27808000AB681BF9FE768DA08071749798FB983CB371"},GameOfThronesTargaryen:{5:"AC1F25272727ff993382878896804b"},GameOfThronesMartell:{8:"ff8000cc6600b81b1873110ff8fc23fafd7b4c2600a57642"},GameOfThronesTully:{6:"212250AE432FE4EDCA8B5B454682B4000000"},GameOfThronesGreyjoy:{6:"000000708090D4CDB1DCDCDCF7DC27808080"},GameOfThronesManderly:{7:"40e0d080808000ff00282828015202195953FFFFFF"},GameOfThronesArryn:{7:"007fff7fbfff0019334c4cffffefb2a89797FFFFFF"},Brooklyn99Regular:{10:"e7298a72bcd4e41a1cFCF40E49f149f16913525252F9FEFF000E33000000"},Brooklyn99Dark:{9:"6CA9C33A3533000E33800000CBCFD2175E78DAA520174D79000000"}};for(var c in CanvasXpress.colorSchemes){for(var d in CanvasXpress.colorSchemes[c]){var b=CanvasXpress.colorSchemes[c][d].match(/.{6}/g);CanvasXpress.colorSchemes[c][d]=b?b.map(function(a){return"#"+a}):[]}}}();CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themeDef={names:["economist","excel","tableau","stata","igray","solarized","paulTol","ggplot","wallStreetJournal","cx","blackAndWhite","lastAirBender","gameOfThrones","none"],axisTickColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],axisTickScaleFontFactor:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],axisTitleColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],axisTitleScaleFontFactor:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],background:["#D5E4EB","#FFFFFF","#E5E5E5","#EAF2F3","#E5E5E5","#FDF6E3","#FFFFFF","#FFFFFF","#F8F2E4","#FFFFFF","#FFFFFF","#ECE5D3","#FFFFFF","#FFFFFF"],backgroundType:["solid","window","window","window","window","solid","solid","window","solid","window","solid","solid","solid","solid"],backgroundWindow:["#D5E4EB","#C0C0C0","#FFFFFF","#FFFFFF","#FFFFFF","#FDF6E3","#FFFFFF","#E5E5E5","#F8F2E4","#E8E8E8","#FFFFFF","#ECE5D3","#FFFFFF","#F4F4F4"],colorScheme:["Economist","Excel","TableauMedium","Stata","GGPlot","Solarized","PaulTol","GGPlot","WallStreetJournal3","CanvasXpress","BlackAndWhite",false,false,"User"],colors:[false,false,false,false,false,false,false,false,false,false,false,false,false,["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"]],fitLineColor:["#FFD700","#FFD700","#FFD700","#FFD700","#0000FF","#FFD700","#FFD700","#0000FF","#FFD700","#FFD700","#000000","#FFD700","#FFD700","#FFD700"],foreground:["#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],guides:[false,false,false,false,false,false,false,true,false,false,false,false,false,false],guidesColor:["#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#FFFFFF","#CCCCCC","#CCCCCC","#FFFFFF","#FFFFFF","#FFFFFF","#CCCCCC"],legendBackgroundBorderColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#000000","#000000","#000000","#FFFFFF","#FFFFFF","#ECE5D3","#FFFFFF","#CCCCCC"],legendBackgroundColor:["#D5E4EB","#FFFFFF","#FFFFFF","#FFFFFF","#FFFFFF","#FFFFFF","#FFFFFF","#FFFFFF","#F8F2E4","#E8E8E8","#FFFFFF","#ECE5D3","#FFFFFF","#FFFFFF"],legendColumns:[4,1,1,4,1,1,1,1,4,1,1,3,3,1],legendInside:[true,false,false,false,false,false,false,false,true,false,false,false,false,false],legendKeyBackgroundBorderColor:["#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#FFFFFF","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC"],legendKeyBackgroundColor:["#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC"],legendPosition:["top","right","right","bottom","right","right","right","right","top","right","right","bottom","bottom","right"],legendTextColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],legendTextScaleFontFactor:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],lineDecoration:["symbol","symbol","symbol","symbol","symbol","symbol","symbol","symbol","symbol","symbol","pattern","false","false","symbol"],mapOutlineColor:["#D5E4EB","#C0C0C0","#E5E5E5","#EAF2F3","#FFFFFF","#FDF6E3","#FFFFFF","#FFFFFF","#F8F2E4","#CCCCCC","#000000","#333333","#333333","#CCCCCC"],objectBorderColor:["#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000"],plotBox:[false,false,false,false,false,false,false,false,false,false,true,false,false,false],plotBoxColor:["#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],showLegendBorder:[false,true,true,true,false,true,false,true,false,true,false,false,false,false],subtitleAlign:["left","left","left","center","center","left","left","center","left","center","center","center","center","center"],subtitleColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],titleAlign:["left","left","left","center","center","left","left","center","left","center","center","center","center","center"],titleColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],xAxisTickColor:["#000000","#000000","#E5E5E5","#000000","#E5E5E5","#93A1A1","#E5E5E5","#FFFFFF","#000000","#FFFFFF","#000000","#333333","#333333","#CCCCCC"],xAxisTickGuideColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],xAxisTickGuideSize:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],xAxisTickLeftColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],xAxisTickLeftShow:[false,true,true,true,false,true,false,true,false,true,true,true,true,true],xAxisTickLeftSize:[1,1,1,2,1,2,1,1,1,1,1,1,1,1],xAxisTickLineType:["solid","solid","solid","solid","solid","solid","solid","solid","dotted","solid","dotted","solid","solid","solid"],xAxisTickRightColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],xAxisTickRightShow:[false,true,true,false,false,false,false,false,false,true,true,true,true,true],xAxisTickRightSize:[1,1,1,2,1,2,1,1,1,1,1,1,1,1],xAxisTickSize:[2,1,1,1,1,1,1,1,2,1,1,1,1,1],xAxisTicksMajorShow:[false,false,true,false,true,true,true,true,false,true,true,true,true,true],xAxisTicksMinorShow:[false,false,false,false,false,false,false,false,false,false,true,true,true,true],yAxis2Show:[true,false,false,false,false,false,false,false,false,false,false,false,false,false],yAxisShow:[false,true,true,true,true,true,true,true,true,true,true,true,true,true],yAxisTickBottomColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],yAxisTickBottomShow:[true,true,true,true,false,true,false,true,true,true,true,true,true,true],yAxisTickBottomSize:[1,1,1,1,1,2,1,1,1,1,1,1,1,1],yAxisTickColor:["#FFFFFF","#000000","#E5E5E5","#EAF2F3","#E5E5E5","#93A1A1","#E5E5E5","#FFFFFF","#000000","#FFFFFF","#000000","#333333","#333333","#CCCCCC"],yAxisTickGuideColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],yAxisTickGuideSize:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],yAxisTickLineType:["solid","solid","solid","solid","solid","solid","solid","solid","dotted","solid","dotted","solid","solid","solid"],yAxisTickSize:[2,1,1,1,1,1,1,1,2,1,1,1,1,1],yAxisTickTopColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],yAxisTickTopShow:[false,true,true,false,false,false,false,false,false,true,true,true,true,true],yAxisTickTopSize:[1,1,1,1,1,2,1,1,1,1,1,1,1,1],yAxisTicksMajorShow:[true,true,true,true,true,true,true,true,true,true,true,true,true,true],yAxisTicksMinorShow:[false,false,false,false,false,false,false,false,false,false,true,true,true,true],conditional:[{OneDPlots:{xAxisTicksMajorShow:true}},{OneDPlots:{xAxisTicksMajorShow:true}},false,{OneDPlots:{xAxisTicksMajorShow:true}},false,false,false,false,{OneDPlots:{xAxisTicksMajorShow:true}},{OneDPlots:{plotBox:true,plotBoxColor:"#337AB7"}},false,false,false,false]};CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.prototype.initDOM=function(){this.$=function(id){return window.document.getElementById(id)};this.$cX=function(t,p,s){var e=window.document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.$cXI=function(k,p,s,x,d){var el=document.createElementNS("http://www.w3.org/2000/svg","svg");var t="";var classes=function(svg){var sn={};var sp=svg.split(/class=/);var c="<style>";for(var ii=1;ii<sp.length;ii++){var m=sp[ii].match(/"(.+?)"/);if(m){var cs=m[1].split(/\s+/);for(var jj=0;jj<cs.length;jj++){var ms=cs[jj];if(CanvasXpress.icons.classes.hasOwnProperty(ms)&&!sn.hasOwnProperty(ms)){c+="."+ms+CanvasXpress.icons.classes[ms]}}}}c+="</style>";return c};if(CanvasXpress.icons.use.hasOwnProperty(k)){var svg='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(k)){svg+=CanvasXpress.icons.gradients[k].replace(/&quot;/g,'"')}for(var i=0;i<CanvasXpress.icons.use[k].length;i++){svg+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[k][i]].replace(/&quot;/g,'"').replace(/&apos;/g,"'")}var c=classes(svg);if(!d){d=24}el.setAttribute("xmlns","http://www.w3.org/2000/svg");el.setAttribute("viewBox","0 0 100 100");el.setAttribute("style","width:"+d+"px;height:"+d+"px;box-sizing:border-box;");if(p){for(var i in p){if(i=="className"){el.setAttribute("class",p[i])}else{el.setAttribute(i,p[i]);if(i=="title"){t="<title>"+p[i]+"</title>"}}}}if(s){for(var i in s){el.style[i]=s[i]}}el.innerHTML=t+c+svg}return x?new XMLSerializer().serializeToString(el):el};this.$cXIU=function(el,k,p,s){var t="";var classes=function(svg){var sn={};var sp=svg.split(/class=/);var c="<style>";for(var ii=1;ii<sp.length;ii++){var m=sp[ii].match(/"(.+?)"/);if(m){var cs=m[1].split(/\s+/);for(var jj=0;jj<cs.length;jj++){var ms=cs[jj];if(CanvasXpress.icons.classes.hasOwnProperty(ms)&&!sn.hasOwnProperty(ms)){c+="."+ms+CanvasXpress.icons.classes[ms]}}}}c+="</style>";return c};if(el&&CanvasXpress.icons.use.hasOwnProperty(k)){var svg='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(k)){svg+=CanvasXpress.icons.gradients[k].replace(/&quot;/g,'"')}for(var i=0;i<CanvasXpress.icons.use[k].length;i++){svg+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[k][i]].replace(/&quot;/g,'"').replace(/&apos;/g,"'")}var c=classes(svg);if(p){for(var i in p){if(i=="className"){el.setAttribute("class",p[i])}else{el.setAttribute(i,p[i]);if(i=="title"){t="<title>"+p[i]+"</title>"}}}}if(s){for(var i in s){el.style[i]=s[i]}}el.innerHTML=t+c+svg}};this.setPixelImage=function(){if(CanvasXpress.instances.length==1){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:(window.navigator.onLine?"https://www.canvasxpress.org/assets/images/beacon.gif?"+CanvasXpress.factory.client:CanvasXpress.png),title:"",alt:""})}else{this.beaconImage=CanvasXpress.instances[0].beaconImage}};this.$$=function(){var t=this;var c=CanvasXpress;var f=function(k){if(!k){k=c[d[4]]}else{if(k.length>36){return 0}}var len=k.length;var ini=Number(k.substring(2,3));var end=Number(k.substring(len-3,len-2));var str=k.substring(3+ini,3+ini+5)[d[7]]("")[d[8]]()[d[9]]("");var fns=k.substring(len-(3+end+5),len-(3+end));return Number(str+""+fns+"000")};var w=["686578546f537472696e67","6472617754657874","666163746f7279","73797374656d","72656769737465726564","76616c6964","737562737472696e67","73706c6974","72657665727365","6a6f696e","43616e766173587072657373","4e6f7420612076616c696420636f7079206f6620","556e737570706f727465642056657273696f6e206f6620","20522056657273696f6e","204e6f64652056657273696f6e","697352566965776572","697352436f6e736f6c65","68726566","2f7777772e63616e7661737870726573732e6f72672f646973742f","72616e646f6d496e744265747765656e","666f6e7453697a65","666f6e744e616d65","69734378706c6f74","6378706c6f742042792043616e766173587072657373","736574506978656c496d616765","64697361626c65426561636f6e"];var h=t.hexToString("686578546f537472696e67");var d=[];for(var i=0;i<w.length;i++){d.push(t[h](w[i]))}var r=Number(f());var s=Number(t.meta.time.start);var v=isNaN(c[d[2]][d[5]])?Number(f(c[d[2]][d[5]])):0;var x=new RegExp(d[18]).test(c[d[2]][d[17]])||c[d[3]][d[15]]||c[d[3]][d[16]];var m=t[d[22]]?d[23]:d[10];if(!x){if(r-s<0){if(!v||v-s<0){if(c[d[2]][d[5]]){m=d[11]+d[10]}setTimeout(function(){t.$$$(m)},t[d[19]](1,8)*1000)}}}};this.$$$=function(m){var t=this;var w=["6472617754657874","666f6e744e616d65"];var h=t.hexToString("686578546f537472696e67");var d=[];for(var i=0;i<w.length;i++){d.push(t[h](w[i]))}var a=t[d[1]]+20+"px";t[d[0]](m,t.width-6,t.height-10,a,"rgba(0,0,0,1)","right","middle")};this.showMask=function(){var c=this.$(this.target);var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.height=parseInt((c.height/2)-100.5)+"px";l.style.display="block"}};this.hideMask=function(){var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.display="none"}this.loaded=true;this.$$()};this.createNewTarget=function(){var cn=this.$cX("canvas").setAttribute("id",this.newId("-canvasXpress-"));window.document.body.appendChild(cn);return cn.id};this.newId=function(t,f){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return f?n:i};this.insertTarget=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.castCanvasAttributes(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.castCanvasAttributes=function(c,e){if(!e){e=this.meta.canvas.ctx.canvas}CanvasXpress.transferDatasetAttributes(e,c)};this.removeTarget=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.getWindowSize=function(){var doc=window.document;var w=window.innerWidth||doc.documentElement.clientWidth||doc.body.clientWidth;var h=window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight;return[w,h]};this.getWindowScroll=function(){var d=window.document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.isInViewport=function(el,d){var w=this.getWindowSize();var b=el.getBoundingClientRect();var c=b.right-(this.width*0.5);var m=b.bottom-(this.height*0.5);return b.left>=0&&b.top>=0&&c<=w[0]&&m<=w[1]};this.hasClass=function(e,n){return e?e.classList.contains(n):false};this.addClass=function(e,n){if(e){e.classList.add(n)}};this.removeClass=function(e,n){if(e){e.classList.remove(n)}};this.getComputedCSS=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.getPropertyValue(o[i])+";"}return s};this.cancelEvent=function(e){if(!e){return}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.stopEvent=function(e){if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.normalizeEvtName=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.triggerEvent=function(el,type){if("createEvent" in document){var e=document.createEvent("HTMLEvents");e.initEvent(type,false,true);el.dispatchEvent(e)}else{var e=document.createEventObject();e.eventType=type;el.fireEvent("on"+e.eventType,e)}};this.copyEvent=function(e){var ce={};for(var i in e){ce[i]=e[i]}return ce};this.addEvtListener=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.normalizeEvtName(e),c)}else{if(e=="touchstart"){o.addEventListener(e,c,f)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}}};this.removeEvtListener=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.normalizeEvtName(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.getKeys(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.addRemoveEvtListener=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.purgeEventListeners=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.removeEvtListener(o,e,m[i][0],m[i][1])}}};this.preventSelection=function(){var d=window.document;if(d.selection){d.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.getTargetEvent=function(e){var obj=e.target||e.srcElement;if(typeof(obj)!="object"){obj=this.$(obj)}if(obj instanceof SVGElement&&obj.ownerSVGElement){obj=obj.ownerSVGElement}return obj};this.dispatchEvent=function(el,e){el.dispatchEvent(e)};this.requestAnimationFrame=function(callback,time){if(callback){raf=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame;if(raf){raf(callback)}else{if(!time){time=1000/60}window.setTimeout(callback,time)}}};this.setTimeout=function(callback,time){if(this.isR){setTimeout(callback,time)}else{var that=this;var wait=function(t){return new Promise(function(resolve,reject){if(t){setTimeout(resolve,t)}else{setTimeout(resolve,1000)}})};wait(time).then(function(){callback.apply(that)})}};this.setInterval=function(c,d){this.logConsole("canvasXpress setInterval ready - "+arguments.callee.caller.name+" - "+d);return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}if(typeof window.CustomEvent!=="function"){window.CustomEvent=function(event,params){params=params||{bubbles:false,cancelable:false,detail:null};var evt=document.createEvent("CustomEvent");evt.initCustomEvent(event,params.bubbles,params.cancelable,params.detail);return evt}}if(!Array.prototype.includes){Object.defineProperty(Array.prototype,"includes",{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(len===0){return false}var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==="number"&&typeof y==="number"&&isNaN(x)&&isNaN(y))}while(k<len){if(sameValueZero(o[k],searchElement)){return true}k++}return false}})}this.getToggleSwitch=function(id,checked,left,right){var cnt=this.$cX("div",{className:"CanvasXpressToggle"});var lab=this.$cX("label",{className:"CanvasXpressToggle"});var inp=this.$cX("input",{id:id||this.newId("-cX-Toggle-"),className:"CanvasXpressToggle",type:"checkbox"});if(checked){inp.checked=true}var bkg=this.$cX("div",{className:"CanvasXpressToggleSwitch"});var lft=this.$cX("span",{className:"CanvasXpressToggle",innerHTML:left||""});var rgt=this.$cX("span",{className:"CanvasXpressToggle",innerHTML:right||""});lab.appendChild(lft);lab.appendChild(inp);lab.appendChild(bkg);lab.appendChild(rgt);cnt.appendChild(lab);return cnt};this.getRangeSlider=function(key,id,min,max,width){if(min!=null&&max!=null){min=parseFloat(min);max=parseFloat(max);if(min>max){var tmp=max;max=min;min=tmp}}var vals=this.rPretty(min,max,4);min=vals[0];max=vals[vals.length-1];var rnge=max-min;var decs=(((rnge*1000000)-(parseInt(rnge)*1000000))/1000000).toString().replace(/\./,"").length-1;var step=Math.pow(1/10,(decs+1));var lmin=min>0?Math.log10(min):min==0?0:null;var lmax=max>0?Math.log10(max):max==0?0:null;var lvals=[];if(lmin!=null&&lmax!=null){var scale=this.rPretty(lmin,lmax,4);for(var i=0;i<scale.length;i++){lvals.push(this.formatNumber((Math.pow(10,scale[i])),decs))}lvals=this.cleanVals(lvals)}var cont=this.$cX("div",{className:"CanvasXpressRangeSliderContainer"},{width:width+"px"});var contt=this.$cX("div",{className:"CanvasXpressRangeSliderContainerTop"});var label=this.$cX("div",{className:"CanvasXpressRangeSliderContainerTop"},{width:"50%"});var span=this.$cX("span",{className:"CanvasXpressRangeSliderContainerTop",innerHTML:key});var linlog=this.getToggleSwitch(id+"LinLog",true,"Log","Lin");var contb=this.$cX("div",{className:"CanvasXpressRangeSliderContainerBottom"});var rmin=this.$cX("input",{id:(id+"Min")||this.newId("-cX-RangeSliderMin-"),className:"CanvasXpressRangeSlider",type:"range",min:min,max:max,value:min,step:step});var rmax=this.$cX("input",{id:(id+"Max")||this.newId("-cX-RangeSliderMax-"),className:"CanvasXpressRangeSlider",type:"range",min:min,max:max,value:max,step:step});var imin=this.$cX("input",{id:(id+"InputMin")||this.newId("-cX-RangeSliderInputMin-"),className:"CanvasXpressRangeSliderMin",type:"number",min:min,max:max,value:min,step:step});var imax=this.$cX("input",{id:(id+"InputMax")||this.newId("-cX-RangeSliderInputMax-"),className:"CanvasXpressRangeSliderMax",type:"number",min:min,max:max,value:max,step:step});var input=this.$cX("div",{className:"CanvasXpressRangeSliderInput"});var slider=this.$cX("div",{className:"CanvasXpressRangeSlider"});var track=this.$cX("div",{className:"CanvasXpressRangeSliderTrack"});var range=this.$cX("div",{className:"CanvasXpressRangeSliderRange"});var thmbl=this.$cX("div",{className:"CanvasXpressRangeSliderThumbLeft"});var thmbr=this.$cX("div",{className:"CanvasXpressRangeSliderThumbRight"});var ticks=this.$cX("div",{className:"CanvasXpressRangeSliderTicks"});var ticksl=this.$cX("div",{className:"CanvasXpressRangeSliderTicks"},{display:"none"});for(var i=0;i<vals.length;i++){ticks.appendChild(this.$cX("span",{className:"CanvasXpressRangeSliderTicksLong",innerHTML:vals[i]}));if(i<vals.length-1){for(var j=0;j<4;j++){ticks.appendChild(this.$cX("span",{className:"CanvasXpressRangeSliderTicks",innerHTML:""}))}}}for(var i=0;i<lvals.length;i++){ticksl.appendChild(this.$cX("span",{className:"CanvasXpressRangeSliderTicksLong",innerHTML:lvals[i]}));if(i<lvals.length-1){for(var j=0;j<4;j++){ticksl.appendChild(this.$cX("span",{className:"CanvasXpressRangeSliderTicks",innerHTML:""}))}}}if(lmin==null||lmax==null){linlog.style.display="none"}label.appendChild(span);contt.appendChild(label);linlog.firstChild.firstChild.nextSibling.tickLinear=ticks;linlog.firstChild.firstChild.nextSibling.tickLog=ticksl;linlog.firstChild.firstChild.nextSibling.minRange=rmin;linlog.firstChild.firstChild.nextSibling.maxRange=rmax;contt.appendChild(linlog);imin.minRange=rmin;imax.maxRange=rmax;input.appendChild(imin);input.appendChild(imax);rmin.decs=decs;rmin.minInput=imin;rmin.maxRange=rmax;rmin.minThumb=thmbl;rmin.range=range;rmin.linLog=linlog.firstChild.firstChild.nextSibling;rmax.decs=decs;rmax.maxInput=imax;rmax.minRange=rmin;rmax.maxThumb=thmbr;rmax.range=range;rmax.linLog=linlog.firstChild.firstChild.nextSibling;slider.appendChild(track);slider.appendChild(range);slider.appendChild(thmbl);slider.appendChild(thmbr);contb.appendChild(input);contb.appendChild(rmin);contb.appendChild(rmax);contb.appendChild(slider);contb.appendChild(ticks);contb.appendChild(ticksl);cont.appendChild(contt);cont.appendChild(contb);return cont};this.isInIframe=function(){try{return window.self!==window.top}catch(e){return true}};this.initializeBrowser=function(){var getBrowserVersion=function(){var ua=window.navigator.userAgent;var tem;var m=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(m[1])){tem=/\brv[ :]+(\d+)/g.exec(ua)||[];return"IE "+(tem[1]||"")}if(m[1]==="Chrome"){tem=ua.match(/\b(OPR|Edge)\/(\d+)/);if(tem!=null){return tem.slice(1).join(" ").replace("OPR","Opera")}}m=m[2]?[m[1],m[2]]:[window.navigator.appName,window.navigator.appVersion,"-?"];if((tem=ua.match(/version\/(\d+)/i))!=null){m.splice(1,1,tem[1])}return m.join(" ")};var getOS=function(){var userAgent=window.navigator.userAgent;var platform=window.navigator.platform;var macosPlatforms=["Macintosh","MacIntel","MacPPC","Mac68K"];var windowsPlatforms=["Win32","Win64","Windows","WinCE"];var iosPlatforms=["iPhone","iPad","iPod"];var os=null;if(macosPlatforms.indexOf(platform)!==-1){os="Mac OS"}else{if(iosPlatforms.indexOf(platform)!==-1){os="iOS"}else{if(windowsPlatforms.indexOf(platform)!==-1){os="Windows"}else{if(/Android/.test(userAgent)){os="Android"}else{if(!os&&/Linux/.test(platform)){os="Linux"}}}}}return os};var str=getBrowserVersion().split(" ");var os=getOS();CanvasXpress.system={browser:str[0],browserVersion:str[1],os:os,alt:(os=="Mac OS"?"&#8997;":"Alt"),command:"&#8984;",control:(os=="Mac OS"?"&#8963;":"Ctrl"),shift:(os=="Mac OS"?"&#8679;":"Shift"),isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:(str[0].match(/safari/i)?true:this.isInIframe()),isTouchScreen:("ontouchstart" in window||"onmsgesturechange" in window||window.navigator.maxTouchPoints)}}};CanvasXpress.prototype.initSVG=function(){function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}var a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);var j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};var i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};var e=function(m,l){this.__root=m;this.__ctx=l};var k=function(n){var l={width:500,height:500,enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};this.canvasToSVG=k};CanvasXpress.prototype.initInterface=function(){this.parseJSON=function(s,r){if(s.toString().match(/<!DOCTYPE/)){return undefined}else{if(r){return JSON.parse(s,r)}else{return JSON.parse(s,function(k,v){if(typeof v==="string"&&v.startsWith&&v.startsWith("/Function(")&&v.endsWith&&v.endsWith(")/")){v=v.substring(10,v.length-2).replace(/&quot;/g,'"');return Function("v");return eval("("+v+")")}else{return v}})}}};this.stringifyJSON=function(js,r,s){if(r){return JSON.stringify(js,r,s||null)}else{return js?JSON.stringify(js,function(k,v){if(typeof v==="function"){return"/Function("+v.toString().replace(/"/g,"&quot;")+")/"}else{if(k=="events"&&typeof v==="object"){return v}else{if(k=="state"||k=="stateIndex"||k=="gantt"){return undefined}else{if(v instanceof Array){for(var p in v){if(Array.isArray(v[p])||v[p] instanceof Object){return v}}return JSON.stringify(v)}else{return v}}}}},s||null).replace(/\\n/g,"").replace(/\\/g,"").replace(/\"\[/g,"[").replace(/\]\"/g,"]").replace(/\"\{/g,"{").replace(/\}\"/g,"}").replace(/u0000/g,""):false}};this.isValidURL=function(str){var pattern=new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");var pattern2=new RegExp("^(\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");return pattern.test(str)||pattern2.test(str)};this.stringToXML=function(str){var test=false;if(window.DOMParser){test=(new DOMParser()).parseFromString(str,"text/xml")}else{if(typeof window.ActiveXObject!="undefined"&&new window.ActiveXObject("Microsoft.XMLDOM")){test=new window.ActiveXObject("Microsoft.XMLDOM");test.async="false";test.loadXML(str)}}return test};this.isValidXML=function(str){var test=this.stringToXML(str);return test!=null&&test.getElementsByTagName("parsererror").length==0};this.isValidBZ2=function(str){return str.match(/.xml.bz2$/)};this.isValidJSON=function(str){try{JSON.parse(str)}catch(e){return false}return true};this.isValidDelimitedFile=function(str){var test=this.delimitedToArray(str);return this.isArray(test)&&this.isArray(test[0])};this.isValidString=function(str){var obj={type:false,data:false};if(this.isValidURL(str)){obj.type="URL";obj.data=str}else{if(this.isValidXML(str)){obj.type="XML";obj.data=this.stringToXML(str)}else{if(this.isValidBZ2(str)){obj.type="URL";obj.data=str}else{if(this.isValidJSON(str)){obj.type="JSON";obj.data=JSON.parse(str)}else{if(this.isValidDelimitedFile(str)){obj.type="DELIM";obj.data=this.delimitedToArray(str,false,true,this.graphType=="Network")}}}}}return obj};this.loadParamsFile=function(t){return function(e){t.removeMenus();var file=e.target.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw({func:"loadParamsFile",par:(e)})}}catch(e){alert("Oooops! Not a valid CanvasXpress json parameter file")}};reader.readAsText(file)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.parseDataFromPNG=function(p){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};var dv=new DataView(p);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");return this.parseJSON(res)}else{alert("Oooops! Not a valid CanvasXpress Image")}};this.parseNodeLinks=function(json){var smps=[];var vals=[];var srce=[];var targ=[];for(var i=0;i<json.links.length;i++){var l=json.links[i];if(l.source&&l.target&&l.value){srce.push(l.source);targ.push(l.target);vals.push(l.value);smps.push("Smp"+(i+1))}}var data={y:{vars:["Weight"],smps:smps,data:[vals]},x:{Source:srce,Target:targ}};return{renderTo:"newSankey",data:data,config:{graphType:"Sankey",sankeySource:"Source",sankeyTarget:"Target"}}};this.parseHierarchy=function(json){var that=this;var reformat=function(treeStructure){var max=0;var smps=[];var vals=[];var seen={};var flatten=function(children,extractChildren,level,parent){return Array.prototype.concat.apply(children.map(function(x){if(!seen.hasOwnProperty(x.name)){seen[x.name]=0}seen[x.name]++;if(seen[x.name]>1){x.name+=seen[x.name]}var o=that.cloneObject(x);o.level=level||1;o.parent=parent||null;return o}),children.map(function(x){max=Math.max(max,(level||1)+1);if(!x.children){smps.push(x.name);vals.push(x.value||1)}return flatten(extractChildren(x)||[],extractChildren,(level||1)+1,x.name)}))};var extractChildren=function extractChildren(x){return x.children||null};var flat=flatten(extractChildren(treeStructure),extractChildren).map(function(x){x.n=x.children?x.children.length:0;return delete x.children&&x});var data={y:{vars:["Dummy"],smps:smps,data:[vals]},x:{}};for(var i=0;i<data.y.smps.length;i++){for(var j=0;j<flat.length;j++){if(!flat[j].n&&data.y.smps[i]==flat[j].name){flat[j].smp=i;break}}}var hier=[];var levl=json.name;data.x[levl]=[];hier.push(levl);for(var i=2;i<max-1;i++){data.x[levl+i]=[];hier.push(levl+i)}var map={};for(var i=0;i<flat.length;i++){map[flat[i].name]=i}for(var i=0;i<hier.length;i++){for(var j=0;j<data.y.smps.length;j++){data.x[hier[i]][j]=null}}for(var i=0;i<flat.length;i++){if(flat[i].parent){var p=flat[i].parent;var m=map[p];var s=flat[i].smp;var l=flat[i].level-1;var f=flat[m].parent;data.x[levl+(l>1?l:"")][s]=flat[m].name;while(f){m=map[f];l=flat[m].level;data.x[levl+(l>1?l:"")][s]=flat[m].name;f=flat[m].parent}}}return{renderTo:"newTree",data:data,config:{graphType:"Tree",hierarchy:hier}}};return reformat(json)};this.loadFile=function(t){return function(e,jr,callback,f){t.removeMenus();t.showMask();var checkBackgroundImage=function(data){if(data.config&&data.config.backgroundImage&&data.config.backgroundImage.match(/^javascript:\/\//)&&data.config.backgroundImageSrc){var im=new Image();im.id=data.config.backgroundImage.split("//")[1];im.style.display="none";im.src="data:image/png;base64,"+atob(data.config.backgroundImageSrc);document.body.appendChild(im);CanvasXpress.cacheImages[t.getFileName(im.src)]=im}};var file=f?f:e.target?e.target.files[0]:e.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();if(type=="image/png"){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};reader.onload=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");var data=t.parseJSON(res);if(jr){return data}checkBackgroundImage(data);if(data.hasOwnProperty("config")){delete (data.config.remoteService)}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{t.hideMask();alert("Oooops! Not a valid CanvasXpress Image")}};reader.readAsArrayBuffer(file)}else{if(type=="application/x-bzip2"){reader.onload=function(){var bz2=t.bz2(this.result);if(part[1].match(/ml$/)){try{var xml=t.parseXML(bz2);t.loadXML(xml,part[0])}catch(e){t.hideMask();alert("Oooops! Not a valid bz2 file for CanvasXpress")}}else{t.hideMask();alert("Oooops! Not a valid bz2 file for CanvasXpress")}};reader.readAsBinaryString(file)}else{var ext=part.pop();if(ext=="cxj"){reader.onload=function(){try{var tbp=t.parseJSON(reader.result);if(tbp.tabs&&tbp.ref){var data=tbp.tabs[tbp.ref[0]].rows[tbp.ref[1]].cels[tbp.ref[2]].content;var clb=function(){t.restoreTabPanel(tbp)};checkBackgroundImage(data);if(data.data||(data&&data.config&&data.config.graphType&&data.config.graphType=="Map")){if(data.config.topoJSON){if(data.config.mapId){delete window[data.config.mapId];delete t.meta.map;delete t.topoJSON;delete t.topoJSONURL}}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,clb);t.hideMask()}else{if(data.config){t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}clb()}else{t.draw({func:"loadFile",par:[e,false,clb]})}}else{var foo=data.error.error}}}else{var foo=data.error.error}}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress tab panel file")}}}else{if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);checkBackgroundImage(data);if(data.data||(data&&data.config&&data.config.graphType&&data.config.graphType=="Map")){if(data.config.topoJSON){if(data.config.mapId){delete window[data.config.mapId];delete t.meta.map;delete t.topoJSON;delete t.topoJSONURL}}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.config){t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw({func:"loadFile",par:[e,jr,callback,f]})}}else{if(data.children&&data.children.length){data=t.parseHierarchy(data);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.nodes&&data.links){data=t.parseNodeLinks(data);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.type&&data.type.match(/FeatureCollection|Topology/)){var datan={data:false,config:{graphType:"Map",topoJSON:data,mapId:"cXMap"}};window.cXMap=data;t.updateData(datan);t.hideMask()}else{var foo=data.error.error}}}}}}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="geojson"){reader.onload=function(){try{var data=t.parseJSON(reader.result);if(data.type&&data.type.match(/FeatureCollection|Topology/)){var datan={data:false,config:{graphType:"Map",topoJSON:data,mapId:"cXMap"}};window.cXMap=data;t.updateData(datan);t.hideMask()}else{var foo=data.error.error}}catch(e){t.hideMask();alert("Oooops! Not a valid geojson file")}}}else{if(ext=="svg"){reader.onload=function(){try{var data=t.SVGtoCX(reader.result);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="txt"||ext=="csv"||ext=="tsv"||ext=="tab"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=ext=="csv"&&tc>tt?",":"\t";var data;if(t.graphType=="Network"){data=t.delimitedToArray(str,dl,false,true);if(data&&!t.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}alert(data.rows+" "+data.type+" records added to network data\n"+fail);if(data.type=="node"){t.appendNodeData(data.data)}else{t.appendEdgeData(data.data)}t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}else{data=t.isMetaDataFile(t.delimitedToArray(str,dl),t.graphType=="Map");if(data&&!t.isArray(data)){if(data.addt){alert(data.recs+" records added as an additional data set\n")}else{alert(data.recs+" records added to meta data\n")}t.appendMetaData(data.data,data.addt);t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}data.renderTo=part[0].replace(/\s/g,"").replace(/\(/g,"").replace(/\)/g,"");data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="esv"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=tc>tt?",":"\t";var data=t.delimitedToArray(str,dl,false,true,"edge");data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="gml"){reader.onload=function(){try{var data=t.parseGML(reader.result);data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(ext=="gexf"){reader.onload=function(){t.remoteServiceType="file";try{var xml=t.parseXML(reader.result);t.gexfToCX(xml,part[0])}catch(e){t.hideMask();alert("Oooops! Not a valid "+ext+" file for CanvasXpress")}}}else{if(ext.match(/ml$/)){reader.onload=function(){try{var xml=t.parseXML(reader.result);t.loadXML(xml,part[0])}catch(e){t.hideMask();alert("Oooops! Not a valid "+ext+" file for CanvasXpress")}}}}}}}}}}}reader.readAsText(file)}}}}(this);this.loadXML=function(xml,target,config,events){this.remoteServiceType="file";var ts1=xml.childNodes[0];var ts2=xml.childNodes[2]||xml.childNodes[1];if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){this.metabaseToCX(xml,target,config,events)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){this.cytoscapeToCX(xml,target,config,events)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){this.wikipathwayToCX(xml,target,config,events)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){this.keggToCX(xml,target,config,events)}}}}};this.editJSFiddle=function(t){return function(e,f){if(t.editable||f){t.removeMenus();var js="onReady(function () {\n"+t.getCodeJSONJS()+"})";var ht="<link rel='stylesheet' href='https://www.canvasxpress.org/dist/canvasXpress.css' type='text/css'/>\n";ht+="<script type='text/javascript' src='https://www.canvasxpress.org/dist/canvasXpress.min.js'><\/script>\n\n";ht+="<canvas id='"+t.target+"' width='"+t.width+"' height='"+t.height+"'></canvas>";var form=t.$cX("form",{id:"submitToJSFiddle",method:"post",action:"https://jsfiddle.net/api/post/library/pure/",target:"check"},{display:"none"});document.body.appendChild(form);var tatt=t.$cX("textarea",{name:"title",value:(t.title||"CanvasXpress")});var taht=t.$cX("textarea",{name:"html",value:ht});var tajs=t.$cX("textarea",{name:"js",value:js});var btsb=t.$cX("button",{type:"submit"});form.appendChild(tatt);form.appendChild(taht);form.appendChild(tajs);form.appendChild(btsb);btsb.click();document.body.removeChild(form)}}}(this);this.editCodePen=function(t){return function(e,f){if(t.editable||f){t.removeMenus();var js="onReady(function () {\n"+t.getCodeJSONJS().replace(/\'/g,"")+"})";var ht='<link rel="stylesheet" href="https://www.canvasxpress.org/dist/canvasXpress.css" type="text/css"/>\n';ht+='<script type="text/javascript" src="https://www.canvasxpress.org/dist/canvasXpress.min.js"><\/script>\n\n';ht+='<canvas id="'+t.target+'" width="'+t.width+'" height="'+t.height+'"></canvas>';var rs="https://www.canvasxpress.org/dist/canvasXpress.css;https://www.canvasxpress.org/dist/canvasXpress.min.js";var data='{"title": "'+(t.title||"CanvasXpress")+'", "html": "'+ht+'" js: "'+js+'" js_external: "'+rs+'"}';data='{"title": "CanvasXpress", "html": "'+ht.replace(/"/g,"'")+'", "js": "'+js.replace(/"/g,"'")+'", "js_external": "'+rs.replace(/"/g,"'")+'"}';var form=t.$cX("form",{id:"submitToCodePen",method:"post",action:"https://codepen.io/pen/define",target:"_blank"},{display:"none"});document.body.appendChild(form);var indt=t.$cX("input",{type:"hidden",name:"data",value:data});var btsb=t.$cX("button",{type:"submit"});form.appendChild(indt);form.appendChild(btsb);btsb.click();document.body.appendChild(form)}}}(this);this.saveCurrent=function(){this.resortData();var s=CanvasXpress.stack[this.target];var a=s.afterRender;var ar=[];for(var i=0;i<a.length;i++){if(a[i][0].match(/^sort/)){ar.push(this.cloneObject(a[i]))}}return this.prettyJSON({renderTo:s.renderTo,data:this.data,config:this.getConfig(),afterRender:ar,factory:s.factory,system:s.system,version:s.version})};this.save=function(t){return function(e,f,p,o){t.removeMenus();var flnm=f?f+".json":t.saveFilename?t.saveFilename+".json":"cX-"+t.target+".json";flnm=flnm.replace(/.json.json$/,".json");CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].system=CanvasXpress.system;var obj;if(p){obj=t.prettyJSON({config:CanvasXpress.stack[t.target].config,afterRender:CanvasXpress.stack[t.target].afterRender||[]})}else{if(o||(e&&(e.ctrlKey||e.altKey))){obj=t.saveCurrent()}else{obj=t.prettyJSON(t.cleanDataObject(t.cloneObject(CanvasXpress.stack[t.target])))}}var blob=new Blob([obj],{type:"text/plain"});t.saveAs(blob,flnm)}}(this);this.saveSVG=function(t){return function(e,f){t.removeMenus();CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].system=CanvasXpress.system;t.isSVG=true;var tr=t.showTransition;t.showTransition=false;t.meta.canvas.SVG=new this.canvasToSVG({width:t.width,height:t.height,desc:t.isReproducibleResearch?t.prettyJSON(t.cleanDataObject(t.cloneObject(CanvasXpress.stack[t.target]))):""});t.renderGraph(true);var svg=t.meta.canvas.SVG.getSerializedSvg();if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var flnm=f?f+".svg":t.saveFilename?t.saveFilename+".svg":"cX-"+t.target+".svg";flnm=flnm.replace(/.svg.svg$/,".svg");var blob=new Blob([svg],{type:"image/svg+xml"});t.saveAs(blob,flnm);t.showTransition=tr;delete (t.meta.canvas.SVG);t.isSVG=false}}(this);this.parseXML=function(xml){var dom=null;if(window.DOMParser){try{dom=(new DOMParser()).parseFromString(xml,"text/xml")}catch(e){dom=null}}else{if(window.ActiveXObject){try{dom=new ActiveXObject("Microsoft.XMLDOM");dom.async=false;if(!dom.loadXML(xml)){window.alert(dom.parseError.reason+dom.parseError.srcText)}}catch(e){dom=null}}else{alert("cannot parse xml string!")}}return dom};this.parseHTMLTable=function(table,cx){var ar=[];for(var i=0;i<table.rows.length;i++){var ln=[];for(var j=0;j<table.rows.item(i).cells.length;j++){ln.push(table.rows.item(i).cells.item(j).innerHTML)}ar.push(ln)}if(cx){cx=this.arrayToCanvasXpress(ar);CanvasXpress.transferDatasetAttributes(table,cx.config,true);return cx}else{return ar}};this.SVGtoCX=function(xml){var dom=this.parseXML(xml);var svg=dom.childNodes[0];if(svg.tagName.match(/svg/i)){var desc=svg.getAttribute("desc");if(desc){return this.parseJSON(desc)}}};this.arrayBufferToBase64=function(buffer){var binary="";var bytes=new Uint8Array(buffer);var len=bytes.byteLength;for(var i=0;i<len;i++){binary+=String.fromCharCode(bytes[i])}return window.btoa(binary)};this.base64ToArrayBuffer=function(base64){var binary_string=window.atob(base64);var len=binary_string.length;var bytes=new Uint8Array(len);for(var i=0;i<len;i++){bytes[i]=binary_string.charCodeAt(i)}return bytes.buffer};this.bz2=function(str){function bwt_reverse(src,primary){var len=src.length;if(primary>=len){throw RangeError("Out of bound")}if(primary<0){throw RangeError("Out of bound")}var A=src;src=src.join("");A.sort();var start={};for(var i=len-1;i>=0;i--){start[A[i]]=i}var links=[];for(i=0;i<len;i++){links.push(start[src[i]]++)}var i,first=A[i=primary],ret=[];for(var j=1;j<len;j++){ret.push(A[i=links[i]])}return first+ret.reverse().join("")}function move_to_front_and_store(a,c,buff){var v=a[c];for(var i=c;i>0;a[i]=a[--i]){}buff.push(a[0]=v)}var RBitfield=function(){this.init=function(x){this.masks=[];for(var i=0;i<31;i++){this.masks[i]=(1<<i)-1}this.masks[31]=-2147483648;this.f=x;this.bits=0;this.bitfield=0;this.count=0};this.readbits2=function readbits2(n){var n2=n>>1;return this.readbits(n2)*(1<<n2)+this.readbits(n-n2)};this.readbits=function readbits(n){while(this.bits<n){this.bitfield=(this.bitfield<<8)+this.f.charCodeAt(this.count++);this.bits+=8}var m=this.masks[n];var r=(this.bitfield>>(this.bits-n))&m;this.bits-=n;this.bitfield&=~(m<<this.bits);return r}};var HuffmanLength=function(code,bits){this.code=code;this.bits=bits;this.symbol=undefined};var OrderedHuffmanTable=function(){this.process=function(lengths){var len=lengths.length;var z=[];for(var i=0;i<len;i++){z.push([i,lengths[i]])}z.push([len,-1]);var l=[];var b=z[0];var start=b[0],bits=b[1];for(var p=1;p<z.length;p++){var finish=z[p][0],endbits=z[p][1];if(bits){for(var code=start;code<finish;code++){l.push(new HuffmanLength(code,bits))}}start=finish;bits=endbits;if(endbits==-1){break}}l.sort(function(a,b){return(a.bits-b.bits)||(a.code-b.code)});this.table=l;var temp_bits=0;var symbol=-1;this.faht=[];var cb=null;for(var i=0;i<this.table.length;i++){var x=this.table[i];symbol+=1;if(x.bits!=temp_bits){symbol<<=x.bits-temp_bits;cb=this.faht[temp_bits=x.bits]={}}cb[x.symbol=symbol]=x}this.min_bits=16;this.max_bits=-1;this.table.forEach(function(x){if(x.bits<this.min_bits){this.min_bits=x.bits}if(x.bits>this.max_bits){this.max_bits=x.bits}},this)}};var decode=function(input){var b=new RBitfield();b.init(input);b.readbits(16);var method=b.readbits(8);if(method!=104){throw"Unknown (not type 'h'uffman Bzip2) compression method"}var blocksize=b.readbits(8);if(49<=blocksize&&blocksize<=57){blocksize-=48}else{throw"Unknown (not size '1'-'9') Bzip2 blocksize"}function getUsedCharTable(b){var a=[];var used_groups=b.readbits(16);for(var m1=1<<15;m1>0;m1>>=1){if(!(used_groups&m1)){for(var i=0;i<16;i++){a.push(false)}continue}var used_chars=b.readbits(16);for(var m2=1<<15;m2>0;m2>>=1){a.push(Boolean(used_chars&m2))}}return a}var out=[];function main_loop(){while(true){var blocktype=b.readbits2(48);var crc=b.readbits2(32);if(blocktype==54156738319193){if(b.readbits(1)){throw"Bzip2 randomised support not implemented"}var pointer=b.readbits(24);var used=getUsedCharTable(b);var huffman_groups=b.readbits(3);if(2>huffman_groups||huffman_groups>6){throw RangeError("Bzip2: Number of Huffman groups not in range 2..6")}var mtf=[0,1,2,3,4,5,6].slice(0,huffman_groups);var selectors_list=[];for(var i=0,selectors_used=b.readbits(15);i<selectors_used;i++){var c=0;while(b.readbits(1)){if(c++>=huffman_groups){throw RangeError("More than max ("+huffman_groups+") groups")}}move_to_front_and_store(mtf,c,selectors_list)}var groups_lengths=[];var symbols_in_use=used.reduce(function(a,b){return a+b},0)+2;for(var j=0;j<huffman_groups;j++){var length=b.readbits(5);var lengths=[];for(var i=0;i<symbols_in_use;i++){if(length<0||length>20){throw RangeError("Bzip2 Huffman length code outside range 0..20")}while(b.readbits(1)){length-=(b.readbits(1)*2)-1}lengths.push(length)}groups_lengths.push(lengths)}var tables=[];for(var g=0;g<groups_lengths.length;g++){var codes=new OrderedHuffmanTable();codes.process(groups_lengths[g]);tables.push(codes)}var favourites=[];for(var c=used.length-1;c>=0;c--){if(used[c]){favourites.push(String.fromCharCode(c))}}favourites.reverse();var selector_pointer=0;var decoded=0;var t;var repeat=0;var repeat_power=0;var buffer=[],r;while(true){if(--decoded<=0){decoded=50;if(selector_pointer<=selectors_list.length){t=tables[selectors_list[selector_pointer++]]}}for(var bb in t.faht){if(b.bits<bb){b.bitfield=(b.bitfield<<8)+b.f.charCodeAt(b.count++);b.bits+=8}if(r=t.faht[bb][b.bitfield>>(b.bits-bb)]){b.bitfield&=b.masks[b.bits-=bb];r=r.code;break}}if(0<=r&&r<=1){if(repeat==0){repeat_power=1}repeat+=repeat_power<<r;repeat_power<<=1;continue}else{var v=favourites[0];for(;repeat>0;repeat--){buffer.push(v)}}if(r==symbols_in_use-1){break}else{move_to_front_and_store(favourites,r-1,buffer)}}var nt=bwt_reverse(buffer,pointer);var done=[];var i=0;var len=nt.length;while(i<len){var c=nt.charCodeAt(i);if((i<len-4)&&nt.charCodeAt(i+1)==c&&nt.charCodeAt(i+2)==c&&nt.charCodeAt(i+3)==c){var c=nt.charAt(i);var rep=nt.charCodeAt(i+4)+4;for(;rep>0;rep--){done.push(c)}i+=5}else{done.push(nt[i++])}}out.push(done.join(""))}else{if(blocktype==25779555029136){b.readbits(b.bits&7);break}else{throw"Illegal Bzip2 blocktype = 0x"+blocktype.toString(16)}}}}main_loop();return out.join("")};return decode(str)};this.print=function(t){return function(e,f,c){var wn=window;var ow=t.width;var oh=t.height;var pm=t.printMagnification;var as=t.autoScaleFont;var st=t.showTransition;var ss=t.skipStack;var pr=["outlineWidth","lineThickness","xAxisTickSize","yAxisTickSize","zAxisTickSize","xAxisTickLeftSize","xAxisTickRightSize","yAxisTickTopSize","yAxisTickBottomSize","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize","treemapBorderWidth","errorBarsThickness","ganttDependencyThickness"];if(!CanvasXpress.stack.hasOwnProperty(t.target)){t=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var adjustDPI=function(reset){if(reset&&pm!=1){for(var i=0;i<pr.length;i++){t[pr[i]]/=pm}t.autoScaleFont=as;t.showTransition=st;t.setDimensions(ow,oh,true);t.skipStack=ss}else{if(pm!=1){t.skipStack=true;t.showTransition=false;for(var i=0;i<pr.length;i++){t[pr[i]]*=pm}t.autoScaleFont=true;t.setDimensions(ow*pm,oh*pm,true)}}};var makeCRCTable=function(){var cn;var crcTable=[];for(var n=0;n<256;n++){cn=n;for(var k=0;k<8;k++){cn=((cn&1)?(3988292384^(cn>>>1)):(cn>>>1))}crcTable[n]=cn}return crcTable};var crc32=function(str){var crcTable=wn.crcTable||(wn.crcTable=makeCRCTable());var crc=0^(-1);for(var i=0;i<str.length;i++){crc=(crc>>>8)^crcTable[(crc^str.charCodeAt(i))&255]}return(crc^(-1))>>>0};var appendBuffer=function(buffer1,buffer2){var tmp=new Uint8Array(buffer1.byteLength+buffer2.byteLength);tmp.set(new Uint8Array(buffer1),0);tmp.set(new Uint8Array(buffer2),buffer1.byteLength);return tmp.buffer};var getArrayBuffer=function(string){var ztxt="tEXt";var len=string.length;var crc=crc32(ztxt+string);var mab=new ArrayBuffer(12+len);var ndv=new DataView(mab);ndv.setUint32(0,len);for(var i=0;i<ztxt.length;i++){ndv.setUint8(4+i,ztxt.charCodeAt(i))}for(var i=0;i<string.length;i++){ndv.setUint8(8+i,string.charCodeAt(i))}ndv.setUint32(4+4+len,crc);return mab};var cleanStack=function(){if(t.isReproducibleResearch){if(t.printMagnification!=1){delete (CanvasXpress.stack[t.target].config.showTransition)}return e&&(e.ctrlKey||e.altKey)?t.saveCurrent():t.stringifyJSON(t.cleanDataObject(t.cloneObject(CanvasXpress.stack[t.target])))}else{var stk=t.parseJSON(e.ctrlKey||e.altKey?t.saveCurrent():t.stringifyJSON(CanvasXpress.stack[t.target]));stk.afterRender=[stk.afterRender[0]];return t.stringifyJSON(stk)}};var collectArrayBuffers=function(hab,sab,rab,dab){var nab=appendBuffer(hab,sab);nab=appendBuffer(nab,rab);nab=appendBuffer(nab,dab);return nab};var toDataUrl=function(blb){var fr=new FileReader();var tx="";if(t.isReproducibleResearch){tx+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{tx+="<h2>Right click to save image</h2>"}fr.onload=function(evt){tx+="<img width="+t.width+" height="+t.height+" src= '"+evt.target.result+"'/>";t.showTooltipDiv(e,tx,t.getTargetEvent(e),{maxWidth:t.width+"px",whiteSpace:"normal"},40,40)};fr.readAsDataURL(blb)};adjustDPI();t.removeMenus();CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].system=CanvasXpress.system;if(!CanvasXpress.factory.valid){t.$$$("CanvasXpress")}var cnv=t.meta.canvas.ctx.canvas;cnv.toBlob(function(blob){var fr=new FileReader();var fn=f?f+".png":t.saveFilename?t.saveFilename+".png":"cX-"+t.target+".png";fn=fn.replace(/.png.png$/,".png");fr.onloadend=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var idat=8+4+4+ihdr+4;var hab=this.result.slice(0,idat);var dab=this.result.slice(idat);var sab=getArrayBuffer("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var rab=getArrayBuffer("ReproducibleResearch\0"+cleanStack());var nab=collectArrayBuffers(hab,sab,rab,dab);var blb=new Blob([nab],{type:"image/png"});t.meta.base64=t.arrayBufferToBase64(nab);if(c){c(blb,fn)}else{if(t.printType=="download"){if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}t.saveAs(blb,fn)}else{toDataUrl(blb)}}adjustDPI(true)};fr.readAsArrayBuffer(blob)},"image/png");if(t.customizing){}else{if(t.maximized){t.clickGraphMaxMin(e)}}}}(this);this.exportToSVG=function(t){return function(e){var ctx=t.meta.canvas.ctx;t.meta.canvas.ctx=new this.canvasToSVG({width:t.width,height:t.height});t.draw({func:"exportToSVG",par:[e]});var svg=t.prettyXML(t.meta.canvas.ctx.getSerializedSvg());var win=window.open("",t.target+"-SVG");win.document.write(svg);t.meta.canvas.ctx=ctx;t.draw({func:"exportToSVG",par:[e]});return false}}(this);this.exportToExcel=function(d){return this.exportToTabDelimited(d)};this.exportToHTML=function(d,t){var str="<table>";for(var i=0;i<d.length;i++){str+="<tr><td>";str+=d[i].join("</td><td>");str+="</td></tr>"}str+="</table>";return t?str:window.open().document.write(str)};this.exportToTabDelimited=function(d){var str="";for(var i=0;i<d.length;i++){str+=d[i].join("\t")+"\n"}var link=this.$(this.target+"-cX-linkTab");if(!link){link=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});window.document.body.appendChild(link)}link.download=this.target+".tsv";link.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(str);link.click()};this.arrayToHTML=function(d){var str="";if(d[0].length){str+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';str+='<table class="CanvasXpressDataTable" style="position:inherit;">';str+="<tbody>";str+="<tr>";for(var i=0;i<d[0][0].length;i++){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][0][i];str+="</div>";str+="</th>"}str+="</tr>";for(var i=1;i<d[0].length;i++){str+="<tr>";for(var j=0;j<d[0][i].length;j++){if(j==0){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</th>"}else{if(d[2]&&d[2][i]&&d[2][i][j]){str+='<td class="CanvasXpressTableCell" style="height:18px;background-color:'+d[2][i][j]+'">'}else{str+='<td class="CanvasXpressTableCell" style="height:18px">'}str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</td>"}}str+="</tr>"}str+="</tbody>";str+="</table>";str+="</div>"}return str};this.rToPrettyR=function(s){var nice=[];var lines=s.split(/\n(?=(?:(?:[^"]*"){2})*[^"]*$)/);var funcs=["header","quote","row.names","fill","check.names","stringsAsFactors"];var call=false;for(var i=0;i<lines.length;i++){var l=lines[i];if(l.match(/library\(canvasXpress\)/)){nice.push(l.replace("library(canvasXpress)",'library(<span class="json-value">canvasXpress</span>)'))}else{if(l.match(/canvasXpress\(/)){nice.push(l.replace("canvasXpress(",'<span class="json-value">canvasXpress</span>('));call=true}else{if(l.match(/\"http.+\"/)){l=l.replace(/(\"http.+?\")/,'<span class="json-string">$1</span>');for(var j=0;j<funcs.length;j++){l=l.replace(funcs[j],'<span class="json-key">'+funcs[j]+"</span>")}l=l.replace('""','<span class="json-string">""</span>,');l=l.replace(/\"\t\"/,'<span class="json-string">"&#92;t"</span>');l=l.replace("=1,",'=<span class="json-number">1</span>,');l=l.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');l=l.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>');nice.push(l)}else{if(call){if(l.match(/\".+?\"/)){l=l.replace(/(\".+?\")/g,'<span class="json-string">$1</span>')}else{if(l.match(/[^xis][\d\.]+/)){l=l.replace(/([\d\.]+)/,'<span class="json-number">$1</span>')}}l=l.replace(/\n/,"&#92;n");l=l.replace(/(\w+)?=/,'<span class="json-key">$1=</span>');l=l.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');l=l.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>')}nice.push(l)}}}}return'<pre class="CanvasXpressCodeContent">\n<code>'+nice.join("</code>\n<code>")+"</code>\n</pre>"};this.prettyColoredR=function(o,r,c){var json=this.stringifyJSON(o,r?r:null,2);if(json.length>10000){c=false}if(c){json=json.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}json=json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls="number";if(/^"/.test(match)){if(/:$/.test(match)){match=match.replace(/"/g,"").replace(":"," =");cls="key"}else{cls="string"}}else{if(/true|false/.test(match)){match=match.replace("false","FALSE").replace("true","TRUE");cls="boolean"}else{if(/null/.test(match)){match=match.replace("null","NULL");cls="null"}}}return c?('<span class="json-'+cls+'">'+match+"</span>"):match});return json.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")};this.dataToR=function(){var arr=[];var prp=[];var cnf,vls,vrs,sps,dat,cod;var scr="";var data=CanvasXpress.stack[this.target].data;var ini="<span class=json-value>canvasXpress</span>(\n";if(this.meta.config.remote&&!this.isObject(this.meta.config.remote.data)){if(this.meta.config.remote.data===false){scr+="data = FALSE\n"}else{scr+='data = "'+this.meta.config.remote.data+'"\n'}ini+="  <span class=json-key>data</span> = data,\n"}else{if(this.graphType=="Map"&&!this.isObject(this.meta.config.remote.data)){scr+="";ini+="  <span class=json-key>data</span> = <span class=json-value>FALSE</span>,\n"}else{if(data.y){arr=[];for(var i=0;i<data.y.vars.length;i++){var arr2=[];for(var j=0;j<data.y.smps.length;j++){arr2.push(data.y.data[i][j]!=null?data.y.data[i][j]:"NA")}arr.push("<span class=json-number>"+arr2.join("</span>,<span class=json-number>")+"</span>,")}arr[arr.length-1]=arr[arr.length-1].replace(/,$/,"");vls="vals = c("+arr.join("\n")+")\n";vrs='vars = c(<span class=json-string>"'+data.y.vars.join('"</span>,\n<span class=json-string>"')+'"</span>)\n';sps='smps = c(<span class=json-string>"'+data.y.smps.join('"</span>,\n<span class=json-string>"')+'"</span>)\n';dat="data = as.data.frame(matrix(vals, <span class=json-key>nrow</span> = <span class=json-number>"+data.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+data.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(vars, smps)))\n";scr+=vls+vrs+sps+dat;ini+="  <span class=json-key>data</span> = data,\n"}if(data.x){arr=[];prp=[];vls="";for(var i in data.x){if(this.meta.data.x[i].type=="Numeric"){arr.push("<span class=json-number>"+data.x[i].join("</span>,\n<span class=json-number>")+"</span>,")}else{arr.push('<span class=json-string>"'+data.x[i].join('"</span>,\n<span class=json-string>"')+'"</span>,')}prp.push(i)}arr[arr.length-1]=arr[arr.length-1].replace(/,$/,"");vls="valx = c("+arr.join("\n ")+")\n";if(this.graphType=="Tree"){vls=vls.replace(/\"\"/g,"NA")}vrs='varx = c(<span class=json-string>"'+prp.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="datx = as.data.frame(matrix(valx, <span class=json-key>nrow</span> = <span class=json-number>"+prp.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+data.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(varx, smps)))\n";scr+=vls+vrs+dat;ini+="  <span class=json-key>smpAnnot</span> = datx,\n"}if(data.z){arr=[];prp=[];vls="";for(var i in data.z){if(this.meta.data.z[i].type=="Numeric"){arr.push("<span class=json-number>"+data.z[i].join("</span>,\n<span class=json-number>")+"</span>,")}else{arr.push('<span class=json-string>"'+data.z[i].join('"</span>,\n<span class=json-string>"')+'"</span>,')}prp.push(i)}arr[arr.length-1]=arr[arr.length-1].replace(/,$/,"");vls="valz = c("+arr.join("\n ")+")\n";sps='smpz = c(<span class=json-string>"'+prp.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="datz = as.data.frame(matrix(valz, <span class=json-key>nrow</span> = <span class=json-number>"+data.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+prp.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>FALSE</span>, <span class=json-key>dimnames</span> = list(vars, smpz)))\n";scr+=vls+sps+dat;ini+="  <span class=json-key>varAnnot</span> = datz,\n"}if(data.nodes){scr+="nodes = list(\n"+this.prettyColoredR(data.nodes,function(k,v){if(k!="layout"){return v}},true)+")\n";ini+="  <span class=json-key>nodeData</span> = nodes,\n"}if(data.edges){scr+="edges = list(\n"+this.prettyColoredR(data.edges,false,true)+")\n";ini+="  <span class=json-key>edgeData</span> = edges,\n"}if(data.venn){scr+="venn = data.frame(\n"+this.prettyColoredR(data.venn.data,false,true)+")\n";ini+="  <span class=json-key>vennData</span> = venn,\n";if(data.venn.legend){scr+="legn = data.frame(\n"+this.prettyColoredR(data.venn.legend,false,true)+")\n";ini+="  <span class=json-key>vennLegend</span> = legn,\n"}}if(data.tracks){ini+="  <span class=json-key>tracks</span> = genome,\n";scr+="genome = list(\n"+this.prettyColoredR(data.tracks,false,true)+")\n"}}}cnf=this.meta.config.remote?this.cloneObject(this.meta.config.remote.config):this.cloneObject(CanvasXpress.stack[this.target].config);if(CanvasXpress.stack[this.target].afterRender&&CanvasXpress.stack[this.target].afterRender.length>1){cnf.afterRender=this.cloneObject(CanvasXpress.stack[this.target].afterRender)}ini+=this.prettyColoredR(cnf,false,true)+")";cod="library(<span class=json-value>canvasXpress</span>)\n"+scr+ini;return"<code> "+cod.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.prettyJSON=function(o,r,c,i){return c&&o?this.prettyColoredJSON(o,r):o?this.stringifyJSON(o,r,i||2):false};this.prettyColoredJSON=function(o,r){if(o){var json=this.stringifyJSON(o,r?r:null,2);if(json.length>10000){return json}else{json=json.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls="number";if(/^"/.test(match)){if(/:$/.test(match)){cls="key"}else{cls="string"}}else{if(/true|false/.test(match)){cls="boolean"}else{if(/null/.test(match)){cls="null"}}}return'<span class="json-'+cls+'">'+match+"</span>"})}else{return false}};this.prettyXML=function(str){var reg=/(>)\s*(<)(\/*)/g;var wsexp=/ *(.*) +\n/g;var contexp=/(<.+>)(.+\n)/g;var xml=str.replace(reg,"$1\n$2$3").replace(wsexp,"$1\n").replace(contexp,"$1\n$2");var pad=0;var formatted="";var lines=xml.split("\n");var indent=0;var lastType="other";var transitions={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var i=0;i<lines.length;i++){var ln=lines[i];var single=Boolean(ln.match(/<.+\/>/));var closing=Boolean(ln.match(/<\/.+>/));var opening=Boolean(ln.match(/<[^!].*>/));var type=single?"single":closing?"closing":opening?"opening":"other";var fromTo=lastType+"->"+type;lastType=type;var padding="";indent+=transitions[fromTo];for(var j=0;j<indent;j++){padding+="  "}formatted+=padding+ln+"\n"}return formatted};this.dataToPython=function(jupyter){var cd=this.getDataJSON(true).replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var sc=this.getConfigJSON(true).replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var se=this.getEventsJSON(true);var ar=this.getAfterRenderJSON(true);var pc="";pc+="<span class=json-key>from</span> canvasxpress.canvas <span class=json-key>import</span> CanvasXpress\n";if(jupyter){pc+="<span class=json-key>from</span> canvasxpress.render.jupyter <span class=json-key>import</span> CXNoteBook\n"}else{pc+="<span class=json-key>from</span> canvasxpress.render.popup <span class=json-key>import</span> CXBrowserPopup\n\n"}pc+="cx = CanvasXpress(\n";pc+='  render_to = </span>"'+this.target+'"</span>,\n';pc+="  data = "+cd+",\n";pc+="  config = "+sc+",\n";if(se){pc+="  events = "+se.replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(ar){pc+="  after_render = "+ar.replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}pc+="  width = <span class=json-number>"+this.width+"</span>,\n";pc+="  height = <span class=json-number>"+this.height+"</span>\n";pc+=")\n\n";if(jupyter){pc+="display = CXNoteBook(cx)\n"}else{pc+="display = CXBrowserPopup(cx)\n"}pc+="display.render()";return"<code> "+pc.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.delimitedToArrayOrig=function(str,delim,cx){delim=delim||",";var pat=new RegExp(("(\\"+delim+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+delim+"\\r\\n]*))"),"gi");var arr=[[]];var arrM=null;while(arrM=pat.exec(str)){var strM=arrM[1];if(strM.length&&strM!==delim){arr.push([])}var strV;if(arrM[2]){strV=arrM[2].replace(new RegExp('""',"g"),'"')}else{strV=arrM[3]}arr[arr.length-1].push(this.isNumber(strV)?Number(strV):strV!=this.missingDataValue?strV:null)}return cx?this.arrayToCanvasXpress(arr):arr};this.delimitedToArray=function(str,delim,cx,net,nwt){var nl=/\r\n|\r|\n/g;var ar=str.split(nl);var setDelim=function(){var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}delim=tc>tt?",":"\t"};if(!delim){setDelim()}for(var i=0;i<ar.length;i++){if(ar[i].match(/^#/)){ar.splice(i,1);i--;continue}var f=ar[i].split(delim);for(var x=f.length-1;x>=0;x--){if(f[x].replace(/"\s+$/,'"').charAt(f[x].length-1)=='"'){var tl=f[x].replace(/^\s+"/,'"');if(tl.length>1&&tl.charAt(0)=='"'){f[x]=f[x].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(x){f.splice(x-1,2,[f[x-1],f[x]].join(delim))}else{f=f.shift().split(delim).concat(f)}}}else{f[x].replace(/""/g,'"')}}for(var j=0;j<f.length;j++){if(this.isNumber(f[j])){f[j]=Number(f[j])}else{if(f[j]==this.missingDataValue){f[j]=null}else{if(f[j].match(/^\[.+\]$/)||f[j].match(/^\{.+\}$/)){f[j]=this.parseJSON(f[j])}else{f[j]=f[j].replace(/"/g,"'")}}}}if(f.length==1&&f[0]==""){ar.splice(i,1);i--;continue}ar[i]=f}return cx&&!nwt?this.arrayToCanvasXpress(ar):net?this.isNetworkFile(ar,nwt):ar};this.isMetaDataFile=function(arr,isMap){if(this.varIndices.length&&this.smpIndices.length){var that=this;var getObject=function(t){if(t=="s"){return{y:{smps:that.cloneObject(that.data.y.smps)},x:{}}}else{return{y:{vars:that.cloneObject(that.data.y.vars)},z:{}}}};var map={};if(isMap&&this.data.z&&this.data.z.hasOwnProperty("cXId")){for(var i=0;i<this.data.z.cXId.length;i++){map[this.data.z.cXId[i]]=i}}var rows={s:[],v:[]};var cols={s:[],v:[]};var idx;var min=2;var add=false;for(var i=1;i<arr.length;i++){idx=this.getSampleIndices(arr[i][0]);if(idx>-1){rows.s.push([i,idx]);continue}idx=isMap&&map.hasOwnProperty(arr[i][0])?map[arr[i][0]]:this.getVariableIndices(arr[i][0]);if(idx>-1){rows.v.push([i,idx]);continue}}for(var i=1;i<arr[0].length;i++){idx=isMap&&map.hasOwnProperty(arr[i][0])?map[arr[i][0]]:this.getVariableIndices(arr[0][i]);if(idx>-1){cols.v.push([i,idx]);continue}idx=this.getSampleIndices(arr[0][i]);if(idx>-1){cols.s.push([i,idx]);continue}}var rs=rows.s.length>min?rows.s.length:0;var rv=rows.v.length>min?rows.v.length:0;var cs=cols.s.length>min?cols.s.length:0;var cv=cols.v.length>min?cols.v.length:0;var sl=this.data.y.smps.length;var vl=this.data.y.vars.length;if(rs||rv||cs||cv){var n=0;if(rs==sl&&cv==vl){var data=[];for(var i=0;i<cols.v.length;i++){var ii=cols.v[i][0];var ix=cols.v[i][1];data[ix]=[];for(var j=0;j<rows.s.length;j++){var jj=rows.s[j][0];var jx=rows.s[j][1];data[ix][jx]=arr[jj][ii];n++}}add=true}else{if(cs==sl&&rv==vl){var data=[];for(var i=0;i<rows.v.length;i++){var ii=rows.v[i][0];var ix=rows.v[i][1];data[ix]=[];for(var j=0;j<cols.s.length;j++){var jj=cols.s[j][0];var jx=cols.s[j][1];data[ix][jx]=arr[ii][jj];n++}}add=true}else{if(rs>=rv&&rs>=cs&&rs>=cv){var data=getObject("s");for(var i=1;i<arr[0].length;i++){data.x[arr[0][i]]=[];var m=0;for(var j=0;j<rows.s.length;j++){var jj=rows.s[j][0];var jx=rows.s[j][1];data.x[arr[0][i]][jx]=arr[jj][i];n++;m=arr[jj][i]?m+1:m}if(!m){delete data.x[arr[0][i]]}}}else{if(rv>=rs&&rv>=cs&&rv>=cv){var data=getObject("v");for(var i=1;i<arr[0].length;i++){data.z[arr[0][i]]=[];var m=0;for(var j=0;j<rows.v.length;j++){var jj=rows.v[j][0];var jx=rows.v[j][1];data.z[arr[0][i]][jx]=arr[jj][i];n++;m=arr[jj][i]?m+1:m}if(!m){delete data.z[arr[0][i]]}}}else{if(cs>rs&&cs>=rv&&cs>=cv){var data=getObject("s");for(var i=0;i<cols.s.length;i++){var ii=cols.s[i][0];var ix=cols.s[i][1];var m=0;for(var j=1;j<arr.length;j++){if(i==0){data.x[arr[j][0]]=[]}data.x[arr[j][0]][ix]=arr[j][ii];n++;m=arr[j][ii]?m+1:m}if(!m){delete data.x[arr[j][0]]}}}else{if(cv>rs&&cv>=rv&&cv>=cs){var data=getObject("v");for(var i=0;i<rows.s.length;i++){var ii=rows.s[i][0];var ix=rows.s[i][1];var m=0;for(var j=1;j<arr.length;j++){if(i==0){data.z[arr[j][0]]=[]}data.z[arr[j][0]][ix]=arr[j][ii];n++;m=arr[j][ii]?m+1:m}if(!m){delete data.z[arr[j][0]]}}}}}}}}return{data:data,recs:n,addt:add}}else{return arr}}return arr};this.isNetworkFile=function(arr,nwt){var obj={};var cols=arr[0];var nodes=0;var edges=0;var fail=0;var type=nwt||false;if(type=="node"){}else{if(type=="edge"){nodes={};obj.data={nodes:[],edges:[]};done={};for(var i=1;i<arr.length;i++){var i1=arr[i][0];var i2=arr[i][1];if(i1&&i2){var n1={id:i1};var n2={id:i2};var e={id1:i1,id2:i2};for(var j=2;j<arr[i].length;j++){n1[arr[0][j]]=arr[i][j];n2[arr[0][j]]=arr[i][j];e[arr[0][j]]=arr[i][j]}if(!done.hasOwnProperty(i1)){obj.data.nodes.push(n1);done[i1]=true}if(!done.hasOwnProperty(i2)){obj.data.nodes.push(n2);done[i2]=true}obj.data.edges.push(e)}}obj.config={graphType:"Network"};return obj}else{if(type=="guess"){if(arr[0][0].match(/id1/i)&&arr[0][1].match(/id2/i)){return this.isNetworkFile(arr,"edge")}else{if(arr[0][0].match(/id1/i)){return this.isNetworkFile(arr,"node")}else{return this.isNetworkFile(arr)}}}else{var map={};for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++}else{if(this.data.nodeIndices.hasOwnProperty(n)){nodes++}else{fail++}}map[n]=i}if(!nodes&&!edges){for(var i=0;i<this.data.nodes.length;i++){var n=this.data.nodes[i];if(n.hasOwnProperty("extId")&&map.hasOwnProperty(n.extId)){arr[map[n.extId]][0]=n.id;nodes++}}}if(edges>nodes){nodes=0;edges=0;fail=0;type="edge";for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++;obj[n+":"+m]={};for(var j=2;j<cols.length;j++){obj[n+":"+m][cols[j]]=arr[i][j]}}else{fail++}}}else{if(nodes>8){nodes=0;edges=0;fail=0;type="node";for(var i=1;i<arr.length;i++){var n=arr[i][0];if(this.data.nodeIndices.hasOwnProperty(n)){nodes++;obj[n]={};for(var j=1;j<cols.length;j++){obj[n][cols[j]]=arr[i][j]}}else{fail++}}}else{return arr}}if((type=="edge"&&(edges>5||edges>=arr.length-1))||(type=="node"&&(nodes>5||nodes>=arr.length-1))){return{data:obj,rows:Math.max(nodes,edges),fail:fail,type:type}}else{return arr}}}}};this.XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p){json[p].push(j)}}else{if(p=="alt"){json[p].push(xml.textContent.replace(/\"/g,"'").replace(/\[/g,"&#91").replace(/\]/g,"&#93"))}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();this.XMLToJSON(n,json,p)}}}}}return json};this.cytoscapeToCX=function(xml,target,config,events){var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var nodes=[];var edges=[];var title="";var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="graph"){var ob=this.XMLToJSON(pw,false,false,true);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();var js=this.XMLToJSON(el);switch(nn){case"node":if(js.graphics&&js.id){var gr=js.graphics[0];var node={id:js.id,x:Number(gr.x),y:Number(gr.y),z:Number(gr.z),width:Number(gr.w),height:Number(gr.h),shape:(sp[gr.type]||gr.type),color:gr.fill,outline:gr.outline,outlineWidth:Number(gr.width)};if(js.label){node.name=js.label}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/NODE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.name=="COMMON"&&at.value){node.label=at.value}else{if(at.value){node[at.name]=at.value}}break;case"Double":case"Integer":if(at.value!=null){node[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){node[at.name]=at.value==0?false:true}break}}}}nodes.push(node)}break;case"edge":if(js.source&&js.target){var edge={id1:js.source,id2:js.target};if(js.id){edge.intId=js.id}if(js.label){edge.label=js.label}if(js.directed){edge.directed=js.directed}if(js.graphics){edge.color=js.graphics[0].fill;edge.width=js.graphics[0].width}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/EDGE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.value){edge[at.name]=at.value}break;case"Double":case"Integer":if(at.value!=null){edge[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){edge[at.name]=at.value==0?false:true}break}}}}edges.push(edge)}break;case"att":if(js.name&&js.value&&js.name=="Dataset Name"){title=js.value}break}}}}else{alert("Ooops! Not a cytoscape xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Cytoscape"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.keggToCX=function(xml,target,config,events){var that=this;var pw=xml.childNodes[2]||xml.childNodes[1];var nodes=[];var edges=[];var title,image,link,width,height;var addAnchors=function(){nodes.push({id:"__zero__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:0,y:0,hideLabel:true},{id:"__max__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:width,y:height,hideLabel:true})};if(pw.tagName.toLowerCase()=="pathway"){var ob=this.XMLToJSON(pw,false,false,true);title=ob.title;image=ob.image;link=ob.link;var img=new Image();img.onload=function(){width=this.width;height=this.height;var res="Number of Nodes: "+nodes.length+"\n";res+="Number of Edges: "+edges.length+"\n";addAnchors();that.remoteServiceType="file";that.networkFreeze=false;var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,networkFreeze:false,showNodeNameThreshold:20000,preScaleNetwork:false,title:title,backgroundType:"image",backgroundImage:image,networkVendor:"Kegg"},renderTo:target,events:events,uploadFile:(that.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=that.dataURL||that.dataString;var cnfg=that.cloneObject(that.meta.config.user);if(that.graphType=="Network"){for(var p in that.meta.config.user){data.config[p]=that.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}that.updateRemoteData(data,clbk);that.hideMask()};if((CanvasXpress.system.isR&&!CanvasXpress.system.isInIframe)||!CanvasXpress.system.isR){img.crossOrigin="anonymous"}img.src=ob.image;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"entry":var ob=this.XMLToJSON(el);if(ob.graphics[0].type=="roundrectangle"){ob.graphics[0].type="roundrect";ob.graphics[0].fgcolor="rgba(0,0,0,0)"}if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type!="line"){var ext=ob.type=="group"?5:0;var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:ob.graphics[0].type,color:"rgba(0,0,0,0)",outline:that.validateColor(ob.graphics[0].fgcolor)||"rgb(0,0,0)",width:parseInt(ob.graphics[0].width)+ext,height:parseInt(ob.graphics[0].height)+ext,x:parseInt(ob.graphics[0].x),y:parseInt(ob.graphics[0].y),hideLabel:true,fixed:true};if(ob.type=="group"){nodes.unshift(node)}else{nodes.push(node)}}else{if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type=="line"){var coords=ob.graphics[0].coords.split(",");if(coords.length==4){var x=[];var y=[];var w,h,r;while(coords.length>1){x.push(parseInt(coords.shift()));y.push(parseInt(coords.shift()))}var mx=parseInt(this.mean(x));var my=parseInt(this.mean(y));if(x[0]==x[1]){mx+=1;w=2;h=y[1]-y[0];r=0}else{if(y[0]==y[1]){my+=1;w=x[1]-x[0];h=2;r=0}else{h=this.lineLength(x[0],y[0],x[1],y[1]);w=2;r=this.getAngle(x[0],y[0],x[1],y[1])}}var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:"rect",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",x:mx,y:my,width:w,height:h,rotate:r,hideLabel:true,fixed:true};nodes.push(node)}}}break;case"relation":case"reaction":var ob=this.XMLToJSON(el);ob.id1=this.cloneObject(ob.entry1);ob.id2=this.cloneObject(ob.entry2);delete (ob.entry1);delete (ob.entry2);ob.color="rgba(0,0,0,0)";edges.push(ob);break}}}}else{alert("Ooops! Not a kgml file!")}};this.wikipathwayToCX=function(xml,target,config,events){var pw=xml.childNodes[0];var nodes={};var edges=[];var state={};var groups={};var anchors={};var order={};var cntp=1;var cntn=0;var sord=[];var groupRef={};var groupGref={};var groupId={};var wrn="\nWarnings:\n";var htt=false;var title,subtitle;var arrowTypes={Line:false,Arrow:"arrow",TBar:"square","mim-necessary-stimulation":false,"mim-binding":false,"mim-conversion":"arrow","mim-stimulation":"arrow","mim-catalysis":"round","mim-modification":false,"mim-inhibition":"square","mim-covalent-bond":false,"mim-transcription-translation":false};var createNodeFromGroup=function(grp,id){var mnx=Number.MAX_VALUE;var mny=Number.MAX_VALUE;var mxx=-Number.MAX_VALUE;var mxy=-Number.MAX_VALUE;var ids=[];var ord=[];var shw=false;for(var i=0;i<grp.length;i++){mnx=Math.min(mnx,grp[i][1]-(grp[i][3]/2));mny=Math.min(mny,grp[i][2]-(grp[i][4]/2));mxx=Math.max(mxx,grp[i][1]+(grp[i][3]/2));mxy=Math.max(mxy,grp[i][2]+(grp[i][4]/2));ids.push(grp[i][0]);nodes[grp[i][0]].parentNode=id;ord.push(nodes[grp[i][0]].zorder);if(nodes[grp[i][0]].nodeName!="label"){shw=true}ord.sort(function(a,b){return a-b})}var w=mxx-mnx;var h=mxy-mny;var ob={id:id,x:(mnx+mxx)/2,y:(mny+mxy)/2,width:w+(grp.length>1&&w>10?5:0),height:h+(grp.length>1&&h>10?5:0),group:ids,hideLabel:true,hideTooltip:htt,type:"Group",color:(shw?"rgba(245,245,245,0.5)":"rgba(0,0,0,0)"),outline:(shw?"rgb(0,0,0)":"rgba(0,0,0,0)"),shape:"rectangle",zorder:ord[0]};order[id]=cntn--;nodes[id]=ob;sord.push(id)};var createNodeFromPoint=function(p,id){var ob={id:id,x:Math.round(p.x*10)/10,y:Math.round(p.y*10)/10,width:p.width?Math.round(p.width):1,height:p.height?Math.round(p.height):1,hideLabel:p.show?false:true,hideTooltip:!htt?false:p.show?false:true,eventless:p.show?false:true,type:p.type||"Anchor",color:p.color||"rgba(0,0,0,0)",outline:p.outline||"rgba(0,0,0,0)",shape:p.shape||"circle",label:p.label||"",zorder:p.zorder||0};order[id]=cntp++;nodes[id]=ob;sord.push(id)};var getDirection=function(s){switch(s){case"r":case"l":return"rl";case"b":case"t":case"c":return"tb"}};var getSide=function(p){if(parseInt(p.relx)==1){return"r"}else{if(parseInt(p.relx)==-1){return"l"}else{if(parseInt(p.rely)==1){return"b"}else{if(parseInt(p.rely)==-1){return"t"}else{if(Math.abs(p.relx)>Math.abs(p.rely)){if(parseFloat(p.relx)>0){return"r"}else{return"l"}}else{if(parseFloat(p.rely)>0){return"b"}else{if(parseFloat(p.rely)<0){return"t"}else{return"c"}}}}}}}};var getNumberOfLines=function(s,t){var findExtra=function(sd,p1,p2){switch(sd){case"r":if(parseFloat(p1.x)>=parseFloat(p2.x)){return 2}break;case"l":if(parseFloat(p1.x)<=parseFloat(p2.x)){return 2}break;case"t":case"c":if(parseFloat(p1.y)<=parseFloat(p2.y)){return 2}break;case"b":if(parseFloat(p1.y)>=parseFloat(p2.y)){return 2}break}return 0};var ss=getSide(s);var ts=getSide(t);var ls=2;if(getDirection(ss)==getDirection(ts)){ls++}if(ss!=ts){ls+=findExtra(ss,s,t);ls+=findExtra(ts,t,s)}return ls};var getPoint=function(s,a,f){if(f){switch(s){case"r":return[a[0]+20,a[1]];case"l":return[a[0]-20,a[1]];case"t":case"c":return[a[0],a[1]-20];case"b":return[a[0],a[1]+20]}}else{switch(s){case"r":case"l":return[a[0][0],a[1][1]];case"t":case"b":case"c":return[a[1][0],a[0][1]]}}};var getCoords=function(d,a){var r=[a[0]];var l=a[0];for(var i=1;i<a.length;i++){var c=a[i];switch(d){case"rl":r.push([c[0],l[1]]);break;case"tb":r.push([l[0],c[1]]);break}l=r[i];d=d=="rl"?"tb":"rl"}r.push(a[a.length-1]);return r};var to2DArray=function(edg){var ps=edg.point;var a=[];for(var i=0;i<ps.length;i++){a.push([Math.round(ps[i].x*10)/10,Math.round(ps[i].y*10)/10])}return a};var getElbowPoints=function(edg){var ps=edg.point;var n1=ps.length-1;var ls=getNumberOfLines(ps[0],ps[n1]);var s=getSide(ps[0]);var t=getSide(ps[n1]);var d=getDirection(s);var a=to2DArray(edg);if(ls==ps.length){a=getCoords(d,a)}else{if(ps.length==2){a.splice(1,0,getPoint(s,a[0],true));if(ls>3){if(ls>3){a.splice(2,0,getPoint(t,a[2],true))}if(ls>4){if(ls>4){a.splice(3,0,[(a[1][0]+a[2][0])/2,(a[1][1]+a[2][1])/2])}if(ls>5){a=to2DArray(edg);a=getCoords(d,a)}}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}else{if((a[0][0]==a[1][0]&&a[1][0]==a[2][0])||(a[0][1]==a[1][1]&&a[1][1]==a[2][1])){a.splice(1,1)}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}}else{if(ps.length>ls){a=getCoords(d,a)}else{for(var i=0;i<n1;i++){var j=i*2;if(d=="tb"){d="rl";a.splice(j+1,0,[a[j][0],a[j+1][1]])}else{d="tb";a.splice(j+1,0,[a[j+1][0],a[j][1]])}}}}}var b=[[a[0][0],a[0][1]]];for(var i=1;i<a.length;i++){if(a[i][0]==a[i-1][0]&&a[i][1]==a[i-1][1]){continue}b.push([a[i][0],a[i][1]])}return b};var getBezierPoints=function(edg,sn,tn){var ps=edg.point;var n1=ps.length-1;var s=getSide(ps[0]);var t=getSide(ps[n1]);var ds=getDirection(s);var dt=getDirection(t);var ar=to2DArray(edg);var segs=[];var p0,p1,mx,my;if(n1==1){p0=ar[0];p1=ar[1];if(sn&&tn){if(ds==dt){mx=(p0[0]+p1[0])/2;my=(p0[1]+p1[1])/2;if(ds=="tb"){if(t=="t"){if(my>tn.y-tn.height){my-=tn.height}}else{if(t=="b"){if(my<tn.y+tn.height){my+=tn.height}}}segs.push([p0[0],p0[1],p0[0],my,mx,my]);segs.push([mx,my,p1[0],my,p1[0],p1[1]])}else{if(t=="l"){if(mx>tn.x-tn.width){mx-=tn.width*0.5}}else{if(t=="r"){if(mx<tn.x+tn.width){mx+=tn.width*0.5}}}segs.push([p0[0],p0[1],mx,p0[1],mx,my]);segs.push([mx,my,mx,p1[1],p1[0],p1[1]])}}else{if(s=="t"||s=="b"){mx=t=="l"?-tn.width*0.5:t=="r"?tn.width*0.5:-tn.width*0.5;my=(p1[1]-p0[1])/3;if((t=="l"&&p0[0]>tn.x-tn.width)||(t=="r"&&p0[0]<tn.x+tn.width)){segs.push([p0[0],p0[1],p0[0],p0[1]+my,p1[0],p0[1]+my]);segs.push([p1[0],p0[1]+my,p1[0]+mx,p0[1]+my,p1[0]+mx,p0[1]+my+my]);segs.push([p1[0]+mx,p0[1]+my+my,p1[0]+mx,p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}else{mx=(p1[0]-p0[0])/3;my=t=="t"?-tn.height:t=="b"?tn.height:-tn.height;if((t=="t"&&p0[1]>tn.y-tn.height)||(t=="b"&&p0[1]<tn.y+tn.height)){segs.push([p0[0],p0[1],p0[0]+mx,p0[1],p0[0]+mx,p1[1]]);segs.push([p0[0]+mx,p1[1],p0[0]+mx,p1[1]+my,p0[0]+mx+mx,p1[1]+my]);segs.push([p0[0]+mx+mx,p1[1]+my,p1[0],p1[1]+my,p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}}}}else{p0=ar[0];if(s=="t"||s=="b"){for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}else{for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}}return segs};var getStatePosition=function(n,s){var x=parseFloat(s.relx);var y=parseFloat(s.rely);var w=n.width/2;var h=n.height/2;return[n.x+(x*w),n.y+(y*h)]};var XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&(p=="point"||p=="anchor")&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p&&(p=="point"||p=="anchor")){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p&&(p=="point"||p=="anchor")){json[p].push(j)}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();XMLToJSON(n,json,p)}}}}}return json};if(pw.tagName.toLowerCase()=="pathway"){var ob=XMLToJSON(pw,false,false,true);title=ob.name;subtitle=ob.organism;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"comment":break;case"graphics":break;case"state":var ob=XMLToJSON(el);ob.nodeName=nn;state[ob.graphid]=ob;break;case"datanode":case"label":case"shape":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.centerx){ob.x=Math.round(ob.centerx*10)/10;delete (ob.centerx)}if(ob.centery){ob.y=Math.round(ob.centery*10)/10;delete (ob.centery)}if(ob.width){ob.width=parseInt(ob.width)}if(ob.height){ob.height=parseInt(ob.height)}if(ob.textlabel){ob.label=ob.textlabel;delete (ob.textlabel)}if(ob.database&&ob.id){ob.database+=" : "+ob.id}if(ob.graphid){ob.id=ob.graphid}if(ob.fontsize){ob.labelSize=parseInt(ob.fontsize)}if(ob.rotation){ob.rotate=(parseFloat(ob.rotation)*180/Math.PI)+180}if(ob.shapetype){if(ob.shapetype=="RoundedRectangle"){ob.shapetype=ob.value&&ob.value=="Double"?"roundrectd":"roundrect"}if(ob.shapetype=="Arc"){ob.shapetype="arc3"}if(ob.shapetype=="Mitochondria"){ob.shapetype="image";ob.imagePath="https://www.canvasxpress.org/assets/images/mit.png"}if(this.isValidShape(ob.shapetype.toLowerCase())){ob.shape=ob.shapetype.toLowerCase()}else{if(ob.shapetype=="None"){ob.shape="rectangle"}else{wrn+=ob.id+" has an unkown shape: "+ob.shapetype+"\n";ob.shape=ob.shapetype}}if(ob.shape=="oval"&&ob.value&&ob.value=="Double"){ob.shape="ovald"}delete (ob.shapetype)}if(!ob.shape){ob.shape="rectangle"}if(nn=="shape"){ob.labelColor=ob.color?this.validateColor(ob.color):"rgb(0,0,0)"}else{if(ob.color){ob.labelColor=this.validateColor(ob.color)}else{ob.labelColor="rgb(0,0,0)"}}if(ob.fillcolor){ob.color=this.validateColor(ob.fillcolor);delete (ob.fillcolor)}else{ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(0,0,0)"){ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(255,255,255)"){ob.color="rgba(255,255,255,0)"}if(nn=="label"){if(!ob.label||ob.label==""){ob.hideLabel=true;ob.hideTooltip=htt;ob.eventless=true}ob.outline="rgba(0,0,0,0)";ob.color="rgba(0,0,0,0)"}else{ob.outline=ob.labelColor}if(nn=="shape"&&(!ob.label||ob.label=="")){ob.hideLabel=true;ob.hideTooltip=htt;ob.outline=ob.labelColor}if(ob.groupref){if(!groupRef.hasOwnProperty(ob.groupref)){groupRef[ob.groupref]=[]}groupRef[ob.groupref].push([ob.id,ob.x,ob.y,ob.width,ob.height]);ob.parentNode=ob.groupref}order[ob.id]=cntp++;nodes[ob.id]=ob;sord.push(ob.id);break;case"interaction":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.anchor){for(var j=0;j<ob.anchor.length;j++){anchors[ob.anchor[j].graphid]=true}delete (ob.anchor)}var n1=ob.point.length-1;if(ob.point[0].graphref&&ob.point[n1].graphref){ob.id1=ob.point[0].graphref;ob.id2=ob.point[n1].graphref}var type="solid";if(ob.linestyle&&ob.linestyle=="Broken"){type="dashed"}if(ob.connectortype&&ob.connectortype=="Curved"){type+="Bezier"}ob.type=type;if(ob.point[0].arrowhead){if(arrowTypes[ob.point[0].arrowhead]){ob.startArrow=arrowTypes[ob.point[0].arrowhead]}}if(ob.point[n1].arrowhead){if(arrowTypes[ob.point[n1].arrowhead]){ob.endArrow=arrowTypes[ob.point[n1].arrowhead]}}if(ob.linethickness){ob.thickness=parseInt(ob.linethickness*10)/10;delete (ob.linethickness)}if(ob.point[0].relx&&ob.point[0].rely){ob.startX=parseFloat(ob.point[0].relx);ob.startY=parseFloat(ob.point[0].rely)}if(ob.point[n1].relx&&ob.point[n1].rely){ob.endX=parseFloat(ob.point[n1].relx);ob.endY=parseFloat(ob.point[n1].rely)}delete (ob.id);edges.push(ob);break;case"group":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.groupref&&ob.groupid){if(!groups.hasOwnProperty(ob.groupref)){groups[ob.groupref]=[]}groups[ob.groupref].push(ob.groupid);groupGref[ob.graphid]=ob.groupref}else{groupId[ob.graphid]=ob.groupid}break;case"infobox":break;case"legend":break;case"biopax":break}}}}else{alert("Ooops! Not a gpml file!")}for(var s in state){var g=state[s].graphref;if(nodes[g]){var c=getStatePosition(nodes[g],state[s]);var p={id:g,x:c[0],y:c[1],width:state[s].width,height:state[s].height,label:state[s].textlabel==""?" ":state[s].textlabel,type:"State",color:state[s].textlabel==""?"rgb(255,255,255)":this.validateColor(state[s].fillcolor),outline:"rgb(0,0,0)",shape:"oval",show:true};createNodeFromPoint(p,s)}}for(var g in groupRef){createNodeFromGroup(groupRef[g],g)}for(var g in groups){if(groupRef.hasOwnProperty(g)){for(var i=0;i<groups[g].length;i++){var ob=nodes[groups[g][i]];groupRef[g].push([ob.id,ob.x,ob.y,ob.width,ob.height])}createNodeFromGroup(groupRef[g],g)}}var edgs=[];var fail=[];for(var i=0;i<edges.length;i++){var ob=edges[i];var n1=ob.point.length-1;if(!ob.point[0].graphref&&!ob.point[n1].graphref){ob.exact=true}for(var j=0;j<ob.point.length;j++){var pt=ob.point[j];if(pt.graphref){if(!nodes.hasOwnProperty(pt.graphref)){if(j==0){if(groupId[pt.graphref]){ob.id1=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactStart=anchors[pt.graphref]?true:false;ob.id1=pt.graphref}}else{if(j==ob.point.length-1){if(groupId[pt.graphref]){ob.id2=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactEnd=anchors[pt.graphref]?true:false;ob.id2=pt.graphref}}}}}else{if(j==0||j==ob.point.length-1){var id=j==0?ob.graphid+".1":ob.graphid+".2";var ni=j==0?ob.point.length-1:0;createNodeFromPoint(pt,id);if(j==0){ob.id1=id;ob.exactStart=true}else{ob.id2=id;ob.exactEnd=true}ob.hideTooltip=htt;if(ob.point[ni].graphref){if(!nodes.hasOwnProperty(ob.point[ni].graphref)&&groupId[ob.point[ni].graphref]){if(j==0){ob.id2=groupId[ob.point[ni].graphref]}else{ob.id1=groupId[ob.point[ni].graphref]}}else{if(j==0){ob.id2=ob.point[ni].graphref}else{ob.id1=ob.point[ni].graphref}}}}}}if(ob.connectortype){if(ob.connectortype=="Elbow"){ob.elbows=getElbowPoints(ob)}else{if(ob.connectortype=="Curved"){ob.elbows=getBezierPoints(ob,nodes[ob.id1],nodes[ob.id2])}else{if(ob.connectortype=="Segmented"){ob.elbows=to2DArray(ob)}}}}if(nodes[ob.id1]&&nodes[ob.id2]){edgs.push(ob)}else{fail.push(ob)}}sord.sort(function(a,b){if(nodes[a].zorder&&nodes[b].zorder){if(parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)==0){return order[a]-order[b]}else{return parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)}}else{return order[a]-order[b]}});var nods=[];for(var i=0;i<sord.length;i++){nods.push(nodes[sord[i]])}var res="Number of Nodes: "+nods.length+"\n";res+="Number of Edges: "+edgs.length+"\n";if(fail.length>0){res+="Number of Failed Edges: "+fail.length+"\n";for(var i=0;i<fail.length;i++){res+="\t"+(i+1)+". "+fail[i].graphid+"\n"}}if(wrn!="\nWarnings:\n"){res+=wrn}res=res.replace(/\n/g,"<br>");var data={data:{nodes:nods,edges:edgs},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,networkVendor:"Wikipathways"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.metabaseToCX=function(xml,target,config,events){var that=this;var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var loc={3:"microsome",13:"epr",21:"lysosome",43:"nucleus",67:"golgi",1287:"mitochondria",1312:"peroxisome"};var getMembrane=function(node){var getNode=function(){return{shape:"rectangle",color:"rgba(255,255,255,0)",outline:"rgba(0,0,0,0)",outlineWidth:0,hideLabel:true,immutable:true,eventless:true,type:node.type,zorder:node.zorder+1,width:32,height:32}};var getNodeTL=function(){var nd=getNode();nd.id=node.id+"-membraneTL";nd.pattern="membraneTL";nd.x=node.x-(node.width*0.5);nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeTR=function(){var nd=getNode();nd.id=node.id+"-membraneTR";nd.pattern="membraneTR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeBL=function(){var nd=getNode();nd.id=node.id+"-membraneBL";nd.pattern="membraneBL";nd.x=node.x-(node.width*0.5);nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeBR=function(){var nd=getNode();nd.id=node.id+"-membraneBR";nd.pattern="membraneBR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeTop=function(s){var nd=getNode();nd.id=node.id+"-membraneT";nd.pattern="membraneTop";nd.x=node.x+(s==0?0:s==1?-16:s==2?16:0);nd.y=node.y-(node.height*0.5);nd.width=node.width-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeBottom=function(s){var nd=getNodeTop(s);nd.id=node.id+"-membraneB";nd.pattern="membraneBottom";nd.y=node.y+(node.height*0.5)-16;return nd};var getNodeRight=function(s){var nd=getNode();nd.id=node.id+"-membraneR";nd.pattern="membraneRight";nd.x=node.x+(node.width*0.5)-16;nd.y=node.y+(s==0?0:s==1?-16:s==2?16:0);nd.height=node.height-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeLeft=function(s){var nd=getNodeRight(s);nd.id=node.id+"-membraneL";nd.pattern="membraneLeft";nd.x=node.x-(node.width*0.5);return nd};switch(node.type){case 1:node.shape="rectangle";return[getNodeTop(0)];case 2:node.shape="rectangle";return[getNodeRight(0)];case 3:node.shape="roundrecttr";return[getNodeTop(1),getNodeRight(2),getNodeTR()];case 4:node.shape="rectangle";return[getNodeBottom(0)];case 5:node.shape="rectangle";return[getNodeTop(0),getNodeBottom(0)];case 6:node.shape="roundrectbr";return[getNodeBottom(1),getNodeRight(1),getNodeBR()];case 7:node.shape="roundrectr";return[getNodeTop(1),getNodeBottom(1),getNodeRight(3),getNodeBR(),getNodeTR()];case 8:node.shape="rectangle";return[getNodeLeft(0)];case 9:node.shape="roundrecttl";return[getNodeTop(2),getNodeLeft(2),getNodeTL()];case 10:node.shape="rectangle";return[getNodeRight(0),getNodeLeft(0)];case 11:node.shape="roundrectt";return[getNodeTop(3),getNodeRight(2),getNodeLeft(2),getNodeTR(),getNodeTL()];case 12:node.shape="roundrectbl";return[getNodeBottom(2),getNodeLeft(1),getNodeBL()];case 13:node.shape="roundrectl";return[getNodeTop(2),getNodeBottom(2),getNodeLeft(3),getNodeTL(),getNodeBL()];case 14:node.shape="roundrectb";return[getNodeBottom(3),getNodeRight(1),getNodeLeft(1),getNodeBR(),getNodeBL()];case 15:if(node.width<64||node.height<64){node.shape="rectangle";delete node.gradient;delete node.color1;delete node.color2;delete node.color3;return[getNodeTop(0)]}node.shape="roundrect2";return[getNodeTop(3),getNodeBottom(3),getNodeRight(3),getNodeLeft(3),getNodeTR(),getNodeTL(),getNodeBR(),getNodeBL()]}return[]};var getLengthToNodeBoundary=function(x0,y0,x1,y1,node){var wi=node.width;var he=node.height;var cl=that.clip("line",[x0,y0,x1,y1],[x0-(node.width/2),y0-(node.height/2),node.width+(x0-(node.width/2)),node.height+(y0-(node.height/2))]);return that.lineLength(cl[0],cl[1],cl[2],cl[3])+2};var nodes=[];var edges=[];var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="map"){var seen={};var sord=[];var n=0;var ob=this.XMLToJSON(pw,false,false,true);nodes.push({id:"__background__",type:"background",shape:"rectangle",color:"rgb(220,231,232)",outline:"rgb(29,154,195)",outlineWidth:3,width:Number(ob.width),height:Number(ob.height),x:Number(ob.width)*0.5,y:Number(ob.height)*0.5,hideLabel:true,immutable:true,eventless:true,zorder:1});sord.push(n++);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"localizations":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="loc"){var js=this.XMLToJSON(nd);var shp=loc.hasOwnProperty(js.id)?"image":js.id=="16"?"roundrect2":"roundrect";var node={id:"loc"+(j+1),shape:shp,hideLabel:true,immutable:true,eventless:true,x:Number(js.x)+(Number(js.width)*0.5),y:Number(js.y)+(Number(js.height)*0.5),width:Number(js.width),height:Number(js.height),type:Number(js.type),zorder:js.appearance&&js.appearance[0].zorder?Number(js.appearance[0].zorder.replace("Integer: ","")):2};if(shp!="image"){node.color="rgba(0,0,0,0)";node.outline=js.id=="16"?"rgba(0,0,0,0)":"rgb(83,158,188)";node.outlineWidth=js.id!="16"?3:0;if(js.id!="16"){node.width-=6;node.height-=6}}if(js.appearance&&js.appearance[0].rotateangle){node.rotate=Number(js.appearance&&js.appearance[0].rotateangle.split(": ")[1]);if(!node.rotate){delete node.rotate}else{node.widthTMP=node.width;node.width=node.height;node.height=node.widthTMP;delete node.widthTMP}}if(js.id=="16"){node.gradient="linear";node.color1="rgb(122,194,226)";node.color2="rgb(223,237,248)";node.color3="rgb(223,237,248)"}if(shp=="image"){if(js.id=="1287"){node.imagePath=js.type=="1"?CanvasXpress.images.mitochondria2:CanvasXpress.images.mitochondria}else{node.imagePath=CanvasXpress.images[loc[js.id]]}}for(var p in js){if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(": ");switch(vk[0]){case"String":node[a]=vk[1];break;case"Integer":case"Double":node[a]=Number(vk[1]);break;case"Boolean":node[a]=vk[1]=="true"?true:false;break}}}}nodes.push(node);sord.push(n++);if(Number(js.id)==16){var mem=getMembrane(node);if(mem.length){for(var k=0;k<mem.length;k++){nodes.push(mem[k]);sord.push(n++)}}}}}break;case"nodes":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="node"){var js=this.XMLToJSON(nd);var node={};for(var p in js){if(p.toLowerCase()=="alt"){if(js[p][0].match(/\w/)){node.tooltip=js[p][0].replace(/\"/g,"'");node.tooltip=js[p][0].replace(/\[/g,"&#91");node.tooltip=js[p][0].replace(/\]/g,"&#93")}}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(":");switch(vk[0]){case"String":node[a]=vk[1].replace(/\s/g,"");break;case"Integer":case"Double":node[a]=Number(vk[1].replace(/\s/g,""));break;case"Boolean":node[a]=vk[1].replace(/\s/g,"")=="true"?true:false;break;case"Rectangle":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"Color":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);node[a][3]=Math.round(node[a][3]/255*10)/10;node[a]="rgba("+node[a].join(",")+")";break;case"Font":node[a]=vk[1].replace(/\s/g,"").split(",");break}}}node[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}node.extId=js.id;node.id=js.nodeid.toString();node.x=Number(js.x)+(Number(js.width)*0.5);node.y=Number(js.y)+(Number(js.height)*0.5);node.width=Number(js.width);node.height=Number(js.height);if(node.iconarea){node.width=node.iconarea[2];node.height=node.iconarea[3];node.x=node.iconarea[0]+(node.width*0.5);node.y=node.iconarea[1]+(node.height*0.5);delete node.iconarea}if(js.icontype&&(js.type==0||js.type==16)){if(isNaN(js.icontype)){js.icontype=1000}if(Number(js.icontype)<10){js.icontype="0"+js.icontype}if(CanvasXpress.images.hasOwnProperty(js.icontype)){node.zoomX=50/node.width;node.zoomY=50/node.height;node.shape="image";node.imagePath=CanvasXpress.images[js.icontype];node.immutable=false}else{node.shape="roundrect";node.immutable=true}}else{if(js.icontype){switch(js.type){case"-10":node.width-=5;node.height-=5;node.x+=2.5;node.y+=2.5;node.shape=node.arcwidth>40?"roundrecto":"roundrect";break;case"21":case"61":case"63":case"91":case"-11":case"-12":node.width-=4;node.height-=4;node.x+=2;node.y+=2;node.shape="roundrect";break;default:break}node.immutable=true}else{node.shape="roundrect";node.immutable=true}}if(node.name==""){node.hideLabel=true}else{node.name=node.name.toString().replace(/\[/g,"&#91").replace(/\]/g,"&#93").replace(/\"/g,"&quot")}if(node.textarea){var lines=1;if(node.font){lines=Math.floor(node.textarea[3]/(Number(node.font[2])+(Number(node.font[2])>12?1:0)));node.labelSize=node.font[2]==14?1.1:1;if(node.font[0].match(/Bold Italic/i)){node.labelStyle="Bold Italic"}else{if(node.font[0].match(/Bold/i)){node.labelStyle="Bold"}else{if(node.font[0].match(/Italic/i)){node.labelStyle="Italic"}}}}if(lines>1&&!node.name.toString().match(/\n/)){var fnt=this.nodeFontStyle+" "+Math.floor(10*node.labelSize)+"px "+this.fontName;var tst=Math.floor(node.textarea[2]/5.5);var wrp=tst>0?this.wrapText(node.name.toString(),tst):node.name.toString();var lns=wrp.split(/\n/);var max=this.measureTextMultiple(wrp,fnt);if(lns.length>lines){while(lns.length>lines&&tst<node.name.toString().length){wrp=this.wrapText(node.name.toString(),tst++);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}if(max>node.textarea[2]){wrp=wrp.replace("(","\n(");lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt);while((max>node.textarea[2]||lns.length*fnt>node.textarea[3]||lns.length<lines)&&tst>3){wrp=this.wrapText(node.name,tst--);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}node.name=wrp}else{if(lines==0){node.hideLabel=true}}node.labelX=node.textarea[0]+(node.textarea[2]*0.5);node.labelY=node.textarea[1]+(node.textarea[3]*0.5)}if(node.textalignment!=null){if(node.textalignment==0){node.labelAlign="left";node.labelX-=(node.textarea[2]*0.45)}else{if(node.textalignment==1){node.labelAlign="center"}else{if(node.textalignment==2){node.labelAlign="right";node.labelX+=(node.textarea[2]*0.45)}}}}delete node.textarea;if(node.fontcolor){node.labelColor=node.fontcolor;delete node.fontcolor}if(node.backgroundcolor){node.color=node.backgroundcolor;delete node.backgroundcolor}if(node.bordercolor){node.outline=node.bordercolor;delete node.bordercolor}if(node.rotateangle){node.rotate=node.shape=="image"?-node.rotateangle:270-node.rotateangle;if(node.shape!="image"){node.labelRotate=-node.rotateangle}delete node.rotateangle}if(node.borderwidth){node.outlineWidth=Number(node.borderwidth)-1;delete node.borderwidth}seen[node.id]=n;delete node.appearance;delete node.icontype;nodes.push(node);sord.push(n++);if(node.complex){nodes.push({id:node.id+"-complex",x:node.x,y:node.y,width:14,height:14,shape:"star",color:"rgb(255,255,255)",hideLabel:true,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-complex"]=n;sord.push(n++);delete node.complex}if(node.pathstart){var rot=0;var ptx=0;var pty=0;switch(node.sideofpathstarteditor){case 0:rot=90;pty=-(40+node.pathstartarrowmargin);break;case 1:rot=180;ptx=(40+node.pathstartarrowmargin);break;case 2:rot=270;pty=(40+node.pathstartarrowmargin);break;case 3:rot=0;ptx=-(40+node.pathstartarrowmargin);break}nodes.push({id:node.id+"-pathstart",x:node.x+ptx,y:node.y+pty,width:40,height:40,shape:"image",imagePath:CanvasXpress.images["99"],hideLabel:true,immutable:true,rotate:rot,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-pathstart"]=n;sord.push(n++);delete node.sideofpathstarteditor;delete node.pathstartarrowmargin;delete node.pathstart}if(node.organismspecificobject){nodes.push({id:node.id+"-organism",x:node.x,y:node.y,width:60,height:60,shape:"circle",color:"rgba(0,0,0,0.1)",outline:"rgb(255,255,0)",outlineWidth:3,hideLabel:true,zorder:node.zorder-1,parentNode:node.id});seen[node.id+"-organism"]=n;sord.push(n++);delete node.organismspecificobject}}}break;case"edges":for(var j=0;j<el.childNodes.length;j++){var ed=el.childNodes[j];if(ed.nodeName&&ed.nodeName.toLowerCase()=="edge"){var js=this.XMLToJSON(ed);var edge={};for(var p in js){if(p.toLowerCase()=="alt"){continue}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){if(a=="linkhighlighting"){vk=js[p][0][a].split(":");if(vk[1]=="Color"&&vk[2]){vk[2]=vk[2].split(",");vk[2].pop();edge.highlight="rgb("+vk[2].join(",")+")"}}else{vk=js[p][0][a].split(": ");switch(vk[0]){case"String":edge[a]=vk[1];break;case"Integer":case"Double":edge[a]=Number(vk[1]);break;case"Boolean":edge[a]=vk[1]=="true"?true:false;break;case"Rectangle":edge[a]=vk[1].replace(/\s/g,"").split(",").map(Number.isFinite);break;case"PointArray":var cp=[];vk[1]=vk[1].replace(/\s/g,"").split(";");for(var k=0;k<vk[1].length-1;k++){cp.push(vk[1][k].split(",").map(Number.isFinite))}edge[a]=cp;break}}}}edge[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}edge.id1=js.src;edge.id2=js.dst;if(edge.type){edge.EdgeType=edge.type;delete edge.type}if(edge.directed){edge.endArrow="arrow";delete edge.directed}edge.color="grey";edge.type=edge.enhances?"dashed":"solid";if(edge.visualization=="Round"){edge.type="quadratic";edge.angle=edge.angle}else{if(edge.visualization=="Bezier"){if(!edge.controlpoints){edge.type="solid";edge.linksourcepointindex=0;edge.linktargetpointindex=0}else{edge.type="bezier";edge.angle=edge.angle}}}if(edge.hasOwnProperty("effect")){if(edge.effect>=0){switch(edge.effect){case 0:edge.color="rgb(152,156,158)";break;case 1:edge.color="rgb(0,128,0)";break;case 2:edge.color="rgb(170,0,0)";break}}if(edge.mech!=null){var dec={};if(edge.showhexagon){var col=edge.hexagoncustomcolor||edge.color;var idx=edge.hexagonindex||0;var pos=edge.hexagoncoordinate||0.5;var cll=edge.effect==0?"black":"rgb(242,216,0)";var getDec=function(lbl){return{label:lbl,labelColor:cll,shape:"hexagon",color:col,index:idx,pos:pos}};switch(edge.mech){case -1:dec=getDec("");break;case 0:dec=getDec("?");break;case 2:dec=getDec("CM");break;case 3:dec=getDec("+P");break;case 4:dec=getDec("-P");break;case 5:dec=getDec("B");break;case 6:dec=getDec("Cn");break;case 7:dec=getDec("T");break;case 8:dec=getDec("C");break;case 9:dec=getDec("TR");break;case 10:dec=getDec("GR");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 11:dec=getDec("CR");break;case 12:dec=getDec("IE");break;case 14:dec=getDec("CS");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 15:dec=getDec("Z");break;case 16:dec=getDec("Tn");break;case 20:dec=getDec("cRT");break;case 21:dec=getDec("PE");break;case 22:dec=getDec("TE");break;case 24:dec=getDec("M");break;case 31:dec=getDec("SR");break;case 44:dec=getDec("RG");break;default:dec=getDec("");break}if(dec.label!=""){edge.decoration=[dec]}}delete edge.effect;delete edge.mech;delete edge.hexagonindex;delete edge.hexagoncoordinate;delete edge.showhexagon;delete edge.hexagoncustomcolor}}if(edge.broken){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"X",labelColor:"purple",fontSize:20,shape:"square",color:"rgba(0,0,0,0)",index:(edge.brokenindex||0),pos:(edge.brokencoordinate||0.5)});delete edge.broken;delete edge.brokenindex;delete edge.brokencoordinate}if(edge.weakens){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"-x-",labelColor:"purple",fontSize:12,shape:"square",color:"rgba(0,0,0,0)",index:(edge.weakensindex||0),pos:(edge.weakenscoordinate||0.5)});delete edge.weakens;delete edge.weakensindex;delete edge.weakenscoordinate}if(edge.disease){edge.color="purple";edge.thickness=2;delete edge.disease}if(edge.enhances){edge.color="purple";edge.thickness=2;delete edge.enhances}delete edge.appearance;delete edge.src;delete edge.dst;if(seen.hasOwnProperty(edge.id1)&&seen.hasOwnProperty(edge.id2)){var src=nodes[seen[edge.id1]];var dst=nodes[seen[edge.id2]];var sx=src.x;var sy=src.y;var sw=src.width*0.5;var sh=src.height*0.5;var ex=0;var ey=0;var dx=dst.x;var dy=dst.y;var dw=dst.width*0.5;var dh=dst.height*0.5;var ss,sd,sq,ds,dd,dq,xy,cx,cy,rd,frs,lst,n1;if(edge.visualization&&edge.visualization=="Right angle polyline"){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(edge.firstleg&&edge.firstleg=="Vertical"){frs=edge.controlpoints?edge.controlpoints[0][1]:false;sy=frs&&frs[1]>0?sy+sh:src.y>dst.y?sy-sh:frs&&frs<0?sy-sh:sy+sh;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{if(ss==1){sx=sx+sw}else{if(ss==3){sx=sx-sw}}}sq="tb"}else{frs=edge.controlpoints?edge.controlpoints[0][0]:false;sx=frs&&frs>0?sx+sw:src.x>dst.x?sx-sw:frs&&frs<0?sx-sw:sx+sw;if(ss==1||ss==3){sy=(sy-sh)+(src.height*sd)}else{if(ss==0){sy=sy-sh}else{if(ss==2){sy=sy+sh}}}sq="lr"}ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(!edge.controlpoints){if(edge.firstleg&&edge.firstleg=="Vertical"){dx=src.x>dst.x?dx+dw:dx-dw;if(ds==1||ds==3){dy=(dy-dh)+(dst.height*dd)}}else{dy=src.y>dst.y?dy+dh:dy-dh;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}}}else{dq=edge.controlpoints.length%2?sq:sq=="tb"?"lr":"tb";n1=edge.controlpoints.length-1;lst=edge.controlpoints[n1];if(edge.linktargetpointindex){if(ds==1||ds==3){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}dy=(dy-dh)+(dst.height*dd)}else{if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd);if(src.y+lst[1]>dst.y){dy+=dh}else{dy-=dh}}}}else{if(edge.controlpoints.length%2){if(sq==dq&&sq=="lr"){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}}}else{dx=src.x+lst[0]>dst.x?dx+dw:dx-dw}if(edge.controlpoints.length%2){if(sq!=dq||sq!="lr"){dy=src.y+lst[1]>dst.y?dy+dh:dy-dh}}else{if(src.y+lst[1]>dst.y){dy=dy+dh}}}}if(edge.controlpoints){edge.elbows=[[sx,sy]];cx=sx;cy=sy;if(edge.firstleg&&edge.firstleg=="Vertical"){for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cx=sx+edge.controlpoints[k][0]}else{cy=sy+edge.controlpoints[k][1]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([dx,cy])}else{edge.elbows.push([cx,dy])}}else{for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cy=sy+edge.controlpoints[k][1]}else{cx=sx+edge.controlpoints[k][0]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([cx,dy])}else{edge.elbows.push([dx,cy])}}edge.elbows.push([dx,dy])}else{if(edge.firstleg&&edge.firstleg=="Vertical"){edge.elbows=[[sx,sy],[sx,dy],[dx,dy]]}else{edge.elbows=[[sx,sy],[dx,sy],[dx,dy]]}}}else{if(edge.controlpoints&&edge.linksourcepointindex!=null&&edge.linktargetpointindex!=null&&edge.id1!=edge.id2){if(edge.linksourcepointindex||edge.controlpoints){frs=edge.controlpoints?edge.controlpoints[0]:[0,0];if(edge.linksourcepointindex==0){ds=getLengthToNodeBoundary(sx,sy,sx+frs[0],sy+frs[1],src);xy=this.getCoordinateAtDistance(sx,sy,sx+frs[0],sy+frs[1],ds);rd=this.getRadians(sx,sy,sx+frs[0],sy+frs[1]);sx=xy[0];sy=xy[1];ex=(-ds*-Math.cos(rd));ey=ds*Math.sin(rd)}else{ss=Math.floor((edge.linksourcepointindex-1)/src.linkpointcount);sd=(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1);switch(ss){case 0:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy-sh;break;case 1:ex=0;ey=(src.height*sd);sx=sx+sw;sy=ey+sy-sh;break;case 2:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy+sh;break;case 3:ex=0;ey=(src.height*sd);sx=sx-sw;sy=ey+sy-sh;break}}}if(edge.linktargetpointindex||edge.controlpoints){lst=edge.controlpoints?this.cloneObject(edge.controlpoints[edge.controlpoints.length-1]):[0,0];if(edge.linktargetpointindex==0){if(edge.controlpoints){lst[0]=dx-(sx+lst[0]);lst[1]=dy-(sy+lst[1])}ds=getLengthToNodeBoundary(dx,dy,dx+lst[0],dy+lst[1],dst);xy=this.getCoordinateAtDistance(dx,dy,dx+lst[0],dy+lst[1],-ds);rd=this.getRadians(dx,dy,dx+lst[0],dy+lst[1]);dx=xy[0];dy=xy[1]}else{ds=Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount);dd=(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1);switch(ds){case 0:dx=(dst.width*dd)+dx-dw;dy=dy-dh;break;case 1:dx=dx+dw;dy=(dst.height*dd)+dy-dh;break;case 2:dx=(dst.width*dd)+dx-dw;dy=dy+dh;break;case 3:dx=dx-dw;dy=(dst.height*dd)+dy-dh;break}}}edge.elbows=[];for(var k=0;k<edge.controlpoints.length;k++){edge.elbows.push([sx+edge.controlpoints[k][0]+5,sy+edge.controlpoints[k][1]])}edge.elbows.unshift([sx,sy]);edge.elbows.push([dx,dy])}else{if(edge.id1==edge.id2){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;if(ss==ds){edge.self={dir:edge.angle>0,pos:(ss==0?"top":ss==1?"right":ss=2?"bottom":"left"),size:20,end:"arrow"}}else{if(ss>ds||(ss==0&&ds==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topLeft":ss=1?"topRight":ss==2?"bottomRight":"bottomLeft"),size:20,end:"arrow"}}else{if(ds>ss||(ds==0&&ss==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topRight":ss==1?"bottomRight":ss==2?"bottomLeft":"topLeft"),size:20,end:"arrow"}}}}}else{if(edge.linksourcepointindex){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{sy=(sy-sh)+(src.height*sd)}}if(edge.linktargetpointindex){ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}else{dy=(dy-dh)+(dst.height*dd)}}if(edge.linksourcepointindex||edge.linktargetpointindex){if(edge.linksourcepointindex){switch(ss){case 0:sy-=sh;break;case 1:sx+=sw;break;case 2:sy+=sh;break;case 3:sx-=sw;break}if(!edge.linktargetpointindex){ds=getLengthToNodeBoundary(dx,dy,sx,sy,dst);xy=this.getCoordinateAtDistance(dx,dy,sx,sy,ds);dx=xy[0];dy=xy[1]}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}}}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}ds=getLengthToNodeBoundary(sx,sy,dx,dy,src);xy=this.getCoordinateAtDistance(sx,sy,dx,dy,ds);sx=xy[0];sy=xy[1]}edge.elbows=[[sx,sy],[dx,dy]]}}}}delete edge.linksourcepointindex;delete edge.linktargetpointindex;delete edge.controlpoints;delete edge.visualization;delete edge.firstleg;edges.push(edge)}}}break}}}sord.sort(function(a,b){if(nodes[a].zorder-nodes[b].zorder==0){return a-b}else{return nodes[a].zorder-nodes[b].zorder}});var tmp=[];for(var i=0;i<sord.length;i++){tmp.push(nodes[sord[i]])}nodes=tmp}else{alert("Ooops! Not a Metabase xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Metabase"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.gexfToCX=function(xml,target,config,events){var nodes=[];var edges=[];var cl=true;var gexf=xml.childNodes[0];if(gexf.tagName.toLowerCase()=="gexf"){for(var i=0;i<gexf.childNodes.length;i++){var el=gexf.childNodes[i];if(el.nodeName&&el.nodeName.toLowerCase()=="graph"){for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="nodes"){for(var k=0;k<nd.childNodes.length;k++){var n=nd.childNodes[k];if(n.nodeName&&n.nodeName.toLowerCase()=="node"){var js=this.XMLToJSON(n);var node={};if(js.id){for(var p in js){switch(p.toLowerCase()){case"id":node.id=js.id;break;case"label":node.name=js.label;break;case"color":node.color="rgb("+js[p][0].r+","+js[p][0].g+","+js[p][0].b+")";break;case"position":node.x=Number(js[p][0].x);node.y=Number(js[p][0].y);node.z=Number(js[p][0].z);cl=false;break;case"size":node.width=Number(js[p][0].value);node.height=Number(js[p][0].value);break}}nodes.push(node)}}}}else{if(nd.nodeName&&nd.nodeName.toLowerCase()=="edges"){for(var k=0;k<nd.childNodes.length;k++){var e=nd.childNodes[k];if(e.nodeName&&e.nodeName.toLowerCase()=="edge"){js=this.XMLToJSON(e);var edge={};if(js.source&&js.target){edge.id1=js.source;edge.id2=js.target;edges.push(edge)}}}}}}}}}else{alert("Ooops! Not a Gephi gexf file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{graphType:"Network",calculateLayout:cl,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Gephi"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.parseGML=function(gml){var forIn=function(object,callback){Object.keys(object).forEach(function(key){callback(key,object[key])})};var json=("{\n"+gml+"\n}").replace(/^(\s*)(\w+)\s*\[/gm,'$1"$2": {').replace(/^(\s*)\]/gm,"$1},").replace(/^(\s*)(\w+)\s+(.+)$/gm,'$1"$2": $3,').replace(/,(\s*)\}/g,"$1}");var graph={};var nodes=[];var edges=[];var i=0;json=json.replace(/^(\s*)"node"/gm,function(all,indent){return(indent+'"node['+(i++)+']"')});i=0;json=json.replace(/^(\s*)"edge"/gm,function(all,indent){return(indent+'"edge['+(i++)+']"')});try{json=this.parseJSON(json)}catch(err){throw new SyntaxError("bad format")}if(!this.isObject(json.graph)){throw new SyntaxError("no graph tag")}forIn(json.graph,function(key,value){var matches=key.match(/^(\w+)\[(\d+)\]$/);var name;var i;if(matches){name=matches[1];i=parseInt(matches[2],10);if(name==="node"){nodes[i]=value}else{if(name==="edge"){edges[i]=value;edges[i].id1=edges[i].source;edges[i].id2=edges[i].target;delete (edges[i].source);delete (edges[i].target)}else{graph[key]=value}}}else{graph[key]=value}});graph.nodes=nodes;graph.edges=edges;return{data:graph,config:{graphType:"Network"}}};this.arrayToCanvasXpress=function(arr){var unique=function(a){return a.filter(function(x,i){return a.indexOf(x)===i})};var isDate=function(arr){var check=function(v){if(toString.call(v)==="[object Date]"){return true}if(typeof v.replace==="function"){v.replace(/^\s+|\s+$/gm,"")}var f=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return f.test(v)};var n=arr.length;for(var i=0;i<n;i++){if(arr[i]!=null&&!check(arr[i])){return false}}return true};var isNumeric=function(n){return n===null||n===undefined?true:!isNaN(parseFloat(n))&&isFinite(n)};var data={y:{vars:[],smps:[],data:[]}};var g="Scatter2D";var cols=arr[0].filter(Number.isFinite);var mts=false;if(cols.length==0){cols=arr.shift()}else{cols=[];mts=true;for(var i=0;i<arr[0].length;i++){cols.push("C"+(i+1))}}var rows=[];var hasDot=false;for(var i=0;i<arr.length;i++){var v=arr[i][0];if(v!=null){rows.push(arr[i][0].toString());if(arr[i][0].toString().match(/\./)){hasDot=true}}}var urow=unique(rows);if(urow.length==rows.length&&!hasDot){for(var i=0;i<arr.length;i++){arr[i].shift(arr[i][0])}}else{rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}if(cols.length>arr[0].length){cols.shift();if(!cols.length==arr[0].length){return false}}if(arr[0].length!=arr[arr.length-1].length){arr.pop();rows.pop();if(arr[0].length!=arr[arr.length-1].length){return false}}var isrd=isDate(rows);if(isrd){cols.unshift("Date");for(var i=0;i<rows.length;i++){arr[i].unshift(new Date(rows[i]))}rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}var iscd=isDate(cols);var types=[];var yAxis=[];var total=0;for(var i=0;i<cols.length;i++){types[i]=false;for(var j=0;j<rows.length;j++){if(isNaN(arr[j][i])){types[i]=true;break}}if(!types[i]){for(var j=0;j<rows.length;j++){if(i==0&&isrd){continue}else{arr[j][i]=arr[j][i]==null||arr[j][i]==undefined?null:!isNaN(parseFloat(arr[j][i]))&&isFinite(arr[j][i])?Number(arr[j][i]):null}}total++}else{data.z={}}}var ts=true;var uts={};for(var i=0;i<types.length;i++){if(!types[i]&&!isNumeric(arr[0][i])){ts=false;break}else{var v=arr[0][i];if(v!=null){if(uts.hasOwnProperty(arr[0][i].toString())){ts=false;break}else{uts[arr[0][i].toString()]=true}}}}if(ts&&mts){if(data.z){delete data.z;data.x={}}}var trans=false;if(total>1){var n=Math.ceil(total*0.6);var q=0;for(var i=types.length-1;i>=0;i--){if(!types[i]){q++}else{if(q<n){trans=true}}}}if(ts&&mts){var ii=1;for(var i=0;i<cols.length;i++){if(types[i]){data.x[arr[0][i]]=[]}else{data.y.vars.push("V"+ii);ii++}}data.y.smps=["Time"];for(var i=1;i<rows.length;i++){yAxis.push(rows[i]);data.y.smps.push(rows[i])}var ii=0;for(var i=0;i<cols.length;i++){if(types[i]){for(var j=0;j<rows.length;j++){data.x[arr[0][i]].push(j==0?"":arr[j][i])}}else{data.y.data[ii]=[];for(var j=0;j<rows.length;j++){data.y.data[ii][j]=arr[j][i]}ii++}}}else{for(var i=0;i<rows.length;i++){data.y.data[i]=[];data.y.vars.push(rows[i])}for(var i=0;i<cols.length;i++){if(this.isCxplot){var str=this.aes.hasOwnProperty("stringSampleFactors")&&this.aes.stringSampleFactors.includes(cols[i])?true:false;if(!types[i]&&(cols[i]==this.aes.x||cols[i]==this.aes.y||cols[i]==this.aes.z)&&!str){data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}else{if(!data.z){data.z={}}data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}}else{if(types[i]||(this.metaData&&this.metaData.hasOwnProperty(cols[i]))){data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}else{data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}}}}if(data.y.smps.length==0){var n=data.y.data.length;data.y.data=[[]];for(var i=0;i<n;i++){data.y.data[0].push(1)}data.y.smps=data.y.vars;data.y.vars=["counts"];data.x=data.z;delete (data.z);g="Bar"}else{if(data.y.smps.length==1||trans){var trp=function(mat){return mat[0].map(function(_,c){return mat.map(function(r){return r[c]})})};data.y.data=trp(data.y.data);data.y.vars=data.y.smps;data.y.smps=rows;data.x=data.z;delete (data.z);g="Bar"}}if(ts&&mts){return{data:data,config:{graphType:g,xAxis:["Time"],yAxis:yAxis,scatterType:"line"}}}else{return{data:data,config:{graphType:g}}}};this.getRDatasets=function(){var setRDataSets=function(t){return function(r){t.Rdatasets=t.parseJSON(r)}}(this);var url=this.RdatasetsURL+"datasets.json";this.ajaxRequest(url,false,setRDataSets)};this.getRLibraryDataSets=function(s){this.getDataSetListFromURL(this.RdatasetsURL+"json/"+s+"/datasets.json")};this.appendNetworkDataFromURL=function(){var that=this;var url=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var appendDelimitedData=function(r){var tc=0;var tt=0;if(r.match(/,/g)){tc=r.match(/,/g).length}if(r.match(/\t/g)){tt=r.match(/\t/g).length}var dl=url.match(/\.csv$/)&&tc>tt?",":"\t";var data=that.delimitedToArray(r,dl,false,true);if(data&&!that.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}that.flashInfoSpan(100,150,data.rows+" "+data.type+" records added to network data\n"+fail,5000);var cn=that.meta.config.user;var at=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var i=0;i<at.length;i++){var a=at[i];if(cn.hasOwnProperty(a)){that[a]=cn[a]}}if(data.type=="node"){that.appendNodeData(data.data)}else{that.appendEdgeData(data.data)}if(that.appendNetworkData.length>0){that.appendNetworkDataFromURL()}else{that.draw({func:"appendNetworkDataFromURL"});that.hideMask()}}};var appendJSONData=function(r){if(r.type=="node"){that.appendNodeData(r.data)}else{that.appendEdgeData(r.data)}if(that.appendNetworkData.length>0){that.appendNetworkDataFromURL()}else{that.draw({func:"appendNetworkDataFromURL"});that.hideMask()}};var appendDataURL=function(t){return function(r){if(url.match(/\.txt$/)||url.match(/\.csv$/)||url.match(/\.tsv$/)||url.match(/\.tab$/)){appendDelimitedData(r)}else{t.hideMask();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(url){if(typeof(url)=="string"){var obj=this.isValidString(url);switch(obj.type){case"URL":this.ajaxRequest(url,false,appendDataURL);break;case"XML":alert("XML not supported!");break;case"JSON":appendJSONData(obj.data);case"DELIM":appendDelimitedData(url);break}}else{appendJSONData(url)}}};this.getDataFromURLOrString=function(target,config,events,info,callback){if(this.dataURL){var that=this;var getJSON=function(s){try{return that.parseJSON(s)}catch(e){return false}};var format=this.dataURL.match(/\.png$/)?"arraybuffer":this.dataURL.match(/ml.bz2$/)?"binary":false;var netwrk=config&&config.graphType=="Network";var setData=function(t){return function(r){var data=getJSON(r);t.remoteService=t.dataURL;t.remoteServiceType="file";if(t.isObject(data)){if(Array.isArray(data)){return t.setDataSetsFromURL(r)}}else{if(t.dataURL.match(/\.png$/)){data=t.parseDataFromPNG(r)}else{if(t.dataURL.match(/\.svg$/)){data=t.SVGtoCX(r)}else{if(t.dataURL.match(/\.txt$/)||t.dataURL.match(/\.csv$/)||t.dataURL.match(/\.tsv$/)||t.dataURL.match(/\.tab$/)){data=t.delimitedToArray(r,false,true,netwrk,netwrk?"guess":false)}else{if(t.dataURL.match(/.gexf/)){var xml=t.parseXML(r);return t.gexfToCX(xml,trg)}else{if(t.dataURL.match(/\ml$/)||t.dataURL.match(/\ml.bz2$/)){var xml=t.dataURL.match(/\ml.bz2$/)?t.parseXML(t.bz2(r)):t.parseXML(r);var ts1=xml.childNodes[0];var ts2=xml.childNodes[2];var trg=target?target:t.newId("-cX-data-url-");if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){return t.metabaseToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){return t.cytoscapeToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){return t.wikipathwayToCX(xml,trg)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){return t.keggToCX(xml,trg)}}}}}}}}}}data.records=0;data.renderTo=target?target:data.renderTo?data.renderTo:t.newId("-cX-data-url-");data.config=config?config:data.config?data.config:{graphType:"Scatter2D"};if(data.config.graphType=="Network"){data.config.appendNetworkData=t.appendNetworkData}data.events=events?events:data.events?data.events:false;data.info=info?info.toString().replace(/'/g,"'").replace(/"/g,"'"):data.info?data.info.toString().replace(/'/g,"'").replace(/"/g,"'"):false;data.noValidate=true;if(!data.afterRender){data.afterRender=[]}if(data.config.graphType=="Network"){data.afterRender.push(["appendNetworkDataFromURL",[]])}var rurl=t.dataURL;var cnfg=t.cloneObject(t.meta.config.user);t.updateRemoteData(data,function(that){that.meta.config.remote={data:rurl,config:cnfg};that.reInitStack(data);if(callback){callback.apply(that)}})}}(this);this.ajaxRequest(this.dataURL,false,setData,format)}else{if(this.topoJSONURL){var setData=function(t){return function(r){var json=t.parseJSON(r);var rd=t.isExample?false:t.cloneObject(t.data);var rc=t.cloneObject(t.meta.config.user);var data={renderTo:t.target,data:t.isExample?false:t.data,config:t.meta.config.user};if(!window[t.mapId]||!t.isObject(window[t.mapId])){data.config.remoteTransitionEffect="none";window[t.mapId]=json;t.remoteServiceType="file";t.updateRemoteData(data,function(that){that.meta.config.remote={data:rd,config:rc};that.reInitStack(data);for(i in CanvasXpress.chain){if(CanvasXpress.chain[i]==that.target){if(CanvasXpress.stack[i].hasOwnProperty("afterRender")){that.afterRender(CanvasXpress.stack[i].afterRender)}}}if(callback){callback()}})}}}(this);this.ajaxRequest(this.topoJSONURL,false,setData)}else{if(this.dataString){this.loadXML(this.dataString,target,config,events)}}}};this.getDataSetListFromURL=function(u){this.remoteService=u;this.ajaxRequest(u,false,this.setDataSetsFromURL)};this.setDataSetsFromURL=function(t){return function(r){var setDataSetsFromURLRemote=function(t){return function(r){var obj=n.parseJSON(r);n.updateRemoteData({data:obj,ids:n.remoteIds,records:n.remoteIds.length})}}(n);var getParentId=function(){var par=t.$("container-"+t.target).parentNode;while(par.id.match("canvasXpressRemoteWindow")){par=par.parentNode}if(!par.id){par.id=t.newId("-cX-data-sets-url-container-")}return par.id};var obj=t.parseJSON(r);var url=obj[0][1];var ids=[];for(var i=0;i<obj.length;i++){ids.push(obj[i][0])}var pid=getParentId();var par=t.$("container-"+t.target).parentNode;var cid=t.newId("-cX-data-sets-");var cnv=t.$cX("canvas",{id:cid,width:t.originalWidth,height:t.originalHeight});t.castCanvasAttributes(cnv);par.appendChild(cnv);var n=new CanvasXpress(cid,false,{remoteService:t.remoteService});t.remoteIds=ids;t.destroy(t.target);n.remoteData=obj;n.remoteParentId=pid;n.remoteIds=ids;n.remoteServiceType="file";n.ajaxRequest(url,false,setDataSetsFromURLRemote)}}(this);this.initStack=function(data,config,events,info,afterRender){if(!CanvasXpress.stack){CanvasXpress.stack={}}var cnv=this.$(this.target);if(cnv){CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:(this.isCxplot&&this.isArray(data)?this.cloneObject(this.data):data?this.cloneObject(data):false),config:config||false,events:events?events:false,info:info?info.toString().replace(/'/g,"'").replace(/"/g,"'"):false,afterRenderInit:afterRender?afterRender:false,afterRender:[["setDimensions",[cnv.originalWidth,cnv.originalHeight,true]]],state:[],stateIndex:0,noValidate:true}}};this.reInitStack=function(data){if(data.data){if(data.config.stringSampleFactors){for(var i=0;i<data.config.stringSampleFactors.length;i++){var f=data.config.stringSampleFactors[i];if(data.data.x&&data.data.x[f]){for(var j=0;j<data.data.x[f].length;j++){data.data.x[f][j]=data.data.x[f][j]}}}}if(data.config.stringVariableFactors){for(var i=0;i<data.config.stringVariableFactors.length;i++){var f=data.config.stringVariableFactors[i];if(data.data.z&&data.data.z[f]){for(var j=0;j<data.data.z[f].length;j++){data.data.z[f][j]=data.data.z[f][j]}}}}CanvasXpress.stack[this.target].data=data.data}};this.getStack=function(){return CanvasXpress.stack[this.target].afterRender};this.getConfigState=function(){var skip={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,events:true,functions:true,gantt:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,lines:true,moveSankeyId:true,movingOn:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,touchEvent:true,touches:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"){skip.data=true}var keys=Object.keys(this);var cfg=this.getObjectArray(CanvasXpress.config);var props=[];for(var i=0;i<keys.length;i++){var c=keys[i];if(cfg.hasOwnProperty(c)){props.push(c)}else{if(!this.isFunction(this[c])&&!skip.hasOwnProperty(c)){props.push(c)}}}var config={};for(var i=0;i<props.length;i++){var c=props[i];config[c]=this.isObject(this[c])?this.cloneObject(this[c],true):this[c]}return config};this.setConfigState=function(idx){if(!idx){idx=0}var config=CanvasXpress.stack[this.target].state[idx];for(var c in config){this[c]=config[c]}var tmp={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.draw({func:"setConfigState",par:[idx]});this.skipStack=false;for(var c in tmp){this[c]=tmp[c]}};this.stack=function(o){if(!this.skipStack&&o){var f=o.func;var a=o.par?this.cleanEventInArguments(o.par):[];var p=o.prop?this.cloneObject(o.prop):{};var t=new Date().getTime();var s=CanvasXpress.stack[this.target];var n=s?s.afterRender.length:0;if(f&&s){switch(f){case"setDimensions":if(a&&a[0]==this.width&&a[1]==this.height){return}if(a&&a[5]){f="clickGraphMaxMin";a=a[5]>0?[false,false,true]:[false,this.maximized,false]}s.afterRender.push([f,a,{},t]);break;case"broadcastDraw":f=a[0].func;a=a[0]&&a[0].par?this.cleanEventInArguments(a[0].par):[];p=a[0]&&a[0].prop||{};if(f){s.afterRender.push([f,a,p,t])}break;case"drawIndicesAfterPannEvent":case"drawIndicesAfterWheelEvent":case"drawRangesAfterWheelEvent":case"updateDragCircular":case"updateDragScatter":case"updateDragNetwork":case"updateDragGenome":case"updateDragMap":case"updateDragMarker":var u=s.afterRender;var q=s.state;var m=f=="updateDragNetwork"&&a[0].shiftKey?false:true;if(n>1&&u[n-1][0]==f&&m){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}s.afterRender.push([f,a,p,t]);break;case"handleWheelEvent":s.afterRender.push([f,a,p,t]);break;case"resortSankeyDONOTUSE":var u=s.afterRender;var q=s.state;if(n>1&&u[n-1][0]=="resortSankey"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}default:s.afterRender.push([f,a,p,t]);break}if(!this.disableUndoRedoKeys&&s.stateIndex<s.state.length-1){s.state.splice(s.stateIndex,s.state.length-1)}this.meta.stack.push([f,this.meta.time.start,this.meta.time.elapsed]);if(!this.disableUndoRedoKeys){var st=this.getConfigState();s.state.push(st);s.stateIndex=s.state.length-1}}}};this.reproducePlay=function(t){return function(e){t.reproduce(e,true)}}(this);this.reproduce=function(t){return function(e,p,d){if(t.maximized){t.clickGraphMaxMin()}if(t.motionBy){return}t.skipStack=true;t.reproducing=true;t.resetMenus();t.resetLinks();t.resetSelected(e,true);t.meta.ids={};if(d){t.setMotionObject();t.clickMotion(e,true,true)}else{t.addMotionDiv(e);if((e&&e.shiftKey)||p){t.clickMotion(e,true)}}}}(this);this.animate=function(t){return function(e){t.replot(e,true)}}(this);this.replot=function(t){return function(e,a,o){var d=t.cloneObject(CanvasXpress.stack[t.target]);if(!this.isRawData){if(d.data.y){delete d.data.y.data}}this.isQQ=false;this.isCDF=false;d.config.showTransition=a?true:false;if(o){var ar=t.cloneObject(d.afterRender);d.afterRender=[];for(var i=0;i<ar.length;i++){var c=ar[i];if(c[0]=="addCDFPlot"&&d.config.decorations){delete d.config.decorations.cdf}if(c&&c[4]){d.afterRender.push(c)}}}var m=false;if(t.maximized){t.clickGraphMaxMin()}t.destroy(t.target,true);new CanvasXpress(d)}}(this)};CanvasXpress.prototype.initSave=function(){
/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(g){g.URL=g.URL||g.webkitURL;if(g.Blob&&g.URL){try{new Blob;return}catch(j){}}var i=g.BlobBuilder||g.WebKitBlobBuilder||g.MozBlobBuilder||(function(v){var m=function(F){return Object.prototype.toString.call(F).match(/^\[object\s(.*)\]$/)[1]},E=function s(){this.data=[]},C=function o(H,F,G){this.data=H;this.size=H.length;this.type=F;this.encoding=G},w=E.prototype,B=C.prototype,y=v.FileReaderSync,k=function(F){this.code=this[this.name=F]},x=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),A=x.length,r=v.URL||v.webkitURL||v,z=r.createObjectURL,l=r.revokeObjectURL,q=r,u=v.btoa,p=v.atob,n=v.ArrayBuffer,t=v.Uint8Array,D=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;C.fake=B.fake=true;while(A--){k.prototype[x[A]]=A+1}if(!r.createObjectURL){q=v.URL=function(G){var F=document.createElementNS("http://www.w3.org/1999/xhtml","a"),H;F.href=G;if(!("origin" in F)){if(F.protocol.toLowerCase()==="data:"){F.origin=null}else{H=G.match(D);F.origin=H&&H[1]}}return F}}q.createObjectURL=function(G){var H=G.type,F;if(H===null){H="application/octet-stream"}if(G instanceof C){F="data:"+H;if(G.encoding==="base64"){return F+";base64,"+G.data}else{if(G.encoding==="URI"){return F+","+decodeURIComponent(G.data)}}if(u){return F+";base64,"+u(G.data)}else{return F+","+encodeURIComponent(G.data)}}else{if(z){return z.call(r,G)}}};q.revokeObjectURL=function(F){if(F.substring(0,5)!=="data:"&&l){l.call(r,F)}};w.append=function(J){var L=this.data;if(t&&(J instanceof n||J instanceof t)){var K="",G=new t(J),H=0,I=G.length;for(;H<I;H++){K+=String.fromCharCode(G[H])}L.push(K)}else{if(m(J)==="Blob"||m(J)==="File"){if(y){var F=new y;L.push(F.readAsBinaryString(J))}else{throw new k("NOT_READABLE_ERR")}}else{if(J instanceof C){if(J.encoding==="base64"&&p){L.push(p(J.data))}else{if(J.encoding==="URI"){L.push(decodeURIComponent(J.data))}else{if(J.encoding==="raw"){L.push(J.data)}}}}else{if(typeof J!=="string"){J+=""}L.push(unescape(encodeURIComponent(J)))}}}};w.getBlob=function(F){if(!arguments.length){F=null}return new C(this.data.join(""),F,"raw")};w.toString=function(){return"[object BlobBuilder]"};B.slice=function(I,F,H){var G=arguments.length;if(G<3){H=null}return new C(this.data.slice(I,G>1?F:this.data.length),H,this.encoding)};B.toString=function(){return"[object Blob]"};B.close=function(){this.size=0;delete this.data};return E}(g));g.Blob=function(o,n){var q=n?(n.type||""):"";var m=new i();if(o){for(var p=0,k=o.length;p<k;p++){if(Uint8Array&&o[p] instanceof Uint8Array){m.append(o[p].buffer)}else{m.append(o[p])}}}var l=m.getBlob(q);if(!l.slice&&l.webkitSlice){l.slice=l.webkitSlice}return l};var h=Object.getPrototypeOf||function(k){return k.__proto__};g.Blob.prototype=h(new g.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(g){var h=g.Uint8Array,j=g.HTMLCanvasElement,i=j&&j.prototype,k=/\s*;\s*base64\s*(?:;|$)/i,l="toDataURL",n,m=function(u){var v=u.length,r=new h(v/4*3|0),t=0,x=0,y=[0,0],o=0,w=0,s,p,q;while(v--){p=u.charCodeAt(t++);s=n[p-43];if(s!==255&&s!==q){y[1]=y[0];y[0]=p;w=(w<<6)|s;o++;if(o===4){r[x++]=w>>>16;if(y[1]!==61){r[x++]=w>>>8}if(y[0]!==61){r[x++]=w}o=0}}}return r};if(h){n=new h([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(j&&(!i.toBlob||!i.toBlobHD)){if(!i.toBlob){i.toBlob=function(v,t){if(!t){t="image/png"}if(this.mozGetAsFile){v(this.mozGetAsFile("canvas",t));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t)){v(this.msToBlob());return}var s=Array.prototype.slice.call(arguments,1),q=this[l].apply(this,s),p=q.indexOf(","),u=q.substring(p+1),o=k.test(q.substring(0,p)),r;if(Blob.fake){r=new Blob;if(o){r.encoding="base64"}else{r.encoding="URI"}r.data=u;r.size=u.length}else{if(h){if(o){r=new Blob([m(u)],{type:t})}else{r=new Blob([decodeURIComponent(u)],{type:t})}}}v(r)}}if(!i.toBlobHD&&i.toDataURLHD){i.toBlobHD=function(){l="toDataURLHD";var o=this.toBlob();l="toDataURL";return o}}else{i.toBlobHD=i.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));var f=typeof window==="object"&&window.window===window?window:typeof self==="object"&&self.self===self?self:typeof global==="object"&&global.global===global?global:this;function e(g,h){if(typeof h==="undefined"){h={autoBom:false}}else{if(typeof h!=="object"){console.warn("Depricated: Expected third argument to be a object");h={autoBom:!h}}}if(h.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(g.type)){return new Blob([String.fromCharCode(65279),g],{type:g.type})}return g}function b(h,g,i){var j=new XMLHttpRequest();j.open("GET",h);j.responseType="blob";j.onload=function(){a(j.response,g,i)};j.onerror=function(){console.error("could not download file")};j.send()}function c(g){var h=new XMLHttpRequest();h.open("HEAD",g,false);h.send();return h.status>=200&&h.status<=299}function d(h){try{h.dispatchEvent(new MouseEvent("click"))}catch(i){var g=document.createEvent("MouseEvents");g.initMouseEvent("click",true,true,window,0,0,0,80,20,false,false,false,false,0,null);h.dispatchEvent(g)}}var a=f.saveAs||(typeof window!=="object"||window!==f)?function a(){}:"download" in HTMLAnchorElement.prototype?function a(i,j,k){var g=f.URL||f.webkitURL;var h=document.createElement("a");j=j||i.name||"download";h.download=j;h.rel="noopener";if(typeof i==="string"){h.href=i;if(h.origin!==location.origin){c(h.href)?b(i,j,k):d(h,h.target="_blank")}else{d(h)}}else{h.href=g.createObjectURL(i);setTimeout(function(){g.revokeObjectURL(h.href)},40000);setTimeout(function(){d(h)},0)}}:"msSaveOrOpenBlob" in navigator?function a(h,i,j){i=i||h.name||"download";if(typeof h==="string"){if(c(h)){b(h,i,j)}else{var g=document.createElement("a");g.href=h;g.target="_blank";setTimeout(function(){d(g)})}}else{navigator.msSaveOrOpenBlob(e(h,j),i)}}:function a(h,j,g,k){k=k||open("","_blank");if(k){k.document.title=k.document.body.innerText="downloading..."}if(typeof h==="string"){return b(h,j,g)}var l=h.type==="application/octet-stream";var o=/constructor/i.test(f.HTMLElement)||f.safari;var p=/CriOS\/[\d]+/.test(navigator.userAgent);if((p||(l&&o))&&typeof FileReader==="object"){var m=new FileReader();m.onloadend=function(){var q=m.result;q=p?q:q.replace(/^data:[^;]*;/,"data:attachment/file;");if(k){k.location.href=q}else{location=q}k=null};m.readAsDataURL(h)}else{var n=f.URL||f.webkitURL;var i=n.createObjectURL(h);if(k){k.location=i}else{location.href=i}k=null;setTimeout(function(){n.revokeObjectURL(i)},40000)}};this.saveAs=a};CanvasXpress.prototype.initConfig=function(){this.defDoc=function(a){var b=CanvasXpress.doc;if(!b.M[a]){b.M[a]={}}if(!b.M[a].P){b.M[a].P=[]}};this.defColor=function(e,c,h,a,b){this[e+"Color"]=c==false?false:(c||"rgb(0,0,0)");var g=CanvasXpress.doc;var f=[e+"Color"];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[e+"Color"]={C:"Color for the "+h+"<br>",D:this[e+"Color"],H:["{[*]}"],M:a,T:"color"}};this.defColor2=function(e,c,h,a,b){this[e]=c||"rgb(0,0,0)";var g=CanvasXpress.doc;var f=[e];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[e]={C:"Color for the "+h+"<br>",D:this[e],H:["{[*]}"],M:a,T:"color"}};this.defOption=function(c,f,e,i,a,b){this[c]=f||false;var h=CanvasXpress.doc;var g=[c];b.push.apply(b,g);this.defDoc(a);h.M[a].P=h.M[a].P.concat(g);h.P[c]={C:i+"<br>",D:this[c],H:["{[*]}"],M:a,O:e,T:"string"}};this.defOption2=function(c,f,e,i,a,b){this[c]=f||"";var h=CanvasXpress.doc;var g=[c];b.push.apply(b,g);this.defDoc(a);h.M[a].P=h.M[a].P.concat(g);h.P[c]={C:i+"<br>",D:this[c],H:["{[*]}"],M:a,O:e,T:"string"}};this.defString=function(c,e,h,a,b){this[c]=e||false;if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"string"}}};this.defInteger=function(c,e,h,a,b){this[c]=e==null?null:(e||0);if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"integer"}}};this.defFloat=function(c,e,h,a,b){this[c]=e!=null?e:null;if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"float"}}};this.defBoolean=function(c,e,h,a,b){this[c]=e||false;if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"boolean"}}};this.defArray=function(c,e,h,a,b){this[c]=e||[];if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"array"}}};this.defArray2=function(c,e,h,a,b){this[c]=e==false?false:(e||[]);if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"array"}}};this.defObject=function(c,e,h,a,b){this[c]=e==false?false:{};if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"object"}}};this.defFilter=function(c,e,h,a,b){this[c]=e||{cases:[],comp:[],op:[],type:[],value:[]};if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"filter"}}};this.defURL=function(c,e,h,a,b){this[c]=e||false;if(b){var g=CanvasXpress.doc;var f=[c];b.push.apply(b,f);this.defDoc(a);g.M[a].P=g.M[a].P.concat(f);g.P[c]={C:h+"<br>",D:this[c],H:["{[*]}"],M:a,T:"url"}}};this.defRect=function(f,g,c,d,e,h,a,b){this.defColor(f,g||"rgba(0,0,0,0)",h,a,b);this.defColor(f+"Border",c||"rgba(0,0,0,0)","border in "+h,a,b);this.defFloat(f+"BorderSize",d||0.5,"Size for the border line in "+h,a,b);this.defOption(f+"BorderLineType",e||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the border in "+h,a,b)};this.defText=function(a,i,e,l,b,h,f,d,g,j,c){this.defOption2(a+"FontStyle",i||"",["","bold","italic","bold italic"],"Font style for the "+g,j,c);this.defColor(a,e==false?false:(e||"rgb(0,0,0)"),"text in "+g,j,c);this.defInteger(a+"FontSize",l||12,"Font size for the text in "+g+". Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the "+a+"ScaleFontFactor",j,c);this.defFloat(a+"ScaleFontFactor",b||1,"Scaling factor used to increase or decrease the "+g+" font size in the canvas",j,c);this.defOption(a+"Align",h||"center",["left","center","right"],"Align for the "+g,j,c);this.defInteger(a+"Rotate",f||0,"Rotation in degrees for the "+g,j,c);this.defFloat(a+"Margin",d||5,"Margin used in "+g,j,c)};this.defDendrogram=function(b,j,g,h,d,f,i,e){var c=b.toLowerCase();var a=b=="Var"?["top","bottom"]:["left","right"];this.defShow(b+"Dendrogram",j==false?false:true,f,i,e);this.defString(c+"DendrogramNewick",g||false,"Dendrogram in Newick format for the "+f,i,e);this.defPosition(c+"Dendrogram",h,a,f+" in the plot. It could be top, bottom, right or left depending on the orientation of the graph",i,e);this.defOption("color"+b+"DendrogramBy",d||false,[false],"Name of metadata annotation to color the "+f,i,e)};this.defLine=function(a,c,i,e,f,h,d,g,b){this.defColor(a,c,d,g,b);this.defFloat(a+"Size",i||0.5,"Size for the "+d,g,b);this.defFloat(a+"Length",e||null,"Length for the "+d,g,b);this.defLineType(a,f,d,g,b);this.defShow2(a,h,d,g,b)};this.defHistogram=function(e,c,b,f,a,d){this.defBoolean(e+"HistogramShow",c==false?false:true,"Flag to show/hide the histogram in the "+f,a,d);this.defInteger(e+"HistogramHeight",b||80,"Size in pixels for the histogram in the "+f,a,d)};this.defRug=function(e,c,b,g,f,a,d){this.defBoolean(e+"RugShow",c==false?false:true,"Flag to show/hide a data rug in the "+f,a,d);this.defInteger(e+"RugHeight",b||80,"Size in pixels for the data rug in the "+f,a,d);this.defOption(e+"RugPosition",g?g[0]:false,g,"Position for the data rug in the"+f,a,d)};this.defPosition=function(d,f,c,e,a,b){this.defOption(d+"Position",f||"right",c,"Position for the "+e,a,b)};this.defDirection=function(d,c,e,a,b){this.defOption(d+"Direction",c||"vertical",["vertical","horizontal"],"Direction for "+e,a,b)};this.defShow=function(d,b,e,a,c){this.defBoolean("show"+d,b==false?false:true,"Flag to show/hide the "+e,a,c)};this.defShow2=function(d,b,e,a,c){this.defBoolean(d+"Show",b==false?false:true,"Flag to show/hide the "+e,a,c)};this.defLineType=function(d,c,e,a,b){this.defOption(d+"LineType",c||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the "+e,a,b)};this.defTransform=function(d,c,e,a,b){this.defOption(d+"Transform",c||false,[false,"log2","log10","exp2","exp10","percentile"],"Type of transformation for values in "+e,a,b)};this.defAxis=function(d,h,m,e){var l=d.toUpperCase();var q=l=="Y"?["Top","Bottom"]:l=="X"?["Right","Left"]:[];var b=l=="Y"?["left","rigth","both"]:l=="X"?["bottom","top","both"]:false;var j=l=="Y"?" on the left":l=="X"?" on the bottom":"";var n=l=="Y"?" on the right":l=="X"?" on the top":"";var o=l=="Z"?10:5;if(l!="R"){this.defArray(d+"Axis",[],"Name of the samples, groups or variables to be displayed in the "+h,m,e);this.defArray(d+"AxisIndices",[])}if(l=="X"){this.defArray(d+"Axis2",[],"Name of the samples, groups or variables to be displayed in the second "+h,m,e)}this.defInteger(d+"AxisCurrent",0,"Sample id that is currently displayed in the "+h+". Important when there are more that one series displayed in the graph",m,e);this.defBoolean(d+"AxisShow",true,"Flag to show/hide the "+h+j,m,e);if(l=="X"||l=="Y"){this.defBoolean(d+"Axis2Show",false,"Flag to show/hide the "+h+n,m,e)}if(l!="R"){this.defFloat("setMin"+l,null,"Set the minimum value for data in the "+h,m,e);this.defFloat("setMax"+l,null,"Set the maximum value for data in the "+h,m,e)}this.defFloat(d+"AxisAbsMin",null);this.defFloat(d+"AxisAbsMax",null);this.defString(d+"AxisMaxStrLength",false);this.defFloat(d+"AxisMin",null);this.defFloat(d+"AxisMax",null);this.defFloat(d+"AxisRange",null);this.defFloat(d+"AxisIncr",null);this.defFloat(d+"AxisDecs",null);this.defBoolean(d+"AxisExtensionMin",false);this.defBoolean(d+"AxisExtensionMax",false);if(l=="X"){this.defFloat("setMin"+l+2,null,"Set the minimum value for data in the second "+h,m,e);this.defFloat("setMax"+l+2,null,"Set the maximum value for data in the second "+h,m,e);this.defFloat(d+"Axis2AbsMin",null);this.defFloat(d+"Axis2AbsMax",null);this.defString(d+"Axis2MaxStrLength",false)}this.defBoolean(d+"AxisExact",false,"Flag to force exact values in "+h,m,e);this.defArray(d+"AxisValues",[]);this.defArray(d+"AxisValuesRaw",[]);this.defArray(d+"AxisMinorValues",[]);if(l=="X"){this.defArray(d+"Axis2Values",[]);this.defArray(d+"Axis2ValuesRaw",[]);this.defArray(d+"Axis2MinorValues",[])}this.defTransform(d+"Axis",false,h,m,e);this.defBoolean(d+"AxisTransformTicks",false,"Flag to transform the values of the ticks in the "+h,m,e);this.defFloat(d+"AxisCeilValue",null,"Value to ceil the data in the "+h,m,e);this.defFloat(d+"AxisFloorValue",null,"Value to floor the data in the "+h,m,e);this.defString(d+"AxisTitle",false,h+" title "+j,m,e);this.defString(d+"Axis2Title",false,h+"2 title "+n,m,e);this.defBoolean(d+"AxisTitleDynamic",false,"Set the title for the "+h+" dynamically as it changes when configured by the user",m,e);this.defLine(d+"AxisTickGuide","rgb(0,0,0)",0.5,5,"solid",true,"side tick lines indicators in the "+h+j,m,e);this.defLine(d+"AxisTick","rgb(204,204,204)",0.5,null,"solid",true,"tick lines across the "+h,m,e);for(var g=0;g<q.length;g++){this.defLine(d+"AxisTick"+q[g],"rgb(204,204,204)",0.5,null,"solid",q[g]+" tick line across the "+h,g==1,m,e)}this.defString(d+"AxisTickFormat",false,h+"Format for the tick values in the "+h+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',m,e);this.defInteger(d+"AxisTicks",o,"Approx number of tick lines in the "+h,m,e);if(l=="X"){this.defString(d+"Axis2TickFormat",false,h+"Format for the tick values in the second "+h+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',m,e);this.defInteger(d+"Axis2Ticks",null,"Approx number of tick lines in the second "+h,m,e)}this.defBoolean(d+"AxisTicksMinorShow",false,"Flag to show/hide the minor tick lines in the "+h,m,e);this.defBoolean(d+"AxisTicksMajorShow",true,"Flag to show/hide the major tick lines in the "+h,m,e);if(l=="X"||l=="Y"){this.defHistogram(d+"Axis",false,80,h,m,e);if(b){this.defRug(d+"Axis",false,15,b,h,m,e)}}};this.setConfigDefaults=function(){var a=CanvasXpress.config;this.defOption("graphType","Bar",["Bar","Line","Area","AreaLine","BarLine","Boxplot","Dotplot","DotLine","Fish","Gantt","Meter","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tree","Treemap","TagCloud","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Correlation","Pie","Venn","Network","Genome","Circular"],"Specifies the type of graph","General",a);this.defOption("graphOrientation","horizontal",["horizontal","vertical"],"Specifies the orientation of one dimensional graphs","General",a);this.defFloat("transparency",null,"Percentage of transparency applied to all elements in the visualizations","General",a);this.defFloat("transparencyHidden",0.1,"Percentage of transparency applied to elements that are hidden","General",a);this.defBoolean("canvasBox",false,"Flag to draw a box around the canvas","General",a);this.defColor("canvasBox","rgb(204,204,204)","box around the canvas","General",a);this.defBoolean("plotBox",false,"Flag to draw a box around the x,y coordinates of the plot","General",a);this.defColor("plotBox","rgb(204,204,204)","box around the x,y coordinates of the plot","General",a);this.defBoolean("invertGraph",false,"Flag to invert horizontal one dimensional graphs to plot from right to left","General",a);this.defOption("view","canvas",["canvas","table","layout"],"Specify the starting view of the data","General",a);this.defBoolean("isR",false,"Flag to indicate is running from the R library. For developers only","General",a);this.defBoolean("isCxplot",false,"Flag to indicate is using cxplot","General",a);this.defBoolean("isReproducibleResearch",true,"Flag to indicate to track user modifications for Reproducible Research. For developers only","General",a);this.defInteger("reproduceTime",500,"Time to wait in milliseconds to reproduce user modifications through the UI","General",a);this.defOption("printType","download",["download","window"],"Type of printing when the camera icon in the UI is pressed. Download is to download the image while window is to save the image in a new browser window","General",a);this.defInteger("printMagnification",1,"Print Magnification to produce High Definition images. Courtesy of Baohong Zhang","General",a);this.defBoolean("printThumbnail",false,"Print thumbnail","General",a);this.defBoolean("cacheBase64",false,"Cache image in meta data as Base64","General",a);this.defBoolean("editable",true,"Editable in JS Fiddle and CodePen","General",a);this.defBoolean("highlightGreyOut",false,"Flag to add grey out when highlighting with mouse over","General",a);this.defFloat("highlightGreyOutTransparency",0.67,"Fraction of transparency for grey out when highlighting with mouse over","General",a);this.defOption("theme","none",["none","economist","excel","tableau","stata","igray","solarized","paulTol","ggplot","wallStreetJournal","cx"],"Themes for the plot. This parameter will overwrite colors, background, axes, etc","General",a);this.defBoolean("useRawLines",false,"Use raw lines rather than potentially crisp lines. Use only with circular graphs and networks","General",a);this.defInteger("fullTextMeasureCheck",500,"Full thorough check of variable and sample names when more than the specified number. This is useful for large data sets as canvas has not an efficent maner to measure text","General",a);this.defString("saveFilename",false,"Filename to use when downloading the canvas as an image or as json. If not specified. the filename will be based on the target id of the canvas. cX- + canvas.targetId + extension","General",a);this.defBoolean("skipRender",false,"Flag to skip initial rendering","General",false);this.defArray("tags",[],"Tags","General",a);this.defFloat("createVersion",false,"CanvasXpress Version used to create plot. This is parsed from the PNG or JSON data loaded","General",false);this.defObject("createFactory",false,"CanvasXpress Factory used to create plot. This is parsed from the PNG or JSON data loaded","General",false);this.defObject("metaData",{},"Meta data for files read from a url","General",a);this.defString("password",false,"Password to protect exploring data","General",a);this.defArray("functions",[],"Functions exposed to the api","General",false);this.defObject("aes",{},"Initial Configuration passed to cxplot","cxplot",a);this.defOption("effect","none",["none","magic","puffIn","openDownLeft","openDownLeftOut","perspectiveDown","rotateDown","twisterInDown","puffOut","openDownRight","openDownRightOut","perspectiveUp","rotateUp","twisterInUp","vanishIn","openUpLeft","openUpLeftOut","perspectiveLeft","rotateLeft","swap","vanishOut","openUpRight","openUpRightOut","perspectiveRight","rotateRight","openDownLeftReturn","perspectiveDownReturn","openDownRightReturn","perspectiveUpReturn","openUpLeftReturn","perspectiveLeftReturn","openUpRightReturn","perspectiveRightReturn","slideDown","swashOut","tinRightOut","bombRightOut","boingInUp","spaceOutUp","slideUp","swashIn","tinLeftOut","bombLeftOut","boingOutDown","spaceOutRight","slideLeft","foolishIn","tinUpOut","spaceOutDown","slideRight","holeOut","tinDownOut","spaceOutLeft","slideDownReturn","tinRightIn","spaceInUp","slideUpReturn","tinLeftIn","spaceInRight","slideLeftReturn","tinUpIn","spaceInDown","slideRightReturn","tinDownIn","spaceInLeft"],"Effect used to show widgets Magic - Ver 1.3.0 - https://minimamente.com","Effect",a);this.defString("codeEffectIn","slideLeftReturn2","Code Effect In","Effect",a);this.defString("codeEffectOut","slideLeft","Code Effect Out","Effect",a);this.defString("customizerEffectIn","slideLeftReturn","Customize Effect In","Effect",a);this.defString("customizerEffectOut","slideUp2","Customizer Effect Out","Effect",a);this.defString("datafilterEffectIn","slideRightReturn","Data Filter Effect In","Effect",a);this.defString("datafilterEffectOut","slideRight","Data Filter Effect Out","Effect",a);this.defString("datatableEffectIn","slideUpReturn","Data Table Effect In","Effect",a);this.defString("datatableEffectOut","slideDown3","Data Table Effect Out","Effect",a);this.defString("tabpanelEffectIn","slideDownReturn2","Tab Panel Effect In","Effect",a);this.defString("tabpanelEffectOut","slideDown2","Tab Panel Effect Out","Effect",a);this.defString("motionEffectIn","swashIn","Motion Effect In","Effect",a);this.defString("motionEffectOut","holeOut","Motion Effect Out","Effect",a);this.defString("remoteEffectIn","holeIn","Remote Effect In","Effect",a);this.defString("remoteEffectOut","holeOut","Remote Effect Out","Effect",a);this.defString("toolbarEffectIn","holeIn","Toolbar Effect In","Effect",a);this.defString("toolbarEffectOut","holeOut","Toolbar Effect Out","Effect",a);this.defString("tooltipDivEffectIn","holeOut","Tooltip Div Effect In","Effect",a);this.defString("tooltipDivEffectOut","spaceInUp","Tooltip Div Effect Out","Effect",a);this.defBoolean("gradient",false,"Flag used to apply gradients to all objects in the graphs","Gradients",a);this.defOption("gradientType","radial",["linear","radial"],"Specifies the gradient pattern","Gradients",a);this.defOption("gradientOrientation","vertical",["vertical","horizontal"],"Specifies the orientation of the gradient if the gradient type is of the type linear","Gradients",a);this.defFloat("gradientRatio",1.3,"Specifies the ratio used to generate linear gradients","Gradients",a);this.defBoolean("adjustAspectRatio",true,"Flag to automatically adjust the size of the bars or points in the one dimensional plots to fit in the provided canvas width and height. If the flag is set to false the width and height of the canvas will be sized according to the number of bars or points in the data set","Aspect Ratio, Space and width",a);this.defFloat("percentAspectRatioPlotArea",0.5,"Specifies the minimum percentage for the plotting area","Aspect Ratio, Space and width",a);this.defFloat("fixedAspectRatio",0,"Keep fixed aspect ratio expressed as y / x. A zero value is used to ignore otherwise the x and y axes are set accordingly","Aspect Ratio, Space and width",a);this.defInteger("variableSpaceFactor",2,"Factor to adjust the spacing between the data points between the variables in the one dimensional plots. The greater the number, the greater the gap","Aspect Ratio, Space and width",a);this.defInteger("sampleSpaceFactor",1,"Factor to adjust the spacing between the data points between the samples in the one dimensional graphs. The greater the number, the greater the gap","Aspect Ratio, Space and width",a);this.defInteger("widthFactor",1,"Factor to adjust the width of the bars in the one dimensional and the three dimensional plots. The greater the number, the wider the bars","Aspect Ratio, Space and width",a);this.defInteger("dataPointSize",15,"Approximate size for the data points in scatter plots, dotplots and boxplots. The size will be adjusted according to the dimensions of the graph","Aspect Ratio, Space and width",a);this.defFloat("dataPointSizeScaleFactor",1,"Factor used to adjust the size of the dataPointSize","Aspect Ratio, Space and width",a);this.defInteger("adjustAspectRatioMax",3,"Specifies the number of times to try to automatically adjust the size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.defInteger("adjustAspectRatioYTries",0,"Counter set when trying to automatically adjust the vertical size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.defInteger("adjustAspectRatioXTries",0,"Counter set when trying to automatically adjust the horizontal size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.defColor2("foreground","rgb(0,0,0)","Specifies the foreground color for text or lines not covered in a more specific configuration property","Foreground and Background",a);this.defColor2("background","rgb(255,255,255)","Specifies the background color for the canvas","Foreground and Background",a);this.defColor2("backgroundWindow","rgb(244,244,244)","Specifies the background color for the canvas when the background type is of a type window","Foreground and Background",a);this.defOption("backgroundType","solid",["solid","gradient","window","windowGradient","windowSolidGradient","image","windowImage"],"Specifies the style for the background of the canvas. The canvas background is composed of a frame with a window where the data is plotted. Either of these elements the may be a solid or gradient color or an image of your choosing. The colorScheme property will be used If gradient is specified","Foreground and Background",a);this.defURL("backgroundImage",false,"Specifies the url for the background image when the background type is of the type image or windowImage","Foreground and Background",a);this.defString("backgroundImageSrc",false,"Specifies the source for the background image when the background type is of the type image or windowImage","Foreground and Background",a);this.defInteger("margin",5,"Relative length in pixels for the distance between various objects in the graphs. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true","Margins",a);this.defInteger("marginLeft",5,"Specifies the length in pixels for the left margin in the canvas","Margins",a);this.defInteger("marginTop",5,"Specifies the length in pixels for the top margin in the canvas","Margins",a);this.defInteger("marginBottom",5,"Specifies the length in pixels for the bottom margin in the canvas","Margins",a);this.defInteger("marginRight",5,"Specifies the length in pixels for the right margin in the canvas","Margins",a);this.defShow("Shadow",false,"shadows in all graph objects in the canvas. It will be forced to false if the browser is IE","Shadows",a);this.defShow("TextShadow",false,"shadows in text in the canvas. It will be forced to false if the browser is IE","Shadows",a);this.defInteger("shadowOffsetX",1,"Length in pixels for the shadow offset in the X axis","Shadows",a);this.defInteger("shadowOffsetY",1,"Length in pixels for the shadow offset in the Y axis","Shadows",a);this.defInteger("shadowBlur",2,"Amount in blur for the shadow","Shadows",a);this.defColor("shadow","rgba(0,0,0,0.5)","shadow","Shadows",a);this.defString("topoJSON",false,"TopoJSON map string","Maps",a);this.defString("mapId",false,"Map Id for the map div in the DOM","Maps",a);this.defString("mapPropertyId",false,"Map Property Id use to match the data ids to the GeoJSON layer Id","Maps",a);this.defOption("mapProjection","mercator",["mercator","albers","orthographic"],"Map projection","Maps",a);this.defFloat("mapLatitudeOrigin",23,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",a);this.defFloat("mapCentralMeridian",-96,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",a);this.defFloat("mapStandardParallel1",29.5,"Map Standard Parallel 1 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",a);this.defFloat("mapStandardParallel2",45.5,"Map Standard Parallel 2 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",a);this.defBoolean("mapGraticuleShow",false,"Show Map Graticule","Maps",a);this.defOption("mapGraticuleType","solid",["dashed","solid"],"Map Graticule type","Maps",a);this.defObject("mapConfig",false,"Map config","Maps",a);this.defObject("mapConfigFeatures",false,"Map config for features use to translate and scale","Maps",a);this.defArray("mapSmps",[],"Samples to use in maps","Maps",a);this.defArray("hiddenMapFeatures",[],"Hidden Map features","Maps",a);this.defArray("visibleMapFeatures",[],"Visible Map features. It Overrides the hidden features","Maps",a);this.defColor("map","rgb(105,210,230)","maps","Maps",a);this.defColor("mapOutline","rgb(204,204,204)","outline of the maps","Maps",a);this.defArray("fonts",[],"Goggle Fonts","Text",a);this.defArray("fontsExternal",[],"External Fonts","Text",a);this.defOption("fontName","Arial",["Courier","Arial","Verdana","sans-serif","Indie Flower","Ubuntu","Architects Daughter","Roboto"],"Font name. It will be set depending on the browser","Text",a);this.defOption("fontStyle","",["","bold","italic","bold italic"],"Font style","Text",a);this.defInteger("fontSize",12,"Font size for text in complex plot only. See other categories to modify specific font sizes","Text",a);this.defFloat("fontScaleFontFactor",1,"Scaling factor used to increase or decrease the font size in the canvas","Text",a);this.defOption("align","center",["right","center","left"],"Default horizontal alignment for drawing text","Text",a);this.defOption("baseline","middle",["top","middle","bottom"],"Default vertical alignment for drawing text","Text",a);this.defInteger("maxTextSize",40,"Maximum size for any text in the canvas","Text",a);this.defInteger("minTextSize",4,"Minimum size for any text in the canvas","Text",a);this.defBoolean("autoScaleFont",true,"Flag to automatically adjust the font size in many visualization. Please be aware that scaling factors can still modify the font size. This flag needs to be false for the text to accept the specified font size","Text",a);this.defInteger("scaleTextConstantMult",25,"Constants to autoscale text","Text",false);this.defFloat("scaleTextConstantAdd",2,"Constants to autoscale text (extra)","Text",false);this.defString("title",false,"Title of the graph","Titles and Subtitles",a);this.defString("subtitle",false,"Subtitle of the graph","Titles and Subtitles",a);this.defText("title","","rgb(0,0,0)",16,1,"center",0,5,"title","Titles and Subtitles",a);this.defRect("titleBackground","rgba(0,0,0,0)","rgba(0,0,0,0)",0.5,"solid","title background","Titles and Subtitles",a);this.defText("subtitle","","rgb(0,0,0)",14,1,"center",0,5,"subtitle","Titles and Subtitles",a);this.defRect("subtitleBackground","rgba(0,0,0,0)","rgba(0,0,0,0)",0.5,"solid","subtitle background","Titles and Subtitles",a);this.defString("citation",false,"A reference citation of the graph which is placed at the bottom right corner","Citations or References",a);this.defText("citation","","rgb(0,0,0)",7,1,"right",0,5,"citations","Citations or References",a);this.defInteger("dashLength",8,"Size in pixels of the length of the dashes and the separation between the dashes in the dashed lines","Lines",a);this.defInteger("dotLength",1,"Size in pixels of the length between dots in the doted lines","Lines",a);this.defInteger("arrowPointSize",9,"Size in pixels of the arrow head in arrow lines","Lines",a);this.defFloat("arrowQuadraticFactor",2.3,"Factor to use to bend the quadratic lines","Lines",a);this.defOption("capType","butt",["butt","round","square"],"Default type of cap for lines","Lines",a);this.defOption("joinType","mitter",["mitter","bevel","round"],"Default type for joining lines","Lines",a);this.defInteger("lineWidthEvent",2,"Size in pixels of the width for the events in the lines","Lines",false);this.defFloat("outlineWidth",1,"Default width in pixels for lines in networks and other line elements in all visualizations except for the lines in the line plots","Lines",a);this.defFloat("lineThickness",1,"Default thickness in pixels for the lines in line plots","Lines",a);this.defBoolean("adjustBezier",false,"Flag to automatically select the bezier line type. the bezier can start from the top or bottom (vertical), or from the side (horizontal). This will be based on the location of the two points joined by the line","Lines",a);this.defArray("lines",["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC"],"Line types in network graphs for the edges (or connections) between network nodes.<br> There are three styles: solid, dashed and dotted and four sub types: straight, bezier, curved (clockwise) and curvedCC (counter clockwise). The line types can be any combination of a style followed by a subtype. By default the type is always a solid straight line so there is no need to specify solid or stright as a style if there is a subtype.<br> Lines can also have elbows which are specified as a 2D-array. In the case a straight solid line each elements in the array will have an x,y coordinate and each segment will be perpendicular to the previous one. For example in this edge object:<br> <i>{ ..., type : line, elbows : [ [20, 40], [60, 80] ], ... }</i><br> A special subtype of line called segmented can also have elbows which are not perpendicalar to each other. For example in this edge object:<br> <i>{ ..., type : segmented, elbows : [ [20, 40], [60, 80] ], ... }</i><br> In the case of a bezier curved each element of the array will have an x,y coordinate for the control point 1, an x,y coordinate for the control point 2 and an x,y coordinate for the end of the line.<br> <i>{ ..., type : bezier, elbows : [ [20, 40, 40, 20, 40, 40], ... ], ... }</i><br> If the property elbow is specified the line will be drawn using the first and last elements of the array rather than the coordinates of the two nodes. A property startX and startY can be used to better adjust the position of the starting line. Similarly, a property endX and endY can be used to better adjust the position of the end line. These properties have a maginitud between -1 to 1 which will be used based on the width and height of the source and target node. For example in the following edge object the line will start in the middle bottom of the source node and will end at the upper left of the target node.<br>  <i>{ ..., type : line, startX : 0, startY : 1, endX : -1, endY : -0.5, ... }</i>","Lines",false);this.defArray("arrows",["arrow","square","round"],"Arrows for the edges (or connections) in network graphs.<br> There are three arrow types: arrow, square and round. They can be at the start or at the end of the line. To specify an arrow at the start of the line include a startArrow property in the edge; to specify an arrow at the end of the line include a endArrow property in the edge. For example in this edge object:<br> <i>{ ..., type : line, startArrow : square, endArrow : arrow, ... }</i>","Lines",false);this.defOption("colorScheme","User",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color schemes can be user defined which will take the colors in the color property or one provided in canvasXpress. The order of the colors will be used to sequentially select when a different color is needed in a particular visualization","Colors",a);this.defArray("colors",["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"],"Colors","Colors",a);this.defArray("colorHSV",[0,0,1],"Color HSV. Hue, Saturation and Value used when configuring colors","Colors",false);this.defArray("colorRGB",[1,1,1],"Color RGB. Red, Green, Blue used when configuring colors","Colors",false);this.defArray("colorSpectrum",["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"],"An array with valid color names to create a color brew for the default color indicators","Colors",a);this.defArray("colorSpectrumBreaks",[],"An array with numbers in ascending order for the color spectrum to create discontinuous spectra. It must have the same length of the colorSpectrum array for example [0, 0.3, 1]","Colors",a);this.defFloat("colorSpectrumZeroValue",null,"A value to be at the center of the color spectrum to produce symmetrical heatmaps","Colors",a);this.defInteger("colorSpectrumNumber",100,"Number of colors to use in the color spectrum","Colors",a);this.defInteger("colorSpectrumTarget",10,"Approximate number of colors to use to build the color spectrum","Colors",a);this.defColor("odd","rgb(255,255,255)","odd numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots","Colors",a);this.defColor("even","rgb(245,245,245)","even numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots","Colors",a);this.defOption("blindnessType",false,[false,"protanopia","deuteranopia","tritanopia","monochromatic"],"Color Blindness","Colors",a);this.defInteger("roundedPolygonRadius",5,"Radius for rounded polygons","Shapes",a);this.defBoolean("useRoundRectangles",false,"Use round rectangles in bar graphs, stacked graphs and boxplots","Shapes",a);this.defBoolean("useOpenShapes",false,"Use open shapes in most visualizations","Shapes",a);this.defArray("shapes",["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle","image"],"Array with shapes used in visualizations. The order will dictate the utilization in the visualization","General Attributes",a);this.defArray("sizes",[8,12,16,20,24,28,32,36,40,44,48],"Array with sizes used invisualizations. The order will dictate the utilization in the visualization","General Attributes",a);this.defArray("images",[],"Array of urls of images used in scatter plots. Additional shapes will be used if the array does not contain as many images as needed","General Attributes",a);this.defArray("patterns",["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"],"Patterns used in visualizations to fill objects. This array must contain one or more pattern names and in concert with the color array can be used to specify the pattern colors for all filled objects in the visualizations.. The order will dictate the utilization in the visualization","General Attributes",a);this.defArray("linePatterns",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line Patterns used in line visualizations","General Attributes",a);this.defInteger("maxSmpStringLen",25,"Maximum length in characters a sample label or description can have so anything above is truncated","Samples",a);this.defString("smpTitle",false,"Title for the sample axis in one dimensional plots","Samples",a);this.defInteger("smpLabelInterval",1,"Interval for the sample labels in one dimensional and circular plots","Samples",a);this.defBoolean("smpLabelImage",false,"Use images as sample labels when possible","Samples",a);this.defBoolean("smpLabelImageRound",false,"Use round images as sample labels","Samples",a);this.defShow("SampleNames",true,"sample names","Samples",a);this.defArray("highlightSmp",[],"Name of samples to highlight","Samples",a);this.defColor("smpHighlight","rgb(255,0,0)","higlighted samples","Samples",a);this.defText("smpTitle","","rgb(0,0,0)",12,1,"center",0,5,"sample title","Samples",a);this.defText("smpLabel","","rgb(0,0,0)",12,1,"center",0,5,"sample labels","Samples",a);this.defInteger("maxVarStringLen",25,"Maximum length in characters a variable label or description can have so anything above is truncated","Variables",a);this.defString("varTitle",false,"Title for the variables in hetamap plots","Variables",a);this.defInteger("varLabelInterval",1,"Interval for the variable labels in heatmaps","Variables",a);this.defShow("VariableNames",true,"variable names","Variables",a);this.defArray("highlightVar",[],"Name of variables to highlight","Variables",a);this.defColor("varHighlight","rgb(255,0,0)","higlighted variables","Variables",a);this.defText("varTitle","","rgb(0,0,0)",12,1,"center",0,5,"variable title","Variables",a);this.defText("varLabel","","rgb(0,0,0)",12,1,"center",0,5,"variable labels","Variables",a);this.defObject("binConfigurations",{},"Properties for the binning functions","Bins",a);this.defInteger("maxOverlayStringLen",30,"Maximum length in characters for the sample or variable metadata when included as an overlay. Anything above is truncated","Overlays",a);this.defInteger("overlaysThickness",18,"Relative length in pixels for the thickness of the colored boxes to classify samples and or variables in one dimensional plots. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true","Overlays",a);this.defArray("smpOverlays",[],"Sample metadata to overlay in one dimensional plots","Overlays",a);this.defObject("smpOverlayProperties",{},"Object to assign properties of the sample overlays. The key should be a valid sample annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes","Overlays",a);this.defInteger("smpOverlaysLegendColumns",1,"Number of columns for the sample overlay legends","Overlays",a);this.defShow("SmpOverlaysLegend",false,"sample overlay legends","Overlays",a);this.defArray("varOverlays",[],"Variable metadata to overlay in heatmap plots","Overlays",a);this.defObject("varOverlayProperties",{},"Object to assign properties of the variable overlays. The key should be a valid variable annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes","Overlays",a);this.defInteger("varOverlaysLegendColumns",1,"Number of columns for the variable overlay legends","Overlays",a);this.defShow("VarOverlaysLegend",false,"sample overlay legends","Overlays",a);this.defPosition("overlaysLegend","topRight",["topRight","right","bottomLeft","bottom"],"the variable and sample overlays legend","Overlays",a);this.defShow("Overlays",true,"overlays in one dimensional plots","Overlays",a);this.defShow("LevelOverlays",true,"overlay levels (values) in one dimensional plots","Overlays",a);this.defText("overlay","","rgb(0,0,0)",12,1,"center",0,5,"overlays","Overlays",a);this.defBoolean("legendInside",false,"Position the legend inside the graphs","Legends",a);this.defInteger("legendColumns",1,"Number of columns in legends","Legends",a);this.defInteger("legendRows",1,"Number of rows in legends","Legends",a);this.defObject("legendOrder",false,"Object to specify custom order for the levels in the legends. The key of the object is the name of a valid sample or variable annotation included in the data object. The value for element is an array with the levels for the corresponding factor","Legends",a);this.defArray("customLegend",[],"Custom legends : Array of objects [{ size : [], shape : [], shapeColor : [], line : [], lineColor : [], lineStart : [], lineEnd : [], text : [], x : number, y : number, title : string }]","Legends",a);this.defShow("Legend",true,"legend","Legends",a);this.defShow("LegendTitle",true,"the legend title","Legends",a);this.defShow("LegendBorder",true,"the legend border","Legends",a);this.defPosition("legend","right",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the legend","Legends",a);this.defDirection("legend","vertical","legend","Legends",a);this.defRect("legendBackground","rgba(0,0,0,0)","rgb(0,0,0,0)",0.5,"solid","legend background","Legends",a);this.defRect("legendKeyBackground","rgba(0,0,0,0)","rgb(0,0,0,0)",1,"solid","legend key background","Legends",a);this.defText("legendText","","rgb(0,0,0)",12,1,"left",0,8,"legends","Legends",a);this.defText("legendTitle","","rgb(0,0,0)",12,1,"center",0,8,"legends","Legends",a);this.defInteger("decorationsWidth",20,"Length in pixels of the width for the decorations in the networks","Decorations",a);this.defInteger("decorationsHeight",40,"Length in pixels of the height for the decorations in the networks","Decorations",a);this.defOption("decorationsType","bar",["pie","bar","heatmap","stacked","stackedpercent"],"Type for the decorations in the networks. The types stacked and stackedpercent must be two dimensional. Heatmap could be one or two dimensional","Decorations",a);this.defObject("decorations",false,"Name of the node properties to include in the network decorations in the data.nodes object","Decorations",a);this.defArray("decorationsColors",[],"Array of colors used for selection in network decorations not to be confused by its singular form decorationsColor above","Decorations",a);this.defObject("decorationsProperties",{},"Object to assign properties like color for the network decorations","Decorations",a);this.defBoolean("decorationsInside",false,"Position the decorations inside the graphs","Decorations",a);this.defShow("Decorations",true,"decorations","Decorations",a);this.defShow("DecorationsLegend",true,"decoration legends","Decorations",a);this.defShow("DecorationsBorder",false,"the decoration legends border","Decorations",a);this.defPosition("decorations","bottom",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the decorations","Decorations",a);this.defRect("decorationsBackground","rgba(0,0,0,0)","rgb(204,204,204)",0.5,"solid","decoration legends background","Decorations",a);this.defText("decorationsText","","rgb(0,0,0)",12,1,"center",0,5,"decoration legends","Decorations",a);this.defBoolean("isGroupedData",false,"Flag to indicate if the data is grouped","Data",false);this.defBoolean("isBoxplotCalc",false,"Flag to indicate if the iqr has been calculated when the graph type is Boxplot","Data",false);this.defArray("groupingFactors",[],"An array that holds the group names used for grouping the data. It must be a category in the data.x object","Data",a);this.defArray("segregateSamplesBy",[],"An array that holds the annotation(s) used to segregate the samples. It must be categories in the data.x object","Data",a);this.defArray("segregateVariablesBy",[],"An array that holds the annotation(s) used to segregate the variables. It must be categories in the data.z object","Data",a);this.defOption("summaryType",false,[false,"iqr","median","mean","cor","min","max","count","sum"],"Summary type for the data when grouping","Data",a);this.defBoolean("isTransformedData",false,"Flag to indicate if the data is transformed","Data",false);this.defInteger("transformBase",10,"Default log or exponential transformation for the data","Data",false);this.defOption("transformData",false,[false,"log2","log10","exp2","exp10","percentile","zscore","ratio2","ratio10","save","reset","undo"],"Default transformation type for ALL the data. Data can also be transformed by axis (x,y,z) to give more flexibility. false, save, reset and undo are NOT real transformations. They are only used in the canvasXpress UIs to save the transformed data","Data",a);this.defOption("transformAxis","samples",["samples","variables"],"Default axis to use to transform the data when either z-score or ratio transformation is used","Data",a);this.defInteger("ratioReference",0,"Default index of sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",a);this.defOption("ratioSampleReference",false,[false],"Name of the sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",a);this.defOption("ratioGroupReference",false,[false],"Name of the group used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",a);this.defOption("ratioLevelReference","",[],"Name of the level used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",a);this.defBoolean("transposeData",false,"Flag to transpose data as a parameter. This parameter accomplishes the same as the function transpose at load time","Data",a);this.defArray("asSampleFactors",[],"Array containing variable names. Numeric variable data (in rows) to be treated as a sample factor (move from y to x object). This parameter accomplishes the same as the function switchVarToAnnotation at load time. It can be used in conjunction with the parameter stringSampleFactors to be treated as a string. TO DO: write example","Data",a);this.defArray("asVariableFactors",[],"Array containing sample names. Numeric sample data (in columns) to be treated as a variable factor (move from y to z object). This parameter accomplishes the same as the function switchSmpToAnnotation at load time. It can be used in conjunction with the parameter stringVariableFactors to be treated as a string. TO DO: write example","Data",a);this.defArray("stringSampleFactors",[],"Array containing sample factors. The numeric sample factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for samples at load time. It can be used in conjunction with the parameter asSampleFactors. TO DO: write example","Data",a);this.defArray("stringVariableFactors",[],"Array containing variable factors. The numeric variable factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for variables at load time. It can be used in conjunction with the parameter asVariableFactors. TO DO: write example","Data",a);this.defString("histogramData",false,"Flag or sample annotation to create histogram. If true is specified then the histogram will be done with all data","Data",a);this.defArray("appendNetworkData",[],"Array containing additional data files to append to networks. Useful for loading KEGG and Wikipatways to decorate the nodes and the edges","Data",a);this.defOption("timeFormat","isoDate",["default","shortDate","mediumDate","longDate","fullDate","shortTime","mediumTime","longTime","isoDate","isoTime","isoDateTime","isoUtcDateTime","year","month","day","hour","minute","second"],"Time Format according to date.format.js Steven Levithan <stevenlevithan.com>","Time Series",a);this.defBoolean("isGraphTime",false,"Flag to indicate if the data is a time series so there is no need to plot every time interval. It is boolean in one dimensional plots or a string indicating the axis which is timed x, y or z","Time Series",a);this.defArray("timeValues",[],"Array containing the tick values when the the graph is a time series","Time Series",false);this.defArray("timeValueIndices",[],"Array containing the indices of the values when the the graph is a time series","Time Series",false);this.defObject("timeValueProperties",{},"Object with all the time properties needed to plot the data","Time Series",false);this.defOption("sortDir","ascending",["ascending","descending"],"Default direction for data sorting. Almost private parameters used within the different CanvasXpress UIs","Data sorting",a);this.defBoolean("sortCaseSensitive",false,"Whether to use case sensitive in ascii sorting. Almost private parameters used within the different CanvasXpress UIs","Data sorting",a);this.defObject("sortData",[],"Array of arrays with sorting functions. Each function takes three parameters. The first parameter must be either smp to identify the parameters are related to the samples, var to identify  the parameters are related to the variables, or cat to identify a sample or variable category. The second parameter can be either smp to indicate to sort the sample indices or var to indicate to sort the variable indices. The third parameter is the value for the key referenced by the first parameter. A special case for this parameter could be samples or variables to indicate to sort by the names of the samples or variables respectively. Here are some examples to sort the samples in the data: [ [cat, smp, Factor1] ]   : Sort the samples by the sample category Factor1 [ [var, smp, Variable1] ] : Sort the samples by the value of the Variable1 [ [cat, smp, samples] ]   : Sort the samples by their name.  Important!!!! This parameter will clean the data and remove any variables not used in the dataset at load time","Data sorting",a);this.defOption("sortOnGrouping",false,[false,"ascending","descending"],"Sort the name of the groups after sample grouping.<br>","Data sorting",a);this.defColor("missingData","rgb(245,245,245)","missing data","Missing Data",a);this.defString("missingDataValue","NA","String value use to specify missing data","Missing Data",a);this.defBoolean("nanOmit",false,"Flag to omit NaN values in log transformation","Missing Data",a);this.defShow("ErrorBars",true,"error bars in graphs","Error Bars and Confidence Intervals",a);this.defOption("errorBarsType","confidenceInterval95",["standardDeviation","standardErrorMean","confidenceInterval95"],"Type of error bars","Error Bars and Confidence Intervals",a);this.defColor("errorBars","rgb(0,0,0)","error bars in dotplots and barplots","Error Bars and Confidence Intervals",a);this.defFloat("errorBarsThickness",3,"Thickness for the error bars in dotplots","Error Bars and Confidence Intervals",a);this.defInteger("errorBarsWidth",2,"Minimum size of the bar in pixels to determine to show or hide error bar ends in the graphs when available","Error Bars and Confidence Intervals",a);this.defOption("standardDeviationType","unbiased",["biased","unbiased"],"Type of Standard Deviation. biased uses n as denominator and unbiased uses (n - 1) as denominator where n is the number of values","Error Bars and Confidence Intervals",a);this.defShow("RegressionFullRange",false,"full range in regression plots","Error Bars and Confidence Intervals",a);this.defOption("regressionType","linear",["linear","exponential","logarithmic","power","polynomial"],"Type of linear least-squares fitting methods for simple data analysis","Error Bars and Confidence Intervals",a);this.defInteger("regressionOrder",2,"Specifies the number of degrees to solve for in polynomial regressions","Error Bars and Confidence Intervals",a);this.defShow("ConfidenceIntervals",true,"confidence intervals in the regression and Kaplan-Meier plots ","Error Bars and Confidence Intervals",a);this.defFloat("confidenceLevel",0.95,"Confidence level for regression, ellipse and Kaplan Meier","Error Bars and Confidence Intervals",a);this.defOption("confidenceIntervalType","log",["ordinary","log","loglog"],"Confidence intervals type for Kaplan Meier estimates","Error Bars and Confidence Intervals",a);this.defColor("confidenceInterval","rgb(50,50,50)","confidence intervals","Error Bars and Confidence Intervals",a);this.defBoolean("invertCensored",false,"Flag to indicate whether zero values are censored or not in Kaplan-Meier plots ","Error Bars and Confidence Intervals",a);this.defColor("fitLine","rgb(255,215,0)","fit line","Error Bars and Confidence Intervals",a);this.defOption("fitLineStyle","solid",["solid","dotted","dashed","dotdash","longdash","twodash"],"Color for the fit line","Error Bars and Confidence Intervals",a);this.defInteger("fitLineWidth",2,"Specifies the width for the fitLine","Error Bars and Confidence Intervals",a);this.defFloat("fitLineTransparency",1,"The transparency for the fit line. A value between 0 and 1","Error Bars and Confidence Intervals",a);this.defInteger("randomSeed",8,"Specifies the random seed number to create pseudo random numbers","Random",a);this.defBoolean("pseudoRandom",true,"Flag to indicate to use pseudo random rather than random","Random",a);this.defOption("randomMethod","numericalRecipes",["jenkins","numericalRecipes"],"Random method","Random",a);this.defBoolean("randomData",false,"Flag to indicate random data for debug and demonstration purposes","Random",false);this.defOption("randomDataDistribution","biased",["range","normal","uniform","symmetrical","biased"],"Distribution for the random data","Random",a);this.defBoolean("randomDataTime",false,"Flag to create or not time series random data for debug and demonstration purposes","Random",a);this.defInteger("randomDataMin",1,"Minimun value when creating random data","Random",a);this.defInteger("randomDataMax",100,"Maxmun value when creating random data","Random",a);this.defInteger("randomDataMean",0,"Mean value when creating random data","Random",a);this.defInteger("randomDataSigma",1,"Sigma value when creating random data","Random",a);this.defInteger("randomDataVariables",3,"Default number of variables when creating random data","Random",a);this.defInteger("randomDataSamples",36,"Default number of samples when creating random data","Random",a);this.defInteger("randomDataVariableAnnotations",2,"Default number of variable annotations when creating random data","Random",a);this.defInteger("randomDataSampleAnnotations",2,"Default number of sample annotations when creating random data","Random",a);this.defFloat("randomMissingDataPercentage",0,"Default percentage of missing values when creating random data. A value between 0 and 1","Random",a);this.defBoolean("randomNetworkReduce",true,"Flag to create or not a single random network for debug and demonstration purposes","Random",a);this.defInteger("randomNetworkNodes",40,"Default number of nodes when creating random networks","Random",a);this.defInteger("randomNetworkNodeEdgesMax",5,"Default number of maximum edges when creating random networks","Random",a);this.defBoolean("randomNetworkAll",true,"Use all types of colors, shapes and edges in random network, otherwise only one color, one shape and straight black lines for the edges","Random",a);this.defOption("randomNetworkLayout","forceLayout",["forceDirected","circular","radial","duo","trio","pentagon","hexagon","octagon","star","small","medium","large","huge","lesmiserables","karate"],"Random network layout","Random",a);this.defFloat("zoom",1,"Zoom factor for the networks. A number greater than zero","Zooming, Panning and Resizing",a);this.defFloat("zoomGlobal",1,"Cumulative zoom factor for the networks","Zooming, Panning and Resizing",false);this.defFloat("zoomStep",0.2,"Percentage step for zooming networks and genome panel","Zooming, Panning and Resizing",a);this.defBoolean("zoomScale",true,"Flag to scale nodes and edges in networks with zoom and data points in 3D scatter plots","Zooming, Panning and Resizing",a);this.defBoolean("zoomVariablesDisable",false,"Flag to disable zooming of variables with mouse wheel in Heatmaps","Zooming, Panning and Resizing",a);this.defBoolean("zoomSamplesDisable",false,"Flag to disable zooming of samples with mouse wheel in Heatmaps","Zooming, Panning and Resizing",a);this.defBoolean("zoomDisable",false,"Flag to disable zooming in all plots","Zooming, Panning and Resizing",a);this.defFloat("panningX",0,"Number of unit to pan the network in the X dimension","Zooming, Panning and Resizing",a);this.defFloat("panningY",0,"Number of unit to pan the network in the Y dimension","Zooming, Panning and Resizing",a);this.defFloat("panningGlobalX",0,"Cumulative number of unit to pan the network in the X dimension","Zooming, Panning and Resizing",false);this.defFloat("panningGlobalY",0,"Cumulative number of unit to pan the network in the Y dimension","Zooming, Panning and Resizing",false);this.defFloat("panningStep",0.2,"Percentage step for panning networks","Zooming, Panning and Resizing",a);this.defColor("resizerBackground","rgba(204,204,204,0.7)","div that shows up when resizing the canvas","Zooming, Panning and Resizing",a);this.defAxis("x","X axis","X-Axis",a);this.defAxis("y","Y axis","Y-Axis",a);this.defAxis("z","Z axis","Z-Axis",a);this.defBoolean("rAxisPercentShow",true,"Flag to show on not the percent in each segment in the R axis","R-Axis",a);this.defOption("rAxisLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the ticks values in circular plots","R-Axis",a);this.defAxis("r","R axis","R-Axis",a);this.defFloat("axisExtension",0.1,"Percentage to extend the values of the data to ensure all the data points are plotted inside and not over the edges of the graph","Axis",a);this.defOption("axisAlgorithm","rPretty",["heckbert","wilkinson","wilkinsonExtended","rPretty"],"Algorithm used to position tick labels on axes. See An Extension of Wilkinson’s Algorithm for Positioning Tick Labels on Axes. Justin Talbot, Sharon Lin, Pat Hanrahan","Axis",a);this.defBoolean("axisWilkinsonLoose",false,"Flag to indicate whether to use loose positioning when using the wilkinson algorithm to position the labels on the axis. There will not be a difference most of the times","Axis",a);this.defBoolean("axisCoordinate",false,"Flag to coordinate xAxis and xAxis2 in *-Line combination plots","Axis",a);this.defFloat("setMax",null,"Maximum value to set the data","Axis",false);this.defFloat("setMin",null,"Minimum value to set the data","Axis",false);this.defText("axisTick","","rgb(0,0,0)",12,1,"left",0,5,"axis","Axis",a);this.defText("axisTitle","","rgb(0,0,0)",12,1,"left",0,5,"axis","Axis",a);this.defOption("guides",false,[false,"solid","dotted","dashed","dotdash","longdash","twodash"],"This is a thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",a);this.defFloat("guidesWidth",1,"The width for the thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",a);this.defColor("guides","rgb(204,204,204)","thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",a);this.defBoolean("blockContrast",false,"A flag to creates a shade between the samples so there are two backgrounds, one for the odd samples and one for the even samples","Plot area",a);this.defBoolean("plotByVariable",false,"Flag to indicate whether to group the data variable rather than by sample","Plot area",a);this.defBoolean("is3DPlot",false,"Flag to create or not a 3D plot","Plot area",a);this.defShow("DataValues",false,"data values in the one bar graphs","Plot area",a);this.defBoolean("binned",false,"Flag to bin the data points in dotplots and boxplots","Plot area",a);this.defOption("binAlignment","center",["left","center","right"],"Alignment for the data points when binned","Plot area",a);this.defBoolean("jitter",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots","Plot area",a);this.defFloat("jitterFactor",0.4,"Factor for jittering. The larger the more jitter","Plot area",a);this.defColor("objectBorder","rgb(0,0,0)","border of all objects in one dimensional graphs. It turns into the non-transparent fill color if set to false","Plot area",a);this.defFloat("objectColorTransparency",1,"The transparency for the color fill of all objects in one dimensional graphs. A value between 0 and 1","Plot area",a);this.defInteger("dotplotOutlineThreshold",5000,"Maximum number of data points before skipping plotting their outline but only the fill color","Plot area",a);this.defOption("lineDecoration","symbol",[false,"dot","symbol","pattern"],"Lines decorations in the line graphs","Line Graphs",a);this.defOption("lineErrorType","bar",["bar","area"],"Line error type in the line graphs. The line type must be spline for the area error type. ","Line Graphs",a);this.defBoolean("coordinateLineColor",false,"Flag to used same color in BarLine plots. If set to true the color of the bars and the lines will be coordinated","Line Graphs",a);this.defOption("lineType","rect",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line used to join the points in line graphs","Line Graphs",a);this.defFloat("tension",0.3,"Curvature for the splines and hulls","Line Graphs",a);this.defInteger("tensionSegments",16,"Number of segments to smooth a quadratic curve","Line Graphs",a);this.defArray("parallelCoordinates",[],"Array used to store and handle a parallel coordinates plot","Line Graphs",false);this.defInteger("boxplotOutliersRatio",8,"Ratio for the size of the outliers with respect to boxplot","Boxplot Graphs",a);this.defOption("boxplotWhiskersType","double",["single","double","none"],"Boxplot whiskers type","Boxplot Graphs",a);this.defOption("boxplotType","boxWhiskers",["boxWhiskers","range"],"Boxplot type","Boxplot Graphs",a);this.defBoolean("boxplotNotched",false,"Flag to notch boxplots","Boxplot Graphs",a);this.defFloat("boxplotTransparency",0.5,"Fraction to adjust color transparency for the boxplot id individual data points are shown","Boxplot Graphs",a);this.defColor("boxplot",false,"boxplot if individual data points are shown","Boxplot Graphs",a);this.defBoolean("boxplotVarWidth",false,"Flag to adjust the width of boxplots. Similar to R if true then the width is proportional to the sqare root of the number of observations","Boxplot Graphs",a);this.defFloat("boxplotCoef",1.5,"Number that determines how far the plot ‘whiskers’ extend out from the box","Boxplot Graphs",a);this.defOption("boxplotHingeFunction","summary",["summary","fivenum"],"Function to calculate the boxplor hinges. See https://chemicalstatistician.wordpress.com/2013/08/12/exploratory-data-analysis-the-5-number-summary-two-different-methods-in-r-2/","Boxplot Graphs",a);this.defShow("BoxplotOriginalData",false,"observed data point in boxplots. (Should be called showBoxplotDataPoints)","Boxplot Graphs",a);this.defShow("ViolinBoxplot",false,"violin plot in boxplots","Boxplot Graphs",a);this.defBoolean("violinTrim",true,"Flag to trim violin plots","Boxplot Graphs",a);this.defOption("violinScale","width",["area","count","width"],"Type for scaling violin plots","Boxplot Graphs",a);this.defShow("BoxplotIfViolin",true,"boxplots when violin plot are show. It does not affect anything unless violins are shown","Boxplot Graphs",a);this.defFloat("boxplotWidthRatioIfViolin",0.33,"A number between 0.1 and 1 to adjust the width of the boxplot when violins are shown. It does not affect anything unless violins are shown","Boxplot Graphs",a);this.defFloat("violinTransparency",0.5,"Fraction to adjust color transparency for the violins","Boxplot Graphs",a);this.defColor("violin",false,"violins. If specified all the violins will have the assigned color; otherwise it will be automatically assigned","Boxplot Graphs",a);this.defColor("violinBorder","rgb(0,0,0)","violin borders","Boxplot Graphs",a);this.defShow("ViolinQuantiles",false,"quantile 0.25 and 0.75 in violin plots","Boxplot Graphs",a);this.defFloat("boxplotDataPointTransparency",0.5,"Fraction to adjust color transparency for the data points when displaying original data in boxplots","Boxplot Graphs",a);this.defColor("boxplotBorder",false,"line of the borders in boxplots","Boxplot Graphs",a);this.defColor("boxplotMedian","rgb(0,0,0)","line of the median of data in boxplots","Boxplot Graphs",a);this.defInteger("boxplotMedianWidth",2,"Width for the line of the median of data in boxplots","Boxplot Graphs",a);this.defBoolean("boxplotMean",false,"Flag to show mean of data in boxplots","Boxplot Graphs",a);this.defColor("boxplotMean","rgb(255,215,0)","data mean in boxplots","Boxplot Graphs",a);this.defColor("boxplotMeanBorder","rgb(255,0,0)","border of the data mean in boxplots","Boxplot Graphs",a);this.defBoolean("boxplotConnect",false,"Flag to show data in boxplots connected","Boxplot Graphs",a);this.defInteger("boxplotConnectWidth",2,"Width for the line of the connection of boxes in boxplots","Boxplot Graphs",a);this.defOption("areaType","normal",["normal","stacked","percent"],"Flag to produce normal, stacked, center or percent area graphs","Area Graphs",a);this.defOption("dotplotType","normal",["normal","stacked","movement"],"Flag to produce normal, stacked or movement dotplot graphs. Movement plot are only applicable when data is grouped","Dotplot Graphs",a);this.defOption("barType","normal",["normal","lollipop","arrow","swimmer"],"Flag to produce normal or lollipop bar graphs","Bar Graphs",a);this.defBoolean("barPath",false,"Show the path for the bar graph","Bar Graphs",a);this.defBoolean("barPathTransparency",0.1,"Transparency for the bar graph path","Bar Graphs",a);this.defColor("barPath",false,"bar graph path. If false, it will default to the color of the graph","Bar Graphs",a);this.defInteger("barLollipopFactor",1.5,"Ratio for the lollipop in bar graphs. The higher the value the bigger the lollipop","Bar Graphs",a);this.defBoolean("barLollipopOpen",false,"Pattern open for th lollipop","Bar Graphs",a);this.defOption("swimHigh",false,[false],"Variable to use in Swimmer plot. Defaults to the first variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",a);this.defOption("swimStart",false,[false],"Variable to use in Swimmer Plot. Defaults to the second variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",a);this.defOption("swimEnd",false,[false],"Variable to use in Swimmer Plot. Defaults to the third variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",a);this.defOption("swimStatus",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to Status. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",a);this.defOption("swimHighCap",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to High Cap. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",a);this.defOption("ganttStart",false,[false],"Variable to use in Gantt plots as start date. Defaults to the first variable in the data set","Gantt Charts",a);this.defOption("ganttEnd",false,[false],"Variable to use in Gantt plots as end date. Defaults to the second variable in the data set","Gantt Charts",a);this.defOption("ganttCompletion",false,[false],"Variable annotation in the x object to use in Gantt plots as completion percentage. Must be a value between 0 and 1","Gantt Charts",a);this.defOption("ganttDependency",false,[false],"Variable annotation in the x object to use in Gantt plots as dependency. Must be a valid sample / group name","Gantt Charts",a);this.defOption("ganttDependencyEnd",false,[false],"Variable annotation for the type of ending for the dependency line. Options are arrow, square or round","Gantt Charts",a);this.defColor("ganttDependency",false,"variable metadata used for the dependency line. Defaults to rgb(0,0,0)","Gantt Charts",a);this.defFloat("ganttDependencyThickness",false,"Variable annotation for the thickness of the dependency line. Defaults to 1","Gantt Charts",a);this.defFloat("ganttCompletionTransparency",0.5,"Fraction to adjust color transparency for completion","Gantt Charts",a);this.defOption("meterType","gauge",["gauge","speedometer","vertical","horizontal","state","digital","number"],"Type of meter. ","Meter Graphs",a);this.defFloat("meterMin",null,"Minimum value in the meter","Meter Graphs",a);this.defFloat("meterMax",null,"Maximum value in the meter","Meter Graphs",a);this.defFloat("meterStart",270,"Start value for the meter in degrees","Meter Graphs",a);this.defFloat("meterEnd",90,"End value for the meter in degrees","Meter Graphs",a);this.defArray("meterSegments",[],"Meter Segments","Meter Graphs",a);this.defArray("meterColors",[],"Meter Colors","Meter Graphs",a);this.defOption("meterVar",false,[false],"Name of the variable use to create the meter. The first variable will be used if not specified or if it is non-valid","Meter Graphs",a);this.defInteger("meterIndex",0,"Variable index to use creating a meter when there are multiple variables","Meter Graphs",false);this.defColor("meterNeedle","rgb(0,0,0)","Meter Needle Color","Meter Graphs",a);this.defColor("meterBackground","rgb(229,229,229)","Meter Background Color","Meter Graphs",a);this.defInteger("meterThickness",50,"Thickness in pixels for the vertical, horizontal and state meters","Meter Graphs",a);this.defArray("fishParents",[],"Fish Parents","Fish Graphs",a);this.defArray("fishTimepoints",[],"Fish Timepoints","Fish Graphs",a);this.defBoolean("fishSeparateIndependentClones",false,"Separate indepenent clones","Fish Graphs",a);this.defOption("fishShape","polygon",["spline","polygon"],"Fish Shape","Fish Graphs",a);this.defArray("fishAxis",[],"Fish Axis (array with lines across the X Axis)","Fish Graphs",a);this.defArray("fishAxisLabels",[],"Fish Axis Labels (array with names for the lines across the X Axis). Must have the same dimension as the fishAxis","Fish Graphs",a);this.defArray("fishCloneLabels",[],"Fish Clone Labels (array with names for the clones). Must have the same dimension as the fishParents","Fish Graphs",a);this.defInteger("sankeyNodeWidth",20,"Width for the Sankey nodes","Sankey Diagrams",a);this.defInteger("sankeyIterations",32,"Number of iterations for the Sankey diagram","Sankey Diagrams",false);this.defOption("sankeySource",false,[false],"Name of a sample annotation to use as source in the sankey diagrams","Sankey Diagrams",a);this.defOption("sankeyTarget",false,[false],"Name of a sample annotation to use as target in the sankey diagrams","Sankey Diagrams",a);this.defColor("sankey","rgba(150,150,150,0.5)","sankey lines (links)","Sankey Diagrams",a);this.defBoolean("sankeyCoordinateColor",false,"Flag to use same color for the nodes and for the lines (links) in the Sankey diagram","Sankey Diagrams",a);this.defArray("hierarchy",[],"Hierarchy for trees and bubble graphs made up of sample annotations present the data x object","Hierarchy",a);this.defString("hierarchyVar",false,"Variable name to use in the sankey, sunburst and bubble graphs. This is used when the data set has more than a single variable. Otherwise the first variable will be selected","Hierarchy",a);this.defInteger("hierarchyVarIndex",0,"Variable index to use in the sankey, sunburst and bubble graphs","Hierarchy",false);this.defInteger("treeNodeSize",5,"Size for the Tree nodes","Trees",false);this.defColor("treeLink","rgb(150,150,150)","tree lines (links)","Trees",a);this.defColor("treeNodeOutline","rgb(51,122,183)","tree node outline","Trees",a);this.defInteger("treeLinkWidth",1,"Width for the Tree lines","Trees",a);this.defBoolean("treeCircular",false,"Flag to plot a circular tree layout","Trees",a);this.defBoolean("treeInverted",false,"Flag to plot the tree inverted","Trees",a);this.defInteger("treeVarIndex",0,"Variable index to use in the tree diagrams","Trees",false);this.defInteger("treeNodeId",0,"Id for the nodes in the tree","Trees",false);this.defOption("colorBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to color the variables","Data Point Attributes",a);this.defBoolean("colorByShowLegend",true,"Flag to show the colorBy legend","Data Point Attributes",a);this.defObject("colorKey",false,"Object to assign custom colors to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object, or the name of an annotation in the data.z object. The value for each key could be either: (1) a scalar with a valid color scheme (see this.meta.def.colorSchemes), or (2) an array with valid colors, or (3) an object to specify custom colors for each of the values of the annotation. A default color will be assigned to a data point whose value was not included the object. CanvasXpress will handle string and numeric annotation approprietly. However, if an object is specified like that one in number (3) the annotation will be treated as categorical even if the annotation is numeric","Data Point Attributes",a);this.defOption("shapeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to shape the variables. When shapeByData is specified shapeBy is used for the title in the legend","Data Point Attributes",a);this.defBoolean("shapeByContinuous",false,"Flag to use pie shapes with continuous data as opposed to by binning the data and show regular shapes","Data Point Attributes",a);this.defBoolean("shapeByShowLegend",true,"Flag to show the shapeBy legend","Data Point Attributes",a);this.defObject("shapeKey",false,"Object to assign custom shapes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default shape will be assigned to a data point whose value was not included the object","Data Point Attributes",a);this.defString("shapeByData",false,"String that identify the object containing a two dimensional array with values used to shape data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)","Data Point Attributes",a);this.defOption("shapeByShape",false,[false,"sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","mdavid"],"String that identify the shape to use in regular and multidimensional heatmaps. shapeByData will take precedence over this property","Data Point Attributes",a);this.defOption("sizeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to size the variables. When sizeByData is specified sizeBy is used for the title in the legend","Data Point Attributes",a);this.defBoolean("sizeByContinuous",false,"Flag to show the size data continuously as opposed to by binning the sizes","Data Point Attributes",a);this.defBoolean("sizeByShowLegend",true,"Flag to show the sizeBy legend","Data Point Attributes",a);this.defObject("sizeKey",false,"Object to assign custom sizes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default size will be assigned to a data point whose value was not included the object","Data Point Attributes",a);this.defString("sizeByData",false,"String that identify the object containing a two dimensional array with values used to size data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data3)","Data Point Attributes",a);this.defString("outlineBy",false,"Name of the annotation for the outline when drawing a multidimensional Heatmap","Data Point Attributes",a);this.defBoolean("outlineByShowLegend",true,"Flag to show the outlineBy legend","Data Point Attributes",a);this.defString("outlineByData",false,"String that identify the object containing a two dimensional array with values used to color the outline data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)","Data Point Attributes",a);this.defOption("patternBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to pattern the variables. When patternByData is specified patternBy is used for the title in the legend","Data Point Attributes",a);this.defBoolean("patternByShowLegend",true,"Flag to show the patternBy legend","Data Point Attributes",a);this.defObject("patternKey",false,"Object to assign custom patterns to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default pattern will be assigned to a data point whose value was not included the object","Data Point Attributes",a);this.defString("patternByData",false,"String that identify the object containing a two dimensional array with values used to pattern the data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)","Data Point Attributes",a);this.defOption("connectBy",false,[false],"Name of a variable annotation to connect the variables","Data Point Attributes",a);this.defBoolean("connectByNoColor",false,"Flag to prevent coloring the lines  by the connectBy annotation. Usefull when connectBy is used along with colorBy to avoid confusion of colors","Data Point Attributes",a);this.defColor("connectBy","rgb(204,204,204)","connectBy lines","Data Point Attributes",a);this.defInteger("connectByWidth",2,"Width for the line of the connectBy line","Data Point Attributes",a);this.defBoolean("connectByShowLegend",true,"Flag to show the connectBy legend","Data Point Attributes",a);this.defObject("connectKey",false,"Object to assign custom colors to lines when samples are connected by a sample annotations included in the data object. The key of the object is the name of an annotation in the data.x object. A default connect will be assigned to a data point whose value was not included the object","Data Point Attributes",a);this.defObject("connectByData",{},"Internal object with connectBy data","Data Point Attributes",false);this.defArray("treemapBy",[],"Array of sample annotations to treemap the variables. The array may also include sample to use as last level","Data Point Attributes",a);this.defOption("stackBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Bar graphs","Data Point Attributes",a);this.defOption("dodgeBy",false,[false],"Name of a sample annotation to dodge the samples of each variable in Bar graphs","Data Point Attributes",a);this.defOption("lineBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Line graphs","Data Point Attributes",a);this.defBoolean("lineByShowLegend",true,"Flag to show the lineBy legend","Data Point Attributes",a);this.defOption("ribbonBy",false,[false],"Name of a sample annotation(s) to create a ribbon of each variable in scatter plots. If a single annotation is passed then it will be used as a standard deviation. If two annotations are passed then, it will be used as upper and lower confidence intervals. Works in coordination with the lineBy parameter","Data Point Attributes",a);this.defOption("motionBy",false,[false,"variable"],"Utility to create dynamic filtering of data in Scatter plots","Data Point Attributes",a);this.defOption("markerBy",false,[false,"variable"],"Utility to create dynamic markers in Map. It must have a latitude and longitude metadata too","Data Point Attributes",a);this.defOption("ellipseBy",false,[false,"variable"],"Utility to create error ellipses in Scatter plots","Data Point Attributes",a);this.defOption("ridgeBy",false,[false],"Utility to create ridgelines in Scatter2D plots","Data Point Attributes",a);this.defInteger("motionWidth",250,"Size in pixels for the motion widget when used to reproduce user customizations","Motion Charts",a);this.defText("motionCurrent","","rgb(0,0,0,0.3)",60,1,"center",0,5,"motion charts","Motion Charts",a);this.defOption("scatterType",false,[false,"line","bar","dot","image","lineImage","lineStep","boxplot","visium","manhattan","bin2d"],"Type of scatter plot","Scatter Plots",a);this.defBoolean("visiumFlip",false,"Invert the data in visium plots. ","Scatter Plots",a);this.defBoolean("visiumPanning",false,"No panning on visium plots so dragging will always zoom","Scatter Plots",a);this.defBoolean("visiumFixedAspectRatio",true,"Fix aspect ratio for visium plots","Scatter Plots",a);this.defBoolean("scatterAxesEqual",false,"Keep same range in both axes","Scatter Plots",a);this.defInteger("scatterOutlineThreshold",50000,"Maximum number of data points before skipping plotting their outline but only the fill color","Scatter Plots",a);this.defArray("chromosomeLengths",[],"Manhattan Chromosomes length is a sorted array by chromosome with the length in base pairs for each chromosome. It is required when scatterType is manhattan","Scatter Plots",a);this.defString("manhattanMarkerChromosomeNumber",false,"Sample name included in the data.y.smps object used to map to the chromosome number","Scatter Plots",a);this.defOption("manhattanMarkerPosition",false,[false],"Sample name included in the data.y.smps object used to map to the position in base pairs","Scatter Plots",a);this.defOption("manhattanMarkerLogPValue",false,[false],"Sample name included in the data.y.smps object used to map to the negative log 10 p value","Scatter Plots",a);this.defArray("manhattanColors",["rgb(128,128,128)","rgb(135,206,235)"],"Colors for the manhattan plots","Scatter Plots",a);this.defArray("manhattanContrastColor","rgba(0,0,0,0.1)","Manhattan contrast color","Scatter Plots",a);this.defFloat("groupingFactorWindow",false,"The width for the data when grouping in Scatter2D plots. This is the analogous parameter to cut_width in R. It defaults to a fifth of the data range. The scatterType must be boxplot to take this parameter into effect","Scatter Plots",a);this.defColor("function","rgb(0,0,0)","function plots","Scatter Plots",a);this.defOption("selectionMode","highlight",["highlight","ghost","name","filter"],"Mode use to highlight selected data points in visualizations","Data Selection",a);this.defColor("selection","rgb(255,0,0)","The color used for selected data points when selection mode is to be highlight","Data Selection",a);this.defOption("selectionMetadata",false,[false],"Matadata (or factor) to use to display selected data points instead of the variable name. This metadata has to be in the data.z object. This property is only valid when the selectionMode is name and the visualization is a Scatter plot","Data Selection",a);this.defArray("selectedDataPoints",[],"Variable / Sample names of data points (in the data object) to initially select","Data Selection",a);this.defBoolean("isContour",false,"Flag to show the contour","Contours",a);this.defBoolean("contourFilled",false,"Flag to color the contour plot","Contours",a);this.defFloat("contourFilledTransparency",1,"Transparency applied to the filled contours","Contours",a);this.defShow("ContourBands",true,"contour bands","Contours",a);this.defColor("contourBands","rgb(0,0,255)","the bands in contours","Contours",a);this.defInteger("contourLevelWidth",null,"Width of contour levels","Contours",a);this.defInteger("contourLevelNumber",10,"Numbe of contour levels. Overridden by contourLevelWidth","Contours",a);this.defOption("contourStat","density",["density","ndensity","count"],"Contour density type","Contours",a);this.defOption("contourType","normal",["normal","raster","point"],"Contour type","Contours",a);this.defArray("contourLevels",[],"Numeric vector to set the contour levels. It is automatically calculated if not defined using the axisAlgorithm setting and the contourLevelNumber","Contours",a);this.defShow("ContourLevel",false,"levels in contours","Contours",a);this.defShow("ContourDataPoints",false,"data points in contours","Contours",a);this.defColor("contourDataPoints","rgb(0,0,0)","data points in contours when the contour is filled","Contours",a);this.defOption("contourColorScheme","Viridis",["Viridis","YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color scheme to use in contours","Contours",a);this.defBoolean("isHistogram",false,"Flag to track conversion of 2D scatter plot into histograms","Histograms",false);this.defFloat("histogramBarWidth",false,"Length in pixels for half of the bar width in the 2D sccater plot histogram","Histograms",false);this.defBoolean("histogramRight",true,"Histogram right is a boolean.  If true, the histogram cells are right-closed (left open) intervals","Histograms",a);this.defBoolean("histogramLowest",true,"Histogram lowest is a boolean. If true, an x[i] equal to the breaks value will be included in the first (or last, for right = FALSE) bar","Histograms",a);this.defInteger("histogramBins",30,"Approximate number of bins in a histogram. It may vary considerably to the actual number used in the histogram to ensure a pretty size for the intervals in the histogram. Default is the same as in ggplot which is 30","Histograms",a);this.defFloat("histogramBinWidth",false,"Width in actual units for the histogram bin","Histograms",a);this.defOption("histogramType","dodged",["dodged","staggered","stacked"],"Type of histogram when multiple series are present","Histograms",a);this.defShow("HistogramDensity",false,"density kernel in histograms","Histograms",a);this.defShow("HistogramPath",false,"histograms path","Histograms",a);this.defColor("histogramPath",false,"histogram path. If not specified the it defaults to the color of the histogram bars","Histograms",a);this.defInteger("histogramPathWidth",2,"Width for the line of the histogram path line","Histograms",a);this.defShow("FilledHistogramDensity",false,"filled histogram density","Histograms",a);this.defFloat("histogramDensityFillTransparency",0.6,"Transparency applied to the filled histogram density","Histograms",a);this.defShow("HistogramDataPoints",false,"original data point in histograms","Histograms",a);this.defShow("HistogramQuantiles",false,"quantile 0.25 and 0.75 in density plots","Histograms",a);this.defShow("HistogramMedian",false,"histogram median","Histograms",a);this.defOption("histogramMedianLineStyle","dashed",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line type for the histogram median","Histograms",a);this.defBoolean("hideHistogram",false,"Flag to hide the histogram bars","Histograms",a);this.defOption("histogramSizeEstimator","sturges",["sturges","freedmanDiaconis","scott"],"Histogram size estimator","Histograms",a);this.defOption("histogramStat","count",["density","count"],"Histogram density type","Histograms",a);this.defBoolean("histogramAsDotplot",false,"Flag to use dots as histogram bars","Histograms",a);this.defBoolean("histogramStackRatio",1,"Stack ratio for dotplot histograms. I has to be a value between 0 and 1","Histograms",a);this.defOption("histogramStackDir","down",["down","center","centerwhole"],"Direction to stack the dots in dotplot histograms","Histograms",a);this.defObject("isCreateHistogram",false,"Object to store histogram data","Histograms",false);this.defShow("ScatterDensity",false,"density kernel in histograms","Density Plots",a);this.defInteger("densityPixels",1000,"Number of pixels to stack on the density plots","Density Plots",a);this.defOption("densityKernel","gaussian",["gaussian","rectangular","triangular","epanechnikov","quartic","biweight","cosine","optcosine"],"Histogram density kernels","Density Plots",a);this.defOption("densityPosition","normal",["normal","stacked","filled"],"Histogram density position","Density Plots",a);this.defOption("bandwidthRule","nrd0",["nrd0","nrd","silverman"],"Bandwidth rule ","Density Plots",a);this.defInteger("bandwidthCut",3,"Bandwidth cut","Density Plots",a);this.defFloat("bandwidthAdjust",1,"Bandwidth adjust for the window","Density Plots",a);this.defFloat("ridgelineScale",1.5,"Scale for ridgeline","Ridgeline Plots",a);this.defOption("loessDegree",2,[0,1,2],"Loess degree. 0 : Constant, 1 : Linear, 2 : Quadratic","Loess",a);this.defInteger("loessSteps",30,"Loess steps. Number of steps to smooth the line","Loess",a);this.defFloat("loessBandwidth",0.8,"Loess bandwidth. Thickness for the confidence of the loess curve. A vaulue between 0 and 1","Loess",a);this.defFloat("loessCell",0.2,"Loess cell. If interpolation is used this controls the accuracy of the approximation via the maximum number of points in a cell in the kd tree. Cells with more than floor(n*span*cell) points are subdivided","Loess",a);this.defFloat("loessSpan",0.75,"Loess span. Factor to adjust the gaussian shape of the loess curve. A vaulue between 0 and 1","Loess",a);this.defInteger("loessIteration",4,"Loess iterations","Loess",false);this.defShow("LoessFit",false,"Flag to show the loess fit in Scatter2D plots","Loess",a);this.defBoolean("loessNormalize",true,"Flag to normalize loess fit in Scatter2D plots","Loess",a);this.defOption("loessFamily","gaussian",["gaussian","symmetric"],'Loess Family. Type of error distribution to be optimized in fitting. The default, "gaussian" is fitting with least squares. Fitting with Tukeys biweight M-Estimator is used if family = "symmetric"',"Loess",a);this.defOption("loessSurface","interpolate",["direct","interpolate"],'Loess Surface. The fitted surface to be computed exactly ("direct") or via interpolation from a kd tree',"Loess",a);this.defOption("loessStatistics","approximate",["approximate","exact"],"LoessStatistics. The statistics to be computed exactly, approximately or not at all? Exact computation can be very slow ","Loess",a);this.defArray("quantiles",["0.25","0.5","0.75"],"Array with quantiles to use in quantile regression plots","Quantile Regression Plots",a);this.defShow("QuantileRegressionFit",false,"Quantile Regression fit in Scatter2D plots","Quantile Regression Plots",a);this.defArray("binplotBins",[],"Approximate number of bins in a bin plot. It may vary considerably to the actual number used in the bin plot to ensure a pretty size for the intervals in the bin plot. ggplots default is 30","Bin Plots",a);this.defArray("binplotBinWidth",[],"Width in actual units for the histogram bin","Bin Plots",a);this.defBoolean("binplotDrop",true,"Flag to drop cells with zero counts in binplots","Bin Plots",a);this.defOption("binplotShape","hexagon",["rectangle","hexagon","oval"],"Type for the shape to use in binplots","Bin Plots",a);this.defOption("binplotColorScheme","Blues",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color scheme to use in binplots","Bin Plots",a);this.defInteger("maxDOENumber",8,"Maximum number of graphs when creating a DOE","DOE",a);this.defArray("includeDOE",[],"Array containing the factors to include when exploring the DOE. If left empty all the factors will be included","DOE",a);this.defBoolean("autoexpandDOE",true,"Flag to automatically expand verticaly the extent of the meta data-plots when changing the size of the graphs","DOE",a);this.defBoolean("extendedDOE",true,"Flag to extend DOE to include variables / samples","DOE",a);this.defObject("asDOE",false,'Object with configurations to create DOE. Example: [ {size: "2X2", graphType: "Bar"} ]',"DOE",a);this.defOption("scatterPlotMatrix",false,[true,false],"Could be a boolean to plot a matrix of 2D sccaterplots or a sample annotation to color and segregate the plots","Scatter Plot Matrix",a);this.defOption("scatterPlotMatrixType","both",["both","upper","lower","correlation","correlationHistogram","corelationDensity","all","first"],"Type for the matrix of 2D sccaterplots. Draw either in both panels, upper only or lower only. Show any combination of correlation, histogram, density and variability (boxplots). Also specify whether to use all versus all or only the first data set","Scatter Plot Matrix",a);this.defShow("ScatterPlotMatrixLabels",false,"labels in the scatter plot matrix","Scatter Plot Matrix",a);this.defFloat("xRotate",45,"Starting number of degrees to rotate graph arround the X axis","3D Attributes",a);this.defFloat("yRotate",0,"Starting number of degrees to rotate graph arround the Y axis","3D Attributes",a);this.defFloat("zRotate",0,"Starting number of degrees to rotate graph arround the Z axis","3D Attributes",a);this.defFloat("x3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the X Axis","3D Attributes",a);this.defFloat("y3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Y Axis","3D Attributes",a);this.defFloat("z3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Z Axis","3D Attributes",a);this.defShow("3DGrid",true,"X,Y,Z grid in 3D plots","3D Attributes",a);this.defInteger("rotationSensitivity",450,"Factor to adjust the sensitivity of the mouse when rotating the graph","3D Attributes",a);this.defInteger("rotationStep",2,"Number of degrees used when the plot is automatically rotated","3D Attributes",a);this.defFloat("perspectiveFactor",2.2,"Factor to use to make the 3D perspective. The higher the number the more perspective. Perspective of zero is no perspective at all","3D Attributes",a);this.defColor("outline3D","rgba(0,0,0,0)","outline of the 3D Scatters","3D Attributes",a);this.defInteger("varIndicesStart",-1,"Number that indicates starting point for variables in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.defInteger("smpIndicesStart",-1,"Number that indicates starting point for samples in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.defInteger("grpIndicesStart",-1,"Number that indicates starting point for grouped samples in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.defBoolean("isMultidimensionalData",false,"Flag to indicate if there is more than a single data set","Heatmap Graphs",false);this.defBoolean("heatmapAutoAdjust",false,"Flag to adjust the range of the heatmaps when zooming in/out","Heatmap Graphs",a);this.defBoolean("heatmapCellBox",true,"Flag to print a box around the heatmap cells","Heatmap Graphs",a);this.defColor("heatmapCellBox","rgb(102,102,102)","heatmap boxes around the cells","Heatmap Graphs",a);this.defFloat("heatmapCellBoxWidth",1,"Width for the heatmap boxes around the cells","Heatmap Graphs",a);this.defColor2("heatmapCellBoxColorHighlight","rgb(255,215,0)","highlighted heatmap cells","Heatmap Graphs",a);this.defFloat("heatmapCellBoxHighlightWidth",1,"Width for the highlighting heatmap boxes around the cells","Heatmap Graphs",a);this.defString("heatmapSmpSeparateBy",false,"Factor (in the x data object) used to separate the samples in the heatmap. The same factor must be included in the sample overlays","Heatmap Graphs",a);this.defString("heatmapVarSeparateBy",false,"Factor (in the z data object) used to separate the variables in the heatmap. The same factor must be included in the variable overlays","Heatmap Graphs",a);this.defFloat("heatmapSeparatorThickness",3,"Thickness of the separation of samples and variables in the heatmap","Heatmap Graphs",a);this.defOption("varTitleLabelPosition","bottom",["bottom","top"],"Position for variable labels","Heatmap Graphs",a);this.defOption("smpTitleLabelPosition","left",["left","right"],"Position for sample labels","Heatmap Graphs",a);this.defShow("HeatmapIndicator",true,"heatmap color indicator","Heatmap Graphs",a);this.defInteger("heatmapIndicatorHeight",25,"Length in pixels for the heatmap indicator","Heatmap Graphs",a);this.defInteger("heatmapIndicatorWidth",250,"Length in pixels for the heatmap indicator line width used for increase the size of the indicator","Heatmap Graphs",a);this.defBoolean("adjustAspectRatioHeatmapIndicator",true,"Flag to adjust aspect ratio of heatmap indicator. It depends on the adjustAspectRatio parameter; that is, the adjustAspectRatio parameter has to set to true for the adjustAspectRatioHeatmapIndicator to take effect","Heatmap Graphs",a);this.defOption("heatmapIndicatorPosition","right",["topLeft","top","topRight","right"],"Position for the heatmap indicator","Heatmap Graphs",a);this.defBoolean("heatmapIndicatorHistogram",false,"Flag to show histogram in the heatmap indicator","Heatmap Graphs",a);this.defColor("heatmapIndicatorHistogram","rgb(0,255,255)","heatmap indicator histogram","Heatmap Graphs",a);this.defOption("heatmapType","normal",["normal","circle","hexagon"],"Type of Heatmap used to overlay a layer on top of an image. Special for spatial transcriptomics","Heatmap Graphs",a);this.defBoolean("heatmapCollapse",false,"Flag to collapse cells in heatmaps of type circle or hexagon. If true cells are ploted without outline otherwise the outline is the foreground color","Heatmap Graphs",a);this.defBoolean("isOncoprint",false,"Boolean flag to draw an oncoprint","Oncoprint Graphs",false);this.defBoolean("oncoprintCNA",false,"String to identify the data object to use to draw the copy number alterations; that is the amplifications (which will be colored red) and deletions (which will be colored blue). It MUST be a file with only two categorical levels","Oncoprint Graphs",a);this.defBoolean("oncoprintMUT",false,"String to identify the data object to use to draw the mutations. For example missense, non-synonymous, truncating, etc. Each level will be colored in a shade of green","Oncoprint Graphs",a);this.defBoolean("oncoprintHeatmapSwitch",false,"Switch to Oncoprint or Heatmap visualization. Requieres data in the data object","Oncoprint Graphs",a);this.defBoolean("oncoprintNoAlterations",true,"Switch to show variables and samples without any alterations","Oncoprint Graphs",a);this.defBoolean("oncoprintColSummary",false,"Flag to show column summary in oncoprints","Oncoprint Graphs",a);this.defBoolean("oncoprintRowSummary",false,"Flag to show row summary in oncoprints","Oncoprint Graphs",a);this.defShow("HeatmapOncoprint",false,"heatmap along with the oncoprint","Oncoprint Graphs",a);this.defOption("oncoprintHeatmapPosition","bottom",["right","bottom","left","top"],"Position for the heatmap in the oncoprint","Oncoprint Graphs",a);this.defInteger("treemapBorderWidth",3,"Width for the treemap border","Treemap Graphs",a);this.defColor("treemapBorder","rgb(204,204,204)","treemap header and border","Treemap Graphs",a);this.defOption("correlationAxis","samples",["samples","variables"],"Axis used for the correlation","Correlation Graphs",a);this.defBoolean("correlationAnchorLegend",false,"Flag to show a region above the correlation plot that anchror a sample/variable to a position","Correlation Graphs",a);this.defInteger("correlationAnchorLegendAlignWidth",40,"Length in pixels of the height of the correlation anchor legend","Correlation Graphs",a);this.defInteger("correlationLabelInterval",1,"Interval for the sample or variable labels in the correlation plot","Correlation Graphs",a);this.defOption("correlationType","diamond",["diamond","circle"],"Shape to use in the correlation graphs","Correlation Graphs",a);this.defDendrogram("Var",true,false,"top",false,"variable dendrogram","Dendrograms",a);this.defDendrogram("Smp",true,false,"left",false,"sample dendrogram","Dendrograms",a);this.defInteger("dendrogramHeight",80,"Size in pixels for the dendrogram","Dendrograms",a);this.defColor("dendrogram","rgb(0,0,0)","dendrograms","Dendrograms",a);this.defOption("distance","euclidian",["euclidian","manhattan","max"],"Distance metric to use when clustering data","Clustering",a);this.defOption("linkage","complete",["single","complete","average"],"Linkage type to use when clustering data","Clustering",a);this.defOption("clusterAxis","samples",["samples","variables"],"Axis to use when clustering data","Clustering",a);this.defInteger("kmeansVarClusters",3,"Number of clusters when clustering variable data with kmeans","Clustering",a);this.defInteger("kmeansSmpClusters",3,"Number of clusters when clustering sample data with kmeans","Clustering",a);this.defInteger("maxIterations",500,"Number of maximum iterations when clustering data with kmeans for one dimensional graphs or maximum number of iterations when calculating force direct layout networks","Clustering",a);this.defOption("imputeMethod","mean",["mean","median"],"Imputation method for missing data when clustering","Clustering",a);this.defBoolean("samplesClustered",false,"Configuration property to cluster samples","Clustering",a);this.defBoolean("variablesClustered",false,"Configuration property to cluster variables","Clustering",a);this.defBoolean("samplesKmeaned",false,"Configuration property to k-mean samples","Clustering",a);this.defBoolean("variablesKmeaned",false,"Configuration property to k-mean variables","Clustering",a);this.defBoolean("vennLegendColors",false,"Flag to use the venn colors to use for the legends instead of the letters","Venn Diagrams",a);this.defInteger("vennGroups",4,"Number of groups in the Venn diagram","Venn Diagrams",a);this.defArray("vennCompartments",["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"],"Name for the compartments in the the Venn diagrams","Venn Diagrams",false);this.defArray("vennColors",[],"Colors for the Venn bubles. If not specified the colors will be chosen from the colors array. Colors in this array need to be at least the same number of groups in the Venn diagram","Venn Diagrams",a);this.defOption("pieType","separated",["separated","solid"],"Position for the pices of the pie","Pie Charts",a);this.defInteger("pieSegmentPrecision",0,"Number of decimals for values in the Pie charts","Pie Charts",a);this.defInteger("pieSegmentSeparation",1,"Length in pixels for the separation of the pieces of the pie charts","Pie Charts",a);this.defOption("pieSegmentLabels","inside",["inside","outside"],"Location for the values in the pie charts","Pie Charts",a);this.defOption("pieLabelType","percentage",["percentage","value"],"Pie label type to show the percentage of the slice or the actual number","Pie Charts",a);this.defFloat("maxPieSectors",20,"Max pie sectors. After that number the sectors will be put in a sector named other","Pie Charts",a);this.defShow("PieValues",true,"values for the pie","Pie Charts",a);this.defShow("PieSampleLabel",true,"sample label when plotting multiple pies","Pie Charts",a);this.defFloat("startPieSectors",270,"Starting degrees for pie sectors. 0 is equivalent to 3:00 oclock","Pie Charts",a);this.defFloat("pieInnerRadius",0,"Percentage of the radius in the pies to remove to make a donut. It must be a number between 0 to 1","Pie Charts",a);this.defArray("pieColors",[],"Pie Colors. Defaults to the parameter colors","Pie Charts",a);this.defOption("circularType","normal",["normal","radar","sunburst","chord","bubble"],"Property to set the subtype of circular graph. If set to sunburst or bubble then smpOverlays can be used to build a hierarchy for the graph","Circular Graphs",a);this.defInteger("chordThickness",28,"Relative length in pixels of the chord thickness in the circular graphs. Only applicable to the chord subtype","Circular Graphs",a);this.defOption("chordColor","source",["source","target"],"Color the ribbon according to either the source or the target of the connection","Circular Graphs",a);this.defColor("bubble","rgba(204,204,204,0.33)","Venn bubbles. Only applicable to the bubble subtype","Circular Graphs",a);this.defFloat("circularCenterProportion",0.3,"Proportion of the center of the circular graph to use as void; that is the fraction of the radius in the middle of the graph","Circular Graphs",a);this.defInteger("arcSegmentsSeparation",8,"Number of degrees to separate the arc segments in the circular plots. The arc segments can be set with the segregateSampleBy property","Circular Graphs",a);this.defInteger("circularRotate",0,"Number of degrees to rotate the circular graph to adjust the starting point","Circular Graphs",a);this.defInteger("circularArc",360,"Number of degrees to extend the circular graph","Circular Graphs",a);this.defInteger("ringSeparation",5,"Number of pixels to separate the rings in the circular plots","Circular Graphs",a);this.defArray("ringGraphType",[],"Array containing the graph type for each ring in the circular plot","Circular Graphs",a);this.defArray("ringGraphWeight",[],"Array containing the proportion of the dimensions for each data ring in the circular plot. It must be a value between 0.1 and 1. If not specified then all ring will be weighted the same","Circular Graphs",a);this.defArray("arcSegmentsRadius",[],"Array containing the proportion of the radius for each arc segment in the circular plot. If not specified then all radius will be the same. The plot will be scaled based of the largest value in the array","Circular Graphs",a);this.defArray("ringsOrder",[],"Array containing the order of the rings. The array includes the levels of the factor specified as either segregateSamplesBy when show the ideogram or segregateVariablesBy when there is no ideogram. It may also include any of the following terms: dendrogram, ideogram, labels, scale, percent and data. If there are sample overlays, the array may also contain any of the factor names include in the this.data.x object. This array supersede any other configurations for example for the sample overlays. CanvasXpress will honored all other configurations if left empty","Circular Graphs",a);this.defString("rAxis",false,"Radial axis for circular plots. It must be the name of a variable. Only applicable to 2 Dimensional circular plots","Circular Graphs",a);this.defBoolean("rAxisZero",false,"Flag to force the rAxis property to start from zero otherwise it starts from the minimum value","Circular Graphs",a);this.defShow("CircularConnections",true,"connections in circular graphs","Circular Graphs",a);this.defArray("connections",[],"Array to store connections in circular graphs","Circular Graphs",a);this.defFloat("circularLetterSeparationFactor",1.5,"Factor to adjust the spacing between letters in the circular graphs. The greater the number the closer the letters in the labels","Circular Graphs",a);this.defFloat("circularConnectionsTransparency",0.5,"Percentage of transparency applied to the connections in the circular graphs","Circular Graphs",a);this.defOption("overlayLevelOrientation","circular",["perpendicular","circular"],"Orientation to show the segregation levels","Circular Graphs",a);this.defOption("smpLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the sample names","Circular Graphs",a);this.defOption("circularLabelsAlign","outside",["inside","outside"],"Position to align the variable and sample names in circular plot","Circular Graphs",a);this.defOption("circularScalesAlign","inside",["inside","outside"],"Position to align the percent and radial axes in circular plot","Circular Graphs",a);this.defOption("circularAnchorsAlign","inside",["inside","outside"],"Position to align the anchors in circular plot","Circular Graphs",a);this.defOption("circularAnchors2Align","outside",["inside","outside"],"Position to align the anchors2 in circular plot","Circular Graphs",a);this.defOption("circularDataPosition","distributed",["absolute","distributed"],"Position to align the data in 2D radial graphs and ideograms","Circular Graphs",a);this.defInteger("circularAnchorLength",15,"Length in pixels of the height of the circular anchor","Circular Graphs",a);this.defColor("circularAnchor","rgb(0,0,255)","circular anchor","Circular Graphs",a);this.defShow("Ideogram",false,"Human Chromosome Ideogram. Force plot to be two dimensional","Circular Graphs",a);this.defOption("ideogram","hg38",["hg19","hg38"],'Ideogram. Additional ideograms can be loaded by appending to the CanvasXpress.chromosomes object. The format of the ideogram is based on the R data for USCS.hg19.chr<br> CanvasXpress.chromosomes = {<br> &nbsp;&nbsp;hg19 : {<br> &nbsp;&nbsp;&nbsp;&nbsp;order : [ 1, 2, 3, 4, 5, 6, 7, 8, ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;data : {<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1 : [ [ 0, 2300000, "p36.33", "gneg" ], ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2 : [ [ 0, 4300000, "p25.3", "gneg" ],  ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;}<br> &nbsp;&nbsp;}<br> }',"Circular Graphs",a);this.defString("ideogramChromosome","chr","Factor name included in the data.z object used to map to the chromosome number","Circular Graphs",a);this.defString("ideogramChromosomePosition","pos","Factor name included in the data.z object used to map to the chromosome position","Circular Graphs",a);this.defInteger("tagCloudTextWeightFactor",1,"Factor weight for text in tag cloud visualizations","Tag Cloud",a);this.defInteger("tagCloudTextGridSize",8,"Size for the grid in text tag cloud visualizations","Tag Cloud",a);this.defFloat("tagCloudTextEllipticity",0.65,"Ellipticity for the for text in tag cloud visualizations","Tag Cloud",a);this.defFloat("tagCloudTextRotateRatio",0.1,"Ratio for rotation of text in cloud visualizations","Tag Cloud",a);this.defOption("tagCloudShape",false,[false,"circle","cardioid","diamond","square","triangle","triangle2","pentagon","star"],"Shape for the tag cloud","Tag Cloud",a);this.defBoolean("tagCloudMask",false,"Add a shadow for the selected shape","Tag Cloud",a);this.defArray("tagCloudGridPoints",[],"Array to keep state of the used space in the tag cloud visualization","Tag Cloud",false);this.defBoolean("calculateLayout",true,"Flag to force or not to calculate the network layout","Network Graphs",a);this.defBoolean("networkFreeze",false,"Flag to prevent autoscaling for the network layout. Useful when images are part of the network","Network Graphs",a);this.defInteger("networkMaxIterations",15,"Number of iterations to separate subnetworks","Network Graphs",a);this.defBoolean("networkFreezeOnLoad",false,"Flag to prevent autoscaling for the network layout after loading. Useful when images are part of the network","Network Graphs",a);this.defBoolean("preScaleNetwork",false,"Flag to prescale or not the network. This is an aesthetic parameter to make the graph look nicer... Sometimes..","Network Graphs",a);this.defBoolean("ignoreEventlessOrder",false,"Flag to render all nodes at one time rather that rendering first the eventless nodes and then the non-eventless nodes","Network Graphs",a);this.defArray2("subNetworks",false,"Array to keep independent networks","Network Graphs",false);this.defOption("networkLayoutType","forceDirected",["forceDirected","circular","radial"],"Type of network layout","Network Graphs",a);this.defString("networkRoot",false,"Node Id of the network root","Network Graphs",a);this.defBoolean("isNetworkMetrics",false,"Flag to calculate all network metrics: betweenness, closeness, eccentricity and degree","Network Graphs",a);this.defShow("NetworkRadialLayout",false,"radial layout wire","Network Graphs",a);this.defBoolean("is3DNetwork",false,"Flag to create or not a 3D network","Network Graphs",a);this.defBoolean("networkNodesOnTop",true,"Order to use when drawing the nodes and edges in the networks. Useful for very populated netwrok graphs. When is set to true all the edges will be in the background","Network Graphs",a);this.defBoolean("moveParentsWithChildren",false,"Flag to make parents move when a child is moved","Network Graphs",a);this.defArray("highlightNode",[],"Name of nodes in the data.nodes object to highlight","Network Graphs",a);this.defColor("nodeHighlight","rgb(255,0,0)","highlighted nodes","Network Graphs",a);this.defInteger("showNodeNameThreshold",50,"Thereshold used to set the limit to hide or display the name of nodes in a network. If the number of nodes exceed this thereshold then the name will not be shown","Network Graphs",a);this.defInteger("showNodeNameSizeThreshold",20,"Thereshold used to set the limit to hide or display the name of nodes in a network based on the size of the node. If the number of node size exceed this thereshold then the name will be shown","Network Graphs",a);this.defInteger("nodeSize",15,"Approximate pixels for the size of the nodes in the network. Automatically adjusted depending on the numebr of nodes in the network","Network Graphs",false);this.defInteger("edgeThickness",1,"Default thickness for the edges in the networks","Network Graphs",false);this.defOption("labelNodePosition","auto",["auto","center","top","right","bottom","left"],"Default position for the node label","Network Graphs",a);this.defText("node","",false,15,1,"center",0,8,"node","Network Graphs",a);this.defString("networkVendor",false,"Network vendor","Network Graphs",a);this.defOption("attractiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating attractive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log","Network Algorithm Parameters",a);this.defOption("repulsiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating repulsive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log","Network Algorithm Parameters",a);this.defBoolean("useBarnesHutSimulation",false,"Flag to use Barnes–Hut simulation","Network Algorithm Parameters",a);this.defBoolean("networkDisjoint",true,"Flag to use positioning forces rather than centering forces. Applicable only to force directed layouts that contain multiple subnetworks","Network Algorithm Parameters",a);this.defFloat("networkSpeed",0.1,"Network Speed","Network Algorithm Parameters",a);this.defFloat("networkGravity",0.75,"Network Gravity","Network Algorithm Parameters",a);this.defInteger("networkSpringLength",35,"Ideal length for links (springs in physical model)","Network Algorithm Parameters",a);this.defFloat("networkSpringCoeff",0.0008,"Hooks law coefficient. 1 - solid spring","Network Algorithm Parameters",a);this.defFloat("networkRepulsion",-1,"Coulombs law coefficient. Its used to repel nodes thus should be negative if you make it positive nodes start attract each other","Network Algorithm Parameters",a);this.defFloat("networkTheta",0.8,"Theta coefficient from Barnes Hut simulation. Ranged between (0, 1). The closer its to 1 the more nodes algorithm will have to go through. Setting it to one makes Barnes Hut simulation no different from brute-force forces calculation (each node is considered)","Network Algorithm Parameters",a);this.defFloat("networkDragCoeff",0.09,"Drag force coefficient. Used to slow down system, thus should be less than 1. The closer it is to 0 the less tight system will be","Network Algorithm Parameters",a);this.defInteger("networkTimeStep",20,"Default time step (dt) for forces integration","Network Algorithm Parameters",a);this.defArray("barnesHutUpdateQueue",[],"Barnes Hut Queue for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.defArray("barnesHutNodesCache",[],"Barnes Hut node cache for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.defInteger("barnesHutNodesCacheCurrent",0,"Barnes Hut idex for node cache for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.defString("colorNodeBy",false,"Name of the attribute to color the nodes","Network Node and Edge Attributes",a);this.defString("shapeNodeBy",false,"Name of the attribute to shape the nods","Network Node and Edge Attributes",a);this.defString("sizeNodeBy",false,"Name of the attribute to size the nodes","Network Node and Edge Attributes",a);this.defString("patternNodeBy",false,"Name of the attribute to pattern the nodes","Network Node and Edge Attributes",a);this.defString("colorEdgeBy",false,"Name of the attribute to color the edges","Network Node and Edge Attributes",a);this.defString("sizeEdgeBy",false,"Name of the attribute to size the edges","Network Node and Edge Attributes",a);this.defShow("NetworkCommunities",false,"network communities","Network Communities",a);this.defBoolean("calculateNetworkCommunities",true,"Flag to calculate the network communities using the jLouvain algorithm. If this flag is false the property community and communityColor for each node will need to be provided, otherwise all nodes will belong to a single community","Network Communities",a);this.defBoolean("coordinateNetworkConvexHullCommunityColor",false,"Flag to coordinate colors of the nodes with convex hull for the network communities","Network Communities",a);this.defFloat("hullScale",1.25,"Scaling factor for extension of the hulls in the network communities","Network Communities",a);this.defInteger("networkCommunities",null,"Number of network communities","Network Communities",false);this.defArray("networkConvexHulls",[],"Array for the Network community convex hull property object","Network Communities",false);this.defInteger("genomeTicks",50,"Number of ticks in the genome browser","Genome Browser",a);this.defText("trackName","","rgb(0,0,0)",10,1,"center",0,8,"track name","Genome Browser",a);this.defColor("trackFill","rgb(255,255,255)","fill of the tracks in the genome browser","Genome Browser",a);this.defColor("trackDir","rgb(0,0,0)","strand direction of the tracks in the genome browser","Genome Browser",a);this.defInteger("subtracksMaxDefault",8,"Maximum number of subtracks to show in a track","Genome Browser",a);this.defInteger("showFeatureNameThereshold",20,"Threshehold used to set te limit when there are too many features in the genome browser","Genome Browser",a);this.defText("featureName","","rgb(0,0,0)",12,1,"center",0,8,"feature name","Genome Browser",a);this.defColor("featureFill","rgb(255,255,255)","fill of the feature in the genome browser","Genome Browser",a);this.defColor("featureDir","rgb(0,0,0)","strand direction of the feature in the genome browser","Genome Browser",a);this.defInteger("maxFeatureStringLen",30,"Maximum length in characters a feature label can have so anything above is truncated","Genome Browser",a);this.defInteger("featureWidthDefault",3,"Default size in pixels of the feature width","Genome Browser",a);this.defInteger("featureHeightDefault",14,"Default size in pixels of the feature height","Genome Browser",a);this.defOption("featureSpliceStyle","rect",["rect","broken"],"Default style for splicing in boxes","Genome Browser",a);this.defInteger("featureTraceHeight",40,"Default size in pixels of the trace height","Genome Browser",a);this.defInteger("featureTraceTrim",1,"Default triming for nucleotide values in the traces (expressed in percent)","Genome Browser",a);this.defBoolean("featureTracesShow",true,"Flag use to show traces","Genome Browser",a);this.defInteger("featureQualityHeight",14,"Default size in pixels of the quality height","Genome Browser",a);this.defBoolean("featureQualityValues",false,"Flag use to show values for the quality","Genome Browser",a);this.defBoolean("featureQualityShow",true,"Flag use to show quality","Genome Browser",a);this.defInteger("featureSignalToNoiseHeight",14,"Default size in pixels of the quality height","Genome Browser",a);this.defBoolean("featureSignalToNoiseValues",false,"Flag use to show values for the quality","Genome Browser",a);this.defBoolean("featureSignalToNoiseShow",true,"Flag use to show quality","Genome Browser",a);this.defInteger("featureCoordinateHeight",14,"Default size in pixels of the coordinates height","Genome Browser",a);this.defBoolean("featureCoordinateShow",true,"Flag use to show coordinates","Genome Browser",a);this.defInteger("featureTranslateHeight",14,"Default size in pixels of the translation height","Genome Browser",a);this.defBoolean("featureTranslateShow",true,"Flag use to show tranlation","Genome Browser",a);this.defOption("featureTypeDefault","line",["box","bar","heatmap","sequence","triangle","line"],"Default type for the feature in the genome browser","Genome Browser",a);this.defBoolean("featureStaggered",false,"Flag use to stagger the features in the genome panel","Genome Browser",a);this.defText("sequence","","rgb(0,0,0)",12,1,"center",0,8,"sequence","Genome Browser",a);this.defColor("sequenceFill",false,"background when showing sequnces in the box or sequence object in the Genome. The default is to use the background of the object. If specied a valid color then all the background of sequences will be uniform","Genome Browser",a);this.defColor("sequenceGAP","rgb(255,0,255)","deletions, insertions and gaps in the genome browser","Genome Browser",a);this.defColor("sequenceA","rgb(0,103,0)","adenines and alanines in the genome browser","Genome Browser",a);this.defColor("sequenceB","rgb(0,0,0)","degenerate C/G/T and asparagines in the genome browser","Genome Browser",a);this.defColor("sequenceC","rgb(0,0,255)","cytosines and cysteins in the genome browser","Genome Browser",a);this.defColor("sequenceD","rgb(0,0,0)","degenerate A/G/T and aspartic acids in the genome browser","Genome Browser",a);this.defColor("sequenceE","rgb(0,0,0)","glutamic acids in the genome browser","Genome Browser",a);this.defColor("sequenceF","rgb(0,0,255)","phenylalanines in the genome browser","Genome Browser",a);this.defColor("sequenceG","rgb(0,0,0)","guanines and glycines in the genome browser","Genome Browser",a);this.defColor("sequenceH","rgb(255,0,0)","degenerate A/C/T and histidines in the genome browser","Genome Browser",a);this.defColor("sequenceI","rgb(0,103,0)","isoleucines in the genome browser","Genome Browser",a);this.defColor("sequenceK","rgb(255,0,0)","degenerate G/T and lysines in the genome browser","Genome Browser",a);this.defColor("sequenceL","rgb(0,103,0)","leucines in the genome browser","Genome Browser",a);this.defColor("sequenceM","rgb(0,103,0)","degenerate A/G and methionines in the genome browser","Genome Browser",a);this.defColor("sequenceN","rgb(0,0,0)","degenerate A/C/G/T and asparagines in the genome browser","Genome Browser",a);this.defColor("sequenceP","rgb(255,165,0)","prolines in the genome browser","Genome Browser",a);this.defColor("sequenceQ","rgb(0,0,0)","glutamines in the genome browser","Genome Browser",a);this.defColor("sequenceR","rgb(255,0,0)","degenerate A/G and arginines in the genome browser","Genome Browser",a);this.defColor("sequenceS","rgb(255,165,0)","degenerate G/C and serines in the genome browser","Genome Browser",a);this.defColor("sequenceT","rgb(255,0,0)","thymidines and threonines in the genome browser","Genome Browser",a);this.defColor("sequenceU","rgb(255,0,0)","uracils in the genome browser","Genome Browser",a);this.defColor("sequenceV","rgb(0,103,0)","degenerate A/C/G and valines in the genome browser","Genome Browser",a);this.defColor("sequenceW","rgb(0,0,255)","degenerate A/T and tryptophans in the genome browser","Genome Browser",a);this.defColor("sequenceX","rgb(0,0,0)","any aminoacid code in the genome browser","Genome Browser",a);this.defColor("sequenceY","rgb(0,0,255)","degenerate C/T and tyrosines in the genome browser","Genome Browser",a);this.defColor("sequenceZ","rgb(0,0,0)","glutamines in the genome browser","Genome Browser",a);this.defColor("sequenceStart","rgb(0,204,0)","start codon in the genome browser","Genome Browser",a);this.defColor("sequenceEnd","rgb(255,0,0)","end codon in the genome browser","Genome Browser",a);this.defColor("wire","rgba(204,204,204,0.1)","ticks in the genome browser","Genome Browser",a);this.defInteger("periodTicksLabels",5,"Number of ticks to skip between values in the genome browser","Genome Browser",a);this.defOption("genomeResolution","low",["low","medium","high"],"Number to adjust the splines curvature","Genome Browser",a);this.defArray("trackConfigurableProperties",["name","hideName","hideFeatureNames","type","height","fill","outline","data","hide","connect","subtracksMax","highlight"],"Track configurable properties<br> @tracks {name:[string];Track name;[]}","Genome Browser",a);this.defArray("featureConfigurableProperties",["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"],"Feature configurable properties<br> @features {id:[string];Feature id;[],fill:[color];Color for the feature;[]}","Genome Browser",a);this.defArray("errors",[],"Array containing benign errors produced when rendering canvasXpress","Debug",false);this.defBoolean("debug",false,"Flag to turn on alerts","Debug",a);this.defBoolean("verbose",false,"Flag to turn on/off verbose","Debug",a);this.defBoolean("offline",false,"Flag to work offline","Debug",a);this.defShow("Version",true,"version when mouse over top-left corner of the canvas","Debug",a);this.defShow("Code",false,"code for the canvas","Debug",a);this.defOption("codeType","params",["pretty","compact","tab","params"],"Output type for the JSON code","Debug",a);this.defBoolean("disableEvents",false,"Flag to disable all events","Events",a);this.defBoolean("disableCode",false,"Flag to disable showing the code","Events",a);this.defBoolean("disableMenu",false,"Flag to disable showing the menu on right clicks","Events",a);this.defBoolean("disableToolbar",false,"Flag to disable showing the toolbar","Events",a);this.defBoolean("disableDataTable",false,"Flag to disable showing data table","Events",a);this.defBoolean("disableDataFilters",false,"Flag to disable showing data filters","Events",a);this.defBoolean("disableCustomizer",false,"Flag to disable the data explorer","Events",a);this.defBoolean("disableTabPanel",false,"Flag to disable the tab panels","Events",a);this.defBoolean("disableCanvas",false,"Flag to disable all canvas events","Events",a);this.defBoolean("disableKeys",false,"Flag to disable key binding events. This prevent some default browser shortcuts and it is system specific. Please see the Event section bellow","Events",a);this.defBoolean("disableShowShortcuts",true,"Flag to disable showing shortcuts","Events",a);this.defBoolean("disablePlusMinusKeys",true,"Flag to disable plus / minus key binding events","Events",a);this.defBoolean("disableUndoRedoKeys",true,"Flag to disable undo / redo key binding events","Events",a);this.defBoolean("disableDocument",false,"Flag to disable mousemove and mouseup in the document","Events",a);this.defBoolean("disableWindow",false,"Flag to disable resizing the canvas when the window is resized. ","Events",a);this.defBoolean("disableWheel",false,"Flag to disable wheel. ","Events",a);this.defBoolean("disableBeacon",false,"Flag to disable beacon. ","Events",a);this.defBoolean("playable",false,"Flag to make the plot playable if there are after rendering functions","Events",a);this.defBoolean("resizable",true,"Flag to disable resizing the canvas by dragging the mouse over the edges","Events",a);this.defBoolean("resizableX",true,"Flag to disable resizing the width of the canvas by dragging the mouse over the edges","Events",a);this.defBoolean("resizableY",true,"Flag to disable resizing the height of canvas by dragging the mouse over the edges","Events",a);this.defBoolean("movable",true,"Flag to disable moving the canvas by dragging the mouse from the move image in the toolbar","Events",a);this.defInteger("maxSubMenus",25,"Maximum number of submenus in the context menus","Events",a);this.defShow("PrimaryMenus",false,"primary menus in toolbar","Events",a);this.defInteger("maxItemMenuCheckbox",10,"Maximum number of items in a menu before it becomes a scroll box","Events",a);this.defBoolean("resizeWidthOnLayout",true,"Flag to enable resizing the width of the canvas after changing the layout","Events",a);this.defBoolean("resizeHeightOnLayout",true,"Flag to enable resizing the height of the canvas after changing the layout","Events",a);this.defBoolean("skipClick",false,"Flag to skip click events after a mouse down event in visualizations where there is a drag capabilities","Events",false);this.defInteger("infoTimeOut",3000,"Time in milliseconds to wait between updates for the mouse over info to show up","Events",a);this.defInteger("infoStartTime",new Date().getTime(),"Time in milliseconds to keep track of time","Events",false);this.defInteger("infoTimeIn",50,"Time in milliseconds to start showing info after a mouse over","Events",a);this.defBoolean("broadcast",true,"Flag to enable broadcasting to other canvasXpress objects in the page","Events",a);this.defString("broadcastGroup",false,"Group Id for canvas to broadcast to. If not specified then it broadcasts to all canvases","Events",a);this.defShow("MousePositionOnDrag",true,"mouse position when dragging in relation to the zero coordinate (top-right) of the canvas","Events",a);this.defOption("toolbarType","under",["over","under","fixed"],"Toolbar type","Events",a);this.defBoolean("lazyLoad",false,"Load canvas only if shown in viewport","Events",a);this.defShow("Animation",true,"animation for the graphs","Animations and Visualization Transitions",a);this.defShow("Transition",false,"transitions for the graphs","Animations and Visualization Transitions",a);this.defInteger("transitionStep",20,"Steps for transition","Animations and Visualization Transitions",a);this.defInteger("transitionStaggering",10,"Steps for transitionioning data objects","Animations and Visualization Transitions",a);this.defOption("transitionFunction","easeInOutQuad",["linear","easeInQuad","easeOutQuad","easeInOutQuad","easeInCubic","easeOutCubic","easeInOutCubic","easeInQuart","easeOutQuart","easeInOutQuart","easeInQuint","easeOutQuint","easeInOutQuint"],"Easing function for the transition","Animations and Visualization Transitions",a);this.defFloat("weight",1,"Fraction of the canvas to be used (a value between 0 and 1). Used when multiple graphs are displayed in one canvas. Could be an number or an array of numbers","Combination Plots",false);this.defFloat("scaleX",1,"Scale factor for the X axis","Combination Plots",false);this.defFloat("scaleY",1,"Scale factor for the Y axis","Combination Plots",false);this.defFloat("translateX",0,"Amount to translate for the X axis","Combination Plots",false);this.defFloat("translateY",0,"Amount to translate for the Y axis","Combination Plots",false);this.defFloat("offsetX",0,"Additional amount to move for the X axis","Combination Plots",false);this.defFloat("offsetY",0,"Additional amount to move for the Y axis","Combination Plots",false);this.defFloat("layoutWidth",0,"Width of the current segment of the canvas when there are multiple graphs","Combination Plots",false);this.defFloat("layoutHeight",0,"Height of the current segment of the canvas when there are multiple graphs","Combination Plots",false);this.defString("layout","1X1","Topology of the canvas. Number of rows and columns","Combination Plots",false);this.defString("layoutTopology",false,"Topology of the canvas. Number of columns and rows separated by X. For example: 2X1, 1X3, etc","Combination Plots",a);this.defBoolean("layoutComb",false,"Flag that identify that multiple graphs will be displayed in the canvas. This is the case when ata is segregated, splom, multiple pies or DOE visualizations","Combination Plots",false);this.defBoolean("layoutAdjust",false,"Flag to force recalculating the ranges in the axes when multiple graphs are displayed in the canvas","Combination Plots",a);this.defBoolean("layoutCollapse",false,"Flag to make layout graphs without any space in between","Combination Plots",a);this.defOption("layoutType","wrap",["wrap","rows","cols"],"Type of layout to place the position for the labels in the trellis plot. Identify the axis that will be used to place the first segregating factor. rows will use the first segregating factor in the rows and the second in the columns. cols will use the first segregating factor in the columns and the second in the rows. wrap will wrap the segregating factors putting the sample factors in the columns","Combination Plots",a);this.defBoolean("layoutRemoveEmpty",true,"Flag to remove empty combinations in segregated layouts","Combination Plots",a);this.defBoolean("layoutCanvasCompartments",false,"Flag to draw lines around each graph in the layout in the canvas. Used only when debugging","Combination Plots",a);this.defArray("layoutBoxLabelColors",[],'Layout box label background colors.<br> @ex {["gold","silver"],"data":"Random:4:8:2:2","segregateSamplesBy":["Factor1"];',"Combination Plots",a);this.defBoolean("layoutBoxShow",true,"Flag to draw the layout boxes","Combination Plots",a);this.defColor("layoutLabel","rgb(0,0,0)","label text in layout graphs","Combination Plots",a);this.defFloat("layoutLabelBoxThickness",30,"Thickness of the layout label boxes","Combination Plots",a);this.defBoolean("layoutLabelShow",true,"Flag to draw the layout label","Combination Plots",a);this.defArray("layoutConfig",[],"Array of object to assign visualization configurations to each layout","Combination Plots",a);this.defInteger("layoutCurrent",0,"Integer to identify the current graph being displayed in the canvas","Combination Plots",false);this.defOption("layoutAxis",3,[1,2,3],"Flag to indicated whether to print axes values when multiple graphs are displayed in the canvas. The possible values are: 1: horizontal, 2: vertical, 3: both","Combination Plots",a);this.defInteger("imageTimeOut",1000,"Time in milliseconds to wait to load images","Images",a);this.defInteger("imageMaxTries",10,"Maximum times to try to load images. Used to calculate the timeout which will be imageTimeOut / imageTries which will be 100ms by default","Images",a);this.defInteger("imageTries",0,"Image try counter","Images",false);this.defURL("remoteService",false,"Url used to obtain data remotely thorugh a web service or directly from a file. If the remote service is a file then it expects a json file with a two dimensional array. Each of the arrays should have a key (which will be used in a drop down menu) and a value to point to a url where to get the data. If the remote service is a web service it expects a canvasXpress object. You may specify additional parameters for the web service but you must specify the type of remote service in remoteServiceType. The default parameters for web services are index (to identify the current record number) and dir (to identify the direction; it could be either next or prev)","Remote Procedures",a);this.defString("remoteServiceType","webService","Type of web service to obtain data remotely","Remote Procedures",a);this.defObject("remoteParams",{},"Object to hold additional parameters used to obtain data remotely. The target property will be always added to the method as well as the direction [next|prev]","Remote Procedures",a);this.defOption("remoteDirection","next",["next","prev"],"Direction parameter used to obtain data remotely","Remote Procedures",a);this.defBoolean("remoteAutoPlay",false,"Flag to automatically iterate over remote data sets","Remote Procedures",a);this.defInteger("remoteAutoPlayDelay",3000,"Time in milliseconds to wait between iterations while automatically going over remote data sets","Remote Procedures",a);this.defBoolean("remoteParamOverride",true,"Flag to override parameters to maintain the state of the graphs when using remote services","Remote Procedures",a);this.defOption("remoteTransitionEffect","slide",["none","slide","fade"],"Effect for the remote transitions","Remote Procedures",a);this.defBoolean("remoteAutoSize",true,"Flag to adjust remote graph to current canvas size","Remote Procedures",a);this.defString("remoteParentId","","Id for the parent holding the remoteWindow to prevent id collisions","Remote Procedures",false);this.defInteger("remoteDataIndex",0,"Index of the canvasXpress object requested","Remote Procedures",false);this.defArray("remoteIds",[],"Array of the remoteIds passed after a service call","Remote Procedures",false);this.defArray("remoteData",[],"Array for the remote data pased after a service call","Remote Procedures",false);this.defBoolean("remoteUpdating",false,"Flag to indicate that updating data is in progress","Remote Procedures",false);this.defURL("RdatastesURL","https://raw.githubusercontent.com/neuhausi/Rdatasets/master/","URL for R objects","R",false);this.defBoolean("loadRDatasets",false,"Flag to load R datasets from Github","R",a);this.defInteger("maxDataCustomizerEntries",10000,"Maximum number of samples or variables to display in the data customizer","Data Customizer",a);this.defOption("customizerSize","medium",["small","medium","large"],"Size for the customizer. Requires re-opening of customizer","Data Customizer",a);this.defBoolean("customizerEntriesAsList",true,"Flag to show entries in scrolling widgets as text. The default is to show them as icons-like","Data Customizer",a);this.defBoolean("customizerGraphMaximize",false,"Flag to maximize the graph when the customizer is called","Data Customizer",a);this.defBoolean("skipConfigurableProperties",true,"Flag to indicate to exclude configurable parameters in the data table and the data filters in Networks and Genome Browser","Data Table/Filter",a);this.defArray("nodesProperties",[],"Two dimensional array with object properties not at the root level for the nodes in the Network graph to include in the Data table and the data filter","Data Table/Filter",a);this.defArray("edgesProperties",[],"Two dimensional array with object properties not at the root level for the edges in the Network graph to include in the Data table and the data filter","Data Table/Filter",a);this.defArray("featuresProperties",[],"Two dimensional array with object properties not at the root level for the features in the Genome graph to include in the Data table and the data filter","Data Table/Filter",a);this.defBoolean("layoutGraphMaximize",false,"Flag to maximize the graph when the layout app is called","Data Table/Filter",a);this.defInteger("dataFilterWidth",300,"Size in pixels for the data filters","Data Filters",a);this.defOption("filterType","and",["and","or"],"Type for the filter. Can be and or or","Data Filters",a);this.defOption("filterMode","remove",["remove","hide","color"],"Mode for the filter. Can be remove to remove the data from the plot, hide to hide the data similarily to legend filters (may be useful to adjustor transparencyHidden) or color to color the data point with a set color (may be useful to adjust missingDataColor)","Data Filters",a);this.defBoolean("filterSkipNullKeys",false,"Flag to indicate to bypass filtering when a key is non existent in the data objects","Data Filters",a);this.defBoolean("filterSkipNullValues",false,"Flag to indicate to bypass filtering when a value is null","Data Filters",a);this.defFilter("filterVarBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter variables by their annotation included in the data.z object used in one dimensional plots. Used in the CanvasXpress UIs","Data Filters",a);this.defFilter("filterSmpBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter samples by their annotation included in the data.x object used in one dimensional plots. Used in the CanvasXpress UIs","Data Filters",a);this.defFilter("filterNodeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter nodes by their properties used in network graphs. Used in the CanvasXpress UIs","Data Filters",a);this.defFilter("filterEdgeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter edges by their properties used in network graphs. Used in the CanvasXpress UIs","Data Filters",a);this.defFilter("filterFeatureBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter features by their properties used in genome browser. Used in the CanvasXpress UIs","Data Filters",a);this.defFilter("filterDataBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter data by their value in the data object used in oncoprints. Used in the CanvasXpress UIs","Data Filters",a);this.defArray("filtersExposed",[],"Exposed filters after rendering the plot. Each element in the array is an object as follows: {name: [var or smp annotation|vars|smps], position: [topRight|topLeft|bottomRight|bottomLeft], css: {property:value}}","Data Filters",a);this.defShow("DataTable",false,"data table","Data Table",a);this.defBoolean("dataTableTransposed",true,"Flag to transpose the data in the data table","Data Table",a);this.defInteger("maxRows",10,"Maximum number of rows to display in the data table","Data Table",a);this.defInteger("maxCols",6,"Maximum number of columns to display in the data table","Data Table",a);this.defInteger("colWidth",100,"Mumber of pixels for the width of cells in the data table","Data Table",a);this.defInteger("rowHeight",28,"Mumber of pixels for the height of cells in the data table","Data Table",a);this.defInteger("dataTableFontSize",16,"Data table font size","Data Table",a);this.defString("dataTableFontFamily","unset","Data table font family","Data Table",a);this.defBoolean("refresehDataTableOnDraw",false,"Flag to indicate to refresh data after drawing the plot","Data Table",a);this.defShow("DataTableOnSelect",false,"Flag to indicate to show data after selecting data in the plot","Data Table",a);this.defOption("networkShowDataTable","nodes",["nodes","edges"],"Show nodes or edges on data table","Data Table",a);this.defBoolean("colorDataTable",true,"Flag to color the data table","Data Table",a);this.defColor("backgroundDataTable","rgba(255,255,255,0.95)","data table background","Data Table",a);this.defFloat("colorDataTableTransparency",0.5,"Transparency for the background of the data table cells if colored","Data Table",a);this.defOption("dataTableStyle",false,[false,"stripped"],"Data table style","Data Table",a);this.defInteger("startCol",0,"Starting column in the data table","Data Table",false);this.defInteger("startRow",0,"Starting row in the data table","Data Table",false);this.defInteger("totalCols",null,"Total columns in the data table","Data Table",false);this.defInteger("totalRows",null,"Total rows in the data table","Data Table",false);this.defArray("dataTableColumnWidth",[],"Array to store the column width for the data table","Data Table",false);this.defArray("dataTableRowHeight",[],"Array to store the row height for the data table","Data Table",false)};this.updateTheme=function(a){for(var d in a){if(d=="conditional"){for(var e in a[d]){if(CanvasXpress.graphTypes[e].includes(this.graphType)){for(var b in a[d][e]){this[b]=a[d][e][b]}}}}else{if(d!="colorScheme"&&d!="colors"){this[d]=a[d]}else{if(d=="colorScheme"&&a[d]){this[d]=a[d]}}}}};this.setTheme=function(d){if(!d){d=CanvasXpress.stack[this.target]?CanvasXpress.stack[this.target].config:false}if(d&&d.hasOwnProperty("theme")&&d.theme){var a=d.theme.toLowerCase().replace(" ","");var b="none";switch(a){case"cx":case"canvasxpress":b="cx";break;case"paultol":b="paulTol";break;case"wallstreetjournal":case"wallstreet":b="wallStreetJournal";break;case"blackandwhite":b="blackAndWhite";break;case"lastairbenderfire":b="lastAirBender";this.colorScheme="LastAirBenderFire";break;case"lastairbenderair":b="lastAirBender";this.colorScheme="LastAirBenderAir";break;case"lastairbenderwater":b="lastAirBender";this.colorScheme="LastAirBenderWater";break;case"lastairbenderearth":b="lastAirBender";this.colorScheme="LastAirBenderEarth";break;case"gameofthronestargaryen":b="gameOfThrones";this.colorScheme="GameOfThronesTargaryen";break;case"gameofthronesstark":b="gameOfThrones";this.colorScheme="GameOfThronesStark";break;case"gameofthronesstannis":b="gameOfThrones";this.colorScheme="GameOfThronesStannis";break;case"gameofthroneslannister":b="gameOfThrones";this.colorScheme="GameOfThronesLannister";break;case"gameofthronestyrell":b="gameOfThrones";this.colorScheme="GameOfThronesTyrell";break;case"gameofthronesmartell":b="gameOfThrones";this.colorScheme="GameOfThronesMartell";break;case"gameofthronestully":b="gameOfThrones";this.colorScheme="GameOfThronesTully";break;case"gameofthronesgreyjoy":b="gameOfThrones";this.colorScheme="GameOfThronesGreyjoy";break;case"gameofthronesmanderly":b="gameOfThrones";this.colorScheme="GameOfThronesManderly";break;case"gameofthronesarryn":b="gameOfThrones";this.colorScheme="GameOfThronesArryn";break;default:b=a;break}if(CanvasXpress.themes.hasOwnProperty(b)){this.updateTheme(CanvasXpress.themes[b])}}};this.resetInitialFontSize=function(){var a=["fontSize","titleFontSize","subtitleFontSize","smpTitleFontSize","smpLabelFontSize","varTitleFontSize","varLabelFontSize","overlayFontSize","legendTextFontSize","legendTitleFontSize","decorationsTextFontSize","axisTickFontSize","axisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var b=0;b<a.length;b++){this[a[b]]=Number(CanvasXpress.doc.P[a[b]].D)}this.setInitialFonts()};this.setInitialFonts=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.legendTextFont=this.legendTextFontStyle+" "+this.legendTextFontSize+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+this.legendTitleFontSize+"px "+this.fontName;this.decorationsTextFont=this.decorationsTextFontStyle+" "+this.decorationsTextFontSize+"px "+this.fontName;this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.setInitialConfig=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var a in this.meta.config.user){if(this.isCreateHistogram){if(a=="setMaxX"||a=="setMinX"){continue}}if(this.isPivot){if(a=="groupingFactors"){continue}}if(CanvasXpress.doc.P[a]&&CanvasXpress.doc.P[a].hasOwnProperty("T")){if(CanvasXpress.doc.P[a].T=="integer"||CanvasXpress.doc.P[a].T=="float"){this.meta.config.user[a]=this.meta.config.user[a]===null?null:Number(this.meta.config.user[a])}this[a]=this.meta.config.user[a]}else{this[a]=this.meta.config.user[a]}}}};this.resetConfig=function(b){var d={};if(b){for(var c=0;c<b.length;c++){d[b[c]]=this[b[c]]}}this.setConfigDefaults();for(var c in d){this[c]=d[c]}};this.updateConfig=function(b){if(b){if(b.groupingFactors&&this.groupingFactors.length){if(!this.isSameObject(b.groupingFactors,this.groupingFactors)){this.ungroupSamples(true)}}this.meta.config.user=b;for(var a in b){this[a]=b[a]}}};this.setConfig=function(b){if(b){for(var a in b){this[a]=b[a]}}};this.getConfig=function(q){var l=this;var b={};var f=CanvasXpress.config.sort();var p=function(a){if(l.theme&&CanvasXpress.themes[l.theme]&&CanvasXpress.themes[l.theme].hasOwnProperty(a)){return CanvasXpress.themes[l.theme][a]}else{return CanvasXpress.doc.P[a].D}};var s={shapes:true,images:true,randomSeed:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,trackConfigurableProperties:true,featureConfigurableProperties:true,remoteServiceType:true};if(this.isTransformedData){b.isTransformedData=this.isTransformedData}for(var h=0;h<f.length;h++){var g=f[h];if(g.match(/FontSize$/)){continue}if(CanvasXpress.doc.P[g]&&CanvasXpress.doc.P[g].hasOwnProperty("D")){var m=p(g);if(s[g]){continue}var r=l[g]===undefined?false:l[g];if(typeof(r)=="object"){if(m=="[]"){m=[]}if(m=="{}"){m={}}if(r===null){if(m!="null"){b[g]=r}}else{if(g=="sizes"){if(!this.isSameObject(r,m.map(Number))){b[g]=r}}else{if(g=="colorSpectrum"||g=="colors"){var u=[];for(var n=0;n<r.length;n++){var e=this.validateColor(r[n],false,true);if(e){u.push(e.toLowerCase())}}if(!this.isSameObject(u,m)){b[g]=r}}else{if(g.match("filter")&&g!="filtersExposed"){if(!this.isSameObject(r,m)){b[g]=r}}else{if(!this.isSameObject(r,m)){b[g]=r}}}}}}else{if(m!=null&&m.toString().match(/false|true|null/)){if(g=="summaryType"&&r=="raw"){continue}else{if(r.toString()!=m.toString()){b[g]=r}}}else{if(r!=m){b[g]=r}}}}}if(b.backgroundImage&&b.backgroundImage.match(/javascript:\/\//)){if(CanvasXpress.cacheImages[b.backgroundImage.split("//")[1]]){b.backgroundImageSrc=btoa(CanvasXpress.cacheImages[b.backgroundImage.split("//")[1]].replace("data:image/png;base64,",""))}}if(q){for(var h=0;h<q.length;h++){b[q[h]]=this.configStndBy&&this.configStndBy[q[h]]?this.configStndBy[q[h]]:this[q[h]]}}return b};this.getUserConfig=function(){return this.meta.config.user};this.getNewCanvasContext=function(b){var a=this.$(b);if(!a||a.tagName.toLowerCase()!="canvas"){a=this.$cX("canvas",{id:b});window.body.appendChild(a)}return this.get2DCanvasContext(a)};this.setCanvasPixelRatio=function(){var b=window.devicePixelRatio||1;var a=this.get2DCanvasContext(this.$cX("canvas"));var c=a.webkitBackingStorePixelRatio||a.mozBackingStorePixelRatio||a.msBackingStorePixelRatio||a.oBackingStorePixelRatio||a.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=b/c};this.setDPI=function(b,c){b.style.width=b.style.width||b.width+"px";b.style.height=b.style.height||b.height+"px";var g=c/96;var a=parseFloat(b.style.width);var h=parseFloat(b.style.height);var d=b.width/a;var f=g/d;var e=b.cloneNode(false);this.get2DCanvasContext(e).drawImage(b,0,0);var i=this.get2DCanvasContext(b);b.width=Math.ceil(a*g);b.height=Math.ceil(h*g);i.setTransform(f,0,0,f,0,0);i.drawImage(e,0,0);i.setTransform(g,0,0,g,0,0)};this.setCanvas=function(){var a=this.$(this.target);if(a){this.setCanvasPixelRatio();this.checkCanvasXpressOrgSite();this.meta.canvas.ctx=this.get2DCanvasContext(a);this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.get2DCanvasContext=function(a){return a.getContext("2d")};this.getCanvasContext=function(){var a=this.isSVG?this.meta.canvas.SVG:this.isHighlightCanvas?this.meta.canvas.ctx2:this.meta.canvas.ctx;this.currentCanvasContext=a.canvas.id;return a};this.checkCanvasXpressOrgSite=function(){var f=new RegExp("/www.canvasxpress.org/dist/");var b=window.document.getElementsByTagName("head")[0];for(var a=0;a<b.childNodes.length;a++){var d=b.childNodes[a];if(d.type=="text/javascript"&&f.test(d.src)){CanvasXpress.factory.siteSrc=true}}};this.setCanvasXpressThemes=function(){if(!CanvasXpress.themes){CanvasXpress.themes={};var d=Object.keys(CanvasXpress.themeDef);var b=CanvasXpress.themeDef.names;for(var c=0;c<b.length;c++){var f=b[c];if(!CanvasXpress.themes[f]){CanvasXpress.themes[f]={}}for(var a=0;a<d.length;a++){var e=d[a];if(e=="names"){continue}CanvasXpress.themes[f][e]=CanvasXpress.themeDef[e][c]}}CanvasXpress.themes.CanvasXpress=CanvasXpress.themes.cx;CanvasXpress.themes.canvasXpress=CanvasXpress.themes.cx;CanvasXpress.themes.canvasxpress=CanvasXpress.themes.cx;CanvasXpress.themes.paultol=CanvasXpress.themes.paulTol;CanvasXpress.themes.PaulTol=CanvasXpress.themes.paulTol;CanvasXpress.themes.GGPlot=CanvasXpress.themes.ggplot}};this.setSystem=function(){CanvasXpress.system.isR=this.isR;CanvasXpress.system.isHTMLWidgets=typeof HTMLWidgets!="undefined";CanvasXpress.system.isShiny=typeof window.Shiny!=="undefined"&&!!window.Shiny.outputBindings;CanvasXpress.system.isRViewer=/\bviewer_pane=1\b/.test(window.location);CanvasXpress.system.isRConsole=CanvasXpress.system.isHTMLWidgets&&!CanvasXpress.system.isShiny&&!CanvasXpress.system.isRViewer;CanvasXpress.system.isNode=typeof exports==="object"&&typeof module!=="undefined";CanvasXpress.system.isCxplot=this.isCxplot;CanvasXpress.system.isjQuery=typeof $==="function";CanvasXpress.system.isReveal=typeof Reveal!="undefined";CanvasXpress.system.isZoom=typeof zoom!="undefined"};this.initializeConfig=function(a){CanvasXpress.config=[];this.setConfigDefaults();this.setCanvasXpressThemes();if(a&&a.graphType){this.graphType=a.graphType}if(!a||(a&&!a.graphOrientation)){if(this.meta.config.user){this.meta.config.user.graphOrientation=this.graphOrientation}}this.setTheme(a);if(a){if(!window.cX){CanvasXpress.factory.valid=a.cX;window.cX=CanvasXpress.factory.valid}for(var c in a){if(CanvasXpress.doc.P[c]&&CanvasXpress.doc.P[c].D==null&&a[c]===""){delete a[c]}}if(!a.graphType||a.graphType.match(/Scatter/)){this.dataTableTransposed=false}for(var c=0;c<CanvasXpress.config.length;c++){var e=CanvasXpress.config[c];var b=CanvasXpress.doc.P[e]?CanvasXpress.doc.P[e].T:false;if(a.hasOwnProperty(e)){if(b=="array"){if(a[e] instanceof Array){this[e]=a[e]}else{this[e]=[a[e]];a[e]=[a[e]]}}else{this[e]=a[e]}}}}this.setInitialFonts();for(var d in this.url){if(this.hasOwnProperty(d)){this[d]=this.url[d]}}this.setCanvas();this.setSystem();window.pcX={};if(CanvasXpress.system.isShiny){this.disableUndoRedoKeys=true}}};CanvasXpress.prototype.initDate=function(){var a=function(){var b=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,c=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,e=/[^-+\dA-Z]/g,d=function(g,f){g=String(g);f=f||2;while(g.length<f){g="0"+g}return g};return function(j,w,r){var h=a;if(arguments.length==1&&Object.prototype.toString.call(j)=="[object String]"&&!/\d/.test(j)){w=j;j=undefined}j=j?new Date(j):new Date;if(isNaN(j)){throw SyntaxError("invalid date")}w=String(h.masks[w]||w||h.masks["default"]);if(w.slice(0,4)=="UTC:"){w=w.slice(4);r=true}var u=r?"getUTC":"get",n=j[u+"Date"](),f=j[u+"Day"](),k=j[u+"Month"](),q=j[u+"FullYear"](),t=j[u+"Hours"](),l=j[u+"Minutes"](),v=j[u+"Seconds"](),p=j[u+"Milliseconds"](),g=r?0:j.getTimezoneOffset(),i={d:n,dd:d(n),ddd:h.i18n.dayNames[f],dddd:h.i18n.dayNames[f+7],m:k+1,mm:d(k+1),mmm:h.i18n.monthNames[k],mmmm:h.i18n.monthNames[k+12],yy:String(q).slice(2),yyyy:q,h:t%12||12,hh:d(t%12||12),H:t,HH:d(t),M:l,MM:d(l),s:v,ss:d(v),l:d(p,3),L:d(p>99?Math.round(p/10):p),t:t<12?"a":"p",tt:t<12?"am":"pm",T:t<12?"A":"P",TT:t<12?"AM":"PM",Z:r?"UTC":(String(j).match(c)||[""]).pop().replace(e,""),o:(g>0?"-":"+")+d(Math.floor(Math.abs(g)/60)*100+Math.abs(g)%60,4),S:["th","st","nd","rd"][n%10>3?0:(n%100-n%10!=10)*n%10]};return w.replace(b,function(m){return m in i?i[m]:m.slice(1,m.length-1)})}}();a.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'",year:"yyyy",month:"mmmm",day:"dddd",hour:"HH",minute:"MM",second:"ss"};a.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(b,c){return a(this,b,c)};this.isValidDateFormat=function(b){return !isNaN(new Date(b))};this.dateFormat=a};CanvasXpress.prototype.initText=function(){this.setTextShadow=function(a){if(this.showTextShadow){if(a){this.meta.canvas.ctx.shadowOffsetX=this.shadowOffsetX;this.meta.canvas.ctx.shadowOffsetY=this.shadowOffsetY;this.meta.canvas.ctx.shadowBlur=this.shadowBlur;this.meta.canvas.ctx.shadowColor=this.shadowColor}else{this.meta.canvas.ctx.shadowOffsetX=0;this.meta.canvas.ctx.shadowOffsetY=0;this.meta.canvas.ctx.shadowBlur=0;this.meta.canvas.ctx.shadowColor=this.background}}};this.getArcTextArea=function(C,A,z,a,D,u,p,v,j,w,d,g,B){if(C==undefined){C=""}var q=["poly"];var o=this.getFontPt(p);var j=this.measureText(C,p,B)*(Math.PI*0.5)/a;D=(D+(u/2))-(j/2)%(Math.PI*2);u=D+j;var n=this.traceArc1(A,z,a,D,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.traceArc1(A,z,a-o,D,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.adjustNetworkObjects(q)}else{return q}};this.drawArcText=function(B,z,w,a,C,p,o,q,j,v,g,h,A){if(B==undefined){B=""}if(!A){A=this.getCanvasContext()}if(B==null){return}if(!A){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(z)||isNaN(w)){if(this.debug){alert("Not a valid coordinate ("+z+", "+w+") to draw "+B)}return}if(!h&&!isNaN(B)){B=this.formatNumber(B)}B=B.toString().replace("\x00","");if(!z){z=0}if(!w){w=0}if(!o){o=this.font}if(!q){q=this.foreground}if(!j){j=this.align}if(!v){v=this.baseline}this.saveCanvas(A);A.strokeStyle=this.isArray(q)?q[0]:q;A.fillStyle=this.isArray(q)?q[0]:q;A.font=o;A.textAlign=j;A.textBaseline=v;this.setTextShadow(true);var d=j=="right"?1:-1;var u=this.getFontPt(o);if(((["left","center"].indexOf(j)>-1)&&g)||(j=="right"&&!g)){B=B.split("").reverse().join("");if(this.isArray(q)){q=q.reverse()}}A.translate(z,w);C+=(Math.PI*!g);C+=(Math.PI/2)+(p/2);if(j=="center"){for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o,A);C+=((n+(k==B.length-1?0:this.circularLetterSeparationFactor))/(a-u))/2*-d}}p=C;this.rotateCanvas(C,A);for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o,A);p+=(n/2)/(a-u)*d;this.rotateCanvas((n/2)/(a-u)*d,A);if(this.isArray(q)){A.strokeStyle=q[k];A.fillStyle=q[k]}A.fillText(B[k],0,(g?1:-1)*(0-a+u/2));p+=(n/2+this.circularLetterSeparationFactor)/(a-u)*d;this.rotateCanvas((n/2+this.circularLetterSeparationFactor)/(a-u)*d),A}this.restoreCanvas(A);this.setTextShadow(false)};this.getTextMultipleArea=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.getFontPt(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.getTextArea(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.drawTextMultiple=function(B,w,r,o,q,v,u,e,h,C,z,A){var j=B.split(/\n/);var d=o;if(!d){d=this.font}var n=this.getFontPt(d);var p=r+(j%2?0:n/2)-(j.length*n/2);for(var k=0;k<j.length;k++){this.drawText(j[k],w,p,d,q,v,u,e,h,C,z,A);p+=n;if(e&&e<90){w+=n;p-=n}}};this.getTextArea=function(p,n,l,C,D,F,E,g,r,q,k,u){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.rotatePoint(b[0],b[1],n,l,g));a=a.concat(j.rotatePoint(b[2],b[1],n,l,g));a=a.concat(j.rotatePoint(b[2],b[3],n,l,g));a=a.concat(j.rotatePoint(b[0],b[3],n,l,g));return a};if(p==undefined){p=""}if(k){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.isMultipleLines(p)){return this.getTextMultipleArea(p,n,l,C,D,F,E,g,r,q,k)}var G=[];var o=this.measureText(p,C,u);var z=this.getFontPt(C);var B,e,A,d;var i=0;if(r){while(o>r&&i<10){p=p.substring(0,p.length-1);o=this.measureText(p,C,u);i++}}if(F=="left"){B=n;A=B+o}else{if(F=="right"){B=n-o;A=n}else{B=n-(o/2);A=n+(o/2)}}if(E=="top"){e=l;d=e+z}else{if(E=="bottom"){e=l-z;d=l}else{e=l-(z/2);d=l+(z/2)}}G=["rect",B,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.adjustNetworkObjects(G)}else{return G}};this.drawText=function(r,n,j,h,i,l,k,d,e,u,p,q){if(r==undefined){r=""}if(!q){q=this.getCanvasContext()}var g=0;if(r==null){return}if(this.isMultipleLines(r)){return this.drawTextMultiple(r,n,j,h,i,l,k,d,e,u,p,q)}if(!q){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(n)||isNaN(j)){if(this.debug){alert("Not a valid coordinate ("+n+", "+j+") to draw "+r)}return}if(p){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(j<this.marginTop+this.offsetY+this.top||j>this.marginTop+this.offsetY+this.top+this.y){return}}if(!n){n=0}if(!j){j=0}if(!h){h=this.font}if(!i){i=this.foreground}if(!l){l=this.align}if(!k){k=this.baseline}var o=this.measureText(r,h,q);if(e){while(o>e&&g<10){r=r.substring(0,r.length-1);o=this.measureText(r,h,q);g++}}this.saveCanvas(q);q.strokeStyle=i;q.fillStyle=i;q.font=h;this.translateCanvas(n,j,q);q.textAlign=l;q.textBaseline=k;this.setTextShadow(true);if(d){this.rotateCanvas(d,q)}r=r.toString().replace("\x00","").replace("u0000","");if(u){q.strokeText(r,0,0)}else{q.fillText(r,0,0)}this.restoreCanvas(q);this.setTextShadow(false)};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.decapitalize=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.measureTextMultiple=function(e,g,c){var b=e.split(/\n/);var a=0;if(!c){c=this.getCanvasContext();if(!c){return 0}}if(!g){g=this.font}c.font=g;for(var d=0;d<b.length;d++){a=Math.max(a,c.measureText(b[d]).width)}return a};this.measureText=function(b,c,a){if(!a){a=this.getCanvasContext()}if(!b||!a){return 0}b=b.toString();if(!c){c=this.font}if(!CanvasXpress.cacheText[c]){CanvasXpress.cacheText[c]={}}if(!CanvasXpress.cacheText[c][b]){a.font=c;if(this.isMultipleLines(b)){CanvasXpress.cacheText[c][b]=this.measureTextMultiple(b,c,a)}else{CanvasXpress.cacheText[c][b]=a.measureText(b).width}}return CanvasXpress.cacheText[c][b]};this.measureTextWidth=function(b,c){var a=this.isMultipleLines(b);if(a>0){return(this.getFontPt(c)+this.margin)*(a+1)}else{return this.getFontPt(c)}};this.scaleTextToFont=function(c,i,b,d,a){var g=Math.ceil(i);if(this.fontStyle==false){this.fontStyle=""}var e=this.fontStyle+" "+g+"px "+this.fontName;if(c){while(this.measureText(c,e,a)>b&&g>=this.minTextSize){g-=2;e=this.fontStyle+" "+g+"px "+this.fontName}if(d){while(parseInt(g/1.33)>d-2){g--}e=this.fontStyle+" "+g+"px "+this.fontName}}return e};this.getFontPt=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.wrapText=function(c,b){var a=new RegExp("(?![^\\n]{1,"+b+"}$)([^\\n]{1,"+b+"})([\\s|-])","g");return c.toString().replace(a,"$1$2\n").replace(" \n","\n")};this.scaleFont=function(a,b){var d=this.getFontPt(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.formatNumber=function(f,e){var c=(!isNaN(e)&&parseInt(e!=null?e:10)>0)?parseFloat(f).toFixed(parseInt(e!=null?e:10)):Number(f);var b=parseFloat(c);if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){var a=b.toExponential(2).toString().replace("e+0","").replace(".00","").replace(/(\.[0-9])(0)/,"$1");if(a.match(/e\+1$/)||a.match(/e\+2$/)||a.match(/e\-1$/)){a=(a*1).toString()}return a}else{return b.toString()}};this.getMaxtTextBySampling=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.getMaxText(g)};this.getMaxText=function(e,j,d){var h="";var b=0;if(e&&e.length>0){if(!j){j=this.font}for(var g=0;g<e.length;g++){if(e[g]){var k=this.measureText(e[g].toString(),j,d);if(k>b){h=e[g].toString();b=k}}}}return h};this.shortenText=function(c,b,a){if(c==null){return""}c=c.toString();if(!c){return""}if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.stringToHex=function(c){var b="";for(var a=0;a<c.length;a++){b+=""+c.charCodeAt(a).toString(16)}return b};this.hexToString=function(b){var c="";for(var a=0;a<b.length;a+=2){c+=String.fromCharCode(parseInt(b.substr(a,2),16))}return c};this.sprintf=function(){var k=function(c,a){for(var f=[];a>0;f[--a]=c){}return(f.join(""))};var g=0,n,h=arguments[g++],d=[],e,b,j,l;while(h){if(e=/^[^\x25]+/.exec(h)){d.push(e[0])}else{if(e=/^\x25{2}/.exec(h)){d.push("%")}else{if(e=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gosuxX])/.exec(h)){if(((n=arguments[e[1]||g++])==null)||(n==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(e[7])&&(typeof(n)!="number")){throw ("Expecting number but found "+typeof(n))}switch(e[7]){case"b":n=n.toString(2);break;case"c":n=String.fromCharCode(n);break;case"d":n=parseInt(n);break;case"e":n=e[6]?n.toExponential(e[6]):n.toExponential();break;case"f":n=e[6]?parseFloat(n).toFixed(e[6]):parseFloat(n);break;case"g":n=e[6]?String(Number(n).toPrecision(e[6])):parseFloat(n);break;case"o":n=n.toString(8);break;case"s":n=((n=String(n))&&e[6]?n.substring(0,e[6]):n);break;case"u":n=Math.abs(n);break;case"x":n=n.toString(16);break;case"X":n=n.toString(16).toUpperCase();break}n=(/[def]/.test(e[7])&&e[2]&&n>0?"+"+n:n);j=e[3]?e[3]=="0"?"0":e[3].charAt(1):" ";l=e[5]-String(n).length;b=e[5]?k(j,l):"";d.push(e[4]?n+b:b+n)}else{throw ("Huh ?!")}}}h=h.substring(e[0].length)}return d.join("")}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};Date.prototype.addMilliseconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getMilliseconds()+a);return date};Date.prototype.addSeconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getSeconds()+a);return date};Date.prototype.addMinutes=function(a){let date=new Date(this.valueOf());date.setDate(date.getMinutes()+a);return date};Date.prototype.addHours=function(a){let date=new Date(this.valueOf());date.setDate(date.getHours()+a);return date};Date.prototype.addDays=function(a){let date=new Date(this.valueOf());date.setDate(date.getDate()+a);return date};Date.prototype.addMonths=function(a){let date=new Date(this.valueOf());date.setMonth(date.getMonth()+a);return date};Date.prototype.addYears=function(a){let date=new Date(this.valueOf());date.setYear(date.getFullYear()+a);return date};this.getMillisecond=function(a){return a.getMilliseconds()};this.getSecond=function(a){return a.getSeconds()};this.getMinuteSecond=function(a){return a.getMinutes()+"."+a.getSeconds()};this.getMinute=function(a){return a.getMinutes()};this.getHourMinute=function(a){return a.getHours()+"."+a.getMinutes()};this.getHour=function(a){return a.getHours()};this.getYearWeek=function(a){return a.getFullYear()+"."+a.getWeek()};this.getMonthDay=function(a){return(a.getMonth()+1)+"."+(a.getDay()+1)};this.getYearMonth=function(a){return a.getFullYear()+"."+(a.getMonth()+1)};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.formatDate=function(f,w){var A,j,q,b,p,i,k,g,u,o,d,v,c,x,y,r,t,n,l,z,a,e;f=new Date(f);j=((A=f.getFullYear())+"").slice(-2);p=(i=f.getMonth()+1)<10?("0"+i):i;b=(q=["January","February","March","April","May","June","July","August","September","October","November","December"][i-1]).substring(0,3);u=(o=f.getDate())<10?("0"+o):o;g=(k=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][f.getDay()]).substring(0,3);e=(o>=10&&o<=20)?"th":((a=o%10)==1)?"st":(a==2)?"nd":(a==3)?"rd":"th";w=w.replace("#YYYY#",A).replace("#YY#",j).replace("#MMMM#",q).replace("#MMM#",b).replace("#MM#",p).replace("#M#",i).replace("#DDDD#",k).replace("#DDD#",g).replace("#DD#",u).replace("#D#",o).replace("#th#",e);x=(v=f.getHours());if(x==0){x=24}if(x>12){x-=12}c=x<10?("0"+x):x;d=v<10?("0"+v):v;z=(l=v<12?"am":"pm").toUpperCase();y=(r=f.getMinutes())<10?("0"+r):r;t=(n=f.getSeconds())<10?("0"+n):n;return w.replace("#hhhh#",d).replace("#hhh#",v).replace("#hh#",c).replace("#h#",x).replace("#mm#",y).replace("#m#",r).replace("#ss#",t).replace("#s#",n).replace("#ampm#",l).replace("#AMPM#",z)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h.length){var k=Date.parse(h[0]);var a=Date.parse(h[h.length-1]);var g=a-k;var c;if(this.timeFormat=="year"||g>this.times.year*2){if(g/h.length>=this.times.year){c="addYears"}else{c="addDays"}}else{if(this.timeFormat=="month"||g>this.times.week){c="addDays"}else{if(g<this.times.second){c="addMilliseconds"}else{if(g<this.times.minute){c="addSeconds"}else{if(g<this.times.hour){c="addMinutes"}else{if(g<this.times.day){c="addHourss"}}}}}}this.timeValues=[this.dateFormat(new Date(k)[c](-1),this.timeFormat)];this.timeValueIndices=[-1];while(k<=a){var j=new Date(k);var e=this.dateFormat(j,this.timeFormat);var b=this.getSampleIndices(this.timeFormat.match(/year|hour|minute|second/)?Number(e):e);this.timeValues.push(e);this.timeValueIndices.push(b);j=j[c](1);k=Date.parse(j)}}else{return[]}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w.labs:this.data.y.smps;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.length;c++){e=Date.parse(h[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var j=this.isGroupedData?this.data.w.labs:this.data.y.smps;var b=false;var h=[];for(var c=0;c<j.length;c++){var a=j[c];var e=this.timeFormat;switch(this.timeFormat){case"Year":case"year":a+="/01/02";e="isoDate";break;case"Month":case"month":a="2018/"+CanvasXpress.dates[a]+"/02";e="isoDate";break;case"Day":case"day":a="2018/01/"+CanvasXpress.dates[a];e="isoDate";break}if(!this.isValidDateFormat(a)){this.isGraphTime=false;alert("Invalid Date! Graph converted from Time Graph");return[]}var g=Date.parse(this.dateFormat(a,e));if(isNaN(g)){if(this.isExample){h=this.createRandomTimes();return h}else{b=true;break}}else{h.push(new Date(g))}}h.sort(function(f,d){return f-d});return b?false:h}};CanvasXpress.prototype.initColor=function(){this.validateColor=function(j,e,g){var k=j;if(k){k=k.toString();k=k.replace(/\s/g,"");var b=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(k);var d=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(k);var i=(/^#?([0-9abcdef]{6})/i).exec(k);var a=(/^([0-9abcdef]{6})/i).exec(k);if(CanvasXpress.colorNames.hasOwnProperty(k)){k=this.hexToRgb(CanvasXpress.colorNames[k])}else{if(b!=null){k=b[0]}else{if(d!=null){k=d[0]}else{if(i!=null){k=this.hexToRgb(i[0])}else{if(a!=null){k=this.hexToRgb("#"+a[0])}else{if(k=="[objectCanvasGradient]"){return j}else{k=false}}}}}}}k=k&&e!=null?this.addColorTransparency(k,e,true):k?k:false;return k&&g?this.rgbToHex(k):k};this.desaturateColor=function(e,b){b=(b==0)?0:(b||10);var d=this.rgbToHsl(e,true);d[1]-=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.hslToRgb(e)};this.saturateColor=function(e,b){b=(b==0)?0:(b||10);var d=this.rgbToHsl(e,true);d[1]+=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.hslToRgb(e)};this.greyColor=function(a){return this.desaturateColor(a,100)};this.lightenColor=function(e,b){b=(b==0)?0:(b||10);var d=this.rgbToHsl(e,true);d[2]+=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.hslToRgb(e)};this.darkenColor=function(e,b){b=(b==0)?0:(b||10);var d=this.rgbToHsl(e,true);d[2]-=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.hslToRgb(e)};this.brightenColor=function(e,b){b=(b==0)?0:(b||10);var d=this.colorAsArray(e);d[0]=Math.max(0,Math.min(255,d[0]-Math.round(255*-(b/100))));d[1]=Math.max(0,Math.min(255,d[1]-Math.round(255*-(b/100))));d[2]=Math.max(0,Math.min(255,d[2]-Math.round(255*-(b/100))));return"rgb("+d[0]+","+d[1]+","+d[2]+")"};this.complementColor=function(b){var a=this.rgbToHsl(b,true);a[0]=(a[0]+180)%360;b="hsl("+Math.floor(a[0]*100)+","+Math.floor(a[1]*100)+"%,"+Math.floor(a[2]*100)+"%)";this.hslToRgb(b)};this.triadColors=function(e){var b=this.rgbToHsl(e,true);var d=(b[0]+120)%360;var a=(b[0]+240)%360;return[e,this.hslToRgb("hsl("+Math.floor(d*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(a*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)")]};this.tetradColors=function(f){var d=this.rgbToHsl(f,true);var e=(d[0]+90)%360;var b=(d[0]+180)%360;var a=(d[0]+270)%360;return[f,this.hslToRgb("hsl("+Math.floor(e*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(b*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(a*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)")]};this.pentadColors=function(g){var e=this.rgbToHsl(g,true);var f=(e[0]+72)%360;var d=(e[0]+144)%360;var b=(e[0]+216)%360;var a=(e[0]+288)%360;return[g,this.hslToRgb("hsl("+Math.floor(f*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(d*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(b*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(a*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)")]};this.hexadColors=function(h){var e=this.rgbToHsl(h,true);var f=(e[0]+60)%360;var d=(e[0]+120)%360;var b=(e[0]+180)%360;var a=(e[0]+240)%360;var g=(e[0]+300)%360;return[h,this.hslToRgb("hsl("+Math.floor(f*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(d*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(b*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(a*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(g*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)")]};this.spliComplementColors=function(e){var b=this.rgbToHsl(e,true);var d=(b[0]+72)%360;var a=(b[0]+216)%360;return[e,this.hslToRgb("hsl("+Math.floor(d*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)"),this.hslToRgb("hsl("+Math.floor(a*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)")]};this.fadeColors=function(m,e){var l=[];var o=this.colorAsArray(m);var a=Math.min(255,Math.max(0,o[0]));var k=Math.min(255,Math.max(0,o[0]));var p=Math.min(255,Math.max(0,o[0]));var h=this.seq(a,255,a/(e+1));var d=this.seq(k,255,k/(e+1));var q=this.seq(p,255,p/(e+1));for(var j=0;j<h.length;j++){l.unshift("rgb("+Math.floor(h[j])+","+Math.floor(d[j])+","+Math.floor(q[j])+")")}return l};this.darkenLightenColor=function(j,e){j=this.rgbToHex(this.validateColor(j)).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{if(b&&b.match(/^rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}}};this.rgbToHsl=function(n,c){var j=this.colorAsArray(n);var a=j[0]/255;var k=j[1]/255;var o=j[2]/255;var p=Math.max(a,k,o);var f=Math.min(a,k,o);var i,q;var e=(p+f)/2;if(p==f){i=0;q=0}else{var m=p-f;q=e>0.5?m/(2-p-f):m/(p+f);switch(p){case a:i=(k-o)/m+(k<o?6:0);break;case k:i=(o-a)/m+2;break;case o:i=(a-k)/m+4;break}i/=6}if(c){return[i,q,e]}else{return"hsl("+Math.floor(i*100)+","+Math.floor(q*100)+"%,"+Math.floor(e*100)+"%)"}};this.complementaryColor=function(j,e){var d=this.validateColor(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rgbToHex(d):d}else{return j}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.hslToRgb=function(n){var j=n.split(",");var i=Number(j[0].replace(/\s/g,"").replace("hsl(",""));var f=Number(j[0].replace(/\s/g,"").replace("%)",""));var o=Number(j[0].replace(/\s/g,"").replace("%",""));if(o==0){return"rgb("+f+","+f+","+f+")"}else{var e=function(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h};var c=f<0.5?f*(1+o):f+o-f*o;var d=2*f-c;var a=Math.round(e(d,c,i+1/3)*255);var k=Math.round(e(d,c,i)*255);var m=Math.round(e(d,c,i-1/3)*255);return"rgb("+a+","+k+","+m+")"}};this.addColorTransparency=function(e,d,b){if(e){if(e instanceof CanvasGradient){return e}var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){e=this.validateColor(e);a=e&&e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}return a?"rgba("+a[1]+","+Math.min(d,(a[2]!=null?a[2]:1))+")":false}else{return false}};this.removeColorTransparency=function(d,b){if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){d=this.validateColor(d);a=d&&d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}return a?"rgb("+a[1]+")":false}else{return false}};this.isColorTransparency=function(d,b){if(!b){d=this.validateColor(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?null:a[2]!=null?Number(a[2]):null}};this.isColorTransparent=function(e,b){if(!b){e=this.validateColor(e)}var d;if(e&&e.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?false:a[2]!=null&&a[2]==0?true:false}else{return false}}};this.combineColors=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.mean(e));var h=parseInt(this.mean(d));var m=parseInt(this.mean(n));if(k.length>0){var o=parseFloat(this.mean(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.colorAsArray=function(f){f=this.validateColor(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.monoColor=function(f,d){var b=this.colorAsArray(f);var e=Math.ceil(0.3*b[0]+0.59*b[1]+0.11*b[2]);if(d!=null){return"rgba("+e+","+e+","+e+","+d+")"}else{return"rgb("+e+","+e+","+e+")"}};this.blindColor=function(S,I){var q=this.colorAsArray(this.validateColor(S,I));var J=q[0];var Q=q[1];var T=q[2];var x=[0.7465,0.2535,1.273463,-0.073894];var A=[1.4,-0.04,0.968437,0.003331];var u=[1.748,0,0.062921,0.292119];if(J==0&&Q==0&&T==0){return"rgb(0,0,0)"}var l;switch(this.blindnessType){case"protanopia":l=x;break;case"deuteranopia":l=A;break;case"tritanopia":l=u;break;case"monochromatic":var S=Math.ceil((J*0.212656+J*0.715158+J*0.072186));return"rgb("+S+","+S+","+S+")"}var F=l[0];var D=l[1];var K=l[2];var z=l[3];var n=1;var y=Math.pow(J,2.2);var B=Math.pow(Q,2.2);var C=Math.pow(T,2.2);var i=y*0.412424+B*0.357579+C*0.180464;var h=y*0.212656+B*0.715158+C*0.072185;var f=y*0.019332+B*0.119193+C*0.950444;var k=i/(i+h+f);var j=h/(i+h+f);var w=(j-D)/(k-F);var L=j-k*w;var e=(z-L)/(w-K);var a=(w*e)+L;i=e*h/a;f=(1-(e+a))*h/a;var O=0.312713*h/0.329016;var M=0.358271*h/0.329016;var G=O-i;var E=M-f;var H=G*3.24071+E*-0.498571;var N=G*-0.969258+E*0.0415557;var R=G*0.0556352+E*1.05707;var d=i*3.24071+h*-1.53726+f*-0.498571;var o=i*-0.969258+h*1.87599+f*0.0415557;var s=i*0.0556352+h*-0.203996+f*1.05707;var U=((H<0?0:1)-d)/H;var m=((N<0?0:1)-o)/N;var p=((R<0?0:1)-s)/R;var P=[(U>1||U<0)?0:U,(m>1||m<0)?0:m,(p>1||m<0)?0:p];P=Math.max.apply(null,P);d=d+(P*H);o=o+(P*N);s=s+(P*R);d=Math.pow(d,1/2.2);o=Math.pow(o,1/2.2);s=Math.pow(s,1/2.2);J=Math.ceil(d);Q=Math.ceil(o);T=Math.ceil(s);if(J>255){J-=255}if(Q>255){Q-=255}if(T>255){T-=255}return"rgb("+J+","+Q+","+J+")"};this.disableGradientTransparencyShadow=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.enableGradientTransparencyShadow=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.resetGradientTransparencyShadow=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.getGradient=function(f,e,d,c,b,a){if(this.gradientType=="radial"){return this.getRadialGradient(f,e,d,b,a,true)}else{return this.getLinearGradient(f,e,d,c,b,a,true)}};this.getLinearGradient=function(d,o,a,m,j,l,k){if(!k){this.saveCanvas()}var p=this.getCanvasContext();var h=p.createLinearGradient(d,o,a,m);if(!j){j=this.colorSpectrum}else{if(this.validateColor(j)&&(!this.isArray(j)||j.length<2)){j=[j,"rgb(0,0,0)"]}}if(!l||!this.isArray(l)){l=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var q=1/(j.length-1);var e=q;for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}h.addColorStop(l[0]||0,this.transparency!=null?this.addColorTransparency(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(l[f]||e,this.transparency!=null?this.addColorTransparency(j[0]):j[f]);e+=q}return h};this.getRadialGradient=function(p,k,a,j,m,l){if(!l){this.saveCanvas()}var q=this.getCanvasContext();var d=a/5.5;var h=q.createRadialGradient(p-d,k-d,1,p,k,a);if(!j){j=this.colorSpectrum}else{if(this.validateColor(j)&&(!this.isArray(j)||j.length<2)){j=[j,"rgb(0,0,0)"]}}if(!m||!this.isArray(m)){m=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var t=1/(j.length-1);var e=t;h.addColorStop(m[0]||0,this.transparency!=null?this.addColorTransparency(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(m[f]||e,this.transparency!=null?this.addColorTransparency(j[0]):j[f]);e+=t}return h};this.colorRGBfromString=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.colorFromRgb(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.colorFromRgb(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.colorFromRgb=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.rgbFromHsv(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.rgbFromHsv=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.colorFromHsv=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.hsvFromRgb=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.colorRGBToString=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.getColorNames=function(){return this.sortObject(CanvasXpress.colorNames)};this.getColorSchemes=function(){return this.sortObject(CanvasXpress.colorSchemes)};this.getHexColor=function(b){var c=/^#?[0-9a-fA-F]{6}$/i;var a=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;if(c.test(b)){return b.substring(b.length-6,b.length)}else{if(a.test(b)){return this.rgbToHex(b)}else{var d=b.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(d)){return CanvasXpress.colorNames[d]}else{throw new Error(b+" is not a valid color.")}}}};this.getColorForValue=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.setColorForValues=function(a,d){var g=this;var c=function(l){var j=function(t,q){var n=a.grads[l];var s=n.min;var z=n.max;var p=n.scol.replace("#","").substring(t,q);var A=n.ecol.replace("#","").substring(t,q);var w=d<s?s:d>z?z:d;var i=z-s;var x=parseInt(p,16);var m=parseInt(A,16);var u=(m-x)/i;if(isNaN(u)){u=0}var o=Math.round(u*(w-s)+x);var y=o.toString(16);return y.length==1?"0"+y:y};var k=j(0,2);var h=j(2,4);var b=j(4,6);return g.hexToRgb("#"+k+h+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{for(var e=0;e<a.grads.length;e++){if(a.grads[e].min<=d&&a.grads[e].max>d){return c(e)}}var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return isNaN(e)?"rgba(0,0,0,0)":c(e)}};this.getColorBrew=function(L,C,F,g,f,c){var h=L||this.colorSpectrum;var B=this.graphType=="Genome";if(C!=null&&F!=null&&C==F){F+=0.1}var G=C!=null&&f&&f.length?Math.min(C,f[0]):C!=null?C:this.minData!=null?this.minData:0;var o=F!=null&&f&&f.length?Math.max(F,f[f.length-1]):F!=null?F:this.maxData!=null?this.maxData:100;var J=!B&&!c&&this.setMinX!=null?this.setMinX:null;var w=!B&&!c&&this.setMaxX!=null?this.setMaxX:null;var D,t;var M=[];if(g==null){zero=(G+o)/2}else{zero=g;var D=g-G;var t=o-g;if(D>t){o=g+D}else{G=g-t}}var q=this[this.axisAlgorithm](Math.min(J||G,w||o),Math.max(J||G,w||o),5,this.axisWilkinsonLoose);if(o==Math.abs(G)&&g==0&&q.length%2){q[Math.floor(q.length/2)]=0}var H=(q[q.length-1]-q[0])/(h.length-1);var a=this.getNumberDecimals(q[1]-q[0]);var d=[];for(var E=0;E<q.length;E++){d[E]=q[E].toFixed(a)}var e=this.getMaxText(d);var I=this.measureText(e.toString(),this.font);var m=q[q.length-1]-q[0];var u=[];if(f&&f.length>1&&f.length==h.length){for(var E=0;E<f.length;E++){f[E]=Number(f[E]);u.push(this.formatNumber(f[E].toString()))}e=this.getMaxText(u);I=this.measureText(e.toString(),this.font);f=f.sort(function(l,i){return l-i});var x=f[0];var A=Math.ceil(100/h.length)+1;for(var E=1;E<f.length;E++){var k=f[E];var K=this.seq(x,k,false,A);x=K.pop();M=M.concat(K)}M.push(x);this.colorSpectrumNumber=M.length}else{M=this.seq(q[0],q[q.length-1],false,this.colorSpectrumNumber)}var j={spectrum:h,stops:f,z:g,colors:[],smooth:[],grads:[],rmin:G,rmax:o,min:(f&&f.length>1?f[0]:q[0]),max:(f&&f.length>1?f[f.length-1]:q[q.length-1]),range:m,zero:zero,vals:q,valStr:d,incr:H,decs:a,breaks:M,maxLevLen:I,maxLevChr:e.toString().length,maxLevStr:e};for(var E=0;E<h.length-1;E++){var y={scol:this.getHexColor(h[E]),ecol:this.getHexColor(h[E+1]),min:(f&&f.length>1?f[E]:q[0]+(H*E)),max:(f&&f.length>1?f[E+1]:q[0]+(H*(E+1)))};j.grads.push(y)}for(var E=0;E<this.colorSpectrumNumber;E++){v=this.setColorForValues(j,M[E]);j.colors.push(v)}return j};this.setColorBrew=function(d,e){this.setColorSpectrum();if(!this.meta.def.colorBrew||d){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var b=this.meta.def.colorBrew;if(e){if(this.isTransformedData){var c=this.isHistogram?0.000001:this.minData;var a=this.maxData;switch(this.isTransformedData){case"log2":c=Math.log(c)/Math.LN2;a=Math.log(a)/Math.LN2;break;case"log10":c=Math.log(c)/Math.LN10;a=Math.log(a)/Math.LN10;break;case"exp2":c=Math.pow(2,c);a=Math.pow(2,a);break;case"exp10":c=Math.pow(10,c);a=Math.pow(10,a);break}if(!this.isNumber(c,true)||!this.isNumber(a,true)){c=this.min(this.data.y.trans);a=this.max(this.data.y.trans)}this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,c,a,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData||b.rmin,this.maxData||b.rmax,this.colorSpectrumZeroValue||b.z,this.colorSpectrumBreaks||b.stops)}}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,b.rmin,b.rmax,b.z,b.stops)}}}}};this.getCustomColorScheme=function(b,m,j){if(!b){b=8}if(!m||!CanvasXpress.colorSchemes.hasOwnProperty(m)){m=this.colorScheme}var k=this.getKeys(CanvasXpress.colorSchemes[m]);k.sort(function(d,c){return d-c});if(CanvasXpress.colorSchemes[m]){if(CanvasXpress.colorSchemes[m][b]){return CanvasXpress.colorSchemes[m][b]}else{if(k[k.length-1]==256){var g=this.frac(b);var a=[];for(var e=0;e<b;e++){var l=Math.max(0,Math.min(255,Math.floor(g[e]*256)));a.push(CanvasXpress.colorSchemes[m][256][l])}return a}else{if(b>k[k.length-1]){if(j){b--;while(!CanvasXpress.colorSchemes[m][b]){b--}return this.cloneObject(CanvasXpress.colorSchemes[m][b])}else{var h=b-k.length;b--;while(!CanvasXpress.colorSchemes[m][b]){b--}var a=this.cloneObject(CanvasXpress.colorSchemes[m][b]);for(var e=0;e<h;e++){a.push(CanvasXpress.colorSchemes[m][b][e%CanvasXpress.colorSchemes[m][b].length])}}return a}else{b++;while(!CanvasXpress.colorSchemes[m][b]){b++}return CanvasXpress.colorSchemes[m][b]}}}}else{return this.colors}};this.setColorSpectrum=function(){if(this.blindnessType&&!this.meta.def.colorSpectrum){this.meta.def.colorSpectrum=this.cloneObject(this.colorSpectrum);var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.blindColor(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{if(this.meta.def.colorSpectrum&&this.meta.def.blindnessTypeSpectrum!=this.blindnessType){if(this.blindnessType){var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.blindColor(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{this.colorSpectrum=this.cloneObject(this.meta.def.colorSpectrum)}}}this.meta.def.blindnessTypeSpectrum=this.blindnessType};this.setColorScheme=function(k){var e=this;var a=false;var h;var c=function(o){if(e.data[o]){if(e.colorBy){return e.data[o].hasOwnProperty(e.colorBy)&&e.meta.data[o][e.colorBy].colors?e.meta.data[o][e.colorBy].colors.length:e.data.y.smps.length}else{var n=e.data.y.smps.length;for(var m in e.meta.data[o]){if(e.meta.data[o][m].levels){n=Math.max(n,e.meta.data[o][m].levels.length)}}return n}}return e.data.y.smps.length};if(this.colorScheme=="User"){h=this.cloneObject(this.colors)}else{if(this.colorScheme=="ColorSpectrum"){var j=this.colorSpectrumNumber;this.colorSpectrumNumber=this.graphType=="Circular"?Math.max(this.data.y.vars.length,this.data.y.smps.length):this.data.y.vars.length;var l=this.getColorBrew(this.colorSpectrum,0,this.data.y.vars.length);h=l.colors;this.colorSpectrumNumber=j}else{if(CanvasXpress.colorSchemes[this.colorScheme]){var b;var g=this.getKeys(CanvasXpress.colorSchemes[this.colorScheme]);g.sort(function(m,i){return m-i});g=parseInt(g[g.length-1]);if(k&&k.type=="String"){b=k.levels.length}else{if(this.graphType.match(/Scatter/)){if(this.layoutValid){b=c("z")}else{if(this.colorBy&&this.meta.data.hasOwnProperty("z")&&this.meta.data.z.hasOwnProperty(this.colorBy)&&this.meta.data.z[this.colorBy].colors){b=this.meta.data.z[this.colorBy].levels.length}else{b=this.data.y.smps.length}}}else{if(this.graphType.match(/Treemap|TagCloud|Sankey|Tree|Circular/)){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/Venn/)){b=this.vennGroups}else{if(this.graphType.match(/Pie/)){b=this.data.y.vars.length}else{if(this.graphType.match(/Network|Genome|Correlation/)){b=g}else{if(this.graphType=="ParallelCoordinates"){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/BarLine|DotLine/)&&this.coordinateLineColor&&(!this.isGroupedData||!this.colorBy)){b=Math.max(this.xAxis.length,this.xAxis2.length)}else{if(this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){b=this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.meta.data.x[this.colorBy].levels?this.meta.data.x[this.colorBy].levels.length:this.data.y.vars.length}else{b=this.data.y.vars.length}}}}}}}}}if(CanvasXpress.colorSchemes[this.colorScheme][b]){h=CanvasXpress.colorSchemes[this.colorScheme][b]}else{if(b>g){b--;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b--}}else{b++;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b++}}h=CanvasXpress.colorSchemes[this.colorScheme][b]}if(this.meta.def.colors){this.meta.def.colors=this.cloneObject(h);a=true}}else{h=CanvasXpress.colorSchemes.Balanced[20]}}}if((this.blindnessType&&!this.meta.def.colors)||a){this.meta.def.colors=this.cloneObject(h);if(this.blindnessType){var f=[];for(var d=0;d<h.length;d++){f.push(this.blindColor(h[d]))}h=f}}else{if(this.meta.def.colors&&this.meta.def.blindnessTypeColors!=this.blindnessType){h=this.cloneObject(this.meta.def.colors);if(this.blindnessType){var f=[];for(var d=0;d<h.length;d++){f.push(this.blindColor(h[d]))}h=f}}}this.meta.def.blindnessTypeColors=this.blindnessType;for(var d=0;d<h.length;d++){h[d]=this.validateColor(h[d])}if(!k){this.colors=h}this.updateMetaDataColors(h,k)};this.validateUserColors=function(){var b=[];for(var c=0;c<this.colors.length;c++){b.push(this.validateColor(this.colors[c]))}if(b.length>0){this.colors=b}var a=[];for(var c=0;c<this.colorSpectrum.length;c++){a.push(this.validateColor(this.colorSpectrum[c]))}if(a.length>0){this.colorSpectrum=a}}};CanvasXpress.prototype.initAttributes=function(){this.setStyle=function(c,b,d,a){if(!a){a=this.getCanvasContext()}if(this.transparency!=null){c=this.addColorTransparency(c,this.transparency,true)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.setShadow(true,a)};this.setClipBoundaries=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left-1;d=this.marginTop+this.offsetY+this.top-1;a=this.x+2;e=this.y+2}return[b,d,a,e]};this.setClipArea=function(a,e){if(this.graphType=="Tree"){return}if(!e){e=this.getCanvasContext()}this.saveCanvas(e);var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}e.rect(d,f,c,g);e.clip();this.meta.state.clip=[d,f,c,g]};this.resetClipArea=function(a){if(this.graphType=="Tree"){return}this.restoreCanvas(a);this.setClipArea([0,0,0,0],a);this.restoreCanvas(a);this.meta.state.clip=false};this.resetStyle=function(a){this.setShadow(false,a)};this.setShadow=function(c,a){if(this.showShadow){if(!a){a=this.getCanvasContext()}var b="rgba(255,255,255,0)";if(c){a.shadowOffsetX=this.shadowOffsetX;a.shadowOffsetY=this.shadowOffsetY;a.shadowBlur=this.shadowBlur;a.shadowColor=this.shadowColor}else{a.shadowOffsetX=0;a.shadowOffsetY=0;a.shadowBlur=0;a.shadowColor=this.background;a.strokeStyle="rgba(255,255,255,0)";a.fillStyle="rgba(255,255,255,0)"}}};this.lineTo=function(c,h,b,g,i){if(this.graphType=="Network"){return this.lineRawTo(c,h,b,g,i)}var f=~~(c+0.5);var a=~~(h+0.5);var d=~~(b+0.5);var j=~~(g+0.5);if(Math.abs(f-d)==1){f=(f+d)/2;d=f}else{f+=0.5;d+=0.5}if(Math.abs(a-j)==1){a=(a+j)/2;j=a}else{a+=0.5;j+=0.5}if(!i){i=this.getCanvasContext()}if(f==d&&a==j){var e=this.lineThickness/1.5;i.fillRect(f,a,e,e)}else{i.moveTo(f,a);i.lineTo(d,j)}i.stroke()};this.lineRawTo=function(c,e,b,d,a){if(!a){a=this.getCanvasContext()}a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.lineToOld=function(c,e,b,d,a){if(c==b){c=(((c+0.5)<<1)>>1)+0.5;b=c}else{if(e==d){e=(((e+0.5)<<1)>>1)+0.5;d=e}}if(!a){a=this.getCanvasContext()}a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.bitCode=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.intersect=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.lineClip=function(n,l,h){var k,j,d,m;if(!l){l=this.setClipBoundaries();l[2]+=l[0];l[3]+=l[1]}if(!h){h=[]}var g=n.length;var e=this.bitCode(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.bitCode(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.intersect(k,j,e,l);e=this.bitCode(k,l)}else{j=this.intersect(k,j,d,l);d=this.bitCode(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.polygonClip=function(k,j,c){var h,d,g,a,e;if(!j){j=this.setClipBoundaries();j[2]+=j[0];j[3]+=j[1]}if(c){xy=[];for(var f=1;f<k.length;f+=2){xy.push([k[f],k[f+1]])}}else{xy=k}for(var b=1;b<=8;b*=2){h=[];d=xy[xy.length-1];g=!(this.bitCode(d,j)&b);for(var f=0;f<xy.length;f++){a=xy[f];e=!(this.bitCode(a,j)&b);if(e!==g){h.push(this.intersect(d,a,b,j))}if(e){h.push(a)}d=a;g=e}xy=h;if(!xy.length){break}}if(c){k=["poly"];for(var f=0;f<h.length;f++){k.push(h[f][0]);k.push(h[f][1])}return k}return h};this.lineIntersect=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.clip=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.setClipBoundaries()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"arrow":case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.parseInt(f[0]-(f[2]/2));p=this.parseInt(f[1]-(f[3]/2));c=this.parseInt(d+f[2]);n=this.parseInt(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.getLineArea=function(P,D,a,B,af,aa,O,T,Q,ab,ac,ad,R,U,V,E){var W=Math.max((O||1),this.lineWidthEvent);var S=[];var I=["poly"];P=this.validateBezier(P,D,a,B,af,Q,ab);if(P.match(/error/)){if(this.showErrorBars&&this.isNumeric([D,a,B,af,O])){D=Math.ceil(D);B=Math.ceil(B);a=Math.ceil(a);af=Math.ceil(af);O=Math.ceil(O);var K=O/2;if(O>0){I=["poly",D,a-W,B-W,af-W,B-W,af-K,B+W,af-K,B+W,af+K,B-W,af+K,B-W,af+W,D,a+W]}else{I=["poly",B-W,af+W,B-K,af+W,B-K,af-W,B+K,af-W,B+K,af+W,B+W,af+W,D+W,a,D-W,a]}}else{return false}}else{if(P=="spline"||P=="cardinalSpline"){if(D.length<3){return D.length<2?false:this.getLineArea("line",D[0],a[0],D[1],a[1],aa,O,T,Q,ab,ac,ad,R,U,V)}for(var Z=0;Z<D.length;Z++){I.push(D[Z],a[Z]-W);S.push(a[Z]+W,D[Z])}I=I.concat(S.reverse())}else{if(P=="arch"){if(D.length!=3||a.length!=3){return false}for(var Z=0;Z<D.length;Z++){if(!this.isNumeric([D[Z],a[Z]])){return false}}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="arc"){I=["poly"];S=this.traceArc1(D,a,B,Q,ab,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc1(D,a,B-W,Q,ab);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="quadratic"){var v=this.perpendicularLinePoints(D,a,B,af,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(R))*(R>0?-1:1));var C=this.shortenLine(D,a,B,af,Q,ab,P,R);var x=this.parallelLinePoints(C[0],C[1],v[0],v[1],W);var u=this.parallelLinePoints(v[0],v[1],C[2],C[3],W);S=this.traceQuadraticCurve(x[0],x[1],x[4],x[5],u[4],u[5],0.1,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}var M=[];S=this.traceQuadraticCurve(x[2],x[3],x[6],x[7],u[6],u[7],0.1,true);for(var Z=0;Z<S.length;Z++){M.push(S[Z][1],S[Z][0])}I=I.concat(M.reverse())}else{if(P=="roundLine"){I=["poly",D-W,a,D-W,af+W,B,af+W,B,af-W,D+W,af-W,D+W,a]}else{if(this.isNumeric([D,a,B,af])){var G=this.shortenLine(D,a,B,af,(Q||0),(ab||0),P);D=G[0];a=G[1];B=G[2];af=G[3];if(ac){G=this.clip("line",[D,a,B,af],ad);if(G){D=G[0];a=G[1];B=G[2];af=G[3]}else{return false}}if(R&&this.isArray(R)&&R.length>0){if(this.isNumeric2DArray(R)){if(P.match(/bezier/i)){if(R[0].length==6){var ae=[R[0][0],R[0][1]];for(var Z=0;Z<R.length;Z++){ae=ae.concat(R[Z])}ae.push(R[R.length-1][0],R[R.length-1][1]);var d=this.cloneObject(ae);for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]-W,d[2],d[3]-W,d[4],d[5]-W,d[6],d[7]-W,0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}for(var Y=0;Y<6;Y++){d.shift()}}d=this.cloneObject(ae);var M=[];for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]+W,d[2],d[3]+W,d[4],d[5]+W,d[6],d[7]+W,0.1,true);for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}for(var Y=0;Y<6;Y++){d.shift()}}I=I.concat(M.reverse())}else{if(R.length==4){var x=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);var u=this.parallelLinePoints(R[2][0],R[2][1],R[3][0],R[3][1],W);S=this.traceBezierCurve(x[0],x[1],x[4],x[5],u[0],u[1],u[4],u[5],0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}S=this.traceBezierCurve(x[2],x[3],x[6],x[7],u[2],u[3],u[6],u[7],0.1,true);var M=[];for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}I=I.concat(M.reverse())}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[R.length-1][0],R[R.length-1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{if(R.length>2){I=["poly"];var L=[];for(var Z=0;Z<R.length-1;Z++){L.push([R[Z][0],R[Z][1]])}for(var Z=R.length-1;Z>=1;Z--){L.push([R[Z][0],R[Z][1]])}S=this.enlargePolygon(L,W,1);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{return false}}else{if(P.match(/curved/i)){var z=D==B&&a==af&&E;var o=this.lineMidPoint(D,a,B,af);var N=this.lineLength(D,a,o[0],o[1]);var J=(Q||0)/N;var F=(ab||0)/N;var y=P.match(/curvedcc/i)&&D>B?false:!P.match(/curvedcc/i)&&B>=D?true:false;var l=B>=D?Math.asin((o[1]-a)/N):Math.asin(-(o[1]-a)/N);var X=l+Math.PI;var k=[];if(z){if(l<0){l+=Math.PI*2}var r=E.size*1.25;var H=E.size/1.25;switch(E.pos){case"top":k=[D,a-r,H,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":k=[D+r,a-r,H,Math.PI,Math.PI*0.5,false];break;case"right":k=[D+r,a,H,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":k=[D+r,a+r,H,Math.PI*1.5,Math.PI,false];break;case"bottom":k=[D,a+r,H,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":k=[D-r,a+r,H,0,Math.PI*1.5,false];break;case"left":k=[D-r,a,H,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":k=[D-r,a-r,H,Math.PI*0.5,0,false];break}}else{if(B>=D){k=[o[0],o[1],Math.max(0,N),l-F,X+J,y]}else{k=[o[0],o[1],Math.max(0,N),l+J,X-F,y]}}I=["poly"];S=this.traceArc(k[0],k[1],k[2]+W,k[3],k[4],k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc(k[0],k[1],k[2]-W,k[3],k[4],!k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P.match(/bezier/i)){var h=(D+B)/2;var g=(a+af)/2;if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a-W,D,g-W,B,g-W,B,af-W,0.25,true)}else{S=this.traceBezierCurve(D,a-W,h,a-W,h,af-W,B,af-W,0.25,true)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a+W,D,g+W,B,g+W,B,af+W,0.25)}else{S=this.traceBezierCurve(D,a+W,h,a+W,h,af+W,B,af+W,0.25)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(D==B&&a!=af){I=["poly",D-W,a,D+W,a,B+W,af,B-W,af]}else{if(a==af&&D!=B){I=["poly",D,a-W,B,a-W,B,af+W,D,af+W]}else{var A=this.parallelLinePoints(D,a,B,af,W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}}}}else{return false}}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?I:this.adjustNetworkObjects(I)}else{return I}};this.setDashDot=function(c,a){if(!a){a=this.getCanvasContext()}if(!c){c="solid"}var b=[];this.tempCap=a.lineCap;if(c.match(/blank/i)){b=CanvasXpress.R.lty[0]}else{if(c.match(/solid/i)){b=CanvasXpress.R.lty[1]}else{if(c.match(/dashed/i)){b=CanvasXpress.R.lty[2];b=[this.dashLength,this.dashLength-2]}else{if(c.match(/dotted/i)){b=CanvasXpress.R.lty[3];b=[this.dotLength,this.dotLength+2]}else{if(c.match(/dotdash/i)){b=CanvasXpress.R.lty[4]}else{if(c.match(/longdash/i)){b=CanvasXpress.R.lty[5]}else{if(c.match(/twodash/i)){b=CanvasXpress.R.lty[6]}}}}}}}a.setLineDash(b)};this.resetDashDot=function(a){if(!a){a=this.getCanvasContext()}a.lineCap=this.tempCap;a.setLineDash([])};this.validateBezier=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.drawLine=function(N,z,a,x,ad,W,M,R,P,Y,Z,ab,Q,S,T,A,K,B){if(!B){B=this.getCanvasContext()}this.setDashDot(N,B);N=this.validateBezier(N,z,a,x,ad,P,Y);var d=false;var H=function(){var c=Math.sqrt(Math.pow(x-z,2)+Math.pow(ad-a,2));var b=ad>a?this.roundedPolygonRadius/c:(c-this.roundedPolygonRadius)/c;return[z+(b*(x-z)),a+(b*(ad-a))]};var C=function(b){switch(b){case"arrow":d=0;break;case"square":d=1;break;case"round":d=2;break;case"roundDocked":d=false;break}};if(!N){N="solid"}if(N.match(/error/)){if(this.showErrorBars&&this.isNumeric([z,a,x,ad,M])){z=Math.ceil(z);x=Math.ceil(x);a=Math.ceil(a);ad=Math.ceil(ad);M=Math.ceil(M);var J=M/2;this.setStyle(W,false,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();this.lineTo(z,a,x,ad,B);if(Math.abs(M)>this.errorBarsWidth){if(M>0){this.lineTo(x,ad-J,x,ad+J,B)}else{this.lineTo(x-J,ad,x+J,ad,B)}}}}this.resetStyle(B)}else{if(N.match(/spline|cardinalSpline/i)){if(z.length<3){return z.length<2?false:this.drawLine(N.match(/dashedSpline/i)?"dashedLine":"line",z[0],a[0],z[1],a[1],W,M,R,P,Y,Z,ab,Q,S,T,false,false,B)}var O=[];var aa=[];var X=0;for(var V=0;V<z.length;V++){if(this.isNumeric([z[V],a[V]])){aa.push(z[V],a[V]);X+=2}else{return}}this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){if(N.match(/spline/i)){for(var V=0;V<X-4;V+=2){O=O.concat(this.splineControlPoint(aa[V],aa[V+1],aa[V+2],aa[V+3],aa[V+4],aa[V+5]))}B.beginPath();B.moveTo(aa[0],aa[1]);B.quadraticCurveTo(O[0],O[1],aa[2],aa[3]);for(var V=2;V<X-5;V+=2){B.bezierCurveTo(O[2*V-2],O[2*V-1],O[2*V],O[2*V+1],aa[V+2],aa[V+3])}B.moveTo(aa[X-2],aa[X-1]);B.quadraticCurveTo(O[2*X-10],O[2*X-9],aa[X-4],aa[X-3]);B.stroke()}else{aa=this.curvePoints(aa);B.beginPath();B.moveTo(aa[0],aa[1]);for(var V=2;V<aa.length-1;V+=2){B.lineTo(aa[V],aa[V+1])}B.stroke()}}this.resetStyle(B)}else{if(N.match(/arch/)){if(z.length!=3||a.length!=3){return false}for(var V=0;V<z.length;V++){if(!this.isNumeric([z[V],a[V]])){return false}}this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();B.moveTo(z[0],a[0]);B.quadraticCurveTo(z[1],a[1],z[2],a[2]);B.stroke()}this.resetStyle(B)}else{if(N=="arc"){this.setStyle(W,M,R,B);B.beginPath();B.arc(z,a,Math.max(0,x),P,Y,false);B.stroke();this.resetStyle(B)}else{if(N=="quadratic"){this.setStyle(W,M,R,B);var r=this.perpendicularLinePoints(z,a,x,ad,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(Q))*(Q>0?-1:1));var y=this.shortenLine(z,a,x,ad,P,Y,N,Q);var ac=this.traceQuadraticCurve(y[0],y[1],r[0],r[1],y[2],y[3],0.1,true);B.beginPath();B.moveTo(y[0],y[1]);B.quadraticCurveTo(r[0],r[1],y[2],y[3]);B.stroke();this.resetStyle(B);if(T){z=ac[9][0];a=ac[9][1];x=y[2];ad=y[3];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=ac[1][0];a=ac[1][1];x=y[0];ad=y[1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(N=="roundLine"){this.setStyle(W,M,R,B);B.beginPath();B.moveTo(z,a);if(a>ad){B.lineTo(z,ad+this.roundedPolygonRadius);if(z>x){B.quadraticCurveTo(z,ad,z+this.roundedPolygonRadius,ad)}else{B.quadraticCurveTo(z,ad,z-this.roundedPolygonRadius,ad)}}else{B.lineTo(z,ad-this.roundedPolygonRadius);if(z>x){B.quadraticCurveTo(z,ad,z-this.roundedPolygonRadius,ad)}else{B.quadraticCurveTo(z,ad,z+this.roundedPolygonRadius,ad)}}B.lineTo(x,ad);B.stroke();this.resetStyle(B);if(T){C(T);this.drawArrowHead(z,ad,x,ad,W,M,d,false,B)}if(S){C(S);this.drawArrowHead(z,ad,x,ad,W,M,d,true,B)}}else{if(this.isNumeric([z,a,x,ad])){var E=this.shortenLine(z,a,x,ad,(P||0),(Y||0),N);z=E[0];a=E[1];x=E[2];ad=E[3];if(Z){E=this.clip("line",[z,a,x,ad],ab);if(E){z=E[0];a=E[1];x=E[2];ad=E[3]}else{return false}}if(Q&&this.isArray(Q)&&Q.length>0){var G=Q.length-1;if(this.isNumeric2DArray(Q)){this.setStyle(W,M,R,B);if(N.match(/bezier/i)){if(!this.isColorTransparent(W,true)){if(Q[0].length==6){B.beginPath();B.moveTo(Q[0][0],Q[0][1]);for(var V=0;V<Q.length;V++){B.bezierCurveTo(Q[V][0],Q[V][1],Q[V][2],Q[V][3],Q[V][4],Q[V][5])}B.stroke();var ac;if(T){ac=this.traceBezierCurve(Q[G][0],Q[G][1],Q[G][0],Q[G][1],Q[G][2],Q[G][3],Q[G][4],Q[G][5],0.1,true);z=ac[9][0];a=ac[9][1];x=ac[10][0];ad=ac[10][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){ac=this.traceBezierCurve(Q[0][0],Q[0][1],Q[0][0],Q[0][1],Q[0][2],Q[0][3],Q[0][4],Q[0][5],0.1,true);z=ac[1][0];a=ac[1][1];x=ac[0][0];ad=ac[0][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(Q.length==4){B.beginPath();B.moveTo(Q[0][0],Q[0][1]);B.bezierCurveTo(Q[1][0],Q[1][1],Q[2][0],Q[2][1],Q[3][0],Q[3][1]);B.stroke();var ac=this.traceBezierCurve(Q[0][0],Q[0][1],Q[1][0],Q[1][1],Q[2][0],Q[2][1],Q[3][0],Q[3][1],0.1,true);if(T){z=ac[9][0];a=ac[9][1];x=Q[3][0];ad=Q[3][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=ac[1][0];a=ac[1][1];x=Q[1][0];ad=Q[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{B.beginPath();B.moveTo(Q[0][0],Q[0][1]);this.lineTo(Q[G][0],Q[G][1],false,false,B);B.stroke();if(T){z=Q[G-1][0];a=Q[G-1][1];x=Q[G][0];ad=Q[G][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=Q[0][0];a=Q[0][1];x=Q[1][0];ad=Q[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}}}}else{if(!this.isColorTransparent(W,true)){B.beginPath();this.lineTo(Q[0][0],Q[0][1],Q[1][0],Q[1][1],B);for(var V=1;V<G;V++){this.lineTo(Q[V][0],Q[V][1],Q[V+1][0],Q[V+1][1],B)}if(T){z=Q[G-1][0];a=Q[G-1][1];x=Q[G][0];ad=Q[G][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=Q[0][0];a=Q[0][1];x=Q[1][0];ad=Q[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}}this.resetStyle(B)}else{return false}}else{if(N.match(/curved/i)){var v=z==x&&a==ad&&A;var l=this.lineMidPoint(z,a,x,ad);var L=this.lineLength(z,a,l[0],l[1]);var I=(P||0)/L;var D=(Y||0)/L;var u=N.match(/curvedcc/i)&&z>x?false:!N.match(/curvedcc/i)&&x>=z?true:false;var k=x>=z?Math.asin((l[1]-a)/L):Math.asin(-(l[1]-a)/L);var U=k+Math.PI;var j=[];this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();if(v){if(k<0){k+=Math.PI*2}if(A.dir){T=false;S=A.end}else{T=A.end;S=false}var o=A.size*1.25;var F=A.size/1.25;switch(A.pos){case"top":j=[z,a-o,F,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":j=[z+o,a-o,F,Math.PI,Math.PI*0.5,false];break;case"right":j=[z+o,a,F,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":j=[z+o,a+o,F,Math.PI*1.5,Math.PI,false];break;case"bottom":j=[z,a+o,F,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":j=[z-o,a+o,F,0,Math.PI*1.5,false];break;case"left":j=[z-o,a,F,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":j=[z-o,a-o,F,Math.PI*0.5,0,false];break}}else{if(x>=z){j=[l[0],l[1],Math.max(0,L),k-D,U+I,u]}else{j=[l[0],l[1],Math.max(0,L),k+I,U-D,u]}}B.arc(j[0],j[1],j[2],j[3],j[4],j[5]);var ac=this.traceArc(j[0],j[1],j[2],j[3],j[4],j[5]);B.stroke()}this.resetStyle(B);if(T){C(T);z=ac[15][0];a=ac[15][1];x=ac[16][0];ad=ac[16][1];this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=ac[1][0];a=ac[1][1];x=ac[0][0];ad=ac[0][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(N.match(/bezier/i)){var h=(z+x)/2;var g=(a+ad)/2;var ac;this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();B.moveTo(z,a);if(this.graphType=="Tree"&&this.treeCircular&&K){B.bezierCurveTo(K[2],K[3],K[0],K[1],x,ad);ac=this.traceBezierCurve(z,a,K[0],K[1],K[0],K[1],x,ad,0.1,true)}else{if(N.match(/beziery/i)){B.bezierCurveTo(z,g,x,g,x,ad);ac=this.traceBezierCurve(z,a,z,g,x,g,x,ad,0.1,true)}else{B.bezierCurveTo(h,a,h,ad,x,ad);ac=this.traceBezierCurve(z,a,h,a,h,ad,x,ad,0.1,true)}}B.stroke()}this.resetStyle(B);if(T){z=ac[9][0];a=ac[9][1];x=ac[10][0];ad=ac[10][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){x=ac[0][0];ad=ac[0][1];z=ac[1][0];a=ac[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(N.match(/needle/i)){this.setStyle(W,M,R,B);var r=this.parallelLinePoints(z,a,x,ad,M);if(!this.isColorTransparent(W,true)){B.beginPath();B.moveTo(r[0],r[1]);B.lineTo(x,ad);B.lineTo(r[2],r[3]);B.closePath();B.stroke();B.fill();B.arc(z,a,M*3,0,Math.PI*2);B.stroke();B.fill()}this.resetStyle(B)}else{this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();if(N.match(/R$/)||this.useRawLines){this.lineRawTo(z,a,x,ad,B)}else{this.lineTo(z,a,x,ad,B)}}this.resetStyle(B);if(T){C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}}}}}else{this.resetDashDot(B);return false}}}}}}}this.resetDashDot(B)};this.drawArrowHead=function(v,c,t,b,u,l,h,e,q){if(!q){q=this.getCanvasContext()}var s=function(z,C,f,D){var w=[];for(var A=0;A<z.length;A++){w.push([(z[A][0]*Math.cos(C))-(z[A][1]*Math.sin(C)),(z[A][0]*Math.sin(C))+(z[A][1]*Math.cos(C))])}var B=[];for(var A=0;A<w.length;A++){B.push([w[A][0]+f,w[A][1]+D])}return B};var p=this.arrowPointSize;var d=Math.max((p/2)-1,1);var a=Math.max((p*2/3),1);var n=l?l/2:this.outlineWidth/2;var j=l?l*2:this.outlineWidth*2;var o=h==1?[[-n,-p],[-n,p]]:h==0?[[1.5,-0.5],[-p,-d*l],[-p,d*l]]:false;var m=t-v;var k=b-c;this.setStyle(u,h==1?l+2:l,false,q);if(h<2){var g=s(o,Math.atan2(k,m),t,b);q.beginPath();q.moveTo(g[0][0],g[0][1]);for(var r=1;r<g.length;r++){if(!isNaN(g[r][0])&&!isNaN(g[r][1])){q.lineTo(g[r][0],g[r][1])}}if(h==0){if(!isNaN(g[0][0])&&!isNaN(g[0][1])){q.lineTo(g[0][0],g[0][1])}q.closePath();q.fill()}else{q.closePath();q.stroke()}}else{if(h==2){q.beginPath();q.arc(t,b,Math.max(0,d*1.3),0,Math.PI*2,true);q.closePath();q.fill()}else{}}this.resetStyle(q)};this.createPatterns=function(b){var h=function(c){c.strokeStyle="rgb(29,137,182)";var j=[4,6,9,12,16,21,27,14,17,21,26];var l=[27,21,16,12,9,6,4,26,21,17,14];for(var k=0;k<j.length;k++){c.moveTo(j[k],l[k]);c.arc(j[k],l[k],2,0,Math.PI*2)}c.moveTo(3,32);c.arc(3,32,2,Math.PI,0);c.moveTo(13,32);c.arc(13,32,2,Math.PI,0);c.moveTo(32,3);c.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);c.moveTo(32,13);c.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);j=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];l=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var k=0;k<j.length;k++){c.moveTo(j[k][0],l[k][0]);c.lineTo(j[k][1],l[k][1])}c.stroke()};var g=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(3,0);c.arc(3,0,2,Math.PI,0,true);c.moveTo(3,5);c.arc(3,5,2,Math.PI,0);c.moveTo(6,1);c.lineTo(8,4);c.lineTo(10,1);c.moveTo(13,0);c.arc(13,0,2,Math.PI,0,true);c.moveTo(13,5);c.arc(13,5,2,Math.PI,0);c.stroke()};var d=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(0,3);c.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,3);c.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);c.moveTo(1,6);c.lineTo(4,8);c.lineTo(1,10);c.moveTo(0,13);c.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,13);c.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);c.stroke()};if(!b){b=this.getCanvasContext()}var e;var f=this.$cX("canvas");f.width=5;f.height=5;var a=this.get2DCanvasContext(f);if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.hatchForward=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.hatchReverse=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeVertical")){f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();CanvasXpress.cachePatterns.stripeVertical=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeHorizontal")){a.clearRect(0,0,3,3);a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.stripeHorizontal=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("polkaDot")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.fill();CanvasXpress.cachePatterns.polkaDot=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossHatch")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.crossHatch=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossStripe")){f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.crossStripe=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squares")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.strokeRect(1,1,4,4);a.stroke();CanvasXpress.cachePatterns.squares=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("circles")){a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,1,0,Math.PI*2);a.stroke();CanvasXpress.cachePatterns.circles=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("plus")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.plus=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("minus")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.minus=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("bars")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();CanvasXpress.cachePatterns.bars=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesHorizontal")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,5);a.lineTo(2.5,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesVertical")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,2.5);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.squiglesVertical=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickForward")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(3,0);a.lineTo(0,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(2,5);a.lineTo(5,2);a.lineTo(5,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickForward=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickReverse")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(2,0);a.lineTo(5,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(0,5);a.lineTo(0,2);a.lineTo(3,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickReverse=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("art")){a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.moveTo(0,5);a.lineTo(5,0);a.stroke();CanvasXpress.cachePatterns.art=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("pcx")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(2,0);a.lineTo(0,0);a.lineTo(0,3);a.lineTo(2,3);a.stroke();a.beginPath();a.moveTo(3,3);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,3);a.lineTo(3,5);a.stroke();CanvasXpress.cachePatterns.pcx=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward3")){f.width=5;f.height=3;a.clearRect(0,0,5,3);a.beginPath();a.moveTo(0,0);a.lineTo(5,3);a.stroke();CanvasXpress.cachePatterns.hatchForward3=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse3")){a.clearRect(0,0,5,3);a.beginPath();a.moveTo(5,0);a.lineTo(0,3);a.stroke();CanvasXpress.cachePatterns.hatchReverse3=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTop")){f.width=5;f.height=16;a.clearRect(0,0,5,16);d(a);CanvasXpress.cachePatterns.membraneTop=b.createPattern(f,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBottom")){f.width=5;f.height=16;a.clearRect(0,0,5,16);a.translate(5,0);a.scale(-1,1);d(a);CanvasXpress.cachePatterns.membraneBottom=b.createPattern(f,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneRight")){f.width=16;f.height=5;a.clearRect(0,0,16,5);g(a);CanvasXpress.cachePatterns.membraneRight=b.createPattern(f,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneLeft")){f.width=16;f.height=5;a.clearRect(0,0,16,5);a.translate(0,5);a.scale(1,-1);g(a);CanvasXpress.cachePatterns.membraneLeft=b.createPattern(f,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTL")){f.width=32;f.height=32;a.clearRect(0,0,32,32);h(a);CanvasXpress.cachePatterns.membraneTL=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBL")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(0,32);a.scale(1,-1);h(a);CanvasXpress.cachePatterns.membraneBL=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTR")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,0);a.scale(-1,1);h(a);CanvasXpress.cachePatterns.membraneTR=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBR")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,32);a.scale(-1,-1);h(a);CanvasXpress.cachePatterns.membraneBR=b.createPattern(f,"no-repeat")}};this.sphere=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.roundedPolygon=function(h){var v=function(x,r,i){i.x=r.x-x.x;i.y=r.y-x.y;i.len=Math.sqrt(i.x*i.x+i.y*i.y);i.nx=i.x/i.len;i.ny=i.y/i.len;i.ang=Math.atan2(i.ny,i.nx)};var s=[];for(var t=0;t<h.length;t++){s.push({x:h[t][0],y:h[t][1]})}var m=[];var o=this.roundedPolygonRadius;var e={};var d={};var u=s.length;var c=s[u-1];for(var t=0;t<u;t++){var b=s[(t)%u];var a=s[(t+1)%u];v(b,c,e);v(b,a,d);var j=e.nx*d.ny-e.ny*d.nx;var p=e.nx*d.nx-e.ny*-d.ny;var w=Math.asin(j);var q=1;var f=false;if(p<0){if(w<0){w=Math.PI+w}else{w=Math.PI-w;q=-1;f=true}}else{if(w>0){q=-1;f=true}}var g;var n=w/2;var z=Math.abs(Math.cos(n)*o/Math.sin(n));if(z>Math.min(e.len/2,d.len/2)){z=Math.min(e.len/2,d.len/2);g=Math.abs(z*Math.sin(n)/Math.cos(n))}else{g=o}var l=b.x+d.nx*z;var k=b.y+d.ny*z;l+=-d.ny*g*q;k+=d.nx*g*q;m.push([l,k,g,e.ang+Math.PI/2*q,d.ang-Math.PI/2*q,f]);c=b;b=a}return m};this.drawShapeSetShapeStyle=function(j,i,k,d,e,c,b,a,g,l){if(!l){l=this.getCanvasContext()}this.saveCanvas(l);this.translateCanvas(j,i,l);if(a){this.rotateCanvas(a,l)}if(this.transparency!=null){e=this.addColorTransparency(e,this.transparency,true)}if(this.gradient){if(this.gradientType=="radial"){l.fillStyle=this.getGradient(0,0,Math.max(Math.abs(k),Math.abs(d)),false,e)}else{l.fillStyle=this.getGradient(0,0,k,d,e)}}else{if(b){switch(b){case"closed":case"solid":l.fillStyle=e;break;case"open":break;default:if(e){if(e.match(/0.1\)$/)&&c.match(/0.1\)$/)){l.globalAlpha=0.1}}l.fillStyle=CanvasXpress.cachePatterns[b]?CanvasXpress.cachePatterns[b]:e;break}}else{l.fillStyle=e}}l.strokeStyle=c?c:this.foreground;l.lineWidth=g?g:this.outlineWidth;l.lineJoin=this.joinType;if((k&&l.lineWidth>=k)||(d&&l.lineWidth>=d)){l.strokeStyle=e}this.setShadow(true,l)};this.drawShapeDraw=function(d,c,b){if(!b){b=this.getCanvasContext()}if(d&&d.length>1){var a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.beginPath();b.moveTo(a[0]+0.5,a[1]+0.5);while(d.length>0){a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.lineTo(a[0]+0.5,a[1]+0.5)}if(!c){b.closePath()}}};this.drawShapeFillStroke=function(b,d,c,a){if(!a){a=this.getCanvasContext()}if(c&&c=="open"){a.stroke()}else{if(d==b||a.strokeStyle==a.fillStyle){a.fill()}else{a.fill();a.stroke()}}};this.drawShapeRestore=function(a,d,c,b){if(!b){b=this.getCanvasContext()}b.globalAlpha=1;this.setShadow(false,b);if(c){}this.restoreCanvas(b)};this.getShapeArea=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"||v=="arrow"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.setClipBoundaries()}switch(v){case"arc2":K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=this.polygonClip(N.concat(K.reverse()),false,true);break;case"violin":case"fish":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.traceBezierCurve(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceBezierCurve(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.traceQuadraticCurve(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.traceQuadraticCurve(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"roundpolygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2)}else{N.push(m[E],l[E]-2);K.unshift(m[E],l[E]+2)}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"path":N=N.concat(K);break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"drop":case"teardrop":case"marker":N=["circle",m,l-n,g];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"arrow":case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.getShapeArea("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.getShapeArea("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.getShapeArea("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.getShapeArea("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.getShapeArea("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.getShapeArea("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.adjustNetworkObjects(N)}else{return N}};this.drawShape=function(ab,W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av,O){var T,ay,k,aA,ae,aj;if(!O){O=this.getCanvasContext()}if(af){switch(af){case"closed":case"solid":case"open":case"round":break;default:var aB=af;af="closed";this.drawShape(ab,W,V,Y,ap,aq,aq,af,ad,U,ax,az,ac,at,Z,av);af=aB;break}}switch(ab){case"polygon":case"roundpolygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":case"fish":var al=Number.MAX_VALUE;var R=Number.MAX_VALUE*-1;var ak=Number.MAX_VALUE;var P=Number.MAX_VALUE*-1;ay=[];T=[];if(W.length==V.length){if(ab=="spline"&&W.length<5){return this.drawShape("polygon",W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av)}if(ab=="arch"&&(W.length!=6||V.length!=6||Y.length!=4||ap.length!=2)){return false}if(ab=="bezier"){if(this.isNumeric(W)&&this.isNumeric(V)&&this.isNumeric(ap)){for(var ao=0;ao<W.length;ao++){al=Math.min(al,W[ao]);R=Math.max(R,W[ao]);ak=Math.min(ak,V[ao]);P=Math.max(P,V[ao]);T.push([W[ao],V[ao]])}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0]-=W;T[ao][1]-=V;ay.push(T[ao][0],T[ao][1])}}else{return false}}else{if(ab=="confidence"){if(W.length>2){for(var ao=0;ao<W.length;ao++){if(W[ao][0]!=null&&W[ao][1]!=null&&V[ao][0]!=null&&V[ao][1]!=null&&this.isNumeric([W[ao][0],W[ao][1],V[ao][0],V[ao][1]])){al=Math.min(al,Math.min(W[ao][0],W[ao][1]));R=Math.max(R,Math.max(W[ao][0],W[ao][1]));ak=Math.min(ak,Math.min(V[ao][0],V[ao][1]));P=Math.max(P,Math.max(V[ao][0],V[ao][1]));T.push([[W[ao][0],W[ao][1]],[V[ao][0],V[ao][1]]])}}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0][0]-=W;T[ao][0][1]-=W;T[ao][1][0]-=V;T[ao][1][1]-=V;ay.push([T[ao][0][0],T[ao][0][1]],[T[ao][1][0],T[ao][1][1]])}}else{return false}}else{if(ab=="violin"||ab=="fish"){if(W[0].length==V[0].length&&W[1].length==V[1].length&&W[0].length==W[1].length){for(var ao=0;ao<W[0].length;ao++){if(this.isNumeric([W[0][ao],W[1][ao],V[0][ao],V[1][ao]])){al=Math.min(al,Math.min(W[0][ao],W[1][ao]));R=Math.max(R,Math.max(W[0][ao],W[1][ao]));ak=Math.min(ak,Math.min(V[0][ao],V[1][ao]));P=Math.max(P,Math.max(V[0][ao],V[1][ao]));T.push([[W[0][ao],W[1][ao]],[V[0][ao],V[1][ao]]])}}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0][0]-=W;T[ao][0][1]-=W;T[ao][1][0]-=V;T[ao][1][1]-=V;ay.push([T[ao][0][0],T[ao][0][1]],[T[ao][1][0],T[ao][1][1]])}}else{return false}}else{for(var ao=0;ao<W.length;ao++){if(W[ao]&&V[ao]&&this.isNumeric([W[ao],V[ao]])){al=Math.min(al,W[ao]);R=Math.max(R,W[ao]);ak=Math.min(ak,V[ao]);P=Math.max(P,V[ao]);T.push([W[ao],V[ao]])}}W=ab=="arch"?W[1]:(al+R)/2;V=ab=="arch"?V[1]:(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0]-=W;T[ao][1]-=V;ay.push(T[ao][0],T[ao][1])}}}}}else{return false}break;default:if(this.isNumeric([W,V,Y,ap])){if(ax){T=this.clip(ab,[W,V,Y,ap],az);if(T){if(T.length==4){Y=Math.max(1,T[2]);ap=Math.max(1,T[3]);W=T[0]+(Y/2);V=T[1]+(ap/2)}else{if(T.length==2){W=T[0];V=T[1]}}}else{return false}}else{Y=Math.max(1,Y);ap=Math.max(1,ap)}k=Y/2;aA=ap/2;ae=ap/Y;aj=1.5}else{return false}break}switch(ab){case"image":var N=Array.isArray(Z)?this.backgroundImageMD5:this.getFileName(Z);if(Z&&(CanvasXpress.cacheImages[N]||CanvasXpress.images[Z])){this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);if(CanvasXpress.images[Z]){this.drawImage(CanvasXpress.images[Z],-k*this.zoom,-aA*this.zoom,Y*this.zoom,ap*this.zoom,false,false,false,false,aq,af,O)}else{this.drawImage(CanvasXpress.cacheImages[N],-k*this.zoom,-aA*this.zoom,Y*this.zoom,ap*this.zoom,false,false,false,false,aq,af,O)}}else{if(N&&N=="canvasXpress"){return}else{return this.drawShape("rectangle",W,V,Y,ap,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",af,ad,U,ax,az,ac,at,Z,av)}}break;case"circle":case"sphere":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);if(!this.isColorTransparent(aq,true)||!this.isColorTransparent(ag,true)){O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,false);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}break;case"drop":case"teardrop":case"marker":var F=k*2/3;var E=F*0.5;var S=this.graphType=="Map"?-F*3:0;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.arc(0,S,Math.max(0,k),0,Math.PI,true);O.bezierCurveTo(-k,S+k,0,S+E,0,S+(F*3));O.bezierCurveTo(0,S+E,k,S+k,k,S);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);O.beginPath();O.arc(0,S,Math.max(0,k*0.3),0,Math.PI*2,true);O.closePath();this.drawShapeFillStroke("white","black",af,O);break;case"arrow":T=[[-k,-aA],[k,-aA],[k,aA],[-k,aA]];if(ad){ad=false;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);var F=ap/4;O.beginPath();O.moveTo(k-ap,-aA);O.lineTo(k-ap,-aA-F);O.lineTo(k,0);O.lineTo(k-ap,aA+F);O.lineTo(k-ap,aA);O.lineTo(-k,aA);O.lineTo(-k,-aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}else{this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);var v=Y/4;O.beginPath();O.moveTo(-k,-aA+Y);O.lineTo(-k-v,-aA+Y);O.lineTo(0,-aA);O.lineTo(k+v,-aA+Y);O.lineTo(k,-aA+Y);O.lineTo(k,aA);O.lineTo(-k,aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}break;case"box":case"rect":T=[[-k,-aA],[k,-aA],[k,aA],[-k,aA]];this.drawShapeSetShapeStyle(Math.round(W),Math.round(V),Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(k,-aA);O.lineTo(k,aA);O.lineTo(-k,aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"rectangle":T=[[-k,-aA],[k,-aA],[k,aA],[-k,aA]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);if(af&&af=="open"){O.strokeRect(-k,-aA,Y,ap)}else{if(ag==aq||O.strokeStyle==O.fillStyle){O.fillRect(-k,-aA,Y,ap)}else{O.fillRect(-k,-aA,Y,ap);O.strokeRect(-k,-aA,Y,ap)}}break;case"rect2":return this.drawShape("rectangle",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"rect3":return this.drawShape("rectangle",W,V,Y,Y/3,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"roundrectt":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA);O.lineTo(k,aA);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectb":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA);O.lineTo(-k,-aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k,-aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k,aA);O.lineTo(k,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrecttr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA);O.lineTo(k,aA);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k,-aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrecttl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA);O.lineTo(k,aA);O.lineTo(k,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectbr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA);O.lineTo(-k,-aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectbl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k,aA);O.lineTo(k,-aA);O.lineTo(-k,-aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrecto":var X=Y<ap?k:aA;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();if(Y<ap){O.arc(0,-aA+X,X,Math.PI,0);O.lineTo(k,aA-X);O.arc(0,aA-X,X,0,Math.PI);O.lineTo(-k,-aA+X)}else{O.arc(-k+X,0,X,Math.PI*0.5,Math.PI*1.5);O.lineTo(k-X,-aA);O.arc(k-X,0,X,Math.PI*1.5,Math.PI*0.5);O.lineTo(-k+X,aA)}O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrect":case"roundrect2":case"roundrectd":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap/4:Y/4;if(ab=="roundrect2"){X*=4}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);if(ab=="roundrectd"&&Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius){Y-=this.roundedPolygonRadius;ap-=this.roundedPolygonRadius;k=Y/2;aA=ap/2;O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}break;case"brace":var X=Y>ap?ap/4:Y/4;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.bezierCurveTo(-k,0,0,0,0,aA);O.bezierCurveTo(0,0,k,0,k,-aA);this.drawShapeFillStroke(aq,ag,af,O);break;case"square":T=[[-k,-k],[k,-k],[k,k],[-k,k]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"triangle":if(Y==ap){return this.drawShape("equilateral",W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av)}T=[[0,-aA],[k,aA],[-k,aA]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"triangle2":if(Y==ap){return this.drawShape("equilateral2",W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av)}T=[[0,aA],[k,-aA],[-k,-aA]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"equilateral":var X=Y*Math.sqrt(3)/6;var j=X/2;var H=Math.sqrt((X*X)-(j*j));T=[[0,-aA],[k,aA],[-k,aA]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"equilateral2":var X=Y*Math.sqrt(3)/6;var j=X/2;var H=Math.sqrt((X*X)-(j*j));T=[[0,aA],[k,-aA],[-k,-aA]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"diamond":case"rhombus":T=[[0,-aA],[k,0],[0,aA],[-k,0]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"hexagon":var g=2*Math.PI/6;var T=[];for(var aw=0;aw<6;aw++){T.push([k*Math.sin(g*aw),aA*Math.cos(g*aw)])}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"pentagon":var au=Y/3;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();for(var ao=0;ao<5;ao++){var G=(ao/5)*Math.PI*2+(-Math.PI/2);O.lineTo(Math.cos(G)*au,Math.sin(G)*au)}O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"octagon":var aC=Y/4;var an=ap/4;T=[[-aC,-aA],[aC,-aA],[k,-an],[k,an],[aC,aA],[-aC,aA],[-k,an],[-k,-an]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"oval":case"ovald":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,true);O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);if(ab=="ovald"){Y-=this.margin*2;ap-=this.margin*2;ae=ap/Y;this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,true);O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O)}break;case"oval2":return this.drawShape("oval",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"oval3":return this.drawShape("oval",W,V,Y,Y/3,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"arc":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI,true);if(af!="open"){O.closePath()}this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"arc2":var J=ap*Math.cos(ac);var aF=ap*Math.sin(ac);var I=ap*Math.cos(at);var aD=ap*Math.sin(at);var D=this.shortenLine(0,0,J,aF,0,Y,"line");var B=this.shortenLine(0,0,I,aD,0,Y,"line");this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(D[2],D[3]);O.lineTo(J,aF);O.arc(0,0,Math.max(0,ap),ac,at,false);O.lineTo(B[2],B[3]);O.arc(0,0,Math.max(0,ap-Y),at,ac,true);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"arc3":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI,true);this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"arch":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(T[0][0],T[0][1]);O.quadraticCurveTo(T[1][0],T[1][1],T[2][0],T[2][1]);O.arc(0,0,Math.max(0,ap[0]),Y[3],Y[2],true);O.quadraticCurveTo(T[4][0],T[4][1],T[5][0],T[5][1]);O.arc(0,0,Math.max(0,ap[1]),Y[1],Y[0],true);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"path":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T,af=="open");this.drawShapeFillStroke(aq,ag,af,O);break;case"roundpolygon":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);T=this.roundedPolygon(T);O.beginPath();for(var ao=0;ao<T.length;ao++){O.arc(T[ao][0],T[ao][1],T[ao][2],T[ao][3],T[ao][4])}O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"polygon":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T,af=="open"&&aq);this.drawShapeFillStroke(aq,ag,af,O);break;case"spline":var aa=[];var ai=[];var K=[];ai.push(ay.shift());ai.push(ay.shift());K.push(ay.pop());K.unshift(ay.pop());var ah=ay.length;for(var ao=0;ao<ah-4;ao+=2){aa=aa.concat(this.splineControlPoint(ay[ao],ay[ao+1],ay[ao+2],ay[ao+3],ay[ao+4],ay[ao+5]))}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ai[0],ai[1]);O.lineTo(ay[0],ay[1]);O.quadraticCurveTo(aa[0],aa[1],ay[2],ay[3]);for(var ao=2;ao<ah-5;ao+=2){O.bezierCurveTo(aa[2*ao-2],aa[2*ao-1],aa[2*ao],aa[2*ao+1],ay[ao+2],ay[ao+3])}O.quadraticCurveTo(aa[2*ah-10],aa[2*ah-9],ay[ah-2],ay[ah-1]);O.lineTo(K[0],K[1]);O.lineTo(ai[0],ai[1]);this.drawShapeFillStroke(aq,ag,af,O);break;case"hull":var am;var ah=1;var L=[];while(ay.length>1){L.push([ay.shift(),ay.shift()])}var aa=this.hullControlPoints(L);var q=[[L[0][0],L[0][1],aa[aa.length-1][0],aa[aa.length-1][1],aa[0][0],aa[0][1],L[1][0],L[1][1]]];for(var ao=1;ao<L.length-1;ao++){q.push([L[ao][0],L[ao][1],aa[ah][0],aa[ah][1],aa[ah+1][0],aa[ah+1][1],L[ao+1][0],L[ao+1][1]]);ah+=2}q.push([L[ao][0],L[ao][1],aa[ah][0],aa[ah][1],aa[ah+1][0],aa[ah+1][1],L[0][0],L[0][1]]);this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(q[0][0],q[0][1]);for(var ao=0;ao<q.length;ao++){O.bezierCurveTo(q[ao][2],q[ao][3],q[ao][4],q[ao][5],q[ao][6],q[ao][7])}this.drawShapeFillStroke(aq,ag,af,O);break;case"violin":var ah=ay.length;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0][0],ay[1][0]);for(var ao=2;ao<ah;ao+=2){O.lineTo(ay[ao][0],ay[ao+1][0])}O.lineTo(ay[ah-2][1],ay[ah-1][1]);for(var ao=2;ao<ah;ao+=2){var aE=(ah-1)-ao;O.lineTo(ay[aE-1][1],ay[aE][1])}O.lineTo(ay[0][0],ay[1][0]);this.drawShapeFillStroke(aq,ag,af,O);break;case"fish":var ah=ay.length;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0][0],ay[1][0]);for(var ao=2;ao<ah;ao+=2){var A=(ay[ao-2][0]+ay[ao][0])/2;O.bezierCurveTo(A,ay[ao-1][0],A,ay[ao+1][0],ay[ao][0],ay[ao+1][0])}O.lineTo(ay[ah-2][1],ay[ah-1][1]);for(var ao=2;ao<ah;ao+=2){var aE=(ah-1)-ao;var A=(ay[aE+1][1]+ay[aE-1][1])/2;O.bezierCurveTo(A,ay[aE+2][1],A,ay[aE][1],ay[aE-1][1],ay[aE][1])}O.lineTo(ay[0][0],ay[1][0]);this.drawShapeFillStroke(aq,ag,af,O);break;case"confidence":var ah=ay.length;var aa=[];var Q=[];for(var ao=0;ao<ah-4;ao+=2){var aE=(ah-1)-ao;aa=aa.concat(this.splineControlPoint(ay[ao][0],ay[ao+1][0],ay[ao+2][0],ay[ao+3][0],ay[ao+4][0],ay[ao+5][0]));Q=Q.concat(this.splineControlPoint(ay[aE-1][1],ay[aE][1],ay[aE-3][1],ay[aE-2][1],ay[aE-5][1],ay[aE-4][1]))}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0][0],ay[1][0]);O.quadraticCurveTo(aa[0],aa[1],ay[2][0],ay[3][0]);for(var ao=2;ao<ah-5;ao+=2){O.bezierCurveTo(aa[2*ao-2],aa[2*ao-1],aa[2*ao],aa[2*ao+1],ay[ao+2][0],ay[ao+3][0])}O.quadraticCurveTo(aa[2*ah-10],aa[2*ah-9],ay[ah-2][0],ay[ah-1][0]);O.lineTo(ay[ah-2][1],ay[ah-1][1]);O.quadraticCurveTo(Q[0],Q[1],ay[ah-4][1],ay[ah-3][1]);for(var ao=2;ao<ah-5;ao+=2){var aE=(ah-1)-ao;O.bezierCurveTo(Q[2*ao-2],Q[2*ao-1],Q[2*ao],Q[2*ao+1],ay[aE-3][1],ay[aE-2][1])}O.quadraticCurveTo(Q[2*ah-10],Q[2*ah-9],ay[0][1],ay[1][1]);O.lineTo(ay[0][0],ay[1][0]);this.drawShapeFillStroke(aq,ag,af,O);break;case"bezier":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0],ay[1]);O.bezierCurveTo(ay[2],ay[3],ay[4],ay[5],ay[6],ay[7]);O.lineTo(ay[6],ay[7]+ap);O.bezierCurveTo(ay[4],ay[5]+ap,ay[2],ay[3]+ap,ay[0],ay[1]+ap);O.lineTo(ay[0],ay[1]);this.drawShapeFillStroke(aq,ag,af,O);break;case"ellipse":var a=k*0.5522848;var ar=aA*0.5522848;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(0,aA);O.bezierCurveTo(0,aA-ar,k-a,0,k,0);O.bezierCurveTo(k+a,0,Y,aA-ar,Y,aA);O.bezierCurveTo(Y,aA+ar,k+a,ap,k,ap);O.bezierCurveTo(k-a,ap,0,aA+ar,0,aA);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"ellipse2":return this.drawShape("ellipse",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"ellipse3":return this.drawShape("ellipse",W,V,Y,Y/3,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"plus":T=[[-aj,-aA],[aj,-aA],[aj,-aj],[k,-aj],[k,aj],[aj,aj],[aj,aA],[-aj,aA],[-aj,aj],[-k,aj],[-k,-aj],[-aj,-aj],[-aj,-aA]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"minus":T=[[-k,-aj],[k,-aj],[k,aj],[-k,aj],[-k,-aj]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"mdavid":var au=Y/3;var C=Math.PI/6;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(0.8,0.8,O);this.rotateCanvas(M*0.45,O);O.beginPath();O.moveTo(au,0);for(var ao=0;ao<11;ao++){this.rotateCanvas(C,O);if(ao%2==0){O.lineTo((au/0.55),0)}else{O.lineTo(au,0)}}O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"star":var m=(Y/4);var M=Math.PI/5;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(0.7,0.7,O);this.rotateCanvas(M*0.45,O);O.beginPath();O.moveTo(m,0);for(var ao=0;ao<9;ao++){this.rotateCanvas(M,O);if(ao%2==0){O.lineTo((m/0.35),0)}else{O.lineTo(m,0)}}O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"pie":if(typeof(ac)=="undefined"){ac=0}if(typeof(at)=="undefined"){at=Math.PI*2}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),ac,at,false);O.lineTo(0,0);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"pie0":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/5,Z,av);break;case"pie1":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/3.5,Z,av);break;case"pie2":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/2,Z,av);break;case"pie3":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/1.5,Z,av);break;case"pie4":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI,Z,av);break;case"pie5":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.2,Z,av);break;case"pie6":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.4,Z,av);break;case"pie7":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.6,Z,av);break;case"pie8":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.8,Z,av);break;case"pie9":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*2,Z,av);break;case"pacman":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,Math.PI*1/4,Math.PI*7/4,Z,av);break;case"pacman2":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,Math.PI*5/4,Math.PI*3/4,Z,av);break;case"pch0":this.drawShape("square",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch1":this.drawShape("circle",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch2":this.drawShape("equilateral",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch3":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,"open",false,U,O);O.moveTo(0,-aA);this.lineTo(0,-aA,0,aA,O);O.stroke();O.moveTo(-k,0);this.lineTo(-k,0,k,0,O);O.stroke();this.drawShapeFillStroke(aq,ag,af,O);break;case"pch4":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,"open",false,U,O);O.moveTo(-k,-aA);this.lineTo(-k,-aA,k,aA,O);O.stroke();O.moveTo(k,-aA);this.lineTo(k,-aA,-k,aA,O);O.stroke();this.drawShapeFillStroke(aq,ag,af,O);break;case"pch5":this.drawShape("diamond",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch6":this.drawShape("equilateral2",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch7":this.drawShape("pch0",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch4",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch8":this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch4",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch9":this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch5",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch10":this.drawShape("pch1",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch11":this.drawShape("pch2",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch6",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch12":this.drawShape("pch0",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch13":this.drawShape("pch1",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch4",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch14":this.drawShape("pch0",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.drawShape("pch6",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch15":case"pch22":this.drawShape("square",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch16":case"pch21":this.drawShape("circle",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch17":case"pch24":this.drawShape("equilateral",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch18":case"pch23":this.drawShape("diamond",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch19":this.drawShape("circle",W,V,Y+2,Y+2,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch20":this.drawShape("circle",W,V,Math.max(2,Y-2),Math.max(2,Y-2),aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch25":this.drawShape("equilateral2",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;default:this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);break}if(ab=="box"||ab=="rect"){this.drawShapeRestore(Math.round(W),Math.round(V),ad,O)}else{this.drawShapeRestore(W,V,ad,O)}};this.flipImage=function(k){var s=k.naturalWidth;var l=k.naturalHeight;var o=this.imageToCanvas(k);var m=o.ctx.getImageData(0,0,s,l).data;for(var f=0;f<l;f++){var t=l-(f+1);for(var e=0;e<s;e++){var d=parseInt(m[t][e][0]*255);var n=parseInt(m[t][e][1]*255);var p=parseInt(m[t][e][2]*255);var q=m[t][e][3]?parseInt(m[t][e][3]*255):255;o.ctx.fillStyle="rgba("+d+","+n+","+p+","+q+")";o.ctx.fillRect(e,f,1,1)}}return o.toDataURL("img/png")};this.imageToCanvas=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=this.get2DCanvasContext(b);b.ctx.drawImage(a,0,0);return b};this.colorizeImage=function(e,k){var m=this.imageToCanvas(e);var b=k?this.colorAsArray(k):false;var j=m.ctx.getImageData(0,0,e.naturalWidth,e.naturalHeight);var l=j.data;for(var e=0;e<l.length;e+=4){var h=0.34*l[e]+0.5*l[e+1]+0.16*l[e+2];if(h>220){h=255;l[e]=h;l[e+1]=h;l[e+2]=h;l[e+3]=0}else{l[e]=k?b[0]:h;l[e+1]=k?b[1]:h;l[e+2]=k?b[2]:h}}m.ctx.putImageData(j,0,0);return m};this.createImage=function(l){var k=l.length;var q=l[0].length;var n=this.$cX("canvas",{width:q,height:k});n.ctx=this.get2DCanvasContext(n);n.ctx.clearRect(0,0,q,k);for(var f=0;f<k;f++){var s=k-(f+1);for(var e=0;e<q;e++){var d=parseInt(l[s][e][0]*255);var m=parseInt(l[s][e][1]*255);var o=parseInt(l[s][e][2]*255);var p=l[s][e][3]?parseInt(l[s][e][3]*255):255;n.ctx.fillStyle="rgba("+d+","+m+","+o+","+p+")";if(this.scatterType=="visium"&&this.visiumFlip){n.ctx.fillRect(e,f,1,1)}else{n.ctx.fillRect(e,s,1,1)}}}if(this.scatterType=="visium"){this.backgroundImageRows=k;this.backgroundImageCols=q}return n.toDataURL("img/png")};this.drawImage=function(x,v,m,j,y,D,s,p,F,g,o,u){if(!u){u=this.getCanvasContext()}try{v=parseInt(Math.round(v||0));m=parseInt(Math.round(m||0));j=parseInt(Math.round(j||x.naturalWidth));y=parseInt(Math.round(y||x.naturalHeight));if(this.scatterType=="visium"){if(this.visiumFlip){var A=this.xAxisMin;var z=this.xAxisMax;var b=x.naturalHeight-this.yAxisMax;var c=x.naturalHeight-this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=this.yAxisMax;u.scale(a,G);u.drawImage(x,A,n,f,E,v+k,m+B,f,E);u.scale(1/a,1/G)}else{var A=this.xAxisMin;var z=this.xAxisMax;var b=this.yAxisMax;var c=this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=x.naturalHeight-this.yAxisMax;u.scale(a,G);u.drawImage(x,A,n,f,E,v+k,m+B,f,E);u.scale(1/a,1/G)}}else{if(D&&s&&p&&F){D=parseInt(Math.round(D));s=parseInt(Math.round(s));p=parseInt(Math.round(p));F=parseInt(Math.round(F));u.drawImage(x,v,m,j,y,D,s,p,F);u.drawImage(this.colorizeImage(x,g),v,m,j,y,D,s,p,F)}else{if(g&&g=="b&w"){u.drawImage(this.colorizeImage(x),v,m,j,y)}else{if(g){u.drawImage(x,v,m,j,y);u.drawImage(this.colorizeImage(x,g),v,m,j,y)}else{if(o=="round"){var q=Math.max(j,y)/2;this.saveCanvas(u);u.arc(v+q,m+q,q,0,Math.PI*2);u.clip();u.drawImage(x,v,m,j,y);this.restoreCanvas(u);this.setClipArea([0,0,0,0],u);this.restoreCanvas(u)}else{u.drawImage(x,v,m,j,y)}}}}}}catch(C){console.log(C);var d=this;setTimeout(function(){d.draw({func:"drawImage",par:[x,v,m,j,y,D,s,p,F,g]})},100)}};this.trackTransforms=function(k){if(!k){k=this.getCanvasContext()}var f=document.createElementNS("http://www.w3.org/2000/svg","svg");var i=f.createSVGMatrix();k.getTransform=function(){return i};var j=[];var g=k.save;k.save=function(){j.push(i.translate(0,0));return g.call(k)};var h=k.restore;k.restore=function(){i=j.pop();return h.call(k)};var c=k.scale;k.scale=function(n,m){i=i.scaleNonUniform(n,m);return c.call(k,n,m)};var d=k.rotate;k.rotate=function(m){i=i.rotate(m*180/Math.PI);return d.call(k,m)};var b=k.translate;k.translate=function(n,m){i=i.translate(n,m);return b.call(k,n,m)};var a=k.transform;k.transform=function(n,m,s,r,q,p){var o=f.createSVGMatrix();o.a=n;o.b=m;o.c=s;o.d=r;o.e=q;o.f=p;i=i.multiply(o);return a.call(k,n,m,s,r,q,p)};var e=k.setTransform;k.setTransform=function(n,m,r,q,p,o){i.a=n;i.b=m;i.c=r;i.d=q;i.e=p;i.f=o;return e.call(k,n,m,r,q,p,o)};var l=f.createSVGPoint();k.transformedPoint=function(m,n){l.x=m;l.y=n;return l.matrixTransform(i.inverse())}};this.setGlobalCompositionOperation=function(b,a){if(!CanvasXpress.system.isIE&&b){if(!a){a=this.getCanvasContext()}a.globalCompositeOperation=b;this.meta.state.globalCompositeOperation=b}};this.rectangleClear=function(a,e,c,d,b){if(!b){b=this.getCanvasContext()}b.clearRect(a,e,c,d)};this.translateCanvas=function(a,c,b){if(!b){b=this.getCanvasContext()}b.translate(a,c);this.meta.state.translate[0]+=a;this.meta.state.translate[1]+=c};this.rotateCanvas=function(b,a){if(!a){a=this.getCanvasContext()}a.rotate(b);this.meta.state.rotate[0]+=b};this.scaleCanvas=function(a,c,b){if(!b){b=this.getCanvasContext()}b.scale(a,c);this.meta.state.scale[0]*=a;this.meta.state.scale[1]*=c};this.saveCanvas=function(a){if(!a){a=this.getCanvasContext()}a.save();this.meta.state.save++;this.meta.state.last={translate:[this.meta.state.translate[0],this.meta.state.translate[1]],scale:[this.meta.state.scale[0],this.meta.state.scale[1]],rotate:[this.meta.state.rotate[0]]}};this.restoreCanvas=function(a){if(!a){a=this.getCanvasContext()}a.restore();this.meta.state.translate[0]=this.meta.state.last.translate[0];this.meta.state.translate[1]=this.meta.state.last.translate[1];this.meta.state.scale[0]=this.meta.state.last.scale[0];this.meta.state.scale[1]=this.meta.state.last.scale[1];this.meta.state.rotate[0]=this.meta.state.last.rotate[0];this.meta.state.save--}};CanvasXpress.prototype.initRangeAlgorithms=function(){this.approxNumber=function(g){if(g==undefined){g=0}var e=g;var d=g.toString();var j=d.indexOf("999999");var h=d.indexOf("000000");var i=d.indexOf(".");var b=j>=0&&i<j?j:h>=0?h:null;if(b!=null){e=d.substring(0,b);f=Math.pow(10,e.length-(e.indexOf(".")+1));return Number(Math.round(Number(d)*f)/f)}else{return Number(d)}};this.heckbert=function(d,l,b){var c=function(i,n){var p;var q=Math.floor(Math.log(i)/Math.LN10);var o=i/Math.pow(10,q);if(n){if(o<1.5){p=1}else{if(o<3){p=2}else{if(o<7){p=5}else{p=10}}}}else{if(o<1){p=1}else{if(o<2){p=2}else{if(o<5){p=5}else{p=10}}}}return p*Math.pow(10,q)};if(d>l){var g=l;d=l;d=g}else{if(l-d<1e-8){l+=0.1}}var k=[];var h=c(l-d,false);var m=c(h/(b-1),true);var a=Math.floor(d/m)*m;var j=Math.ceil(l/m)*m;for(var e=a;e<=j;e+=m){k.push(this.approxNumber(e))}if(k[0]==k[k.length-1]){var k=[];for(var e=a;e<=j;e+=m){k.push(e)}}return this.cleanVals(k)};this.wilkinson=function(c,j,a){var b=function(A,C,B,z){var v=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var x=C-A;var s=B-1;var p=1-Math.abs(B-z)/z;var E=x/s;var u=Math.floor(Math.log(E)/Math.LN10);var F=Math.pow(10,u);var q=null;for(var D=0;D<v.length;D++){var t=v[D]*F;var G=Math.floor(A/t)*t;var n=G+s*t;if(G<=A&&n>=C){var w=1-(D-(G<=0&&n>=0?1:0))/v.length;var r=(C-A)/(n-G);if(r>0.8){var y=p+w+r;if(q==null||y>q.score){q={lmin:G,lmax:n,lstep:t,score:y}}}}}if(!q){q={lmin:A,lmax:C,lstep:1,score:0}}return q};if(c>j){var h=j;c=j;c=h}else{if(j-c<1e-8){}}var l=[];var e=null;var m=[];for(var g=Math.max(Math.floor(a/2),2);g<=Math.ceil(6*a);g++){m.push(g)}for(var g=0;g<m.length;g++){var d=m[g];var o=b(c,j,d,a);if((o!=null&&e==null)||(o&&e&&o.score>e.score)){e=o}}for(var g=e.lmin;g<=e.lmax;g+=e.lstep){l.push(this.approxNumber(g))}if(l[0]==l[l.length-1]){var l=[];for(var g=e.lmin;g<=e.lmax;g+=e.lstep){l.push(g)}}return this.cleanVals(l)};this.wilkinsonExtended=function(a,A,S,D){var B=2.22e-14;var h=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var K=function(c,w,m,g,z,Z){var k=w.length;var s=h(c,w);var aa=(g%Z<B||Z-(g%Z)<B)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+aa};var L=function(s,m,g){var w=m.length;var k=h(s,m);var c=1;return 1-k/(w-1)-g+c};var l=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var t=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var p=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var Y=function(g,c){return g>=c?2-(g-1)/(c-1):1};var e=[1,5,2,2.5,4,3];var H=[0.25,0.2,0.5,0.05];var R=e.length;var M={score:-2};var I=[];if(a>A){var o=a;a=A;A=o}else{if(A-a<1e-8){}}var U=1;while(U<Number.POSITIVE_INFINITY){for(var V=0;V<R;V++){var O=e[V];var v=L(O,e,U);if((H[0]*v+H[1]+H[2]+H[3]<M.score)){U=Number.POSITIVE_INFINITY;break}var T=2;while(T<Number.POSITIVE_INFINITY){var r=Y(T,S);if((H[0]*v+H[1]+H[2]*r+H[3]<M.score)){break}var F=(A-a)/(T+1)/U/O;var G=Math.ceil(Math.log(F)/Math.LN10);while(G<Number.POSITIVE_INFINITY){var E=U*O*Math.pow(10,G);var C=t(a,A,E*(T-1));if((H[0]*v+H[1]*C+H[2]*r+H[3]<M.score)){break}var x=Math.floor(A/E)*U-(T-1)*U;var P=Math.ceil(a/E)*U;if(x>P){G++;continue}for(var y=x;y<=P;y++){var u=y*(E/U);var N=u+E*(T-1);var d=E;var J=K(O,e,U,u,N,d);var X=l(a,A,u,N);var W=p(T,S,a,A,u,N);var b=H[0]*J+H[1]*X+H[2]*W+H[3];if(b>M.score&&(!D||(u<=a&&N>=A))){M={lmin:u,lmax:N,lstep:d,score:b}}}G++}T++}}U++}for(var V=M.lmin;V<=M.lmax;V+=M.lstep){I.push(this.approxNumber(V))}if(I[0]==I[I.length-1]){var I=[];for(var V=M.lmin;V<=M.lmax;V+=M.lstep){I.push(V)}}return this.cleanVals(I)};this.rPrettyOLD=function(p,q,s){if(p>q){var x=q;q=p;p=x}else{if(q-p<1e-8){q+=0.1}}var a,e,b;var o=[];var r=Math.floor(s)-1;var t=Math.floor(r%3);var j=0.75;var w=1.5;var d=0.5+1.5*w;var g=q-p;if(g==0&&q==0){a=1;e=true;b=1}else{a=Math.max(Math.abs(p),Math.abs(q));b=1+d>=1.5*w+0.5?1/(1+w):1.5/1+d;e=g<(a*b*Math.max(1,r)*1e-7*3)}if(e){if(a>10){a=9+a/10}a=a*j;if(t>1){a/=t}}else{a=g;if(r>1){a/=r}}if(a<20*1e-7){a=20*1e-7}var c=Math.pow(10,Math.floor(Math.log(a)/Math.LN10));var l=c;if((2*c)-a<w*(a-l)){l=2*c;if((5*c)-a<d*(a-l)){l=5*c;if((10*c)-a<w*(a-l)){l=10*c}}}var z=Math.floor(p/l+1e-7);var y=Math.ceil(q/l-1e-7);while(z*l>p+(1e-7*l)){z--}while(y*l<q-(1e-7*l)){y++}var u=Math.floor(0.5+y-z);if(u<t){u=t-u;if(z>=0){y+=u/2;z=z-u/2+u%2}else{z-=u/2;y=y+u/2+u%2}r=t}else{r=u}for(var v=z*l;v<=y*l;v+=l){o.push(this.approxNumber(v))}if(o[0]==o[o.length-1]){var o=[];for(var v=z*l;v<=y*l;v+=l){o.push(v)}}return this.cleanVals(o)};this.rPretty=function(j,l,y){if(j>l){var x=l;l=j;j=x}var u=Math.floor(y%3);var g=0.75;var w=1.5;var e=0.5+1.5*w;var v=2e-20;var i=0;var b,r,c;var n=CanvasXpress.constants.DBL_EPSILON;var t=1.25;var a=1e-10;var m=l-j;if(m==0&&l==0){b=1;r=true}else{b=Math.max(Math.abs(j),Math.abs(l));c=1+((e>=1.5*w+0.5)?1/(1+w):1.5/(1+e));c*=parseInt(Math.max(1,y))*n;r=m<b*c*3}if(r){if(b>10){b=9+b/10}b*=g;if(u>1){b/=u}}else{b=m;if(isFinite(m)){if(y>1){b/=y}else{if(y<2){b=l*0.5}else{b=l/y-j/y}}}}var q=v*Number.MIN_VALUE;if(q==0){q=Number.MIN_VALUE}if(b<q){alert("Error in rPretty: very small range");b=q}else{if(b>Number.MAX_VALUE/t){alert("Error in rPretty: very large range");b=Number.MAX_VALUE/t}}var d=Math.pow(10,Math.floor(Math.log10(b)));var p=d;if((2*d)-b<w*(b-p)){p=2*d;if((5*d)-b<e*(b-p)){p=5*d;if((10*d)-b<w*(b-p)){p=10*d}}}var A=Math.floor(j/p+a);var z=Math.ceil(l/p-a);if(i&&(i>1||!r)){if(j!=0){j*=(1-n)}else{j=-Number.MIN_VALUE}if(l!=0){l*=(1+n)}else{l=Number.MIN_VALUE}}while(A*p>j+(a*p)){A--}while(!isFinite(A*p)){A++}while(z*p<l-(a*p)){z++}while(!isFinite(A*p)){A--}var s=Math.floor(0.5+z-A);if(s<u){s=u-s;if(j==0&&A==0&&l!=0){z+=s}else{if(l==0&&z==0&&j!=0){A-=s}else{if(A>=0){z+=s/2;A-=s/2+s%2}else{A-=s/2;z+=s/2+s%2}}}y=u}else{y=s}if(A*p<j){j=A*p}if(z*p>l){l=z*p}var o=this.seq(j,l,false,y+1);return this.cleanVals(o)}};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.modifyObjectArray=function(c,g,h,f,j){if(this.isTransition()){return}var e=this[h];if(f){var a={};if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(e.includes(d)){e=this.removeFromArray(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.draw({func:"modifyObjectArray",par:[c,g,h,f,j]})}};this.getObjectArray=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.getObjectArrayOrder=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]+""]=c}}return d};this.intersectArray=function(e,d){var h=[];if(!this.isArray(e)){e=this.toArray(e)}var f=this.getObjectArray(this.toArray(d));for(var g=0;g<e.length;g++){if(f.hasOwnProperty(e[g].toString())){h.push(e[g])}}return h};this.removeFromArray=function(e,b){if(this.isArray(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.isFunction=function(a){return a&&typeof a==="function";var b={};return a&&b.toString.call(a)==="[object Function]"};this.isArray=function(a){return Array.isArray(a)};this.isObject=function(a){return a instanceof Object};this.isUnique=function(b){return this.getUniqueEls(b).length==b.length};this.isBoolean=function(b){var d=b.length;if(this.isR){for(var c=0;c<d;c++){if(this.isObject(b[c])){return false}else{if(b[c]==null){continue}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}}}}}else{for(var c=0;c<d;c++){if(this.isObject(b[c])){return false}else{if(b[c]!==true&&b[c]!==false&&b[c]!==""&&b[c]!==null){return false}}}}return true};this.toArray=function(a){return this.isArray(a)?a:[a]};this.getKeys=function(a){return this.isArray(a)?a:this.isObject(a)?Object.keys(a):[]};this.unique=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return Object.keys(a)}else{return[a]}}};this.getUniqueEls=function(b){var g=b.length;var f=[];var e=new Set();for(var d=0;d<g;d++){var c=b[d];if(e.has(c)){continue}e.add(c);f.push(c)}return f};this.getUniqueKeys=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.shuffleArray=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.random()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.toNumber=function(c){var f=[];var d=this.isArray(c);c=this.toArray(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.zip=function(d,c){return d.map(function(b,a){return[d[a],c[a]]})};this.unzip=function(b,a){return b.map(function(d,c){return d[a]})};this.extend=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.cloneObjectR=function(c,a){var b=this;if(c==null||typeof(c)!="object"){return c}if(this.isArray(c)){return c.map(function(d){return b.isArray(d)?d.slice():b.cloneObjectR(d,a)})}else{if(a){return this.isObject(c)?Object.assign({},c):this.parseJSON(this.stringifyJSON(c))}else{return this.parseJSON(this.stringifyJSON(c))}}};this.cloneObject=function(f,e){var d={bubble:true,gantt:true,sankey:true,tree:true};if(this.isObject(f)&&f.config&&f.config.decorations&&f.config.decorations.marker){var a=f.config.decorations.marker;for(var c=0;c<a.length;c++){a[c].text=a[c].text.replace(/\n/g,"__nl__")}}if(typeof f!=="object"){return f}if(!f){return f}if(Object.prototype.toString.apply(f)==="[object Array]"){var g=[];var b=f.length;for(var c=0;c<b;c++){g[c]=this.cloneObject(f[c])}return g}var g={};for(c in f){if(e&&d.hasOwnProperty(c)){continue}if((f[c]&&f.hasOwnProperty(c))||f[c]===false||f[c]===0){g[c]=this.cloneObject(f[c],c=="data")}}return g};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.isNumber=function(b,a){if(a){return !isNaN(parseFloat(b))&&isFinite(b)}else{return b===null||b===undefined?true:!isNaN(parseFloat(b))&&isFinite(b)}};this.toNumber=function(a){if(this.isNumber(a,true)){return a}else{return Number.NaN}};this.isNumeric2DArray=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.isNumber(a[d][b])){return false}}}return true};this.isNumeric=function(a){var c=a.length;for(var b=0;b<c;b++){if(!this.isNumber(a[b])){return false}}return true};this.isNull=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null){return false}}return true};this.isEmpty=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!==""){return false}}return true};this.isDate=function(a){var c=function(e){if(toString.call(e)==="[object Date]"){return true}if(typeof e.replace==="function"){e.replace(/^\s+|\s+$/gm,"")}var g=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return g.test(e)};var d=a.length;for(var b=0;b<d;b++){if(a[b]!=null&&!c(a[b])){return false}}return true};this.isMonthDay=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null&&!CanvasXpress.dates.hasOwnProperty(a[b])){return false}}return true};this.isCountry=function(a){var b=function(e){return CanvasXpress.countries.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]!=null&&!b(a[c])){return false}}return true};this.isUsa=function(a){var b=function(e){return CanvasXpress.usa.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]!=null&&!b(a[c])){return false}}return true};this.padNumber=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.isCountourable=function(){if(this.graphType=="Heatmap"){if(this.meta.tree){return false}else{if(this.varOverlays.length+this.smpOverlays.length>0){return false}else{if(this.isMultidimensionalData){return false}}}return true}};this.isPivotable=function(){var b=this.data.y.vars.length;var c=this.data.x?this.getKeys(this.data.x):[];var a=c.length;return(this.data.x||b+a==3)?true:false};this.pivotMatrix=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.stringRangeSort(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.transposeDataMatrix=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.filterNumbers=function(a,c){var d=[];var e=a.length;for(var b=0;b<e;b++){if(this.isNumber(a[b],c)){d.push(a[b])}}return d};this.cleanArray=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.filterNumbers(d,true)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.filterNumbers(d,true)}else{d=this.filterNumbers(b,true)}}return d};this.cleanArrays=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.smpIndices[f]],h[this.smpIndices[f]]],true);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.varIndices[f]],h[this.varIndices[f]]],true);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[f],h[f]],true);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.reverseArray=function(a){tmp=a.reverse();return tmp};this.parseInt=function(a){return((a+0.5)<<1)>>1};this.ungroupGroupedData=function(){return this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Gantt")};this.getIpRangeFromAddressAndNetmask=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.int2Ip=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.ip2Int=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.md5=function(b){var d=function(o,q){var p=o[0];var n=o[1];var s=o[2];var r=o[3];p=a(p,n,s,r,q[0],7,-680876936);r=a(r,p,n,s,q[1],12,-389564586);s=a(s,r,p,n,q[2],17,606105819);n=a(n,s,r,p,q[3],22,-1044525330);p=a(p,n,s,r,q[4],7,-176418897);r=a(r,p,n,s,q[5],12,1200080426);s=a(s,r,p,n,q[6],17,-1473231341);n=a(n,s,r,p,q[7],22,-45705983);p=a(p,n,s,r,q[8],7,1770035416);r=a(r,p,n,s,q[9],12,-1958414417);s=a(s,r,p,n,q[10],17,-42063);n=a(n,s,r,p,q[11],22,-1990404162);p=a(p,n,s,r,q[12],7,1804603682);r=a(r,p,n,s,q[13],12,-40341101);s=a(s,r,p,n,q[14],17,-1502002290);n=a(n,s,r,p,q[15],22,1236535329);p=i(p,n,s,r,q[1],5,-165796510);r=i(r,p,n,s,q[6],9,-1069501632);s=i(s,r,p,n,q[11],14,643717713);n=i(n,s,r,p,q[0],20,-373897302);p=i(p,n,s,r,q[5],5,-701558691);r=i(r,p,n,s,q[10],9,38016083);s=i(s,r,p,n,q[15],14,-660478335);n=i(n,s,r,p,q[4],20,-405537848);p=i(p,n,s,r,q[9],5,568446438);r=i(r,p,n,s,q[14],9,-1019803690);s=i(s,r,p,n,q[3],14,-187363961);n=i(n,s,r,p,q[8],20,1163531501);p=i(p,n,s,r,q[13],5,-1444681467);r=i(r,p,n,s,q[2],9,-51403784);s=i(s,r,p,n,q[7],14,1735328473);n=i(n,s,r,p,q[12],20,-1926607734);p=f(p,n,s,r,q[5],4,-378558);r=f(r,p,n,s,q[8],11,-2022574463);s=f(s,r,p,n,q[11],16,1839030562);n=f(n,s,r,p,q[14],23,-35309556);p=f(p,n,s,r,q[1],4,-1530992060);r=f(r,p,n,s,q[4],11,1272893353);s=f(s,r,p,n,q[7],16,-155497632);n=f(n,s,r,p,q[10],23,-1094730640);p=f(p,n,s,r,q[13],4,681279174);r=f(r,p,n,s,q[0],11,-358537222);s=f(s,r,p,n,q[3],16,-722521979);n=f(n,s,r,p,q[6],23,76029189);p=f(p,n,s,r,q[9],4,-640364487);r=f(r,p,n,s,q[12],11,-421815835);s=f(s,r,p,n,q[15],16,530742520);n=f(n,s,r,p,q[2],23,-995338651);p=l(p,n,s,r,q[0],6,-198630844);r=l(r,p,n,s,q[7],10,1126891415);s=l(s,r,p,n,q[14],15,-1416354905);n=l(n,s,r,p,q[5],21,-57434055);p=l(p,n,s,r,q[12],6,1700485571);r=l(r,p,n,s,q[3],10,-1894986606);s=l(s,r,p,n,q[10],15,-1051523);n=l(n,s,r,p,q[1],21,-2054922799);p=l(p,n,s,r,q[8],6,1873313359);r=l(r,p,n,s,q[15],10,-30611744);s=l(s,r,p,n,q[6],15,-1560198380);n=l(n,s,r,p,q[13],21,1309151649);p=l(p,n,s,r,q[4],6,-145523070);r=l(r,p,n,s,q[11],10,-1120210379);s=l(s,r,p,n,q[2],15,718787259);n=l(n,s,r,p,q[9],21,-343485551);o[0]=e(p,o[0]);o[1]=e(n,o[1]);o[2]=e(s,o[2]);o[3]=e(r,o[3])};var k=function(v,p,o,n,u,r){p=e(e(p,v),e(n,r));return e((p<<u)|(p>>>(32-u)),o)};var a=function(p,o,v,u,n,r,q){return k((o&v)|((~o)&u),p,o,n,r,q)};var i=function(p,o,v,u,n,r,q){return k((o&u)|(v&(~u)),p,o,n,r,q)};var f=function(p,o,v,u,n,r,q){return k(o^v^u,p,o,n,r,q)};var l=function(p,o,v,u,n,r,q){return k(v^(o|(~u)),p,o,n,r,q)};var j=function(q){txt="";var t=q.length;var r=[1732584193,-271733879,-1732584194,271733878];var p;for(p=64;p<=q.length;p+=64){d(r,m(q.substring(p-64,p)))}q=q.substring(p-64);var o=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(p=0;p<q.length;p++){o[p>>2]|=q.charCodeAt(p)<<((p%4)<<3)}o[p>>2]|=128<<((p%4)<<3);if(p>55){d(r,o);for(p=0;p<16;p++){o[p]=0}}o[14]=t*8;d(r,o);return r};var m=function(o){var p=[];var n;for(n=0;n<64;n+=4){p[n>>2]=o.charCodeAt(n)+(o.charCodeAt(n+1)<<8)+(o.charCodeAt(n+2)<<16)+(o.charCodeAt(n+3)<<24)}return p};var h="0123456789abcdef".split("");var g=function(q){var p="";var o=0;for(;o<4;o++){p+=h[(q>>(o*8+4))&15]+h[(q>>(o*8))&15]}return p};var c=function(n){for(var o=0;o<n.length;o++){n[o]=g(n[o])}return n.join("")};var e=function(o,n){return(o+n)&4294967295};return c(j(this.stringifyJSON(b)))}};CanvasXpress.prototype.initPlotUtils=function(){this.drawLayoutCanvasCompartments=function(){var n=this.canvasBoxColor;var m=this.height;var s=this.width;var g=this.left;var d=this.right;var p=this.bottom;var u=this.top;var j=this.marginLeft;var e=this.marginRight;var q=this.marginBottom;var a=this.marginTop;var o=this.layoutLeft;var k=this.layoutRight;var f=this.layoutBottom;var i=this.layoutTop;this.toRender({p:["drawShape","rectangle",(j+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,n,"open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u)+(this.y/2),this.x,this.y,false,"red","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g+this.x)+(d/2),(a+this.offsetY+u)+(this.y/2),d,this.y,false,"blue","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX)+(g/2),(a+this.offsetY+u)+(this.y/2),g,this.y,false,"blue","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY)+(u/2),this.x,u,false,"blue","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u+this.y)+(p/2),this.x,p,false,"blue","open"],t:"Size"});return};this.drawCanvasBox=function(a){if(this.canvasBox&&(this.graphType!="Network"||a)){this.toRender({p:["disableGradientTransparencyShadow"],t:"Size"});this.toRender({p:["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.canvasBoxColor,"open"],t:"Size"});this.toRender({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.drawPlotWindow=function(){if(this.backgroundType.match("window")){this.toRender({p:["disableGradientTransparencyShadow"],t:"Size"});var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(!this.layoutValid){this.toRender({p:["drawShape","rectangle",this.width*0.5,this.height*0.5,this.width,this.height,this.background,this.background],t:"Size"})}if(this.backgroundType=="windowSolidGradient"){var d=this.getLinearGradient(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b);this.toRender({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,d,d],t:"Size"})}else{if(this.backgroundType=="windowImage"){this.toRender({p:["drawShape","image",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{var e=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.backgroundWindow;this.toRender({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,e,e],t:"Size"})}}this.toRender({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.validateSegregation=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.removeMenus();alert(e);return false}return true};this.checkSegregation=function(){if(!this.isDOE){if(this.validateSegregation()){if(this.layoutValid&&this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.segregateSamples(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.segregateVariables(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.segregateSamplesVariables(true)}else{if(this.segregateSamplesBy.length>0){this.segregateSamples(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.segregateVariables(this.segregateVariablesBy,true)}}}}}}};this.validateOverlays=function(){if(this.smpOverlays.length>0){var a=[];for(var b=0;b<this.smpOverlays.length;b++){if(this.smpOverlays[b]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[b]))){a.push(this.smpOverlays[b])}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var b=0;b<this.varOverlays.length;b++){if(this.varOverlays[b]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[b]))){a.push(this.varOverlays[b])}}this.varOverlays=a}};this.isDotplotGraph=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.isAttributedGraph=function(){return this.colorBy||this.shapeBy||this.sizeBy||this.lineBy||this.patternBy};this.isSegregatable=function(){var a=this;var b=function(){if(a.isTransitionOn){CanvasXpress.transitions[a.target].push([a.isSegregatable]);return true}else{return false}};return !b()&&!this.isDOE&&!CanvasXpress.graphTypes.NonSegregatable.includes(this.graphType)};this.isDOEable=function(){if(this.graphType.match(/Gantt|Circular|Fish|Meter|Network|Correlation|Genome|Pie|Scatter3D|TagCloud|Venn/)||this.is3DPlot||this.scatterPlotMatrix||this.isContour||this.isOncoprint){return false}return true};this.validateNetworkDecorations=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}}};CanvasXpress.prototype.initConfigUtils=function(){this.encode=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.decode=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.getFileName=function(a){return a?a.substring(a.lastIndexOf("/")+1):"canvasXpress"};this.getTitleSubtitleHeight=function(){var b=0;var a;this.setTitleSubtitleFont();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.getFontPt(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.getFontPt(this.subtitleFont))*a.length}b+=this.margin}return b};this.setTitleSubtitleFont=function(){this.setPropertyFontSize(this.width,"titleFont");this.adjustFont(this.title,"titleFont",this.width);this.setPropertyFontSize(this.width,"subtitleFont");this.adjustFont(this.subtitle,"subtitleFont",this.width)};this.drawTitle=function(){this.setTitleSubtitleFont();if(this.title){var a=this.title.split(/\n/);var c=this.marginTop+((this.getFontPt(this.titleFont)+this.margin)*a.length);if(this.subtitle){a=this.subtitle.split(/\n/);c+=(this.getFontPt(this.subtitleFont)+this.margin)*a.length}if(this.titleColorBackground){this.toRender({p:["drawShape","rectangle",this.width/2,c/2,this.width,c,this.titleColorBackground,this.titleColorBackground],t:"Titles"})}var b=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;var d=this.marginTop+(this.measureTextWidth(this.title,this.titleFont)/2);this.toRender({p:["drawText",this.title,b,d,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"],t:"Titles"});if(this.subtitle){b=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.toRender({p:["drawText",this.subtitle,b,d+(this.getFontPt(this.titleFont)/2)+this.margin+(this.getFontPt(this.subtitleFont)/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"],t:"Titles"})}}};this.getCitationHeight=function(){var b=0;var a;this.setCitationFont();if(this.citation){a=this.citation.split(/\n/);b+=(this.margin+this.getFontPt(this.citationFont))*a.length;b+=this.margin}return b};this.setCitationFont=function(){var b=20*this.printMagnification;this.setPropertyFontSize(this.width,"citationFont",b);var a=this.measureText(this.citation,this.citationFont);var c=1;while(a>this.width||c>9){b/=2;this.setPropertyFontSize(this.width,"citationFont",b);a=this.measureText(this.citation,this.citationFont);c++}return};this.drawCitation=function(){if(this.citation){var a=this.width-this.margin;var b=this.height-this.margin;this.toRender({p:["drawText",this.citation,a,b,this.citationFont,this.citationColor,"right","bottom"],t:"Citations"})}};this.getFontHeight=function(){this.setMainFont();return this.getFontPt(this.font)};this.setMainFont=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.setPropertyFontSize=function(h,f,c){if(!h||!f){return}var a=5;var e={titleFont:a+4,subtitleFont:a+2,decorationsTextFont:a,axisTickFont:a,axisTitleFont:a,smpLabelFont:a,smpTitleFont:(this.graphType=="Meter"?a+4:a),varLabelFont:a,varTitleFont:a,legendTextFont:a,legendTitleFont:a,overlayFont:a-6,citationFont:a-10,motionCurrentFont:a+50};var g=f.replace("Font","ScaleFontFactor");this[f+"Size"]=Math.min(Math.max(parseInt((h/30)*this[g])+e[f],this.minTextSize),c||this.maxTextSize);this[f]=this[f+"Style"]+" "+this[f+"Size"]+"px "+this.fontName};this.adjustFont=function(b,c,g){if(b&&c&&g){var e=this.getFontPt(this[c]);var a=this.measureText(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.measureText(b,this[c])}}};this.setAspectRatioProperties=function(d){if(this.adjustAspectRatio&&this.graphType!="Genome"){var a=this.meta.config.orig;var e=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize","layoutLabelBoxThickness"];var f=["legendTextMargin","legendTitleMargin","axisTickMargin","axisTitleMargin","xAxisTickGuideLength","yAxisTickGuideLength","zAxisTickGuideLength"];for(var b=0;b<f.length;b++){e.push(f[b])}if(this.adjustAspectRatioHeatmapIndicator){e.push("heatmapIndicatorHeight");e.push("heatmapIndicatorWidth")}if(d){for(var b=0;b<e.length;b++){if(a[e[b]]){this[e[b]]=a[e[b]];delete (a[e[b]])}}}else{for(var b=0;b<e.length;b++){if(!a[e[b]]){a[e[b]]=this[e[b]]}}for(var b=0;b<e.length;b++){this[e[b]]=Number(Math.max(0.5,Math.min(this.width,this.height)*this[e[b]]/833).toFixed(1))}if(this.isDOE||(this.layoutValid&&this.graphType.match(/Scatter/)&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/Density|Histogram|all/))){this.dataPointSize=Number(Math.max(0.5,this.dataPointSize/Math.max(this.layoutRows,this.layoutCols)).toFixed(1))*(this.isDOE?1.5:1)}}}};this.resetAspectRatioProperties=function(){if(this.adjustAspectRatio&&this.graphType!="Genome"){if(this.graphType=="Network"&&!this.isLayoutDone){this.setTimeout(this.resetAspectRatioProperties,50)}else{this.setAspectRatioProperties(true)}}};this.getGroupColor=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];if(a){this.isGroupedData=false;h=this.getPropertyValue(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.getPropertyValue(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.foreground}}this.isGroupedData=true}else{h=this.getPropertyValue(b,e,"colorBy")}}else{h=this.getPropertyValue(b,e,"colorBy")}return h};this.getVarColor=function(a,c){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varLabelFontColor};this.getSmpColor=function(c,b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpLabelColor};this.getNodeColor=function(e,a){if(this.isArray(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==e){return this.nodeHighlightColor}}}else{if(this.highlightNode==e){return this.nodeHighlightColor}}var d=this.isSelected(e);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!d;return d&&this.selectionMode=="highlight"?this.selectionColor:b?this.addColorTransparency(a,0.1,true):a?a:this.nodeColor};this.getEdgeColor=function(f,d,a){if(this.isArray(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==f||this.highlightNode[c]==d){return this.nodeHighlightColor}}}else{if(this.highlightNode==f||this.highlightNode==d){return this.nodeHighlightColor}}var e=this.isSelected(f)||this.isSelected(d);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!e;return e&&this.selectionMode=="highlight"?this.selectionColor:b?this.addColorTransparency(a,0.1,true):a?a:this.nodeColor};this.getDendrogramColor=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.getVariableIndices(a);if(b>-1){return this.getPropertyValue(b,false,"colorVarDendrogramBy")}}return this.getVarColor(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.getSampleIndices(c);if(b>-1){return this.getPropertyValue(false,b,"colorSmpDendrogramBy")}}return this.getSmpColor(c,true)}};this.isStringOverlays=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.isUniqueFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.isNumericFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.isStringFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.getBestSizes=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.cloneObject(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.isBinConfigurations=function(){for(var a in this.binConfigurations){return true}return false};this.initValidity=function(){var i=this.hexToString("686578546f537472696e67");var g=this[i]("666163746f7279");var f=this[i]("636c69656e74");var d=this[i]("656e636f6465");var j=this[i]("76616c6964");var k=this[i]("757365724964");var a=this[i]("76657273696f6e");var e=this[i]("68726566");var b=this[i]("736574506978656c496d616765");CanvasXpress[g][f]=this[d]([CanvasXpress[g][j]||0,this[k],CanvasXpress[g][a],this[e]].join("::"));this[b]()};this.getWorstAspectRatio=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.adjustTreemapCoords=function(f,e){if(f){var c=this.treemapBorderWidth&&!this.isDOE?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpLabelFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.setTreemapRowVerticalLayout=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.adjustTreemapCoords(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.setTreemapRowHorizontalLayout=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.adjustTreemapCoords(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.setTreemapRowLayout=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.setTreemapRowVerticalLayout(a,b,c,d)}else{return this.setTreemapRowHorizontalLayout(a,b,c,d)}};this.computeTreemapDimensions=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.adjustTreemapCoords(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.setTreemapRowLayout(c,b,f,h)}return}var d=a[0];if(this.getWorstAspectRatio(c,b)>=this.getWorstAspectRatio([d].concat(c),b)){this.computeTreemapDimensions(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.setTreemapRowLayout(c,b,f,h);this.computeTreemapDimensions(a,[],g.orientation,g,d.title)}};this.squarifyTreemap=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.computeTreemapDimensions(a.slice(1),[a[0]],c,g,a[0].title)};this.processTreemap=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.squarifyTreemap(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.processTreemap(a,d)}}return b};this.getCloudPointsAtRadius=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){var e=1;if(this.tagCloudShapeFunction!=="circle"){e=this.tagCloudShapeFunction(c/b*2*Math.PI)}d.push([this.tagCloudGridCenter[0]+a*e*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*e*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.getCloudRotateDeg=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.random()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.random()*Math.PI)};this.getCloudTextInfo=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=this.$cX("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.measureText(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.canFitCloudText=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fillCloudGridAt=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.updateCloudGrid=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fillCloudGridAt(e+a[b][0],c+a[b][1])}};this.drawCloudTag=function(c,i,g,d){var k=this;var m=this.getCloudRotateDeg();var e=this.getCloudTextInfo(c,i,m);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var j=this.addColorTransparency(g,0,true);var f=this.get1DLeft();var p=this.get1DTop();while(a--){var n=this.getCloudPointsAtRadius(this.tagCloudGridMaxRadius-a);n=[].concat(n);this.shuffleArray(n);var h=n.some(function o(q){var w=Math.floor(q[0]-e.gw/2);var v=Math.floor(q[1]-e.gh/2);var z=e.gw;var s=e.gh;var r=e.fontSize+"px "+k.fontName;var l="1px "+k.fontName;if(!k.canFitCloudText(w,v,z,s,e.occupied)){return false}var u=((w+e.gw/2)*k.tagCloudTextGridSize);var t=((v+e.gh/2)*k.tagCloudTextGridSize);k.renderTagCloud.push([["drawText",c,u+f,t+p,r,g,"center","middle",-m],d,false,null,false,[k.width/2,k.height/2,l,j,-Math.PI*2]]);k.updateCloudGrid(w,v,e);return true});if(h){return true}}return false};this.setTagCloud=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize);this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.setTagCloudTextWeightFactor()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.setTagCloudTextWeightFactor=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.getDataAtPos(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.x,this.y));if(h>b){this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.tryRenderTagCloud=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.setTagCloud(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.getDataAtPos(j,a);var k=this.colorBy?this.getPropertyValue(j,a,"colorBy"):this.foreground;if(!this.drawCloudTag(this.data.y.smps[a],h,k,[j,a])){this.resizeCanvas();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.tryRenderTagCloud(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.getVariableColor=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.getOutlineColor=function(b,a,g){var i;if((this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)||(this.useOpenShapes&&!g)){i=this.removeColorTransparency(b,true)}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){var d=this.layoutValid?this.data.y.vars.length*this.data.y.smps.length:this.varIndices.length*this.smpIndices.length;if(d>this.dotplotOutlineThreshold){i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor}else{i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor?this.objectBorderColor:this.removeColorTransparency(b,true)}}else{i=this.objectBorderColor&&this.graphType!="Map"?this.objectBorderColor:this.removeColorTransparency(b,true)}}if(a){var f=this.isSelected(a);var e=this.isVarHighlughted(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;i=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.addColorTransparency(i,0.1,true):i}return i};this.getFillColor=function(b,a,g){var i=(this.useOpenShapes&&!g)&&(!this.isDOE||!this.layoutCurrent);var j=this.addColorTransparency(b,(i?0:this.objectColorTransparency),true);if(a){var f=this.isSelected(a);var e=this.isVarHighlughted(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;j=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.addColorTransparency(j,0.1,true):j}return j};this.isVarHighlughted=function(a){if(this.highlightVar.length&&a!=null){var b=this.data.y.vars[a];return this.highlightVar.includes(b)}};this.getDefaultMetaDataObject=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.resetCacheColors=function(){delete (this.cacheColors)};this.setCacheColors=function(){if(!this.cacheColors){this.cacheColors={}}if(!this.cacheColors[this.colorScheme]){this.cacheColors[this.colorScheme]={}}};this.setPieData=function(n,q,m){this.setCacheColors();var e={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.sum(n)};var b=this.getCustomColorScheme(n.length);for(var l=0;l<n.length;l++){var h=q?this.varIndices[l]:l;var a=n[h]/e.tot;var g=q?this.data.y.vars[h]:l;var o;if(m&&m[l%m.length]){o=m[l%m.length]}else{if(this.cacheColors[this.colorScheme].hasOwnProperty(g)){o=this.cacheColors[this.colorScheme][g]}else{o=this.pieColors[l]||b[l%b.length];this.cacheColors[this.colorScheme][g]=o}}if(this.isNumber(a,true)){e.data[h]=a;e.raw[h]=n[h];if(l>=this.maxPieSectors-1){e.oprc+=a;e.idso.push(h);e.no++}else{e.ids.push(h)}e.cols.push(o)}}if(e.no){e.ids.push(-1)}return e};this.drawPie=function(u,h,g,t,I,w){var f=this;var q=function(){for(var a=0;a<u.ids.length;a++){if(u.data[u.ids[a]]&&u.data[u.ids[a]]>-1&&!f.isNumber(u.data[u.ids[a]],true)){return false}}return true};if(q()){var z,d;var m=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var o=this.graphType=="Network"||this.graphType!="Pie"?I[E]:k>-1?[k,C]:u.idso;var e=this.graphType=="Map"?u.cols[E]:this.getFillColor(u.cols[E],o,this.isDOE);var D=this.getOutlineColor(e,this.graphType=="Map"?E:o);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var H=(z+d)/2;var B=(d-z)/32;var J=this.graphType=="Network"||this.graphType=="Map"?"Decorations":this.graphType!="Pie"?"Overlays":"Data";var D=this.pieType=="separated"?this.background:this.getOutlineColor(e);if(this.graphType=="Network"||this.graphType=="Map"){this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:(this.graphType=="Map"?I[0]:I[E]),m:w,t:J,h:this.isHidden(this.graphType=="Map"?I[0][0]:I[E])})}else{if(this.graphType!="Pie"){this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I[E],t:J})}else{if(k>-1){I=this.isDOE?[k,C,"Facet-"+this.layoutCurrent]:[k,C];this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I,t:J,h:this.isHidden(I[0])})}else{this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:u.idso,t:J})}}}var F=u.ids.length>1?h-Math.sin(H-(Math.PI/2))*A:h;var b=u.ids.length>1?g+Math.cos(H-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.graphType!="Map"&&this.showPieValues&&(d-z)>0.05){if(this.pieLabelType=="value"){this.toRender({p:["drawText",u.raw[k],F,b,this.axisTickFont,this.axisTickColor,"center","middle"],t:J})}else{this.toRender({p:["drawText",this.sprintf("%."+this.pieSegmentPrecision+"f",v*100)+"%",F,b,this.axisTickFont,this.axisTickColor,"center","middle"],t:J})}}G+=v}G=0;d=null;if(u.ids.length>1&&this.graphType!="Map"){for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.getFillColor(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var D=this.pieType=="separated"?this.background:this.getOutlineColor(e);this.toRender({p:["drawShape","pie",h,g,(t*2),t,false,D,"open",false,this.pieSegmentSeparation,false,false,z,d],s:true,t:J});G+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1&&this.graphType!="Map"){this.toRender({p:["drawShape","circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed"],t:J})}}};this.drawBarPlot=function(ah,ag,Y,Q,N,T,P,K,X,V,ak,U,an,W,ae,aa,M,am){var O,L,af,S;var J=this;var j=function(a){return J.isGroupedData?M.smps[J.data.w.smps[J.grpIndices[a]]]:M.smps[J.data.y.smps[J.smpIndices[a]]]};var R=this.variableSpaceFactor/2;var ad=N/2;var ac=am?"Overlays":this.graphType=="Network"?"Decorations":"Data";if(V=="vertical"||this.graphType=="Network"){for(var ab=0;ab<ah.length;ab++){O=((ah[ab]-X)*P)-K;var ai;var Z=(M&&M.cap&&M.cap[j(ab)])||this.barType=="arrow"?"arrow":this.useRoundRectangles&&O>0?"roundrectt":this.useRoundRectangles?"roundrectb":"rectangle";var A=this.getFillColor(M?M.fill[j(ab)]:ak[ab],an[ab]);var al=N-this.variableSpaceFactor>5?this.getOutlineColor(A,an[ab]):A;var I=this.isHidden(an[ab][0],an[ab][1]);if(this.isNumber(O,true)){if(this.barPath){var B=this.addColorTransparency(this.barPathColor||A,this.barPathTransparency);this.toRender({p:["drawShape","rectangle",(Y+R)+((N-this.variableSpaceFactor)/2),K+(this.y/2),N-this.variableSpaceFactor,this.y*2,B,B],t:"Decorations"})}if(O<0){ai=this.toRender({p:["drawShape",Z,(Y+R)+((N-this.variableSpaceFactor)/2),Q+(-O/2),N-this.variableSpaceFactor,-O,A,al,U[ab],false,false,ae],i:an[ab],m:W,t:ac,h:I})}else{ai=this.toRender({p:["drawShape",Z,(Y+R)+((N-this.variableSpaceFactor)/2),Q-(O/2),N-this.variableSpaceFactor,O,A,al,U[ab],false,false,ae],i:an[ab],m:W,t:ac,h:I})}af=Q-O;S=Y+ad;if(ag[ab]&&this.isNumber(ag[ab],true)){L=(ag[ab]/2)*P;this.toRender({p:["drawLine","error",S,af,S,af-L,this.errorBarsColor,-ad,"butt"],g:ai,t:ac,h:I});this.toRender({p:["drawLine","error",S,af,S,af+L,this.errorBarsColor,-ad,"butt"],g:ai,t:ac,h:I})}if(M){var H=j(ab);for(var aj in M){if(aj!="cap"&&aj!="high"&&aj!="color"&&aj!="fill"){if(M[aj][H]){for(var F=0;F<M[aj][H].length;F++){var E=((M[aj][H][F][0]-X)*P)-K;var G=((M[aj][H][F][1]-X)*P)-K;var D=(Y+R)+((N-this.variableSpaceFactor)/2);this.toRender({p:["drawShape",this.shapes[0],D,Q-E,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I});if(!this.isNumber(G,true)){G=O-this.margin}else{this.toRender({p:["drawShape",this.shapes[1],D,Q-G,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I})}this.toRender({p:["drawLine","line",D,Q-E,D,Q-G,M.color[aj],this.margin],g:ai,t:ac,h:I})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.toRender({p:["drawText",this.formatNumber(ah[ab]),S,Q-(O+(this.margin/4)),this.smpLabelFont,A,"center","bottom"],g:ai,t:ac,h:I})}}Y+=T}}else{for(var ab=0;ab<ah.length;ab++){O=((ah[ab]-X)*P)-K;var ai;var Z=(M&&M.cap&&M.cap[j(ab)])||this.barType=="arrow"?"arrow":!this.useRoundRectangles?"rectangle":aa||O<0?"roundrectl":"roundrectr";var A=this.getFillColor(M?M.fill[j(ab)]:ak[ab],an[ab]);var al=N-this.variableSpaceFactor>5?this.getOutlineColor(A,an[ab]):A;var I=this.isHidden(an[ab][0],an[ab][1]);if(this.isNumber(O,true)){if(this.barPath){var B=this.addColorTransparency(this.barPathColor||A,this.barPathTransparency);this.toRender({p:["drawShape","rectangle",K+(this.x/2),(Q+R)+((N-this.variableSpaceFactor)/2),this.x*2,N-this.variableSpaceFactor,B,B],t:"Decorations"})}if(O<0){if(aa){ai=this.toRender({p:["drawShape",Z,((Y+aa)-K)+(-O/2),(Q+R)+((N-this.variableSpaceFactor)/2),-O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],i:an[ab],m:W,t:ac,h:I})}else{ai=this.toRender({p:["drawShape",Z,(Y+O)+(-O/2),(Q+R)+((N-this.variableSpaceFactor)/2),-O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],i:an[ab],m:W,t:ac,h:I})}}else{if(aa){ai=this.toRender({p:["drawShape",Z,((Y+aa)-(O+K))+(O/2),(Q+R)+((N-this.variableSpaceFactor)/2),O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],i:an[ab],m:W,t:ac,h:I})}else{ai=this.toRender({p:["drawShape",Z,Y+(O/2),(Q+R)+((N-this.variableSpaceFactor)/2),O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],i:an[ab],m:W,t:ac,h:I})}}af=aa?(Y+aa)-(O+K):Y+O;S=Q+ad;if(ag[ab]&&this.isNumber(ag[ab],true)){L=(ag[ab]/2)*P;this.toRender({p:["drawLine","error",af,S,af+L,S,this.errorBarsColor,ad,"butt"],g:ai,t:ac,h:I});this.toRender({p:["drawLine","error",af,S,af-L,S,this.errorBarsColor,ad,"butt"],g:ai,t:ac,h:I})}if(M){var H=j(ab);for(var aj in M){if(aj!="cap"&&aj!="high"&&aj!="color"&&aj!="fill"){if(M[aj][H]){for(var F=0;F<M[aj][H].length;F++){var E=((M[aj][H][F][0]-X)*P)-K;var G=((M[aj][H][F][1]-X)*P)-K;var C=(Q+R)+((N-this.variableSpaceFactor)/2);this.toRender({p:["drawShape",this.shapes[0],Y+E,C,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I});if(!this.isNumber(G,true)){G=O-this.margin}else{this.toRender({p:["drawShape",this.shapes[1],Y+G,C,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I})}this.toRender({p:["drawLine","line",Y+E,C,Y+G,C,M.color[aj],this.margin],g:ai,t:ac,h:I})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.toRender({p:["drawText",this.formatNumber(ah[ab]),af+(this.margin/4),S,this.smpLabelFont,ak[ab],"left","middle"],g:ai,t:ac,h:I})}}Q+=T}}};this.drawLinePlot=function(af,ae,W,P,N,ab,O,V,T,ah,R,Q,ak,ad,ac,X,F,aj){var J=function(){var b=[[],[]];if(T=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var S,A,y,x,j,am,al,ag,K,B,I;var M=null;var D=null;var H=N/2;var G=this.dataPointSize*0.5;var ai=R=="open"?ah:this.objectBorderColor||ah;var U=af.length-1;var L=[[],[]];var r=[[],[]];var Y=[];var C=this.getVariableIndices(F);var aa=aj?"Overlays":"Data";if(T=="vertical"){A=W;y=W+ab;if(M==null){M=A}for(var Z=1;Z<af.length;Z++){S=Z-1;if(this.isObject(O)){j=P-((af[S]-O[S].min)*O[S].units);am=P-((af[Z]-O[Z].min)*O[Z].units)}else{j=P-((af[S]-V)*O);am=P-((af[Z]-V)*O)}if(D==null){D=j}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[S][2]+":x"):false;if(this.isNumber(j,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){ag=this.toRender({p:["drawShape",Q,A,j,G,G,ah,ai,R[S],false,false,ac],i:ak[S],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}else{ag=this.toRender({p:["drawShape","sphere",A,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[S],false,false,ac],i:ak[S],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[S]),A,j-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(!K){K=ag}if(this.isNumber(ae[S],true)){al=(ae[S]/2)*this.isObject(O)?O[S].units:O;if(this.lineErrorType=="bar"){this.toRender({p:["drawLine","error",A,j,A,j+al,ah,-H,"butt"],i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)});this.toRender({p:["drawLine","error",A,j,A,j-al,ah,-H,"butt"],i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}else{r[0].push([A,A]);r[1].push([j+al,j-al]);Y.push([A,j])}}if(this.lineType=="spline"){L[0].push(A);L[1].push(j)}}if((this.lineType!="spline"&&this.isNumber(j,true)&&this.isNumber(am,true))||af.length<3){ag=this.toRender({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(R[S]||"solid"):this.lineType,A,j,y,am,ah,this.lineThickness,"butt",false,false,ac],i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}else{if(this.lineType=="spline"&&!this.isNumber(am,true)){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)});L=[[],[]];M=null;D=null}}if(!K){K=ag}if(r[0].length>0&&!this.isNumber(am,true)){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}r=[[],[]];Y=[]}A+=ab;y+=ab}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[U][2]+":x"):false;if(this.isNumber(am,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){ag=this.toRender({p:["drawShape",Q,A,am,G,G,ah,ai,R[U],false,false,ac],i:ak[U],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}else{ag=this.toRender({p:["drawShape","sphere",A,am,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[U],false,false,ac],i:ak[U],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[U]),A,am-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(!K){K=ag}if(this.isNumber(ae[U],true)){al=(ae[U]/2)*this.isObject(O)?O[U].units:O;if(this.lineErrorType=="bar"){this.toRender({p:["drawLine","error",A,am,A,am+al,ah,-H,"butt"],i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)});this.toRender({p:["drawLine","error",A,am,A,am-al,ah,-H,"butt"],i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{if(Z==af.length){r[0].push([A,A]);r[1].push([am+al,am-al]);Y.push([A,am])}}}if(this.lineType=="spline"){L[0].push(A);L[1].push(am)}}if(this.lineType=="spline"){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}if(!K){K=ag}if(r[0].length>0){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}}}else{j=P;am=P+ab;if(D==null){D=j}for(var Z=1;Z<af.length;Z++){S=Z-1;if(this.isObject(O)){A=X?W+X-((af[S]-O[S].min)*O[S].units):W+((af[S]-O[S].min)*O[S].units);y=X?W+X-((af[Z]-O[Z].min)*O[Z].units):W+((af[Z]-O[Z].min)*O[Z].units)}else{A=X?W+X-((af[S]-V)*O):W+((af[S]-V)*O);y=X?W+X-((af[Z]-V)*O):W+((af[Z]-V)*O)}if(M==null){M=A}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[S][2]+":x"):false;if(this.isNumber(A,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){this.toRender({p:["drawShape",Q,A,j,G,G,ah,ai,R[S],false,false,ac],i:ak[S],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}else{this.toRender({p:["drawShape","sphere",A,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[S],false,false,ac],i:ak[S],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[S]),A,j-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(this.isNumber(ae[S],true)){x=(ae[S]/2)*this.isObject(O)?O[S].units:O;if(this.lineErrorType=="bar"){ag=this.toRender({p:["drawLine","error",A,j,A+x,j,ah,H,"butt"],i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)});if(!K){K=ag}this.toRender({p:["drawLine","error",A,j,A-x,j,ah,H,"butt"],i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{r[0].push([A+x,A-x]);r[1].push([j,j]);Y.push([A,j])}}if(this.lineType=="spline"){L[0].push(A);L[1].push(j)}}if((this.lineType!="spline"&&this.isNumber(A,true)&&this.isNumber(y,true))||af.length<3){ag=this.toRender({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(R[S]||"solid"):this.lineType,A,j,y,am,ah,this.lineThickness,"butt",false,false,ac],i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}else{if(this.lineType=="spline"&&!this.isNumber(y,true)){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)});L=[[],[]];M=null;D=null}}if(!K){K=ag}if(r[1].length>0&&!this.isNumber(y,true)){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}r=[[],[]];Y=[]}j+=ab;am+=ab}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[U][2]+":x"):false;if(this.isNumber(y,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){this.toRender({p:["drawShape",Q,y,j,G,G,ah,ai,R[U],false,false,ac],i:ak[U],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}else{this.toRender({p:["drawShape","sphere",y,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[U],false,false,ac],i:ak[U],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[U]),y,j-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(this.isNumber(ae[U],true)){x=(ae[U]/2)*this.isObject(O)?O[U].units:O;if(this.lineErrorType=="bar"){ag=this.toRender({p:["drawLine","error",y,j,y+x,j,ah,H,"butt"],i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)});if(!K){K=ag}this.toRender({p:["drawLine","error",y,j,y-x,j,ah,H,"butt"],i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{r[0].push([y+x,y-x]);r[1].push([j,j]);Y.push([y,j])}}if(this.lineType=="spline"){L[0].push(y);L[1].push(j)}}if(this.lineType=="spline"){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}if(!K){K=ag}if(r[1].length>0){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}}}};this.drawStackedPlot=function(U,N,F,C,W,I,R,E,y,J,V,H,X,L,O,S,T){var m=F;var B=N;var s=this;var Y=T?"Overlays":"Data";var h=function(a){var c=0;if(s.dodgeBy){for(var b=0;b<U.length;b++){if(U[b]!=0){c++}}}return a/c};var Q=function(c,e,b,d,a){return s.processTreemap(c,{width:d,height:a,left:e,top:b})};var A=h(C);if(J=="vertical"){F=m-y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P==U.length-1&&this.useRoundRectangles?"roundrectt":"rectangle";var x=this.getFillColor(V[P],X[P]);var r=C>5?this.getOutlineColor(x,X[P]):x;if(this.graphType=="Network"){this.toRender({p:["drawShape",M,N+(C/2),F-(D/2),C,D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,D);this.drawTreemap(K,0,0)}else{if(this.dodgeBy){var j=this.isHidden(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.toRender({p:["drawShape",M,N+(A/2),F-(D/2),A,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.isHidden(X[P][0],X[P][1]);var G=this.toRender({p:["drawShape",M,N+(C/2),F-(D/2),C,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(U[P]),N+(C/2),F-(D/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}F=m-y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":"roundrectb";var x=this.getFillColor(V[P],X[P]);var r=C>5?this.getOutlineColor(x,X[P]):x;if(this.graphType=="Network"){this.toRender({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,-D);this.drawTreemap(K,0,0)}else{if(this.dodgeBy){var j=this.isHidden(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.toRender({p:["drawShape",M,N+(A/2),F-(D/2),A,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.isHidden(X[P][0],X[P][1]);var G=this.toRender({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(U[P]),N+(C/2),F-(D/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}}else{N=B+y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P<U.length-1||!this.useRoundRectangles?"rectangle":O?"roundrectl":"roundrectr";var x=this.getFillColor(V[P],X[P]);var r=C>5?this.getOutlineColor(x,X[P]):x;if(O){if(this.graphType=="Network"){this.toRender({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,D,C);this.drawTreemap(K,0,0)}else{if(this.dodgeBy){var j=this.isHidden(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.toRender({p:["drawShape",M,N+O-(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.isHidden(X[P][0],X[P][1]);var G=this.toRender({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(U[P]),N+O-(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.toRender({p:["drawShape",M,N+(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,D,C);this.drawTreemap(T,0,0)}else{if(this.dodgeBy){var j=this.isHidden(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.toRender({p:["drawShape",M,N+(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.isHidden(X[P][0],X[P][1]);var G=this.toRender({p:["drawShape",M,N+(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(U[P]),N+(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}N=B+y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":O?"roundrectr":"roundrectl";var x=this.getFillColor(V[P],X[P]);var r=C>5?this.getOutlineColor(x,X[P]):x;if(O){if(this.graphType=="Network"){this.toRender({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,-D,C);this.drawTreemap(K,0,0)}else{if(this.dodgeBy){var j=this.isHidden(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.toRender({p:["drawShape",M,N+O-(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.isHidden(X[P][0],X[P][1]);var G=this.toRender({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(U[P]),N+O-(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.toRender({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,-D,C);this.drawTreemap(T,0,0)}else{if(this.dodgeBy){var j=this.isHidden(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.toRender({p:["drawShape",M,N+(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.isHidden(X[P][0],X[P][1]);var G=this.toRender({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(U[P]),N+(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}}};this.drawAreaPlot=function(ai,Z,S,Q,ae,T,ag,V,J,D,m,X,af,ak,W,an,al,M,G,am){var Y=ai.length-1;var aa=af&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var ao=-D*J;var C=m*J;var ad=am?"Overlays":"Data";var L=function(b,a){for(var c=a+1;c<ai[b].length;c++){if(ai[b][c]>0){return 1}else{if(ai[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ai[0].length;ac++){A[ac]=ag=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ai.length;ac++){var ah=Z;var P=af?[]:[Z];var N=af?[]:[S-ao];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.isNumber(ai[ac][ab],true)){if(!af){P.push(ah-T);N.push(S-ao)}if(af&&this.lineType=="spline"){this.toRender({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],i:an[ac],m:al,b:S-ao,t:ad,h:this.isHidden(an[ac][0])})}else{if(D>=0&&Y>0&&ag!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var ap=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);ap.push([N[ac],E[ac]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ak[Y],an[Y]),this.getOutlineColor(ak[Y],an[Y]),W[Y]],i:an[Y],m:al,b:S-ao,t:ad,h:this.isHidden(an[Y][0])})}else{this.toRender({p:["drawShape",aa,P,N,this.width,this.height,this.getFillColor(ak[ac],an[ac]),this.getOutlineColor(ak[ac],an[ac]),W[ac]],i:an[ac],m:al,b:S-ao,t:ad,h:this.isHidden(an[ac][0])})}}if(G){var u=this.addColorTransparency(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.toRender({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.toRender({p:["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[ah+T];N=af?[]:[S-ao]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;P.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(ai[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ai[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(ao)}}}}}else{N.push(S-R)}}ah+=T}if(!af){P.push(Z+Q);N.push(S-ao)}U.push([P,N,ak[ac],W[ac],an[ac]])}}else{for(var ac=0;ac<ai[0].length;ac++){A[ac]=M?Z+M:ag=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ai.length;ac++){var ah=S;var P=af?[]:M?[Z+M]:[Z+ao];var N=af?[]:[S];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.isNumber(ai[ac][ab],true)){if(!af){P.push(M?Z+M:Z+ao);N.push(ah-T)}if(af&&this.lineType=="spline"){this.toRender({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],i:an[ac],m:al,b:Z+ao,t:ad,h:this.isHidden(an[ac][0])})}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&ag!="normal"){N.shift();var F=[];var ap=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);ap.push([N[ac-1],N[ac-1]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ak[Y],an[Y]),this.getOutlineColor(ak[Y],an[Y]),W[Y]],i:an[Y],m:al,b:Z+ao,t:ad,h:this.isHidden(an[Y][0])})}else{this.toRender({p:["drawShape",aa,P,N,this.width,this.height,this.getFillColor(ak[ac],an[ac]),this.getOutlineColor(ak[ac],an[ac]),W[ac]],i:an[ac],m:al,b:Z+ao,t:ad,h:this.isHidden(an[ac][0])})}}if(G){var u=this.addColorTransparency(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.toRender({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.toRender({p:["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[M?Z+M:Z+ao];N=af?[]:[ah+T]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;N.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ai[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ai[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(ao)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ah+=T}if(!af){P.push(M?Z+M:Z+ao);N.push(S+ae)}U.push([P,N,ak[ac],W[ac],an[ac]])}}while(Y>=0){var aj,K;var ab=U.pop();if(af){if(this.lineType=="spline"){this.toRender({p:["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var aj=this.toRender({p:["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],i:ab[4],m:al,g:K,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.isHidden(ab[4][0])});if(K==null){K=aj}}}}else{if(D>=0&&Y>0&&ag!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);ap.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],i:ab[4],m:al,b:S-ao,t:ad,h:this.isHidden(ab[4][0])})}else{ab[1].shift();ab[1].pop();var F=[];var ap=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);ap.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],i:ab[4],m:al,b:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}}else{if(ag=="normal"||ag=="stacked"){this.toRender({p:["drawShape",aa,ab[0],ab[1],this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}else{if(X=="vertical"){var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){ap.push([ab[1][ac],ab[1][0]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],i:ab[4],m:al,b:S-ao,t:ad,h:this.isHidden(ab[4][0])})}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],i:ab[4],m:al,b:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}}}}if(G){var u=this.addColorTransparency(ab[2],0,true);var g=Math.min(10,T);for(var ac=1;ac<ab[0].length-1;ac++){if(this.isGraphTime&&G[ac-1]<0){continue}aj=this.toRender({p:["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],i:[ab[4][0],G[ac-1]],s:true,t:ad});if(!af){if(X=="vertical"){this.toRender({p:["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}else{this.toRender({p:["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}}}}Y--}};this.drawBoxPlot=function(ar,ah,Z,W,ac,Y,ag,ae,at,ad,av,an,n,V){var T=this;var af=this.segregateSamplesBy.length&&this.isGroupedData&&this.groupingFactors.includes(this.segregateSamplesBy[0]);var C=function(f){var d;if(T.layoutValid&&!T.isDOE){if(T.segregateVariablesBy.length>0){d=f}else{if(T.segregateSamplesBy.length>0){var a=!af?[T.data.l.name[T.layoutCurrent],T.data.w.glab[f]].join("::"):T.data.w.labs[f]?T.data.w.labs[f]:T.data.w.glab[f];for(var c=0;c<k.g[E].length;c++){if(k.g[E][c].density.name==a){d=c;break}}}}}else{d=T.grpIndices[f]}return k.g[E][d]};var U=function(a){return ae=="vertical"?Z-((a-ag)*Y):ah+((a-ag)*Y)};var k=this.meta.data.d;var E=this.getVariableIndices(V);var aa=this.variableSpaceFactor/2;var al=W/2;var H=al/2;var F=H/2;var ap=W/this.boxplotOutliersRatio;var G={};var S={};var L=false;var Q=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(W-this.variableSpaceFactor)*this.boxplotWidthRatioIfViolin:W-this.variableSpaceFactor;var P=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?W*this.boxplotWidthRatioIfViolin:0;var O=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?P/2:al;var b=Math.max(1,W/4);if(ae=="vertical"){for(var ak=0;ak<ar.length;ak++){if(this.isGraphTime&&av[ak][1]<0){ah+=ac;continue}var R=this.showBoxplotOriginalData?this.isHidden(av[ak][0]):this.scatterPlotMatrix&&this.scatterType=="boxplot"?this.isHidden(false,false,av[ak][1]):this.isHidden(av[ak][0],av[ak][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ar[ak].length>1){var B=C(this.layoutValid?av[ak][1]:ak);if(B){this.drawViolin(B,ah+(W/2),Z,W/this.varIndices.length,Y,ag,ae,an[ak],n[ak],av[ak],R,ar[ak]);if(!this.showBoxplotIfViolin){L=true}}}var ab=ah+al;var X=[];var A=[];var M=this.showBoxplotOriginalData||this.showViolinBoxplot?an[ak]:at[ak];for(var aj=0;aj<5;aj++){X.push(U(ar[ak][aj]));A.push(X[X.length-1].toString())}if(!L){var N=(ah+aa)+((W-this.variableSpaceFactor)/2);var ao=X[3]+((X[2]-X[3])/2);var am=Q;var au=X[2]-X[3];var e=this.boxplotNotched?U(ar[ak][7][0]):false;var ai=this.boxplotNotched?U(ar[ak][7][1]):false;var J=this.showBoxplotOriginalData?this.addColorTransparency(this.getFillColor(at[ak],av[ak]),this.boxplotTransparency,true):this.getFillColor(at[ak],av[ak]);var I=this.boxplotBorderColor==false?(this.useOpenShapes?this.removeColorTransparency(J):J):this.boxplotBorderColor;var D=this.useOpenShapes?I:(this.boxplotBorderColor||this.boxplotMedianColor);var aq,K,x;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){am=Q*ar[ak][8];P+=(Q-am)/2}if(this.boxplotColor){J=this.boxplotColor}if(this.boxplotNotched&&this.boxplotType!="range"){if(this.showViolinBoxplot){K=[ah+(W-aa-P)-b,ah+aa+P,ah+aa+P,ah+(W-aa-P),ah+(W-aa-P),ah+aa+P+b,ah+(W-aa-P)-b]}else{K=[ah+aa+P+b,ah+aa+P,ah+aa+P,ah+(W-aa-P),ah+(W-aa-P),ah+(W-aa-P)-b,ah+aa+P+b]}x=[X[4],e,X[2],X[2],e,X[4],X[4]];aq=this.toRender({p:["drawShape","polygon",K,x,false,false,J,I,ad[ak]],i:av[ak],b:Z,t:"Data",h:R});x=[X[4],ai,X[3],X[3],ai,X[4],X[4]];this.toRender({p:["drawShape","polygon",K,x,false,false,J,I,ad[ak]],i:av[ak],g:aq,b:Z,t:"Data",h:R})}else{if(this.boxplotType=="range"){aq=this.toRender({p:["drawLine","line",N,X[1],N,X[0],this.useOpenShapes?I:J,ap,"round"],i:av[ak],b:Z,t:"Data",h:R})}else{aq=this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",N,ao,am,au,J,I,ad[ak]],i:av[ak],b:Z,t:"Data",h:R})}}if(this.unique(A).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.toRender({p:["drawLine","median",ah+aa+P+b,X[4],ah+(W-aa-P)-b,X[4],D,this.boxplotMedianWidth,"butt"],i:av[ak],g:aq,t:"Data",h:R})}else{if(this.boxplotType=="range"){this.toRender({p:["drawShape","sphere",N,X[4],ap*2.5,ap*2.5,this.useOpenShapes?I:J,this.useOpenShapes?I:J],i:av[ak],g:aq,t:"Data",h:R})}else{this.toRender({p:["drawLine","median",ah+aa+P,X[4],ah+(W-aa-P),X[4],D,this.boxplotMedianWidth,"butt"],i:av[ak],g:aq,t:"Data",h:R})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){this.toRender({p:["drawLine","line",ab,X[2],ab,X[0],I,false,"butt"],i:av[ak],g:aq,t:"Data",h:R});this.toRender({p:["drawLine","line",ab,X[3],ab,X[1],I,false,"butt"],i:av[ak],g:aq,t:"Data",h:R})}else{if(this.boxplotWhiskersType=="double"){this.toRender({p:["drawLine","error",ab,X[2],ab,X[0],I,-O,"butt"],i:av[ak],g:aq,t:"Data",h:R});this.toRender({p:["drawLine","error",ab,X[3],ab,X[1],I,-O,"butt"],i:av[ak],g:aq,t:"Data",h:R})}}}}if(this.boxplotMean){this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",ab,U(ar[ak][6]),H,H,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:av[ak],g:aq,b:Z,t:"Data",h:R})}if(ar[ak][5]&&!this.showBoxplotOriginalData){for(var aj=0;aj<ar[ak][5].length;aj++){this.toRender({p:["drawShape","sphere",ab,U(ar[ak][5][aj]),ap,ap,J,I,ad[ak]],i:av[ak],g:aq,b:Z,t:"Data",h:R})}}}if(!G.hasOwnProperty(M)){G[M]=[];S[M]=this.cloneObject(av[ak])}G[M].push([ah+aa+(W/2),X[4]]);ah+=ac}}else{for(var ak=0;ak<ar.length;ak++){if(this.isGraphTime&&av[ak][1]<0){Z+=ac;continue}var R=this.showBoxplotOriginalData?this.isHidden(av[ak][0]):this.isHidden(av[ak][0],av[ak][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&ar[ak].length>1){var B=C(this.layoutValid?av[ak][1]:ak);if(B){this.drawViolin(B,ah,Z+(W/2),W/this.varIndices.length,Y,ag,ae,an[ak],n[ak],av[ak],R,ar[ak]);if(!this.showBoxplotIfViolin){L=true}}}var ab=Z+al;var X=[];var A=[];var M=this.showBoxplotOriginalData||this.showViolinBoxplot?an[ak]:at[ak];for(var aj=0;aj<5;aj++){X.push(U(ar[ak][aj]));A.push(X[X.length-1].toString())}if(!L){var N=X[2]+((X[3]-X[2])/2);var ao=(Z+aa)+((W-this.variableSpaceFactor)/2);var am=X[3]-X[2];var au=Q;var e=this.boxplotNotched?U(ar[ak][7][0]):false;var ai=this.boxplotNotched?U(ar[ak][7][1]):false;var J=this.showBoxplotOriginalData?this.addColorTransparency(this.getFillColor(at[ak],av[ak]),this.boxplotTransparency,true):this.getFillColor(at[ak],av[ak]);var I=this.boxplotBorderColor==false?(this.useOpenShapes?this.removeColorTransparency(J):J):this.boxplotBorderColor;var D=this.useOpenShapes?I:(this.boxplotBorderColor||this.boxplotMedianColor);var aq,K,x;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){au=Q*ar[ak][8];P+=(Q-au)/2}if(this.boxplotColor){J=this.boxplotColor}if(this.boxplotNotched&&this.boxplotType!="range"){K=[X[4],e,X[2],X[2],e,X[4],X[4]];if(this.showViolinBoxplot){x=[Z+(W-aa-P)-b,Z+aa+P,Z+aa+P,Z+(W-aa-P),Z+(W-aa-P),Z+aa+P+b,Z+(W-aa-P)-b]}else{x=[Z+aa+P+b,Z+aa+P,Z+aa+P,Z+(W-aa-P),Z+(W-aa-P),Z+(W-aa-P)-b,Z+aa+P+b]}aq=this.toRender({p:["drawShape","polygon",K,x,false,false,J,I,ad[ak]],i:av[ak],b:Z,t:"Data",h:R});K=[X[4],ai,X[3],X[3],ai,X[4],X[4]];this.toRender({p:["drawShape","polygon",K,x,false,false,J,I,ad[ak]],i:av[ak],g:aq,b:Z,t:"Data",h:R})}else{if(this.boxplotType=="range"){aq=this.toRender({p:["drawLine","line",X[0],ao,X[1],ao,this.useOpenShapes?I:J,ap,"round"],i:av[ak],b:ah,t:"Data",h:R})}else{aq=this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",N,ao,am,au,J,I,ad[ak]],i:av[ak],b:ah,t:"Data",h:R})}}if(this.unique(A).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.toRender({p:["drawLine","median",X[4],Z+aa+P+b,X[4],Z+(W-aa-P)-b,D,this.boxplotMedianWidth,"butt"],i:av[ak],g:aq,t:"Data",h:R})}else{if(this.boxplotType=="range"){this.toRender({p:["drawShape","sphere",X[4],ao,ap*2.5,ap*2.5,this.useOpenShapes?I:J,this.useOpenShapes?I:J],i:av[ak],g:aq,t:"Data",h:R})}else{this.toRender({p:["drawLine","median",X[4],Z+aa+P,X[4],Z+(W-aa-P),D,this.boxplotMedianWidth,"butt"],i:av[ak],g:aq,t:"Data",h:R})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){this.toRender({p:["drawLine","line",X[2],ab,X[0],ab,I,false,"butt"],i:av[ak],g:aq,t:"Data",h:R});this.toRender({p:["drawLine","line",X[3],ab,X[1],ab,I,false,"butt"],i:av[ak],g:aq,t:"Data",h:R})}else{if(this.boxplotWhiskersType=="double"){this.toRender({p:["drawLine","error",X[2],ab,X[0],ab,I,O,"butt"],i:av[ak],g:aq,t:"Data",h:R});this.toRender({p:["drawLine","error",X[3],ab,X[1],ab,I,O,"butt"],i:av[ak],g:aq,t:"Data",h:R})}}}}if(this.boxplotMean){this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",U(ar[ak][6]),ab,H,H,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:av[ak],g:aq,b:ah,t:"Data",h:R})}if(ar[ak][5]&&!this.showBoxplotOriginalData){for(var aj=0;aj<ar[ak][5].length;aj++){this.toRender({p:["drawShape","sphere",U(ar[ak][5][aj]),ab,ap,ap,J,I,ad[ak]],i:av[ak],g:aq,b:ah,t:"Data",h:R})}}}if(!G.hasOwnProperty(M)){G[M]=[];S[M]=this.cloneObject(av[ak])}G[M].push([X[4],Z+aa+(W/2)]);Z+=ac}}if(this.boxplotConnect){for(var M in G){if(G[M].length>1){var aq=this.toRender({p:["drawLine","line",G[M][0][0],G[M][0][1],G[M][1][0],G[M][1][1],M,this.boxplotConnectWidth,"butt"],i:["Line:",S[M][0],S[M][1]],t:"Data",h:R});for(var ak=1;ak<G[M].length-1;ak++){this.toRender({p:["drawLine","line",G[M][ak][0],G[M][ak][1],G[M][ak+1][0],G[M][ak+1][1],M,this.boxplotConnectWidth,"butt"],i:["Line:",S[M][0],S[M][1]],g:aq,t:"Data",h:R})}}}}};this.drawGanttPlot=function(R,E,T,H,L,C,P,B,K,F,S,U){var y=function(a){return L+((a-K)*B)};var x=null;for(var N=0;N<R.length;N++){var J=y(R[N][0]);var f=y(R[N][1]);var A=J+((f-J)/2);var e=C+(P/2);var W=f-J;var v=E[N]?W*E[N]:false;var w=this.getFillColor(S[N],U[N]);var g=this.addColorTransparency(w,this.ganttCompletionTransparency,true);var s=this.getOutlineColor(w,U[N]);var r=this.isHidden(false,U[N][0]);var D=this.toRender({p:["drawShape","roundrect",A,e,W,P,g,g,F[N]],i:U[N],g:x,b:L,t:"Data",h:r});if(!x){x=D}if(E[N]){if(E[N]==1){this.toRender({p:["drawShape","roundrect",A,e,W,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}else{this.toRender({p:["drawShape","roundrectl",A-((W-v)/2),e,v,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}}this.toRender({p:["drawShape","roundrect",A,e,W,P,false,s,"open"],i:U[N],g:x,b:L,t:"Data",h:r});if(H.length){for(var M=0;M<H.length;M++){var I=y(H[M][0]);this.toRender({p:["drawShape","triangle2",I,C,P/3,P/3,w,s],i:[].concat(U[N].concat(H[M][1])),g:x,b:L,t:"Data",h:r})}}if(T[N]){var G=y(T[N][0]);var X=y(T[N][1]);var V=T[N][2]+(P/2);var Q=e==V?X:G+((X-G)/2);var n=e==V?V:V+(P/2);var O=A-(W/2);var k=e;this.toRender({p:["drawLine",n==k?"line":"roundLine",Q,n,O,k,this.getOutlineColor(T[N][4]),T[N][5],"butt",0,0,false,false,false,false,T[N][3]],i:U[N],g:x,b:L,t:"Data",h:r})}}};this.drawViolin=function(s,J,B,N,A,H,F,Q,E,D,g,O){var k=[];var L=[];var e=[];var G=[];var b=[[],[]];var I,f,r,n,w,a,R,P;var S=s.density.maxY>0?s.density.maxY:0.000001;switch(this.violinScale){case"area":I=N/S*S/s.scale*0.9;break;case"count":I=N/S*s.density.sumY/s.area*0.9;break;case"width":I=N/S*0.9;break}var C=this.addColorTransparency(this.violinColor||Q,this.showBoxplotOriginalData&&!this.violinColor?0:this.violinTransparency,true);if(this.violinTrim){f=[];for(var M=s.density.trim[0];M<s.density.trim[1];M++){f.push(s.density.xy[M])}}else{f=s.density.xy}if(F=="vertical"){for(var M=0;M<f.length;M++){r=(f[M][1]*I);n=((f[M][0]-H)*A);k.push(J-r);L.push(B-n);e.push(J+r);G.push(B-n);b[0].push(J);b[1].push(B-n)}}else{for(var M=0;M<f.length;M++){r=((f[M][0]-H)*A);n=(f[M][1]*I);k.push(J+r);L.push(B-n);e.push(J+r);G.push(B+n);b[0].push(J+r);b[1].push(B)}}if(k.length>1&&L.length>1){this.toRender({p:["drawShape","violin",[k,e],[L,G],false,false,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g});if(this.showViolinQuantiles){r=O;for(M=2;M<=4;M++){if(F=="vertical"){for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=f[K][1]*I;P=B-((r[M]-H)*A);this.toRender({p:["drawLine","solid",J-R,P,J+R,P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}else{for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=J+((r[M]-H)*A);P=f[K][1]*I;this.toRender({p:["drawLine","solid",R,B-P,R,B+P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}}}}else{if(F=="vertical"){r=J;n=B-((s.density.median[0]-H)*A)}else{r=J+((s.density.median[0]-H)*A);n=B}this.toRender({p:["drawShape","circle",r,n,this.margin,this.margin,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g})}};this.drawDotPlot=function(am,al,aa,S,af,V,R,Z,T,X,ao,ab,W,au,P,U,O,H,G,aq){var N=this;var F=function(l,c){var a=c[0];var j=0;var e="";var m={n:{},arr:{}};for(var h=0;h<l.length;h++){var d=l[h]!=null?l[h].toString():"";if(!m.n.hasOwnProperty(d)){m.n[d]=0;m.arr[d]=[]}m.n[d]++;if(m.n[d]>j){j=m.n[d];e=d}}if(m.n[e]*a>af){a=af*(N.binAlignment=="center"?1:0.5)/m.n[e]}for(var d in m.n){switch(N.binAlignment){case"bottom":case"right":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--}break;case"top":case"left":case"centerwhole":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break;case"center":if(m.n[d]%2){m.arr[d].push(0);m.n[d]--}else{m.arr[d].push(-a/2);m.n[d]--;m.arr[d].push(a/2);m.n[d]--}while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--;k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break}}return m.arr};var A=[];var ae=aq?"Overlays":"Data";if(X=="vertical"){for(var ad=0;ad<am.length;ad++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var ap=this.dotplotType=="movement"?false:this.binned?F(am[ad],T[ad]):false;for(var ac=0;ac<am[ad].length;ac++){if(this.isGraphTime&&am[ad][ac]==null){continue}var D=this.dotplotType=="movement"?false:this.jitter?this.jitterData(this.rep(0,am[ad].length),false,af*this.jitterFactor*0.5*this.widthFactor):false;var Y=this.dotplotType=="movement"?0:this.binned&&ap[am[ad][ac]]?ap[am[ad][ac].toString()].shift():this.jitter?D[ac]:0;var f=au?au[ad][ac]:false;var Q=S-((am[ad][ac]-Z)*R);var J=this.getFillColor(ao[ad][ac],f);var K=this.graphType=="Boxplot"?(this.boxplotBorderColor==false?(this.useOpenShapes?this.removeColorTransparency(J):J):this.boxplotBorderColor):(this.objectBorderColor==false&&this.useOpenShapes?this.removeColorTransparency(J):this.getOutlineColor(J,f));if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){f.push("Lollipop")}if(this.isNumber(Q,true)){var an;A.push([aa+Y,Q,T[ad][ac]/2,f]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ac>0){var L=A.length-1;var C=A.length-2;while(!this.isNumber(A[C][1],true)&&C>=0){C--}if(this.isNumber(A[C][1],true)){var at=A[L];var ak=A[C];var aj=this.addColorTransparency(J,0.2);this.toRender({p:["drawShape","polygon",[at[0]-at[2],ak[0]-ak[2],ak[0]+ak[2],at[0]+at[2]],[at[1],ak[1],ak[1],at[1]],false,false,aj,aj],t:"Decorations",h:this.isHidden(at[3][0],at[3][1])||this.isHidden(ak[3][0],ak[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){an=this.toRender({p:["drawShape",W[ad][ac],aa+Y,Q,T[ad][ac],T[ad][ac],this.background,J,ab[ad][ac],false,2,U],i:f,m:P,b:S,t:ae,h:this.isHidden(f[0],f[1])})}else{an=this.toRender({p:["drawShape",W[ad][ac],aa+Y,Q,T[ad][ac],T[ad][ac],J,K,ab[ad][ac],false,false,U],i:f,m:P,b:S,t:ae,h:this.isHidden(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(am[ad][ac]),aa+Y,Q,this.smpLabelFont,this.barLollipopOpen?J:this.foreground,"center","middle"],g:an,t:ae,h:this.isHidden(f[0],f[1])})}if(!this.isGroupedData){if(al[ad]&&al[ad][ac]&&this.isNumber(al[ad][ac],true)){var ar=(al[ad][ac]/2)*R;this.toRender({p:["drawLine","error",aa+Y,Q,aa+Y,Q+ar,J,-af,"butt",false,false,true],i:f,g:an,t:ae,h:this.isHidden(f[0],f[1])});this.toRender({p:["drawLine","error",aa+Y,Q,aa+Y,Q-ar,J,-af,"butt",false,false,true],i:f,g:an,t:ae,h:this.isHidden(f[0],f[1])})}}}else{A.push([aa+Y,Number.NaN,T[ad][ac]/2,f])}}if(this.showErrorBars&&this.isGroupedData&&al[ad]&&al[ad]&&this.isNumber(al[ad][0],true)&&this.isNumber(al[ad][1],true)){var Q=S-((al[ad][0]-Z)*R);var ar=(al[ad][1]/2)*R;var f=au?[au[ad][0][0],au[ad][0][1],"error"]:false;this.toRender({p:["drawShape","diamond",aa,Q,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,U],h:this.isHidden(false,au[ad][0][0]),t:ae});this.toRender({p:["drawLine","line",aa,Q-ar,aa,Q+ar,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,U],h:this.isHidden(false,au[ad][0][0]),t:ae})}}aa+=V}}else{for(var ad=0;ad<am.length;ad++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var ap=this.dotplotType=="movement"?false:this.binned?F(am[ad],T[ad]):false;for(var ac=0;ac<am[ad].length;ac++){if(this.isGraphTime&&am[ad][ac]==null){continue}var D=this.dotplotType=="movement"?false:this.jitter?this.jitterData(this.rep(0,am[ad].length),false,af*this.jitterFactor*0.5*this.widthFactor):false;var Y=this.dotplotType=="movement"?0:this.binned&&ap[am[ad][ac]]?ap[am[ad][ac].toString()].shift():this.jitter?D[ac]:0;var f=au?au[ad][ac]:false;var Q=O?aa+O-((am[ad][ac]-Z)*R):aa+((am[ad][ac]-Z)*R);var J=this.getFillColor(ao[ad][ac],f);var K=this.graphType=="Boxplot"?(this.boxplotBorderColor==false?(this.useOpenShapes?this.removeColorTransparency(J):J):this.boxplotBorderColor):(this.objectBorderColor==false&&this.useOpenShapes?this.removeColorTransparency(J):this.getOutlineColor(J,f));if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){f.push("Lollipop")}if(this.isNumber(Q,true)){var an;A.push([Q,S+Y,T[ad][ac]/2,f]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ac>0){var L=A.length-1;var C=A.length-2;while(!this.isNumber(A[C][0],true)&&C>=0){C--}if(this.isNumber(A[C][0],true)){var at=A[L];var ak=A[C];var aj=this.addColorTransparency(J,0.2);this.toRender({p:["drawShape","polygon",[at[0],ak[0],ak[0],at[0]],[at[1]-at[2],ak[1]-ak[2],ak[1]+ak[2],at[1]+at[2]],false,false,aj,aj],t:"Decorations",h:this.isHidden(at[3][0],at[3][1])||this.isHidden(ak[3][0],ak[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){an=this.toRender({p:["drawShape",W[ad][ac],Q,S+Y,T[ad][ac],T[ad][ac],this.background,J,ab[ad][ac],false,2,U],i:f,m:P,b:aa,t:ae,h:this.isHidden(f[0],f[1])})}else{an=this.toRender({p:["drawShape",W[ad][ac],Q,S+Y,T[ad][ac],T[ad][ac],J,K,ab[ad][ac],false,false,U],i:f,m:P,b:aa,t:ae,h:this.isHidden(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(am[ad][ac]),Q,S+Y,this.smpLabelFont,this.barLollipopOpen?J:this.foreground,"center","middle"],g:an,t:ae,h:this.isHidden(f[0],f[1])})}if(!this.isGroupedData){if(al[ad]&&al[ad][ac]&&this.isNumber(al[ad][ac],true)){var ar=(al[ad][ac]/2)*R;this.toRender({p:["drawLine","error",Q,S+Y,Q+ar,S+Y,J,af,"butt",false,false,true],i:f,g:an,t:ae,h:this.isHidden(f[0],f[1])});this.toRender({p:["drawLine","error",Q,S+Y,Q-ar,S+Y,J,af,"butt",false,false,true],i:f,g:an,t:ae,h:this.isHidden(f[0],f[1])})}}}else{A.push([Number.NaN,S+Y,T[ad][ac]/2,f])}}}if(this.showErrorBars&&this.isGroupedData&&al[ad]&&al[ad]&&this.isNumber(al[ad][0],true)&&this.isNumber(al[ad][1],true)){var Q=aa+((al[ad][0]-Z)*R);var ar=(al[ad][1]/2)*R;var f=au?[au[ad][0][0],au[ad][0][1],"error"]:false;this.toRender({p:["drawShape","diamond",Q,S,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,U],h:this.isHidden(false,false,"Var-"+au[ad][0][0]),t:ae});this.toRender({p:["drawLine","line",Q-ar,S,Q+ar,S,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,U],h:this.isHidden(false,false,"Var-"+au[ad][0][0]),t:ae})}S+=V}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var g=this.meta.data.x[this.connectBy];var E=0;var ag=this.getKeys(this.connectByData);var b=this.getCustomColorScheme(ag.length);var I={};if(this.isGraphTime){for(var ad=0;ad<this.timeValueIndices.length;ad++){if(this.timeValueIndices[ad]>0){I[ad.toString()]=this.timeValueIndices[ad]}}}for(var ad in this.connectByData){var an;var M=null;var am=this.connectByData[ad];var J=this.connectByNoColor?this.connectByColor:g&&g.type!="Numeric"?g.connects[g.order[ad]%g.connects.length]:b[E%b.length];if(am.length>1){for(var ac=1;ac<am.length;ac++){var Q=this.isGraphTime?A[I[am[ac-1]]]:A[am[ac-1]];var ar=this.isGraphTime?A[I[am[ac]]]:A[am[ac]];if(Q&&ar){an=this.toRender({p:["drawLine","line",Q[0],Q[1],ar[0],ar[1],J,this.connectByWidth,"butt",Q[2],ar[2],U],i:["Line:"+this.connectBy+" "+ad,Q[3][0],Q[3][2],ar[3][2]],g:M,t:ae,h:this.isHidden(false,Q[3][2])});if(M==null){M=an}}}}E++}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(A);if(G){var g=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var ad in this.connectByData){var am=this.connectByData[ad];if(am.length>1){for(var ab=0;ab<this.connectByDataVar[0].length;ab++){for(var ac=1;ac<am.length;ac++){var Q=this.connectByDataVar[am[ac-1]][ab];var ar=this.connectByDataVar[am[ac]][ab];var ai=ad;if(Q&&ar){var B=this.data.y.vars[Q[3][0]];var ah=this.data.y.vars[ar[3][0]];var z=this.data.y.smps[Q[3][(this.isGroupedData?2:1)]];var x=this.data.y.smps[ar[3][(this.isGroupedData?2:1)]];if(z==x){ai=B+" - "+ah+" ("+z+")"}else{ai=B+" ("+z+") - "+ah+" ("+x+")"}}this.toRender({p:["drawLine","line",Q[0],Q[1],ar[0],ar[1],this.connectByColor,this.connectByWidth,"butt",Q[2],ar[2],U],i:["Line:"+this.connectBy+" "+ai],t:ae,h:this.isHidden(false,Q[3][2])})}}}}}}}};this.drawHeatmap=function(H,C,s,j,E,G,K,F,z,J,y){var n=0;var g=C;var x=0.75;var B=this.meta.vals;if(!B.colors){B.colors={}}for(var D=0;D<H.length;D++){var k=H[D];var I=this.isContour?"rgba(0,0,0,0)":k==null||!this.isNumber(k,true)?this.missingDataColor:B.colors[k.toString()]?B.colors[k.toString()]:this.getColorForValue(J,k);var A=G&&y?this.addColorTransparency(I,y,true):G?I:this.heatmapCellBoxColor;B.colors[k==null?"null":k.toString()]=I;if(y){I=this.addColorTransparency(I,y,true)}if(this.graphType=="Network"){if(this.shapeByShape){this.toRender({p:["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z[D]],i:K[D],m:F,t:"Decorations",h:this.isHidden(K[D])})}else{this.toRender({p:["drawShape","rectangle",C+(j/2),s+(E/2),j,E,I,I,z[D]],i:K[D],m:F,t:"Decorations",h:this.isHidden(K[D])})}}else{if(this.shapeByShape){this.toRender({p:["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z?z[D]:false],i:K[D],m:F,t:"Data",h:this.isHidden(K[D][0],K[D][1])})}else{if(D>0&&D<H.length-1){if(n>=0.5){this.toRender({p:["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],i:K[D],m:F,b:[g,s+((E+x)/2),0,E+x],h:this.isHidden(K[D][0],K[D][1]),t:"Data"});n=0}}else{this.toRender({p:["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],i:K[D],m:F,b:[g,s+((E+x)/2),0,E+x],h:this.isHidden(K[D][0],K[D][1]),t:"Data"})}}}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(k),(C+j)-2,(s+E)-2,this.smpLabelFont,this.foreground,"right","bottom"],t:"Data"})}C+=j;n+=j}};this.drawTreemap=function(B,u,p,C,D){var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){if(c){f.toRender({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.getOutlineColor(d.color),"open",false,d.outline,C,D],b:r,t:"Data"})}else{f.toRender({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.getFillColor(d.color,d.index),f.getOutlineColor(d.color,d.index),"closed",false,false,C,D],i:d.index,b:r,t:"Data",h:f.isHidden(d.index[0],d.index[1])})}if(d.label){var b=f.measureText(d.label,f.overlayFont);if(b+f.margin<d.coords.width&&f.overlayFontSize+f.margin<d.coords.height){if(c){f.toRender({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5,true),"center","middle"],t:"Data"})}else{f.toRender({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"left","top"],t:"Data"})}}else{if(b+f.margin<d.coords.height&&f.overlayFontSize+f.margin<d.coords.width){if(c){f.toRender({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5,true),"center","middle",-Math.PI/2],t:"Data"})}else{f.toRender({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"right","top",-Math.PI/2],t:"Data"})}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth&&!this.isDOE?1:0;var E=this.isDOE?0:this.treemapBorderWidth;var o=E*2;var e=this.smpLabelFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.toRender({p:["disableGradientTransparencyShadow"],t:"Data"});if(a.coords.border>1){this.toRender({p:["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D],t:"Data"});this.toRender({p:["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>0){this.toRender({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>-1){this.toRender({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}}}var z=this.measureText(a.title,this.smpLabelFont);if(z+this.margin<n&&this.smpLabelFontSize<=e&&a.coords.height>e+(E/2)){this.toRender({p:["drawText",a.title,m+this.margin,j+(this.smpLabelFontSize/2),this.smpLabelFont,this.foreground,"left","middle"],t:"Data"})}this.toRender({p:["enableGradientTransparencyShadow"],t:"Data"})}if(a.children){s(a.children)}else{k(a)}}};this.drawSankey=function(b){var f=b.links[0].target.x-b.links[0].source.x;for(var a=0;a<b.links.length;a++){var c=b.links[a];this.toRender({p:["drawShape","bezier",c.plotX,c.plotY,f,c.dy,this.getFillColor(c.color),this.getOutlineColor(c.color),false,c.colors],i:c.tooltip,b:[this.left,this.top+this.y/2,f,c.dy],t:"Data"})}for(var a=0;a<b.nodes.length;a++){var e=b.nodes[a];this.toRender({p:["drawShape","rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground],i:e.tooltip,b:[this.left,this.top+this.y/2,e.dx,e.dy],t:"Data"});this.toRender({p:["drawText",e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayColor,"center","middle",-Math.PI/2],i:[e.tooltip[0]+":T"],t:"Data"})}};this.drawTree=function(a,f){if(this.data.tree&&this.data.tree.plot){var l=this.data.tree.plot;var k=this.treeNodeSize;var d=k/2;var h=k/4;var e=a=="vertical"?true:false;var g=this;var j=function(u){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=g.isHidden(false,u.id);g.toRender({p:["drawShape",u.data.shape,m,t,u.data.size,u.data.size,g.getFillColor(u.data.color,u.id),g.treeNodeOutlineColor,u.data.pattern,false,g.treeLinkWidth],i:["Tree-Node:"+u.id],b:[b,i],t:"Data",h:q});if(u.children){for(var p=0;p<u.children.length;p++){j(u.children[p])}if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.toRender({p:["drawText",u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"left":"right","middle",o],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"right":"left","middle",o-Math.PI],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){if(u.parent){g.toRender({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelColor,"right","middle",Math.PI/2],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelColor,"center","bottom"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{g.toRender({p:["drawText",u.data.name,m-((k/2)+g.margin),t,g.smpLabelFont,g.smpLabelColor,"right","middle"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}else{if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.toRender({p:["drawText",u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"right":"left","middle",o],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"left":"right","middle",o-Math.PI],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){g.toRender({p:["drawText",u.data.name,m,t+(k/2)+g.margin,g.smpLabelFont,g.smpLabelColor,"left","middle",Math.PI/2],i:["Tree-Text-:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m+(k/2)+g.margin,t,g.smpLabelFont,g.smpLabelColor,"left","middle"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}if(u._children){g.toRender({p:["drawLine","line",m-h,t,m+h,t,g.foreground],i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q});g.toRender({p:["drawLine","line",m,t-h,m,t+h,g.foreground],i:["Tree-Line2:"+u.id],b:[b,i],t:"Data",h:q})}else{if(u.children){g.toRender({p:["drawLine","line",m-h,t,m+h,t,g.foreground],i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q})}}};var c=function(u){if(u.children){for(var o=0;o<u.children.length;o++){c(u.children[o])}}if(u.parent){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=e?u.parent.x0:u.parent.y0;var s=e?u.parent.y0:u.parent.x0;var r=u._clicked?[q,s,q,s]:[b,i,b,i];var p=g.isHidden(false,u.id);g.toRender({p:["drawLine","bezier",q,s,m,t,g.treeLinkColor,g.treeLinkWidth,false,false,false,false,false,false,false,false,false,g.treeCircular?[u.mx,u.my,u.mx2,u.my2]:false],i:[u.parent.id+":"+u.id],b:r,t:"Data",h:p});u._clicked=false}};var b=e?l.x0:l.y0;var i=e?l.y0:l.x0;c(l);if(!f){j(l)}}};this.zoomOncoprintVariables=function(c){if(this.isTransition()){return}var b=[];this.setOriginalIndices(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.draw({func:"zoomOncoprintVariables",par:[c]})}};CanvasXpress.prototype.init3dUtils=function(){this.setTrigonometry=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.set3DRotation=function(){this.setTrigonometry();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.set3DParams=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.get3DTransfrom=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h}};CanvasXpress.prototype.initApiUtils=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.hasDecorations=function(){return this.decorations&&(this.decorations.nlfit||this.decorations.line||this.decorations.reg||this.decorations.nor||this.decorations.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.getHeatmapSchemes=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.isCompatibleGraphType=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.isOneDimensionalGraph=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.isOneDimensionalCombinationGraph=function(){return this.graphType.match(/BarLine|StackedLine|StackedPercentLine|AreaLine|DotLine/)};this.isHistogramLayout=function(){return this.isHistogram&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(a){return this.getObjectArray(a?this.highlightVar:this.highlightSmp)};this.modifyOverlaysProperties=function(g){if(this.isTransition()){return}var e=[];if(!this.isArray(g)){for(var d=0;d<arguments.length;d++){e.push(this.cloneObject(arguments[d]))}g=this.cloneObject(e)}else{e=this.cloneObject(g)}var b;var c=this;var a=e.shift();var f=this.cloneObject(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.draw({func:"modifyOverlaysProperties",par:[g]})};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.getXData=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.getZData=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.getXZData=function(){return this.graphType.match(/Scatter/)?this.getZData():this.getXData()};this.getSamplesVariablesAsArray=function(){return this.graphType.match(/scatter/i)?this.getSamplesAsArray():this.getVariablesAsArray};this.getSamplesAsArray=function(){var d=this.getSamples();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getVariablesAsArray=function(){var d=this.getVariables();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getNodeData=function(a){return this.getNetworkData("nodes",a)};this.getEdgeData=function(a){return this.getNetworkData("edges",a)};this.isBooleanData=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.getKeys(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.getSampleVariableData=function(l,r,q,k,s){var h={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var c={};c[l]={o:{},t:"string"};if(r){c[l]["o"]=this.getObjectArray(this.data.y[l])}else{for(var f=0;f<this[h[l]["idx"]].length;f++){c[l]["o"][this.data.y[l][this[h[l]["idx"]][f]]]=true}}if(k||s){var n=k?this.getVariableIndices(q):this.getSampleIndices(q,true);if(this.isArray(q)){for(var b=0;b<q.length;b++){var n=k?this.getVariableIndices(q[b]):this.getSampleIndices(q[b],true);if(n>-1){c[q[b]]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q[b]];c[q[b]]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.range(g);c[q[b]]["o"]={min:a[0],max:a[1]}}}}}else{var n=k?this.getVariableIndices(q):this.getSampleIndices(q,true);if(n>-1){c={};c[q]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q];c[q]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.range(g);c[q]["o"]={min:a[0],max:a[1]}}}}}if(this.data[h[l]["spc"]]){for(var j in this.data[h[l]["spc"]]){if(q&&j!=q){continue}var e=this.meta.data[h[l]["spc"]][j];c[j]={o:{},t:e.type.toLowerCase()};if(r){if(e.type=="Numeric"){c[j]["t"]="numeric";c[j]["o"]={min:e.rmin,max:e.rmax}}else{c[j]["t"]="string";c[j]["o"]=this.cloneObject(e.levels)}}else{for(var f=0;f<this[h[l]["idx"]].length;f++){var d=this.getMetadataValue(this[h[l]["idx"]][f],h[l]["spc"],j,true);if(!c[j]["o"].hasOwnProperty(d)){c[j]["o"][d]=true}}if(c[j]["t"]=="numeric"){var g=[];for(var d in c[j]["o"]){for(var f=0;f<c[j]["o"][d];f++){g.push(d)}}var a=this.range(g);c[j]["o"]={min:a[0],max:a[1]}}}}}return c};this.getNetworkData=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.getAdditionalData(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.getKeys(this[d+"Data"])}else{return false}};this.getFilteredNetworkData=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.getAdditionalData(d,b,this[g+"Properties"])}}this.isBooleanData(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.range(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.getFeatureData=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.getObjectArray(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.getAdditionalData(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.getKeys(this.featuresData)};this.getAdditionalData=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.getOperators=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.zoonIn=function(a){this.handleWheelEvent(a,1)};this.zoonOut=function(a){this.handleWheelEvent(a,-1)};this.clusterSamples=function(b,a){if(this.isTransition()){return}this.clusterAxis="samples";if(b||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.cluster()}if(!a){this.draw({func:"clusterSamples",par:[b,a]})}};this.clusterVariables=function(b,a){if(this.isTransition()){return}this.clusterAxis="variables";if(b||!this.varDendrogramNewick){this.varDendrogramNewick=this.cluster()}if(!a){this.draw({func:"clusterVariables",par:[b,a]})}};this.kmeansSamples=function(e,d){if(this.isTransition()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.kmeans();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.smpOverlays.includes("k-Means-S")){this.smpOverlays.push("k-Means-S")}this.updateMetaData("x","k-Means-S",false,true);this.modifySort("cat","smp","k-Means-S",true)}if(!d){this.draw({func:"kmeansSamples",par:[e,d]})}};this.kmeansVariables=function(e,d){if(this.isTransition()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.kmeans();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.varOverlays.includes("k-Means-V")){this.varOverlays.push("k-Means-V")}this.updateMetaData("z","k-Means-V",false,true);this.modifySort("cat","var","k-Means-V",true)}if(!d){this.draw({func:"kmeansVariables",par:[e,d]})}};this.setFunctions=function(){var a=this.functions;a.push("clusterSamples");a.push("clusterVariables");a.push("transpose");a.push("transform");a.push("hideUnhideSmps");a.push("hideUnhideVars");a.push("desegregateSamples");a.push("segregateSamples");a.push("groupSamples");a.push("ungroupSamples");a.push("desegregateVariables");a.push("segregateVariables");a.push("kmeansSamples");a.push("kmeansVariables");a.push("createContour");a.push("removeContour");a.push("showCodeDiv");a.push("hideCodeDiv");a.push("showInfoDiv");a.push("hideInfoDiv");a.push("updateCodeDiv");a.push("createHistogram");a.push("removeHistogram");a.push("addRegressionLine");a.push("addNormalDistributionLine");a.push("recalculateLayout");a.push("createRandomData");a.push("drawArea");a.push("draw");a.push("reset");a.push("print")};this.initializeApi=function(){this.setFunctions()}};CanvasXpress.prototype.initDimensionUtils=function(){this.resizeCanvas=function(a,o,e){var c=this.margin;var j=this.meta.canvas.canvasPixelRatio;if(a||o||e){if(o||e){if(o){this.width=o;this.originalWidth=o}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.getTitleSubtitleHeight();this.left=c;this.right=c;this.bottom=c;this.resetRender()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width*j;this.meta.canvas.ctx.canvas.height=this.height*j;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width*j;this.meta.canvas.ctx2.canvas.height=this.height*j;this.meta.canvas.ctx2.canvas.style.width=this.width+"px";this.meta.canvas.ctx2.canvas.style.height=this.height+"px";this.meta.canvas.ctx.scale(j,j);this.meta.canvas.ctx2.scale(j,j)}this.toRender({p:["disableGradientTransparencyShadow"],t:"Size"});if(this.backgroundType=="image"){if(this.graphType=="Network"){var n=this.scaleFactorX||1;var l=this.scaleFactorY||1;var b=this.offsetX*n;var q=this.offsetY*l;var k=this.maxX?this.maxX*n:this.maxX;var d=this.maxY?this.maxY*l:this.maxY;var p=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.isInIframe()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.toRender({p:["drawShape","image",(k/2)+b,(d/2)+q,k,d,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(this.backgroundImage)],0,0,this.maxX,this.maxY,b,q,k,d,p)}}else{this.toRender({p:["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="windowImage"){if(this.graphType=="Network"){this.toRender({p:["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"){this.toRender({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.background,this.background],t:"Size"})}else{var i=this.getLinearGradient(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0);this.toRender({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,i,i],t:"Size"})}}}this.toRender({p:["enableGradientTransparencyShadow"],t:"Size"})};this.setWidth=function(a,b){this.setDimensions(a,false,b)};this.setHeight=function(b,a){this.setDimensions(false,b,a)};this.getWidth=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.getHeight=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.setDimensions=function(j,b,l,k,i,a){if(this.isTransition()){return}if(!this.resizable){return}if(j<5||b<5){return}if(j&&b){if(Math.abs(this.width-j)<5&&Math.abs(this.height-b)<5){return}}if(!j||!this.resizableX){j=this.width}if(!b||!this.resizableY){b=this.height}var g=this.meta.canvas.ctx.canvas;j=g.originalWidth=parseInt(j);b=g.originalHeight=parseInt(b);this.clickLayoutNoAnimation(l);if(!this.reproducing){this.removeMotionDiv(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.draw({width:j,height:b,func:"setDimensions",par:[j,b,l,k,i,a]});this.updateRemoteNavigationWindow();if(k){var d=this;setTimeout(function(){d.resizeViewport()},k)}else{this.resizeViewport()}if(i){try{i()}catch(f){}}};this.initializeDimensions=function(){var a=this.margin;var b=this.meta.canvas.ctx.canvas;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.getTitleSubtitleHeight();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)}};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.validateLegendPositions=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition&&!this.legendPosition.toLowerCase().match("top")&&!this.legendPosition.toLowerCase().match("bottom")&&!this.legendPosition.toLowerCase().match("right")&&!this.legendPosition.toLowerCase().match("left")){if(this.graphType=="Circular"){if(this.legendPosition!="top"){this.legendPosition="right"}}else{if(this.graphType!="Pie"){this.legendPosition="right"}}}}if(this.graphType=="Pie"&&this.layoutValid){this.legendPosition="right"}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid&&!this.getLayoutConfig("legendPosition")){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.setLegendTextFont=function(){if(this.autoScaleFont){var e=(1-this.percentAspectRatioPlotArea);var b=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var c=this.layoutComb&&this.isDOE?this.layoutHeight:this.height;var a=this.min(b*e,c*e);this.setPropertyFontSize(a/(this.graphType=="Circular"?1.66:1),"legendTextFont");this.setPropertyFontSize(a/(this.graphType=="Circular"?1.66:1),"legendTitleFont")}else{this.legendTextFont=this.legendTextFontStyle+" "+parseInt(this.legendTextFontSize)+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+parseInt(this.legendTitleFontSize)+"px "+this.fontName}};this.drawLegendBackgroundBox=function(c,o,m,f,k,i){var g="solid";var n=this.useRoundRectangles?"roundrect":"rectangle";var q=i?this.showDecorationsBorder:this.showLegendBorder;var j=i?this.decorationsBackgroundColor:this.legendBackgroundColor;var b=!q?"rgba(0,0,0,0)":i?this.decorationsBackgroundBorderColor:this.legendBackgroundBorderColor;var e=!q?0:i?this.decorationsBackgroundBorderSize:this.legendBackgroundBorderSize;var p=[0,0,this.width,this.height];this.disableGradientTransparencyShadow();this.toRender({p:["drawShape",n,c+(m/2),o+(f/2),m,f,j,b,g,false,e,true,p],i:[-1],m:k,t:"Legends"});this.enableGradientTransparencyShadow()};this.drawLegendTitle=function(l,k,n,f,b,c,g){this.drawLegendBackgroundBox(l,k,n,f,c,g);if(b&&this.showLegendTitle){var j=this.getFontPt(this.legendTitleFont);var e=j/2;var a=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-n/2:n/2;k+=this.legendTitleMargin+e;this.toRender({p:["drawText",b,l+(n/2)+a,k,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"});k+=e+this.legendTitleMargin-this.legendBackgroundBorderSize;this.disableGradientTransparencyShadow();if(this.showLegendBorder){this.toRender({p:["drawLine","line",l,k,l+n,k,this.legendBackgroundBorderColor,this.legendBackgroundBorderSize],t:"Legends"})}this.enableGradientTransparencyShadow()}};this.drawLegendShape=function(m,k,o,q,j,l,a,n,d,f,e){return this.toRender({p:["drawShape",o,m,k,q,q,j,l,a,false,n],i:d,g:f,t:"Legends",h:e})};this.drawLegendLine=function(l,k,n,o,j,m,d,f,e){var b=l-(o/1.1);var a=l+(o/1.1);return this.toRender({p:["drawLine",n,b,k,a,k,j,m],i:d,g:f,t:"Legends",h:e})};this.drawLegendText=function(a,m,d,k,l,b,j,e){return this.toRender({p:["drawText",d,a,m,k,l,"left","middle"],i:b,g:j,t:"Legends",h:e})};this.drawKeyShape=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j||0,Math.ceil(this.getFontPt(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(k*0.6);var v=this.drawLegendShape(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(u)?u:["legend-key-"+u],z,w);if(!z){z=v}this.drawLegendShape(e,a,f,A,C,D,n,1,this.isArray(u)?u:["legend-shape-"+u],z,w);this.drawLegendText(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.isArray(u)?u:["legend-text-"+u],z,w)};this.drawKeySize=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j[1],Math.ceil(this.getFontPt(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(j[0]);var v=this.drawLegendShape(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(u)?u:["legend-key-"+u],z,w);if(!z){z=v}this.drawLegendShape(e,a,f,A,C,D,n,1,this.isArray(u)?u:["legend-shape-"+u],z,w);this.drawLegendText(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.isArray(u)?u:["legend-text-"+u],z,w)};this.drawKeyLine=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.getFontPt(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.6);var a=Math.ceil(B*0.5);var w=this.drawLegendShape(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.drawLegendLine(f,e,C,a,n,1.5,this.isArray(v)?v:["legend-line-"+v],A,z);this.drawLegendText(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.isArray(v)?v:["legend-text-"+v],A,z)};this.drawKeyLineSize=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.getFontPt(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.6);var a=Math.ceil(B*0.5);var w=this.drawLegendShape(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.drawLegendLine(f,e,C,a,n,j,this.isArray(v)?v:["legend-line-"+v],A,z);this.drawLegendText(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.isArray(v)?v:["legend-text-"+v],A,z)};this.drawKeyShapeLine=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.getFontPt(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.3);var a=Math.ceil(F*0.7);var w=this.drawLegendShape(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.drawLegendShape(f,e,j,B,D,E,o,1,this.isArray(v)?v:["legend-shape-"+v],A,z);this.drawLegendLine(f,e,C,a,n,1.5,this.isArray(v)?v:["legend-line-"+v],A,z);this.drawLegendText(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.isArray(v)?v:["legend-text-"+v],A,z)};this.drawKeyBoxplot=function(k,j,m,n,G,H,u,F,r,w,A,D,C){var v=this.legendTextMargin;var o=Math.max(n||0,Math.ceil(this.getFontPt(this.legendTextFont)))+v;var I=Math.ceil(o/2);var E=Math.ceil(o*0.75);var z=Math.ceil(o*0.4);var J=Math.ceil(E*0.6);var a=Math.ceil(E*0.5);var f=u||"solid";var e=this.useOpenShapes?H:this.foreground;var B=this.drawLegendShape(k,j,"rectangle",o,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(A)?A:["legend-key-"+A],D,C);if(!D){D=B}this.toRender({p:["drawLine",f,k,j-J,k,j+J,e,1],i:this.isArray(A)?A:["legend-vline-"+A],g:D,t:"Legends",h:C});this.toRender({p:["drawShape","rectangle",k,j,E,z,G,e,u,false,1],i:this.isArray(A)?A:["legend-shape-"+A],g:D,t:"Legends",h:C});this.drawLegendLine(k,j,f,a*1.1,e,1,this.isArray(A)?A:["legend-hline-"+A],D,C);this.drawLegendText(k+I+v,j,w,this.legendTextFont,this.legendTextColor,this.isArray(A)?A:["legend-text-"+A],D,C)};this.drawKeyConfidence=function(j,f,k,m,F,G,u,E,o,w,z,C,B){var v=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.getFontPt(this.legendTextFont)))+v;var H=Math.ceil(n/2);var D=Math.ceil(n*0.75);var a=Math.ceil(D*0.35);var r=this.addColorTransparency(F,0.5);var e=u||"solid";var A=this.drawLegendShape(j,f,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(z)?z:["legend-key-"+z],C,B);if(!C){C=A}this.drawLegendShape(j,f,"rectangle",D,r,r,u,1,this.isArray(z)?z:["legend-shape-"+z],C,B);this.drawLegendLine(j,f,E,a,G,1.5,this.isArray(z)?z:["legend-line-"+z],C,B);this.drawLegendText(j+H+v,f,w,this.legendTextFont,this.legendTextColor,this.isArray(z)?z:["legend-text-"+z],C,B)};this.drawKeyLollipop=function(j,f,k,m,F,G,r,E,o,v,z,C,B){var u=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.getFontPt(this.legendTextFont)))+u;var H=Math.ceil(n/2);var D=Math.ceil(n*0.75);var w=Math.ceil(n*0.3);var a=Math.ceil(D*0.5);var e=r||"solid";var A=this.drawLegendShape(j,f,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.isArray(z)?z:["legend-key-"+z],C,B);if(!C){C=A}if(this.graphOrientation=="vertical"){this.toRender({p:["drawLine",e,j,f-a,j,f+a,G,1.5],i:this.isArray(z)?z:["legend-line-"+z],g:C,t:"Legends",h:B});this.toRender({p:["drawShape","circle",j,f-(w*0.7),w,w,F,G,r,false,1],i:this.isArray(z)?z:["legend-shape-"+z],g:C,t:"Legends",h:B})}else{this.toRender({p:["drawLine",e,j-a,f,j+a,f,G,1.5],i:this.isArray(z)?z:["legend-line-"+z],g:C,t:"Legends",h:B});this.toRender({p:["drawShape","circle",j+a-(w*0.3),f,w,w,F,G,r,false,1],i:this.isArray(z)?z:["legend-shape-"+z],g:C,t:"Legends",h:B})}this.drawLegendText(j+H+u,f,v,this.legendTextFont,this.legendTextColor,this.isArray(z)?z:["legend-text-"+z],C,B)};this.drawKeyLabel=function(B,z,C,D,w,A,f,u,a,j,k,r,n){var e=this.legendTextMargin;var v=Math.max(D||0,Math.ceil(this.getFontPt(this.legendTextFont)))+e;var m=Math.ceil(v/2);var o=this.drawLegendShape(B,z,"rectangle",v,w,A,f,1,this.isArray(k)?k:["legend-shape-"+k],r,n);if(!r){r=o}this.drawLegendText(B+m+e,z,j,this.legendTextFont,this.legendTextColor,this.isArray(k)?k:["legend-text-"+k],r,n)};this.getDiameterLegend=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*14/833).toFixed(1))*this.legendTextScaleFontFactor};this.setCustomLegendDimensions=function(k){var e=k.text.length;var x=this.getDiameterLegend();var B=k.size;if(B){for(var o=0;o<B.length;o++){if(B[o]){x=Math.max(x,B[o])}}}var A=this.measureText(k.title&&this.showLegendTitle?k.title:"",this.legendTitleFont)+(this.legendTitleMargin*2);var j=this.measureText(this.getMaxText(k.text),this.legendTextFont);var v=this.getFontPt(this.legendTextFont);var u=this.getFontPt(this.legendTitleFont);var y=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/y);var z=Math.max(A,((j+x+(this.legendTextMargin*2))*y)+(this.legendTextMargin*2));var b=(a*(Math.max(x,v)+this.legendTextMargin))+this.legendTextMargin;var p=k.title&&this.showLegendTitle?b+u+(this.legendTitleMargin*2):b;if(!this.legend[k.id]){this.legend[k.id]={}}this.legend[k.id].columns=y;this.legend[k.id].meta=k;this.legend[k.id].width=z;this.legend[k.id].height=p};this.setPropertyLegendDimensions=function(h,s,e,u){this.setPropertyLegendIter=u||0;if(this.setPropertyLegendIter>3){return}var a=this.decapitalize(h)+"By";if((this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network"))||h=="sample"){var w,j,t;if(s){w=this[a];if(e.type=="Numeric"&&h!="sizeEdge"&&((h.match(/shape/i)&&!this.shapeByContinuous)||(h.match(/size/i)&&!this.sizeByContinuous))){j=" "+s+" - "+s+" ";if(e){e.maxLevStrMod=j;e.isRange=true}}else{j=s}t=e&&e.sizes?e.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){w=this[a];j=this.meta.data.x[this[a]].maxLevStrMod||this.meta.data.x[this[a]].maxLevStr;t=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){w=this[a];j=this.meta.data.z[this[a]].maxLevStrMod||this.meta.data.z[this[a]].maxLevStr;t=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){w=this[a];j=this.meta.data.nodes[this[a]].maxLevStr;t=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){w=this[a];j=this.meta.data.edges[this[a]].maxLevStr;t=this.meta.data.edges[this[a]].sizes||this.sizes}else{w=0;j=0;t=this.sizes}}}}}var q=this.getDiameterLegend();if(h=="size"||h=="sizeNode"){for(var k=0;k<this.legend[h].n;k++){if(t[k]){q=Math.max(q,t[k])}}}else{if(h=="sample"){w=0;j=this.legend.sample.maxStr}}if(j.length>this.maxTextSize){j=j.substring(0,this.maxTextSize-3)+"..."}var o=this.getFontPt(this.legendTextFont);var n=this.getFontPt(this.legendTitleFont);var r=this.legendColumns;var y=r>this.legend[(h=="outline"?"color":h)].n?this.legend[(h=="outline"?"color":h)].n:r;var b=Math.ceil(this.legend[(h=="outline"?"color":h)].n/y);var v=this.showLegendTitle?this.measureText(w,this.legendTitleFont)+(this.legendTitleMargin*2):0;var x=((this.measureText(j,this.legendTextFont)+Math.max(q,o)+this.legendTextMargin*2)*y)+(this.legendTextMargin*2);this.legend[(h=="outline"?"color":h)].columns=y;this.legend[(h=="outline"?"color":h)].width=Math.max(v,x);this.legend[(h=="outline"?"color":h)].height=(b*(Math.max(q,o)+this.legendTextMargin))+this.legendTextMargin+(h=="sample"?0:(this.showLegendTitle?n+(this.legendTextMargin*2):0));if(this.graphType=="Map"&&this.mapProjection=="orthographic"){this.legend[(h=="outline"?"color":h)].width=0;this.legend[(h=="outline"?"color":h)].height=0}else{if(this.legend[(h=="outline"?"color":h)].height>this.height){this.legendColumns++;this.legend[(h=="outline"?"color":h)].columns++;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.setPropertyLegendDimensions(h,s,e,this.setPropertyLegendIter+1)}else{if(this.legend[(h=="outline"?"color":h)].width>this.width&&this.legend[(h=="outline"?"color":h)].columns>1){this.legendColumns--;this.legend[(h=="outline"?"color":h)].columns--;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.setPropertyLegendDimensions(h,s,e,this.setPropertyLegendIter+1)}}}}};this.setPropertyLegendIndicatorDimensions=function(d,c){var a=this.decapitalize(d)+"By";var n=0;var i=0;var k=this.getFontPt(this.legendTextFont);var j=this.getFontPt(this.legendTitleFont);if(this[a]||d=="decoration"||d=="contour"||d=="bin2d"){switch(d){case"color":case"colorNode":case"colorEdge":case"outline":case"decoration":case"contour":case"bin2d":var b=this.showLegendTitle?this.measureText(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendTitleFont)+(this.legendTitleMargin*2):0;var e=c.maxLevLen+(this.legendTextMargin*3);if(this.legendPosition.match(/top|bottom/)){if(this.showLegendTitle){i+=j+(this.legendTitleMargin*2)}i+=this.heatmapIndicatorHeight+(this.legendTextMargin*3)+k;n=this.heatmapIndicatorWidth+Math.max(b,e)}else{i=this.heatmapIndicatorWidth+(this.legendTextMargin*2)+(this.showLegendTitle?j+(this.legendTitleMargin*2):0);n=this.heatmapIndicatorHeight+Math.max(b,e)+(this.legendTextMargin*2)}break;case"shape":case"shapeNode":case"shapeEdge":case"size":case"sizeNode":case"sizeEdge":this.setPropertyLegendDimensions(d,c.maxLevStr,c);return;case"pattern":case"patternNode":case"patternEdge":n=0;i=0;break}}this.legend[(d=="outline"?"color":d)].width=n;this.legend[(d=="outline"?"color":d)].height=i};this.setDecorationsLegendDimensions=function(){this.legend.decoration.width=0;this.legend.decoration.height=0;this.legend.decoration.maxLabel=0;this.legend.decoration.columns=this.legendColumns;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var o=this.getFontPt(this.decorationsTextFont);var h=this.decorations;var n=0;var m=["nlfit","reg","nor","area"];var g=[96,45,30,0,0,0,0];var k=[5,2,1,0,0,0,0];for(var f=0;f<m.length;f++){if(h[m[f]]){var b=k[f]?this.measureText(this.sprintf("%"+g[f]+"s","X"),this.decorationsTextFont)+(this.decorationsTextMargin*k[f])+this.decorationsTextMargin:0;var l=0;for(var c=0;c<h[m[f]].length;c++){var e=this.measureText(h[m[f]][c].label,this.decorationsTextFont);l=Math.max(e,l);this.legend.decoration.maxLabel=Math.max(l,this.legend.decoration.maxLabel)}n=Math.max(n,this.decorationsTextMargin+l+this.decorationsTextMargin+b);this.legend.decoration.height=(h[m[f]].length*(o+this.decorationsTextMargin))+o+this.decorationsTextMargin}}if(this.graphType=="Map"&&h.pie&&h.pie[0]&&h.pie[0].smps&&h.pie[0].smps.length){var l=0;var a=this.getFontPt(this.decorationsTextFont);for(var f=0;f<h.pie[0].smps.length;f++){var e=this.measureText(h.pie[0].smps[f],this.decorationsTextFont);l=Math.max(e,l);this.legend.decoration.maxLabel=Math.max(l,this.legend.decoration.maxLabel)}n=Math.max(n,(l+(this.decorationsTextMargin*3)+(a*2))*Math.min(h.pie[0].smps.length,this.legend.decoration.columns));this.legend.decoration.height+=(Math.ceil(h.pie[0].smps.length/Math.min(h.pie[0].smps.length,this.legend.decoration.columns))*a*1.5)+(this.decorationsTextMargin*2)}this.legend.decoration.width=n}};this.setOncoprintLegendDimension=function(){this.legend.oncoprint.width=0;this.legend.oncoprint.height=0;this.legend.oncoprint.colors={};if(this.isOncoprint){var g=this.cloneObject(this.meta.data[this.oncoprintCNA].levels);var h=this.cloneObject(this.meta.data[this.oncoprintCNA].colors);var b=[];g.push("No Alteration");h.push("rgb(220,220,220");for(var e=0;e<g.length;e++){b.push("CNA")}var k=g.length;if(this.oncoprintMUT){g=g.concat(this.cloneObject(this.meta.data[this.oncoprintMUT].levels));h=h.concat(this.cloneObject(this.meta.data[this.oncoprintMUT].colors));for(var e=k;e<g.length;e++){b.push("MUT")}}var j=[];var f=[];for(var e=0;e<g.length;e++){if(g[e]){j.push(g[e]);f.push(b[e]);this.legend.oncoprint.colors[g[e]]=h[e];if(h[e]=="rgb(220,220,220"){this.legend.oncoprintMutations=j.length}}}var d=this.getMaxText(j,this.legendTextFont);var c=this.measureText(d,this.legendTextFont);var a=Math.ceil(c+5+(this.margin*8));var h=Math.floor(this.width/a);var l=Math.ceil(j.length/h);this.legend.oncoprint.width=a*h;this.legend.oncoprint.height=((21+this.margin)*l)+this.margin;this.legend.oncoprint.rows=l;this.legend.oncoprint.cols=h;this.legend.oncoprint.labels=j;this.legend.oncoprint.objects=f}};this.setSampleLegendDimension=function(){this.legend.sample.width=0;this.legend.sample.height=0;this.legend.sample.columns=this.legendColumns;this.legend.sample.maxStr="";this.legend.sample.maxStrLen=0;this.legend.sample.n=1;var k=this.getFontPt(this.legendTextFont);var g=0;var h=0;var a=[];var b={};if(this.ridgeBy&&this.dataStndBy.y.smps.length==1){return}if(this.colorBy&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.colorBy)&&((this.xAxisIndices&&this.xAxisIndices.length==1)||(this.yAxisIndices&&this.yAxisIndices.length==1))){return}if(this.isHistogram&&this.isHistogramLayout()){for(var d=0;d<this.data.l.axes.length;d++){for(var c=0;c<this.data.l.axes[d].yAxis.length;c++){if(this.data.l.axes[d].yAxis[c]){if(this.segregateVariablesBy.length||!this.data.l.axes[d].yAxis[c].match(":")){b[this.data.l.axes[d].yAxis[c].split(":")[0]]=true}else{if(this.data.l.axes.length==this.dataStndBy.y.smps.length){b[this.data.l.axes[d].yAxis[c].split(":")[1]]=true}else{b[this.data.l.axes[d].yAxis[c]]=true}}}}}a=this.getKeys(b)}if(this.graphType.match(/Scatter/)){h=this.ridgeBy?this.dataStndBy.y.smps.length:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);if(this.ridgeBy){g=this.measureText(this.shortenText(this.getMaxText(this.dataStndBy.y.smps),this.maxSmpStringLen),this.legendTextFont)}else{if(this.isHistogram){g=this.measureText(this.shortenText(this.getMaxText(this.data.y.smps),this.maxSmpStringLen),this.legendTextFont);h=this.data.y.smps.length-1;if(this.isHistogramLayout()){h=a.length;g=this.measureText(this.shortenText(this.getMaxText(a),this.maxSmpStringLen),this.legendTextFont)}else{if(this.histogramAsDotplot&&this.colorBy){g=0}}}else{if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var d=0;d<this.xAxisIndices.length;d++){var f=this.shortenText(this.xAxis[d],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[d],this.maxSmpStringLen);var e=this.measureText(f,this.legendTextFont);if(e>g){this.legend.sample.maxStr=f}g=Math.max(e,g)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){this.legend.sample.maxStr=this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen);g=this.measureText(this.legend.sample.maxStr,this.legendTextFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){this.legend.sample.maxStr=this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen);g=this.measureText(this.legend.sample.maxStr,this.legendTextFont)}}}}}}if(g){this.legend.sample.n=h;this.legend.sample.maxStrLen=g;this.legend.sample.width=((k+g+(this.legendTextMargin*2))*this.legend.sample.columns)+(this.legendTextMargin*2);this.legend.sample.height=(Math.ceil(h/this.legend.sample.columns)*(k+this.legendTextMargin))+this.legendTextMargin}}};this.setVariableLegendDimension=function(k){if(this.showLegend){this.legend.variable.width=0;this.legend.variable.height=0;this.legend.variable.columns=k||this.legendColumns;var h=this;var q=this.legend.variable.columns;var g=function(){if(h.isDOE&&h.layoutCurrentDOE){if(h.layoutCurrentDOE){if(h.meta.data.x&&h.meta.data.x.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.x[h.layoutCurrentDOE]}else{if(h.meta.data.z&&h.meta.data.z.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.z[h.layoutCurrentDOE]}}}}return h.meta.data.y};var c=g();var a=this.getFontPt(this.legendTextFont);if(this.graphType=="Fish"){var r=this.getFontPt(this.legendTextFont);var b=this.varIndices.length;var f=this.shortenText(c.maxVarStr,this.maxVarStringLen);this.legend.variable.width=((a+(this.legendTextMargin*2)+this.measureText(f,this.legendTextFont))*q)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,q))*(r+this.legendTextMargin))+(this.legendTextMargin*2)}if(this.graphType=="Pie"){var b=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var f=this.isDOE&&this.layoutCurrentDOE?this.shortenText(c.maxLevStr,this.maxVarStringLen):this.shortenText(c.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&f.length<5){f=this.shortenText("Other",this.maxVarStringLen)}var e=this.measureText(f,this.legendTextFont)+a+(this.legendTextMargin*3);var o=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var j=(1-this.percentAspectRatioPlotArea);this.legend.variable.width=e>o*j?o*j:this.measureText(f,this.legendTextFont)+a+(this.legendTextMargin*5);this.legend.variable.height=((a+this.legendTextMargin)*b)+(this.legendTextMargin*2)}else{if(this.layoutValid&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{if(!this.colorBy||(this.colorBy&&this.colorBy=="variable")){var r=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.measureText(r,this.legendTextFont))*q)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(this.varIndices.length/Math.min(b,q))*(a+this.legendTextMargin))+this.legendTextMargin}else{return}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var r=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendTextFont)):this.getFontPt(this.legendTextFont);var b=this.varIndices.length;var f=this.shortenText(c.maxVarStr,this.maxVarStringLen);this.legend.variable.width=r+this.measureText(f,this.legendTextFont)+((this.legendTextMargin*2)*Math.min(b,q))+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,q))*(r+this.legendTextMargin))+(this.legendTextMargin*2)}else{if(!this.colorBy&&(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine")){var r=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.xAxisVarIndices.length+this.xAxis2VarIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.measureText(r,this.legendTextFont))*q)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,q))*(a+this.legendTextMargin))+this.legendTextMargin}else{if(!this.colorBy&&(this.graphType=="Bar"||(this.graphType=="Line"&&!this.lineBy)||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var r=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.measureText(r,this.legendTextFont))*q)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(this.varIndices.length/Math.min(b,q))*(a+this.legendTextMargin))+this.legendTextMargin}else{if(this.graphType=="Circular"&&!this.showIdeogram){var r=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var i=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.measureText(r,this.legendTextFont))*q)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(i/Math.min(i,q))*(a+this.legendTextMargin))+this.legendTextMargin}}}}}}if(this.legend.variable.height>this.height){this.legend.variable.columns++;this.maxVarStringLen=Math.max(10,this.maxVarStringLen-5);this.setVariableLegendDimension(this.legend.variable.columns)}}};this.setVennLegendDimension=function(){var a=this.data.venn.legend?this.getMaxText(this.data.venn.legend):"N/A";this.legend.width=this.measureText(a,this.legendTextFont)+(this.margin*6);this.legend.height=this.margin+this.margin+((this.getFontPt(this.legendTextFont)+this.margin)*this.vennGroups)};this.setOverlaysLegendDimensions=function(){var b=this.getFontPt(this.legendTextFont)+2;var s=this.getDiameterLegend();var k=Math.max(b,s);var d=["varOverlays","smpOverlays"];var e=["varOverlayProperties","smpOverlayProperties"];var y=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legend.overlays.layout=[];this.legend.overlays.width=0;this.legend.overlays.height=0;var q=this.margin;var n=this.margin;var a=0;var g=0;var l=0;var B=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)){for(var v=0;v<d.length;v++){if(this[d[v]].length>0&&this[y[v]]){for(var t=0;t<this[d[v]].length;t++){var f=0;var x=0;var p=this[d[v]][t];if(p!="-"){var A=d[v]=="varOverlays"?"z":"x";var r=this.meta.data[A][p];var u=this.measureText(r.maxLevStr,this.legendTextFont);var z=this.measureText(p,this.legendTitleFont);if(this.graphType=="Circular"||(this[e[v]][p]&&this[e[v]][p].type=="Default"&&this[e[v]][p].showLegend)){B=true;if(r.type=="String"){f=Math.max(z,u+k+(this.margin*3))*this[d[v]+"LegendColumns"];x=((Math.max(b,s)+this.margin)*Math.ceil(r.levels.length/this[d[v]+"LegendColumns"]))+b+this.margin}else{if(this.overlaysLegendPosition.match(/right/i)){f=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z);x=this.heatmapIndicatorWidth+(this.margin*3)+b}else{f=this.heatmapIndicatorWidth+(this.margin*3)+b;x=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z)}}if(!this.legend.overlays[p]){this.legend.overlays[p]={}}this.legend.overlays[p].width=f;this.legend.overlays[p].height=x;if(this.overlaysLegendPosition.match(/right/i)){if(g+this.margin+x>(this.height-(this.top+this.bottom))){q+=this.margin+f;a=f;g=x;if(this.legend.overlays.layout[l]){l++}this.legend.overlays.layout[l]=[[A,p,f,x]]}else{if(f>a){q+=(f-a);a=f}g+=x;if(!this.legend.overlays.layout[l]){this.legend.overlays.layout[l]=[]}this.legend.overlays.layout[l].push([A,p,f,x])}}else{if(a+this.margin+f>(this.width-(this.left+this.right))){n+=this.margin+x;a=f;g=x;if(this.legend.overlays.layout[l]){l++}this.legend.overlays.layout[l]=[[A,p,f,x]]}else{if(x>g){n+=(x-g);g=x}a+=f;if(!this.legend.overlays.layout[l]){this.legend.overlays.layout[l]=[]}this.legend.overlays.layout[l].push([A,p,f,x])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legend.overlays.width=B?q+this.margin:0;this.legend.overlays.height=B?g+this.margin:0}else{this.legend.overlays.width=B?a+this.margin:0;this.legend.overlays.height=B?n+this.margin:0}};this.setLegendDimensions=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legend.layout=[];this.legend.width=0;this.legend.height=0;var a=this.margin;var k=this.margin;var b=0;var j=0;var g=0;var e=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge","decoration"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","sample","contour","bin2d"];for(var c=0;c<e.length;c++){var f=this.legend[e[c]].width;var d=this.legend[e[c]].height;if(e[c]=="decoration"&&!this.showDecorations){continue}if(e[c]=="size"&&this.graphType=="Map"&&this.decorations&&this.decorations.pie){continue}if(f>0){if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legend.layout[g]=[e[c]];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legend.layout[g]){this.legend.layout[g]=[]}this.legend.layout[g].push(e[c])}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legend.layout[c]=[e[c]];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legend.layout[g]){this.legend.layout[g]=[]}this.legend.layout[g].push(e[c])}}}}for(var c=0;c<this.customLegend.length;c++){this.customLegend[c].id="custom"+c;this.setCustomLegendDimensions(this.customLegend[c]);var f=this.legend["custom"+c].width;var d=this.legend["custom"+c].height;if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legend.layout[g]=[this.customLegend[c].id];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legend.layout[g]){this.legend.layout[g]=[]}this.legend.layout[g].push(this.customLegend[c].id)}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legend.layout[c]=[this.customLegend[c].id];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legend.layout[g]){this.legend.layout[g]=[]}this.legend.layout[g].push(this.customLegend[c].id)}}}this.legend.width=b==0&&a==this.margin?0:this.legendPosition.match(/right|left/i)?a+this.margin:b+this.margin;this.legend.height=j==0&&k==this.margin?0:this.legendPosition.match(/right|left/i)?j+this.margin:k+this.margin}};this.setLegends=function(w){var k=this;var j=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge"]:this.connectByNoColor?["color","shape","size","pattern","outline"]:["color","shape","size","line","pattern","outline","connect","contour","bin2d"];var z=["shapeByData","sizeByData","patternByData","outlineByData"];var v=function(a,b,x){var y=b=="outline"?"color":b;var p=(k.decapitalize(y)+"s").replace("Node","").replace("Edge","").replace("decorations","colors");delete (k.legend[y].levels);k.legend[y].meta=a;if(x){k.legend[y].meta.vals=k.colorSpectrumBreaks.length?k.colorSpectrumBreaks:k.rPretty(x[0],x[1],5);k.legend[y].meta.decs=k.getNumberDecimals(x[1]-x[0]);k.legend[y].meta.maxLevStr=k.getMaxText(k.legend[(b=="outline"?"color":b)].meta.vals);k.legend[y].meta.maxLevLen=k.measureText(k.legend[y].meta.maxLevStr,k.font);k.legend[y].meta.maxLevChr=k.legend[y].meta.maxLevStr.toString().length}if(k.ridgeBy&&k.colorBy=="data"){k.legend[y].meta.min=k.legend[y].meta.vals[0];k.legend[y].meta.max=k.legend[y].meta.vals[k.legend[y].meta.vals.length-1]}k.legend[y].max=k.legend[y].meta.maxLevStr;k.legend[y].n=k.legend[y].meta.vals.length;if(!k.legend[y].m){k.legend[y].m=[]}for(var o=0;o<k.legend[y].meta.vals.length;o++){k.legend[y].m[k.legend[y].meta.vals[o].toString()]=y=="connect"?k.colors[o]:y=="contour"?k.getColorForValue(a,k.legend[y].meta.vals[o]):y=="bin2d"?k.getColorForValue(a,k.legend[y].meta.vals[o]):k[p][o%k[p].length]}k.setPropertyLegendIndicatorDimensions(b,k.legend[y].meta)};var n=function(G,N,C,I,D){var K=0;var A=0;var F=false;var H={};var b={};var a=G[k.decapitalize(I).replace("Node","").replace("Edge","")+"s"]||k[k.decapitalize(I).replace("Node","").replace("Edge","")+"s"];var E=k.isGroupedData&&k.graphType!="Dotplot"&&k.graphType!="Boxplot"&&!k.showBoxplotOriginalData&&k.groupingFactors.length==1;if(N=="x"){var x;if(k.graphType=="Scatter2D"){x=k.xAxisIndices.length==1?k.yAxisIndices:k.yAxisIndices.length==1?k.xAxisIndices:k.smpIndices}else{x=k.isGroupedData?k.grpIndices:k.smpIndices}for(var L=0;L<x.length;L++){var y=x[L];if(k.isGroupedData&&(k.graphType=="Dotplot"||k.graphType=="Boxplot"||k.barType=="swimmer"||k.graphType=="Gantt"||k.stackBy||k.lineBy||k.dodgeBy)){k.isGroupedData=false;for(var J=0;J<k.data.w.grps[y].length;J++){var B=k.getMetadataValue(k.data.w.grps[y][J],N,k[C]);b[B]=true}k.isGroupedData=true}else{var B;if(k.isGroupedData){k.isGroupedData=false;B=k.getSmpAnnotations(k[C],k.data.w.grps[L],true);k.isGroupedData=true}else{B=k.getMetadataValue(y,N,k[C])}b[B]=true}}}else{if(N=="z"){if((k.graphType=="Map"&&k.varIndices.length<G.levels.length)||(k.isCreateHistogram&&k.histogramAsDotplot)){for(var L=0;L<G.levels.length;L++){var B=G.levels[L];b[B]=true}}else{for(var L=0;L<k.varIndices.length;L++){var y=k.varIndices[L];var B=k.getMetadataValue(y,N,k[C]);b[B]=true}}}else{if(N=="m"){for(var L=0;L<k.varIndices.length;L++){for(var J=0;J<k.smpIndices.length;J++){var B=D[k.varIndices[L]][k.smpIndices[J]];b[B]=true}}}else{if(N=="modified"){G.order={};for(var L=0;L<G.levels.length;L++){b[G.levels[L]]=true;G.order[G.levels[L]]=L}}else{if(N=="nodes"||N=="edges"){G.order={};for(var L=0;L<G.levels.length;L++){b[G.levels[L]]=true;G.order[G.levels[L]]=L}}}}}}b=k.getKeys(b);if(G.type=="Numeric"){if(G.orderS){b.sort(function(l,i){return G.orderS[l]-G.orderS[i]})}else{b.sort(function(l,i){return l-i});G.orderS={};for(var L=0;L<b.length;L++){G.orderS[b[L]]=L}}}else{b.sort(function(l,i){return G.order[l]-G.order[i]})}for(var L=0;L<b.length;L++){var B=b[L]!=null?b[L]:"NA";var M=k.measureText(B,k.legendTextFont);if(M>K){K=M;k.legend[I].max=B}H[B]=(G.type=="Numeric"?G.orderS[B]:G.order[B])%a.length;k.legend[I].m[B]=a[H[B]];A++}k.legend[I].levels=b;F=N=="m"||N=="modified"?k.legend[I].max:false;k.legend[I].n=A;k.legend[I].meta=G;k.setPropertyLegendDimensions(I,F,G)};if(!this.hiddenLegends){this.hiddenLegends={}}this.validateLegendPositions();this.setLegendTextFont();if(this.graphType=="Meter"||this.graphType=="Correlation"){return}else{if(this.graphType=="Venn"){this.setVennLegendDimension();return}else{if(this.graphType=="Network"){for(var h=0;h<j.length;h++){var f=j[h];var u=this.decapitalize(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0;if(this[c]){var e=this.meta.data[f.match("Node")?"nodes":"edges"][this[c]];if(e.type=="Numeric"){v(e,f)}else{n(e,f.match("Node")?"nodes":"edges",c,f)}}}if(this.decorations.length&&this.decorationsType=="heatmap"&&this.meta.data.decorations.n&&this.showDecorations){var e=this.meta.data.decorations;var f="decoration";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0;v(e,f)}}else{if(this.isMultidimensionalData){for(var h=0;h<z.length;h++){if(this.data.y[this[z[h]]]){var d=this.data.y[this[z[h]]];var e=this.meta.data[this[z[h]]];var f=z[h].replace("ByData","");var u=this.decapitalize(f);var c=u+"By";this.legend[(f=="outline"?"color":f)].m=[];this.legend[(f=="outline"?"color":f)].n=0;if(e.type=="Numeric"){v(e,f,[e.min,e.max])}else{n(e,"m",c,f,d)}}}}else{if(this.scatterType=="bin2d"){for(var h=0;h<j.length;h++){var f=j[h];var u=this.decapitalize(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0}if(!this.meta.data.b.g){var q=this.xAxisIndices[this.xAxisCurrent];var g=this.yAxisIndices[this.yAxisCurrent];var t=this.getAxisDataBySample(q,"x");var s=this.getAxisDataBySample(g,"y");var r=this.hist2d(t,s);this.meta.data.b.g=r;this.meta.data.b.c=r.brew}var f="bin2d";var e=this.meta.data.b.c;v(e,f)}else{if(this.isContour&&this.contourFilled){for(var h=0;h<j.length;h++){var f=j[h];var u=this.decapitalize(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0}if(!this.meta.data.q.g.length||!this.meta.data.q.g[0]||!this.meta.data.q.g[0].data){this.createContour(this.isContour,true)}var f="contour";var e=this.meta.data.q.g[0].data.colorBrew;v(e,f)}else{for(var h=0;h<j.length;h++){var f=j[h];var u=this.decapitalize(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0;if(w){continue}if(this.graphType=="Scatter2D"&&this.lineBy&&this.ribbonBy&&this.colorBy==this.lineBy&&c=="colorBy"){continue}if(this[c]){if(this.data.x&&this.data.x.hasOwnProperty(this[c])){var e=this.meta.data.x[this[c]];this[u+"ByType"]="x";if(e.type=="Numeric"&&!e[c]){v(e,f)}else{n(e,"x",c,f)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[c])){var e=this.meta.data.z[this[c]];this[u+"ByType"]="z";if(e.type=="Numeric"&&!e[c]){v(e,f,this.colorSpectrumBreaks.length?true:false)}else{n(e,"z",c,f)}}else{if(this.getSampleIndices(this[c])>-1&&this.meta.data.y.range[this[c]]){var e=this.meta.data;if(e.modified&&e.modified.z&&e.modified.z[this[c]]){e=e.modified.z;if(!e.meta){e.meta={}}e.meta[this[c]]={levels:e[this[c]]};n(e.meta[this[c]],"modified",c,f)}else{e=e.y.range[this[c]];v(e,f,[e.min,e.max])}}else{if(this[c]=="variable"){k.legend[f].n=this.varIndices.length}else{if(this.ridgeBy&&this[c]=="data"){v({type:"Numeric"},f,[this.xAxisMin,this.xAxisMax])}else{if(this.isCreateHistogram&&this.histogramAsDotplot&&this.dataStndBy&&this.dataStndBy.z&&this.dataStndBy.z.hasOwnProperty(this[c])){var e=this.meta.data.z[this[c]];if(e.type=="Numeric"&&!e[c]){v(e,f)}else{n(e,"z",c,f)}}}}}}}}}}}}}}}this.setDecorationsLegendDimensions();this.setSampleLegendDimension();this.setVariableLegendDimension();this.setOncoprintLegendDimension();this.setOverlaysLegendDimensions();this.setLegendDimensions()};this.addLegend=function(c,b){if(c){if(b){var a=this.findXYCoordinates(b);c.x=a.x;c.y=a.y}this.customLegend.push(c)}};this.deleteLegend=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.customLegend.length;a++){if(this.customLegend[a].id!=c.id){b.push(this.customLegend[a])}}this.customLegend=b}};this.drawDecorationData=function(){this.toRender({p:["setClipArea",this.setClipBoundaries()],t:"Decorations"});var ad=this.marginLeft+this.offsetX+this.left;var ab=this.marginTop+this.offsetY+this.top;var al=this.decorations;if(this.showDecorations&&al){if(this.graphType.match(/Scatter/)){if(al.nlfit){var h,R,f;var H=this.varIndices;var K,g;for(var ah=0;ah<al.nlfit.length;ah++){var aG=[];var aE=[];var Q=ah%this.colors.length;var a=Number(this.transformValue(this.yAxisTransform,al.nlfit[ah].param[0]));var aO=Number(this.transformValue(this.yAxisTransform,al.nlfit[ah].param[1]));var aN=Number(al.nlfit[ah].param[2]);var aM=Number(al.nlfit[ah].param[3]);var ac=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[ah];var aI=this.getDataForSmpGrpAtIndex(ac);if(this.xAxisTransform=="percentile"){h=this.range(aI);f=h[0];R=h[1]}H.sort(function(i,d){return aI[i]-aI[d]});Q=al.nlfit[ah].color?al.nlfit[ah].color:this.colors[Q];for(var ag=0;ag<H.length;ag++){var D=H[ag];var U=this.getDataAtPos(D,ac);var T;var P=[];if(U>0){if(ag>0){var aF=H[ag-1];var aJ=this.getDataAtPos(aF,ac);if(aJ>0){var V=(U-aJ)/25;for(var af=0;af<25;af++){P.push(aJ);aJ+=V}}}else{P=[U]}for(var af=0;af<P.length;af++){if(al.nlfit[ah].type=="reg"){T=a+((aO-a)/(1+aN/(Math.pow(P[af],aM))))}else{T=a+((aO-a)/(1+(Math.pow((P[af]/aN),aM))))}if(this.xAxisTransform){P[af]=this.xAxisTransform=="percentile"?this.percentile(f,R,P[af]):this.transformValue(this.xAxisTransform,P[af])}K=ad+((P[af]-this.xAxisMin)*this.xAxisUnit);g=(ab+this.y)-((T-this.yAxisMin)*this.yAxisUnit);aG.push(K);aE.push(g)}}}if(aG.length>0){this.toRender({p:["drawShape","path",aG,aE,false,false,Q,Q,"open",false,false,true],i:["Decor-Non-Lin-"+ag+"-"+ah],t:"Decorations"});if(al.nlfit[ah].type=="reg"){T=a+((aO-a)/(1+aN/(Math.pow(aN,aM))))}else{T=a+((aO-a)/(1+(Math.pow((aN/aN),aM))))}if(this.xAxisTransform){aN=this.xAxisTransform=="percentile"?this.percentile(f,R,aN):this.transformValue(this.xAxisTransform,aN)}K=ad+((aN-this.xAxisMin)*this.xAxisUnit);g=(ab+this.y)-((T-this.yAxisMin)*this.yAxisUnit);var aC=this.toRender({p:["drawLine","dottedLine",ad,g,K,g,Q],i:["Decor-Non-Lin-EC-h"+ag+"-"+ah],t:"Decorations"});this.toRender({p:["drawLine","dottedLine",K,g,K,(ab+this.y),Q],i:["Decor-Non-Lin-EC-v"+ag+"-"+ah],g:aC,t:"Decorations"})}}}if(al.text){for(var ah=0;ah<al.text.length;ah++){if(al.text[ah].x!=null||al.text[ah].y!=null){var Q=al.text[ah].color?al.text[ah].color:this.foreground;var U=al.text[ah].x!=null?al.text[ah].x:null;var T=al.text[ah].y!=null?al.text[ah].y:null;var n=al.text[ah].label||false;var aw=al.text[ah].scope||false;var aK=al.text[ah].align||"left";var K,g;if(aw){var ar=this.layoutValid?false:true;if(this.layoutValid){var Z=this.data.l.name[this.layoutCurrent];if(!this.isArray(Z)){Z=[Z]}for(var ag=0;ag<Z.length;ag++){if(aw.toString()==Z[ag].toString().replace("\x00","")){ar=true;break}}}if(!ar){continue}}if(U!=null&&T!=null&&n){K=ad+((U-this.xAxisMin)*this.xAxisUnit);g=ab+this.y-((T-this.yAxisMin)*this.yAxisUnit);if(aK=="right"){this.toRender({p:["drawText",n,K,g,this.decorationsTextFont,Q,"right","middle"],t:"Decorations"})}else{if(aK=="center"){this.toRender({p:["drawText",n,K,g,this.decorationsTextFont,Q,"center","middle"],t:"Decorations"})}else{this.toRender({p:["drawText",n,K,g,this.decorationsTextFont,Q,"left","middle"],t:"Decorations"})}}}}}}if(al.line){for(var ah=0;ah<al.line.length;ah++){if(al.line[ah].x!=null||al.line[ah].y!=null){var Q=al.line[ah].color?al.line[ah].color:this.colors[ah%this.colors.length];var ao=al.line[ah].type?al.line[ah].type:"line";var U=al.line[ah].x!=null?al.line[ah].x:null;var T=al.line[ah].y!=null?al.line[ah].y:null;var G=al.line[ah].x2!=null?al.line[ah].x2:null;var b=al.line[ah].y2!=null?al.line[ah].y2:null;var W=al.line[ah].width?al.line[ah].width:1;var n=al.line[ah].label||false;var aK=al.line[ah].align||"left";var aw=al.line[ah].scope||false;var q=this.isArray(U)&&this.isArray(T)&&G==null&&b==null;var at=null;var K,g,I,e,ap;if(this.isCreateHistogram){if(U!=null){U-=this.isCreateHistogram.min}if(G!=null){G-=this.isCreateHistogram.min}}if(aw){var ar=this.layoutValid?false:true;if(this.layoutValid){var Z=this.data.l.name[this.layoutCurrent];if(!this.isArray(Z)){Z=[Z]}for(var ag=0;ag<Z.length;ag++){if(aw.toString()==Z[ag].toString().replace("\x00","")){ar=true;break}}}if(!ar){continue}}if(q){for(var ag=1;ag<U.length;ag++){K=ad+((U[ag-1]-this.xAxisMin)*this.xAxisUnit);I=ad+((U[ag]-this.xAxisMin)*this.xAxisUnit);g=ab+this.y-((T[ag-1]-this.yAxisMin)*this.yAxisUnit);e=ab+this.y-((T[ag]-this.yAxisMin)*this.yAxisUnit);ap=n?n:"";if(ag==1){at=this.toRender({p:["drawLine",ao,K,g,I,e,Q,W],i:[ap+":Decor-Line-"+ah],t:"Decorations"})}else{this.toRender({p:["drawLine",ao,K,g,I,e,Q,W],i:[ap+":Decor-Line-"+ah],g:at,t:"Decorations"})}}}else{if(U!=null&&T!=null&&G!=null&&b!=null){K=ad+((U-this.xAxisMin)*this.xAxisUnit);I=ad+((G-this.xAxisMin)*this.xAxisUnit);g=ab+this.y-((T-this.yAxisMin)*this.yAxisUnit);e=ab+this.y-((b-this.yAxisMin)*this.yAxisUnit);ap=al.line[ah].tooltip||("("+U+","+T+") &rarr; ("+G+","+b+")");this.toRender({p:["drawLine",ao,K,g,I,e,Q,W],i:[ap+":Decor-Line-"+ah],t:"Decorations"})}else{if(U!=null){K=ad+((U-this.xAxisMin)*this.xAxisUnit);g=ab;I=K;e=g+this.y;ap=al.line[ah].tooltip||("x &rarr; "+(this.isCreateHistogram?U+this.isCreateHistogram.min:U));this.toRender({p:["drawLine",ao,K,g,I,e,Q,W],i:[ap+":Decor-Line-"+ah],t:"Decorations"})}else{if(T!=null){K=ad;g=ab+this.y-((T-this.yAxisMin)*this.yAxisUnit);I=K+this.x;e=g;ap=al.line[ah].tooltip||("y &rarr; "+T);this.toRender({p:["drawLine",ao,K,g,I,e,Q,W],i:[ap+":Decor-Line-"+ah],t:"Decorations"})}}}}if(n&&!q){if(al.line[ah].y2!=null){var aA=this.getRadians(K,g,I,e);if(aK=="right"){this.toRender({p:["drawText",n,I,e,this.decorationsTextFont,this.decorationsTextColor,"right","bottom",aA],t:"Decorations"})}else{if(aK=="center"){this.toRender({p:["drawText",n,(K+I)/2,(g+e)/2,this.decorationsTextFont,this.decorationsTextColor,"center","bottom",aA],t:"Decorations"})}else{this.toRender({p:["drawText",n,K,g,this.decorationsTextFont,this.decorationsTextColor,"left","bottom",aA],t:"Decorations"})}}}else{if(aK=="right"){this.toRender({p:["drawText",n,I-this.margin,e-this.margin,this.decorationsTextFont,this.decorationsTextColor,"right","bottom"],t:"Decorations"})}else{if(aK=="center"){this.toRender({p:["drawText",n,(K+I)/2,e-this.margin,this.decorationsTextFont,this.decorationsTextColor,"center","bottom"],t:"Decorations"})}else{this.toRender({p:["drawText",n,K+this.margin,e-this.margin,this.decorationsTextFont,this.decorationsTextColor,"left","bottom"],t:"Decorations"})}}}}}}}if(al.reg){for(var ah=0;ah<al.reg.length;ah++){if(al.reg[ah].slope&&al.reg[ah].intercept){var o=al.reg[ah].fit?al.reg[ah].fit:this.colors[ah%this.colors.length];var Q=al.reg[ah].color?al.reg[ah].color:this.colors[ah%this.colors.length];var J=this.addColorTransparency(Q,0.3,true);var m=this.getPropertyValue(ah,false,"patternBy");var am=al.reg[ah].style?al.reg[ah].style:this.fitLineStyle;var aL=Number(al.reg[ah].slope);var ak=Number(al.reg[ah].intercept);var ae=al.reg[ah].id;var L=al.reg[ah].cor;var A="y ~ "+this.formatNumber(aL,this.yAxisDecs+1)+"x + "+this.formatNumber(ak,this.yAxisDecs+1)+(L?" (r = "+this.formatNumber(L,3)+")":"");var X=al.reg[ah].ci?al.reg[ah].ci:false;var M=X?X.length-1:false;var K=this.showRegressionFullRange||!X?this.xAxisMin:X[0][0];var g=(aL*K)+ak;var I=this.showRegressionFullRange||!X?this.xAxisMax:X[M][0];var e=(aL*I)+ak;K=ad+(K*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(ab+this.y)-(g*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);I=ad+(I*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(ab+this.y)-(e*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var az=this.lineClip([[K,g],[I,e]]);if(az.length){this.toRender({p:["drawLine",am,az[0][0][0],az[0][0][1],az[0][1][0],az[0][1][1],o,2],i:["Decor-Reg-"+ah,ae],t:"Decorations",h:this.isHidden(false,false,ae)})}if(X){var B=[];var v=[];var au=[];for(var ag=0;ag<X.length;ag++){K=ad+(X[ag][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(ab+this.y)-(X[ag][1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);e=(ab+this.y)-(X[ag][2]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);B.push([K,K]);v.push([g,e]);au.push([K,(g+e)/2])}if(this.showConfidenceIntervals){this.toRender({p:["drawShape","confidence",B,v,false,false,J,Q,m],i:[A+":Confidence",ae],b:au,t:"Decorations",h:this.isHidden(false,false,ae)})}}}}}if(al.nor){for(var ah=0;ah<al.nor.length;ah++){if(al.nor[ah].mu&&al.nor[ah].sigma){var F=[];var E=[];var aD=[];var K,g;var Q=ah%this.colors.length;var av=al.nor[ah].mu;var aq=al.nor[ah].sigma;var r=al.nor[ah].start?al.nor[ah].start:al.nor[ah].yAxis?this.yAxisMin:this.xAxisMin;var ai=al.nor[ah].end?al.nor[ah].end:al.nor[ah].yAxis?this.yAxisMax:this.xAxisMax;var ax=120;if(r<av&&av<ai){var aJ,ay,s,c;var V=(av-r)/ax;var z=aq*aq;var aa=z*2;var aj=1/Math.sqrt(2*Math.PI*z);if(al.nor[ah].yAxis){s=al.nor[ah].max?al.nor[ah].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);c=s/aj;aJ=r;for(var ag=0;ag<ax-1;ag++){ay=(aj*Math.pow(Math.E,-Math.pow(aJ-av,2)/z));aD.push([aJ,ay]);K=ad+(ay*c);g=(ab+this.y)-(aJ*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F.push(K);E.push(g);aJ+=V}V=(ai-av)/ax;aJ=av;for(var ag=0;ag<ax;ag++){ay=(aj*Math.pow(Math.E,-Math.pow(aJ-av,2)/z));aD.push([aJ,ay]);K=ad+(ay*c);g=(ab+this.y)-(aJ*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F.push(K);E.push(g);aJ+=V}Q=al.nor[ah].color?al.nor[ah].color:this.colors[Q];this.toRender({p:["drawShape","path",F,E,false,false,Q,Q,"open",false,false,true],i:["Decor-Nor-"+ah],t:"Decorations"})}else{s=al.nor[ah].max?al.nor[ah].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);c=s/aj;aJ=r;for(var ag=0;ag<ax-1;ag++){ay=(aj*Math.pow(Math.E,-Math.pow(aJ-av,2)/z));aD.push([aJ,ay]);K=ad+(aJ*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(ab+this.y)-(ay*c);F.push(K);E.push(g);aJ+=V}V=(ai-av)/ax;aJ=av;for(var ag=0;ag<ax;ag++){ay=(aj*Math.pow(Math.E,-Math.pow(aJ-av,2)/z));aD.push([aJ,ay]);K=ad+(aJ*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(ab+this.y)-(ay*c);F.push(K);E.push(g);aJ+=V}Q=al.nor[ah].color?al.nor[ah].color:this.colors[Q];this.toRender({p:["drawShape","path",F,E,false,false,Q,Q,"open",false,false,true],i:["Decor-Nor-"+ah],t:"Decorations"})}}}}}if(al.area){for(var ah=0;ah<al.area.length;ah++){if(al.area[ah].type&&al.area[ah].x&&al.area[ah].y&&al.area[ah].width&&al.area[ah].height){if(this.isValidShape(al.area[ah].type)){var K=ad+(al.area[ah].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(ab+this.y)-(al.area[ah].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var Q=al.area[ah].color?al.area[ah].color:this.colors[ah%this.colors.length];var p=al.area[ah].width*this.xAxisUnit;var an=al.area[ah].height*this.yAxisUnit;this.oRender({p:["drawShape",al.area[ah].type,K,g,p,an,Q,al.area[ah].outline,al.area[ah].pattern,al.area[ah].rotate],i:["Decor-Area-"+ah],t:"Decorations"})}}}}if(al.point){for(var ah=0;ah<al.point.length;ah++){if(al.point[ah].x&&al.point[ah].y){var K=ad+((al.point[ah].x-this.xAxisMin)*this.xAxisUnit);var g=ab+this.y-((al.point[ah].y-this.yAxisMin)*this.yAxisUnit);var aH=al.point[ah].shape||"circle";var Q=al.point[ah].color||this.foreground;var p=al.point[ah].width||(this.dataPointSize*0.5);var an=al.point[ah].height||(this.dataPointSize*0.5);var ap=this.formatNumber(al.point[ah].x,this.xAxisDecs)+", "+this.formatNumber(al.point[ah].y,this.yAxisDecs);this.toRender({p:["drawShape",aH,K,g,p,an,Q,Q],i:[ap+":Decor-Point-"+ah],t:"Decorations"})}}}}else{if(al.line){for(var ah=0;ah<al.line.length;ah++){var K,g,I,e;var ar=true;var ao=al.line[ah].type||"line";var C=al.line[ah].color;var Y=this.transformValue(this.isTransformedData,al.line[ah].value||0);var n=al.line[ah].label||false;var aB=al.line[ah].width||1;var aK=al.line[ah].align||"left";var aw=al.line[ah].scope||false;if(this.graphOrientation=="vertical"){K=this.marginLeft+this.offsetX+this.left;I=K+this.x;g=this.marginTop+this.offsetY+this.top+this.y-((Y-this.xAxisMin)*this.xAxisUnit);e=g;ar=g<=this.marginTop+this.offsetY+this.top+this.y&&g>=this.marginTop+this.offsetY+this.top?true:false}else{K=this.marginLeft+this.offsetX+this.left+((Y-this.xAxisMin)*this.xAxisUnit);I=K;g=this.marginTop+this.offsetY+this.top;e=g+this.y;ar=K<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(ar&&aw){if(this.layoutValid){ar=false;var Z=this.toArray(this.data.l.name[this.layoutCurrent]);for(var ag=0;ag<Z.length;ag++){if(aw==Z[ag]){ar=true}}}}if(ar){var S=this.isR?6:3;if(n){if(this.graphOrientation=="vertical"){if(aK=="right"){this.toRender({p:["drawText",n,I-this.margin,e-this.margin,this.decorationsTextFont,this.decorationsTextColor,"right","bottom"],t:"Decorations"})}else{if(aK=="center"){this.toRender({p:["drawText",n,K+(this.x/2),e-this.margin,this.decorationsTextFont,this.decorationsTextColor,"center","bottom"],t:"Decorations"})}else{this.toRender({p:["drawText",n,K+this.margin,e-this.margin,this.decorationsTextFont,this.decorationsTextColor,"left","bottom"],t:"Decorations"})}}}else{if(aK=="right"){this.toRender({p:["drawText",n,I+(this.margin*2),e-(this.margin*S),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}else{if(aK=="center"){this.toRender({p:["drawText",n,I+(this.margin*2),g+(this.y/2),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}else{this.toRender({p:["drawText",n,I+(this.margin*2),g+(this.margin*S),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}}}}var ap=al.line[ah].tooltip||("&rarr; "+Y);this.toRender({p:["drawLine",ao,K,g,I,e,C,aB],i:[ap+":Decor-Line"+ah],t:"Decorations"})}}}else{if(al.point){for(var ah=0;ah<al.point.length;ah++){var ar=true;var N=this.getSampleIndices(al.point[ah].smp);var Y=this.transformValue(this.isTransformedData,al.point[ah].value||0);var C=al.point[ah].color||this.foreground;var aB=(al.point[ah].width||1)*this.dataPointSize;var u=(al.point[ah].height||1)*this.dataPointSize;var O=al.point[ah].shape||"circle";var K=N!=null&&N>=0?this.smpInfo[N]-this.margin:null;var g=(Y-this.xAxisMin)*this.xAxisUnit;if(K!=null&&g!=null){if(this.graphOrientation=="vertical"){g=this.marginTop+this.offsetY+this.top+this.y-g;ar=g<=this.marginTop+this.offsetY+this.top+this.y&&g>=this.marginTop+this.offsetY+this.top?true:false}else{K=this.marginLeft+this.offsetX+this.left+g;g=this.smpInfo[N];ar=K<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(ar){var ap=al.point[ah].smp+"("+Y+")";this.toRender({p:["drawShape",O,K,g,aB,u,C,C,"closed"],i:[ap+":Decor-Point-"+ah],t:"Decorations"})}}}}}if(al.marker){this.drawMarkers()}}}this.toRender({p:["resetClipArea"],t:"Decorations"})};this.drawOncoprintLegend=function(){if(this.isOncoprint){var b=(this.width/2)-(this.legend.oncoprint.width/2);var p=this.height-(this.marginBottom+this.legend.oncoprint.height-this.margin);var a=0;var o=this.legend.oncoprint.width/this.legend.oncoprint.cols;var k=2;this.toRender({p:["drawShape","rect",this.width/2,p+(this.legend.oncoprint.height/2)-this.margin,this.legend.oncoprint.width,this.legend.oncoprint.height,this.background,this.background],i:[-1],m:["-legend-oncoprint"],t:"Legends"});for(var g=0;g<this.legend.oncoprint.rows;g++){var d=b;for(var e=0;e<this.legend.oncoprint.cols;e++){if(a<this.legend.oncoprint.labels.length){var h=this.legend.oncoprint.labels[a];var m=this.legend.oncoprint.objects[a];if(a<this.legend.oncoprintMutations){this.toRender({p:["drawShape","rect",d+2.5,p+10.5,5,21,this.legend.oncoprint.colors[h]],i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.toRender({p:["drawText",h,d,p+10.5+k,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});d+=o}else{this.toRender({p:["drawShape","rect",d+2.5,p+10.5,5,21,"rgb(220,220,220"],i:["Onc-"+h+"-"+m],t:"Legends"});this.toRender({p:["drawShape","rect",d+2.5,p+10.5,5,7,this.legend.oncoprint.colors[h]],i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.toRender({p:["drawText",h,d,p+10.5+k,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});d+=o}a++}}p+=21+this.margin}}};this.drawSampleLegend=function(z,d){var f=this;var c=function(i,j){if(f.isCreateHistogram){if(f.isCreateHistogram.colors.length<f.legend.sample.n&&f.isCreateHistogram.factor){if(f.cacheColors[f.colorScheme].hasOwnProperty(j)){return f.cacheColors[f.colorScheme][j]}else{return l&&l.hasOwnProperty(f.isCreateHistogram.factor)&&l[f.isCreateHistogram.factor].colors?l[f.isCreateHistogram.factor].colors[i]:f.colors[i%f.colors.length]}}else{if(f.isCreateHistogram.colors.length==f.legend.sample.n){if(f.densityPosition=="filled"&&f.graphType=="Scatter2D"){return f.isCreateHistogram.colors[f.legend.sample.n-(1+i)]}else{return f.isCreateHistogram.colors[i]}}else{return f.cacheColors[f.colorScheme].hasOwnProperty(j)?f.cacheColors[f.colorScheme][j]:f.colors[i%f.colors.length]}}}else{return f.colors[i%f.colors.length]}};var w=function(j){if(f.isCreateHistogram){if(!f.xAxisIndices.length&&!f.yAxisIndices.length){var i;if(f.isHistogramLayout()){i=f.getSampleIndices(b[j]);if(i<0){i=j+1}}else{i=f.getSampleIndices(f.data.l.axes[0].yAxis[j])}return"Series:0:"+i}else{if(f.data.l&&f.data.l.axes&&f.data.l.axes[v]&&f.data.l.axes[v].yAxis&&f.data.l.axes[v].yAxis[s]&&!f.data.l.axes[v].yAxis[s].match(":")){return"Series:0:"+f.data.l.ids[j+1]}else{return f.xAxisIndices.length==f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":"+f.yAxisIndices[j]:f.xAxisIndices.length>f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":0":"Series:0:"+f.yAxisIndices[j]}}}else{return f.xAxisIndices.length==f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":"+f.yAxisIndices[j]:f.xAxisIndices.length>f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":0":"Series:0:"+f.yAxisIndices[j]}};var q=z;var A=d;var u=0;var p=this.getFontPt(this.legendTextFont);var t=p/2;d+=this.legendTextMargin+t;this.drawLegendBackgroundBox(q,A,this.legend.sample.width,this.legend.sample.height,"-legend-sample");var g=this.legend.sample.columns||this.legendColumns;var y=this.legend.sample.width/g;var a=Math.ceil(this.legend.sample.n/g);var l=f.meta.data.z;var b=[];var x={};if(this.ridgeBy){for(var v=0;v<a;v++){for(var s=0;s<g;s++){z=q+((this.legendTextMargin+y)*s);if(u<this.legend.sample.n){var n=this.shortenText(this.dataStndBy.y.smps[u],this.maxSmpStringLen);var e=this.colors[u%this.colors.length];var B="Series:0:"+u;var h=z+t+this.legendTextMargin;this.drawKeyShape(h,d,"circle",p,this.getFillColor(e),this.getOutlineColor(e),"closed","solid",this.background,n,[B],null,this.isHidden(false,false,B));u++}}d+=p+this.legendTextMargin}}else{if(this.isHistogram&&this.isHistogramLayout()){for(var v=0;v<this.data.l.axes.length;v++){for(var s=0;s<this.data.l.axes[v].yAxis.length;s++){if(this.data.l.axes[v].yAxis[s]){if(this.segregateVariablesBy.length||!this.data.l.axes[v].yAxis[s].match(":")){x[this.data.l.axes[v].yAxis[s].split(":")[0]]=true}else{if(this.data.l.axes.length==this.dataStndBy.y.smps.length){x[this.data.l.axes[v].yAxis[s].split(":")[1]]=true}else{x[this.data.l.axes[v].yAxis[s]]=true}}}}}b=this.getKeys(x)}}if(!this.ridgeBy){for(var v=0;v<a;v++){for(var s=0;s<g;s++){z=q+((this.legendTextMargin+y)*s);if(u<this.legend.sample.n){var k=this.isCreateHistogram?"solid":this.getPropertyValue(v,false,"patternBy");var m=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[u]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[u];var o=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[u]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[u]:this.xAxis[this.xAxisCurrent];var B=w(u);var n=this.isHistogramLayout()?b[u]:this.isHistogram?this.shortenText(m,this.maxSmpStringLen):this.shortenText(m,this.maxSmpStringLen)+" vs "+this.shortenText(o,this.maxSmpStringLen);var e=c(u,n);var h=z+t+this.legendTextMargin;if(this.isCreateHistogram){var r=this.histogramAsDotplot?"circle":"rectangle";this.drawKeyShape(h,d,r,p,this.getFillColor(e),this.getOutlineColor(e),k,"solid",this.background,n,[B],null,this.isHidden(false,false,B))}else{if(this.colorBy){this.drawKeyShape(h,d,"circle",p,this.background,this.getFillColor(e),"open","solid",this.background,n,[B],null,this.isHidden(false,false,B))}else{if(this.isKM){e=this.getFillColor(e);this.drawKeyConfidence(h,d,"rectangle",p,e,e,"closed","solid",e,n,[B],null,this.isHidden(false,false,B))}else{this.drawKeyShape(h,d,"circle",p,this.getFillColor(e),this.getOutlineColor(e),k,"solid",this.background,n,[B],null,this.isHidden(false,false,B))}}}}else{break}u++}d+=p+this.legendTextMargin}}};this.drawVariableLegend=function(E,c){var k=this;var r=E;var G=c;var q=this.getFontPt(this.legendTextFont);var w=q/2;var x=0;var h=this.layoutValid&&!this.isDOE&&this.isOneDimensionalGraph()&&this.meta.config.user.graphType!=this.graphType?this.meta.config.user.graphType:this.graphType;var m=function(i){if(i<k.xAxisVarIndices.length){return k.colors[i%k.colors.length]}else{return k.colors[(i-k.xAxisVarIndices.length)%k.colors.length]}};if(this.legend.variable.width==0||this.legend.variable.height==0){return}else{if(h=="Circular"&&this.circularType=="sunburst"){return}else{if(h=="Pie"){var D=!this.layoutComb?this.width-(E+(this.legendTextMargin*1.5)):this.isDOE?this.layoutWidth-((E-this.offsetX)+(this.legendTextMargin*1.5)):999999;if(this.isDOE&&this.legend.variable.width>D){this.legend.variable.width=D}this.drawLegendBackgroundBox(r,G,this.legend.variable.width,this.legend.variable.height,"-legend-variable");E+=w+this.legendTextMargin;c+=q;for(var B=0;B<this.varPie.ids.length;B++){var e=false;var p=this.varPie.ids[B];var f=this.varPie.cols[B];var u=p>-1?this.shortenText(this.data.y.vars[p],this.maxVarStringLen):"Other";if(D>0){while((this.measureText(u,this.legendTextFont)+q+(this.legendTextMargin*3))>D&&u.length>1){u=u.substring(0,u.length-1);e=true}if(e){u=u+"..."}}this.drawKeyShape(E,c,"circle",q,this.getFillColor(f),this.getOutlineColor(f),"closed","solid",this.background,u,["PieVar-"+p],null,this.isHidden(false,false,"Var-"+p));c+=q+this.legendTextMargin;if(this.layoutComb){if((c-this.offsetY)>this.layoutHeight){this.toRender({p:["drawText","...",E+q,c,this.legendTextFont,this.legendTextColor,"left","bottom"],t:"Legends"});break}}else{if(c>this.height){this.toRender({p:["drawText","...",E+q,c,this.legendTextFont,this.legendTextColor,"left","bottom"],t:"Legends"});break}}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){this.drawLegendBackgroundBox(r,G,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var A=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],q):q;var F=A/2;var l=this.legend.variable.columns||this.legendColumns;var C=this.legend.variable.width/l;var a=Math.ceil(this.varIndices.length/l);c+=(this.legendTextMargin*3);for(var B=0;B<a;B++){for(var v=0;v<l;v++){E=r+(this.legendTextMargin+(C*v));if(x<this.varIndices.length){var p=this.varIndices[x];var f=h=="Circular"||(this.colorBy&&this.colorBy=="variable")?x%this.colors.length:0;var s=this.shapeBy&&this.shapeBy=="variable"?x%this.shapes.length:0;var z=this.sizeBy&&this.sizeBy=="variable"?this.sizes[x%this.sizes.length]:A;var o=this.patternBy&&this.patternBy=="variable"?this.patterns[x%this.patterns.length]:this.getPropertyValue(p,false,"patternBy");var n=E+F;var u=this.shortenText(this.data.y.vars[p],this.maxVarStringLen);var b=this.isHidden(false,false,"Var-"+p);this.drawKeyShape(n,c,this.shapes[s],z,this.getFillColor(this.colors[f]),this.getOutlineColor(this.colors[f]),o,"solid",this.background,u,["Var-"+p],null,b)}else{break}x++}c+=A+this.legendTextMargin}}else{if(h=="BarLine"||h=="DotLine"||h=="AreaLine"||h=="StackedLine"||h=="StackedPercentLine"){this.drawLegendBackgroundBox(r,G,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var g=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var l=this.legend.variable.columns||this.legendColumns;var C=this.legend.variable.width/l;var a=Math.ceil(g.length/l);c+=this.legendTextMargin+(q/2);for(var B=0;B<a;B++){for(var v=0;v<l;v++){E=r+(q/2)+this.legendTextMargin+(C*v);if(x<g.length){var p=x<this.xAxisVarIndices.length?this.xAxisVarIndices[x]:this.xAxis2VarIndices[x-this.xAxisVarIndices.length];var f=this.theme=="blackAndWhite"?"rgb(0,0,0)":this.coordinateLineColor?m(x):this.getVariableColor(this.data.y.vars[p]);var o=this.getPropertyValue(p,false,"patternBy");var u=this.shortenText(this.data.y.vars[p],this.maxVarStringLen);var b=this.isHidden(false,false,"Var-"+p);if(x<this.xAxisVarIndices.length){var s=h=="DotLine"?"circle":this.useRoundRectangles?"roundrect":"rectangle";this.drawKeyShape(E,c,s,q,this.getFillColor(f),this.getOutlineColor(f),o,"solid",this.background,u,["Var-"+p],null,b)}else{var t=this.lineDecoration=="pattern"?this.linePatterns[x%this.linePatterns.length]:"line";var s=this.lineDecoration=="symbol"?this.shapes[(x-this.xAxisVarIndices.length)%this.shapes.length]:"circle";var f=this.getFillColor(f);if(this.lineDecoration&&this.lineDecoration!="pattern"&&!this.segregateVariablesBy.length&&h!="DotLine"&&h!="AreaLine"){this.drawKeyShapeLine(E,c,s,q,f,f,"closed","solid",f,u,["Var-"+p],null,b)}else{this.drawKeyLine(E,c,s,q,f,f,o,t,f,u,["Var-"+p],null,b)}}}else{break}x++}c+=q+this.legendTextMargin}}else{if(h=="Bar"||h=="Line"||h=="ParallelCoordinates"||h=="Area"||h=="Dotplot"||h=="Stacked"||h=="StackedPercent"||h=="Boxplot"||h=="Fish"){this.drawLegendBackgroundBox(r,G,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var l=this.legend.variable.columns||this.legendColumns;var C=this.legend.variable.width/Math.min(this.varIndices.length,l);var a=Math.ceil(this.varIndices.length/Math.min(this.varIndices.length,l));c+=this.legendTextMargin+(q/2);for(var B=0;B<a;B++){for(var v=0;v<Math.min(this.varIndices.length,l);v++){E=r+(q/2)+this.legendTextMargin+(C*v);if(x<this.varIndices.length){var p=this.varIndices[x];var f=this.theme=="blackAndWhite"&&h=="Line"?"rgb(0,0,0)":this.getFillColor(this.getVariableColor(this.data.y.vars[p]));var y=this.getOutlineColor(f);var o=this.getPropertyValue(p,false,"patternBy");var u=this.shortenText(this.data.y.vars[p],this.maxVarStringLen);var b=this.isHidden(false,false,"Var-"+p);if(h=="Boxplot"){f=this.boxplotColor?this.boxplotColor:f;y=this.boxplotBorderColor?this.boxplotBorderColor:y}if(h=="Line"||h=="ParallelCoordinates"){var s=this.lineDecoration=="symbol"?this.shapes[x%this.shapes.length]:"circle";var t=this.lineDecoration=="pattern"?this.linePatterns[x%this.linePatterns.length]:"line";if(this.lineDecoration&&(this.lineDecoration=="symbol"||this.lineDecoration=="dot")){this.drawKeyShapeLine(E,c,s,q,f,f,o,"solid",f,u,["Var-"+p],null,b)}else{this.drawKeyLine(E,c,s,q,f,f,o,t,f,u,["Var-"+p],null,b)}}else{if(h=="Dotplot"||(h=="Boxplot"&&this.showBoxplotOriginalData)){var s="circle";this.drawKeyShape(E,c,s,q,f,y,o,"solid",this.background,u,["Var-"+p],null,b)}else{if(h=="Bar"&&this.barType=="lollipop"){this.drawKeyLollipop(E,c,s,q,f,y,o,"solid",this.background,u,["Var-"+p],null,b)}else{var s=this.useRoundRectangles?"roundrect":"rectangle";if(h=="Boxplot"&&(!this.showBoxplotOriginalData||this.boxplotColor)){this.drawKeyBoxplot(E,c,s,q,f,y,o,"solid",this.background,u,["Var-"+p],null,b)}else{this.drawKeyShape(E,c,s,q,f,y,o,"solid",this.background,u,["Var-"+p],null,b)}}}}}else{break}x++}c+=q+this.legendTextMargin}}else{if(h=="Circular"&&!this.showIdeogram){this.drawLegendBackgroundBox(r,G,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var d=[];if(this.rAxisIndex>=0){for(var B=0;B<this.varIndices.length;B++){if(B==this.rAxisIndex){continue}d.push(this.varIndices[B])}}else{d=this.varIndices}var l=this.legend.variable.columns||this.legendColumns;var C=this.legend.variable.width/l;var a=Math.ceil(d.length/l);c+=this.legendTextMargin+(q/2);for(var B=0;B<a;B++){for(var v=0;v<l;v++){E=r+(q/2)+this.legendTextMargin+(C*v);if(x<d.length){var p=d[x];if(this.data.y.vars[p]){var f=this.colors[x%this.colors.length];var o=this.getPropertyValue(p,false,"patternBy");var u=this.shortenText(this.data.y.vars[p],this.maxVarStringLen);this.drawKeyShape(E,c,this.useRoundRectangles?"roundrect":"rectangle",q,this.getFillColor(f),this.getOutlineColor(f),o,"solid",this.background,u,["Var-"+p],null,b)}}else{break}x++}c+=q+this.legendTextMargin}}}}}}}}};this.drawVennLegend=function(){if(this.showLegend){var j=this.getFontPt(this.legendTextFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.toRender({p:["drawText",a[f]+": ",d,g,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.measureText(b,this.legendTextFont)>this.x)?this.scaleTextToFont(b,j,this.x-this.margin):this.legendTextFont;if(!this.vennLegendColors){this.toRender({p:["drawText",b,c,g,e,this.legendTextColor,"left","middle"],t:"Legends"})}else{this.toRender({p:["drawText",b,d,g,e,h[f],"left","middle"],t:"Legends"})}g+=this.margin+j}}};this.drawColorIndicator=function(p,a,k,y,h,u){if(u||h||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy||this.graphType=="Genome"||this.scatterType=="bin2d"||(this.isContour&&this.contourFilled)||(this.graphType=="Network"&&this.decorations.length&&this.decorationsType=="heatmap"&&this.showDecorations&&!this.colorNodeBy&&!this.colorEdgeBy)){var B=this;var v=function(Q,j){if(j==undefined){if(!k.decs||k.decs>3){k.decs=B.getNumberDecimals(Q[1]-Q[0])}j=k.decs}var P=[];for(var c=0;c<Q.length;c++){P[c]=Q[c].toFixed(j)}return P};var b=function(c){if(B.heatmapIndicatorWidth<250){if(c.length==9){c=[c[0],c[4],c[8]]}else{if(c.length==8||c.length==7){c=[c[0],c[2],c[4],c[6]]}else{if(c.length==6||c.length==5){c=[c[0],c[2],c[4]]}}}}return c};var M=function(){var S=B[x]&&B[x].toString().match(/top|bottom/)&&!w;var j=C;var Q=(!S||B.graphType=="Map")&&l&&B.showLegendTitle?r+B.legendTitleFontSize+(B.legendTitleMargin*2):l&&B.showLegendTitle?r+B.legendTitleFontSize+(B.legendTitleMargin*2):r;var c=S?B.heatmapIndicatorWidth:B.heatmapIndicatorHeight;var R=S?B.heatmapIndicatorHeight:B.heatmapIndicatorWidth;B.toRender({p:["drawShape","rectangle",j+(c/2),Q+(R/2),c,R,false,"rgb(0,0,0)","open"],t:"Legends"});if(S){for(var P=0;P<g.length;P++){if(g[P]>j&&g[P]<(j+c)){B.toRender({p:["drawLine","line",g[P],Q,g[P],Q+B.margin,"rgb(0,0,0)",1],t:"Legends"});B.toRender({p:["drawLine","line",g[P],Q+R,g[P],Q+R-B.margin,"rgb(0,0,0)",1],t:"Legends"})}}}else{for(var P=0;P<g.length;P++){if(g[P]>Q&&g[P]<(Q+R)){B.toRender({p:["drawLine","line",j,g[P],j+B.margin,g[P],"rgb(0,0,0)",1],t:"Legends"});B.toRender({p:["drawLine","line",j+c,g[P],j+c-B.margin,g[P],"rgb(0,0,0)",1],t:"Legends"})}}}};var l=this.scatterType=="bin2d"?"n":(y||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy);var x=u?"overlaysLegendPosition":h?"heatmapIndicatorPosition":"legendPosition";var E=u?u:h?0:this.legendTextColorWidth?this.legendTextColorWidth/2:10;var C=p;var r=a;var n=this.getFontPt(this.legendTitleFont);var o=this.heatmapIndicatorHeight;var O=this.heatmapIndicatorHeight;var L=this.graphType=="Genome"?k.brew.min:k.min;var t=this.graphType=="Genome"?k.brew.max:k.max;var D=this.graphType=="Genome"?k.brew.vals:k.vals;var d=k.valStr?k.valStr:k.colorBrew&&k.colorBrew.valStr?k.colorBrew.valStr:v(D);var F=this.heatmapIndicatorWidth/(t-L);var J=10;var G=this.graphType=="Circular"||(this.isContour&&!k.colorBrew)||this.scatterType=="bin2d"?k:k.colorBrew?k.colorBrew:this.meta.def.colorBrew;var f=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var w=x=="overlaysLegendPosition"&&this[x]=="topRight"?true:false;var e=this.legendTitleFont;var N=this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram?this.getHeatmapIndicatorHistogram():false;var g=[];var A=[];if(N&&this.heatmapIndicatorOverlap){p+=this.measureText(N.maxStr,this.legendTextFont);C=p}if(this[x]&&!this[x].toString().match(/top|bottom/)&&!w){if(l&&this.showLegendTitle){p+=(this.measureText(l,this.legendTextFont)-this.heatmapIndicatorHeight)/2;C=p}}if(this[x]&&this[x].toString().match(/top|bottom/)&&!w){if(l){if(this.showLegendTitle){var z=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-(this.heatmapIndicatorWidth/2):(this.heatmapIndicatorWidth/2);a+=this.legendTitleMargin+(n/2);this.toRender({p:["drawText",l,p+(this.heatmapIndicatorWidth/2)+z,a,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"});a+=this.legendTitleMargin+(n/2)}}A=[p,p+this.heatmapIndicatorWidth];this.toRender({p:["setClipArea",[p,a,this.heatmapIndicatorWidth,this.heatmapIndicatorHeight]],t:"Legends"});for(var I=0;I<this.colorSpectrumNumber;I++){var K=this.transparency!=null?this.addColorTransparency(G.colors[I],this.transparency,true):G.colors[I];this.toRender({p:["drawLine","line",p,a,p,a+O,K,J],t:"Legends"});p+=f}this.toRender({p:["resetClipArea",[p,a,this.heatmapIndicatorWidth,this.heatmapIndicatorHeight]],t:"Legends"});p=C;a+=O+this.legendTextMargin;if(G&&G.stops&&G.stops.length){var q=0;for(var I=0;I<G.stops.length;I++){for(var H=0;H<this.colorSpectrumNumber;H++){if(G.breaks[H]>=G.stops[I]){p=C+(H*f);g.push(p);var m=(this.measureText(this.formatNumber(G.stops[I].toString()),this.legendTextFont)/2);if(p-m>q||I==0||I==G.stops.length-1){this.toRender({p:["drawText",this.formatNumber(G.stops[I]),p,a,e,this.legendTextColor,"center","top"],t:"Legends"});q=p+m}break}}}}else{if(N){D=b(D);d=v(D,0);this.drawHeatmapIndicatorHistogram(N,C,r-0.5)}else{if(this.graphType=="Map"){D=b(D);d=v(D,0)}}for(var I=0;I<D.length;I++){p=C+((D[I]-L)*F);g.push(p);if(p>=A[0]&&p<=A[1]){this.toRender({p:["drawText",d[I],p,a,this.legendTextFont,this.legendTextColor,"center","top"],t:"Legends"})}}}}else{if(l){if(this.showLegendTitle){a+=this.legendTitleMargin+(n/2);if(this.graphType=="Circular"){this.toRender({p:["drawText",l,p-(this.legendTextFontSize/2),a+(this.colorSpectrumNumber*f/2),this.legendTitleFont,this.legendTitleColor,"center","bottom",-Math.PI/2],t:"Legends"})}else{var z=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-(E+(this.legendTitleMargin*2)):(E+(this.legendTitleMargin*2));this.toRender({p:["drawText",l,p+E+(this.legendTitleMargin*2),a,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"})}a+=this.legendTitleMargin+(n/2)}}var s=a;A=[a+this.heatmapIndicatorWidth,a];this.toRender({p:["setClipArea",[p,a,this.heatmapIndicatorHeight,this.heatmapIndicatorWidth]],t:"Legends"});a+=(this.colorSpectrumNumber*f);for(var I=0;I<this.colorSpectrumNumber;I++){var K=this.transparency!=null?this.addColorTransparency(G.colors[I],this.transparency,true):G.colors[I];this.toRender({p:["drawLine","line",p,a,p+o,a,K,J],t:"Legends"});a-=f}this.toRender({p:["resetClipArea",[p,a,this.heatmapIndicatorHeight,this.heatmapIndicatorWidth]],t:"Legends"});p+=o+this.legendTextMargin;a=s;if(G&&G.stops&&G.stops.length){a+=this.colorSpectrumNumber*f;var q=a;for(var I=0;I<G.stops.length;I++){for(var H=0;H<this.colorSpectrumNumber;H++){if(G.breaks[H]>=G.stops[I]){O=a-(H*f);g.push(O);if(O+this.legendTextFontSize<q||I==0||I==G.stops.length-1){this.toRender({p:["drawText",this.formatNumber(G.stops[I]),p,O,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});q=O}break}}}}else{a+=this.colorSpectrumNumber*f;var s=-((this.legendTitleMargin*2)+n);for(var I=0;I<D.length;I++){var O=a-((D[I]-L)*F);if(O>(r+s)){g.push(O);if(O<=A[0]&&O>=A[1]){this.toRender({p:["drawText",d[I],p,O,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}}}}}M()}};this.getHeatmapIndicatorHistogram=function(){var k=[];for(var f=0;f<this.data.y.vars.length;f++){for(var e=0;e<this.data.y.smps.length;e++){var n=this.getDataAtPos(f,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(n!=null&&n!==""&&!isNaN(n)){k.push(n)}}}var g=this.range(k);var c=g[0];var m=g[1];var r=this[this.histogramSizeEstimator](k);var q=Math.ceil((m-c)/r);if(r>1000){q*=r/1000;r=1000}var h=[];for(var f=0;f<r;f++){h[f]=0}for(var f=0;f<this.data.y.vars.length;f++){for(var e=0;e<this.data.y.smps.length;e++){var n=this.getDataAtPos(f,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(n!=null&&n!==""&&!isNaN(n)){var p=parseInt((n-c)/q);h[p]++}}}c=0;m=0;for(var f=0;f<r;f++){c=Math.min(c,h[f]);m=Math.max(m,h[f])}var l=this[this.axisAlgorithm](c,m,3,this.axisWilkinsonLoose);var o=this.getMaxText(l);var b=(this.heatmapIndicatorWidth-1)/r;var a=this.heatmapIndicatorHeight/l[l.length-1];return{range:g,min:c,max:m,size:q,bins:r,hist:h,vals:l,maxStr:o,unitsX:b,unitsY:a}};this.drawHeatmapIndicatorHistogram=function(h,c,m){var l;var j=c;var d=m+this.heatmapIndicatorHeight;var n=h.bins;var g=h.hist;var k=h.vals;var b=h.unitsX;var a=h.unitsY;var f=1.5;this.toRender({p:["drawLine","line",j-this.margin,m,j-this.margin,d,this.foreground],t:"Legends"});for(var e=0;e<k.length;e++){m=(k[e]*a);this.toRender({p:["drawLine","line",j-(this.margin*2),d-m,j-this.margin,d-m,this.foreground],t:"Legends"});this.toRender({p:["drawText",this.formatNumber(k[e]),j-(this.margin*3),d-m,this.legendTextFont,this.legendTextColor,"right","middle"],t:"Legends"})}m=(g[0]*a);this.toRender({p:["drawLine","line",j,d,j,d-m,this.heatmapIndicatorHistogramColor,f],t:"Legends"});for(var e=0;e<n;e++){m=(g[e]*a);this.toRender({p:["drawLine","line",j,d-m,j+b,d-m,this.heatmapIndicatorHistogramColor,f],t:"Legends"});if(e<n-1){l=(g[e+1]*a);this.toRender({p:["drawLine","line",j+b,d-m,j+b,d-l,this.heatmapIndicatorHistogramColor,f],t:"Legends"})}j+=b}this.toRender({p:["drawLine","line",j,d-l,j,d,this.heatmapIndicatorHistogramColor,f],t:"Legends"})};this.isDrawPropertyLegend=function(a){if(a){if(this.graphType=="Network"){return(this[a+"By"]&&this.meta.data.edges[this[a+"By"]])||(this[a+"By"]&&this.meta.data.nodes[this[a+"By"]])}else{return(this[a+"By"]&&this.isMultidimensionalData)||(this.isContour&&this.contourType=="point")||(this.histogramAsDotplot&&this.colorBy)||(this[a+"By"]&&((this.data.x&&this.data.x.hasOwnProperty(this[a+"By"]))||(this.data.z&&this.data.z.hasOwnProperty(this[a+"By"]))||this.getSampleIndices(this[a+"By"])>-1))}}else{if(this.graphType=="Network"){return(this.colorEdgeBy&&this.meta.data.edges[this.colorEdgeBy])||(this.colorNodeBy&&this.meta.data.nodes[this.colorNodeBy])||(this.decorations.length&&this.decorationsType=="heatmap")}else{return(this.outlineBy&&this.isMultidimensionalData)||(this.isContour&&this.contourFilled)||this.scatterType=="bin2d"||(this.histogramAsDotplot&&this.colorBy)||(this.data.x&&this.data.x.hasOwnProperty(this.lineBy))||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))||this.getSampleIndices(this.colorBy)>-1||(this.colorBy=="data"&&this.ridgeBy)))}}};this.drawColorLegend=function(a,c,e,d){if(this.graphType=="Map"){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);c+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}var b=this.graphType=="Scatter2D"&&this.lineBy&&this.ribbonBy&&this.colorBy==this.lineBy&&d=="color";if(this.isDrawPropertyLegend()&&!b){if((e.type=="Numeric"&&!e.colorBy)||(this.isContour&&this.contourFilled)||this.scatterType=="bin2d"){this.drawColorIndicator(a,c,(this.isTransformedData&&this.graphType!="Heatmap")?this.getDefaultMetaDataObject():this.isContour?this.meta.data.q.g[0].data.colorBrew:this.scatterType=="bin2d"?this.meta.data.b.c:e)}else{this.drawPropertyLegend(d,a,c,e)}}};this.drawShapeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawSizeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPatternLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawConnectLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPropertyLegend=function(s,o,a,e){var D=this;var m=function(){if(D.graphType.match(/Boxplot|Bar/)){if(!D.showBoxplotOriginalData&&!D.boxplotColor&&!D.showViolinBoxplot){return D.useRoundRectangles?"roundrect":"rectangle"}else{return"circle"}}else{return"circle"}};var G=this.decapitalize(s);if(this.isDrawPropertyLegend(G)){var f=s.replace("Node","").replace("contour","size")=="size"?0:this.getDiameterLegend();if(s.replace("Node","").replace("contour","size")=="size"){var J=e.sizes?e.sizes.length:this.sizes.length;for(var K=0;K<(this.isContour?e.vals.length:(this.legend.size.n||e.levels.length));K++){f=Math.max(f,e.sizes?e.sizes[K%J]:this.sizes[K%J])}}var P=this.getFontPt(this.legendTitleFont);var v=this.getFontPt(this.legendTextFont);var t=this.legend[s].columns||this.legendColumns;var y=t>this.legend[s].n?this.legend[s].n:t;var x=Math.ceil(this.legend[s].n/y);var b=this.legend[s].width/y;var q=a+(this.showLegendTitle?this.legendTitleMargin+(P/2):this.legendTextMargin+(v/2));var d=Math.max(f,v);var u=0;var k=s.replace("Node","").replace("Edge","")=="color"&&this.outlineBy?this.outlineBy:this[G+"By"];this.drawLegendTitle(o,a,this.legend[s].width,this.legend[s].height,k,"-legend-"+G);if(this.showLegendTitle){q+=P+(this.legendTitleMargin*2);if(f>v+this.legendTextMargin){q+=this.legendTextMargin}}var L=this.legend[s].levels||this.sortObject(this.legend[s].m);var H=e.origin?e.origin:this.meta.data.modified?"modified":this.isOncoprint||this.isMultidimensionalData?this[G+"ByData"]:"y";for(var F=0;F<x;F++){for(var N=0;N<y;N++){var C=o+this.legendTextMargin+(f/2)+(b*N);if(u<this.legend[s].n&&u>=0){var g=L[u];var M;if(e.type=="Numeric"&&((s=="shape"&&!this.shapeByContinuous)||(s=="size"&&!this.sizeByContinuous))){M=F==0&&N==0?"<= "+g:F==x-1&&N==y-1?L[u-1]+" - "+g:Number(L[u-1])+" - "+g}else{M=g.length>this.maxTextSize?g.substring(0,this.maxTextSize-3)+"...":g}var h=m();var B=e.colorBy&&e.colorBy.hasOwnProperty(g)?this.validateColor(e.colorBy[g]):this.legend.color.m?this.validateColor(this.legend.color.m[g]):e.colors?this.validateColor(e.colors[u]):this.background;if(this.graphType=="Boxplot"&&this.showViolinBoxplot){B=this.addColorTransparency(B,this.violinTransparency,true)}var E=this.getFillColor(B);var Q=this.outlineBy?this.getFillColor(B):this.graphType=="Scatter2D"&&this.scatterType=="visium"?this.getFillColor(B):this.getOutlineColor(B);var B=this.outlineBy?"rgba(0,0,0,0)":this.getFillColor(B);var j="closed";var w="solid";var A=["PropertyKey:"+k+":"+g+":"+H];var I=this.graphType=="Boxplot"&&s!="connect"&&(!this.showBoxplotOriginalData||this.boxplotColor)&&!this.showViolinBoxplot;var O=this.isHidden(false,false,"Property:"+k+":"+g+":"+H);if(s.replace("Node","").replace("Edge","")=="color"){if(this.outlineBy){this.drawKeyShape(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(this.graphType=="Scatter2D"&&(this.scatterType=="line"||this.isQQ)){this.drawKeyLine(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(this.isKM){this.drawKeyConfidence(C,q,"rectangle",f,B,B,j,w,E,M,A,null,O)}else{if(this.decorations&&this.decorations.reg){this.drawKeyLine(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(I){this.drawKeyBoxplot(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{this.drawKeyShape(C,q,h,f,B,Q,j,w,E,M,A,null,O)}}}}}}else{if(s.replace("Node","").replace("Edge","")=="shape"){h=e.shapeBy&&e.shapeBy.hasOwnProperty(g)?e.shapeBy[g]:this.legend.shape.m?this.legend.shape.m[g]:e.shapes[u];B=this.background;Q=this.foreground;this.drawKeyShape(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(s.replace("Node","").replace("Edge","").replace("contour","size")=="size"){var z=e.sizes?e.sizes.length:this.sizes.length;var n=e.sizeBy&&e.sizeBy.hasOwnProperty(g)?e.sizeBy[g]:s=="contour"?this.sizes[u%z]:this.legend.size.m?this.legend.size.m[g]:e.sizes[u%z];B=this.background;Q=this.foreground;if(s.match(/Edge/)){n=((parseInt(this.percentile(e.min,e.max,Number(M)))/100)*4)+0.5;this.drawKeyLineSize(C,q,n,f,B,Q,j,w,Q,M,A,null,O)}else{this.drawKeySize(C,q,h,[n,f],B,Q,j,w,E,M,A,null,O)}}else{if(s.replace("Node","").replace("Edge","")=="pattern"){if(this.graphType.match(/parallelcoordinates|line/i)){w=e.linePatternBy&&e.linePatternBy.hasOwnProperty(g)?e.linePatternBy[g]:e.linePatterns[u];this.drawKeyLine(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{B=this.background;Q=this.foreground;j=e.patternBy&&e.patternBy.hasOwnProperty(g)?e.patternBy[g]:this.legend.Patterns?this.legend.Patterns[g]:e.patterns[u];h=this.isOncoprint?"rectangle":h;if(I){this.drawKeyBoxplot(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{this.drawKeyShape(C,q,h,f,B,Q,j,w,E,M,A,null,O)}}}else{if(s=="connect"){E=e.connectBy&&e.connectBy.hasOwnProperty(g)?e.connectBy[g]:this.legend.connects?this.legend.connects[g]:e.connects[u];this.drawKeyLine(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(s=="line"){if(this.ribbonBy){E=e.lineBy&&e.lineBy.hasOwnProperty(g)?e.lineBy[g]:e.colors[u];this.drawKeyConfidence(C,q,h,f,E,E,j,w,E,M,A,null,O)}else{E=this.colorBy!=this.lineBy?"rgb(0,0,0)":e.colors[u];w=this.colorBy!=this.lineBy?e.linePatterns[u]:j;this.drawKeyLine(C,q,h,f,B,Q,j,w,E,M,A,null,O)}}}}}}}}u++}q+=this.legendTextMargin+d}}};this.drawCustomLegend=function(F,d,l,H,w){var z=w.text.length;var B=this.getDiameterLegend();var u=w.size;if(u){for(var D=0;D<u.length;D++){if(u[D]){B=Math.max(B,u[D])}}}var b=this.getFontPt(this.legendTitleFont);var j=this.getFontPt(this.legendTextFont);var m=this.legendColumns>z?z:this.legendColumns;var g=Math.ceil(z/m);var o=l/m;var E=d+(w.title?this.legendTitleMargin+(b/2):this.legendTextMargin+(j/2));var t=Math.max(B,j);var k=0;this.drawLegendTitle(F,d,l,H,w.title,"-legend-"+w.id);if(w.title){E+=b+(this.legendTitleMargin*2)}for(var v=0;v<g;v++){for(var G=0;G<m;G++){var q=F+this.legendTextMargin+(B/2)+(o*G);if(k<z){var a=w.text&&w.text[k]?w.text[k]:false;var A=w.shape&&w.shape[k]?w.shape[k]:false;var x=w.shapeColor&&w.shapeColor[k]?w.shapeColor[k]:this.background;var f=w.shapeBorderColor&&w.shapeBorderColor[k]?w.shapeBorderColor[k]:this.foreground;var p=w.line&&w.line[k]?w.line[k]:false;var C=w.shapePattern&&w.shapePattern[k]?w.shapePattern[k]:"closed";var h=w.lineType&&w.lineType[k]?w.lineType[k]:"solid";var y=w.lineColor&&w.lineColor[k]?w.lineColor[k]:this.foreground;var s=a;var e=this.isHidden(false,false,"legend-text-"+a);if(a){if(A&&p){this.drawKeyShapeLine(q,E,A,B,x,f,C,h,y,a,s,null,e)}else{if(A){this.drawKeyShape(q,E,A,B,x,f,C,h,y,a,s,null,e)}else{if(p){this.drawKeyLine(q,E,A,B,x,f,C,h,y,a,s,null,e)}else{this.drawKeyLabel(q,E,A,B,x,f,C,h,y,a,s,null,e)}}}}}k++}E+=this.legendTextMargin+t}};this.drawGenericLegend=function(r,o,m,x,p,z,n){var s=this.getDiameterLegend();var c=this.getFontPt(this.legendTextFont)+2;var q=Math.max(s,c);var d=0;this.drawLegendBackgroundBox(r,o,m,x,"-legend");this.toRender({p:["drawText",z,r+(m/2),o+this.margin+(c/2),this.legendTitleFont,this.legendTitleColor,"center","middle"],t:"Legends"});d=o+c+this.margin;if(this.showLegendBorder){this.toRender({p:["drawLine","line",r,d,r+m,d,this.legendBackgroundBorderColor],t:"Legends"})}d+=this.margin;if(!n){n=1}var b=m/n;var e=Math.ceil(p.levels.length/n);var f=0;var a=d;var g=p.origin?p.origin:this.meta.data.modified?"modified":"y";for(var v=0;v<e;v++){for(var u=0;u<n;u++){var y=r+this.margin+(b*u);if(f<p.levels.length){var k=p.type=="String"?p.colors[f]:this.getColorForValue(p.colorBrew,p.levels[f]);this.toRender({p:["drawShape",this.useRoundRectangles?"rounderect":"square",y+(q/2),a+(q/2),q,q,this.getFillColor(k),this.getOutlineColor(k)],i:["Property:"+z+":"+p.levels[f]+":"+g],t:"Legends",h:this.isHidden(false,false,"Property:"+z+":"+p.levels[f]+":"+g)});this.toRender({p:["drawText",p.levels[f],y+q+this.margin,a+(q/2),this.legendTextFont,this.legendTextColor,"left","middle"],i:["Property:"+z+":"+p.levels[f]+":"+g],t:"Legends",h:this.isHidden(false,false,"Property:"+z+":"+p.levels[f]+":"+g)})}else{break}f++}a+=q}};this.drawDecorationLegend=function(n,g){if(this.graphType.match(/Scatter/)){var w=this.decorations;var m=this.getFontPt(this.decorationsTextFont);var c=this.measureText(this.sprintf("%15s","X"),this.decorationsTextFont);var h=w.nlfit||w.nor||w.reg?c:0;var k=n+(h?this.legend.decoration.maxLabel+c:this.decorationsTextMargin);var v=k;var y=g;var a=y;this.legend.decoration.curX=n;this.legend.decoration.curY=g;this.drawLegendBackgroundBox(n,(g-((m/2)+this.decorationsTextMargin)),this.legend.decoration.width,this.legend.decoration.height+this.decorationsTextMargin,"-legend-decorations",true);if(w.nlfit){this.toRender({p:["drawText","Min",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","Max",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","EC50",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","Slope",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","p-Val",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","F-Chg",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});a+=m+this.decorationsTextMargin;for(var r=0;r<w.nlfit.length;r++){var o=r%this.colors.length;o=w.nlfit[r].color?w.nlfit[r].color:this.colors[o];v=(k+this.decorationsTextMargin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){v+=this.decorationsTextMargin+this.getFontPt(this.axisTitleFont)+this.decorationsTextMargin}this.toRender({p:["drawText",w.nlfit[r].label,v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v=k;for(var q=0;q<6;q++){var z=w.nlfit[r].param[q];if(q<2){z=this.transformValue(this.yAxisTransform,z)}else{if(q==2){}}this.toRender({p:["drawText",this.formatNumber(z,this.yAxisDecs+6),v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin}a+=m+this.decorationsTextMargin}}if(w.line){for(var r=0;r<w.line.length;r++){if(w.line[r].label){for(var r=0;r<w.line.length;r++){var o=w.line[r].color?w.line[r].color:this.colors[r%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){v+=this.decorationsTextMargin+this.getFontPt(this.axisTitleFont)+this.decorationsTextMargin}this.toRender({p:["drawText",w.line[r].label,v,a,this.decorationsTextFont,o,"left","middle"],t:"Legends"});a+=m+this.decorationsTextMargin}}}}if(w.reg){this.toRender({p:["drawText","Slope",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","Int",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","Cor",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});a+=m+this.decorationsTextMargin;for(var r=0;r<w.reg.length;r++){var o=w.reg[r].color?w.reg[r].color:this.colors[r%this.colors.length];v=(k+this.decorationsTextMargin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){v+=this.decorationsTextMargin+this.getFontPt(this.axisTitleFont)+this.decorationsTextMargin}this.toRender({p:["drawText",w.reg[r].label,v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v=k;this.toRender({p:["drawText",this.formatNumber(w.reg[r].slope,2),v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText",this.formatNumber(w.reg[r].intercept,this.yAxisDecs+1),v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText",(w.reg[r].cor?this.formatNumber(w.reg[r].cor,3):"NA"),v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;a+=m+this.decorationsTextMargin}}if(w.nor){this.toRender({p:["drawText","Mu",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText","Sigma",v,a,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});a+=m+this.decorationsTextMargin;for(var r=0;r<w.nor.length;r++){var o=r%this.colors.length;o=w.nor[r].color?w.nor[r].color:this.colors[o];v=(k+this.decorationsTextMargin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){v+=this.decorationsTextMargin+this.getFontPt(this.axisTitleFont)+this.decorationsTextMargin}this.toRender({p:["drawText",w.nor[r].label,v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v=k;this.toRender({p:["drawText",this.formatNumber(w.nor[r].mu,this.xAxisDecs+1),v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;this.toRender({p:["drawText",this.formatNumber(w.nor[r].sigma,this.xAxisDecs+2),v,a,this.decorationsTextFont,o,"right","middle"],t:"Legends"});v+=c+this.decorationsTextMargin;a+=m+this.decorationsTextMargin}}if(w.area){for(var r=0;r<w.area.length;r++){if(w.area[r].label){var o=w.area[r].color?w.area[r].color:this.colors[r%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){v+=this.decorationsTextMargin+this.getFontPt(this.axisTitleFont)+this.decorationsTextMargin}this.toRender(["drawText",w.area[r].label,v,a,this.decorationsTextFont,o,"left","middle"]);a+=m+this.decorationsTextMargin}}}}else{if(this.graphType=="Map"&&this.decorations.pie&&this.decorations.pie[0]&&this.decorations.pie[0].smps&&this.decorations.pie[0].smps.length){var w=this.decorations.pie[0];var m=this.getFontPt(this.decorationsTextFont);var b=m/2;var e=this.legend.decoration.columns||this.legendColumns;var x=Math.ceil(w.smps.length/e);var u=this.legend.decoration.width/e;var p=0;var k=n;var y=g;var s=y+b;for(var r=0;r<x;r++){for(var q=0;q<e;q++){v=k+(this.decorationsTextMargin+(u*q));if(p<w.smps.length){var c=w.colors[p];var f=v+b;this.toRender({p:["drawShape","circle",f,s,m,m,c,this.background],t:"Legends"});this.toRender({p:["drawText",w.smps[p],f+b+this.decorationsTextMargin,s,this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Legends"})}else{break}p++}s+=(b*2)+this.margin}}}};this.resetLegends=function(c){if(c){delete (this.legend.decoration.curX);delete (this.legend.decoration.curY);delete (this.legend.decoration.x);delete (this.legend.decoration.y)}var a=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","sample","bin2d"];for(var b=0;b<a.length;b++){this.legend[a[b]].width=0;this.legend[a[b]].height=0;if(c){delete (this.legend[a[b]].curX);delete (this.legend[a[b]].curY);delete (this.legend[a[b]].x);delete (this.legend[a[b]].y)}}};this.getXYLegendCoords=function(B,s,o){var k,g,r;var n=-1;var A=-1;var f=this;var c=this.graphType=="Network"?0:this.offsetX;var b=this.graphType=="Network"?0:this.offsetY;var d=function(){for(var l=0;l<f.legend.layout.length;l++){if(f.legend.layout[l]){for(var h=0;h<f.legend.layout[l].length;h++){if(f.legend.layout[l][h]==B){return[l,h]}}}}return[-1,-1]};if(this.legend.layout){var e=d();n=e[0];A=e[1];if(n>-1&&A>-1){var a=0;var p=0;if(this.legendPosition.match(/right|left/i)){for(var v=0;v<n;v++){var m=0;if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[v].length;u++){m=Math.max(m,this.legend[this.legend.layout[v][u]].width+this.margin)}}a+=m}if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[n].length;u++){p+=this.legend[this.legend.layout[n][u]].height+this.margin}}}else{for(var v=0;v<n;v++){var z=0;if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[v].length;u++){z=Math.max(z,this.legend[this.legend.layout[v][u]].height+this.margin)}}p+=z}if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[n].length;u++){a+=this.legend[this.legend.layout[n][u]].width+this.margin}}}if(this.graphType=="Circular"){k=s;g=o}else{if(this.legendPosition.match(/right|left/i)){o=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?this.marginTop+this.layoutTop:A==0?this.marginTop+b+this.top:o;k=s+a+(this.graphType=="Network"?-10:0);r=this.legendPosition.match(/top/)?this.margin:this.legendPosition.match(/bottom/)?this.y-(p+this.margin):((this.y-p)/2);g=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?(this.height-p)/2:A==0?this.marginTop+b+this.top+r:o;s=A==this.legend.layout[n].length-1?s+a:s;o=g+this.legend[this.legend.layout[n][A]].height+this.margin}else{s=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?this.marginLeft+this.layoutLeft:A==0?this.marginLeft+c+this.left:s;k=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?(this.width-a)/2:A==0?this.marginLeft+c+this.left+((this.x-a)/2)+this.margin:s+this.margin;g=o+p;s=k+this.legend[this.legend.layout[n][A]].width+this.margin;o=A==this.legend.layout[n].length-1?o+p:o}}}}return[k,g,s,o]};this.getVariableLegendPosition=function(){var c,h;if(this.graphType=="Pie"&&this.layoutValid){if(this.legendPosition=="right"){c=this.width-(this.marginRight+this.legend.variable.width+this.margin);h=(this.height/2)-(this.legend.variable.height/2)}else{c=(this.width/2)-(this.legend.variable.width/2);h=this.height-(this.marginBottom+this.legend.variable.height+this.margin)}}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return[0,0]}else{if(this.graphType=="Circular"){c=this.width-(this.marginRight+this.legend.variable.width+this.margin);h=this.height-(this.marginBottom+this.legend.variable.height+this.margin);return[c,h]}else{if(this.layoutValid&&this.graphType!="Pie"){var d=this.width-(this.marginLeft+(this.layoutLeft||this.margin)+(this.layoutRight||this.margin)+this.marginRight);var b=this.height-(this.marginTop+(this.layoutTop||this.margin)+(this.layoutBottom||this.margin)+this.marginBottom);var j=this.legend.variable.height+this.legend.overlays.height+(this.margin*-0.5);var e=this.legend.variable.width+this.legend.overlays.width+(this.margin*-0.5);c=this.legendPosition=="right"?this.width-(this.marginRight+e):this.legendPosition=="left"?this.marginLeft+this.margin:this.marginLeft+(this.layoutLeft||this.margin)+(d/2)-(e/2);h=this.legendPosition=="bottom"?this.height-(this.marginBottom+j):this.legendPosition=="top"?this.marginTop+this.margin+this.getTitleSubtitleHeight():this.marginTop+(this.layoutTop||this.margin)+(b/2)-(j/2)}else{var f=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;var a=this.legend.variable.height;var i=this.legend.variable.width;if(this.legendInside||this.graphType=="Pie"){switch(this.legendPosition){case"bottomRight":c=f+this.x-(i+this.margin);h=k+this.y-(a+this.margin);break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y-(this.graphType=="Pie"?0:(a+this.margin));break;case"bottomLeft":c=f+this.margin;h=k+this.y-(a+this.margin);break;case"left":c=f+this.margin-(this.graphType=="Pie"?(i+this.margin):0);h=k+(this.y/2)-(a/2);break;case"topLeft":c=f+this.margin;h=k+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=k+this.margin-(this.graphType=="Pie"?(a+this.margin):0);break;case"topRight":c=f+this.x-(i+this.margin);h=k+this.margin;break;default:c=f+this.x-(this.graphType=="Pie"?0:(i+this.margin));h=k+(this.y/2)-(a/2)}}else{var m=this.overlaysLegendPosition.match(/top|bottom/i)?this.legend.overlays.height:0;var g=this.overlaysLegendPosition.match(/right|left/i)?this.legend.overlays.width:0;switch(this.legendPosition){case"bottomRight":c=f+this.x+this.right-(i+g+this.margin);h=k+this.y-a;break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y+this.bottom-(a+m+this.margin);break;case"bottomLeft":c=this.marginLeft+this.offsetX+this.margin;h=k+this.y-a;break;case"left":c=this.marginLeft+this.offsetX+this.margin;h=k+(this.y/2)-(a/2);break;case"topLeft":h=k;c=this.marginLeft+this.offsetX+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=this.marginTop+this.offsetY+this.margin+this.getTitleSubtitleHeight();break;case"topRight":h=k;c=f+this.x+this.right-(i+g+this.margin);break;default:c=f+this.x+this.right-(i+g+this.margin);h=k+(this.y/2)-(a/2)}}}}}}return[c,h]};this.getScatterLegendPosition=function(){var j=0;var h=0;var g=0;var d=0;var a=0;var i=0;var c=this.graphType=="Network"?10:this.offsetX;var b=this.graphType=="Network"?10:this.offsetY;var e=this.marginLeft+c+this.left+this.margin;var k=this.marginTop+b+this.top+this.margin;if(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition"))){if(this.legendPosition=="left"){g=this.marginLeft+this.margin}else{g=this.width+this.margin-(this.marginRight+(this.legend.width||0))}if(this.legendPosition=="top"){d=this.marginTop+this.margin+this.getTitleSubtitleHeight()}else{d=this.height+this.margin-(this.marginBottom+(this.legend.height||0))}j=g-(this.legend.decoration.width+this.margin);h=d-(this.legend.decoration.height+this.margin)}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"&&this.colorBy){g=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendTextColorWidth+this.right+this.marginRight);d=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendTextColorHeight+this.bottom+this.marginBottom)}else{g=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legend.variable.width+this.right+this.marginRight);d=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legend.variable.height+this.bottom+this.marginBottom)}}else{if(this.legendInside){if(this.legend.decoration.width>0&&this.legend.decoration.height>0){var f=this.legend.decoration.width+(this.margin*2);switch(this.decorationsPosition){case"bottomRight":j=e+this.x-f;h=k+this.y-(this.legend.decoration.height+this.margin);break;case"bottom":j=e+(this.x/2)-(this.legend.decoration.width/2);h=k+this.y-(this.legend.decoration.height+this.margin);break;case"bottomLeft":j=e+this.margin;h=k+this.y-(this.legend.decoration.height+this.margin);break;case"left":j=e+this.margin;h=k+(this.y/2)-(this.legend.decoration.height/2);break;case"topLeft":j=e+this.margin;h=k+(this.margin*2);break;case"top":j=e+(this.x/2)-(this.legend.decoration.width/2);h=k+(this.margin*2);break;case"topRight":j=e+this.x-f;h=k+(this.margin*2);break;default:j=e+this.x-f;h=k+(this.y/2)-(this.legend.decoration.height/2);break}}if(this.legend.width>0&&this.legend.height>0){switch(this.legendPosition){case"bottomRight":g=e+this.x-this.legend.width;d=k+this.y-this.legend.height;break;case"bottom":g=e+(this.x/2)-(this.legend.width/2);d=k+this.y-this.legend.height;break;case"bottomLeft":g=e;d=k+this.y-this.legend.height;break;case"left":g=e;d=k+(this.y/2)-(this.legend.height/2);break;case"topLeft":g=e;d=k;break;case"top":g=e+(this.x/2)-(this.legend.width/2);d=k;break;case"topRight":g=e+this.x-this.legend.width;d=k;break;default:g=e+this.x-this.legend.width;d=k+(this.y/2)-(this.legend.height/2);break}}}else{switch(this.decorationsPosition){case"bottom":j=e+(this.x/2)-(this.legend.decoration.width/2);h=k+this.y+this.bottom-this.legend.decoration.height;break;default:j=e+this.x+this.right-(this.legend.decoration.width+(this.margin*2));h=k+(this.y/2)-(this.legend.decoration.height/2);break}a=this.legendPosition==this.decorationsPosition?this.legend.decoration.width:0;i=this.legendPosition==this.decorationsPosition?this.legend.decoration.height:0;switch(this.legendPosition){case"bottomRight":g=e+this.x+this.right-(this.legend.width+a);d=k+this.y-(this.legend.height/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legend.width}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break;case"bottom":g=e+(this.x/2)-(this.legend.width/2);d=k+this.y+this.bottom-(this.legend.height+(i?i+this.margin:0));if(this.graphType=="Scatter3D"||this.is3DPlot){d+=this.legend.height}break;case"bottomLeft":g=this.marginLeft+c+this.margin;d=k+this.y-(this.legend.height/2);break;case"left":g=this.marginLeft+c+this.margin;d=k+(this.y/2)-(this.legend.height/2);break;case"topLeft":g=this.marginLeft+c+this.margin;d=k+(this.legend.height/2);break;case"top":g=e+(this.x/2)-(this.legend.width/2);d=this.marginTop+b+this.margin+this.getTitleSubtitleHeight();break;case"topRight":g=e+this.x+this.right-(this.legend.width+a);d=k+(this.legend.height/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legend.width}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break;default:g=e+this.x+this.right-(this.legend.width+a);d=k+(this.y/2)-(this.legend.height/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legend.width}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break}}}}return[j,h,g,d]};this.drawIndicator=function(a,b,c){this.drawColorIndicator(a,b,false,c)};this.drawLegend=function(a){if(this.graphType=="Meter"){return}else{if(this.graphType=="Fish"){var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}else{if(this.graphType=="Venn"){this.drawVennLegend()}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"){this.drawScatterLegend(a)}else{if(this.circularType=="bubble"){}else{if(this.showLegend){this.drawOverlaysLegend();var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}}}}else{if(this.graphType=="Network"){this.drawScatterLegend()}else{if(this.graphType.match(/Scatter/)||this.is3DPlot||((this.isAttributedGraph()||this.connectBy)&&(CanvasXpress.graphTypes.AttGraphs.includes(this.graphType)||this.graphType=="Map"))){this.drawScatterLegend(a);if(this.isOncoprint){this.drawOncoprintLegend()}this.drawOverlaysLegend()}else{if(this.graphType=="Pie"&&this.layoutValid&&!this.isDOE){if(this.layoutCurrent==this.data.l.smps.length-1){this.draw1DLegend()}}else{this.draw1DLegend();this.drawOverlaysLegend()}}}}}}}};this.draw1DLegend=function(){if(this.showLegend&&((this.graphType!="Heatmap")||(this.graphType=="Heatmap"&&this.isAttributedGraph()))){if(this.isMultidimensionalData||(this.isAttributedGraph()&&CanvasXpress.graphTypes.AttGraphs.includes(this.graphType))){if(this.isOncoprint){this.drawOncoprintLegend()}this.drawScatterLegend()}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return}var c=this.getVariableLegendPosition();var a=c[0];var b=c[1];if(this.legend.variableX&&this.legend.variableY){a=this.legend.variableX;b=this.legend.variableY}this.legend.variableCurX=a;this.legend.variableCurY=b;this.drawVariableLegend(a,b)}}else{if(this.isOncoprint){this.drawOncoprintLegend()}}};this.drawOverlaysLegend=function(){var s,e;if(this.overlaysLegendPosition.match(/right/i)){s=this.layoutValid?this.marginTop+this.layoutTop:this.marginTop+this.offsetY+this.top;if(this.overlaysLegendPosition=="right"){s+=(this.y/2)-(this.legend.overlays.height/2)}e=this.layoutValid?this.width-(this.marginRight+this.layoutRight+this.legend.overlays.width):this.width-(this.marginRight+this.legend.overlays.width);if(this.graphType=="Heatmap"&&this.heatmapIndicatorPosition=="right"){e-=this.getHeatmapIndicatorWidth()-this.margin}}else{s=this.layoutValid?this.height-(this.marginBottom+this.layoutBottom+this.legend.overlays.height):this.height-(this.marginBottom+this.legend.overlays.height);e=this.layoutValid?this.marginLeft+this.layoutLeft:this.marginLeft+this.offsetX+this.left;if(this.overlaysLegendPosition=="bottom"){e+=(this.x/2)-(this.legend.overlays.width/2)}}var v=s;var f=e;for(var k=0;k<this.legend.overlays.layout.length;k++){var n=this.legend.overlays.layout[k];var r,b,d,a;var u=mw=0;var p=mh=0;for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];mw=Math.max(u,n[g][2]);mh=Math.max(p,n[g][3])}for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];d=this.meta.data[r][b];u=this.legend.overlays[b].width;p=this.legend.overlays[b].height;a=r=="z"?this.varOverlaysLegendColumns:this.smpOverlaysLegendColumns;if(d.type=="String"){this.drawGenericLegend(f,v,u,p,d,b,a)}else{this.drawColorIndicator(f,v,d,b,false,u/2)}if(this.overlaysLegendPosition.match(/right/i)){v+=p+this.margin}else{f+=u+this.margin}}if(this.overlaysLegendPosition.match(/right/i)){f+=mw+this.margin;v=s}else{f=e;v+=mh+this.margin}}};this.drawScatterLegend=function(g){var o=this.getScatterLegendPosition();if(this.showDecorations&&this.showDecorationsLegend&&this.decorations&&!this.layoutValid){if(this.legend.decoration.x!=null&&this.legend.decoration.y!=null){this.drawDecorationLegend(this.legend.decoration.x,this.legend.decoration.y)}else{this.drawDecorationLegend(o[0],o[1])}}if(this.showLegend){var l=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge","decoration"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","sample","contour","bin2d"];var f=o[2];var p=o[3];var u=this.isContour&&this.contourType=="Point"?"Size":"Color";for(var j=0;j<l.length;j++){var t=this.legend[l[j]].width;var k=this.legend[l[j]].height;var s=this.legend[l[j]].x;var n=this.legend[l[j]].y;var b=this.isHistogramLayout()&&l[j]=="sample";if(t>0){if(g&&!b){this.setPropertyLegendDimensions(l[j]);t=this.legend[l[j]].width;k=this.legend[l[j]].height}var a=this.capitalize(l[j]);var e=("draw"+a+"Legend").replace("Node","").replace("Edge","").replace("Decoration","color").replace("Contour",u).replace("Bin2d",u).replace("Line","Color");var d=this.legend[l[j]].meta;var r=this.getXYLegendCoords(l[j],f,p);if(s&&n){this[e](s,n,d,l[j]);this.legend[l[j]].curX=s;this.legend[l[j]].curY=n}else{this[e](r[0],r[1],d,l[j]);this.legend[l[j]].curX=r[0];this.legend[l[j]].curY=r[1]}if(this.legendPosition.match(/right|left/i)){p=r[3]+this.margin}else{f=r[2]+this.margin}}}for(var j=0;j<this.customLegend.length;j++){if(this.graphType=="Network"&&!this.showDecorations){continue}var c="custom"+j;var t=this.legend[c].width;var k=this.legend[c].height;var s=this.legend[c].x;var n=this.legend[c].y;var r=this.getXYLegendCoords(c,f,p);if(s&&n){this.drawCustomLegend(s,n,t,k,this.customLegend[j]);this.legend[c].curX=s;this.legend[c].curY=n}else{this.drawCustomLegend(r[0],r[1],t,k,this.customLegend[j]);this.legend[c].curX=r[0];this.legend[c].curY=r[1]}if(this.legendPosition.match(/right|left/i)){p=r[3]+this.margin}else{f=r[2]+this.margin}}}}};CanvasXpress.prototype.initMarkerUtils=function(){this.setMarker=function(p,u){var k=this;var o=function(){if(k.layoutValid&&k.data.l&&k.data.l.comp&&k.segregateSamplesBy.length&&k.segregateVariablesBy.length){if(!p.variable){return[]}var f=k.isArray(p.variable)?p.variable[0]:p.variable;for(var m=0;m<k.data.l.comp[k.layoutCurrent][0].length;m++){var x=k.data.l.comp[k.layoutCurrent][0][m];var y=k.data.y.vars[x];if(y==f){return[x]}}return[]}else{return !p.variable?[]:k.isArray(p.variable)?k.getVariableIndices(p.variable):k.getVariableIndices([p.variable])}};var s=function(){var B=[];if(k.layoutValid&&k.data.l&&k.data.l.smps&&k.data.l.smps[k.layoutCurrent]){for(var z=0;z<k.data.l.smps[k.layoutCurrent].length;z++){if(k.data.l.smps[k.layoutCurrent][z]==p.sample){if(((k.graphType=="Boxplot"&&k.showBoxplotOriginalData)||k.graphType=="Dotplot")&&k.isGroupedData&&k.data.w){var D=false;for(var y=0;y<k.data.w.grps.length;y++){for(var x=0;x<k.data.w.grps[y].length;x++){if(k.data.l.ids[k.layoutCurrent][z]==k.data.w.grps[y][x]){B.push(y);B.push(k.data.l.ids[k.layoutCurrent][z]);D=true}}if(D){break}}}else{B.push(k.data.l.ids[k.layoutCurrent][z])}break}}if(!B.length&&k.isGroupedData&&k.data.w){for(var z=0;z<k.data.w.labs.length;z++){if(k.data.w.labs[z].replace("\x00","")==p.sample){B.push(z)}}}if(p.scope&&k.isArray(p.scope)){if(k.isGroupedData&&k.data.w&&B.length){if(p.scope.length>1){if(k.data.l.name[k.layoutCurrent].includes(p.scope[0])&&k.data.l.name[k.layoutCurrent].includes(p.scope[1])){B=[B[0]]}else{B=null}}else{if(k.data.l.name[k.layoutCurrent].includes(p.scope[0])){B=[B[0]]}else{B=null}}}else{if(k.data.x){for(var z=0;z<B.length;z++){var C=B[z];var A=0;for(var f in k.data.x){if(p.scope.includes(k.data.x[f][C])){A++}}if(A==p.scope.length){B=C;break}}if(k.isArray(B)){B=[B[0]]}}else{B=[B[0]]}}}}else{B=!p.sample?[]:k.isArray(p.sample)?k.getSampleIndices(p.sample,i):k.getSampleIndices([p.sample],i);if(!B.length&&k.isGroupedData&&k.data.w){for(var z=0;z<k.data.w.grps.length;z++){var m=k.data.w.labs[z].replace("\x00","");if(p.sample[0].toString().replace("\x00","")==m){B.unshift(z);D=true;break}}}if(((k.graphType=="Boxplot"&&k.showBoxplotOriginalData)||k.graphType=="Dotplot")&&k.isGroupedData&&k.data.w){if(B.length){var D=false;for(var z=0;z<k.data.w.grps.length;z++){for(var y=0;y<k.data.w.grps[z].length;y++){if(B[0]==k.data.w.grps[z][y]){B.unshift(z);D=true;break}}if(D){break}}}else{B=!p.sample?[]:k.isArray(p.sample)?k.getSampleIndices(p.sample):k.getSampleIndices([p.sample])}}}return B};var w=function(A){var z=k.meta.render.objects;var x=[];for(var m=0;m<z.length;m++){var y=z[m];if(y.type=="Data"&&y.idx){var f=y.idx.join(":");if(f==A||f==A+":false"||f==A+":true"||f==A+":box"){if(k.layoutValid){if(y.layout==k.layoutCurrent){x.push(y)}}else{x.push(y)}}}}if(x.length){return x[0]}return false};var g=function(){if(p.fontSize){return(p.fontStyle||"")+" "+parseInt(p.fontSize)+"px "+k.fontName}else{return k.decorationsTextFont}};if(!p.variable){return false}var v=function(y,C){var A=y.textLength*0.5;var E=y.textHeight*0.5;var z=y.tx<=C[2].left[0]-A;var x=y.tx>=C[2].right[0]+A;var F=y.ty<=C[2].top[1]-E;var D=y.ty>=C[2].bottom[1]+E;var B=1.1;if(F&&z){y.line[2]+=A*B;y.line2=[y.line[2],y.line[3]-E,y.line[2],y.line[3]+E]}else{if(F&&x){y.line[2]-=A*B;y.line2=[y.line[2],y.line[3]-E,y.line[2],y.line[3]+E]}else{if(D&&x){y.line[2]-=A*B;y.line2=[y.line[2],y.line[3]-E,y.line[2],y.line[3]+E]}else{if(D&&z){y.line[2]+=A*B;y.line2=[y.line[2],y.line[3]-E,y.line[2],y.line[3]+E]}else{if(F){y.line[3]+=E;y.line2=[y.line[2]-A,y.line[3],y.line[2]+A,y.line[3]]}else{if(x){y.line[2]-=A*B;y.line2=[y.line[2],y.line[3]-E,y.line[2],y.line[3]+E]}else{if(D){y.line[3]-=E;y.line2=[y.line[2]-A,y.line[3],y.line[2]+A,y.line[3]]}else{if(z){y.line[2]+=A*B;y.line2=[y.line[2],y.line[3]-E,y.line[2],y.line[3]+E]}else{delete (y.line);delete (y.line2)}}}}}}}}};var i=this.graphType.match(/Treemap|Stacked|Dotplot/)||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)?true:false;var h=o();var e=p.variable2&&this.isArray(p.variable2)?this.getVariableIndices(p.variable2):p.variable2?this.getVariableIndices([p.variable2]):false;var d=s();var c=p.sample2&&this.isArray(p.sample2)?this.getSampleIndices(p.sample2,i):p.sample2?this.getSampleIndices([p.sample2],i):false;var a,r,q,n,l;var b=h.concat(d).join(":");var t=w(b);var j=p.position&&p.position!="false"?p.position:"center";if(t&&t.area){switch(p.type){case"comparison":a=e.concat(c).join(":");r=w(a);n=this.renderObjectCoordinates(t,"top",false,4);l=this.renderObjectCoordinates(r,"top",false,4);q=[(n[0]+l[0])/2,Math.min(n[1],l[1])-(this.getFontPt(g())*0.5)];p.tx=p.offsetX?q[0]+p.offsetX:q[0];p.ty=p.offsetY?q[1]+p.offsetY:q[1];p.line=[n[0],Math.min(n[1],l[1]),l[0],Math.min(n[1],l[1])];p.render=t.n;p.render2=r.n;p.id=p.id==null?this.newId("-marker-"):p.id;break;case"line":case"annotation":default:n=this.renderObjectCoordinates(t,j,false,(p.x&&p.y?0:2),p.x,p.y);q=[n[0],n[1]];if(p.x&&p.y){q=n[3]}p.tx=u?p.curX:p.offsetX?q[0]+p.offsetX:q[0];p.ty=u?p.curY:p.offsetY?q[1]+p.offsetY:q[1];p.line=u?[n[2].center[0],n[2].center[1],p.tx,p.ty]:[n[2].center[0],n[2].center[1],q[0],q[1]];p.text=p.text.replace(/__nl__/g,"\n");p.textLength=this.measureText(p.text,g());p.textHeight=this.measureTextWidth(p.text,g());v(p,n);p.render=t.n;p.id=p.id==null?this.newId("-marker-"):p.id;break}return p}return false};this.getMarker=function(c){if(c&&this.decorations&&this.decorations.marker){for(var b=0;b<this.decorations.marker.length;b++){var a=this.decorations.marker[b];if(c==a.id){return a}}}};this.drawMarkers=function(a){var c=this;var u=function(d){if(c.layoutValid){var j=c.layoutCurrent==false?0:c.layoutCurrent!=null?c.layoutCurrent:(c.layoutValidN||0);var i=c.layoutParams[j];if(d.si!=null||d.render){if(d.hasOwnProperty("layout")){if(d.layout!=j){return false}}return d.ty>c.offsetY&&d.ty<c.offsetY+(i.height||c.height)&&d.tx>c.offsetX&&d.tx<c.offsetX+(i.width||c.width)}else{return false}}else{return d.ty>0&&d.ty<c.height&&d.tx>0&&d.tx<c.width}};var b=function(){if(v.fontSize){return(v.fontStyle||"")+" "+parseInt(v.fontSize)+"px "+c.fontName}else{return c.decorationsTextFont}};if(a){this.clearHighlightCanvas();this.isHighlightCanvas=true}else{if(this.moveMarker){return}}if(this.decorations&&this.decorations.marker){var A=this.decorations.marker;var w=[];if(this.layoutValid&&this.data.l&&!this.isDOE){var r=this.data.l.name[this.layoutCurrent];for(var z=0;z<A.length;z++){if(!this.isArray(A[z].scope)){A[z].scope=[A[z].scope]}if(A[z].scope){if(this.isArray(r)){if(this.isArray(A[z].scope)){var B=r.sort().join("").replace("\x00","");var p=A[z].scope.sort().join("").replace("\x00","");if(B==p){w.push(z)}}else{if(r.includes(A[z].scope[0])){w.push(z)}}}else{if(r==A[z].scope[0]){w.push(z)}}}else{w.push(z)}}}else{for(var z=0;z<A.length;z++){w.push(z)}}for(var z=0;z<w.length;z++){delete (A[w[z]].tx);delete (A[w[z]].ty);delete (A[w[z]].layout);var v=this.setMarker(A[w[z]],a);if(v&&v.tx&&v.ty){if(u(v)||a){var g=v.scope||false;if(g){var f=this.layoutValid?false:true;if(this.layoutValid){var h=this.data.l.name[this.layoutCurrent];if(!this.isArray(h)){h=[h]}for(var y=0;y<h.length;y++){var t=h[y].toString().replace("\x00","");if(this.isArray(g)){for(var x=0;x<g.length;x++){if(g[x].toString()==t){f=true;break}}}else{if(g.toString()==t){f=true;break}}}}if(!f){continue}}var e=v.rotate?Math.PI*v.rotate/180:false;v.color=v.color||"rgb(0,0,0)";v.align=v.align||"center";v.baseline=v.baseline||"middle";v.width=v.width||1;var o=this.toRender({p:["drawText",v.text,v.tx,v.ty,b(v),v.color,v.align,v.baseline,e],g:v.render||null,i:["Marker:"+v.id],t:"Decorations",d:this.moveMarker?true:false});if(!a){if(v.type!="annotation"&&v.line){this.toRender({p:["drawLine","line",v.line[0],v.line[1],v.line[2],v.line[3],v.color,v.width],g:v.render||o,t:"Decorations",d:this.moveMarker?true:false})}if(v.type=="comparison"){this.toRender({p:["drawLine","line",v.line[0],v.line[1]-this.margin,v.line[0],v.line[1]+this.margin,v.color,v.width],g:v.render||o,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine","line",v.line[2],v.line[3]-this.margin,v.line[2],v.line[3]+this.margin,v.color,v.width],g:v.render||o,t:"Decorations",d:this.moveMarker?true:false})}else{if(v.type!="annotation"&&v.line2){this.toRender({p:["drawLine","line",v.line2[0],v.line2[1],v.line2[2],v.line2[3],v.color,v.width],g:v.render||o,t:"Decorations",d:this.moveMarker?true:false})}}}v.curX=v.tx;v.curY=v.ty}}}}if(a){this.isHighlightCanvas=false}}};CanvasXpress.prototype.initFilterUtils=function(){this.handleSelector=function(l){this.hiddenLegends[l.id]=this.hiddenLegends[l.id]?false:true;var c=!this.hiddenLegends[l.id];var m=this.showTransition;this.showTransition=false;switch(l.type){case"var":this.filterVariables(l.type+"s","exact",(this.isArray(l.name)?l.name:[l.name]),c);break;case"smp":this.filterSamples(l.type+"s","exact",(this.isArray(l.name)?l.name:[l.name]),c);break;case"series":if(this.isHistogramLayout()){var b=(!this.segregateVariablesBy.length||this.segregateVariablesBy[0]!=this.isCreateHistogram.factor)?l.name[1].split(":")[1]:(this.segregateVariablesBy[0]==this.isCreateHistogram.factor)?l.name[1].split(":")[0]:false;if(b){l.name=[l.name[0]];for(var e=0;e<this.data.y.smps.length;e++){var g=this.data.y.smps[e].split(":");for(var d=0;d<g.length;d++){if(g[d]==b){l.name.push(this.data.y.smps[e]);continue}}}}}this.filterSamples("smps","exact",(this.isArray(l.name)?l.name:[l.name]),c);break;case"meta":var k=this.isOncoprint||this.isMultidimensionalData&&!this.meta.data[l.object][l.factor]&&this.meta.data[l.object]?this.meta.data[l.object]:this.meta.data[l.object][l.factor];switch(l.object){case"x":if(k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.filterSamplesByCategory(l.factor,"between",[f,a],c)}else{this.filterSamplesByCategory(l.factor,"exact",(this.isArray(l.level)?l.level:[l.level]),c)}break;case"z":if(k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.filterVariablesByCategory(l.factor,"between",[f,a],c)}else{this.filterVariablesByCategory(l.factor,"exact",(this.isArray(l.level)?l.level:[l.level]),c)}break;case"y":var k=this.shapeBy==l.factor?this.legendShapeMeta:this.sizeBy==l.factor?this.legendSizeMeta:false;if(!k){return}var h=0;for(var e=0;e<k.vals.length;e++){if(Number(l.level)==k.vals[e]){h=e;break}}var a=k.vals[h];var f=h==0?Number(l.level)-1e-9:k.vals[h-1]+1e-9;this.filterVariablesByCategory(l.factor,"between",[f,a],c);break;case"modified":if(this.meta.data.modified.x&&this.meta.data.modified.x.meta&&this.meta.data.modified.x.meta[l.factor]){alert("Ooops! Needs to develop this case!")}else{if(this.meta.data.modified.z&&this.meta.data.modified.z.meta&&this.meta.data.modified.z.meta[l.factor]){this.filterUserData("filterSmpBy",l.factor,"exact",[this.meta.data.modified.z.meta[l.factor].order[l.level]],c)}}break;default:if(k&&k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.filterDataByCategory(l.object,"between",[f,a],c)}else{this.filterDataByCategory(l.object,"exact",[l.level],c)}break}break;case"data":this.filterDataByCategory(l.object,"exact",[l.name],c);break}this.showTransition=m};this.filterVariables=function(f,e,c,d,a){this.filterUserData("filterVarBy","vars",e,c,d,a)};this.filterVariablesByCategory=function(f,e,c,d,a){this.filterUserData("filterVarBy",f,e,c,d,a)};this.filterSamples=function(f,e,c,d,a){this.filterUserData("filterSmpBy","smps",e,c,d,a)};this.filterSamplesByCategory=function(c,f,d,e,a){this.filterUserData("filterSmpBy",c,f,d,e,a)};this.filterDataByCategory=function(g,f,d,e,a){this.filterUserData("filterDataBy",g,f,d,e,a)};this.filterUserData=function(l,n,e,q,a,r){if(this.isTransition()){return}var j={min:">=",max:"<=",between:"between",like:"like",exact:"exact"};var c={hidden:{},unhidden:{},vs:q,op:!a};var p;this.showMask();var m=this.cloneObject(this[l]);var k=this.ungroupGroupedData();if(!r&&a){this.reset(true,true,false,r);this.filterData(k,!r);p={hiddenVars:this.cloneObject(this.hiddenVars),hiddenSmps:this.cloneObject(this.hiddenSmps),hiddenGrps:this.cloneObject(this.hiddenGrps),hiddenMapFeatures:this.cloneObject(this.hiddenMapFeatures)}}this[l]=m;if(a){for(var f=0;f<this[l].comp.length;f++){if(this[l].comp[f]==n&&this[l].op[f]==j[e]&&this[l].cases[f]==false&&this[l].type[f]=="Legend"&&this.isSameObject(this[l].value[f],q)){this[l].comp.splice(f,1);this[l].op.splice(f,1);this[l].cases.splice(f,1);this[l].type.splice(f,1);this[l].value.splice(f,1)}}}else{this[l].comp.push(n);this[l].op.push(j[e]);this[l].cases.push(false);this[l].type.push("Legend");this[l].value.push(q)}this.reset(true,true,false,r);this.filterData(k,!r);if(this.isGroupedData&&this.smpIndices.length>0){var d=this.cloneObject(this.data.w.grpIdxs);this.groupSamples(this.groupingFactors,false,d,true,true,false,k?false:true)}this.filterIdToName(p,c);this.draw({func:"filterUserData",par:[l,n,e,q,a,r],prop:{hiddenLegends:this.hiddenLegends}});this.userEvents.clicklegend.call(this,c,this.lastEvent,this)};this.filterIdToName=function(a,e){var f=["hiddenVars","hiddenSmps","hiddenGrps","hiddenMapFeatures"];for(var c=0;c<f.length;c++){var d=f[c];e.hidden[d]=[];e.unhidden[d]=[];if(!e.op){if(a[d]){for(var c=0;c<a[d].length;c++){if(!this[d][c]&&a[d][c]){switch(d){case"hiddenVars":e.unhidden[d][this.data.y.vars[c]]=true;break;case"hiddenSmps":e.unhidden[d][this.data.y.smps[c]]=true;break;case"hiddenGrps":e.unhidden[d][this.data.w.smps[c]]=true;break;case"hiddenMapFeatures":e.unhidden[d][vs[0]]=true;break}}}}}else{if(this[d]){for(var c=0;c<this[d].length;c++){if(this[d][c]){switch(d){case"hiddenVars":e.hidden[d][this.data.y.vars[c]]=true;break;case"hiddenSmps":e.hidden[d][this.data.y.smps[c]]=true;break;case"hiddenGrps":e.hidden[d][this.data.w.smps[c]]=true;break;case"hiddenMapFeatures":e.hidden[d][e.vs[0]]=true;break}}}}}if(this[d]){this[d+"Local"]={};for(var c=0;c<this[d].length;c++){this[d+"Local"][this.data.y.vars[c]]=this[d][c]}}}};this.filterData=function(E,H){if(this.isDOE){return}this.showMask();var y={};var P={};var c={};var J=false;var F=this;var u=function(){var a=[];if(F.graphType.match(/line/i)&&F.xAxis.length&&F.xAxis2.length){a=F.getVariableIndices(F.xAxis);return a.concat(F.getVariableIndices(F.xAxis2))}else{return F.varIndices}};var G=function(s,v,g){if(v.hasOwnProperty(s)){return v[s]}else{if(s.match(":::")){var d=s.split(":::");if(g[d[1]]){d[1]=parseInt(d[1]);for(var k=0;k<g[d[1]].length;k++){var h=g[d[1]][k];if(v.hasOwnProperty(h)){v=v[h]}else{return false}}if(v.hasOwnProperty(d[0])){return v[d[0]]}}}return false}};var o=function(a){var d={s:[],v:[]};if(F.filterSmpBy.comp.length){for(var g=0;g<F.filterSmpBy.comp.length;g++){if(F.filterSmpBy.comp[g]){if(a&&F.filterSmpBy.type[g]!="Legend"){continue}d.s[g]=F.getSampleIndices(F.filterSmpBy.comp[g])}}}if(F.filterVarBy.comp.length){for(var g=0;g<F.filterVarBy.comp.length;g++){if(F.filterVarBy.comp[g]){if(a&&F.filterVarBy.type[g]!="Legend"){continue}d.v[g]=F.getVariableIndices(F.filterVarBy.comp[g])}}}return d};var I=function(aa){var ad=F.motionBy?F.seq(0,F.data.y.vars.length-1,1):F.graphType.match(/line/i)?u():F.varIndices;var Z=o(aa);var s=[];var a;var k=false;for(var v=0;v<ad.length;v++){var ae=ad[v];var h=false;var ac=false;a=F.filterSmpBy;if(a.comp.length>0){for(var p=0;p<a.comp.length;p++){if(a.comp[p]){if(aa&&a.type[p]!="Legend"){continue}var ab=Z.s[p];if(ab>=0){k=true;var g=A(F.data.y.data[ae][ab],a.op[p],a.value[p],a.cases[p]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;ac=true;break}}else{if(g){h=true;break}}}}}}a=F.filterVarBy;if(a.comp.length>0&&!ac){for(var p=0;p<a.comp.length;p++){if(a.comp[p]){if(aa&&a.type[p]!="Legend"){continue}var ab=Z.v[p];if(ab==-1){k=true;var d=a.comp[p]=="vars"?F.data.y.vars[ae]:F.getMetadataValue(ae,"z",a.comp[p]);var g=A(d,a.op[p],a.value[p],a.cases[p]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){s.push(ae)}}return k?s:false};var M=function(ad,ac){if(F.isGroupedData&&(!E||ac)){var ag=F.grpIndices;var Z=[];var a;var s=false;for(var aa=0;aa<ag.length;aa++){var ah=ag[aa];var h=false;var af=false;a=F.filterSmpBy;if(a.comp.length>0){for(var v=0;v<a.comp.length;v++){if(a.comp[v]){if(ad&&a.type[v]!="Legend"){continue}s=true;if(a.comp[v]=="smps"){var g=false;for(var p=0;p<F.data.w.grps[ah].length;p++){if(A(F.data.y.smps[F.data.w.grps[ah][p]],a.op[v],a.value[v],a.cases[v])){g=true;break}}if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;af=true;break}}else{if(g||h){h=true;break}}}else{var g=A(F.data.w.factors[a.comp[v]][aa],a.op[v],a.value[v],a.cases[v]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;af=true;break}}else{if(g||h){h=true;break}}}}}}if(h){Z.push(ah)}}}else{var ag=F.smpIndices;var ab=o(ad);var Z=[];var a;var s=false;for(var aa=0;aa<ag.length;aa++){var ah=ag[aa];var h=false;var af=false;a=F.filterVarBy;if(a.comp.length>0){for(var v=0;v<a.comp.length;v++){if(a.comp[v]){if(ad&&a.type[v]!="Legend"){continue}var ae=ab.v[v];if(ae>=0){s=true;var g=A(F.data.y.data[ae][ah],a.op[v],a.value[v],a.cases[v]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;af=true;break}}else{if(g){h=true;break}}}}}}a=F.filterSmpBy;if(a.comp.length>0&&!af){for(var v=0;v<a.comp.length;v++){if(a.comp[v]){if(ad&&a.type[v]!="Legend"){continue}var ae=ab.s[v];if(ae==-1){s=true;var d=a.comp[v]=="smps"?F.data.y.smps[ah]:F.getMetadataValue(ah,"x",a.comp[v],true);var g=A(d,a.op[v],a.value[v],a.cases[v]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){Z.push(ah)}}}return s?Z:false};var A=function(j,s,h,g){if(!s){return true}if(F.filterSkipNullValues&&(j==null||j=="")){return true}if(s==">"){return parseFloat(j)-parseFloat(h)>0}else{if(s==">="){return parseFloat(j)-parseFloat(h)>0||parseFloat(j)-parseFloat(h)==0}else{if(s=="<"){return parseFloat(j)-parseFloat(h)<0}else{if(s=="<="){return parseFloat(j)-parseFloat(h)<0||parseFloat(j)-parseFloat(h)==0}else{if(s=="between"){return(parseFloat(j)-parseFloat(h[0])>0||parseFloat(j)-parseFloat(h[0])==0)&&(parseFloat(j)-parseFloat(h[1])<0||parseFloat(j)-parseFloat(h[1])==0)}else{if(s=="="||s=="=="){return parseFloat(j)-parseFloat(h)==0}else{if(s=="null"){return j==null}else{if(s=="not null"){return j!=null}else{if(s=="exact"){for(var d=0;d<h.length;d++){if((j+"").toString()==(h[d]+"").toString()){return true}}return false}else{if(s=="like"||s=="not like"){var k=false;if(g){for(var d=0;d<h.length;d++){if((j+"").search(h[d]+"")!=-1||h[d].toString()==j.toString()){k=true;if(s=="like"){break}}}}else{var a=(j+"").toLowerCase();for(var d=0;d<h.length;d++){var p=(h[d]+"").toLowerCase();if(a.search(p)!=-1||a.toString()==p.toString()){k=true;if(s=="like"){break}}}}return s=="like"?k:!k}}}}}}}}}}};var w=function(a){if(!c[a]){c[a]=0}c[a]++};if(this.graphType=="Genome"&&this.filterFeatureBy.comp.length>0){for(var T=0;T<this.filterFeatureBy.comp.length;T++){if(this.filterFeatureBy.comp[T]){for(var S=0;S<this.data.tracks.length;S++){var q=this.data.tracks[S];var e=q.data;for(var R=0;R<e.length;R++){var B=e[R];if(this.filterSkipNullKeys&&!B.hasOwnProperty(this.filterFeatureBy.comp[T])){continue}var K=G(this.filterFeatureBy.comp[T],B,this.featuresProperties);if(!A(K,this.filterFeatureBy.opp[T],this.filterFeatureBy.value[T],this.filterFeatureBy.cases[T])){B.hide=this.filterType=="and"?true:y[S+":"+R]?false:true;P[S+":"+R]=true}else{y[S+":"+R]=true;if(this.filterType=="or"&&P[S+":"+R]){B.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.comp.length>0||this.filterEdgeBy.comp.length)){for(var T=0;T<this.filterNodeBy.comp.length;T++){if(this.filterNodeBy.comp[T]){for(var S=0;S<this.data.nodes.length;S++){if(this.filterSkipNullKeys&&!this.data.nodes[S].hasOwnProperty(this.filterNodeBy.comp[T])){continue}if(this.data.nodes[S].hide){continue}var K=G(this.filterNodeBy.comp[T],this.data.nodes[S],this.nodesProperties);if(!A(K,this.filterNodeBy.op[T],this.filterNodeBy.value[T],this.filterNodeBy.cases[T])){this.data.nodes[S].hide=this.filterType=="and"?true:y[this.data.nodes[S].id]?false:true;P[this.data.nodes[S].id]=true}else{y[this.data.nodes[S].id]=true;if(this.filterType=="or"&&P[this.data.nodes[S].id]){this.data.nodes[S].hide=false}}}}}for(var T=0;T<this.filterEdgeBy.comp.length;T++){if(this.filterEdgeBy.comp[T]){for(var S=0;S<this.data.edges.length;S++){var z=this.data.nodes[this.data.nodeIndices[this.data.edges[S].id1]];var x=this.data.nodes[this.data.nodeIndices[this.data.edges[S].id2]];var D=z.id+":"+x.id;if(this.filterSkipNullKeys&&!this.data.edges[S].hasOwnProperty(this.filterEdgeBy.comp[T])){continue}var K=G(this.filterEdgeBy.comp[T],this.data.edges[S],this.edgesProperties);if(!A(K,this.filterEdgeBy.op[T],this.filterEdgeBy.value[T],this.filterEdgeBy.cases[T])){this.data.edges[S].hide=this.filterType=="and"?true:y[D]?false:true;P[D]=true}else{y[D]=true;if(this.filterType=="or"&&P[D]){this.data.edges[S].hide=false}}if(!this.data.edges[S].hide){w(z.id);w(x.id)}}}}if(this.filterEdgeBy.comp.length>0){for(var T=0;T<this.data.nodes.length;T++){var b=this.data.nodes[T];if(!c[b.id]){b.hide=true}}}}else{if(this.isCreateHistogram&&!H){if(this.filterVarBy.length>0){var X=this.dataStndBy;var U=this.data.y.histogram;console.log("Not implemented Yet")}}else{if(this.graphType=="Scatter2D"&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/correlation|all/)&&!H){if(this.filterVarBy.length>0){console.log("Not implemented Yet")}}else{if(this.filterDataBy.comp.length>0){var N=[];var f=this.filterDataBy;for(var T=0;T<this.varIndices.length;T++){var K=this.varIndices[T];var V=false;for(var S=0;S<this.smpIndices.length;S++){var L=this.smpIndices[S];for(var R=0;R<f.comp.length;R++){var t=this.data.y[f.comp[R]][K][L];var r=f.value[R]=="No Alteration"?[""]:f.value[R];var C=A(t,f.op[R],r,f.cases[R]);if(this.filterType=="and"&&!H){if(C){V=true}else{V=false;break}}else{if(C){V=true;break}}}if(V){break}}if(V){N.push(K)}}if(H){for(var T=0;T<N.length;T++){this.hiddenVars[N[T]]=true}}}else{if(this.filterVarBy.comp.length>0||this.filterSmpBy.comp.length>0){var N=I(H);var Q=M(H);var n=this.isGroupedData&&this.layoutValid?M(H,true):false;delete this.data.bubble;delete this.data.tree;if(H&&N){for(var T=0;T<N.length;T++){this.hiddenVars[N[T]]=true}}else{if(this.filterMode!="remove"&&N){for(var T=0;T<this.hiddenVars.length;T++){this.hiddenVars[T]=true}for(var T=0;T<N.length;T++){this.hiddenVars[N[T]]=false}}else{if(N){this.varIndices=N}}}if(this.isGroupedData&&!E){if(H&&Q){for(var T=0;T<Q.length;T++){this.hiddenGrps[Q[T]]=true}}else{if(Q){this.grpIndices=Q}}}else{if(H&&Q){for(var T=0;T<Q.length;T++){this.hiddenSmps[Q[T]]=true}if(this.graphType.match(/Scatter/)){if(this.axesType=="X"&&this.xAxisIndices.length>1){if(this.hiddenSmps[this.yAxisIndices[0]]){this.hiddenSmps[this.yAxisIndices[0]]=false}}else{if(this.axesType=="Y"&&this.yAxisIndices.length>1){if(this.hiddenSmps[this.xAxisIndices[0]]){this.hiddenSmps[this.xAxisIndices[0]]=false}}}}}else{if(this.filterMode!="remove"&&Q){for(var T=0;T<this.hiddenSmps.length;T++){this.hiddenSMps[T]=true}for(var T=0;T<Q.length;T++){this.hiddenSmps[Q[T]]=false}}else{if(Q){this.smpIndices=Q}}}}if(n&&H){this.hiddenGrpsLayout=[];for(var T=0;T<n.length;T++){this.hiddenGrpsLayout[n[T]]=true}}else{this.hiddenGrpsLayout=false}}else{this.hiddenGrpsLayout=false}}}}}}if(this.layoutComb&&this.layoutParams&&!this.graphType.match(/Scatter/)){this.restoreEmptyCompartments();var m=this.getObjectArray(this.varIndices);var l=this.getObjectArray(this.smpIndices);for(var T=0;T<this.data.l.comp.length;T++){var O=this.layoutParams[T];var K=O.startingVarIndices;var L=O.startingSmpIndices;var W=O.startingGrpIndices;var Y=[];if(K){for(var S=0;S<K.length;S++){if(m.hasOwnProperty(K[S])){Y.push(K[S])}}O.varIndices=Y}Y=[];if(this.isGroupedData){if(W){for(var S=0;S<W.length;S++){if(l.hasOwnProperty(W[S])){Y.push(W[S])}}O.grpIndices=Y}}else{if(L){for(var S=0;S<L.length;S++){if(l.hasOwnProperty(L[S])){Y.push(L[S])}}O.smpIndices=Y}}}}};this.resetFilters=function(f,b){var e=this;var d=function(g){if(b!=null&&e[g].comp.length>0){e[g].comp.splice(b,1);e[g].op.splice(b,1);e[g].value.splice(b,1);e[g].cases.splice(b,1);e[g].type.splice(b,1)}else{e[g].comp=[];e[g].op=[];e[g].value=[];e[g].cases=[];e[g].type=[]}};var a=f?[f]:["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"];this.hiddenLegends={};for(var c=0;c<a.length;c++){d(a[c])}delete this.data.bubble;delete this.data.tree};this.isHidden=function(b,c,a,d){if(this.graphType=="Network"){return false}else{if(this.graphType=="Boxplot"&&!a){if(!this.showBoxplotOriginalData){if(this.hiddenGrps){return this.hiddenVars[b]||this.hiddenGrps[c]}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}else{if(c!=null){if(this.hiddenGrps){return this.hiddenVars[b]||(d?this.hiddenGrps[c]:this.hiddenSmps[c])}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}else{return this.hiddenVars[b]}}}else{if(this.graphType=="Gantt"){return a?this.hiddenLegends[a]:this.hiddenSmps[c]}else{if(this.graphType=="Dotplot"){return a?this.hiddenLegends[a]:(this.hiddenVars[b]||this.hiddenSmps[c])}else{if(this.graphType=="Bar"&&this.is3DPlot){return a?this.hiddenLegends[a]:this.hiddenVars[b]}else{if(a){return this.hiddenLegends[a]}else{if(this.isGroupedData&&this.hiddenGrps){return this.hiddenVars[b]||this.hiddenGrps[c]}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}}}}}}}};CanvasXpress.prototype.initClusterUtils=function(){this.setDendrograms=function(){if(this.smpDendrogramNewick&&(!this.toDoFilter||!this.toDoFilter.hasOwnProperty("sample"))){this.smpDendrogram={};this.parseNewick(this.smpDendrogramNewick,"smpDendrogram")}if(this.varDendrogramNewick&&(!this.toDoFilter||!this.toDoFilter.hasOwnProperty("variable"))){this.varDendrogram={};this.parseNewick(this.varDendrogramNewick,"varDendrogram")}};this.parseNewick=function(a,d){var k=this;var w=0;var b=[];var t={};var c=0;var g=0;var u=0;var p=0;var j=[];var z=0;var A=0;this[d+"NodeId"]=0;var q=a.split(/\s*(;|\(|\)|,|:)\s*/);var l=function(D){var x=[];for(var C=0;C<D.length;C++){x.push(D[C].mid)}return k.mean(x)};var o=function(C){if(C.children){C.depth=g++;z=Math.max(z,C.depth);for(var x=0;x<C.children.length;x++){o(C.children[x]);if(C.children[x].children){C.children[x].mid=l(C.children[x].children)}}g--;p++}else{C.depth=g;u++}};var e=function(C){if(C.children){for(var x=0;x<C.children.length;x++){e(C.children[x]);if(C.children[x].children){C.children[x].len=1+z-C.children[x].depth}}}else{C.len=1+z-C.depth}};for(var y=0;y<q.length;y++){if(!w){var h=q[y];switch(h){case"(":var B={};t.children=[B];b.push(t);t=B;break;case",":if(b.length>0){var B={};b[b.length-1].children.push(B);t=B}else{w++}break;case")":t=b.pop();t.nodeId=this[d+"NodeId"]++;break;case":":break;default:var m=q[y-1];if(m==")"||m=="("||m==","){t.name=h;if(h&&!t.children){var s=d=="smpDendrogram"?this.getSampleIndices(h):this.getVariableIndices(h);if(s==-1){s=parseInt(h);t.name=d=="smpDendrogram"?this.data.y.smps[s]:this.data.y.vars[s];t.idx=s}else{t.idx=s}j.push(t.idx);t.ord=c++;t.mid=t.ord}}else{if(m==":"){t.height=parseFloat(h);A++}}}}else{if(w<3){this.parseNewick("("+a+")",d);return}else{alert(d+"is not in a valid Newick format");this[d]=false;if(d=="varDendrogram"){this.varDendrogramNewick=false}else{this.smpDendrogramNewick=false}return}}}o(t);e(t);t.max=z+1;t.leafs=u;t.useHeight=A==p;t.mid=l(t.children);t.axis=d;this[d]=t;var r={labl:d=="varDendrogram"?"variable":"sample",show:d=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram",data:d=="varDendrogram"?"vars":"smps",indx:d=="varDendrogram"?"varIndices":"smpIndices",strt:d=="varDendrogram"?"varIndicesStart":this.isGroupedData?"grpIndicesStart":"smpIndicesStart"};if(this[r.show]){var f;if(this[r.strt]<0){if(u!=this.data.y[r.data].length){f="Dude! The length of the "+r.labl+" nodes in the dendrogram ("+u+") is different to that one in the data ("+this.data.y[r.data].length+"). This ain't gonna work!";this.logConsole(f);if(this.verbose){this.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{if(u!=this[r.indx].length){f="Ooops! Cannot show dendrogram with "+u+" nodes when only "+this[r.indx].length+" "+r.labl+" are visible.";this.logConsole(f);if(this.verbose){this.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{this[r.indx]=j}}}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}else{if(this[r.strt]<0){this[r.indx]=j}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}};this.writeNewick=function(b){var d="";if(b.children){var a=[];for(var c=0;c<b.children.length;c++){a.push(this.writeNewick(b.children[c]))}if(a.length>0){d="("+a.join(",")+")"}}else{d=b.idx}if(b.height){d+=":"+this.sprintf("%.1f",b.height)}return d};this.euclidianDistance=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=Math.pow(b[c]-a[c],2)}e=Math.sqrt(e)}return e};this.manhattanDistance=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=Math.abs(b[c]-a[c])}}return e};this.maxDistance=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e=Math.max(e,Math.abs(b[c]-a[c]))}}return e};this.classifyKmeansVector=function(f,c){var e=Number.POSITIVE_INFINITY;var a=0;for(var d=0;d<c.length;d++){var b=this[this.distance+"Distance"](f,c[d]);if(b<e){e=b;a=d}}return a};this.addVectors=function(c,b){c=this.filterNumbers(c,true);b=this.filterNumbers(b,true);var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.compareVectors=function(b,a){if(this.isArray(b)&&this.isArray(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.isArray(b[c])&&this.isArray(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.vectorDotProduct=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var d=0;if(b.length==a.length){for(var c=0;c<b.length;c++){d+=b[c]*a[c]}}return d};this.multiplyVectorByValue=function(a,c){a=this.filterNumbers(a,true);for(var b=0;b<a.length;b++){a[b]*=c}return a};this.getCentroid=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.createClusterNode=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a!=null){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.createRandomCentroids=function(c){var b=this;var a=c.slice(0);a.sort(function(){return(Math.round(b.random())-0.5)});return a.slice(0,this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters)};this.createRandomVectors=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(this.random()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.compareVectors(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.imputeDatum=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.getSampleIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.getVariableIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.getDataForClustering=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.imputeDatum(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.imputeDatum(e)}g=a[c]}h[c][b]=g}}}return h};this.cluster=function(){var n=function(){var i=a[s][0].id;var d=a[r][0].id;if(i<0&&d>=0){return true}else{if(i<0&&d<0){return d>i}else{if(i>=0&&d>=0){return i>d}else{return false}}}};var h;var z=this.getDataForClustering();var v=this.getIdsForClustering();var o=[];var e=[];var B=[];var a=[];if(!this.meta.tree){this.meta.tree={}}var u=this.meta.tree;u[this.clusterAxis]=[];for(var y=0;y<z.length;y++){o[y]=[]}o[0][0]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length-1;y++){for(var x=y+1;x<z.length;x++){o[x][x]=Number.POSITIVE_INFINITY;o[y][x]=this[this.distance+"Distance"](z[y],z[x]);o[x][y]=o[y][x]}}for(var y=0;y<z.length;y++){e[y]=0;for(var x=0;x<z.length;x++){if(o[y][e[y]]>o[y][x]){e[y]=x}}}for(var y=0;y<z.length;y++){a[y]=[];a[y][0]=this.createClusterNode(v[y],null,null,0,z[y]);B[y]=1}var b=-1;for(var q=0;q<z.length-1;q++){var s=0;for(var y=0;y<z.length;y++){if(o[y][e[y]]<o[s][e[s]]){s=y}}var r=e[s];if(n()){var c=r;r=s;s=c}var f=a[s][0];var t=a[r][0];var g=this.getCentroid(f.size,f.centroid,t.size,t.centroid);var A=this.createClusterNode(b,f,t,o[s][r],g);a[s].splice(0,0,A);for(var x=0;x<z.length;x++){if(this.linkage=="single"){if(o[s][x]>o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="complete"){if(o[s][x]<o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="average"){o[x][s]=o[s][x]=((B[s]*o[s][x])+(B[r]*o[r][x]))/(B[s]+B[r])}}}}B[s]+=B[r];o[s][s]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length;y++){o[y][r]=o[r][y]=Number.POSITIVE_INFINITY}for(var x=0;x<z.length;x++){if(e[x]==r){e[x]=s}}for(var x=0;x<z.length;x++){for(var w=0;w<z.length;w++){if(o[w][x]<o[w][e[w]]){e[w]=x}}}h=A;u[this.clusterAxis].push([f.id,t.id,h.dist]);b--}return this.writeNewickCluster(h,true)};this.isLeafNode=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.writeNewickCluster=function(k,g,j){var h="";var e="";var f=false;if(this.isLeafNode(k)){f=true;if(isNaN(k.id)){h=this.clusterAxis=="variables"?this.getVariableIndices(k.id):this.getSampleIndices(k.id)}else{h=k.id}}else{var b;var c=this.writeNewickCluster(k.left,g,true);var a=this.writeNewickCluster(k.right,g,false);if(k.mid){for(var d=0;d<k.mid.length;d++){if(g&&k.mid[d].dist){e+=","+k.mid[d].id+":"+k.mid[d].dist}else{e+=","+k.mid[d].id}e+=k.mid[d].id}}h="("+c+e+","+a+")"}if(g&&!f){h+=":"+this.sprintf("%.1f",k.dist)}return h};this.kmeans=function(){var p=this.getDataForClustering();var q=this.createRandomCentroids(p);var m=new Array(p.length);var b=this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters;var n=new Array(b);var s=0;var v=true;while(v){for(var e=0;e<p.length;e++){m[e]=this.classifyKmeansVector(p[e],q)}v=false;for(var c=0;c<b;c++){var l=[];for(var e=0;e<m.length;e++){if(m[e]==c){l.push(p[e])}}if(!l.length){continue}var o=q[c];var u=new Array(o.length);for(var f=0;f<o.length;f++){var h=0;for(var e=0;e<l.length;e++){if(!isNaN(l[e][f])){h+=l[e][f]}}u[f]=h/l.length;if(u[f]!=o[f]){v=true}}q[c]=u;n[c]=l}s++;if(s>this.maxIterations){v=false}}var r=[];for(var e=0;e<b;e++){r[e]={distance:this[this.distance+"Distance"](q[0],q[e]),assign:e}}r=r.sort(function(g,d){return g.distance-d.distance});var a={};for(var e=0;e<r.length;e++){a[r[e].assign]=e}for(var e=0;e<m.length;e++){var t=a[m[e]]+1;if(t>9){m[e]="K"+t}else{m[e]="K-0"+t}}return m}};CanvasXpress.prototype.initSortUtils=function(){this.sortNetworkIndices=function(h){if(this.isTransition()){return}var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.isNumeric(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.setNodeIndices()}this.draw({func:"sortNetworkIndices",par:[h]})};this.sortOncoprint=function(){if(this.isOncoprint){if(this.meta.data.z){var c=["Altered-Vars"];for(var b in this.meta.data.z){if(b.match(/delet/i)){c.unshift(b);break}}for(var b in this.meta.data.z){if(b.match(/ampli/i)){c.unshift(b);break}}this.sortIndices("vars","desc",c)}if(this.meta.data.x){var c=["Altered-Smps"];for(var b in this.meta.data.x){if(b.match(/delet/i)){c.unshift(b);break}}for(var b in this.meta.data.x){if(b.match(/ampli/i)){c.unshift(b);break}}this.sortIndices("smps","desc",c)}}};this.sortIndices=function(d,k,b,c,n,p){var e=this.sortCaseSensitive;var v=function(m,i){if(m==null){m=""}if(i==null){i=""}if(e){return(m.toString()).localeCompare(i.toString())}else{return(m.toString().toLowerCase()).localeCompare(i.toString().toLowerCase())}};var h="";var l;var a=[];var q=this.meta.data;var x=[];for(var s=0;s<this.varIndices.length;s++){x.push(this.varIndices[s])}x.sort(function(m,i){return m-i});var w=[];for(var s=0;s<this.smpIndices.length;s++){w.push(this.smpIndices[s])}w.sort(function(m,i){return m-i});var u=[];if(this.grpIndices&&this.grpIndices.length){for(var s=0;s<this.grpIndices.length;s++){u.push(this.grpIndices[s])}}else{if(this.isGroupedData&&this.data.w){u=this.data.w.grpIdxs}}if(b){b=this.toArray(b)}if(c){c=this.toArray(c)}if(n){n=this.toArray(n)}if(!k){k=this.sortDir}if(b&&d=="vars"){for(var s=0;s<b.length;s++){var f=b[s];a.push(this.data.z[f]);h+=q.z[f].type=="Numeric"?"N":"S"}l="varIndices"}else{if(b&&d=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,k,b,c,n,p);this.isGroupedData=true}for(var s=0;s<b.length;s++){var f=b[s];a.push(this.isGroupedData?this.data.w.factors[f]:this.data.x[f]);h+=q.x[f].type=="Numeric"?"N":"S"}l=this.isGroupedData?"grpIndices":"smpIndices"}else{if(p){if(p=="varIndex"||p=="smpIndex"||p=="grpIndex"){j=p=="grpIndex"?u:p=="smpIndex"?w:x;l=p=="grpIndex"?"grpIndices":p=="smpIndex"?"smpIndices":"varIndices";if(this.sortDir=="ascending"){j=j.sort(function(m,i){return m-i})}else{j=j.sort(function(m,i){return i-m})}this[l]=j;if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l]=this.sortDir=="ascending"?this.layoutParams[s][l].sort(function(m,i){return m-i}):this.layoutParams[s][l].sort(function(m,i){return i-m});this.layoutParams[s].dragged=true}}h="I"}else{var s=c?parseInt(this.getVariableIndices(c[0])):parseInt(this.getSampleIndices(n[0]));a.push(this.data.y[p][s]);h="N"}}else{if(c){for(var s=0;s<c.length;s++){a.push(this.getDataForSmpGrpAtIndex(c[s]-1,x,p));h+="N"}l="varIndices"}else{if(n){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,k,b,c,n,p);this.isGroupedData=true}var y=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:p?this.data.y[p]:this.data.y.data;for(var s=0;s<n.length;s++){var g=n[s]-1;if(!y[g]){g=0}a.push(y[g]);h+="N"}l=this.isGroupedData?"grpIndices":"smpIndices"}else{if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,k,b,c,n,p);this.isGroupedData=true}a.push(this.isGroupedData?this.data.w.smps:d=="vars"?this.data.y.vars:this.data.y.smps);l=this.isGroupedData?"grpIndices":d=="vars"?"varIndices":"smpIndices";h="S"}}}}}var j=l=="grpIndices"?u:l=="smpIndices"?w:x;var r=Number.MAX_VALUE*-1;switch(h){case"I":break;case"S":j.sort(function(m,i){return v(a[0][m],a[0][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"N":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"SS":j.sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"SN":j.sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"NN":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"NS":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"SSS":j.sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"SSN":j.sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"SNS":j.sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"NSS":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"NNN":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"NNS":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"NSN":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"SNN":j.sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break}if(k!="ascending"&&k!="asc"&&h!="I"){j.reverse();if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].reverse();this.layoutParams[s].dragged=true}}}this.sorting=[d,k,b,c,n,p];this[l]=j;if(this.isGroupedData&&l=="grpIndices"&&this.data.w&&this[l].length==this.data.w.grpIdxs.length){this.data.w.grpIdxs=this.cloneObject(j)}};this.sortArray=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.isAsciiArray=function(a){return !this.isNumeric(a)};this.sortObject=function(b){var a=Object.keys(b);if(this.isAsciiArray(a)){if(this.sortCaseSensitive){return a.sort()}else{return a.sort(function(d,c){return d.toLowerCase().localeCompare(c.toLowerCase())})}}else{return a.sort(function(d,c){return d-c})}};this.stringRangeSort=function(d){var c={};var a;for(var b=0;b<d.length;b++){if(d[b].match(/^\d+\-\d+/)){a=d[b].split(/\-/);c[b]=Number(a[0])}else{if(d[b].match(/^\>\d+/)){a=d[b].split(/\>/);c[b]=Number(a[1])+1e-8}else{if(d[b].match(/^\<\d+/)){a=d[b].split(/\</);c[b]=Number(a[1])-1e-8}else{if(d[b].match(/^\d+/)){a=d[b];c[b]=a}else{return d.sort(function(f,e){return f.toLowerCase().localeCompare(e.toLowerCase())})}}}}}d.sort(function(f,e){c[f]-c[e]});return d};this.resetSorting=function(){delete this.sorting};this.radixSort=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n};this.resortData=function(){var c={y:{vars:[],smps:[],data:[]}};var g=[];var h=[];var f=false;var a=this.data.l?true:false;for(var d=0;d<this.varIndices.length;d++){var k=this.varIndices[d];c.y.vars[d]=this.data.y.vars[k];g.push(d)}for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.y.smps[b]=this.data.y.smps[e];h.push(b)}for(var d=0;d<this.varIndices.length;d++){var k=this.varIndices[d];c.y.data[d]=[];for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.y.data[d][b]=this.data.y.data[k][e]}}if(this.data.x){c.x={};for(var d in this.data.x){c.x[d]=[];for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.x[d][b]=this.data.x[d][e]}}}if(this.data.z){c.z={};for(var d in this.data.z){c.z[d]=[];for(var b=0;b<this.varIndices.length;b++){var e=this.varIndices[b];c.z[d][b]=this.data.z[d][e]}}}else{if(c.y.vars.length!=this.data.y.vars.length){c.z={};for(var d=0;d<this.data.y.vars.length;d++){if(!c.y.vars.includes(this.data.y.vars[d])){c.z[this.data.y.vars[d]]=[];for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.z[this.data.y.vars[d]][b]=this.data.y.data[d][e]}}}f="z"}}this.data=c;this.varIndices=g;this.smpIndices=h;this.startingVarIndices=g;this.startingSmpIndices=h;if(f){this.updateMetaData(f)}if(this.isGroupedData){this.isGroupedData=false;this.groupSamples(this.groupingFactors,false,false,false,true)}if(this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){this.segregateVariablesAndOrSamples(this.segregateVariablesBy,this.segregateSamplesBy)}}};CanvasXpress.prototype.initNumeric=function(){this.numeric=function(s,m){var M=function(S){var U=this.length,T;for(T=0;T<U;++T){if(this[T]===S){return T}}return -1};var p=(Array.prototype.indexOf)?Array.prototype.indexOf:M;var a=function a(S){var V,U;function T(W){var X=[];while(typeof W==="object"){X.push(W.length);W=W[0]}return X}if(typeof S==="object"){V=S[0];if(typeof V==="object"){U=V[0];if(typeof U==="object"){return T(S)}return[S.length,V.length]}return[S.length]}return[]};var D=function(W,T,S){if(typeof S==="undefined"){S=0}var X=W[S],U=Array(X),V;if(S===W.length-1){for(V=X-2;V>=0;V-=2){U[V+1]=T;U[V]=T}if(V===-1){U[0]=T}return U}for(V=X-1;V>=0;V--){U[V]=D(W,T,S+1)}return U};var R=function(Z,Y){var S=function(ap,ao){var aj,ah,af,ad,ac,ab,al,an,ak,ai,ag,am,aq,ae;ad=ap.length;ac=ao.length;ab=ao[0].length;al=Array(ad);for(aj=ad-1;aj>=0;aj--){an=Array(ab);ak=ap[aj];for(af=ab-1;af>=0;af--){ai=ak[ac-1]*ao[ac-1][af];for(ah=ac-2;ah>=1;ah-=2){ag=ah-1;ai+=ak[ah]*ao[ah][af]+ak[ag]*ao[ag][af]}if(ah===0){ai+=ak[0]*ao[0][af]}an[af]=ai}al[aj]=an}return al};var V=function(ac,ad,ab){var af=ac.length,ae;for(ae=af-1;ae>0;--ae){ab[ae]=ac[ae][ad];--ae;ab[ae]=ac[ae][ad]}if(ae===0){ab[0]=ac[0][ad]}};var W=function(am,al){var an=V,ab=al.length,ao=Array(ab);var ae=am.length,ad=al[0].length,ac=new Array(ae),aj;var ag=aa;var ai,ah,af,ak;--ab;--ae;for(ai=ae;ai!==-1;--ai){ac[ai]=Array(ad)}--ad;for(ai=ad;ai!==-1;--ai){an(al,ai,ao);for(ah=ae;ah!==-1;--ah){ak=0;aj=am[ah];ac[ah][ai]=ag(aj,ao)}}return ac};var T=function(ab,ag){var af=ab.length,ae=ag.length,ad;var ac=Array(af);for(ad=af-1;ad>=0;ad--){ac[ad]=aa(ab[ad],ag)}return ac};var U=function(ai,ah){var aq,ap,ao,al,ak,aj,aw,au,at,af,an,ag,ad,ar,ae,ac,ab,am,av;al=ai.length;ak=ah[0].length;aw=Array(ak);for(ao=ak-1;ao>=0;ao--){af=ai[al-1]*ah[al-1][ao];for(ap=al-2;ap>=1;ap-=2){an=ap-1;af+=ai[ap]*ah[ap][ao]+ai[an]*ah[an][ao]}if(ap===0){af+=ai[0]*ah[0][ao]}aw[ao]=af}return aw};var aa=function(ab,ag){var ad,af=ab.length,ae,ac=ab[af-1]*ag[af-1];for(ad=af-2;ad>=1;ad-=2){ae=ad-1;ac+=ab[ad]*ag[ad]+ab[ae]*ag[ae]}if(ad===0){ac+=ab[0]*ag[0]}return ac};var X=a;switch(X(Z).length*1000+X(Y).length){case 2002:if(Y.length<10){return S(Z,Y)}else{return W(Z,Y)}case 2001:return T(Z,Y);case 1002:return U(Z,Y);case 1001:return aa(Z,Y);case 1000:return mulVS(Z,Y);case 1:return mulSV(Z,Y);case 0:return Z*Y;default:throw new Error("dot only works on vectors and matrices")}};var k=function(X){var V,W,U,Y=X.length,S=Array(Y),T;for(V=Y-1;V>=0;V--){T=Array(Y);W=V+2;for(U=Y-1;U>=W;U-=2){T[U]=0;T[U-1]=0}if(U>V){T[U]=0}T[V]=X[V];for(U=V-1;U>=1;U-=2){T[U]=0;T[U-1]=0}if(U===0){T[0]=0}S[V]=T}return S};var C=function(S){var V=Math.min(S.length,S[0].length),U,T=Array(V);for(U=V-1;U>=1;--U){T[U]=S[U][U];--U;T[U]=S[U][U]}if(U===0){T[0]=S[0][0]}return T};var G=function(S){return k(D([S],1))};var I=function(S,Y,V,T,W){if(T===V.length-1){W(S,Y);return}var U,X=V[T];for(U=X-1;U>=0;U--){I(typeof S==="object"?S[U]:S,typeof Y==="object"?Y[U]:Y,V,T+1,W)}};var L=function(S,Z,W,T,X){if(T===W.length-1){return X(S,Z)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;--V){U[V]=L(typeof S==="object"?S[V]:S,typeof Z==="object"?Z[V]:Z,W,T+1,X)}return U};var A=function(S,V,T,W){if(T===V.length-1){W(S);return}var U,X=V[T];for(U=X-1;U>=0;U--){A(S[U],V,T+1,W)}};var H=function(S,W,T,X){if(T===W.length-1){return X(S)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;V--){U[V]=H(S[V],W,T+1,X)}return U};var d=function(){var X=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag[af]}return ae};var Y=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac+ag[af]}return ae};var Z=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag}return ae};var S=arguments.length,V,ab=arguments[0],aa;var T=X,W=Z,U=Y;for(V=1;V!==S;++V){aa=arguments[V];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,W)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab+=aa}}}return ab};var x=function(){var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag[af]}return ae};var T=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac-ag[af]}return ae};var V=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag}return ae};var U=arguments.length,Y,ab=arguments[0],aa;var W=S,Z=V,X=T;for(Y=1;Y!==U;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,W)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,X)}else{ab-=aa}}}return ab};var c=function(){var Z=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag[af]}return ae};var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac*ag[af]}return ae};var ab=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag}return ae};var S=arguments.length,V,Y=arguments[0],X;var T=Z,W=ab,U=aa;for(V=1;V!==S;++V){X=arguments[V];if(typeof Y==="object"){if(typeof X==="object"){Y=L(Y,X,a(Y),0,T)}else{Y=L(Y,X,a(Y),0,W)}}else{if(typeof X==="object"){Y=L(Y,X,a(X),0,U)}else{Y*=X}}}return Y};var K=function(){var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag[af]}return ae};var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac/ag[af]}return ae};var S=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag}return ae};var T=arguments.length,W,Z=arguments[0],Y;var U=aa,X=S,V=ab;for(W=1;W!==T;++W){Y=arguments[W];if(typeof Z==="object"){if(typeof Y==="object"){Z=L(Z,Y,a(Z),0,U)}else{Z=L(Z,Y,a(Z),0,X)}}else{if(typeof Y==="object"){Z=L(Z,Y,a(Y),0,V)}else{Z/=Y}}}return Z};var h=function(){var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag[af]}return ae};var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac!==ag[af]}return ae};var T=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag}return ae};var U=arguments.length,X,aa=arguments[0],Z;var V=ab,Y=T,W=S;for(X=1;X!==U;++X){Z=arguments[X];if(typeof aa==="object"){if(typeof Z==="object"){aa=L(aa,Z,a(aa),0,V)}else{aa=L(aa,Z,a(aa),0,Y)}}else{if(typeof Z==="object"){aa=L(aa,Z,a(Z),0,W)}else{aa=aa!==Z}}}return aa};var u=function(){var T=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var U=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var X=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,Y,ab=arguments[0],aa;var V=T,Z=X,W=U;for(Y=1;Y!==S;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,V)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,W)}else{ab=u(ab,aa)}}}return ab};var w=function(){var X=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah[ag])}return af};var Y=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad,ah[ag])}return af};var aa=function(ad,ah){var ae=ad.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah)}return af};var S=arguments.length,V,ab=arguments[0],Z;var T=X,W=aa,U=Y;for(V=1;V!==S;++V){Z=arguments[V];if(typeof ab==="object"){if(typeof Z==="object"){ab=L(ab,Z,a(ab),0,T)}else{ab=L(ab,Z,a(ab),0,W)}}else{if(typeof Z==="object"){ab=L(ab,Z,a(Z),0,U)}else{ab=w(ab,Z)}}}return ab};var O=function(){var V=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var X=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var Z=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,W,ab=arguments[0],aa;var T=V,Y=Z,U=X;for(W=1;W!==S;++W){aa=arguments[W];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,Y)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab=O(ab,aa)}}}return ab};var q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=-(V[aa])}return Z};if(typeof S!=="object"){return -(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var v=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=(V[aa])}return Z};if(typeof S!=="object"){return(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var y=function(S){var X=function(Y){var Z=Y.length;var ab,aa=Array(Z);var V=Math.abs;for(ab=Z-1;ab!==-1;--ab){aa[ab]=V(Y[ab])}return aa};if(typeof S!=="object"){return y(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var f=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.cos;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return f(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var Q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.exp;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return Q(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var o=function(T){var S=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.log;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof T!=="object"){return o(T)}var W;var U=S;var X=a(T);return H(T,X,0,U)};var r=function(S){var X=function(V){var Z=V.length;var ab,aa=Array(Z);var Y=Math.sin;for(ab=Z-1;ab!==-1;--ab){aa[ab]=Y(V[ab])}return aa};if(typeof S!=="object"){return r(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var F=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.sqrt;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return F(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var J=function(S,Y,V){var X=function(aa){var ae=aa.length;var ad,ac;var ab=0;for(ad=ae-1;ad!==-1;--ad){ac=aa[ad];ab+=ac*ac}return ab};var U=0;if(typeof S!=="object"){T=S;U+=T*T;return U}if(typeof Y==="undefined"){Y=a(S)}if(typeof V==="undefined"){V=0}if(V===Y.length-1){return X(S)}var T;var Z=S.length,W;for(W=Z-1;W!==-1;--W){T=arguments.callee(S[W]);U+=T*T}return U};var t=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=T[W];X[Y-1]=V[W];--W;X=Z[W];X[Y]=T[W];X[Y-1]=V[W]}if(W===0){X=Z[0];X[Y]=T[0];X[Y-1]=V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=V[W];--W;Z[W][0]=V[W]}if(W===0){Z[0][0]=V[0]}}return Z};var n=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W];--W;X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W]}if(W===0){X=Z[0];X[Y]=-T[0];X[Y-1]=-V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=-V[W];--W;Z[W][0]=-V[W]}if(W===0){Z[0][0]=-V[0]}}return Z};var l=function(S){return Math.sqrt(J(S))};var j=function(S,W,V){var T=a(S);function U(X,Z){var ab,Y=W[Z],ac=V[Z]-Y,aa=Array(ac);if(Z===T.length-1){for(ab=ac;ab>=0;ab--){aa[ab]=X[ab+Y]}return aa}for(ab=ac;ab>=0;ab--){aa[ab]=U(X[ab+Y],Z+1)}return aa}return U(S,0)};var e=function(S,X,W,V){var T=a(S);function U(Y,ad,aa){var ab,Z=X[aa],ac=W[aa]-Z;if(aa===T.length-1){for(ab=ac;ab>=0;ab--){Y[ab+Z]=ad[ab]}}for(ab=ac;ab>=0;ab--){U(Y[ab+Z],ad[ab],aa+1)}}U(S,V,0);return S};var i=function(T,ab,aa){var W=ab.length,V=aa.length;var Y,X;var S=Array(W),Z,U;for(Y=W-1;Y!==-1;--Y){S[Y]=Array(V);Z=S[Y];U=T[ab[Y]];for(X=V-1;X!==-1;--X){Z[X]=U[aa[X]]}}return S};var B=function(Z,Y){if(typeof Z==="number"||typeof Y==="number"){return c(Z,Y)}var ac=a(Z),aa=a(Y);if(ac.length!==1||aa.length!==1){throw new Error("numeric: tensor product is only defined for vectors")}var U=ac[0],T=aa[0],S=Array(U),ab,W,V,X;for(W=U-1;W>=0;W--){ab=Array(T);X=Z[W];for(V=T-1;V>=3;--V){ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V]}while(V>=0){ab[V]=X*Y[V];--V}S[W]=ab}return S};var g=function g(S,T){this.x=S;this.y=T};g.prototype={};g.prototype.add=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(d(S.x,T.x),d(S.y,T.y))}return new g(d(S.x,T.x),S.y)}if(T.y){return new g(d(S.x,T.x),T.y)}return new g(d(S.x,T.x))};g.prototype.sub=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(S.x,T.x),x(S.y,T.y))}return new g(x(S.x,T.x),S.y)}if(T.y){return new g(x(S.x,T.x),q(T.y))}return new g(x(S.x,T.x))};g.prototype.mul=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(c(S.x,T.x),c(S.y,T.y)),d(c(S.x,T.y),c(S.y,T.x)))}return new g(c(S.x,T.x),c(S.y,T.x))}if(T.y){return new g(c(S.x,T.x),c(S.x,T.y))}return new g(c(S.x,T.x))};g.prototype.reciprocal=function(){if(this.y){var S=d(c(this.x,this.x),c(this.y,this.y));return new g(K(this.x,S),K(q(this.y),S))}return new g(K(1,this.x))};g.prototype.div=function(S){if(!(S instanceof g)){S=new g(S)}if(S.y){return this.mul(S.reciprocal())}if(this.y){return new g(K(this.x,S.x),K(this.y,S.x))}return new g(K(this.x,S.x))};g.prototype.dot=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(R(S.x,T.x),R(S.y,T.y)),d(R(S.x,T.y),R(S.y,T.x)))}return new g(R(S.x,T.x),R(S.y,T.x))}if(T.y){return new g(R(S.x,T.x),R(S.x,T.y))}return new g(R(S.x,T.x))};g.prototype.transpose=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),T(U))}return new g(T(S))};g.prototype.transjugate=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),n(U))}return new g(T(S))};g.prototype.exp=function(){var S=this;var T=Q(S.x);if(S.y){return new g(c(f(S.y),T),c(r(S.y),T))}return new g(T)};g.prototype.conj=function(){var S=this;if(S.y){return new g(S.x,q(S.y))}return new g(S.x)};g.prototype.neg=function(){var S=this;if(S.y){return new g(q(S.x),q(S.y))}return new g(q(S.x))};g.prototype.sin=function(){var S=this;if(S.y){return S.exp().sub(S.neg().exp()).div(new g(0,2))}return new g(r(S.x))};g.prototype.cos=function(){var S=this;if(S.y){return S.exp().add(S.neg().exp()).div(2)}return new g(f(S.x))};g.prototype.abs=function(){var S=this;if(S.y){return new g(F(d(c(S.x,S.x),c(S.y,S.y))))}return new g(y(S.x))};g.prototype.log=function(){var S=this;if(S.y){var T=new g(u(S.y,S.x)),U=S.abs();return new g(o(U.x),T.x)}return new g(o(S.x))};g.prototype.norm2=function(){var S=this;if(S.y){var T=J;return Math.sqrt(T(S.x)+T(S.y))}return l(S.x)};g.prototype.get=function(V){var S=this.x,X=this.y,T=0,U,W=V.length;if(X){while(T<W){U=V[T];S=S[U];X=X[U];T++}return new g(S,X)}while(T<W){U=V[T];S=S[U];T++}return new g(S)};g.prototype.set=function(U,aa){var Y=this.x,W=this.y,T=0,Z,S=U.length,X=aa.x,V=aa.y;if(S===0){if(V){this.y=V}else{if(W){this.y=undefined}}this.x=Y;return this}if(V){if(W){}else{W=D(a(Y),0);this.y=W}while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;W[Z]=V;return this}if(W){while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;if(X instanceof Array){W[Z]=D(a(X),0)}else{W[Z]=0}return this}while(T<S-1){Z=U[T];Y=Y[Z];T++}Z=U[T];Y[Z]=X;return this};g.prototype.getRows=function(W,U){var Z=U-W+1,T;var X=Array(Z),V,S=this.x,Y=this.y;for(T=W;T<=U;T++){X[T-W]=S[T]}if(Y){V=Array(Z);for(T=W;T<=U;T++){V[T-W]=Y[T]}return new g(X,V)}return new g(X)};g.prototype.setRows=function(X,V,T){var U;var Y=this.x,W=this.y,S=T.x,Z=T.y;for(U=X;U<=V;U++){Y[U]=S[U-X]}if(Z){if(!W){W=D(a(Y),0);this.y=W}for(U=X;U<=V;U++){W[U]=Z[U-X]}}else{if(W){for(U=X;U<=V;U++){W[U]=D([S[U-X].length],0)}}}return this};g.prototype.getRow=function(T){var S=this.x,U=this.y;if(U){return new g(S[T],U[T])}return new g(S[T])};g.prototype.setRow=function(U,T){var W=this.x,V=this.y,S=T.x,X=T.y;W[U]=S;if(X){if(!V){V=D(a(W),0);this.y=V}V[U]=X}else{if(V){V=D([S.length],0)}}return this};g.prototype.getBlock=function(W,V){var T=this.x,U=this.y,S=j;if(U){return new g(S(T,W,V),S(U,W,V))}return new g(S(T,W,V))};g.prototype.setBlock=function(Z,Y,U){if(!(U instanceof g)){U=new g(U)}var T=this.x,X=this.y,S=e,W=U.x,V=U.y;if(V){if(!X){this.y=D(a(this),0);X=this.y}S(T,Z,Y,W);S(X,Z,Y,V);return this}S(T,Z,Y,W);if(X){S(X,Z,Y,D(a(W),0))}};g.rep=function(U,T){if(!(T instanceof g)){T=new g(T)}var S=T.x,W=T.y,V=D;if(W){return new g(V(U,S),V(U,W))}return new g(V(U,S))};g.diag=function(T){if(!(T instanceof g)){T=new g(T)}var S=T.x,U=T.y;if(U){return new g(k(S),k(U))}return new g(k(S))};g.eig=function(){if(this.y){throw new Error("eig: not implemented for complex matrices.")}return N(this.x)};g.identity=function(S){return new g(G(S))};g.prototype.getDiag=function(){var S=this.x,T=this.y;if(T){return new g(C(S),C(T))}return new g(C(S))};var P=function(S){var T=v(S);var U=S[0]>=0?1:-1;var V=U*l(S);T[0]+=V;var W=l(T);if(W===0){throw new Error("eig: internal error")}return K(T,W)};var b=function(ac){var ag=a(ac);if(ag.length!==2||ag[0]!==ag[1]){throw new Error("numeric: toUpperHessenberg() only works on square matrices")}var X=ag[0],aa,Z,Y,ad,af,V=v(ac),U,S,ae,T,ab=G(X),W;for(Z=0;Z<X-2;Z++){ad=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){ad[aa-Z-1]=V[aa][Z]}if(l(ad)>0){af=P(ad);U=j(V,[Z+1,Z],[X-1,X-1]);S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){ae=V[aa];T=S[aa-Z-1];for(Y=Z;Y<X;Y++){ae[Y]-=2*T[Y-Z]}}U=j(V,[0,Z+1],[X-1,X-1]);S=B(R(U,af),af);for(aa=0;aa<X;aa++){ae=V[aa];T=S[aa];for(Y=Z+1;Y<X;Y++){ae[Y]-=2*T[Y-Z-1]}}U=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){U[aa-Z-1]=ab[aa]}S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){W=ab[aa];T=S[aa-Z-1];for(Y=0;Y<X;Y++){W[Y]-=2*T[Y]}}}}return{H:V,Q:ab}};var z=function(af,V){if(typeof V==="undefined"){V=10000}af=v(af);var ah=v(af);var ai=a(af),am=ai[0],ae,ag,av,au,at,ar,X,S,W,aa=G(am),ac,ab,al,ak,aj,aq,ao,an,ap;if(am<3){return{Q:aa,B:[[0,am-1]]}}var aw=2.220446049250313e-16;for(ap=0;ap<V;ap++){for(ao=0;ao<am-1;ao++){if(Math.abs(af[ao+1][ao])<aw*(Math.abs(af[ao][ao])+Math.abs(af[ao+1][ao+1]))){var Z=z(j(af,[0,0],[ao,ao]),V);var Y=z(j(af,[ao+1,ao+1],[am-1,am-1]),V);al=Array(ao+1);for(aq=0;aq<=ao;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=ao;aq++){aa[aq]=ak[aq]}al=Array(am-ao-1);for(aq=ao+1;aq<am;aq++){al[aq-ao-1]=aa[aq]}ak=R(Y.Q,al);for(aq=ao+1;aq<am;aq++){aa[aq]=ak[aq-ao-1]}return{Q:aa,B:Z.B.concat(d(Y.B,ao+1))}}}av=af[am-2][am-2];au=af[am-2][am-1];at=af[am-1][am-2];ar=af[am-1][am-1];S=av+ar;X=(av*ar-au*at);W=j(af,[0,0],[2,2]);if(S*S>=4*X){var U,T;U=0.5*(S+Math.sqrt(S*S-4*X));T=0.5*(S-Math.sqrt(S*S-4*X));W=d(x(R(W,W),c(W,U+T)),k(D([3],U*T)))}else{W=d(x(R(W,W),c(W,S)),k(D([3],X)))}ae=[W[0][0],W[1][0],W[2][0]];ag=P(ae);al=[af[0],af[1],af[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<am;an++){ab[an]-=2*aj[an]}}al=j(af,[0,0],[am-1,2]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<3;an++){ab[an]-=2*aj[an]}}al=[aa[0],aa[1],aa[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ac=aa[aq];aj=ak[aq];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}var ad;for(ao=0;ao<am-2;ao++){for(an=ao;an<=ao+1;an++){if(Math.abs(af[an+1][an])<aw*(Math.abs(af[an][an])+Math.abs(af[an+1][an+1]))){var Z=z(j(af,[0,0],[an,an]),V);var Y=z(j(af,[an+1,an+1],[am-1,am-1]),V);al=Array(an+1);for(aq=0;aq<=an;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=an;aq++){aa[aq]=ak[aq]}al=Array(am-an-1);for(aq=an+1;aq<am;aq++){al[aq-an-1]=aa[aq]}ak=R(Y.Q,al);for(aq=an+1;aq<am;aq++){aa[aq]=ak[aq-an-1]}return{Q:aa,B:Z.B.concat(d(Y.B,an+1))}}}ad=Math.min(am-1,ao+3);ae=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){ae[aq-ao-1]=af[aq][ao]}ag=P(ae);al=j(af,[ao+1,ao],[ad,am-1]);ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ab=af[aq];aj=ak[aq-ao-1];for(an=ao;an<am;an++){ab[an]-=2*aj[an-ao]}}al=j(af,[0,ao+1],[am-1,ad]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=ao+1;an<=ad;an++){ab[an]-=2*aj[an-ao-1]}}al=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){al[aq-ao-1]=aa[aq]}ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ac=aa[aq];aj=ak[aq-ao-1];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}}}throw new Error("numeric: eigenvalue iteration does not converge -- increase maxiter?")};var N=function(ak,W){var T=b(ak);var X=z(T.H,W);var an=ak.length,at,ap,ar=false,ai=X.B,ae=R(X.Q,R(T.H,t(X.Q)));var Z=new g(R(X.Q,T.Q)),ag;var ao=ai.length,aq;var ax,aw,av,au,V,U,S,ad,ac,aj,ah,ab,aa;var ay=Math.sqrt;for(ap=0;ap<ao;ap++){at=ai[ap][0];if(at===ai[ap][1]){}else{aq=at+1;ax=ae[at][at];aw=ae[at][aq];av=ae[aq][at];au=ae[aq][aq];if(aw===0&&av===0){continue}V=-ax-au;U=ax*au-aw*av;S=V*V-4*U;if(S>=0){if(V<0){ad=-0.5*(V-ay(S))}else{ad=-0.5*(V+ay(S))}ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab);aj=(ax-ad)/ab;ah=aw/ab}else{aa=ay(aa);aj=av/aa;ah=(au-ad)/aa}ag=new g([[ah,-aj],[aj,ah]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}else{ad=-0.5*V;ac=0.5*ay(-S);ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab+ac*ac);aj=(ax-ad)/ab;ah=aw/ab;ad=0;ac/=ab}else{aa=ay(aa+ac*ac);aj=av/aa;ah=(au-ad)/aa;ad=ac/aa;ac=0}ag=new g([[ah,-aj],[aj,ah]],[[ad,ac],[ac,-ad]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}}}var Y=Z.dot(ak).dot(Z.transjugate()),an=ak.length,af=g.identity(an);for(aq=0;aq<an;aq++){if(aq>0){for(ap=aq-1;ap>=0;ap--){var al=Y.get([ap,ap]),am=Y.get([aq,aq]);if(h(al.x,am.x)||h(al.y,am.y)){ad=Y.getRow(ap).getBlock([ap],[aq-1]);ac=af.getRow(aq).getBlock([ap],[aq-1]);af.set([aq,ap],(Y.get([ap,aq]).neg().sub(ad.dot(ac))).div(al.sub(am)))}else{af.setRow(aq,af.getRow(ap));continue}}}}for(aq=0;aq<an;aq++){ad=af.getRow(aq);af.setRow(aq,ad.div(ad.norm2()))}af=af.transpose();af=Z.transjugate().dot(af);return{lambda:Y.getDiag(),E:af}};var E=function(ab){var ag=a(ab),ah=Math.abs,V=ag[0],U=ag[1];var T=v(ab),ad,aa;var ac=G(V),S,af;var Z,Y,W,ab;for(Y=0;Y<U;++Y){var X=-1;var ae=-1;for(Z=Y;Z!==V;++Z){W=ah(T[Z][Y]);if(W>ae){X=Z;ae=W}}aa=T[X];T[X]=T[Y];T[Y]=aa;af=ac[X];ac[X]=ac[Y];ac[Y]=af;ab=aa[Y];for(W=Y;W!==U;++W){aa[W]/=ab}for(W=U-1;W!==-1;--W){af[W]/=ab}for(Z=V-1;Z!==-1;--Z){if(Z!==Y){ad=T[Z];S=ac[Z];ab=ad[Y];for(W=Y+1;W!==U;++W){ad[W]-=aa[W]*ab}for(W=U-1;W>0;--W){S[W]-=af[W]*ab;--W;S[W]-=af[W]*ab}if(W===0){S[0]-=af[0]*ab}}}}return ac};switch(s){case"inv":return E(m);case"eig":return N(m)}}};CanvasXpress.prototype.initjLouvain=function(){this.jLouvain=function(){var l=-1;var k=1e-7;var i;var y;var s={};var a;function d(C){var B={};C.forEach(function(E,D){B[E]=true});return Object.keys(B)}function x(D){var C=[];for(var B in D){if(D.hasOwnProperty(B)){C.push(D[B])}}return C}function v(E,C){var B=E._assoc_mat[C]?Object.keys(E._assoc_mat[C]):[];var D=0;B.forEach(function(F,G){var H=E._assoc_mat[C][F]||1;if(C==F){H*=2}D+=H});return D}function f(D,C){if(typeof D._assoc_mat[C]=="undefined"){return[]}var B=Object.keys(D._assoc_mat[C]);return B}function g(D,C,B){return D._assoc_mat[C]?D._assoc_mat[C][B]:undefined}function A(C){var B=0;C.edges.forEach(function(D){B+=D.weight});return B}function c(D,C){e(D,C);var B=D.edges.map(function(E){return E.id1+"_"+E.id2}).indexOf(C.id1+"_"+C.id2);if(B!=-1){D.edges[B].weight=C.weight}else{D.edges.push(C)}}function z(B){var C={};B.forEach(function(E,D){E.weight=E.weight||1;C[E.id1]=C[E.id1]||{};C[E.id1][E.id2]=E.weight;C[E.id2]=C[E.id2]||{};C[E.id2][E.id1]=E.weight});return C}function e(C,B){C._assoc_mat[B.id1]=C._assoc_mat[B.id1]||{};C._assoc_mat[B.id1][B.id2]=B.weight;C._assoc_mat[B.id2]=C._assoc_mat[B.id2]||{};C._assoc_mat[B.id2][B.id1]=B.weight}function t(D){if(D==null||typeof(D)!="object"){return D}var B=D.constructor();for(var C in D){B[C]=t(D[C])}return B}function p(D,B,C){B.nodes_to_com={};B.total_weight=0;B.internals={};B.degrees={};B.gdegrees={};B.loops={};B.total_weight=A(D);if(typeof C=="undefined"){D.nodes.forEach(function(G,E){B.nodes_to_com[G]=E;var F=v(D,G);if(F<0){throw"Bad graph type, use positive weights!"}B.degrees[E]=F;B.gdegrees[G]=F;B.loops[G]=g(D,G,G)||0;B.internals[E]=B.loops[G]})}else{D.nodes.forEach(function(I,G){var E=C[I];B.nodes_to_com[I]=E;var H=v(D,I);B.degrees[E]=(B.degrees[E]||0)+H;B.gdegrees[I]=H;var J=0;var F=f(D,I);F.forEach(function(K,L){var M=D._assoc_mat[I][K];if(M<=0){throw"Bad graph type, use positive weights"}if(C[K]==E){if(K==I){J+=M}else{J+=M/2}}});B.internals[E]=(B.internals[E]||0)+J})}}function o(C){var E=C.total_weight;var B=0;var D=d(x(C.nodes_to_com));D.forEach(function(F,G){var I=C.internals[F]||0;var H=C.degrees[F]||0;if(E>0){B=B+I/E-Math.pow((H/(2*E)),2)}});return B}function m(D,E,B){var C={};var F=f(E,D);F.forEach(function(G,H){if(G!=D){var I=E._assoc_mat[D][G]||1;var J=B.nodes_to_com[G];C[J]=(C[J]||0)+I}});return C}function u(D,C,E,B){B.nodes_to_com[D]=+C;B.degrees[C]=(B.degrees[C]||0)+(B.gdegrees[D]||0);B.internals[C]=(B.internals[C]||0)+E+(B.loops[D]||0)}function r(D,C,E,B){B.degrees[C]=((B.degrees[C]||0)-(B.gdegrees[D]||0));B.internals[C]=((B.internals[C]||0)-E-(B.loops[D]||0));B.nodes_to_com[D]=-1}function j(F){var D=0;var B=t(F);var C={};var E=Object.keys(F);E.forEach(function(H){var I=F[H];var G=typeof C[I]=="undefined"?-1:C[I];if(G==-1){C[I]=D;G=D;D=D+1}B[H]=G});return B}function b(F,B){var D=true,G=0,E=o(B),C=E;while(D&&G!=l){E=C;D=false;G+=1;F.nodes.forEach(function(J,I){var M=B.nodes_to_com[J];var O=(B.gdegrees[J]||0)/(B.total_weight*2);var L=m(J,F,B);r(J,M,(L[M]||0),B);var N=M;var H=0;var K=Object.keys(L);K.forEach(function(P,Q){var R=L[P]-(B.degrees[P]||0)*O;if(R>H){H=R;N=P}});u(J,N,L[N]||0,B);if(N!=M){D=true}});C=o(B);if(C-E<k){break}}}function h(C,G){var B={nodes:[],edges:[],_assoc_mat:{}};var D,F;var E=x(C);B.nodes=B.nodes.concat(d(E));G.edges.forEach(function(I,H){F=I.weight||1;var L=C[I.id1];var J=C[I.id2];D=(g(B,L,J)||0);var K=(D+F);c(B,{source:L,target:J,weight:K})});return B}function w(C,E){var B=t(C[0]);for(var D=1;D<E+1;D++){Object.keys(B).forEach(function(H,G){var I=H;var F=B[H];B[I]=C[D][F]})}return B}function n(J,D){if(J.edges.length==0){var C={};J.nodes.forEach(function(L,K){C[L]=L});return C}var F={};p(s,F,D);var H=o(F);var I=[];b(s,F);var B=o(F);var G=j(F.nodes_to_com);I.push(G);H=B;var E=h(G,s);p(E,F);while(true){b(E,F);B=o(F);if(B-H<k){break}G=j(F.nodes_to_com);I.push(G);H=B;E=h(G,E);p(E,F)}return I}var q=function(){var B={};var C=n(s,a);return w(C,C.length-1)};q.nodes=function(B){if(arguments.length>0){i=B}return q};q.edges=function(C){if(typeof i=="undefined"){throw"Please provide the graph nodes first!"}if(arguments.length>0){y=C;var B=z(C);s={nodes:i,edges:y,_assoc_mat:B}}return q};q.partition_init=function(B){if(arguments.length>0){a=B}return q};return q}};CanvasXpress.prototype.initMathUtils=function(){this.isNaN=function(a){return isNaN(a)?true:a==Number.POSITIVE_INFINITY?true:a==Number.NEGATIVE_INFINITY?true:false};this.isInteger=function(a){return !isNaN(a)&&(function(b){return(b|0)===b})(parseFloat(a))};this.isFinite=function(a){if(this.isArray(a)){for(var b=0;b<a.length;b++){if(!isFinite(a[b])){return false}}return true}else{return isFinite(a)}};this.getPolar=function(b,e,d,c){return{x:b+d*Math.cos(c*Math.PI/180),y:e+d*Math.sin(c*Math.PI/180)}};this.triCube=function(a){return(a=1-a*a*a)*a*a};this.degreesToArcLength=function(b,a){return b*a};this.radiansToArcLength=function(a,b){return(a*Math.PI*b)/180};this.arcLengthToDegrees=function(b,a){return(a*180)/(b*Math.PI)};this.arcLengthToRadians=function(b,a){return a/b};this.radians=function(a){return a*Math.PI/180};this.degrees=function(a){return a*180/Math.PI};this.getAngle=function(e,g,c,f,d){var b=(Math.atan2(f-g,c-e)*180/Math.PI)%360;if(!d){d=0}while(b<d){b+=360}while(b>=(d+360)){b-=360}return b};this.getRadians=function(d,f,c,e){var b=Math.atan2(e-f,c-d);if(b<0){b+=(2*Math.PI)}return b};this.rotatePoint=function(c,h,b,g,d){var f=Math.cos(d)*(c-b)-Math.sin(d)*(h-g)+b;var e=Math.sin(d)*(c-b)+Math.cos(d)*(h-g)+g;return[f,e]};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.lineMidPoint=function(b,d,a,c){return[(b+a)/2,(d+c)/2]};this.getCoordinateAtDistance=function(b,i,a,h,g){var c=a-b;var j=h-i;var e=Math.sqrt(Math.pow(c,2)+Math.pow(j,2));var f=g/e;return[b+(c*f),i+(j*f)]};this.parallelLinePoints=function(s,d,q,b,o){var i=q-s;var h=b-d;var p=this.lineLength(s,d,q,b);var w=i/p;var u=h/p;var t=-u;var r=w;var c=s+o*t;var f=d+o*r;var a=s-o*t;var e=d-o*r;var j=q+o*t;var n=b+o*r;var g=q-o*t;var k=b-o*r;return[c,f,a,e,j,n,g,k]};this.perpendicularLinePoints=function(b,o,a,j,c,g){var h=this.lineLength(b,o,a,j);var p=this.lineMidPoint(b,o,a,j);if(!c){c=h*g}var s=a-p[0];var r=j-p[1];var e=s/h;var d=r/h;var q=-d;var n=e;var k=p[0]+c*q;var i=p[1]+c*n;return[k,i]};this.shortenLine=function(f,o,c,n,r,i,t,a){if(this.isNumeric([f,o,c,n,r,i])){if(t.match(/bezier/i)){if(t.match(/beziery/i)){return n>o?[f,o+r,c,n-i]:[f,o-r,c,n+i]}else{return c>f?[f+r,o,c-i,n]:[f-r,o,c+i,n]}}else{if(t.match(/quadratic/i)){var k=this.lineLength(f,o,c,n);var d=this.perpendicularLinePoints(f,o,c,n,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(a))*(a>0?-1:1));var b=this.traceQuadraticCurve(f,o,d[0],d[1],c,n,r/k,true);var p=this.traceQuadraticCurve(c,n,d[0],d[1],f,o,i/k,true);return[b[1][0],b[1][1],p[1][0],p[1][1]]}else{if(t.match(/curved/i)){return[f,o,c,n]}else{var g=Math.atan2(n-o,c-f);var h=Math.cos(g);var l=Math.sin(g);var j=this.lineLength(f,o,c,n);if(j){while(j<(r+i)){r/=1.1;i/=1.1}f+=h*r;o+=l*r;c-=h*i;n-=l*i}return[f,o,c,n]}}}}};this.traceArc=function(c,b,a,l,g,d){if(l>g){var j=l;l=g;g=j}var k=[];var h=((Math.PI*2)-(g-l))/16;k.push([a*Math.cos(l)+c,a*Math.sin(l)+b]);for(var f=0;f<16;f++){l-=h;k.push([a*Math.cos(l)+c,a*Math.sin(l)+b])}return d?k.reverse():k};this.traceArc1=function(c,b,a,n,h,d){if(n>h){var k=n;n=h;h=k}var l=[];var g=Math.PI;var i=h-n;var f=32;var j=i/f;if(j<1e-9){l.push([a*Math.cos(n)+c,a*Math.sin(n)+b])}else{l.push([a*Math.cos(n)+c,a*Math.sin(n)+b]);n+=j;while(n<h){l.push([a*Math.cos(n)+c,a*Math.sin(n)+b]);n+=j}l.push([a*Math.cos(h)+c,a*Math.sin(h)+b])}return d?l:l.reverse()};this.traceQuadraticCurve=function(l,k,e,c,j,h,b,f){var n=[];b=Math.max(0.01,b);var a=function(i,r,q,p){var o=1-i;return o*o*r+2*o*i*q+i*i*p};var d=function(i){return[a(i,l,e,j),a(i,k,c,h)]};for(var g=0;g<=1;g+=b){n.push(d(g))}return f?n:n.reverse()};this.traceBezierCurve=function(j,h,c,b,l,k,g,f,a,d){var n=[];a=Math.max(0.01,a);for(var e=0;e<=1;e+=a){n.push(this.deCasteljau([[j,h],[c,b],[l,k],[g,f]],e))}return d?n:n.reverse()};this.splineControlPoint=function(e,n,d,l,c,k){var o=Math.sqrt(Math.pow(d-e,2)+Math.pow(l-n,2));var h=Math.sqrt(Math.pow(c-d,2)+Math.pow(k-l,2));var g=this.tension*o/(o+h);var f=this.tension-g;var b=d+g*(e-c);var a=l+g*(n-k);var j=d-f*(e-c);var i=l-f*(n-k);return[b,a,j,i]};this.spline=function(e,g){var f=[];var a=e[0];var d=e[1];for(var c=0;c<a.length;c++){f.push(a[c]);f.push(d[c])}var b=this.curvePoints(f,g);a=[];d=[];while(b.length){a.push(b.shift());d.push(b.shift())}return[a,d]};this.curvePoints=function(z,k){var a=[];var A=[];var f=this.tension;var g=this.tensionSegments;k=k?k:false;a=z.slice(0);if(k){a.unshift(z[z.length-1]);a.unshift(z[z.length-2]);a.unshift(z[z.length-1]);a.unshift(z[z.length-2]);a.push(z[0]);a.push(z[1])}else{a.unshift(z[1]);a.unshift(z[0]);a.push(z[z.length-2]);a.push(z[z.length-1])}var e,d,c,o,b,l,q,p,n,h,r;for(var w=2;w<(a.length-4);w+=2){for(var u=0;u<=g;u++){c=(a[w+2]-a[w-2])*f;o=(a[w+4]-a[w])*f;b=(a[w+3]-a[w-1])*f;l=(a[w+5]-a[w+1])*f;r=u/g;q=2*Math.pow(r,3)-3*Math.pow(r,2)+1;p=-(2*Math.pow(r,3))+3*Math.pow(r,2);n=Math.pow(r,3)-2*Math.pow(r,2)+r;h=Math.pow(r,3)-Math.pow(r,2);e=q*a[w]+p*a[w+2]+n*c+h*o;d=q*a[w+1]+p*a[w+3]+n*b+h*l;A.push(e);A.push(d)}}return A};this.hullControlPoints=function(f){var c=this;var f;var e=[];var g=0;var b,a;var d=function(q,o,n){var l=function(s,r){var u=r[0]-s[0];var t=r[1]-s[1];return Math.sqrt(u*u+t*t)};var p=l(q,o);var k=l(o,n);var h=c.tension*p/(p+k);var j=[((q[0]-n[0])*h)+o[0],((q[1]-n[1])*h)+o[1]];var i=[o[0]-((q[0]-n[0])*h),(o[1]-(q[1]-n[1])*h)];return[j,i]};for(b=0;b<f.length-2;b++){e.push.apply(e,d(f[b],f[b+1],f[b+2]))}e.push.apply(e,d(f[b],f[b+1],f[0]));e.push.apply(e,d(f[b+1],f[0],f[1]));return e};this.expandPolygon=function(q,y){var b=function(i){var d=Math.sqrt(i.x*i.x+i.y*i.y);return{x:i.x/d,y:i.y/d}};var t=function(d,i){return{x:d.x*i,y:d.y*i}};var l=function(i,d){return i.x*d.x+i.y*d.y};var c=function(d){return{x:d.y,y:-d.x}};var z=function(d){return{x:-d.y,y:d.x}};var x=function(H,G){var i=H[1].x-H[0].x;var F=G[0].x-G[1].x;var D=G[0].x-H[0].x;var d=H[1].y-H[0].y;var E=G[0].y-G[1].y;var p=G[0].y-H[0].y;var I=(F*p-E*D)/(d*F-i*E);return{x:H[0].x+I*(H[1].x-H[0].x),y:H[0].y+I*(H[1].y-H[0].y)}};var B=function(d){return l(c({x:d[1].x-d[0].x,y:d[1].y-d[0].y}),{x:d[2].x-d[1].x,y:d[2].y-d[1].y})>=0};var u=[];var g=B(q)?z:c;for(var w=0;w<q.length;++w){var k=q[(w>0)?w-1:q.length-1];var h=q[w];var f=q[(w<q.length-1)?w+1:0];var n={x:h[0]-k[0],y:h[1]-k[1]};var A={x:f[0]-h[0],y:f[1]-h[1]};var o=t(b(g(n)),y);var C=t(b(g(A)),y);var s={x:k[0]+o.x,y:k[1]+o.y};var j={x:h[0]+o.x,y:h[1]+o.y};var e={x:h[0]+C.x,y:h[1]+C.y};var r={x:f[0]+C.x,y:f[1]+C.y};var a=x([s,j],[e,r]);u.push([a.x,a.y])}return u};this.enlargePolygon=function(t,z,r){var f=function(i,e,d){return((d.x-i.x)*(e.y-i.y))-((e.x-i.x)*(d.y-i.y))};var A=function(p,s){var e=p.vrs[s];var d=p.vrs[(s+1)%p.vrs.length];var i=p.vrs[(s+p.vrs.length-1)%p.vrs.length];return(f(i,d,e)<0)?true:false};var h=function(s){var i=s.v2.x-s.v1.x;var d=s.v2.y-s.v1.y;var p=Math.sqrt(i*i+d*d);return{x:-d/p,y:i/p}};var q=function(d){var i=h(d);return{x:-i.x,y:-i.y}};var b=function(L){var p={vrs:L};var K=[];var F=(L.length>0)?L[0].x:undefined;var E=(L.length>0)?L[0].y:undefined;var s=F;var d=E;for(var G=0;G<p.vrs.length;G++){L[G].label=String(G);L[G].isReflex=A(p,G);var H={v1:L[G],v2:L[(G+1)%L.length],pol:p,index:G};H.outwardNormal=q(H);H.inwardNormal=h(H);K.push(H);var J=L[G].x;var I=L[G].y;F=Math.min(J,F);E=Math.min(I,E);s=Math.max(J,s);d=Math.max(I,d)}p.edges=K;p.minX=F;p.minY=E;p.maxX=s;p.maxY=d;p.closed=true;return p};var l=function(p,i,d){return{v1:{x:p.v1.x+i,y:p.v1.y+d},v2:{x:p.v2.x+i,y:p.v2.y+d}}};var D=function(p,e){var s=(e.v2.y-e.v1.y)*(p.v2.x-p.v1.x)-(e.v2.x-e.v1.x)*(p.v2.y-p.v1.y);if(s==0){return null}var i=((e.v2.x-e.v1.x)*(p.v1.y-e.v1.y)-(e.v2.y-e.v1.y)*(p.v1.x-e.v1.x))/s;var d=((p.v2.x-p.v1.x)*(p.v1.y-e.v1.y)-(p.v2.y-p.v1.y)*(p.v1.x-e.v1.x))/s;if(i<0||d<0||i>1||d>1){return null}return{x:p.v1.x+i*(p.v2.x-p.v1.x),y:p.v1.y+i*(p.v2.y-p.v1.y)}};var c=function(M,F,d,L,G,s){var K=Math.PI*2;var I=Math.atan2(L.y-F.y,L.x-F.x);var E=Math.atan2(G.y-F.y,G.x-F.x);if(I<0){I+=K}if(E<0){E+=K}var H=((I>E)?(I-E):(I+K-E));var e=((s)?-H:K-H)/r;M.push(L);for(var p=1;p<r;++p){var H=I+e*p;var J={x:F.x+Math.cos(H)*d,y:F.y+Math.sin(H)*d};M.push(J)}M.push(G)};var u=[];var w=[];for(var x=0;x<t.length;x++){w.push({x:t[x][0],y:t[x][1]})}var j=b(w);for(var x=0;x<j.edges.length;x++){var y=j.edges[x];var o=y.outwardNormal.x*z;var k=y.outwardNormal.y*z;u.push(l(y,o,k))}w=[];for(var x=0;x<u.length;x++){var g=u[x];var C=u[(x+u.length-1)%u.length];var n=D(C,g);if(n){w.push(n)}else{var B=j.edges[x].v1;c(w,B,z,C.v2,g.v1,false)}}var a=[];for(var x=0;x<w.length;x++){a.push([w[x].x,w[x].y])}return a};this.cleanVals=function(c){var b=[];if(c.length>1){var f=0;for(var a=0;a<c.length;a++){var e=this.getNumberDecimals(c[a]);if(e<8){f=Math.max(f,e)}}for(var a=0;a<c.length;a++){b.push(Number(this.formatNumber(c[a],f)))}}else{if(c.length>0){return c}}return b};this.getNumberDecimals=function(a){a=this.approxNumber(a).toString();return a.indexOf(".")>=0?Math.min(Number(a.length-(a.indexOf(".")+1)),20):0};this.sample=function(c,g){if(c){if(!g||g<=0){g=c.length}var e,b;var f=c.slice(0);var d=c.length;var a=d-g;while(d-->a){b=Math.floor((d+1)*this.random());e=f[b];f[b]=f[d];f[d]=e}return f.slice(a)}else{return[]}};this.rep=function(b,c){var f=b.length;var a=[];if(!Array.isArray(b)){return this.rep([b],c)}else{if(!Array.isArray(c)){for(var e=0;e<c;e++){for(var d=0;d<f;d++){a[d+e*f]=b[d]}}}else{if(c.length!=b.length){alert("If x and k are both arrays in 'rep', then they need to have the same length.")}for(var e=0;e<f;e++){for(var d=0;d<c[e];d++){a.push(b[e])}}}}return a};this.seq=function(g,c,f,a){var d=[];if(g!=null&&c!=null&&(a||f)){var b=c<g;if(c<g){var e=g;g=c;c=e}if(a){a=Math.abs(a);f=(c-g)/(a-1)}else{f=Math.abs(f)}if(f){while(c>=g){d.push(g);g+=f}}if(a){d[a-1]=c}else{if(d[d.length-1]<c){d.push(c)}}}return b?d.reverse():d};this.frac=function(h){var g=0;var d=1+1/(h-1);var b=1/(h-1);for(var c=-1,a=0|Math.max(0,Math.ceil((d-g)/b)),f=new Array(a);++c<a;){f[c]=g+c*b}f.splice(h);return f};this.runif=function(f,e,b){var c=[];if(e!=null&&b!=null){for(var d=0;d<f;d++){c.push(this.randomBetween(e,b))}}else{for(var d=0;d<f;d++){c.push(this.random())}}return c};this.qnorm=function(h){h=parseFloat(h);var j=0.42;var w=2.50662823884;var t=-18.61500062529;var s=41.39119773534;var n=-25.44106049637;var d=-8.4735109309;var c=23.08336743743;var b=-21.06224101826;var a=3.13082909833;var l=-2.78718931138;var k=-2.29796479134;var i=4.85014127135;var g=2.32121276858;var x=3.54388924762;var u=1.63706781897;var f=h-0.5;var e,o;if(Math.abs(f)<=j){e=f*f;o=f*(((n*e+s)*e+t)*e+w)/((((a*e+b)*e+c)*e+d)*e+1)}else{e=h;if(f>0){e=1-h}if(e>0){e=Math.sqrt(-Math.log(e));o=(((g*e+i)*e+k)*e+l)/((u*e+x)*e+1);if(f<0){o=-o}}else{o=0}}return o};this.dnorm=function(k,c,n,f){if(this.isArray(k)){var h=[];for(var g=0;g<k.length;g++){h[g]=this.dnorm(k[g],c,n,f)}return h}else{var j=function(d,i){if(Number.isNaN(d)||Number.isNaN(i)){return d+i}if(!Number.isFinite(d)||!Number.isFinite(i)){return Number.POSITIVE_INFINITY}return d*Math.pow(2,i)};if(c==null){c=0}if(n==null){n=1}var e=Math.abs((k-c)/n);if(e>=2*Number.MAX_VALUE){return f?Number.NEGATIVE_INFINITY:0}if(f){return -(0.9189385332046728+0.5*e*e+Mat.log(n))}if(e<5){return 0.3989422804014327*Math.exp(-0.5*e*e)/n}if(e>Math.sqrt(-2*0.6931471805599453*(Math.log2(Number.MIN_VALUE)+1-18))){return 0}var b=j(Math.round(j(e,16)),-16);var a=e-b;return 0.3989422804014327/n*(Math.exp(-0.5*b*b)*Math.exp((-0.5*a-b)*a))}};this.diff=function(a){var c=[];for(var b=1;b<a.length;b++){c.push(a[b]-a[b-1])}return this.cleanVals(c)};this.rnorm=function(h,b,d){var g=this;var c=[];if(b==null){b=0}if(d==null){d=1}d=Math.sqrt(d);var f=function(){var j,i;var a=2;while(a>1){j=g.random()*2-1;i=g.random()*2-1;a=j*j+i*i}return b+d*j*Math.sqrt(-2*Math.log(a)/a)};for(var e=0;e<h;e++){c.push(f())}return c};this.qt=function(d,i){var b;var c=function(k){return k>0?1:k<0?-1:0};function j(a){var l=1;for(var k=2;k<=a;k=k+1){l=l*k}return l}function f(C,D,y){var a;if(C<1/2){a=-f(1-C,0,1)}else{var A=Math.sqrt(-2*Math.log(1-C));var x=-0.322232431088;var w=-0.342242088547;var t=-0.020423121024;var s=-0.0000453642210148;var r=0.099348462606;var p=0.58858157049;var o=0.531103462366;var l=0.10353775285;var k=0.0038560700634;var n=x+A*(-1+A*(w+A*(t+s*A)));var B=r+A*(p+A*(o+A*(l+k*A)));a=A+n/B}return D+a*y}var e=function(o,w){var l;var s=Math.ceil(w/2);var x=1-o;if(x!=0.5){var n=Math.sqrt(2*Math.pow((1-2*x),2)/(1-Math.pow((1-2*x),2)));for(var u=0;u<20;u=u+1){var y=0;for(var t=0;t<=s-1;t=t+1){y=y+j(2*t)/Math.pow(2,(2*t))/Math.pow(j(t),2)*Math.pow((1+Math.pow(n,2)/(2*s)),-t)}var r=1/Math.sqrt(1/(2*s)*(Math.pow((y/(1-2*x)),2)-1));n=r}if(x>0.5){l=-n}else{l=n}}else{l=0}return l};function g(l,A){var s=l>0.5?2*(1-l):2*l;var n=l>0.5?false:true;var B=1/(A-0.5);var u=48/(B*B);var r=((20700*B/u-98)*B-16)*B+96.36;var o=((94.5/(u+r)-3)/u+1)*Math.sqrt(B*Math.PI/2)*A;var w=s*o;var t=Math.pow(w,(2/A));if(t>0.05+B){w=f(s*0.5,0,1);t=w*w;if(A<5){r=r+0.3*(A-4.5)*(w+0.6)}r=r+(((0.05*o*w-5)*w-7)*w-2)*w+u;t=(((((0.4*t+6.3)*t+36)*t+94.5)/r-t-3)/u+1)*w;t=B*t*t;if(t>0.002){t=Math.exp(t)-1}else{t=t+0.5*t*t}}else{t=((1/(((A+6)/(A*t)-0.089*o-0.822)*(A+2)*3)+0.5/(A+4))*t-1)*(A+1)/(A+2)+1/t}var k=Math.sqrt(A*t);return n?-k:k}if(i==1){b=Math.tan(Math.PI*(d-1/2))}else{if(i==2){var h=4*d*(1-d);b=(2*d-1)*Math.sqrt(2/h)}else{if(i==4){var h=4*d*(1-d);b=Math.cos(1/3*Math.acos(Math.sqrt(h)))/Math.sqrt(h);b=c(d-1/2)*2*Math.sqrt(b-1)}else{if(i%2==0){b=e(d,i)}else{b=g(d,i)}}}}return b};this.percentile2=function(a,f){if(a.length===0){return 0}if(typeof f!=="number"){throw new TypeError("p must be a number")}if(f<=0){return a[0]}if(f>=1){return a[a.length-1]}var c=a.length*f;var b=Math.floor(c);var d=b+1;var e=c%1;if(d>=a.length){return a[b]}else{return a[b]*(1-e)+a[d]*e}};this.percentRank=function(a,c){if(typeof c!=="number"){throw new TypeError("v must be a number")}for(var d=0,b=a.length;d<b;d++){if(c<=a[d]){while(d<b&&c===a[d]){d++}if(d===0){return 0}if(c!==a[d-1]){d+=(c-a[d-1])/(a[d]-a[d-1])}return d/b}}return 1};this.percentile=function(d,a,e){var b=a-d;if(b==0){return 50}var c=e-d;return c*100/b};this.percentile3=function(b){if(b.length===0){return b}var e=this.min(b);var a=this.max(b);var c=a-e;var f=[];for(var d=0;d<b.length;d++){var g=b[d]-e;f.push(g/c)}return f};this.rank=function(a){var c=[];for(var b=0;b<a.length;b++){c.push(b)}c.sort(function(e,d){return a[e]-a[d]});return c};this.rank2=function(b){var d=b.slice().sort(function(g,f){return g-f});var e=b.slice().map(function(f){return d.indexOf(f)+1});var c={};e.map(function(f){c[f]=c[f]?c[f]++:1});var a=e.map(function(f){return f/c[f]});return a};this.min=function(b,a,f){if(this.isArray(b)){var e=Number.POSITIVE_INFINITY;if(this.isArray(b[0])){for(var d=0;d<b.length;d++){for(var c=0;c<b[d].length;c++){if(this.isNumber(b[d][c],true)){e=Math.min(e,b[d][c])}}}}else{b=this.cleanArray(b,a,f);for(var d=0;d<b.length;d++){if(this.isNumber(b[d],true)){e=Math.min(e,b[d])}}}return e}else{return this.Min(b,a)}};this.max=function(c,b,f){if(this.isArray(c)){var a=Number.NEGATIVE_INFINITY;if(this.isArray(c[0])){for(var e=0;e<c.length;e++){for(var d=0;d<c[e].length;d++){if(this.isNumber(c[e][d],true)){a=Math.max(a,c[e][d])}}}}else{c=this.cleanArray(c,b,f);for(var e=0;e<c.length;e++){if(this.isNumber(c[e],true)){a=Math.max(a,c[e])}}}return a}else{return this.Max(c,b)}};this.sum=function(b,a,g,e,f){b=this.cleanArray(b,a,g);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]}}else{if(f){if(b[c]<0){d+=b[c]}}else{d+=b[c]}}}return d};this.sumSquared=function(b,a,f,e){b=this.cleanArray(b,a,f);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]*b[c]}}else{d+=b[c]*b[c]}}return d};this.sumSquaredError=function(b,a,g){b=this.cleanArray(b,a,g);var c=this.mean(b);var f=0;for(var e=0;e<b.length;e++){var d=b[e]-c;f+=d*d}return f};this.mean=function(b,a,e){b=this.cleanArray(b,a,e);var c=0;var f=0;for(var d=0;d<b.length;d++){if(!this.isNaN(b[d])){c+=Number(b[d]);f++}}if(f>0){c/=f}return c};this.range=function(c,b,f){c=this.cleanArray(c,b,f);var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<c.length;d++){e=Math.min(c[d],e);a=Math.max(c[d],a)}return e==a&&e==0?[-0.5,0.5]:e==a?[Number(e)-0.5,Number(a)+0.5]:[Number(e),Number(a)]};this.range2D=function(b){var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<b.length;d++){for(var c=0;c<b[d].length;c++){if(this.isNumber(b[d][c],true)){e=Math.min(b[d][c],e);a=Math.max(b[d][c],a)}}}return e==a&&e==0?[-0.5,0.5]:e==a?[Number(e)-0.5,Number(a)+0.5]:[Number(e),Number(a)]};this.median=function(b,a,f){b=this.cleanArray(b,a,f);var e=[];var d=[];var g=0;e[0]=Number.NaN;e[1]=Number.NaN;for(var c=0;c<b.length;c++){d.push(b[c]);g++}if(g>0){e[1]=g;d.sort(function(i,h){return i-h});if(g%2){e[0]=d[parseInt(g/2)]}else{e[0]=(d[parseInt((g-1)/2)]+d[g/2])/2}}return e};this.Abs=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(Math.abs(b[c]))}return d};this.square=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(b[c]*b[c])}return d};this.subtractArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]-e)}return b};this.addArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]+e)}return b};this.replaceArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(e)}return b};this.nextSeed=function(a){if(this.randomMethod=="numericalRecipes"){return(a*9301+49297)%233280}else{a=((a+2127912214)+(a<<12))&4294967295;a=((a^3345072700)^(a>>>19))&4294967295;a=((a+374761393)+(a<<5))&4294967295;a=((a+3550635116)^(a<<9))&4294967295;a=((a+4251993797)+(a<<3))&4294967295;a=((a^3042594569)^(a>>>16))&4294967295;return a}};this.random=function(a){if(this.pseudoRandom){this.randomSeed=this.nextSeed(a||this.randomSeed);return this.randomMethod=="numericalRecipes"?this.randomSeed/233280:(this.randomSeed&268435455)/268435456;return}else{return Math.random()}};this.randomBetween=function(c,a,b){return(this.random(b)*(a-c+1))+c};this.randomInt=function(a){return parseInt(this.random(a))};this.randomIntBetween=function(c,a,b){return Math.floor(this.random(b)*(a-c+1))+c};this.sumarizeErrorData=function(b,a,c){if(this.errorBarsType=="standardErrorMean"){return this.meanStandardErrorN(b,a,c)}else{if(this.errorBarsType=="confidenceInterval95"){return this.mean95ConfidenceIntervalN(b,a,c)}else{return this.meanStandardDeviationN(b,a,c)}}};this.meanStandardErrorN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],Math.sqrt(c[1])/Math.sqrt(c[2]),c[2]]};this.mean95ConfidenceIntervalN=function(b,a,d){var c=this.meanStandardErrorN(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],c[1]*1.96,c[2]]};this.meanStandardDeviationN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],Math.sqrt(c[1]),c[2]]};this.fivenum=function(a){a.sort(function(h,d){return h-d});var g=a.length;var b=Math.floor((g+3)/2)/2;var f=[1,b,(g+1)/2,g+1-b,g];var e=[];for(var c=0;c<f.length;c++){e.push((a[Math.floor(f[c])-1]+a[Math.ceil(f[c])-1])*0.5)}return e};this.boxplot=function(a,d,c){if(a.length>0){a=this.cleanArray(a,d,c);var e=[];var l=[];var b=this.fivenum(a);var g=this.boxplotHingeFunction=="summary"?this.quantile(a,[0.25,0.75]):[b[1],b[3]];var w=b[0];var r=g[0];var p=b[2];var t=b[2];var o=g[1];var u=b[4];var k=o-r;var q=r-this.boxplotCoef*k;var n=o+this.boxplotCoef*k;var j=(b[3]-b[1])/Math.sqrt(a.length);for(var s=0;s<a.length;s++){if(a[s]<q||a[s]>n){e.push(a[s])}else{l.push(a[s])}}if(e.length>0){var f=this.range(l)}var h=[t-1.58*j,t+1.58*j];return[t,r,p,o,w,u,e,a.length,h]}return[Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN]};this.quantileBin=function(b,a){if(a<b[0]){return 0}else{if(a>=b[0]&&a<b[1]){return 1}else{if(a>=b[1]&&a<b[2]){return 2}else{if(a>=b[2]){return 3}}}}};this.quantile=function(b,c){b=this.cleanArray(b);b=b.slice().sort(function(f,e){return f-e});var d=b.length-1;var a=!c||!c.length?[0.25,0.5,0.75]:c;return a.map(function(j){if(j===0){return b[0]}else{if(j===1){return b[d]}else{var f=1+j*d;var i=Math.floor(f);var g=f-i;var e=b[i-1];return g===0?e:e+g*(b[i]-e)}}})};this.iqr=function(a){var b=this.quantile(a,[0.25,0.75]);return b[1]-b[0]};this.variance=function(e,f,c,a){e=this.cleanArray(e,f,c);var b=e.length;if(b<1){return a?[Number.NaN,Number.NaN,Number.NaN]:Number.NaN}else{if(b==1){return a?[e[0],0,1]:0}else{var j=this.mean(e);var h=0;var d=b;while(--d>=0){if(!this.isNaN(e[d])){var g=e[d]-j;h+=g*g}}if(a){return this.standardDeviationType=="unbiased"?[j,h/(b-1),b]:[j,h/b,b]}else{return this.standardDeviationType=="unbiased"?h/(b-1):h/b}}}};this.deviation=function(b,a,f){b=this.cleanArray(b,a,f);var g=b.length;if(g<1){return[Number.NaN]}else{if(g==1){return[0]}else{var c=this.mean(b);var d=[];for(var e=0;e<g;e++){if(!this.isNaN(b[e])){d[e]=b[e]-c}else{d[e]=NaN}}return d}}};this.standardDeviation=function(b,a,d){var c=this.variance(b,a,d);if(this.isNaN(c)){return c}return Math.sqrt(c)};this.standardError=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return c[1]}return Math.sqrt(c[1])/Math.sqrt(c[2])};this.meanSquaredError=function(b,a,c){b=this.cleanArray(b,a,c);return this.sumSquaredError(this.sumSquaredError(b,a,c))/b.length};this.confidenceInterval95=function(c,b,d){var a=this.standardError(c,b,d);if(this.isNaN(a)){return a}return a*1.96};this.covariance=function(h,g,e,c){var f=this.cleanArrays(h,g,e,c);h=f[0];g=f[1];var l=0;var a=[];var b=0;var k=this.mean(h);var j=this.mean(g);for(var d=0;d<h.length;d++){a[d]=(h[d]-k)*(g[d]-j);l+=a[d];b++}if(b>0){return l/(this.standardDeviationType=="unbiased"?b-1:b)}else{return NaN}};this.correlation=function(c,b,a,e,d){if(d&&d=="spearman"){return this.correlationSpearman(c,b,a,e)}else{return this.correlationPearson(c,b,a,e)}};this.correlationSpearman=function(o,l,h,f){var k=this.cleanArrays(o,l,h,f);o=k[0];l=k[1];var a=o.length;var b=0;var e=this.rank2(o);var c=this.rank2(l);for(var g=0;g<o.length;g++){var j=e[g]-c[g];b+=j*j}return 1-(6*b/(a*(a*a-1)))};this.correlationPearson=function(c,b,a,d){return this.covariance(c,b,a,d)/this.standardDeviation(c,a,d)/this.standardDeviation(b,a,d)};this.regression=function(k,j,g,b,c,l){var f=[];var h=this.cleanArrays(k,j,g,b);k=h[0];j=h[1];for(var e=0;e<k.length;e++){if(!this.isNaN(k[e])&&!this.isNaN(j[e])){f.push([k[e],j[e]])}}var a=this.regressionType+"Regression";var d=this[a](f);return[d.params[0],d.params[1],d.r2,d.confidence]};this.slope=function(b,d,a,c){return d!=c?(a-b)/(c-d):0};this.intercept=function(a,c,b){return c-(a*b)};this.slopeIntercept=function(b,e,a,d){var c=this.slope(b,e,a,d);return[c,this.intercept(b,e,c)]};this.normalize=function(f){var e=this.standardDeviationType;this.standardDeviationType="biased";for(var c=0;c<f.length;c++){var a=this.meanStandardDeviationN(f[c]);for(var b=0;b<f[c].length;b++){f[c][b]=(f[c][b]-a[0])/a[1]}}this.standardDeviationType=e;return f};this.coefficientDetermination=function(h,f){var c=0;for(var b=0;b<h.length;b++){c+=h[b][1]}var j=c/h.length;var e=0;for(var b=0;b<h.length;b++){var g=h[b][1]-j;e+=g*g}var d=0;for(var b=0;b<h.length;b++){var a=h[b][1]-f[b][1];d+=a*a}return 1-(d/e)};this.gaussianElimination=function(o,b){var p=o;var a=o.length-1;var c=[b];for(var g=0;g<a;g++){var h=g;for(var e=g+1;e<a;e++){if(Math.abs(p[g][e])>Math.abs(p[g][h])){h=e}}for(var d=g;d<a+1;d++){var f=p[d][g];p[d][g]=p[d][h];p[d][h]=f}for(var e=g+1;e<a;e++){for(var d=a;d>=g;d--){p[d][e]-=(p[d][g]*p[g][e])/p[g][g]}}}for(var e=a-1;e>=0;e--){var l=0;for(var d=e+1;d<a;d++){l+=p[d][e]*c[d]}c[e]=(p[a][e]-l)/p[e][e]}return c};this.linearRegression=function(x){var c=[0,0,0,0,0];var s=0;var q=Number.NEGATIVE_INFINITY;var l=Number.POSITIVE_INFINITY;for(var k=0;k<x.length;k++){s++;q=Math.max(q,x[k][0]);l=Math.min(l,x[k][0]);c[0]+=x[k][0];c[1]+=x[k][1];c[2]+=x[k][0]*x[k][0];c[3]+=x[k][0]*x[k][1];c[4]+=x[k][1]*x[k][1]}var h=((s*c[2])-(c[0]*c[0]));var a=((s*c[3])-(c[0]*c[1]));var b=h===0?0:a/h;var u=(c[1]/s)-((b*c[0])/s);var p=[];for(var k=0;k<x.length;k++){p[k]=[x[k][0],(x[k][0]*b)+u]}var e=[];var j=0;var w=0;var r=c[0]/s;var g=Math.max(k-2,1);var d=this.seq(l,q,(q-l)/10);var f=this.tinv(1-this.confidenceLevel,g,true);for(var o=0;o<k;o++){j+=Math.pow(x[o][1]-p[o][1],2);w+=Math.pow(x[o][0]-r,2)}j=Math.sqrt(j/g);for(var o=0;o<d.length;o++){var y=-f*j*Math.sqrt((1/k)+Math.pow(d[o]-r,2)/w);var t=b*d[o]+u;e.push([d[o],t+y,t-y,y])}return{predict:p,params:[b,u],r2:this.coefficientDetermination(x,p),confidence:e,string:u===0?"y = "+b+"x":"y = "+b+"x + "+u}};this.exponentialRegression=function(g){var f=[0,0,0,0,0,0];for(var i=0;i<g.length;i++){f[0]+=g[i][0];f[1]+=g[i][1];f[2]+=g[i][0]*g[i][0]*g[i][1];f[3]+=g[i][1]*Math.log(g[i][1]);f[4]+=g[i][0]*g[i][1]*Math.log(g[i][1]);f[5]+=g[i][0]*g[i][1]}var h=((f[1]*f[2])-(f[5]*f[5]));var d=Math.exp(((f[2]*f[3])-(f[5]*f[4]))/h);var c=((f[1]*f[4])-(f[5]*f[3]))/h;var e=[];for(var i=0;i<g.length;i++){e[i]=[g[i][0],d*Math.exp(c*g[i][0])]}return{predict:e,params:[d,c],r2:this.coefficientDetermination(g,e),confidence:false,string:"y = "+d+"e^("+c+"x)"}};this.logarithmicRegression=function(h){var g=[0,0,0,0];var d=h.length;for(var i=0;i<d;i++){g[0]+=Math.log(h[i][0]);g[1]+=h[i][1]*Math.log(h[i][0]);g[2]+=h[i][1];g[3]+=Math.pow(Math.log(h[i][0]),2)}const c=((d*g[1])-(g[2]*g[0]))/((d*g[3])-(g[0]*g[0]));const e=(g[2]-(c*g[0]))/d;var f=[];for(var i=0;i<h.length;i++){f[i]=[h[i][0],e+(c*Math.log(h[i][0]))]}return{predict:f,params:[e,c],r2:this.coefficientDetermination(h,f),confidence:false,string:"y = "+e+" + "+c+"ln(x)"}};this.powerRegression=function(h){var g=[0,0,0,0,0];var d=h.length;for(var i=0;i<d;i++){g[0]+=Math.log(h[i][0]);g[1]+=Math.log(h[i][1])*Math.log(h[i][0]);g[2]+=Math.log(h[i][1]);g[3]+=Math.pow(Math.log(h[i][0]),2)}var c=((d*g[1])-(g[0]*g[2]))/((d*g[3])-Math.pow(g[0],2));var e=Math.exp(((g[2]-(c*g[0]))/d));var f=[];for(var i=0;i<h.length;i++){f[i]=[h[i][0],e*Math.pow(h[i][0],c)]}return{predict:f,params:[e,c],r2:this.coefficientDetermination(h,f),confidence:false,string:"y = "+e+"x^"+c}};this.polynomialRegression=function(p){this.regressionOrder=2;var g=[];var t=[];var x=0;var w=0;var s=p.length;var h=this.regressionOrder+1;for(var q=0;q<h;q++){for(var f=0;f<s;f++){x+=Math.pow(p[f][0],q)*p[f][1]}g.push(x);x=0;var u=[];for(var o=0;o<h;o++){for(var f=0;f<s;f++){w+=Math.pow(p[f][0],(q+o))}u.push(w);w=0}t.push(u)}t.push(g);var e=this.gaussianElimination(t,h);var y=[];for(var d=0;d<p.length;d++){y[d]=[p[d][0],e[0]+(e[1]*Math.pow(p[d][0],e[2]))]}var r="y = ";for(var q=e.length-1;q>=0;q--){if(q>1){r+=e[q]+"x^"+q+" + "}else{if(q===1){r+=e[q]+"x + "}else{r+=e[q]}}}return{predict:y,params:e.reverse(),r2:this.coefficientDetermination(p,y),confidence:false,string:r}};this.commonElementsInArrays=function(c,b){var a=[];var e={};for(var d=0;d<c.length;d++){e[c[d]]=true}for(var d=0;d<b.length;d++){if(e[b[d]]){a.push(b[d])}}return a};this.errorEllipse=function(a,c,b){if(b){return this.errorEllipse3D(a,c,b)}else{return this.errorEllipse2D(a,c)}};this.errorEllipse2D=function(k,g){var i=this.variance(k,false,false,true);var h=this.variance(g,false,false,true);var j=this.covariance(k,g);var n=[[i[1],j],[j,h[1]]];var o=this.numeric("eig",n);var l=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var f=o.lambda.x[0]>o.lambda.x[1]?0:1;var e=o.lambda.x[0]<o.lambda.x[1]?0:1;var b=i[1]>h[1]?Math.sqrt(o.lambda.x[f])*l:Math.sqrt(o.lambda.x[e])*l;var a=h[1]>i[1]?Math.sqrt(o.lambda.x[f])*l:Math.sqrt(o.lambda.x[e])*l;var c=Math.atan2(o.E.x[f][1],o.E.x[f][0]);if(c<0){c+=Math.PI/2}var d={rx:b,ry:a,cx:i[0],cy:h[0],rot:c};return d};this.errorEllipse3D=function(o,n,k){var i=function(z){for(var y=0;y<z.length;y++){for(var x=0;x<z[y].length;x++){if(isNaN(z[y][x])){return false}}}return true};var r=this.variance(o,false,false,true);var q=this.variance(n,false,false,true);var p=this.variance(k,false,false,true);var c=this.covariance(o,n);var b=this.covariance(o,k);var j=this.covariance(n,k);var w=[[r[1],c,b],[c,q[1],j],[b,j,p[1]]];if(i(w)){var l=this.numeric("eig",w);var a=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var f=this.rank(l.lambda.x);var u=f[2];var s=f[1];var t=f[0];var h=Math.sqrt(l.lambda.x[u])*a;var e=Math.sqrt(l.lambda.x[s])*a;var d=Math.sqrt(l.lambda.x[t])*a;var C=Math.atan2(l.E.x[2][u]*-1,l.E.x[1][u]*-1);var B=Math.atan2(l.E.x[2][u]*-1,l.E.x[0][u]*-1);var A=Math.atan2(l.E.x[1][u]*-1,l.E.x[0][u]*-1);if(C<0){}if(B<0){B+=Math.PI/2}if(A<0){}var g={rx:[h],ry:[e],rz:[d],cx:r[0],cy:q[0],cz:p[0],rot:[C,B,A]};return g}else{return false}};this.cdfNormal=function(a,c,b){var a=(a-c)/b;var f=1/(1+0.2315419*Math.abs(a));var g=0.3989423*Math.exp(-a*a/2);var e=g*f*(0.3193815+f*(-0.3565638+f*(1.781478+f*(-1.821256+f*1.330274))));if(a>0){e=1-e}return e};this.cdf=function(c,f){var e=[];var a=[];var l=[];for(var d=0;d<c.length;d++){if(this.isNumber(c[d])){e.push(c[d]);a.push(f[d]);l.push(d)}}var k=l.sort(function(n,i){return e[n]-e[i]});var j=this.cloneObject(e);j=j.sort(function(n,i){return n-i});var h=[];var b=e.length;for(var d=0;d<b;d++){h.push((d+1)/b)}var g=[];for(var d=0;d<k.length;d++){g.push(a[k[d]])}return{i:g,x:j,y:h}};this.qqline=function(h,g){if(!g||!g.length||g.length!=2){g=[0.25,0.75]}var h=this.quantile(h,g);var a=[];for(var d=0;d<g.length;d++){a.push(this.qnorm(g[d]))}var b=this.diff(h);var c=this.diff(a);var e=b[0]/c[0];var f=h[0]-e*a[0];return{slope:e,intercept:f}};this.qqnorm=function(b,f){var e=[];var a=[];var l=[];for(var d=0;d<b.length;d++){if(this.isNumber(b[d])){e.push(b[d]);a.push(f[d]);l.push(d)}}var c=this.ppoints(e.length);var k=l.sort(function(n,i){return e[n]-e[i]});var h=e.sort(function(n,i){return n-i});var j=[];for(var d=0;d<c.length;d++){j.push(this.qnorm(c[d]))}var g=[];for(var d=0;d<k.length;d++){g.push(a[k[d]])}return{l:this.qqline(h),i:g,x:j,y:h}};this.ppoints=function(e){var c=e<=10?3/8:0.5;var b=[];for(var d=0;d<e;d++){b.push(((d+1)-c)/(e+1-2*c))}return b};this.jitterData=function(o,h,n){if(o.length<2){return o}if(!h){h=1}var g=this.range(o);var k=this.diff(g)[0];if(k==0){k=Math.abs(g[0])}if(k==0){k=1}if(n==null){var c=[];var l=3-Math.floor(Math.log10(k));for(var e=0;e<o.length;e++){c.push(Number(o[e].toFixed(l)))}c=this.unique(c.sort(function(f,d){return f-d}));var j=this.diff(c);if(j.length){j=this.min(j)}else{if(c[0]!=0){j=c[0]/10}else{j=k/10}}n=h/5*Math.abs(j)}else{if(n==0){n=h*(k/50)}}this.randomSeed=8;var b=this.runif(o.length,-n,n);for(var e=0;e<b.length;e++){b[e]+=o[e]}return b};this.bezierCalculatePoints=function(g,e){var b=g[0][0];var a=g[0][1];var d=g[1][0];var c=g[1][1];var h=b+(d-b)*e;var f=a+(c-a)*e;return[h,f]};this.deCasteljau=function(e,d){if(d===1){return e[e.length-1]}if(d===0){return e[0]}if(e.length==1){return e[0]}var b=[];for(var c=1,a=e.length;c<a;c++){b.push(this.bezierCalculatePoints([e[c-1],e[c]],d))}return this.deCasteljau(b,d)};this.divideBezierCurve=function(f,e,c,g){c=c||[];g=g||[];c.push(f[0]);g.push(f[f.length-1]);if(f.length===1){return[c,g]}var b=[];for(var d=1,a=f.length;d<a;d++){b.push(this.bezierCalculatePoints([f[d-1],f[d]],e))}return this.divideBezierCurve(b,e,c,g)};this.centroid=function(a){var c=[];if(!a||a.length<2){return[0,0]}else{if(a.length<3||a.length%2){return[a[0],a[1]]}else{while(a.length>1){c.push([a.shift(),a.shift()])}}}var b=c.reduce(function(d,e){return[d[0]+e[0]/c.length,d[1]+e[1]/c.length]},[0,0]);return b};this.centroidArea=function(a){var b=this.cloneObject(a);b.shift();return this.centroid(b)};this.prufer=function(c){var b=[];var e=Array.apply(null,Array(c.length+2)).map(function(a,j){return j});var h=Array.apply(null,Array(1*e.length)).map(function(){return 1});c.map(function(a){h[a]++});for(var f=0;f<c.length;f++){for(var d=0;d<e.length;d++){if(h[e[d]]===1){b.push([c[f],e[d]]);h[c[f]]--;h[e[d]]--;break}}}var g=e.filter(function(a){return h[a]===1});b.push(g);return b};this.probabilityOfZ=function(c){var e=6;var d,a,b;if(c==0){a=0}else{d=0.5*Math.abs(c);if(d>(e*0.5)){a=1}else{if(d<1){b=d*d;a=((((((((0.000124818987*b-0.001075204047)*b+0.005198775019)*b-0.019198292004)*b+0.059054035642)*b-0.151968751364)*b+0.319152932694)*b-0.5319230073)*b+0.797884560593)*d*2}else{d-=2;a=(((((((((((((-0.000045255659*d+0.00015252929)*d-0.000019538132)*d-0.000676904986)*d+0.001390604284)*d-0.00079462082)*d-0.002034254874)*d+0.006549791214)*d-0.010557625006)*d+0.011630447319)*d-0.009279453341)*d+0.005353579108)*d-0.002141268741)*d+0.000535310849)*d+0.999936657524}}}return c>0?((a+1)*0.5):((1-a)*0.5)};this.criticalNormalZ=function(e){var g=6;var c=0.000001;var f=-g;var d=g;var b=0;var a;if(e<0){e=0}if(e>1){e=1}while((d-f)>c){a=this.probabilityOfZ(b);if(a>e){d=b}else{f=b}b=(d+f)*0.5}return b};this.kaplanMeier=function(j,b){var g=this;function k(w,i){firstSecond=g.zip(w,i);firstSecond.sort(function(y,x){return y[1]-x[1]});return g.unzip(firstSecond,0)}function t(w,i){return w-i}var s={times:[],events:[]};for(var p=0;p<j.length;p++){if(!isNaN(j[p])){s.times.push(j[p]);if(this.invertCensored){s.events.push(isNaN(b[p])?1:b[p]?0:1)}else{s.events.push(isNaN(b[p])?0:b[p])}}}j=s.times;b=s.events;var d=this.unique(j).sort(t);var q=new Array(d.length);var a=new Array(d.length);var l=new Array(d.length);var e=new Array(d.length);var u=new Array(d.length);var h=new Array(d.length);var n=new Array(d.length);var o=0;b=k(b,j);j.sort(t);for(var f=0;f<d.length;f++){u[f]=j.length;h[f]=0;n[f]=0;for(var p=0;p<j.length;p++){if(j[p]==d[f]){h[f]+=b[p];n[f]+=!b[p]}else{break}}var r=p;q[f]=(1-h[f]/u[f])*((f==0)?1:q[f-1]);o+=h[f]/(u[f]*(u[f]-h[f]));a[f]=Math.sqrt(o)*q[f];l[f]=Math.sqrt(o);e[f]=Math.sqrt(o)/Math.log(q[f]);b=b.slice(r);j=j.slice(r)}var c=this.kaplanMeierConfidence(q,this.confidenceIntervalType=="log"?l:this.confidenceIntervalType=="loglog"?e:a);return{time:d,nAtRisk:u,nEvents:h,nCensored:n,kaplanMeier:q,greenwoodSE:a,greenwoodSELog:l,greenwoodSELogLog:e,lowerLimit:c[0],upperLimit:c[1]}};this.kaplanMeierConfidence=function(b,f){var g=this.criticalNormalZ(this.confidenceLevel);var h=b.length;var c=new Array(h);var e=new Array(h);for(var d=0;d<h;d++){var a=b[d];if(this.confidenceIntervalType=="log"){a=Math.log(a)}if(this.confidenceIntervalType=="loglog"){a=Math.log(-Math.log(a))}c[d]=a-g*f[d];e[d]=a+g*f[d];if(this.confidenceIntervalType=="log"){c[d]=Math.exp(c[d]);e[d]=Math.exp(e[d])}if(this.confidenceIntervalType=="loglog"){c[d]=Math.exp(-Math.exp(c[d]));e[d]=Math.exp(-Math.exp(e[d]))}c[d]=Math.max(0,c[d]);e[d]=Math.min(1,e[d])}return[c,e]};this.getD3Sankey=function(){var h=function(F,E){return F<E?-1:F>E?1:F>=E?0:NaN};var f=function(J,H){var G=0,I=J.length,E,F=-1;if(H==null){while(++F<I){if(E=+J[F]){G+=E}}}else{while(++F<I){if(E=+H(J[F],F,J)){G+=E}}}return G};var u=function(J,H){var G=-1,I=J.length,F,E;if(H==null){while(++G<I){if((E=J[G])!=null&&E>=E){F=E;break}}while(++G<I){if((E=J[G])!=null&&F>E){F=E}}}else{while(++G<I){if((E=H(J[G],G,J))!=null&&E>=E){F=E;break}}while(++G<I){if((E=H(J[G],G,J))!=null&&F>E){F=E}}}return F};var z=function(F,E){return F=+F,E-=F,function(G){return F+E*G}};var x="$";function j(){}j.prototype=C.prototype={constructor:j,has:function(E){return(x+E) in this},get:function(E){return this[x+E]},set:function(E,F){this[x+E]=F;return this},remove:function(E){var F=x+E;return F in this&&delete this[F]},clear:function(){for(var E in this){if(E[0]===x){delete this[E]}}},keys:function(){var E=[];for(var F in this){if(F[0]===x){E.push(F.slice(1))}}return E},values:function(){var E=[];for(var F in this){if(F[0]===x){E.push(this[F])}}return E},entries:function(){var E=[];for(var F in this){if(F[0]===x){E.push({key:F.slice(1),value:this[F]})}}return E},size:function(){var E=0;for(var F in this){if(F[0]===x){++E}}return E},empty:function(){for(var E in this){if(E[0]===x){return false}}return true},each:function(F){for(var E in this){if(E[0]===x){F(this[E],E.slice(1),this)}}}};function C(E,H){var I=new j;if(E instanceof j){E.each(function(M,L){I.set(L,M)})}else{if(Array.isArray(E)){var G=-1,K=E.length,J;if(H==null){while(++G<K){I.set(G,E[G])}}else{while(++G<K){I.set(H(J=E[G],G,E),J)}}}else{if(E){for(var F in E){I.set(F,E[F])}}}}return I}var B=function(){var I=[],K=[],H,J,G;function F(R,P,N,S){if(P>=I.length){return J!=null?J(R):(H!=null?R.sort(H):R)}var Q=-1,L=R.length,V=I[P++],O,T,M=C(),U,W=N();while(++Q<L){if(U=M.get(O=V(T=R[Q])+"")){U.push(T)}else{M.set(O,[T])}}M.each(function(X,Y){S(W,Y,F(X,P,N,S))});return W}function E(M,N){if(++N>I.length){return M}var O,L=K[N-1];if(J!=null&&N>=I.length){O=M.entries()}else{O=[],M.each(function(Q,P){O.push({key:P,values:E(Q,N)})})}return L!=null?O.sort(function(Q,P){return L(Q.key,P.key)}):O}return G={object:function(L){return F(L,0,s,p)},map:function(L){return F(L,0,t,D)},entries:function(L){return E(F(L,0,t,D),0)},key:function(L){I.push(L);return G},sortKeys:function(L){K[I.length-1]=L;return G},sortValues:function(L){H=L;return G},rollup:function(L){J=L;return G}}};function s(){return{}}function p(E,F,G){E[F]=G}function t(){return C()}function D(G,E,F){G.set(E,F)}var l={};var e=12;var i=5;var n=[1,1];var q=[];var d=[];l.nodeWidth=function(E){if(!arguments.length){return e}e=+E;return l};l.nodePadding=function(E){if(!arguments.length){return i}i=+E;return l};l.nodes=function(E){if(!arguments.length){return q}q=E;return l};l.links=function(E){if(!arguments.length){return d}d=E;return l};l.size=function(E){if(!arguments.length){return n}n=E;return l};l.layout=function(E){c();k();a();g(E);b();w();return l};l.relayout=function(){b();w();return l};l.link=function(){var F=0.5;function E(N){var K=N.source.x+N.source.dx,J=N.target.x,I=z(K,J),H=I(F),G=I(1-F),M=N.source.y+N.sy+N.dy/2,L=N.target.y+N.ty+N.dy/2;return"M"+K+","+M+"C"+H+","+M+" "+G+","+L+" "+J+","+L}E.curvature=function(G){if(!arguments.length){return F}F=+G;return E};return E};function w(){var E=0.5;d.forEach(function(M){var J=M.source.x+M.source.dx,I=M.target.x,H=z(J,I),G=H(E),F=H(1-E),L=M.source.y+M.sy+M.dy/2,K=M.target.y+M.ty+M.dy/2;M.bezier=[[J,G,F,I],[L,L,K,K]]})}function c(){q.forEach(function(E){E.sourceLinks=[];E.targetLinks=[]});d.forEach(function(E){var F=E.source,G=E.target;if(typeof F==="number"){F=E.source=q[E.source]}if(typeof G==="number"){G=E.target=q[E.target]}F.sourceLinks.push(E);G.targetLinks.push(E)})}function k(){q.forEach(function(E){E.value=Math.max(f(E.sourceLinks,r),f(E.targetLinks,r))})}function a(){var F=q,G,E=0;while(F.length){G=[];F.forEach(function(H){H.x=E;H.breadth=E;H.dx=e;H.sourceLinks.forEach(function(I){G.push(I.target)})});F=G;++E}y(E);o((n[0]-e)/(E-1))}function y(E){q.forEach(function(F){if(!F.sourceLinks.length){F.x=E-1}})}function o(E){q.forEach(function(F){F.x*=E})}function g(J){var E=B().key(function(M){return M.x}).sortKeys(h).entries(q).map(function(M){return M.values});H();L();for(var K=1;J>0;--J){F(K*=0.99);L();G(K);L()}function H(){var M=u(E,function(N){return(n[1]-(N.length-1)*i)/f(N,r)});E.forEach(function(N){N.forEach(function(P,O){P.y=O;P.dy=P.value*M})});d.forEach(function(N){N.dy=N.value*M})}function G(N){E.forEach(function(O,P){O.forEach(function(Q){if(Q.targetLinks.length){var R=f(Q.targetLinks,M)/f(Q.targetLinks,r);Q.y+=(R-A(Q))*N}})});function M(O){return A(O.source)*O.value}}function F(N){E.slice().reverse().forEach(function(O){O.forEach(function(P){if(P.sourceLinks.length){var Q=f(P.sourceLinks,M)/f(P.sourceLinks,r);P.y+=(Q-A(P))*N}})});function M(O){return A(O.target)*O.value}}function L(){E.forEach(function(N){var Q,M,P=0,R=N.length,O;N.sort(I);for(O=0;O<R;++O){Q=N[O];M=P-Q.y;if(M>0){Q.y+=M}P=Q.y+Q.dy+i}M=P-i-n[1];if(M>0){P=Q.y-=M;for(O=R-2;O>=0;--O){Q=N[O];M=Q.y+Q.dy+i-P;if(M>0){Q.y-=M}P=Q.y}}})}function I(N,M){return N.y-M.y}}function b(){q.forEach(function(G){G.sourceLinks.sort(E);G.targetLinks.sort(F)});q.forEach(function(H){var I=0,G=0;H.sourceLinks.forEach(function(J){J.sy=I;I+=J.dy});H.targetLinks.forEach(function(J){J.ty=G;G+=J.dy})});function F(H,G){return H.source.y-G.source.y}function E(H,G){return H.target.y-G.target.y}}function A(E){return E.y+E.dy/2}function r(E){return E.value}return l};this.setSankey=function(){var a=this.getD3Sankey();a.nodeWidth(this.sankeyNodeWidth);a.nodePadding(this.margin);a.size([this.x-(this.margin*8),this.y-(this.margin*4)]);a.nodes(this.data.sankey.nodes);a.links(this.data.sankey.links);a.layout(this.sankeyIterations);this.data.sankey.object=a};this.getD3Tree=function(){var b=this;var l=function(A,z,y){var B=y/(z.i-A.i);z.c-=B;z.s+=y;A.c+=B;z.z+=y;z.m+=y};var f=function(A){var z=0;var D=0;var C=A.children;var B=C.length;var y;while(--B>=0){y=C[B];y.z+=z;y.m+=z;z+=y.s+(D+=y.c)}};var a=function(z,y,A){return z.a.parent===y.parent?z.a:A};var s=function(y){var z=y.children;return z?z[0]:y.t};var x=function(y){var z=y.children;return z?z[z.length-1]:y.t};var e=function(z,y){return z.parent===y.parent?1:2};var i=1;var g=1;var o=null;var h=function(B,z){if(B===z){return B}var A=B.ancestors();var y=z.ancestors();var C=null;B=A.pop();z=y.pop();while(B===z){C=B;B=A.pop();z=y.pop()}return C};var d=function(y){y.data=y.data.data};var j=function(z){var y=0;do{z.height=y}while((z=z.parent)&&(z.height<++y))};var c=function(E,A){var H=new w(E);var F=+E.value&&(H.value=E.value);var C;var y=[H];var z;var G;var D;var B;if(A==null){A=function(I){return I.children}}while(C=y.pop()){if(F){C.value=+C.data.value}if((G=A(C.data))&&(B=G.length)){C.children=new Array(B);for(D=B-1;D>=0;--D){y.push(z=C.children[D]=new w(G[D]));z.parent=C;z.depth=C.depth+1}}}return H.eachBefore(j)};var w=function(y){this.data=y;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=b.treeNodeId++}};w.prototype=c.prototype={constructor:w,count:function(){return this.eachAfter(count)},each:function(E){var B=this;var C;var A=[B];var z,y,D;do{C=A.reverse();A=[];while(B=C.pop()){E(B);z=B.children;if(z){for(y=0,D=z.length;y<D;++y){A.push(z[y])}}}}while(A.length);return this},eachAfter:function(E){var C=this;var y=[C];var B=[];var A,z,D;while(C=y.pop()){B.push(C);A=C.children;if(A){for(z=0,D=A.length;z<D;++z){y.push(A[z])}}}while(C=B.pop()){E(C)}return this},eachBefore:function(C){var B=this;var y=[B];var A,z;while(B=y.pop()){C(B);A=B.children;if(A){for(z=A.length-1;z>=0;--z){y.push(A[z])}}}return this},sum:function(y){return this.eachAfter(function(C){var B=+y(C.data)||0;var A=C.children;var z=A&&A.length;while(--z>=0){B+=A[z].value}C.value=B})},sort:function(y){return this.eachBefore(function(z){if(z.children){z.children.sort(y)}})},path:function(y){var C=this;var B=h(C,y);var A=[C];while(C!==B){C=C.parent;A.push(C)}var z=A.length;while(y!==B){A.splice(z,0,y);y=y.parent}return A},ancestors:function(){var z=this;var y=[z];while(z=z.parent){y.push(z)}return y},descendants:function(){var y=[];this.each(function(z){y.push(z)});return y},leaves:function(){var y=[];this.eachBefore(function(z){if(!z.children){y.push(z)}});return y},links:function(){var y=this;var z=[];y.each(function(A){if(A!==y){z.push({source:A.parent,target:A})}});return z},copy:function(){return c(this).eachBefore(d)}};var q=function(z,y){this._=z;this.parent=null;this.children=null;this.A=null;this.a=this;this.z=0;this.m=0;this.c=0;this.s=0;this.t=null;this.i=y};q.prototype=Object.create(w.prototype);var r=function(z){var y=new q(z,0);var D;var A=[y];var F;var C;var B;var E;while(D=A.pop()){if(C=D._.children){D.children=new Array(E=C.length);for(B=E-1;B>=0;--B){A.push(F=D.children[B]=new q(C[B],B));F.parent=D}}}(y.parent=new q(null,0)).children=[y];return y};function k(D){var F=r(D);F.eachAfter(u),F.parent.m=-F.z;F.eachBefore(p);if(o){D.eachBefore(t)}else{var z=D;var E=D;var y=D;D.eachBefore(function(H){if(H.x<z.x){z=H}if(H.x>E.x){E=H}if(H.depth>y.depth){y=H}});var G=z===E?1:e(z,E)/2;var A=G-z.x;var C=i/(E.x+G+A);var B=g/(y.depth||1);D.eachBefore(function(H){H.x=(H.x+A)*C;H.y=H.depth*B})}return D}function u(z){var B=z.children;var C=z.parent.children;var y=z.i?C[z.i-1]:null;if(B){f(z);var A=(B[0].z+B[B.length-1].z)/2;if(y){z.z=y.z+e(z._,y._);z.m=z.z-A}else{z.z=A}}else{if(y){z.z=y.z+e(z._,y._)}}z.parent.A=n(z,y,z.parent.A||C[0])}function p(y){y._.x=y.z+y.parent.m;y.m+=y.parent.m}function n(J,I,D){if(I){var A=J;var z=J;var C=I;var B=A.parent.children[0];var F=A.m;var E=z.m;var H=C.m;var G=B.m;var y;while(C=x(C),A=s(A),C&&A){B=s(B);z=x(z);z.a=J;y=C.z+H-A.z-F+e(C._,A._);if(y>0){l(a(C,J,D),J,y);F+=y;E+=y}H+=C.m;F+=A.m;G+=B.m;E+=z.m}if(C&&!x(z)){z.t=C;z.m+=H-E}if(A&&!s(B)){B.t=A;B.m+=F-G;D=J}}return D}function t(y){y.x*=i;y.y=y.depth*g}k.separation=function(y){return arguments.length?(e=y,k):e};k.size=function(y){return arguments.length?(o=false,i=+y[0],g=+y[1],k):(o?null:[i,g])};k.nodeSize=function(y){return arguments.length?(o=true,i=+y[0],g=+y[1],k):(o?[i,g]:null)};k.setTree=function(z,y){return c(z,y)};k.collapse=function(y){k.collapseTree(y);k.update(y)};k.expand=function(y){k.expandTree(y);k.update(y)};k.collapseTree=function(y){if(y.children){y._children=y.children;y._children.forEach(k.collapseTree);y.children=null}};k.expandTree=function(y){if(y._children){y.children=y._children;y.children.forEach(k.expandTree);delete y._children}};return k};this.setTree=function(){var b=[];var c=this.isDOE?this.margin*6:0;if(this.treeCircular){b=this.x>this.y?[360,this.y/2]:[360,this.x/2]}else{b=[this.graphOrientation=="vertical"?this.x-c:this.y,this.graphOrientation=="vertical"?this.y:this.x-c]}var a=function(e,d){return(e.parent==d.parent?1:2)/e.depth};this.data.tree.object=this.treeCircular?this.getD3Tree().size(b).separation(a):this.getD3Tree().size(b);if(!this.data.tree.root){this.data.tree.root=this.getD3Tree().setTree(this.data.tree.data,function(e){return e.children})}this.data.tree.plot=this.data.tree.object(this.data.tree.root);this.data.tree.plot.size=b};this.getD3CirclePack=function(){var l=this;var s=function(M,K){if(M===K){return M}var L=M.ancestors();var J=K.ancestors();var N=null;M=L.pop();K=J.pop();while(M===K){N=M;M=L.pop();K=J.pop()}return N};var p=function(J){J.data=J.data.data};var y=function(K){var J=0;do{K.height=J}while((K=K.parent)&&(K.height<++J))};var n=function(P,L){var S=new H(P);var Q=+P.value&&(S.value=P.value);var N;var J=[S];var K;var R;var O;var M;if(L==null){L=function(T){return T.children}}while(N=J.pop()){if(Q){N.value=+N.data.value}if((R=L(N.data))&&(M=R.length)){N.children=new Array(M);for(O=M-1;O>=0;--O){J.push(K=N.children[O]=new H(R[O]));K.parent=N;K.depth=N.depth+1}}}return S.eachBefore(y)};var H=function(J){this.data=J;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=l.treeNodeId++}};H.prototype=n.prototype={constructor:H,count:function(){return this.eachAfter(count)},each:function(P){var M=this;var N;var L=[M];var K,J,O;do{N=L.reverse();L=[];while(M=N.pop()){P(M);K=M.children;if(K){for(J=0,O=K.length;J<O;++J){L.push(K[J])}}}}while(L.length);return this},eachAfter:function(P){var N=this;var J=[N];var M=[];var L,K,O;while(N=J.pop()){M.push(N);L=N.children;if(L){for(K=0,O=L.length;K<O;++K){J.push(L[K])}}}while(N=M.pop()){P(N)}return this},eachBefore:function(N){var M=this;var J=[M];var L,K;while(M=J.pop()){N(M);L=M.children;if(L){for(K=L.length-1;K>=0;--K){J.push(L[K])}}}return this},sum:function(J){return this.eachAfter(function(N){var M=+J(N.data)||0;var L=N.children;var K=L&&L.length;while(--K>=0){M+=L[K].value}N.value=M})},sort:function(J){return this.eachBefore(function(K){if(K.children){K.children.sort(J)}})},path:function(J){var N=this;var M=s(N,J);var L=[N];while(N!==M){N=N.parent;L.push(N)}var K=L.length;while(J!==M){L.splice(K,0,J);J=J.parent}return L},ancestors:function(){var K=this;var J=[K];while(K=K.parent){J.push(K)}return J},descendants:function(){var J=[];this.each(function(K){J.push(K)});return J},leaves:function(){var J=[];this.eachBefore(function(K){if(!K.children){J.push(K)}});return J},links:function(){var J=this;var K=[];J.each(function(L){if(L!==J){K.push({source:L.parent,target:L})}});return K},copy:function(){return n(this).eachBefore(p)}};var e=null;var t=1;var r=1;var h=function(J){this._=J;this.next=null};var g=function(O){var K;var N=(O=O.slice()).length;var J=null;var M=J;while(N){var L=new h(O[N-1]);if(M){M=M.next=L}else{M=J=L}O[K]=O[--N]}return{head:J,tail:M}};var u=function(J){return I(g(J),[])};var d=function(L,J){var M=J.x-L.x;var K=J.y-L.y;var N=L.r-J.r;return N*N+0.000001>M*M+K*K};var I=function(K,Q){var O;var N=null;var M=K.head;var J;var P;switch(Q.length){case 1:O=A(Q[0]);break;case 2:O=z(Q[0],Q[1]);break;case 3:O=w(Q[0],Q[1],Q[2]);break}while(M){P=M._;J=M.next;if(!O||!d(O,P)){if(N){K.tail=N;N.next=null}else{K.head=K.tail=null}Q.push(P);O=I(K,Q);Q.pop();if(K.head){M.next=K.head;K.head=M}else{M.next=null;K.head=K.tail=M}N=K.tail;N.next=J}else{N=M}M=J}K.tail=N;return O};var A=function(J){return{x:J.x,y:J.y,r:J.r}};var z=function(U,R){var K=U.x;var T=U.y;var M=U.r;var J=R.x;var Q=R.y;var L=R.r;var P=J-K;var S=Q-T;var N=L-M;var O=Math.sqrt(P*P+S*S);return{x:(K+J+P/O*N)/2,y:(T+Q+S/O*N)/2,r:(O+M+L)/2}};var w=function(ai,ag,af){var ae=ai.x;var N=ai.y;var Z=ai.r;var ad=ag.x;var M=ag.y;var X=ag.r;var aa=af.x;var K=af.y;var W=af.r;var al=2*(ae-ad);var P=2*(N-M);var V=2*(X-Z);var am=ae*ae+N*N-Z*Z-ad*ad-M*M+X*X;var aj=2*(ae-aa);var O=2*(N-K);var U=2*(W-Z);var ak=ae*ae+N*N-Z*Z-aa*aa-K*K+W*W;var ah=aj*P-al*O;var ac=(P*ak-O*am)/ah-ae;var Y=(O*V-P*U)/ah;var L=(aj*am-al*ak)/ah-N;var J=(al*U-aj*V)/ah;var T=Y*Y+J*J-1;var S=2*(ac*Y+L*J+Z);var R=ac*ac+L*L-Z*Z;var Q=(-S-Math.sqrt(S*S-4*T*R))/(2*T);return{x:ac+Y*Q+ae,y:L+J*Q+N,r:Q}};var o=function(O,M,K){var J=O.x;var S=O.y;var T=M.r+K.r;var R=O.r+K.r;var U=M.x-J;var Q=M.y-S;var P=U*U+Q*Q;if(P){var N=0.5+((R*=R)-(T*=T))/(2*P);var L=Math.sqrt(Math.max(0,2*T*(R+P)-(R-=P)*R-T*T))/(2*P);K.x=J+N*U+L*Q;K.y=S+N*Q-L*U}else{K.x=J+R;K.y=S}};var a=function(L,J){var M=J.x-L.x;var K=J.y-L.y;var N=L.r+J.r;return N*N-0.000001>M*M+K*K};var C=function(O,K,Q){var M=O._;var J=O.next._;var P=M.r+J.r;var N=(M.x*J.r+J.x*M.r)/P-K;var L=(M.y*J.r+J.y*M.r)/P-Q;return N*N+L*L};var i=function(J){this._=J;this.next=null;this.previous=null};var k=function(R){if(!(P=R.length)){return 0}var W,P,T,X,X,V;var Z=R[0];Z.x=0;Z.y=0;if(!(P>1)){return Z.r}var Y=R[1];Z.x=-Y.r;Y.x=Z.r;Y.y=0;if(!(P>2)){return Z.r+Y.r}o(Y,Z,W=R[2]);var ab=Z.r*Z.r;var N=Y.r*Y.r;var O=W.r*W.r;var S=ab+N+O;var M=ab*Z.x+N*Y.x+O*W.x;var L=ab*Z.y+N*Y.y+O*W.y;var K,J,U,T,Q,X,V;Z=new i(Z);Y=new i(Y);W=new i(W);Z.next=W.previous=Y;Y.next=Z.previous=W;W.next=Y.previous=Z;D:for(var U=3;U<P;++U){o(Z._,Y._,W=R[U]);W=new i(W);T=Y.next;Q=Z.previous;X=Y._.r;V=Z._.r;do{if(X<=V){if(a(T._,W._)){Y=T;Z.next=Y;Y.previous=Z;--U;continue D}X+=T._.r;T=T.next}else{if(a(Q._,W._)){Z=Q;Z.next=Y;Y.previous=Z;--U;continue D}V+=Q._.r;Q=Q.previous}}while(T!==Q.next);W.previous=Z;W.next=Y;Z.next=Y.previous=Y=W;S+=O=W._.r*W._.r;M+=O*W._.x;L+=O*W._.y;ab=C(Z,K=M/S,J=L/S);while((W=W.next)!==Y){if((O=C(W,K,J))<ab){Z=W;ab=O}}Y=Z.next}Z=[Y._];W=Y;while((W=W.next)!==Y){Z.push(W._)}W=u(Z);for(var U=0;U<P;++U){Z=R[U];Z.x-=W.x;Z.y-=W.y}return W.r};var j=function(J){k(J);return J};var G=function(J){return J==null?null:q(J)};var q=function(J){if(typeof J!=="function"){throw new Error}return J};var B=function(){return 0};var f=function(J){return function(){return J}};var F=function(J){return Math.sqrt(J.value)};var G=function(J){return J==null?null:q(J)};var E=function(J){return function(K){if(!K.children){K.r=Math.max(0,+J(K)||0)}}};var c=function(K,J){return function(O){if(M=O.children){var M,L,Q=M.length,N=K(O)*J||0,P;if(N){for(L=0;L<Q;++L){M[L].r+=N}}P=k(M);if(N){for(L=0;L<Q;++L){M[L].r-=N}}O.r=P+N}}};var b=function(J){return function(L){var K=L.parent;L.r*=J;if(K){L.x=K.x+J*L.x;L.y=K.y+J*L.y}}};var x=B;function D(J){J.x=t/2,J.y=r/2;if(e){J.eachBefore(E(e)).eachAfter(c(x,0.5)).eachBefore(b(1))}else{J.eachBefore(E(F)).eachAfter(c(B,1)).eachAfter(c(x,J.r/Math.min(t,r))).eachBefore(b(Math.min(t,r)/(2*J.r)))}return J}D.radius=function(J){return arguments.length?(e=G(J),D):e};D.size=function(J){return arguments.length?(t=+J[0],r=+J[1],D):[t,r]};D.padding=function(J){return arguments.length?(x=typeof J==="function"?J:f(+J),D):x};D.setPack=function(J){return n(J).sum(function(K){return K.size}).sort(function(L,K){return K.value-L.value})};return D};this.setCirclePack=function(){var b=Math.max(this.top,this.right);var a=this.width-(this.right+this.left+this.marginLeft+this.marginRight);var e=this.height-(this.top+this.bottom+this.marginTop+this.marginBottom);var c=a>e?e:a;this.data.bubble.object=this.getD3CirclePack().size([c,c]).padding(2);if(!this.data.bubble.root){this.data.bubble.root=this.getD3CirclePack().setPack(this.data.bubble.data)}this.data.bubble.plot=this.data.bubble.object(this.data.bubble.root);this.data.bubble.plot.diameter=c};this.getD3Contour=function(){var s=Math.sqrt(50);var j=Math.sqrt(10);var k=Math.sqrt(2);var B=function(K,F,I){var D;var E=-1;var J,H,G;F=+F,K=+K,I=+I;if(K===F&&I>0){return[K]}if(D=F<K){J=K,K=F,F=J}if((G=t(K,F,I))===0||!isFinite(G)){return[]}if(G>0){let r0=Math.round(K/G),r1=Math.round(F/G);if(r0*G<K){++r0}if(r1*G>F){--r1}H=new Array(J=r1-r0+1);while(++E<J){H[E]=(r0+E)*G}}else{G=-G;let r0=Math.round(K*G),r1=Math.round(F*G);if(r0/G<K){++r0}if(r1/G>F){--r1}H=new Array(J=r1-r0+1);while(++E<J){H[E]=(r0+E)/G}}if(D){H.reverse()}return H};var t=function(I,E,H){var G=(E-I)/Math.max(0,H);var F=Math.floor(Math.log(G)/Math.LN10);var D=G/Math.pow(10,F);return F>=0?(D>=s?10:D>=j?5:D>=k?2:1)*Math.pow(10,F):-Math.pow(10,-F)/(D>=s?10:D>=j?5:D>=k?2:1)};var l=function(I,G,H){var F=Math.abs(G-I)/Math.max(0,H);var D=Math.pow(10,Math.floor(Math.log(F)/Math.LN10));var E=F/D;if(E>=s){D*=10}else{if(E>=j){D*=5}else{if(E>=k){D*=2}}}return G<I?-D:D};var a=function(D){return D[0]};var C=function(D){return D[1]};var d=function(){return 1};var i=function(E,K,F){var G=E.width;var H=E.height;var L=(F<<1)+1;for(var I=0;I<H;++I){for(var J=0,D=0;J<G+F;++J){if(J<G){D+=E.data[J+I*G]}if(J>=F){if(J>=L){D-=E.data[J-L+I*G]}K.data[J-F+I*G]=D/Math.min(J+1,G-1+L-J,L)}}}};var h=function(E,K,F){var G=E.width;var H=E.height;var L=(F<<1)+1;for(var J=0;J<G;++J){for(var I=0,D=0;I<H+F;++I){if(I<H){D+=E.data[J+I*G]}if(I>=F){if(I>=L){D-=E.data[J+(I-L)*G]}K.data[J+(I-F)*G]=D/Math.min(I+1,H-1+L-I,L)}}}};var z=function(I,G){var F=-1,H=I.length,E,D;if(arguments.length===1){while(++F<H){if((D=I[F])!=null&&D>=D){E=D;break}}while(++F<H){if((D=I[F])!=null&&D>E){E=D}}}else{while(++F<H){if((D=G.call(I,I[F],F))!=null&&D>=D){E=D;break}}while(++F<H){if((D=G.call(I,I[F],F))!=null&&D>E){E=D}}}return E};var n=function(D,E){let n=0;if(E===undefined){for(let v in D){let value=D[v];if(value!=null&&(value=+value)>=value){++n}}}else{let index=-1;for(let v in D){let value=D[v];if((value=E(value,++index,D))!=null&&(value=+value)>=value){++n}}}return n};var u=function(I,F,G){I=+I,F=+F,G=(H=arguments.length)<2?(F=I,I=0,1):H<3?1:+G;var E=-1,H=Math.max(0,Math.ceil((F-I)/G))|0,D=new Array(H);while(++E<H){D[E]=I+E*G}return D};var y=Array.prototype.slice;var f=function(E,D){return E-D};var A=function(D){var E=0;var G=D.length;var F=D[G-1][1]*D[0][0]-D[G-1][0]*D[0][1];while(++E<G){F+=D[E-1][1]*D[E][0]-D[E-1][0]*D[E][1]}return F};var e=function(D){return function(){return D}};var o=function(D,F){var E=-1;var H=F.length;var G;while(++E<H){if(G=x(D,F[E])){return G}}return 0};var r=function(J,G){var F=-1,I=J.length,E,D,H;if(arguments.length===1){while(++F<I){if((D=J[F])!=null&&D>=D){E=H=D;break}}while(++F<I){if((D=J[F])!=null){if(E>D){E=D}if(H<D){H=D}}}}else{while(++F<I){if((D=G.call(J,J[F],F))!=null&&D>=D){E=H=D;break}}while(++F<I){if((D=G.call(J,J[F],F))!=null){if(E>D){E=D}if(H<D){H=D}}}}return[E,H]};var x=function(H,Q){var P=Q[0];var O=Q[1];var F=-1;for(var K=0,D=H.length,I=D-1;K<D;I=K++){var L=H[K],N=L[0],G=L[1],J=H[I],M=J[0],E=J[1];if(b(L,J,Q)){return 0}if(((G>O)!==(E>O))&&((P<(M-N)*(O-G)/(E-G)+N))){F=-F}}return F};var b=function(E,D,G){var F;return q(E,D,G)&&w(E[F=+(E[0]===D[0])],G[F],D[F])};var q=function(E,D,F){return(D[0]-E[0])*(F[1]-E[1])===(F[0]-E[0])*(D[1]-E[1])};var w=function(F,E,D){return F<=E&&E<=D||D<=E&&E<=F};var g=function(){};var c=[[],[[[1,1.5],[0.5,1]]],[[[1.5,1],[1,1.5]]],[[[1.5,1],[0.5,1]]],[[[1,0.5],[1.5,1]]],[[[1,1.5],[0.5,1]],[[1,0.5],[1.5,1]]],[[[1,0.5],[1,1.5]]],[[[1,0.5],[0.5,1]]],[[[0.5,1],[1,0.5]]],[[[1,1.5],[1,0.5]]],[[[0.5,1],[1,0.5]],[[1.5,1],[1,1.5]]],[[[1.5,1],[1,0.5]]],[[[0.5,1],[1.5,1]]],[[[1,1.5],[1.5,1]]],[[[0.5,1],[1,1.5]]],[]];var p=function(){var L=1;var K=1;var H=function(M){return Math.ceil(Math.log(n(M))/Math.LN2)+1};var J=function(M){var P=H(M);if(!Array.isArray(P)){const O=r(M),N=l(O[0],O[1],P);P=B(Math.floor(O[0]/N)*N,Math.floor(O[1]/N-1)*N,P)}else{P=P.slice().sort(f)}return P.map(function(Q){return G(M,Q)})};var I=function(M){return M[0]*2+M[1]*(L+1)*4};var E=function(N,M,O){N.forEach(function(R){var Q=R[0];var V=R[1];var S=Q|0;var T=V|0;var P;var U=M[T*L+S];if(Q>0&&Q<L&&S===Q){P=M[T*L+S-1];R[0]=Q+(O-P)/(U-P)-0.5}if(V>0&&V<K&&T===V){P=M[(T-1)*L+S];R[1]=V+(O-P)/(U-P)-0.5}})};var D=E;var G=function(O,P){var N=[];var M=[];F(O,P,function(Q){D(Q,O,P);if(A(Q)>0){N.push([Q])}else{M.push(Q)}});M.forEach(function(S){for(var R=0,T=N.length,Q;R<T;++R){if(o((Q=N[R])[0],S)!==-1){Q.push(S);return}}});return{type:"MultiPolygon",value:P,coordinates:N}};var F=function(W,V,X){var N=new Array;var O=new Array;var U,T,S,R,Q,P;var M=function(Z){var ae=[Z[0][0]+U,Z[0][1]+T];var Y=[Z[1][0]+U,Z[1][1]+T];var ad=I(ae);var ac=I(Y);var ab,aa;if(ab=O[ad]){if(aa=N[ac]){delete O[ab.end];delete N[aa.start];if(ab===aa){ab.ring.push(Y);X(ab.ring)}else{N[ab.start]=O[aa.end]={start:ab.start,end:aa.end,ring:ab.ring.concat(aa.ring)}}}else{delete O[ab.end];ab.ring.push(Y);O[ab.end=ac]=ab}}else{if(ab=N[ac]){if(aa=O[ad]){delete N[ab.start];delete O[aa.end];if(ab===aa){ab.ring.push(Y);X(ab.ring)}else{N[aa.start]=O[ab.end]={start:aa.start,end:ab.end,ring:aa.ring.concat(ab.ring)}}}else{delete N[ab.start];ab.ring.unshift(ae);N[ab.start=ad]=ab}}else{N[ad]=O[ac]={start:ad,end:ac,ring:[ae,Y]}}}};U=T=-1;R=W[0]>=V;c[R<<1].forEach(M);while(++U<L-1){S=R,R=W[U+1]>=V;c[S|R<<1].forEach(M)}c[R<<0].forEach(M);while(++T<K-1){U=-1;R=W[T*L+L]>=V;Q=W[T*L]>=V;c[R<<1|Q<<2].forEach(M);while(++U<L-1){S=R,R=W[T*L+L+U+1]>=V;P=Q,Q=W[T*L+U+1]>=V;c[S|R<<1|Q<<2|P<<3].forEach(M)}c[R|Q<<3].forEach(M)}U=-1;Q=W[T*L]>=V;c[Q<<2].forEach(M);while(++U<L-1){P=Q,Q=W[T*L+U+1]>=V;c[Q<<2|P<<3].forEach(M)}c[Q<<3].forEach(M)};J.contour=G;J.size=function(M){if(!arguments.length){return[L,K]}var O=Math.ceil(M[0]);var N=Math.ceil(M[1]);if(!(O>0)||!(N>0)){throw new Error("invalid size")}return L=O,K=N,J};J.thresholds=function(M){return arguments.length?(H=typeof M==="function"?M:Array.isArray(M)?e(y.call(M)):e(M),J):H};J.smooth=function(M){return arguments.length?(D=M?E:g,J):D===E};J.density=function(){var Y=a;var X=C;var V=d;var ac=960;var aa=500;var M=20;var T=2;var O=M*3;var Q=(ac+O*2)>>T;var R=(aa+O*2)>>T;var U=e(20);var Z=function(ag){var af=new Float32Array(Q*R);var ae=new Float32Array(Q*R);ag.forEach(function(an,al,am){var aj=(+Y(an,al,am)+O)>>T,ak=(+X(an,al,am)+O)>>T,ai=+V(an,al,am);if(aj>=0&&aj<Q&&ak>=0&&ak<R){af[aj+ak*Q]+=ai}});i({width:Q,height:R,data:af},{width:Q,height:R,data:ae},M>>T);h({width:Q,height:R,data:ae},{width:Q,height:R,data:af},M>>T);i({width:Q,height:R,data:af},{width:Q,height:R,data:ae},M>>T);h({width:Q,height:R,data:ae},{width:Q,height:R,data:af},M>>T);i({width:Q,height:R,data:af},{width:Q,height:R,data:ae},M>>T);h({width:Q,height:R,data:ae},{width:Q,height:R,data:af},M>>T);var ah=U(af);if(!Array.isArray(ah)){var ad=z(af);ah=l(0,ad,ah);ah=u(0,Math.floor(ad/ah)*ah,ah);ah.shift()}return[ah,[Q,R],af,P]};var P=function(ad){ad.value*=Math.pow(2,-2*T);ad.coordinates.forEach(S);return ad};var S=function(ad){ad.forEach(ab)};var ab=function(ad){ad.forEach(W)};var W=function(ad){ad[0]=ad[0]*Math.pow(2,T)-O;ad[1]=ad[1]*Math.pow(2,T)-O};var N=function(){O=M*3;Q=(ac+O*2)>>T;R=(aa+O*2)>>T;return Z};Z.x=function(ad){return arguments.length?(Y=typeof ad==="function"?ad:e(+ad),Z):Y};Z.y=function(ad){return arguments.length?(X=typeof ad==="function"?ad:e(+ad),Z):X};Z.weight=function(ad){return arguments.length?(V=typeof ad==="function"?ad:e(+ad),Z):V};Z.size=function(ad){if(!arguments.length){return[ac,aa]}var af=+ad[0],ae=+ad[1];if(!(af>=0&&ae>=0)){throw new Error("invalid size")}return ac=af,aa=ae,N()};Z.cellSize=function(ad){if(!arguments.length){return 1<<T}if(!((ad=+ad)>=1)){throw new Error("invalid cell size")}return T=Math.floor(Math.log(ad)/Math.LN2),N()};Z.thresholds=function(ad){return arguments.length?(U=typeof ad==="function"?ad:Array.isArray(ad)?e(y.call(ad)):e(ad),Z):U};Z.bandwidth=function(ad){if(!arguments.length){return Math.sqrt(M*(M+1))}if(!((ad=+ad)>=0)){throw new Error("invalid bandwidth")}return M=Math.round((Math.sqrt(4*ad*ad+1)-1)/2),N()};return Z};return J};return p};this.circularLayout=function(c,f){var e=this;if(c.length>0){var b,g,d;if(f){}else{b=this.x/2;g=this.y/2;d=Math.max(this.x,this.y)}this.calculateCircularLayoutFinalNodePosition(c,b,g,d);var a=function(){if(e.iteration<=15){e.updateCircularLayoutNodePositions(c);e.renderNetwork(false);e.drawNetworkProgressBar("Optimizing ...",e.iteration/15);e.requestAnimationFrame(a)}else{e.finalizeNetworkLayout("circularLayout")}};a()}};this.calculateCircularLayoutFinalNodePosition=function(b,g,f,a){if(this.sizeNodeBy){var j=0;for(var d=0;d<b.length;d++){var c=b[d];if(!c.hide){j+=(this.nodeSize*this.getNodeEdgePropertyValue(c,false,"sizeNodeBy")*2)+this.nodeSize}}var e=2*Math.PI/j;var h=0;for(var d=0;d<b.length;d++){var c=b[d];var j=(this.nodeSize*this.getNodeEdgePropertyValue(c,false,"sizeNodeBy")*2)+this.nodeSize;if(!c.hide){h+=e*j*0.5;c.layout.lastPosition.x=g+a+a*Math.sin(h);c.layout.lastPosition.y=f+a+a*Math.cos(h);c.layout.lastPosition.r=this.networkRadialRadius;c.layout.lastPosition.a=h*180/Math.PI;c.radius=this.networkRadialRadius;c.angle=h*180/Math.PI;h+=e*j*0.5}}}else{var e=2*Math.PI/b.length;for(var d=0;d<b.length;d++){var c=b[d];if(!c.hide){c.layout.lastPosition.x=g+a+a*Math.sin(d*e);c.layout.lastPosition.y=f+a+a*Math.cos(d*e);c.layout.lastPosition.r=this.networkRadialRadius;c.layout.lastPosition.a=d*e*180/Math.PI;c.radius=this.networkRadialRadius;c.angle=d*e*180/Math.PI}}}};this.updateCircularLayoutNodePositions=function(d){var k=Math.atan((this.iteration++/15)*10-5)*0.5/Math.atan(5)+0.5;for(var e=0;e<d.length;e++){var h=d[e].layout;var g=h.lastPosition;var b=g.a*k;var f=g.r*k;var j=this.getPolar(this.networkXCenter,this.networkYCenter,f,b);h.position.x=j.x;h.position.y=j.y}this.updateLayoutNodePositions(d)};this.radialLayout=function(a,d){var c=this;if(a&&a.length){this.calculateRadialLayoutFinalNodePosition(d);this.resetRadialLayoutNodePositions(a);var b=function(){if(c.iteration<15){c.updateRadialLayoutNodePositions(a);c.renderNetwork(false);c.drawNetworkProgressBar("Optimizing ...",c.iteration/15);c.requestAnimationFrame(b)}else{c.finalizeNetworkLayout("radialLayout")}};b()}};this.orderRadialLayout=function(d){var b=this.data.nodeIndices[d];var c=0;for(var a=b;a<this.data.nodes.length;a++){this.data.nodes[a].layout.order=c++}for(var a=0;a<b;a++){this.data.nodes[a].layout.order=c++}};this.updateRadialLayoutNodePositions=function(d){var f=Math.atan((this.iteration++/15)*10-5)*0.5/Math.atan(5)+0.5;var e=1-f;for(var h=0;h<d.length;h++){var g=d[h].layout;var l=g.lastPosition;var k=((e*g.angle)+(f*l.a));var b=((e*g.radius)+(f*l.r));var j=this.getPolar(this.networkXCenter,this.networkYCenter,b,k);d[h].layout.position.x=j.x;d[h].layout.position.y=j.y}this.updateLayoutNodePositions(d)};this.resetRadialLayoutNodePositions=function(a){for(var b=0;b<a.length;b++){var e=a[b].layout;var c=e.lastPosition;if(c.r==0){e.angle=c.a}if(c.r==0){c.a=e.angle}var f=(c.a-e.angle);if(f<0){f+=360}if(f>360){f-=360}if(f>180){f-=360}c.a=e.angle+f}};this.calculateRadialLayoutFinalNodePosition=function(g,d){var p=this;var t=0;var s=[];var o=this.data.nodes[this.data.nodeIndices[g]];var h=o.layout;if(h.hierarchy!="done"){if(!o.hide&&!o.hiddenParent){if(h.children.length>1&&!d){this.orderRadialLayout(g);h.children.sort(function(i,c){var n=p.data.nodes[p.data.nodeIndices[i]].layout;var l=p.data.nodes[p.data.nodeIndices[c]].layout;return n.order-l.order});for(var k=0;k<h.children.length;k++){var e=h.children[k];var u=this.data.nodes[this.data.nodeIndices[e]].layout;if(u.level>h.level){this.calculateRadialLayoutFinalNodePosition(e);s.push(u.angle)}}if(s.length>0){var f=s.length-1;if(s.length==1){t=s[0]}else{if(s[0]>s[f]){t=((s[0]+s[f])%360)/2}else{t=(s[0]+s[f])/2}}}else{this.calculateRadialLayoutFinalNodePosition(g,true)}}else{t=this.networkCurrentAngle;this.networkCurrentAngle=(this.networkCurrentAngle+this.networkAngleStep)}var j=(this.networkDepth-1)-h.level;var q=this.getPolar(this.networkXCenter,this.networkYCenter,this.networkRadialRadius,t);var w=this.shortenLine(this.networkXCenter,this.networkYCenter,q.x,q.y,0,this.networkLevelSize*j,"line");var b=this.lineLength(this.networkXCenter,this.networkYCenter,w[2],w[3]);if(h.level==0){t=0;b=0}h.lastPosition.x=w[2];h.lastPosition.y=w[3];h.lastPosition.r=b;h.lastPosition.a=t%360;h.hierarchy="done";h.angle=t}}};this.forceDirectedLayout=function(b,a){var d=this;if(b&&b.length){var c=function(){if(d.subNetworks&&d.networkDisjoint){var g=d.calculateForcedDirectedLayoutDisjoint(b);if(g<0.001||d.iteration>=d.maxIterations){d.finalizeNetworkLayout("forceDirectedLayout")}else{d.iteration++;if(d.iteration%2){d.renderNetwork(false)}d.drawNetworkProgressBar("Optimizing ...",d.iteration/d.maxIterations);d.requestAnimationFrame(c)}}else{var e=d.calculateForcedDirectedLayoutMovement(b,a);var f=e/b.length;if(f>=0.01&&d.iteration<d.maxIterations){d.iteration++;if(d.iteration%2){d.renderNetwork(false)}d.drawNetworkProgressBar("Optimizing ...",d.iteration/d.maxIterations);d.requestAnimationFrame(c)}else{d.finalizeNetworkLayout("forceDirectedLayout")}}};c()}};this.calculateForcedDirectedLayoutDisjoint=function(u){var d=1;var D=0.001;var E=1-Math.pow(D,1/300);var h=0;var b=0.6;var w=(Math.random()-0.5)*0.000001;if(!this.networkAlphaDisjoint){this.networkAlphaDisjoint=d}d=this.networkAlphaDisjoint;d+=(h-d)*E;var C=this.data.edges.length;for(var A=0;A<1;++A){for(var B=0;B<C;++B){var f=this.data.edges[B];var c=f.layout.subnetworks;var o=this.nodes[f.id1].layout.subnetworks;var j=this.nodes[f.id2].layout.subnetworks;var q=j.x+j.vx-o.x-o.vx||w;var p=j.y+j.vy-o.y-o.vy||w;var z=Math.sqrt(q*q+p*p);z=(z-c.dist)/z*d*c.strn;q*=z;p*=z;j.vx-=q*c.bias;j.vy-=p*c.bias;o.vx+=q*(1-c.bias);o.vy+=p*(1-c.bias)}}var a=this.manyBodyD3();a(d);var t=this.data.nodes.length;for(var B=0;B<t;++B){var g=this.data.nodes[B].layout.subnetworks;g.vx+=-g.x*g.strX*d;g.vy+=-g.y*g.strY*d}var s=0;var r=0;for(var B=0;B<t;++B){var g=this.data.nodes[B].layout.subnetworks;s+=g.x;r+=g.y}for(s=s/t-(this.x*0.5),r=r/t-(this.y*0.5),B=0;B<t;++B){var g=this.data.nodes[B].layout.subnetworks;g.x-=s;g.y-=r}for(var B=0;B<t;++B){var g=this.data.nodes[B].layout.subnetworks;if(g.fx==null){g.x+=g.vx*=b}else{g.x=g.fx;g.vx=0}if(g.fy==null){g.y+=g.vy*=b}else{g.y=g.fy;g.vy=0}}this.networkAlphaDisjoint=d;this.integrateForceDirectedLayoutDisjoint(u);return d};this.integrateForceDirectedLayoutDisjoint=function(a){var b=this.data.nodes.length;if(b){while(b--){var c=this.data.nodes[b];if(!c.fixed&&this.iteration%2){c.layout.position.x=c.layout.subnetworks.x;c.layout.position.y=c.layout.subnetworks.y}}}this.updateLayoutNodePositions(this.data.nodes)};this.calculateForcedDirectedLayoutMovement=function(b,a){if(this.useBarnesHutSimulation||a){this.accumulateForceDirectedLayoutForces();return this.integrateForceDirectedLayout(b)}else{this.setForceDirectedLayoutNodeDisplacement(b);return this.integrateForceDirectedLayoutDisplacement(b)}};this.integrateForceDirectedLayoutDisplacement=function(a){var d=this.averageForceDirectedLayoutMovement(a);var b=a.length;if(b){while(b--){var c=a[b];if(!c.fixed&&this.iteration%2){c.layout.prevPosition.x=c.layout.position.x;c.layout.prevPosition.y=c.layout.position.y}}}this.updateLayoutNodePositions(a);return d*a.length};this.setForceDirectedLayoutNodeDisplacement=function(d){var b={};var h=[];var g=d.length;for(var j=0;j<g;j++){var f=d[j];for(var o=0;o<f.layout.edges.length;o++){var k=f.layout.edges[o];var n=k.id1+":"+k.id2;if(!b.hasOwnProperty(n)){h.push(k);b[n]=true}}if(!f.fixed&&!this.iteration){f.layout.displacement={x:f.x,y:f.y,z:f.z};f.layout.force={x:0,y:0,z:0}}}this.calculateForceDirectedLayoutRepulsiveDisplacement(d);this.calculateForceDirectedLayoutAttractiveDisplacement(d,h);this.applyForceDirectedLayoutDisplacement(d)};this.calculateForceDirectedLayoutRepulsiveDisplacement=function(b){var w=this;var f=b.length;var g=Math.sqrt((f*f)/f+1);var r=function(i){switch(w.repulsiveForceFunction){case"FruchtermanReingold":case"square":return(g*g)/i;case"cubic":return(g*g*g)/i;case"Eades":case"log":return g/Math.log(i);case"pow":return g*Math.pow(2,i);case"sqrt":return g/Math.sqrt(i)}};for(var n=0;n<f;n++){var e=b[n];var c=e.layout.displacement;var q=e.layout.force;if(!e.fixed){for(var h=0;h<f;h++){if(n!=h){var d=b[h];var a=d.layout.displacement;var x=c.x-a.x;var u=c.y-a.y;var s=c.z-a.z;var p=Math.sqrt((x*x)+(u*u)+(s*s))+0.01;var o=r(p);q.x+=x/p*o;q.y+=u/p*o;q.z+=s/p*o}}}}};this.calculateForceDirectedLayoutAttractiveDisplacement=function(h,a){var f=this;var o=h.length;var r=Math.sqrt((o*o)/o+1);var x=function(i){switch(f.attractiveForceFunction){case"FruchtermanReingold":case"square":return(i*i)/r;case"cubic":return(i*i*i)/r;case"Eades":case"log":return i*Math.log(m);case"pow":return i*Math.pow(2,r);case"sqrt":return i/Math.sqrt(r)}};var o=a.length;for(var u=0;u<o;u++){var b=a[u];var s=this.nodes[b.id1];var p=this.nodes[b.id2];var q=s.layout.displacement;var n=p.layout.displacement;var y=s.layout.force;var w=p.layout.force;var e=q.x-n.x;var d=q.y-n.y;var c=q.z-n.z;var g=Math.sqrt((e*e)+(d*d)+(c*c))+0.01;var j=x(g);if(!s.fixed){y.x-=e/g*j;y.y-=d/g*j;y.z-=c/g*j}if(!p.fixed){w.x+=e/g*j;w.y+=d/g*j;w.z+=c/g*j}}};this.applyForceDirectedLayoutDisplacement=function(b){var r=this;var e=b.length;var d=Math.sqrt(e*e)/10;var f=Math.sqrt((e*e)/e+1);for(var g=0;g<e;g++){var o=b[g].layout.displacement;var h=b[g].layout.force;var j=Math.sqrt((o.x*o.x)+(o.y*o.y)+(o.z*o.z));var a=f*this.networkGravity*j*0.01;h.x-=a*o.x/j;h.y-=a*o.y/j;h.z-=a*o.z/j;h.x*=this.networkSpeed;h.y*=this.networkSpeed;h.z*=this.networkSpeed;if(!b[g].fixed){var s=h.x;var q=h.y;var p=h.z;var j=Math.sqrt((s*s)+(q*q)+(p*p));if(j>0){var n=Math.min(d*this.networkSpeed,j);o.x+=s/j*n;o.y+=q/j*n;o.z+=p/j*n}}}for(var g=0;g<e;g++){var c=b[g];var o=b[g].layout.displacement;c.layout.position={x:o.x,y:o.y,z:o.z}}};this.accumulateForceDirectedLayoutForces=function(){var c=this.data.nodes;var b=this.data.edges;var d=c.length;if(d){var a=this.barnesHutInsertBodies(c);while(d--){var e=c[d];if(!e.fixed){e.layout.force={x:0,y:0,z:0};this.barnesHutUpdateBodyForce(e,a);this.updateForceDirectedLayoutDragForce(e)}}}d=b.length;while(d--){this.updateForceDirectedLayoutSpringForce(b[d])}this.updateLayoutNodePositions(c)};this.barnesHutNewNode=function(){this.barnesHutNodesCache[this.barnesHutNodesCacheCurrent]={body:null,quad0:null,quad1:null,quad2:null,quad3:null,quad4:null,quad5:null,quad6:null,quad7:null,mass:0,massX:0,massY:0,left:0,top:0,bottom:0,right:0,back:0,front:0};var a=this.barnesHutNodesCache[this.barnesHutNodesCacheCurrent];++this.barnesHutNodesCacheCurrent;return a};this.barnesHutInsertBodies=function(e,p){var d=this;var a=function(Y){var U=function(y,x){if(x===0){return y.quad0}if(x===1){return y.quad1}if(x===2){return y.quad2}if(x===3){return y.quad3}return null};var T=function(y,x,z){if(x===0){y.quad0=z}else{if(x===1){y.quad1=z}else{if(x===2){y.quad2=z}else{if(x===3){y.quad3=z}}}}};var X=function(ab,aa){var z=Math.abs(ab.x-aa.x);var y=Math.abs(ab.y-aa.y);var x=Math.abs(ab.z-aa.z);return(z<1e-8&&y<1e-8&&x<1e-8)};var Z={stack:[],popIdx:0,isEmpty:function(){return this.popIdx===0},push:function(y,x){this.stack[this.popIdx]={node:y,body:x};++this.popIdx},pop:function(){if(this.popIdx>0){return this.stack[--this.popIdx]}},reset:function(){this.popIdx=0}};Z.reset();Z.push(p,Y);while(!Z.isEmpty()){var B=Z.pop();var R=B.node;var N=B.body;if(!R.body){var K=N.layout.position.x;var I=N.layout.position.y;var H=N.layout.position.z;R.mass=R.mass+N.layout.mass;R.massX=R.massX+N.layout.mass*K;R.massY=R.massY+N.layout.mass*I;R.massZ=R.massZ+N.layout.mass*H;var A=0;var C=R.left;var W=(R.right+C)/2;var P=R.top;var G=(R.bottom+P)/2;var Q=R.back;var F=(R.front-Q)/2;if(this.is3DNetwork){if(K>W){A=A+1;var S=C;C=W;W=W+(W-S)}if(I>G){A=A+2;var i=P;P=G;G=G+(G-i)}if(H>F){A=A+4;var w=Q;Q=F;F=Q+(Q-w)}}else{if(K>W){A=A+1;C=W;W=R.right}if(I>G){A=A+2;P=G;G=R.bottom}}var E=U(R,A);if(!E){E=d.barnesHutNewNode();E.left=C;E.top=P;E.right=W;E.bottom=G;E.back=Q;E.front=F;E.body=N;T(R,A,E)}else{Z.push(E,N)}}else{var M=R.body;R.body=null;if(X(M.layout.position,N.layout.position)){var V=3;while(V>0&&X(M.layout.position,N.layout.position)){var D=d.random();var O=(R.right-R.left)*D;var L=(R.bottom-R.top)*D;var J=(R.front-R.back)*D;M.layout.position.x=R.left+O;M.layout.position.y=R.top+L;M.layout.position.z=R.back+J;V-=1}if(V===0&&X(M.layout.position,N.layout.position)){return}}Z.push(R,M);Z.push(R,N)}}};var u=Number.MAX_VALUE;var c=Number.MAX_VALUE;var o=Number.MAX_VALUE;var t=Number.MIN_VALUE;var b=Number.MIN_VALUE;var l=Number.MIN_VALUE;var r=e.length;var s=r;while(s--){var j=e[s].layout.position.x;var g=e[s].layout.position.y;var f=e[s].layout.position.y;if(j<u){u=j}if(j>t){t=j}if(g<c){c=g}if(g>b){b=g}if(f<o){o=f}if(f>l){l=f}}var n=t-u;var k=b-c;var h=l-o;var q=Math.max(n,Math.max(k,h));if(this.is3DNetwork){t=u+q;b=c+q;l=o+q}else{if(n>k){b=c+n}else{t=u+k}}this.barnesHutNodesCacheCurrent=0;p=this.barnesHutNewNode();p.left=u;p.right=t;p.top=c;p.bottom=b;p.back=o;p.from=l;s=r-1;if(s>=0){p.body=e[s]}while(s--){a(e[s],p)}return p};this.barnesHutUpdateBodyForce=function(j,l){var i=this.barnesHutUpdateQueue;var n;var s;var q;var p;var a;var g=0;var d=0;var b=0;var f=1;var k=0;var e=1;i[0]=l;while(f){var c=i[k];var h=c.body;f-=1;k+=1;var o=(h!==j);if(h&&o){s=h.layout.position.x-j.layout.position.x;q=h.layout.position.y-j.layout.position.y;p=h.layout.position.z-j.layout.position.z;a=Math.sqrt(s*s+q*q+p*p);if(a===0){s=(this.random()-0.5)/50;q=(this.random()-0.5)/50;p=(this.random()-0.5)/50;a=Math.sqrt(s*s+q*q+p*p)}n=this.networkRepulsion*h.layout.mass*j.layout.mass/(a*a*a);g+=n*s;d+=n*q;b+=n*p}else{if(o){s=c.massX/c.mass-j.layout.position.x;q=c.massY/c.mass-j.layout.position.y;p=c.massZ/c.mass-j.layout.position.z;a=Math.sqrt(s*s+q*q+p*p);if(a===0){s=(this.random()-0.5)/50;q=(this.random()-0.5)/50;p=(this.random()-0.5)/50;a=Math.sqrt(s*s+q*q+p*p)}if((c.right-c.left)/a<this.networkTheta){n=this.networkRepulsion*c.mass*j.layout.mass/(a*a*a);g+=n*s;d+=n*q;b+=n*p}else{if(c.quad0){i[e]=c.quad0;f+=1;e+=1}if(c.quad1){i[e]=c.quad1;f+=1;e+=1}if(c.quad2){i[e]=c.quad2;f+=1;e+=1}if(c.quad3){i[e]=c.quad3;f+=1;e+=1}if(this.is3DNetwork){if(c.quad4){i[e]=c.quad4;f+=1;e+=1}if(c.quad5){i[e]=c.quad5;f+=1;e+=1}if(c.quad6){i[e]=c.quad6;f+=1;e+=1}if(c.quad7){i[e]=c.quad7;f+=1;e+=1}}}}}}j.layout.force.x+=g;j.layout.force.y+=d;j.layout.force.z+=b};this.updateLayoutNodePositions=function(a){var b=a.length;while(b--){a[b].x=a[b].layout.position.x;a[b].y=a[b].layout.position.y;a[b].z=a[b].layout.position.z}};this.updateForceDirectedLayoutSpringForce=function(b){var h=this.data.nodes[this.data.nodeIndices[b.id1]];var g=this.data.nodes[this.data.nodeIndices[b.id2]];var c=b.layout.length<0?this.networkSpringLength:b.layout.length;var j=g.layout.position.x-h.layout.position.x;var i=g.layout.position.y-h.layout.position.y;var a=Math.sqrt(j*j+i*i);if(a===0){j=(this.random()-0.5)/50;i=(this.random()-0.5)/50;a=Math.sqrt(j*j+i*i)}var f=a-c;var e=((!b.layout.coeff||b.layout.coeff<0)?this.networkSpringCoeff:b.layout.coeff)*f/a*b.layout.weight;h.layout.force.x+=e*j;h.layout.force.y+=e*i;g.layout.force.x-=e*j;g.layout.force.y-=e*i};this.integrateForceDirectedLayout=function(a){var n=0;var e=0;var l=0;var c=0;var j=a.length;if(j===0){return 0}for(var d=0;d<j;++d){var b=a[d];var f=this.networkTimeStep/b.layout.mass;b.layout.velocity.x+=f*b.layout.force.x;b.layout.velocity.y+=f*b.layout.force.y;var h=b.layout.velocity.x;var g=b.layout.velocity.y;var k=Math.sqrt(h*h+g*g);if(k>1){b.layout.velocity.x=h/k;b.layout.velocity.y=g/k}n=this.networkTimeStep*b.layout.velocity.x;l=this.networkTimeStep*b.layout.velocity.y;b.layout.position.x+=n;b.layout.position.y+=l;e+=Math.abs(n);c+=Math.abs(l)}return(e*e+c*c)/j};this.updateForceDirectedLayoutDragForce=function(a){a.layout.force.x-=this.networkDragCoeff*a.layout.velocity.x;a.layout.force.y-=this.networkDragCoeff*a.layout.velocity.y};this.averageForceDirectedLayoutMovement=function(c){var d=c.length;var b=0;var a=0;while(d--){var f=c[d];var g=f.layout.position;var e=f.layout.prevPosition;b+=Math.abs(g.x-e.x);a+=Math.abs(g.y-e.y)}return Math.sqrt(b*b+a*a)/c.length};this.networkBetweenness=function(c,f){var k=this;var j=[];var g=[];var d={};var l={};var o={};var n={};var a={};var b=function(u){var y=function(s,i){if(l[i]===-1){l[i]=l[s]+1;j.push(i)}if(l[i]===l[s]+1){o[i]+=o[s];d[i].push(s)}};var w=function(A){var z=k.nodes[A].layout.edges;for(var B=0;B<z.length;B++){var C=z[B];var s=C.id1;if(A==s){if(y(A,s)){return true}}}};var t=function(A){var z=k.nodes[A].layout.edges;for(var B=0;B<z.length;B++){var C=z[B];var s=C.id1==A?C.id2:C.id1;if(y(A,s)){return true}}};var x=function(i){if(f){return w(i)}else{return t(i)}};for(var r=0;r<c.length;r++){d[c[r].id]=[];l[c[r].id]=-1;o[c[r].id]=0}l[u]=0;o[u]=1;j.push(u);while(j.length){var q=j.shift();g.push(q);x(q)}};var p=function(){for(var u=0;u<c.length;u++){n[c[u].id]=0}while(g.length){var q=g.pop();var s=(1+n[q])/o[q];var t=d[q];for(var u=0;u<t.length;++u){var r=t[u];n[r]+=o[r]*s}if(q!==e.id){a[q]+=n[q]}}};for(var h=0;h<c.length;h++){var e=c[h].layout;if(!e.metrics){e.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};e.edges=this.edgesForNode(this.data.edges,c[h].id)}a[c[h].id]=0}for(var h=0;h<c.length;h++){var e=c[h];b(e.id);p()}for(var h=0;h<c.length;h++){var e=c[h].layout;e.metrics.betweenness=f?a[c[h].id]:a[c[h].id]/2}};this.networkCloseness=function(b,e){var j=this;var h=[];var k={};var f={};var c;var a=function(q){var u=function(s,i){if(k[i]===-1){k[i]=k[s]+1;h.push(i)}};var r=function(x){var w=j.nodes[x].layout.edges;for(var y=0;y<w.length;y++){var z=w[y];var s=z.id1;if(x==s){if(u(x,s)){return true}}}};var p=function(x){var w=j.nodes[x].layout.edges;for(var y=0;y<w.length;y++){var z=w[y];var s=z.id1==x?z.id2:z.id1;if(u(x,s)){return true}}};var t=function(i){if(e){return r(i)}else{return p(i)}};for(var o=0;o<b.length;o++){k[b[o].id]=-1}k[q]=0;h.push(q);while(h.length){var n=h.shift();t(n)}};var l=function(){var n=Object.keys(k).map(function(p){return k[p]}).filter(function(p){return p!==-1});var o=n.length;var i=n.reduce(function(q,p){return q+p});if(i>0){f[c]=(o-1)/i}else{f[c]=0}};for(var g=0;g<b.length;g++){var d=b[g].layout;if(!d.metrics){d.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};d.edges=this.edgesForNode(this.data.edges,b[g].id)}f[b[g].id]=0}for(var g=0;g<b.length;g++){var d=b[g];c=b[g].id;a(d.id);l()}for(var g=0;g<b.length;g++){var d=b[g].layout;d.metrics.closeness=f[b[g].id]}};this.networkEccentricity=function(b,f){var j=this;var h=[];var k={};var c={};var d;var a=function(q){var u=function(s,i){if(k[i]===-1){k[i]=k[s]+1;h.push(i)}};var r=function(x){var w=j.nodes[x].layout.edges;for(var y=0;y<w.length;y++){var z=w[y];var s=z.id1;if(x==s){if(u(x,s)){return true}}}};var p=function(x){var w=j.nodes[x].layout.edges;for(var y=0;y<w.length;y++){var z=w[y];var s=z.id1==x?z.id2:z.id1;if(u(x,s)){return true}}};var t=function(i){if(f){return r(i)}else{return p(i)}};for(var o=0;o<b.length;o++){k[b[o].id]=-1}k[q]=0;h.push(q);while(h.length){var n=h.shift();t(n)}};var l=function(){var i=0;Object.keys(k).f