% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_input_and_run_cape.R
\name{load_input_and_run_cape}
\alias{load_input_and_run_cape}
\title{Loads input and run CAPE}
\usage{
load_input_and_run_cape(
  input_file = NULL,
  yaml_params = NULL,
  results_path = NULL,
  run_parallel = FALSE,
  results_file = "cross.RDS",
  p_or_q = 0.05,
  n_cores = 4,
  initialize_only = FALSE,
  verbose = TRUE,
  param_file = NULL,
  create_report = FALSE,
  qtl_id_col = NULL,
  qtl_na_strings = "-"
)
}
\arguments{
\item{input_file}{data input to be loaded}

\item{yaml_params}{a parameter set up in the form of a YAML string}

\item{results_path}{path to the results}

\item{run_parallel}{boolean, if TRUE runs certain parts of the code as parallel blocks}

\item{results_file}{the name of the saved data_obj RDS file. The base name is used as the base name for all saved RDS files.}

\item{p_or_q}{A threshold indicating the maximum adjusted p value considered}

\item{n_cores}{integer, default is 4}

\item{initialize_only}{boolean, default: FALSE}

\item{verbose}{boolean, output goes to stdout}

\item{param_file}{path to yml parameter file for running cape}

\item{create_report}{boolean, if true we create the corresponding HTML report page}

\item{qtl_id_col}{argument for read_population, an optional column number for individual IDs}

\item{qtl_na_strings}{argument for read_population, an optional string for missing values}
}
\description{
This function loads the input file path and runs cape
It is used to run CAPE from a non R script (python)
}
\examples{
\dontrun{
#load input in qtl2 zip format
load_input_and_run_cape("cross_file.zip")

#load input in qtl csv format
load_input_and_run_cape("cross_file.csv")
}

}
