% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lines.R
\name{plot_lines}
\alias{plot_lines}
\title{Plot interaction plot for traits and genetic markers}
\usage{
plot_lines(
  phenoV,
  marker1_vals,
  marker2_vals = NULL,
  pheno_name,
  marker1_label,
  marker2_label,
  ymin = NULL,
  ymax = NULL,
  error_bars
)
}
\arguments{
\item{phenoV}{A vector of trait values}

\item{marker1_vals}{A vector of genotype values 
for marker1}

\item{marker2_vals}{A vector of genotype values
for marker2.}

\item{pheno_name}{A string indicating the name of
the trait being plotted.}

\item{marker1_label}{A string indicating the name
of marker1}

\item{marker2_label}{A string indicating the name
of marker2}

\item{ymin}{A numeric value indicating the minimum 
y value for the plot. If NULL, it will be calculated
based on phenoV and error bars.}

\item{ymax}{A numeric value indicating the maximum
y value for the plot. If NULL, it will be calculated
based on phenoV and error bars.}

\item{error_bars}{A string indicating the type of error
bars to draw. Can be "sd" for standard deviation, "se"
for standard error, or "none".}
}
\value{
None
}
\description{
This internal function is called by plot.effects
to generate an interaction plot for two markers
relating to a trait. If marker2_vals is NULL,
the function instead shows the main effect for
marker1.
}
\keyword{internal}
