% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotGlobalSens.R
\name{PlotGlobalSens}
\alias{PlotGlobalSens}
\title{Plot results of GlobalSens function}
\usage{
PlotGlobalSens(global.out = NULL, x.label = "Time",
  y.label = "Population", legend.label = "Sensitivity range",
  qt.label = "Qt 0.05 - 0.95", sd.label = "mean +- sd   ",
  inner.color = "DarkRed", outer.color = "LightBlue")
}
\arguments{
\item{global.out}{output from \code{\link{CalculateGlobalSens}} function.}

\item{x.label}{string with the name for the x axis.}

\item{y.label}{string with the name for the y axis.}

\item{legend.label}{string with the name for the legend.}

\item{qt.label}{string with the name for the envelope calculated using the quantiles 0.05 and 0.95.}

\item{sd.label}{string with the name for the envelope calculated using the mean +- standard deviation ranges.}

\item{inner.color}{any valid specification of a color for the inner envelope.}

\item{outer.color}{any valid specification of a color for the outer envelope.}
}
\description{
Plot results of of \code{\link{CalculateGlobalSens}} function.
}
\details{
Font size of saved plots is usually different to the font size seen in graphic browsers. Before changing font sizes, see the final result in saved (or preview) plots.
 
Other details of the plot can be modifyed using appropriate functions from \code{ggplot2} package.
}
\examples{
## IASA model

## Parameters and intial conditions.
data(dogs)
dogs_iasa <- GetDataIASA(dogs,
                         destination.label = "Pinhais",
                         total.estimate = 50444)

# Solve for point estimates.
solve_iasa_pt <- SolveIASA(pars = dogs_iasa$pars,
                          init = dogs_iasa$init,
                          time = 0:15,
                          alpha.owned = TRUE,
                          method = 'rk4')

## Set ranges 10 \% greater and lesser than the
## point estimates.
rg_solve_iasa <- SetRanges(pars = dogs_iasa$pars)

## Calculate golobal sensitivity of combined parameters.
## To calculate global sensitivity to each parameter, set
## all as FALSE.
glob_all_solve_iasa <- CalculateGlobalSens(
  model.out = solve_iasa_pt,
  ranges = rg_solve_iasa, 
  sensv = "n2", all = TRUE)
PlotGlobalSens(glob_all_solve_iasa)

}
\references{
Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\link[deSolve]{plot.deSolve}.
}
