% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculus.R
\name{score_hessian}
\alias{score_hessian}
\alias{score}
\alias{hessian}
\title{Score and Hessian matrix}
\usage{
score(expr, vars, simplify = TRUE)

hessian(expr, vars, simplify = TRUE)
}
\arguments{
\item{expr}{'caracas expression'.}

\item{vars}{variables to take derivative with respect to.}

\item{simplify}{Try to simplify result using \code{simplify()}; may be time consuming.}
}
\description{
Compute column vector of first derivatives and matrix of second
derivatives of univariate function.
}
\examples{

if (has_sympy()) {
  def_sym(b0, b1, x, x0)
  f <- b0 / (1 + exp(b1*(x-x0)))
  S <- score(f, c(b0, b1))
  S
  H <- hessian(f, c(b0, b1))
  H
}

}
\seealso{
\code{\link[=jacobian]{jacobian()}}, \code{\link[=der]{der()}}
}
\concept{calculus}
