% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_scaled.R
\name{scale_matrix}
\alias{scale_matrix}
\title{Create list of factors as in a product}
\usage{
scale_matrix(X, k = NULL, divide = TRUE)
}
\arguments{
\item{X}{matrix}

\item{k}{scalar to be factored out}

\item{divide}{Should \code{X} be divided with \code{k} before constructing scaled matrix?}
}
\description{
Create list of factors as in a product
}
\examples{
if (has_sympy()) {
  V <- matrix_sym(2, 2, "v")
  a <- symbol("a")
  
  K <- a*V
  scale_matrix(K, a)
  scale_matrix(V, a, divide = FALSE)

  Ks <- scale_matrix(V, a, divide = FALSE)
  Ks
  W <- matrix_sym(2, 2, "w")
  unscale_matrix(Ks) \%*\% W
  unscale_matrix(Ks) \%*\% W |> scale_matrix(a)
  Ksi <- unscale_matrix(Ks) |> inv() |> scale_matrix(a/det(unscale_matrix(Ks)))
  (Ksi |> unscale_matrix()) \%*\% (Ks |> unscale_matrix()) |> simplify()
  tex(Ksi)
}

}
\concept{linalg}
