% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve.caracas_symbol}
\alias{solve.caracas_symbol}
\title{Solve a System of Linear Equations}
\usage{
\method{solve}{caracas_symbol}(a, b, ...)
}
\arguments{
\item{a}{caracas_symbol}

\item{b}{If provided, either a caracas_symbol (if not, \code{as_sym()} is called on the object)}

\item{\dots}{Not used}
}
\description{
Solve a System of Linear Equations
}
\examples{
if (has_sympy()) {
  A <- matrix_sym(2, 2, "a")
  b <- vector_sym(2, "b")
  # Inverse of A:
  solve(A)
  inv(A)
  solve(A) \%*\% A |> simplify()
  # Find x in Ax = b
  x <- solve(A, b)
  A \%*\% x |> simplify()
  solve(A, c(2, 1)) |> simplify()
}

}
\concept{solve}
