% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{intcal04}
\alias{intcal04}
\title{IntCal04 calibration curve}
\format{
\subsection{\code{intcal04}}{

A data frame with 3,301 rows and 5 columns providing the IntCal04 radiocarbon age
calibration curve on a calendar grid spanning from 26,000--0 cal yr BP:
\describe{
\item{calendar_age}{The calendar age (in cal yr BP)}
\item{c14_age}{The \eqn{{}^{14}}C age (in \eqn{{}^{14}}C yr BP)}
\item{c14_sig}{The (1-\eqn{\sigma}) uncertainty in the \eqn{{}^{14}}C age}
\item{f14c}{The \eqn{{}^{14}}C age expressed as F\eqn{{}^{14}}C concentration}
\item{f14c_sig}{The (1-\eqn{\sigma}) uncertainty in the F\eqn{{}^{14}}C concentration}
}
}
}
\source{
https://doi.org/10.1017/S0033822200032999
}
\usage{
intcal04
}
\description{
The IntCal04 Northern Hemisphere radiocarbon age calibration curve
on a calendar grid spanning from 26,000--0 cal yr BP
(Before Present, 0 cal yr BP corresponds to 1950 CE). \cr \cr
\emph{Note:} This dataset provides \eqn{{}^{14}}C ages and F\eqn{{}^{14}}C values
on a calendar age grid. This is different from the \eqn{{}^{14}}C ages
and \eqn{{\Delta}^{14}}C values provided in oxcal .14c files.\cr \cr
\strong{Reference:} \cr PJ Reimer, MGL Baillie, E Bard, A Bayliss, JW Beck, C Bertrand, PG Blackwell,
CE Buck, G Burr, KB Cutler, PE Damon, RL Edwards, RG Fairbanks, M Friedrich,
TP Guilderson, KA Hughen, B Kromer, FG McCormac, S Manning, C Bronk Ramsey,
RW Reimer, S Remmele, JR Southon, M Stuiver, S Talamo, FW Taylor,
J van der Plicht, and CE Weyhenmeyer. 2004.
Intcal04 Terrestrial Radiocarbon Age Calibration, 0--26 Cal Kyr BP.
\emph{Radiocarbon} \strong{46}(3):1029-1058 https://doi.org/10.1017/S0033822200032999. \cr \cr
}
\keyword{datasets}
