% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{intcal20}
\alias{intcal20}
\title{IntCal20 calibration curve}
\format{
\subsection{\code{intcal20}}{

A data frame with 9,501 rows and 5 columns providing the IntCal20 radiocarbon age
calibration curve on a calendar grid spanning from 55,000--0 cal yr BP:
\describe{
\item{calendar_age}{The calendar age (in cal yr BP)}
\item{c14_age}{The \eqn{{}^{14}}C age (in \eqn{{}^{14}}C yr BP)}
\item{c14_sig}{The (1-\eqn{\sigma}) uncertainty in the \eqn{{}^{14}}C age}
\item{f14c}{The \eqn{{}^{14}}C age expressed as F\eqn{{}^{14}}C concentration}
\item{f14c_sig}{The (1-\eqn{\sigma}) uncertainty in the F\eqn{{}^{14}}C concentration}
}
}
}
\source{
http://doi.org/10.1017/RDC.2020.41
}
\usage{
intcal20
}
\description{
The IntCal20 Northern Hemisphere radiocarbon age calibration curve
on a calendar grid spanning from 55,000--0 cal yr BP
(Before Present, 0 cal yr BP corresponds to 1950 CE). \cr \cr
\emph{Note:} This dataset provides \eqn{{}^{14}}C ages and F\eqn{{}^{14}}C values
on a calendar age grid. This is different from the \eqn{{}^{14}}C ages
and \eqn{{\Delta}^{14}}C values provided in oxcal .14c files.\cr \cr
\strong{Reference:} \cr Reimer PJ, Austin WEN, Bard E, Bayliss A, Blackwell PG, Bronk Ramsey C,
Butzin M, Cheng H, Edwards RL, Friedrich M, Grootes PM, Guilderson TP,
Hajdas I, Heaton TJ, Hogg AG, Hughen KA, Kromer B, Manning SW, Muscheler R,
Palmer JG, Pearson C, van der Plicht J, Reimer RW, Richards DA, Scott EM,
Southon JR, Turney CSM, Wacker L, Adolphi F, Büntgen U, Capano M, Fahrni S,
Fogtmann-Schulz A, Friedrich R, Köhler P, Kudsk S, Miyake F, Olsen J,
Reinig F, Sakamoto M, Sookdeo A, Talamo S. 2020.
The IntCal20 Northern Hemisphere radiocarbon age calibration curve
(0-55 cal kBP). \emph{Radiocarbon} \strong{62} https://doi.org/10.1017/RDC.2020.41.
}
\keyword{datasets}
