% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/badges.R
\name{badge_row_svg}
\alias{badge_row_svg}
\alias{create_badge_row}
\title{Create a row of SVG badges with uniform height}
\usage{
create_badge_row(
  badges_data,
  default_color = "white",
  spacing = 4,
  font = "Jost",
  fontsize = 10,
  uniform_height = TRUE
)
}
\arguments{
\item{badges_data}{A list of lists, each containing label, value, and optionally color}

\item{default_color}{Default color for badges}

\item{spacing}{Spacing between badges}

\item{font}{Font family}

\item{fontsize}{Font size}

\item{uniform_height}{Force all badges to have the same height (default TRUE)}
}
\value{
SVG string containing all badges
}
\description{
Generate multiple badges arranged horizontally with the same height.
}
\examples{
badges <- list(
  list(label = "UH", value = "192"),
  list(label = "Recurso Federal", value = "36,4 milhões"),
  list(label = "Contrapartida", value = "0,0")
)
create_badge_row(badges, default_color = "white")
}
