% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{svg_to_formats}
\alias{svg_to_formats}
\title{Convert SVG to multiple formats}
\usage{
svg_to_formats(
  svg_input,
  output_base,
  formats = c("svg", "png"),
  dpi = 300,
  background = "transparent"
)
}
\arguments{
\item{svg_input}{SVG string or file path.}

\item{output_base}{Base name for output files (without extension).}

\item{formats}{Vector of formats to generate ("png", "svg", "pdf").}

\item{dpi}{Resolution for raster formats.}

\item{background}{Background color for PNG output.}
}
\value{
Named list with paths to generated files.
}
\description{
Convert an SVG string or file to multiple formats. Supported formats are:
\itemize{
\item \code{"svg"} - saves the SVG
\item \code{"png"} - rasterizes to PNG via \code{\link{svg_to_png}}
\item \code{"pdf"} - converts to PDF (prefers \pkg{rsvg})
}
}
