% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_noisedims}
\alias{gen_noisedims}
\title{Generate Random Noise Dimensions}
\usage{
gen_noisedims(n = 500, p = 4, m = rep(0, p), s = rep(2, p))
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{m}{A numeric vector (default: c(0, 0, 0, 0)) representing the mean along each dimensions.}

\item{s}{A numeric vector (default: c(2, 2, 2, 2)) representing the standard deviation along each dimensions.}
}
\value{
A data containing the generated random noise dimensions.
}
\description{
This function generates random noise dimensions to be added to the coordinates of a data structure.
}
\examples{
set.seed(20240412)
gen_noisedims(n = 500, p = 4, m = c(0, 0, 0, 0), s = c(2, 2, 2, 2))

}
