% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere.R
\name{gen_clusteredspheres}
\alias{gen_clusteredspheres}
\title{Generate Small Spheres Within a Big Sphere}
\usage{
gen_clusteredspheres(
  n_vec = c(1000, 100),
  k_small = 3,
  r_vec = c(15, 3),
  sep = 10/sqrt(3)
)
}
\arguments{
\item{n_vec}{A numeric vector (default: c(1000, 100)) representing the sample sizes of the big and small spheres respectively.}

\item{k_small}{A numeric value (default: 3) representing the number of small spheres.}

\item{r_vec}{A numeric vector (default: c(15, 3)) representing the radius of the big and small spheres respectively.}

\item{sep}{A numeric value (default: 10 / sqrt(3) representing how far the small spheres are placed from each other.}
}
\value{
A data containing small spheres within a big sphere.
}
\description{
This function generates a dataset representing a structure with a small and big spheres.
}
\examples{
set.seed(20240412)
clusteredspheres <- gen_clusteredspheres(n_vec = c(1000, 100), k_small = 3,
r_vec = c(15, 3), sep = 10 / sqrt(3))
}
