% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scurve.R
\name{gen_scurvehole}
\alias{gen_scurvehole}
\title{Generate S-curve Data with a Hole}
\usage{
gen_scurvehole(n = 500, r_hole = 0.5)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{r_hole}{A numeric value (default: 0.5) representing the radius of the hole.}
}
\value{
A data containing the generated S-curve data with a hole.
}
\description{
This function generates S-curve data with a hole by filtering out samples that
are not close to a specified anchor point.
}
\examples{
set.seed(20240412)
scurvehole <- gen_scurvehole(n = 1000)
}
\references{
Wang, Y., Huang, H., Rudin, C., & Shaposhnik, Y. (2021).
Understanding how dimension reduction tools work: an empirical approach to
deciphering t-SNE, UMAP, TriMAP, and PaCMAP for data visualization.
\emph{J Mach. Learn. Res}, \emph{22}, 1-73.
}
\seealso{
the \href{https://github.com/YingfanWang/PaCMAP}{PaCMAP homepage}.
}
