% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_evaluation.R
\name{co2_eval_moving}
\alias{co2_eval_moving}
\title{Fuel Consumption and CO2 Emissions for Moving Wood From the Felling Spot to
the Forest Road}
\usage{
co2_eval_moving(
  x,
  road_density,
  rel_loss = 0.1,
  mode = c("standard", "nordic")
)
}
\arguments{
\item{x}{An object of class \code{c4c_base_result}}

\item{road_density}{Forest road density (m/ha), relating to truck-accessible
roads}

\item{rel_loss}{Relative amount of the standing tree volume that is lost
during harvesting (default 0.1). Note that the harvested amount is reduced
with the factor 1 - rel_loss before upscaling from the fuel consumption per
m³, because only the wood remaining after the harvest loss (mainly the
stumps) is actually moved.}

\item{mode}{Character string to choose between "standard" (default) and
"nordic". With the option "standard", the function
\code{\link{fuel_cons_forwarder_1}} is used, while "nordic" makes use of
\code{\link{fuel_cons_forwarder_2}}}
}
\value{
A data frame (tibble) with the columns time, harvest_type (damage or
regular), phase_no, phase_name (numbers and names of the stand development
phases), fuel_moving_l_per_m3 (liters of fuel consumed per m3 of moved
wood), fuel_moving_total_l (liters of fuel consumed in total),
co2_moving_total_kg (kg CO2 emitted).
}
\description{
Given the output of a simulation run (i.e. an object of class
\code{c4c_base_result}) as created with the function
\code{\link{simulate_single_concept}}, the fuel consumption and CO2 emissions
for moving the wood to a truck road are calculated. Currently, this function
assumes only forwarder operations.
}
\examples{
  base_out <- simulate_single_concept(
   pine_thinning_from_above_1,
   init_areas = c(50, 100, 10, 50, 150, 600),
   time_span  = 50,
   risk_level = 3
  )

  co2_eval_moving(base_out, road_density = 35, mode = "standard")
  co2_eval_moving(base_out, road_density = 35, mode = "nordic")

}
