% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowlowup.R
\name{flowlowup}
\alias{flowlowup}
\title{Extracts the triangular sub-matrix of flows}
\usage{
flowlowup(tab, origin = NULL, destination = NULL, fij = NULL, lowup, format, x)
}
\arguments{
\item{tab}{is the input flow dataset}

\item{origin}{the place of origin code}

\item{destination}{the place of destination code}

\item{fij}{the flow value between origin and destination places}

\item{lowup}{for selecting lower or upper triangular sub-portion of the original matrix. See Details.}

\item{format}{specify the flow dataset format, "M " for square matrix [n*n] or "L" for long [i,j,data]}

\item{x}{enter the Enter the triangular part to be extracted: "low", "up". See Details.}
}
\description{
Extracts the upper or lower triangular part of a matrix
}
\details{
This function compute for all pairs or origin-destination places (i,j)
a lower "low" or upper "up" triangular sub-portion of the original matrix
- x = "up"  for the part above the main diagonal \cr
- x = "low" for the part below the main diagonal\cr
}
\examples{
library(cartograflow)
data(flowdata)

###Extract the upper part of the matrix : Long format
tab_up <- flowlowup(flows, format="L", lowup="up")
tab_low<-flowlowup(flows, format="L", lowup="low")

}
