% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layoutLayer.R
\name{layoutLayer}
\alias{layoutLayer}
\title{Layout Layer}
\usage{
layoutLayer(title = "Title of the map, year", sources = "Source(s)",
  author = "Author(s)", col = "black", coltitle = "white", bg = NULL,
  scale = 0, frame = TRUE, north = FALSE, south = FALSE,
  extent = NULL)
}
\arguments{
\item{title}{title of the map.}

\item{sources}{sources of the map (or something else).}

\item{author}{author of the map (or something else).}

\item{col}{color of the frame border.}

\item{coltitle}{color of the title.}

\item{bg}{color of the frame background.}

\item{scale}{size of the scale in kilometers. If set to NULL, no scale is
displayed, if set to 0 an automatic scale is displayed (1/10 of the map width).}

\item{frame}{wheither displaying a frame (TRUE) or not (FALSE).}

\item{north}{wheither displaying a Noth arrow (TRUE) or not (FALSE).}

\item{south}{wheither displaying a South arrow (TRUE) or not (FALSE).}

\item{extent}{a SpatialPolygonsDataFrame or a SpatialPointsDataFrame; set the
extent of the frame to the one of a Spatial object. (optional)}
}
\description{
Plot a layout layer.
}
\details{
If extent is not set, plot.new has to be called first.
}
\examples{
data("nuts2006")
# Example 1
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Layout plot
layoutLayer()

# Example 2
layoutLayer(scale = NULL,col = NA, coltitle = "black",
            sources = "", author = "",
            frame = FALSE, bg = "#A6CAE0",
            south = TRUE, extent = nuts0.spdf)
plot(world.spdf, col  = "#E3DEBF", border=NA, add=TRUE)
plot(nuts0.spdf, col = "#D1914D",border = "white", lwd=1, add=TRUE)
}
\seealso{
\link{labelLayer}
}

