% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propLinkLayer.R
\name{propLinkLayer}
\alias{propLinkLayer}
\title{Proportional Links Layer}
\usage{
propLinkLayer(spdf, df, spdfid = NULL, spdfids, spdfide, dfid = NULL, dfids,
  dfide, var, maxlwd = 40, col, legend.pos = "bottomleft",
  legend.title.txt = var, legend.title.cex = 0.8, legend.values.cex = 0.6,
  legend.values.rnd = 0, legend.frame = FALSE, add = TRUE)
}
\arguments{
\item{spdf}{a SpatialLinesDataFrame; a link layer.}

\item{df}{a data frame with identifiers and a variable.}

\item{spdfid}{unique identifier in spdf (spdfids, spdfide, dfids and dfide are not used).}

\item{spdfids}{identifier of starting points in spdf (spdfid and dfid are not used).}

\item{spdfide}{identifier of ending points in spdf (spdfid and dfid are not used).}

\item{dfid}{unique identifier in df (spdfids, spdfide, dfids and dfide are not used).}

\item{dfids}{identifier of starting points in df (spdfid and dfid are not used).}

\item{dfide}{identifier of ending points in df (spdfid and dfid are not used).}

\item{var}{name of the variable used to plot the links widths.}

\item{maxlwd}{maximum size of the links.}

\item{col}{color of the links.}

\item{legend.pos}{position of the legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright". If
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values
displayed in the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}
}
\description{
Plot a layer of proportional links. Links widths are directly proportional to values of a variable.
}
\note{
Unlike most of cartography functions, identifiers fields are mandatory.
}
\examples{
data("nuts2006")
# Create a link layer of the twin cities agreements
twincities.spdf <- getLinkLayer(spdf = nuts2.spdf, df = twincities[,1:2])
# Plot the links - Twin cities agreements between regions
plot(nuts0.spdf, col = "grey60",border = "grey20")
propLinkLayer(spdf = twincities.spdf, df = twincities[twincities$fij>=5,],maxlwd = 10,
              spdfids = "i", spdfide = "j",
              dfids = "i", dfide = "j",legend.pos = "topright",
              var = "fij",
              col = "#92000090", add = TRUE)
}
\seealso{
\link{gradLinkLayer}, \link{getLinkLayer}, \link{legendPropLines}
}

