% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGridData.R
\name{getGridData}
\alias{getGridData}
\title{Compute Data for a Grid Layer}
\usage{
getGridData(x, df, dfid = NULL, var)
}
\arguments{
\item{x}{a list generated by the \link{getGridLayer} function.}

\item{df}{a data frame that contains the values to adapt to the grid. It must 
correspond to the spdf argument in \link{getGridLayer}.}

\item{dfid}{identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df to adapt to the grid.}
}
\value{
A data frame is returned. id_cell are ids of the grid, the two other 
variable are the share of the variable in each cell and the share of the 
variable in each cell divided by its area (in map units).
}
\description{
This function computes data to match a grid layer (as outputed 
by \link{getGridLayer} )
according to the surface intersections.
}
\examples{
\dontrun{
data(nuts2006)
# Create a grid layer
mygrid <- getGridLayer(spdf=nuts2.spdf,cellsize = 200000)
# Compute data for the grid layer
datagrid.df <- getGridData(mygrid, nuts2.df, "pop2008",dfid=NULL)

# Plot total population
plot(mygrid$spdf, col="#CCCCCC",border="white")
propSymbolsLayer(spdf = mygrid$spdf, df = datagrid.df, legend.style = "e",
                 legend.pos = "right", border = "white",legend.title.txt = "Total population",
                 var = "pop2008", inches=0.01, col="black", add=TRUE)

# Plot dentsity of population 
## conversion from square meter to square kilometers
datagrid.df$densitykm <- datagrid.df$pop2008_density*1000*1000 
cols <- carto.pal(pal1 = "taupe.pal", n1 = 6)
choroLayer(spdf = mygrid$spdf,df = datagrid.df,var = "densitykm", add=FALSE,
           border = "grey80",col=cols,
           legend.pos = "right", method = "q6",
           legend.title.txt = "Population density")
           }
}
\seealso{
\link{getGridLayer}
}

