% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propSymbolsLayer.R
\name{propSymbolsLayer}
\alias{propSymbolsLayer}
\title{Proportional Symbols Layer}
\usage{
propSymbolsLayer(x, spdf, df, spdfid = NULL, dfid = NULL, var,
  inches = 0.3, fixmax = NULL, symbols = "circle", col = "#E84923",
  border = "black", lwd = 1, legend.pos = "bottomleft",
  legend.title.txt = var, legend.title.cex = 0.8,
  legend.values.cex = 0.6, legend.values.rnd = 0, legend.style = "c",
  legend.frame = FALSE, add = TRUE, breakval = NULL, col2)
}
\arguments{
\item{x}{an sf object, a simple feature collection. If x is used then spdf, df, spdfid and dfid are not.}

\item{spdf}{a SpatialPointsDataFrame or a SpatialPolygonsDataFrame; if spdf 
is a SpatialPolygonsDataFrame symbols are plotted on centroids.}

\item{df}{a data frame that contains the values to plot. If df is missing 
spdf@data is used instead.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df to plot.}

\item{inches}{size of the biggest symbol (radius for circles, width for
squares, height for bars) in inches.}

\item{fixmax}{value of the biggest symbol (see Details).}

\item{symbols}{type of symbols, one of "circle", "square" or "bar".}

\item{col}{color of symbols.}

\item{border}{color of symbols borders.}

\item{lwd}{width of symbols borders.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)). If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values 
displayed in the legend.}

\item{legend.style}{either "c" or "e". The legend has two display 
styles, "c" stands for compact and "e" for extended.}

\item{legend.frame}{boolean; whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}

\item{breakval}{defunct.}

\item{col2}{defunct.}
}
\description{
Plot a proportional symbols layer.
}
\details{
Two maps with the same inches and fixmax parameters will be comparable.
}
\examples{
## Example 1
library(sf)
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
# Countries plot
plot(st_geometry(mtq), col = "lightblue4",border = "lightblue3", bg = "lightblue1")
# Population plot on proportional symbols
propSymbolsLayer(x = mtq, var = "P13_POP", 
                 symbols = "circle", col =  "white",
                 legend.pos = "right", border = "grey",
                 legend.title.txt = "Total\\npopulation (2013)",
                 legend.style = "c")
# Layout plot
layoutLayer(title = "Population in Martinique",
            sources = "INSEE, 2016", theme = "blue.pal",
            scale = NULL, frame = FALSE)

## Example 2
library(sp)
data("nuts2006")
# Countries plot
plot(nuts0.spdf, col = "grey60",border = "grey20")
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "gdppps2008",
                 symbols = "bar", col =  "#B00EF0",
                 legend.pos = "right",
                 legend.title.txt = "GDP\\nin Millions PPS (2008)",
                 legend.style = "e")

## Example 3
oldpar <- par(mfrow = c(1,2), mar = c(0,0,0,0))
# Countries plot
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "birth_2008", 
                 fixmax = max(nuts0.df$birth_2008),
                 inches = 0.4,
                 symbols = "square", col =  "orange",
                 legend.pos = "right",
                 legend.title.txt = "nb of births",
                 legend.style = "e")
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Population plot on proportional symbols
propSymbolsLayer(spdf = nuts0.spdf, df = nuts0.df,
                 var = "death_2008",
                 symbols = "square", col =  "pink",
                 fixmax = max(nuts0.df$birth_2008),
                 inches = 0.4,
                 legend.pos = "right",
                 legend.style = "e",
                 legend.title.txt = "nb of deaths")
par(oldpar)
}
\seealso{
\link{legendBarsSymbols}, \link{legendCirclesSymbols}, 
\link{legendSquaresSymbols}, \link{propSymbolsChoroLayer}, 
\link{propSymbolsTypoLayer}
}
