% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBorders.R
\name{getBorders}
\alias{getBorders}
\title{Extract Polygons Borders}
\usage{
getBorders(x, id, spdf, spdfid = NULL)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a SpatialPolygonsDataFrame.}

\item{id}{name of the identifier variable x or spdf, default to the first column. (optional)}

\item{spdf}{deprecated, a SpatialPolygonsDataFrame. This SpatialPolygonsDataFrame
has to be projected (planar coordinates).}

\item{spdfid}{deprecated, name of the identifier variable in spdf, default 
to the first column of the 
spdf data frame. (optional)}
}
\value{
An sf object (MULTILINESTRING) of borders is returned. This object has three 
id variables: id, id1 and id2.
id1 and id2 are ids of units that neighbour a border; id is the concatenation 
of id1 and id2 (with "_" as separator).
}
\description{
Extract borders between polygons.
}
\note{
getBorders and getOuterBorders can be combined with rbind.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Get borders
mtq.borders <- getBorders(x = mtq)
# Plot polygons
plot(st_geometry(mtq), border = NA, col = "grey60")
# Plot borders
plot(st_geometry(mtq.borders), 
     col = sample(x = rainbow(nrow(mtq.borders))), 
     lwd = 3, add = TRUE)
}
\seealso{
\link{discLayer}, \link{getOuterBorders}
}
