% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTiles.R
\name{getTiles}
\alias{getTiles}
\title{Get Tiles from Open Map Servers}
\usage{
getTiles(x, spdf, type = "osm", zoom = NULL, crop = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a Spatial*DataFrame.}

\item{spdf}{deprecated, a Spatial*DataFrame with a valid projection attribute.}

\item{type}{the tile server from which to get the map, one of "osm", "hotstyle", 
"hikebike", "osmgrayscale", "stamenbw", "stamenwatercolor", "cartodark", 
"cartolight", "opentopomap".}

\item{zoom}{the zoom level. If null, it is determined automatically 
(see Details).}

\item{crop}{TRUE if results should be cropped to the specified x extent, 
FALSE otherwise. If x is an sf object with one POINT, crop is set to FALSE.}

\item{verbose}{if TRUE, tiles filepaths, zoom level and citation are displayed.}
}
\value{
A RatserBrick is returned.
}
\description{
Get map tiles based on a spatial object extent. Maps can be 
fetched from various open map servers.
}
\details{
Zoom levels are described on the OpenStreetMap wiki: 
\url{http://wiki.openstreetmap.org/wiki/Zoom_levels}.
}
\examples{
\dontrun{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Download the tiles, extent = Martinique
mtqOSM <- getTiles(x = mtq, type = "osm", crop = TRUE)
# Plot the tiles
tilesLayer(mtqOSM)
# Plot countries
plot(st_geometry(mtq), add=TRUE)
txt <- paste0("\u00A9 OpenStreetMap contributors.", 
              " Tiles style under CC BY-SA, www.openstreetmap.org/copyright")
mtext(text = txt, side = 1, adj = 0, cex = 0.7, font = 3)
}
}
\seealso{
\link{tilesLayer}
}
