% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradLinkTypoLayer.R
\name{gradLinkTypoLayer}
\alias{gradLinkTypoLayer}
\title{Graduated and Colored Links Layer}
\usage{
gradLinkTypoLayer(
  x,
  df,
  xid = NULL,
  dfid = NULL,
  var,
  breaks = getBreaks(v = df[, var], nclass = 4, method = "quantile"),
  lwd = c(1, 2, 4, 6),
  var2,
  col = NULL,
  colNA = "white",
  legend.title.cex = 0.8,
  legend.values.cex = 0.6,
  legend.values.rnd = 0,
  legend.var.pos = "bottomleft",
  legend.var.title.txt = var,
  legend.var.frame = FALSE,
  legend.var2.pos = "topright",
  legend.var2.title.txt = var2,
  legend.var2.values.order = NULL,
  legend.var2.nodata = "no data",
  legend.var2.frame = FALSE,
  add = TRUE
)
}
\arguments{
\item{x}{an sf object, a simple feature collection.}

\item{df}{a data frame that contains identifiers of starting and ending points and variables.}

\item{xid}{names of the identifier variables in x, character 
vector of length 2, default to the 2 first columns. (optional)}

\item{dfid}{names of the identifier variables in df, character 
vector of length 2, default to the two first columns. (optional)}

\item{var}{name of the variable used to plot the links widths.}

\item{breaks}{break values in sorted order to indicate the intervals for assigning the lines widths.}

\item{lwd}{vector of widths (classes of widths).}

\item{var2}{name of the variable used to plot the links colors.}

\item{col}{color of the links.}

\item{colNA}{no data color.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.var.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{legend.var.title.txt}{title of the legend (numeric data).}

\item{legend.var.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{legend.var2.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{legend.var2.title.txt}{title of the legend (factor data).}

\item{legend.var2.values.order}{values order in the legend, a character vector 
that matches var modalities. Colors will be affected following this order.}

\item{legend.var2.nodata}{text for "no data" values}

\item{legend.var2.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a layer of colored and graduated links. 
Links are plotted according to discrete classes of widths. 
Colors depend on a discrete variable of categories.
}
\note{
Unlike most of cartography functions, identifiers variables are mandatory.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
mob <- read.csv(system.file("csv/mob.csv", package="cartography"))
# Create a link layer - work mobilities to Fort-de-France (97209) and 
# Le Lamentin (97213)
mob.sf <- getLinkLayer(x = mtq, df = mob[mob$j \%in\% c(97209, 97213),], 
                       dfid = c("i", "j"))
# Plot the links - Work mobility
plot(st_geometry(mtq), col = "grey60",border = "grey20")
gradLinkTypoLayer(x = mob.sf, df = mob,
                  var = "fij", 
                  breaks = c(109,500,1000,2000,4679), 
                  lwd = c(1,2,4,10),
                  var2='j', add = TRUE)
}
\seealso{
\link{getLinkLayer}, \link{propLinkLayer}, \link{legendGradLines}, \link{gradLinkLayer}
}
