% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrtrials.R
\name{rrtrials}
\alias{rrtrials}
\title{\code{rrtrials} produces \code{t-x} trajectories for lead and following vehicles on a ring road}
\usage{
rrtrials(umn, usd, k0, N, T, leff, nveh, xlim, ylim)
}
\arguments{
\item{umn}{lead vehicle speed (mph), a number}

\item{usd}{standard deviation of lead vehicle speed (mph), a number}

\item{k0}{traffic density (vehicles per mile, vpm), a number}

\item{N}{number of time-steps, a number}

\item{T}{upper time range (seconds), a number}

\item{leff}{effective vehicle length (feet), a number}

\item{nveh}{number of following vehicles, a number}

\item{xlim}{plot range along the \code{t} axis, a vector}

\item{ylim}{plot range along the \code{x} axis, a vector}
}
\value{
The \code{rrtrials} function returns \code{t-x} trajectories.
for the lead and following vehicles on a single-lane road. This is a strict car-following
model. Crossing trajectories are disallowed. In addition,
a following vehicle driver maintains a safe headway while attempting to minimize
travel time. In other words, the following vehicle's movement is constrained. Output
from The \code{rrtrials} is an output matrix called \code{LF}.
}
\description{
\code{rrtrials} produces \code{t-x} trajectories for lead and following vehicles on a ring road
}
\examples{
rrtrials(41, 11, 50, 120, 120, 14, 9,   c(0, 120), c(-1000, 7500))
rrtrials(2,  2, 55, 60, 60, 14,    9,   c(0, 60), c(-2000, 600))
rrtrials(18.8, 3.8, 55, 120, 120, 14, 9, c(0, 120), c(-1000, 2000))
}
