% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_util.R
\name{conditionalDistMvnorm}
\alias{conditionalDistMvnorm}
\title{Calculate the conditional mean & variance of a random vector following a multivariate normal distribution}
\usage{
conditionalDistMvnorm(y, conditionalIndex, meanVec, varMat)
}
\arguments{
\item{y}{the vector of the known values to be conditioned on.}

\item{conditionalIndex}{the index to be conditioned on.}

\item{meanVec}{the mean vector the joint multivariate normal distribution.}

\item{varMat}{the variance-covariance matrix of the joint multivariate normal distribution.}
}
\value{
a list consisting of 'mean' and 'var' representing the conditional mean and variance respectively.
}
\description{
Calculate the conditional mean & variance of a sub-vector
of a random vector given the rest elements, where the random vector follows a multivariate normal distribution.
This function calculates the conditional mean & variance of a multivariate normal distribution,
with (\code{meanVec}, \code{varMat}), conditional on y at the indices \code{conditionalIndex}.
}
\keyword{internal}

