% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_residuals.R
\name{residuals.carx}
\alias{residuals.carx}
\title{Residuals of a fitted \code{carx} object}
\usage{
\method{residuals}{carx}(object, type = c("raw", "pearson"), seed = NULL,
  ...)
}
\arguments{
\item{object}{a fitted \code{carx} object.}

\item{type}{a string indicates which type of residual is to be returned.
"raw" returns the (simulated) residuals;
"pearson" returns the raw residuals divided by estimated standard error of the residuals.}

\item{seed}{the seed for the random number generator.}

\item{...}{not used.}
}
\value{
the simulated residuals.
}
\description{
Computes the residuals of fitted \code{carx} object.
When no censoring is present, the ordinary residuals will be computed.
Otherwise, the simulated residuals (Gourieroux, Monfort, Renault, and Trognon 1987) of a
fitted \code{carx} object will be computed, as suggested in Wang and Chan (2017).
}
\details{
The simulated residuals are constructed as follows.
First, impute each unobserved  \eqn{Y_t^*} by a (random) realization from the conditional distribution
\eqn{D(Y_t^*|\{(Y_s,X_s)\}_{s=1}^t)}, evaluated at the parameter estimate.
Then, refit the model with \eqn{(Y_t^* , X_t)} so obtained, via the method of conditional maximum likelihood;
the residuals from the latter model are the simulated residuals \eqn{\varepsilon_t}.
}
\examples{
dat = carxSim(nObs=100,seed=0)
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
#compute the raw residuals
res = residuals(mdl,type="raw")
#compute the Pearson residuals
res = residuals(mdl,type="pearson")
}
\references{
Gourieroux C, Monfort A, Renault E, Trognon A (1987). "Simulated residuals."
Journal of Econometrics, 34(1), 201-252.

Wang C, Chan KS (2017). "Quasi-likelihood estimation of a censored autoregressive model with exogenous variables."  Journal of the American Statistical Association. 2017 Mar 20(just-accepted).
}
