% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height.R
\name{height}
\alias{height}
\title{Height}
\usage{
height(x, size, min = NULL, max = NULL)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{size}{One of \code{25}, \code{50}, \code{75}, \code{100}, \code{"auto"}, or \code{"viewport"} specifying the height of
the tag element.

If \code{25}, \code{50}, \code{75}, or \code{100}, the element's height is a percentage of the
height of the parent element must also be specified.

These percentages do not account for margins or padding and may cause an
element to extend beyond its parent element.

If \code{"auto"}, the element's height is determined by the browser.  The
browser will take into account the height, padding, margins, and border of
the tag element's parent to keep the element from extending beyond its
parent.

If \code{"viewport"}, the element's height is determined by the size of the
browser window.}

\item{min}{One of \code{25}, \code{50}, \code{75}, \code{100}, or \code{"viewport"} specifying the minimum
height of the tag element.

See \code{size} for details.}

\item{max}{One of \code{25}, \code{50}, \code{75}, \code{100}, or \code{"viewport"} specifying the maximum
height of the tag element.

See \code{size} for details.}
}
\description{
The \code{height()} function adjusts a tag element's height. Heights are specified
relative the height of a parent element, an element's content, or the size of
the browser window.
}
\examples{

library(htmltools)

div(
  .style \%>\%
     height("auto", max = "viewport") \%>\%
     overflow("auto"),
  "Vivamus id enim.",
  "Nunc rutrum turpis sed pede.",
  "Nunc aliquet, augue nec adipiscing interdum, ",
  "lacus tellus malesuada massa, quis varius mi purus non odio."
)

}
