% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtgeom}
\alias{dtgeom}
\alias{ptgeom}
\alias{qtgeom}
\alias{rtgeom}
\title{Density function of Truncated Geometric Distribution}
\usage{
dtgeom(x, prob, min = 0, max = 1e+09)

ptgeom(q, prob, min = 0, max = 1e+09)

qtgeom(p, prob, min = 0, max = 1e+09)

rtgeom(n, prob, min = 0, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{prob}{Distribution parameter}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Geometric Distribution

Cumulative probability function of Truncated Geometric Distribution

Quantile function of Truncated Geometric Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Geometric Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtgeom(3,0.3)
ptgeom(3,0.3)
qtgeom(0.7,0.3)
rtgeom(100,0.3)
}
