% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat.R
\name{cat_apply_freq}
\alias{cat_apply_freq}
\title{Applying frequencies to the object returned by get_mappings function}
\usage{
cat_apply_freq(to_x, freqs)
}
\arguments{
\item{to_x}{list object returned by get_mappings.}

\item{freqs}{vector object returned by get_freqs.}
}
\value{
a list with 2 named lists `to_old` and `to_new`.
}
\description{
applying frequencies to the object returned by get_mappings.
We will get a symmetric object to returned one by get_mappings function, nevertheless categories are replaced with frequencies.
Frequencies for each category/key are sum to 1, so could be interpreted as probabilities.
}
\examples{
data(trans)
data(occup)

mappings <- get_mappings(trans)

mappings$to_old[1:4]
mappings$to_new[1:4]

mapp_p <- cat_apply_freq(
  mappings$to_old,
  get_freqs(
    occup$code[occup$year == "2008"],
    occup$multiplier[occup$year == "2008"]
  )
)
head(data.frame(I(mappings$to_old), I(mapp_p)))
mapp_p <- cat_apply_freq(
  mappings$to_new,
  get_freqs(
    occup$code[occup$year == "2010"],
    occup$multiplier[occup$year == "2010"]
  )
)
head(data.frame(I(mappings$to_new), I(mapp_p)))
}
