% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{likelihood}
\alias{likelihood}
\title{Likelihood of the Specified Response Set}
\usage{
likelihood(catObj, theta)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{theta}{A numeric or an integer indicating the value for \eqn{\theta}}
}
\value{
The function \code{likelihood} returns a numeric value of the likelihood of the respondent having offered the provided response profile.
}
\description{
Calculates the likelihood of a respondent, with ability parameter \eqn{\theta}, having offered the specific set of responses stored in the \code{Cat} objects \code{answers} slot. All calculations are conditional on the item-level parameters stored in the \code{Cat} object.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
## Likelihood for Cat object of the ltm model
data(ltm_cat)
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))
likelihood(ltm_cat, theta = 1)

## Loading grm Cat object
## Likelihood for Cat object of the grm model
data(grm_cat)
setAnswers(grm_cat) <- c(1,1,5,2,5, rep(NA, 13))
likelihood(grm_cat, theta = 1)



}
\references{
Baker, Frank B. and Seock-Ho Kim. 2004. Item Response Theory: Parameter Estimation Techniques. New York: Marcel Dekker.

Choi, Seung W. and Richard J. Swartz. 2009. ``Comparison of CAT Item Selection Criteria for Polytomous Items." Applied Psychological Measurement 33(6):419-440.

Muraki, Eiji. 1992. ``A generalized partial credit model: Application of an EM algorithm." ETS Research Report Series 1992(1):1-30.

van der Linden, Wim J. 1998. ``Bayesian Item Selection Criteria for Adaptive Testing." Psychometrika 63(2):201-216.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{probability}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
