% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{likelihoodKL}
\alias{likelihoodKL}
\title{Expected Kullback-Leibler Information, Weighted by Likelihood}
\usage{
likelihoodKL(catObj, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{item}{An integer indicating the index of the question item}
}
\value{
The function \code{likelihoodKL} returns a numeric indicating the
expected Kullback-Leibler information weighted by the likelihood
 for the specified item, given the current answer profile and ability parameter estimate.
}
\description{
Calculates the expected Kullback-Leibler information, weighted by likelihood, for a specified item.
}
\details{
The function \code{likelihoodKL} calculates the expected Kullback-Leibler information 
for question \code{item}, where the proposed values of the true ability parameter are weighted by
the current likelihood.


This function involves integration.  See \strong{Note} for more information.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses adaptive quadrature methods from the GNU Scientific
 Library (GSL) to approximate single-dimensional
 integrals with high accuracy.  The bounds of integration are determined by the
 \code{lowerBound} and \code{upperBound} slots of the \code{Cat} object.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Estimate EPV for different unasked items
likelihoodKL(ltm_cat, item = 10)
likelihoodKL(ltm_cat, item = 20)
likelihoodKL(ltm_cat, item = 30)


}
\seealso{
\code{\link{expectedKL}}, \code{\link{posteriorKL}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
