% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{collect_conditions}
\alias{collect_conditions}
\alias{col_cond}
\title{Collect conditions, without halting processes}
\usage{
collect_conditions(expr, catchErrors = TRUE, asStrings = FALSE,
  dropMiscIfEmpty = TRUE)

col_cond(expr, catchErrors = TRUE, asStrings = FALSE,
  dropMiscIfEmpty = TRUE)
}
\arguments{
\item{expr}{The expression to be evaluated.}

\item{catchErrors}{A logical which, if TRUE, will catch any error, prevent it from being raised, and return it in the named list. The process will still halt when an error occurs however.}

\item{asStrings}{A logical which, if TRUE, will convert the captured conditions into strings of their messages, instead of keeping them as S3 condition objects.}

\item{dropMiscIfEmpty}{A logical which, if TRUE, will drop the "conditions" sublist from the returned list if there were no miscellaneous conditions signalled (ie 99\% of the time).}
}
\value{
A named list with the following structure: \cr
\itemize{
\item \code{value}: The output of the expression, if it did not encounter an error.
\item \code{warnings}: A list of the warnings raised in evaluating the expression.
\item \code{messages}: A list of the warnings raised in evaluating the expression.
\item \code{errors}: A list of errors raised in evaluating the expression. If \code{catchErrors==FALSE}, then this will not be returned.
\item \code{conditions}: A list of miscellaneous conditions (defined as conditions that do not inherit from warnings, errors, or messages) raised in evaluating the expression. If \code{dropMiscIfEmpty==TRUE}, this sublist will not be included unless these rare conditions are signalled.
}
}
\description{
\code{collect_conditions} (and its shorter alias, \code{col_cond}) evaluates an expression, and will catch and collect all the conditions
specified (e.g., warnings, errors, messages, etc.), without halting/restarting
the evaluation of the expression (unless it encounters an error).
It will then return a named list with the result of the expression and sublists
that contain all the collected conditions (see \strong{Value}).
}
\details{
The way this function suppresses conditions is simply by attempting to find the
first available \code{\link{restartDescription}} with "muffle" in its name
and invoke that. This works well for most warnings and messages, which are
muffled by default with "muffleWarning" and "muffleMessage". Barring any
restarts with this property, it will simply return \code{NULL} as a restart (i.e.,
most likely the case for custom miscellaneous conditions). If you have some
really funky conditions being signalled that somehow 1) don't have
"muffle<Condition>" as a restart or 2) have a custom restart with "muffle"
in the name that takes precedence, this might lead to unexpected results,
and you probably shouldn't use this function. \cr \cr
For a more descriptive account of the object returned, see \strong{Value}. If no warnings or message are raised in the expression, their named sublists will still be present, but empty. \cr \cr
Additionally, if the expression encounters an error, the value of the "value" sublist will be returned as \code{NULL}.
}
\examples{
res <- collect_conditions({
  warning("warning 1")
  message("message 1")
  warning("warning 2")
  signal_custom_condition("Custom condition #1!")
  signal_custom_condition("Custom condition #2!")
  stop("error 1")
  message("message 2 (not signalled)")
  "test value"
},
asStrings = FALSE, catchErrors = TRUE, dropMiscIfEmpty = TRUE)
print(res)

# Without the `dropMiscIfEmpty=TRUE` and no miscellaneous conditions being raised,
#   there won't be any `res$conditions`
res <- collect_conditions({
  warning("warning 1")
  message("message 1")
  warning("warning 2")
  stop("error 1")
  message("message 2 (not signalled)")
  "test value"
},
asStrings = TRUE, catchErrors = TRUE, dropMiscIfEmpty = FALSE)
print(res)
}
