% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{black_politicians}
\alias{black_politicians}
\title{Data from "Black Politicians are More Intrinsically Motivated to Advance Blacks' Interests"}
\format{
A data frame with 5593 rows and 14 variables
\describe{
  \item{leg_black}{Legislator receiving email is Black}
  \item{treat_out}{Email is from out-of-district}
  \item{responded}{Legislator responded to email}
  \item{totalpop}{District population}
  \item{medianhhincom}{District median household income}
  \item{black_medianhh}{District median household income among Black people}
  \item{white_medianhh}{District median household income among White people}
  \item{blackpercent}{Percentage of district that is Black}
  \item{statessquireindex}{State's Squire index}
  \item{nonblacknonwhite}{Legislator receiving email is neither Black nor White}
  \item{urbanpercent}{Percentage of district that is urban}
  \item{leg_senator}{Legislator receiving email is a senator}
  \item{leg_democrat}{Legislator receiving email is in the Democratic party}
  \item{south}{Legislator receiving email is in the Southern United States}
}
}
\source{
Broockman, D.E., 2013. Black politicians are more intrinsically motivated to advance blacks’ interests: A field experiment manipulating political incentives. \emph{American Journal of Political Science}, 57(3), pp.521-536.
}
\usage{
black_politicians
}
\description{
The \code{black_politicians} data contains data from Broockman (2013) on a field experiment where the author sent fictional emails purportedly sent by Black people to legislators in the United States. The experiment sought to determine whether the effect of the email being from "out-of-district" (someone who can't vote for you and so provides no extrinsic motivation to reply) would have a smaller effect on response rates for Black legislators than for non-Black ones, providing evidence of additional intrinsic motivation on the part of Black legislators to help Black people.
}
\details{
This data is used in the \emph{Matching} chapter of \emph{The Effect}.
}
\references{
Huntington-Klein. 2021. The Effect: An Introduction to Research Design and Causality. \url{https://theeffectbook.net}.
}
\keyword{datasets}
