% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-parsing.R
\name{parse_effect}
\alias{parse_effect}
\title{Parse text that defines a causal effect}
\usage{
parse_effect(text)
}
\arguments{
\item{text}{Character string}
}
\value{
A nested list that contains the following components:
\describe{
       \item{vars}{For each element of the causal query, this 
       indicates potential outcomes as names of the list elements, 
       the variables that they depend on, and the values that any variables are being fixed to.}
       \item{oper}{The vector of operators (addition or subtraction) that combine the terms of the causal query.}
       \item{values}{The values that the potential outcomes are set to in the query.}
       \item{pcheck}{List of logicals for each element of the query that are TRUE if the element 
       is a potential outcome and FALSE if it is an observational quantity.}
       }
}
\description{
Parse text that defines a causal effect
}
\examples{
effectt <- "p{Y(X = 1) = 1} - p{Y(X = 0) = 1}"
parse_effect(text = effectt)
}
