% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{cbc_overlap}
\alias{cbc_overlap}
\title{Counts of attribute overlap}
\usage{
cbc_overlap(design)
}
\arguments{
\item{design}{A data frame of a survey design.}
}
\value{
Prints the counts of the number of choice questions that contain
the unique number of levels for each attribute.
}
\description{
This function prints out a summary of the amount of "overlap" across
attributes within the choice questions. For example, for each attribute, the
count under \code{"1"} is the number of choice questions in which the same level
was shown across all alternatives for that attribute (because there was only
one level shown). Likewise, the count under \code{"2"} is the number of choice
questions in which only two unique levels of that attribute were shown, and
so on.
}
\examples{
library(cbcTools)

# A simple conjoint experiment about apples

# Generate all possible profiles
profiles <- cbc_profiles(
  price     = c(1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5),
  freshness = c("Excellent", "Average", "Poor"),
  type      = c("Fuji", "Gala", "Honeycrisp")
)

# Make a randomized survey design
design <- cbc_design(
  profiles = profiles,
  n_resp   = 300, # Number of respondents
  n_alts   = 3, # Number of alternatives per question
  n_q      = 6 # Number of questions per respondent
)

# Inspect the design balance
cbc_balance(design)

# Inspect the design overlap
cbc_overlap(design)
}
