% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-meta.R
\name{get_meta-deprecated}
\alias{get_meta-deprecated}
\alias{get_meta}
\title{Get meta data from table}
\usage{
get_meta(
  id,
  verbose = TRUE,
  cache = FALSE,
  base_url = getOption("cbsodataR.base_url", BASE_URL)
)
}
\arguments{
\item{id}{internal id of CBS table, can be retrieved with \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}}

\item{verbose}{Print extra messages what is happening.}

\item{cache}{should the result be cached?}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}
}
\value{
cbs_table object containing several \code{data.frames} with meta data
(see details)
}
\description{
This method is deprecated in favor of \code{\link[=cbs_get_meta]{cbs_get_meta()}}
}
\details{
The meta data of a CBS table is determined by the web api of Statistics
Netherlands. \code{cbsodataR} stays close to this API.
Each cbsodataR object has the following metadata items,
which are all \code{data.frame}s :
\itemize{
\item \verb{$TableInfos}: data.frame with the descriptive publication metadata
of the table, such as \code{Title}, \code{Description}, \code{Summary} etc.
\item \verb{$DataProperties}: data.frame with the \code{Title}, \code{Description},
\code{Unit} etc. of each column in the dataset that is downloaded with
\code{\link[=cbs_get_data]{cbs_get_data()}}.
\item \verb{$CategoryGroups}: hierarchical groupings of the code columns.
\item \verb{$<code column>}: for each code column a \code{data.frame} with
the \code{Title}, \code{Key}, \code{Description} etc. of each code / category
in that column. e.g. \code{Perioden} for time codes \code{c("2019JJ00","2018JJ00")}.
}
}
\seealso{
Other meta data: 
\code{\link{cbs_add_date_column}()},
\code{\link{cbs_add_label_columns}()},
\code{\link{cbs_download_meta}()}
}
