% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc_est.R
\name{ccc_est}
\alias{ccc_est}
\title{Concordance correlation Coefficient estimation from a linear mixed model}
\usage{
ccc_est(model, D = NULL, cl = 0.95, transf = "F2", sd_est = TRUE, ...)
}
\arguments{
\item{model}{The lme model.}

\item{D}{Weights vector.}

\item{cl}{Confidence level (0.95 as a default). Bounded between 0 and 1.}

\item{transf}{Character string. Whether to apply a transformation of the coefficient for inference. Valid options are: "F" for Fisher's Z-transformation; "F2" For Fisher's Z-transformation setting m=2 (default); "KG" Konishi-Gupta transformation; "None", no transformation is applied. See *Details* for further information.}

\item{sd_est}{Logical. Whether to estimate the asymptotic standard deviation (defaults to TRUE) or to only report the \code{ccc} value.}

\item{...}{To pass further arguments.}
}
\value{
A \code{ccc} class object.
}
\description{
It computes the Concordance Correlation Coefficient and its asymptotic confidence interval.
}
\examples{
set.seed(1984)
df <- ccc_sim_data(n=50,b = c(0,1), mu = -0.25, sa = 1.5, se = 1, nrep=2)
mod <- lme_model(df,"y","id",rmet="met")
ccc_est(mod)
}
\seealso{
\code{\link{ccc_vc}}
}
\keyword{internal}
