% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_details_batch}
\alias{get_chemical_details_batch}
\title{Retrieve chemical details from DTXSID of DTXCID in batch search}
\usage{
get_chemical_details_batch(
  DTXSID = NULL,
  DTXCID = NULL,
  Projection = "chemicaldetailstandard",
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{DTXCID}{The chemical identifier DTXCID}

\item{Projection}{The format and chemical detail data returned. Allowed
values are 'chemicaldetailall', 'chemicaldetailstandard',
chemicalidentifier', 'chemicalstructure'. If left empty or there is a
mismatch, the default format will be 'chemicaldetailstandard'.}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.table (DTXSID) or a named list of data.tables (DTXCID)
containing chemical information for the chemicals with DTXSID or DTXCID
matching the input parameter.
}
\description{
Retrieve chemical details from DTXSID of DTXCID in batch search
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical details for multiple chemicals by dtxsid
dtxsids <- c('DTXSID7020182', 'DTXSID2021315')
dtxsid_details <- get_chemical_details_batch(DTXSID = dtxsid)
# Pull chemical details for multiple chemicals by dtxcid
dtxcids <- c('DTXCID30182', 'DTXCID001315')
dtxcid_details <- get_chemical_details_batch(DTXCID = dtxcids)
\dontshow{\}) # examplesIf}
}
