% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrBoot.R
\name{qrBoot}
\alias{qrBoot}
\title{Bootstrapping for cdf quantile regression}
\usage{
qrBoot(object, rn, f = coef, R = 500, ci = 0.95)
}
\arguments{
\item{object}{The fitted cdfqr model object}

\item{rn}{The sample size of bootstrap samples}

\item{f}{A function whose one argument is the name of a cdfqr object that will be applied to the updated cdfqr object to compute the statistics of interest. The default is coef.}

\item{R}{Number of bootstrap samples.}

\item{ci}{The confidence interval level to obtain the boostrap confidence intervals}
}
\value{
A matrix that includes the original statistics, boostrap means, and boostrap confidence intervals
}
\description{
\code{qrBoot} provides a simple bootstrapping method for estimating the parameters of a cdf quantile regression model.
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2', 't2', data = JurorData)
qrBoot(fit, rn = 50, R = 50)

}

