% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wg2ws_get_cat_function.R
\name{wg2ws_get_cat_function}
\alias{wg2ws_get_cat_function}
\title{Get function for category/age combination}
\usage{
wg2ws_get_cat_function(the_category, age = TRUE, echo_only = FALSE)
}
\arguments{
\item{the_category}{Which category to use, following Wordbank naming
convention.
Options: sounds, animals, vehicles, toys, food_drink, clothing, body_parts,
household, furniture_rooms, outside, places, people,
games_routines, action_words, descriptive_words, time_words,
pronouns, question_words, locations, quantifiers, helping_verbs,
connecting_words}

\item{age}{T/F. If TRUE, return model that uses age as predictor.}

\item{echo_only}{T/F. If FALSE, returns model as function; if TRUE echoes
as human readable.}
}
\value{
Function or NULL
}
\description{
Returns a model object to predict category score given category and age.
}
\details{
This is mostly an internal function, but is exposed in case somebody needs
it. Returns a \code{lm()} object that has had the embedded data stripped, given
a category and whether to model age.
}
\examples{
wg2ws_get_cat_function("time_words", age = TRUE)
}
