% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcovmat.R
\name{rcovmat}
\alias{rcovmat}
\title{Construct a Structured Covariance Matrix for Simulations}
\usage{
rcovmat(eigs = k:1, m = 10, k = 2, perc = list(c(0.4, 0.2, 0.4), c(0.2,
  0.4, 0.4)), limits = list(l1 = c(0.5, 1), l2 = c(-1, -0.5), l3 = c(-0.1,
  0.1)), random = TRUE)
}
\arguments{
\item{eigs}{Vector of $k$ eigenvalues.}

\item{m}{Integer; the number of rows and columns of the matrix.}

\item{k}{Integer; the rank of the matrix.}

\item{perc}{List of $k$ vectors giving the sampling proportions for the
uniform sampling of the eigenvectors, for each dimension.}

\item{limits}{List of length 2 vectors, one for each uniform sample, giving
the lower and upper bounds of the uniform distribution.}

\item{random}{Logical; randomize the order of the loading per dimension or
not.}
}
\description{
Construct a low-rank covariance matrix with specified eigenvalues, where the
eigenvectors are simulated from uniform distributions.
}

