% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoid.R
\name{breakdown_geoid}
\alias{breakdown_geoid}
\title{Breakdown Census GEOID into Components}
\usage{
breakdown_geoid(.data, GEOID = "GEOID", area_type = "spine")
}
\arguments{
\item{.data}{dataframe, tibble, or sf tibble}

\item{GEOID}{Column in .data with Census GEOID}

\item{area_type}{String, default is 'spine' with type of GEOID. Options are
'spine' for states, counties, tracts, block groups, and blocks. 'shd' for lower
state legislative districts, 'ssd' for upper state legislative districts, 'cd'
for congressional districts, or 'zcta' for zip code tabulation areas.}
}
\value{
.data with added identifying columns based on area_type
}
\description{
Breakdown Census GEOID into Components
}
\examples{
data(mt_county)
mt_county <- mt_county \%>\% breakdown_geoid()
}
\concept{geoid}
