% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_reg-survival.R
\name{survival_prob_survreg}
\alias{survival_prob_survreg}
\alias{hazard_survreg}
\title{Internal function helps for parametric survival models}
\usage{
survival_prob_survreg(object, new_data, eval_time, time = deprecated())

hazard_survreg(object, new_data, eval_time)
}
\arguments{
\item{object}{A \code{survreg} object.}

\item{new_data}{A data frame.}

\item{eval_time}{A vector of time points.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of time points.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
Internal function helps for parametric survival models
}
\examples{
surv_reg <- survreg(Surv(time, status) ~ ., data = lung)
survival_prob_survreg(surv_reg, lung[1:3, ], eval_time = 100)
hazard_survreg(surv_reg, lung[1:3, ], eval_time = 100)
}
\keyword{internal}
