% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_betting.R
\name{cfbd_betting_lines}
\alias{cfbd_betting_lines}
\title{\strong{CFBD Betting Lines Endpoint Overview}}
\usage{
cfbd_betting_lines(
  game_id = NULL,
  year = NULL,
  week = NULL,
  season_type = "regular",
  team = NULL,
  home_team = NULL,
  away_team = NULL,
  conference = NULL,
  line_provider = NULL
)
}
\arguments{
\item{game_id}{(\emph{Integer} optional): Game ID filter for querying a single game \cr
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}

\item{year}{(\emph{Integer} required): Year, 4 digit format(\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default regular): Select Season Type: regular or postseason}

\item{team}{(\emph{String} optional): D-I Team}

\item{home_team}{(\emph{String} optional): Home D-I Team}

\item{away_team}{(\emph{String} optional): Away D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference \cr
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC \cr
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC \cr}

\item{line_provider}{(\emph{String} optional): Select Line Provider - Caesars, consensus, numberfire, or teamrankings}
}
\value{
Betting information for games with the following columns:

\describe{
\item{game_id:integer.}{Unique game identifier - game_id.}
\item{season:integer.}{Season parameter.}
\item{season_type:character.)}{Season Type (regular, postseason, both}
\item{week:integer.}{Week, values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier).}
\item{start_date:character.}{Start Date}
\item{home_team:character.}{Home D-I Team.}
\item{home_conference:character.}{Home D-I Conference.}
\item{home_score:integer.}{Home Score.}
\item{away_team:character.}{Away D-I Team.}
\item{away_conference:character.}{Away D-I Conference.}
\item{away_score:integer.}{Away Score.}
\item{provider:character.}{Line provider.}
\item{spread:character.}{Spread for the game.}
\item{formatted_spread:character.}{Formatted spread for the game.}
\item{spread_open:character.}{Opening spread for the game.}
\item{over_under:character.}{Over/Under for the game.}
\item{over_under_open:character.}{Opening over/under for the game.}
\item{home_moneyline:character.}{Home team moneyline.}
\item{away_moneyline:character.}{Away team moneyline.}
}
}
\description{
\strong{Get betting lines information for games}
}
\examples{
\donttest{
   try(cfbd_betting_lines(year = 2018, week = 12, team = "Florida State"))
}
}
