% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleandexcomdata.R
\name{cleandexcomdata}
\alias{cleandexcomdata}
\title{Clean Dexcom CGM Data}
\usage{
cleandexcomdata(inputdirectory,
                outputdirectory = tempdir(),
                interval = 5,
                maxgap = 20,
                gapfill = TRUE)
}
\arguments{
\item{inputdirectory}{The directory containing raw Dexcom files to be
formatted.}

\item{outputdirectory}{The directory where you would like the cleaned Dexcom
files to be written.}

\item{interval}{The length of time between CGM sensor measurements. Defaults
to 5 minutes.}

\item{maxgap}{The maximum gap (in minutes) in sensor data that will be
interpolated. Defaults to 20 minutes.}

\item{gapfill}{Defaults to TRUE. If set to FALSE, gaps in sensor data will be
kept.}
}
\value{
one formatted CSV file per file contained in inputdirectory.
}
\description{
This function cleans exported Dexcom CGM data and gets it ready for analysis.
It removes the first 4 hours of sensor data, then searches for missing data
in the rest of the file. The default settings assume intervals of 5 minutes
and that gaps of 20 minutes or less can be filled in with linear
interpolation. The exported .csv file is written to a new directory called
"Cleaned CSVs."
}
\examples{
cleandexcomdata(system.file("extdata", "Dexcom_Tests",
                package = "cgmanalysis"))
}
