% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{set}
\alias{set}
\title{Change the Value of a Node in the Graph}
\usage{
set(name, value)
}
\arguments{
\item{name}{character scalar, name of the node that is changed.}

\item{value}{R object, new value of the node.}
}
\value{
nothing.
}
\description{
Change the value of node \code{name} in the active graph.
}
\note{
The cached value of all nodes that directly or indirectly dependend on node \code{name} is removed. The value of these nodes will be re-computed the next time \link[cgraph]{val} is called.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a parameter
a <- parm(20, name = "a")

# Change value of a
set(a, 40)

# Evaluate a
val(a)

}
\author{
Ron Triepels
}
