% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aooArea.R
\name{AOOarea}
\alias{AOOarea}
\title{Calculate AOO}
\usage{
AOOarea(r, locs = NULL)
}
\arguments{
\item{r}{Raster layer of a binary SDM. Must be either unprojected in the WGS84 datum, or projected in an equal area projection (see IUCN guidelines) measured in meters.
Unprojected rasters will result in an estimate while those projected in an equal area projection will be more accurate.
Raster values must be either NA indicating absence, or 1, indicating presence.}

\item{locs}{(optional) data.frame of occurrence records: Longitude and latitude. If provided, AOO of cells containing occurrence points
is returned. If NULL, AOO of SDM is returned. The projection should match that of r.}
}
\value{
a list of three objects. The first object is a character showing the AOO of cells with occurrence records.
The second is a raster object of the resampled AOO. The third object (optional) represents the AOO raster showing pixels in which the localities occur, resampled to 2kmx2km
 (only if locs argument is supplied).
}
\description{
Calculate area of occupancy measured in 2km resolution using a binary SDM
}
\examples{
# create raster
r1 <- raster::raster(nrows=5, ncols=5, xmn=-5, xmx=5, ymn=-5, ymx=5)
raster::values(r1)<- runif(n = (5*5))
r1[r1 < 0.5] <- NA
r1[!is.na(r1)] <- 1
# calculate aooArea
AOOarea(r = r1)
}
