% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textFileInput4ai.R
\name{textFileInput4ai}
\alias{textFileInput4ai}
\title{Send Text File Content to OpenAI API and Retrieve Response}
\usage{
textFileInput4ai(
  file_path,
  model = "gpt-4o-mini",
  system_prompt = "You are a helpful assistant to analyze your input.",
  max_tokens = 50,
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{file_path}{A string representing the path to the text or csv file to be read and sent to the API.}

\item{model}{A string specifying the OpenAI model to be used (default is "gpt-4o-mini").}

\item{system_prompt}{Optional. A system-level instruction that can be used to guide the model's behavior
(default is "You are a helpful assistant to analyze your input.").}

\item{max_tokens}{A numeric value specifying the maximum number of tokens to generate (default is 50).}

\item{api_key}{A string containing the OpenAI API key. Defaults to the "OPENAI_API_KEY" environment variable.}
}
\value{
A character string containing the response from the OpenAI API.
}
\description{
This function reads the content of a specified text file, sends it to the OpenAI API
using the provided API key, and retrieves the generated response from the GPT model.
}
\examples{
\dontrun{
  # Example usage of the function
  api_key <- "YOUR_OPENAI_API_KEY"
  file_path <- "path/to/your/text_file.txt"
  response <- textFileInput4ai(file_path, api_key = api_key, max_tokens = 50)
  cat(response)
}
}
\author{
Satoshi Kume
}
