% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.R
\name{check_unique}
\alias{check_unique}
\title{Check Unique}
\usage{
check_unique(x, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Check Unique
}
\examples{
check_unique(2, error = FALSE)
check_unique(c(2,2), error = FALSE)
check_unique(1:2, error = FALSE)
check_unique(character(0), error = FALSE)
check_unique(NULL, error = FALSE)
check_unique(list(), error = FALSE)
}
