% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.R
\name{check_chr}
\alias{check_chr}
\alias{check_string}
\title{Check String}
\usage{
check_chr(x, coerce = FALSE, x_name = substitute(x), error = TRUE)

check_string(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a factor scalar to a string and drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if object is a string (non-missing character scalar with no attributes including names).
}
\examples{
check_chr(1, error = FALSE)
check_chr("1", error = FALSE)
check_chr(c("1", "2"), error = FALSE)
}
\seealso{
\code{\link{check_scalar}}
}
